/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_AlignmentPlugin;
import stacgui.Stac_AlignmentPlugin_gonset;
import stacgui.Stac_Out;
import stacgui.StreamGobbler;
import stacgui.TextReader;

public class Stac_AlignmentPlugin_xo
extends Stac_AlignmentPlugin_gonset
implements Stac_AlignmentPlugin {
    public String CalculateAlignment(String workDir, Vector3d datum, Point3d trans, Vector orientations, StacBCM bcm, StacUtil utils) {
        Vector3d actDatum = new Vector3d();
        actDatum.set(datum.z, datum.y, datum.x);
        Vector3d[] okp = new Vector3d[7];
        bcm.getCalibration(okp);
        File fp = new File("STAC_align.vec");
        fp.delete();
        int i = 0;
        while (i < orientations.size()) {
            String command = "-D \"" + actDatum.x + "," + actDatum.y + "," + actDatum.z + "\"" + " -O \"" + okp[0].x + "," + okp[0].y + "," + okp[0].z + "\"" + " -K \"" + okp[1].x + "," + okp[1].y + "," + okp[1].z + "\"" + " -P \"" + okp[2].x + "," + okp[2].y + "," + okp[2].z + "\"" + " -V \"" + orientations.elementAt(i) + "\" -W \"" + orientations.elementAt(i + 1) + "\"" + " name0.x";
            this.CallExternalXO(workDir, command);
            this.AddSolutions(workDir, "xo.out", "STAC_align.vec", utils);
            i += 2;
        }
        String out = "STAC_filtered_align.vec";
        fp = new File(String.valueOf(workDir) + out);
        fp.delete();
        this.FilterCalculatedAlignments(workDir, datum, trans, out, utils, bcm);
        return out;
    }

    void AddSolutions(String workDir, String in, String out, StacUtil utils) {
        String[] sol;
        String inFile = utils.opReadCl(String.valueOf(workDir) + in);
        Vector<Vector> solutions = new Vector<Vector>();
        if (inFile != null && (sol = inFile.split("Independent Solutions for possible Datum positions:")) != null && sol.length == 2) {
            String[] dsetting = sol[0].split("\n");
            String desired = "";
            if (dsetting.length > 4) {
                desired = desired.concat(dsetting[dsetting.length - 4].substring(2, 26));
                desired = desired.concat(dsetting[dsetting.length - 3].substring(2, 26));
            }
            String[] solLines = sol[1].split("\n");
            int i = 1;
            while (i < solLines.length) {
                Vector par = utils.map("double", solLines[i].split("\\s+"));
                if (par.size() == 4) {
                    solutions.addElement(par);
                }
                ++i;
            }
            if (solutions.size() > 0) {
                try {
                    FileWriter alignFile = new FileWriter(String.valueOf(workDir) + out, true);
                    alignFile.write(String.valueOf(desired) + " " + solutions.size() + "\n");
                    int i2 = 0;
                    while (i2 < solutions.size()) {
                        alignFile.write(" " + ((Vector)solutions.elementAt(i2)).elementAt(1) + " " + ((Vector)solutions.elementAt(i2)).elementAt(2) + " " + ((Vector)solutions.elementAt(i2)).elementAt(3) + "\n");
                        ++i2;
                    }
                    alignFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                solutions.clear();
            }
        }
    }

    void CallExternalXO(String workDir, String command) {
        try {
            String osName = System.getProperty("os.name");
            String[] cmd = new String[3];
            String mycmd = new String("p:\\work\\dev\\STAC\\gonset\\argtest.exe sutike < argtest.log");
            if (osName.equals("Windows NT") || osName.equals("Windows XP")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else if (osName.equals("Windows 95")) {
                cmd[0] = "command.com";
                cmd[1] = "/C";
            } else {
                mycmd = "cd " + workDir + "; export PYTHONPATH=$STACDIR/thirdparty/XO/src/ ; python $STACDIR/thirdparty/XO/src/XOalign.py " + command;
                cmd[0] = "sh";
                cmd[1] = "-c";
            }
            cmd[2] = mycmd;
            Runtime rt = Runtime.getRuntime();
            Stac_Out.println("Executing " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            Process proc = rt.exec(cmd);
            int exitVal = 0;
            try {
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", "xo.out");
                errorGobbler.start();
                outputGobbler.start();
                exitVal = proc.waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Stac_Out.println("Process exitValue: " + exitVal);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void FilterCalculatedAlignments(String workDir, Vector3d currDatum, Point3d actualTrans, String out, StacUtil utils, StacBCM bcm) {
        try {
            String osName = System.getProperty("os.name");
            String myfile = new String(String.valueOf(workDir) + "STAC_align.vec");
            Stac_Out.println("File to be read: " + myfile);
            FileInputStream GonsetResultFile = new FileInputStream(myfile);
            TextReader grf = new TextReader(GonsetResultFile);
            grf.IOCheck(true);
            FileOutputStream alignFile = new FileOutputStream(String.valueOf(workDir) + out);
            DataOutputStream outFile = new DataOutputStream(alignFile);
            double actualKappa = 0.0;
            double actualPhi = 0.0;
            actualKappa = currDatum.y;
            actualPhi = currDatum.z;
            try {
                block4: while (true) {
                    double v1x = grf.getDouble();
                    double v1y = grf.getDouble();
                    double v1z = grf.getDouble();
                    double v2x = grf.getDouble();
                    double v2y = grf.getDouble();
                    double v2z = grf.getDouble();
                    int numAlignVecs = grf.getInt();
                    while (true) {
                        if (numAlignVecs <= 0) continue block4;
                        double omega = utils.angleInRange(grf.getDouble(), 0.0);
                        double kappa = utils.angleInRange(grf.getDouble(), -5.0);
                        double phi = utils.angleInRange(grf.getDouble(), 0.0);
                        Point3d trans = utils.CalculateTranslation(actualTrans, actualKappa, kappa, actualPhi, phi, bcm);
                        utils.change_denzo_matrices_by_gonset(bcm, String.valueOf(workDir) + "name0.x", omega, currDatum.x, kappa, currDatum.y, phi, currDatum.z, String.valueOf(workDir) + "alignmentOM.x");
                        ParamTable newOrient = new ParamTable();
                        utils.read_denzo_x(String.valueOf(workDir) + "alignmentOM.x", newOrient);
                        double[] cell = new double[6];
                        double[] tcell = new double[6];
                        Matrix3d B = new Matrix3d();
                        Matrix3d Bm1t = new Matrix3d();
                        Matrix3d U = new Matrix3d();
                        Vector3d phixyz = new Vector3d();
                        Matrix3d osc = new Matrix3d();
                        Matrix3d OMU = new Matrix3d(newOrient.getDoubleVector("Amat"));
                        Matrix3d OMA = new Matrix3d(newOrient.getDoubleVector("Umat"));
                        Matrix3d OMAi = new Matrix3d(OMA);
                        OMAi.invert();
                        Matrix3d OMUB = new Matrix3d(OMA);
                        utils.denzo2mosflm_matrices_by_gonset(OMU, cell, tcell, B, Bm1t, U, OMUB, phixyz);
                        double rank = utils.AlignmentRanking(trans, omega, kappa, phi, bcm, OMUB);
                        if (!(rank < 0.0)) {
                            outFile.writeDouble(v1x);
                            outFile.writeDouble(v1y);
                            outFile.writeDouble(v1z);
                            outFile.writeDouble(v2x);
                            outFile.writeDouble(v2y);
                            outFile.writeDouble(v2z);
                            outFile.writeDouble(omega);
                            outFile.writeDouble(kappa);
                            outFile.writeDouble(phi);
                            outFile.writeUTF(new PrintfFormat("(%.4f;%.4f;%.4f)").sprintf(new Double[]{new Double(trans.x), new Double(trans.y), new Double(trans.z)}));
                            outFile.writeDouble(rank);
                        }
                        --numAlignVecs;
                    }
                    break;
                }
            }
            catch (Exception grfex) {
                grf.close();
                GonsetResultFile.close();
                outFile.close();
                alignFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getCreditString() {
        return "using XO";
    }
}

