/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacBCM;
import stacgui.Stac_Out;
import stacgui.StreamGobbler;
import stacgui.TextReader;

public class StacUtil {
    ParamTable detector_denzo2strategyTable = new ParamTable(new String[][]{{"ccd unsupported-mar", "MAR130"}, {"ccd unsupported-m165", "MAR165"}, {"ccd unsupported-m225", "MAR225"}, {"mar345 345mm", "MAR345"}, {"mar 18cm", "MARSMALL"}, {"mar 30cm", "MARBIG"}, {"ccd adsc unsupported-q4", "ADSCQ4"}, {"ccd adsc unsupported-q210", "ADSCQ210"}, {"ccd adsc unsupported-q315", "ADSCQ315"}, {"ccd adsc", "ADSCQ2x2"}, {"raxis", "RAXIS"}, {"raxis2n", "RAXV"}, {"raxis2n", "RAXISVER"}, {"raxis4 100", "RAXISIV"}, {"raxis5 100", "RAXISV"}, {"ccd unsupported-b4", "BRAND2x2"}, {"ccd brandeis", "CCDB"}, {"ccd esrf 1024", "ESRF"}, {"fuji 10bit", "FUJI"}, {"unsuported", "CRYSTALIS"}, {"unsuported", "STARUN"}, {"unsuported", "VIDEMETRIX"}, {"unsuported", "SIEMENS"}, {"stoe", "STOE"}, {"dip 2020", "DIP2000"}});

    public void Rotation(Matrix M, int i, int j, double angle) {
        int row = 0;
        while (row < 3) {
            int col = 0;
            while (col < 3) {
                if (row != col) {
                    M.set(row, col, 0.0);
                } else {
                    M.set(row, col, 1.0);
                }
                ++col;
            }
            ++row;
        }
        M.set(i, i, Math.cos(angle));
        M.set(j, j, Math.cos(angle));
        M.set(i, j, Math.sin(angle));
        M.set(j, i, -Math.sin(angle));
    }

    public String detector_xds2denzo(String det_type, double detector_diameter) {
        String strategy_type = this.detector2strategy(det_type, detector_diameter);
        try {
            return (String)this.detector_denzo2strategyTable.getNameForParam(strategy_type);
        }
        catch (Exception e) {
            return "NC";
        }
    }

    public String detector2strategy(String det_type_in, double detector_diameter) {
        String det_type = new String(det_type_in).toUpperCase();
        double diameter_tolerance = detector_diameter * 0.04;
        if ((det_type.equals("CCDCHESS") || det_type.equals("MARC")) && Math.abs(detector_diameter - 165.0) < diameter_tolerance) {
            return "MAR165";
        }
        if ((det_type.equals("CCDCHESS") || det_type.equals("MARC")) && Math.abs(detector_diameter - 133.0) < diameter_tolerance) {
            return "MAR130";
        }
        if ((det_type.equals("CCDCHESS") || det_type.equals("MARC")) && Math.abs(detector_diameter - 225.0) < diameter_tolerance) {
            return "MAR225";
        }
        if ((det_type.equals("MAR345") || det_type.equals("MARC")) && Math.abs(detector_diameter - 345.0) < diameter_tolerance) {
            return "MAR345";
        }
        if (det_type.equals("MAR") && Math.abs(detector_diameter - 180.0) < diameter_tolerance) {
            return "MARSMALL";
        }
        if (det_type.equals("MAR") && Math.abs(detector_diameter - 300.0) < diameter_tolerance) {
            return "MARBIG";
        }
        if (det_type.equals("MAR") && Math.abs(detector_diameter - 200.0) < diameter_tolerance) {
            return "BRAND2x2";
        }
        if (det_type.equals("ADSC") && Math.abs(detector_diameter - 188.0) < diameter_tolerance) {
            return "ADSCQ4";
        }
        if (det_type.equals("ADSC") && Math.abs(detector_diameter - 210.0) < diameter_tolerance) {
            return "ADSCQ210";
        }
        if (det_type.equals("ADSC") && Math.abs(detector_diameter - 315.0) < diameter_tolerance) {
            return "ADSCSTAC_CCQ315";
        }
        if (det_type.equals("CCDBRANDEIS") && Math.abs(detector_diameter - 200.0) < diameter_tolerance) {
            return "BRAND2X2";
        }
        if (det_type.equals("CCDBRANDEIS") && Math.abs(detector_diameter - 95.0) < diameter_tolerance) {
            return "CCDB";
        }
        if (det_type.equals("RAXIS")) {
            return "RAXIS";
        }
        if (det_type.equals("RAXIS")) {
            return "RAXISVER";
        }
        if (det_type.equals("RAXIS")) {
            return "RAXISIV";
        }
        if (det_type.equals("RAXIS")) {
            return "RAXISV";
        }
        if (det_type.equals("FUJI")) {
            return "FUJI";
        }
        if (det_type.equals("SMARTCCD") || det_type.equals("CCD2AM")) {
            return "ESRF";
        }
        if (det_type.equals("MAC")) {
            return "DIP2000";
        }
        if (det_type.equals("CRYSTALIS")) {
            return "CRYSTALIS";
        }
        if (det_type.equals("SATURN")) {
            return "SATURN";
        }
        if (det_type.equals("VIDEMETRIX")) {
            return "VIDEMETRIX";
        }
        if (det_type.equals("SIEMENS")) {
            return "SIEMENS";
        }
        if (det_type.equals("STOE")) {
            return "STOE";
        }
        return "DIP2000";
    }

    public String detector_denzo2strategy(String det_type) {
        return this.detector_denzo2strategyTable.getFirstStringValueOfStarting(det_type);
    }

    public double dist_2D(double x, double y, double x0, double y0) {
        return (x - x0) * (x - x0) + (y - y0) * (y - y0);
    }

    public String spot_profile(int xMax, int yMax, int background_radius, int spot_radius) {
        double x0 = (double)xMax / 2.0 - 0.5;
        double y0 = (double)yMax / 2.0 - 0.5;
        String boxe_str = new String("");
        double bkgdLimit = background_radius * background_radius;
        double spotLimit = spot_radius * spot_radius;
        int y = 0;
        while (y < yMax) {
            boxe_str = String.valueOf(boxe_str) + " ";
            int x = 0;
            while (x < xMax) {
                double dist = this.dist_2D(x, y, x0, y0);
                boxe_str = dist < spotLimit ? String.valueOf(boxe_str) + "2" : (dist < bkgdLimit ? String.valueOf(boxe_str) + "0" : String.valueOf(boxe_str) + "1");
                ++x;
            }
            boxe_str = String.valueOf(boxe_str) + "\n";
            ++y;
        }
        return boxe_str;
    }

    public void write_dotx(String toolname, ParamTable dnz, FFormat format, String dotx_fname, String hklxy_str) {
        try {
            FileWriter dotx = new FileWriter(dotx_fname);
            dotx.write("   Generated by " + toolname + " (code from Sandor Brockhauser)\n");
            int l = 0;
            while (l < 3) {
                dotx.write(format.dotx_mat.sprintf(new Object[]{dnz.getValueAt("Amat", l * 3 + 0), dnz.getValueAt("Amat", l * 3 + 1), dnz.getValueAt("Amat", l * 3 + 2), dnz.getValueAt("Umat", l * 3 + 0), dnz.getValueAt("Umat", l * 3 + 1), dnz.getValueAt("Umat", l * 3 + 2)}));
                ++l;
            }
            dotx.write(format.dotx_par.sprintf(new Object[]{dnz.getFirstValue("phi_start"), dnz.getFirstValue("phi_end"), dnz.getFirstValue("distance_pix"), dnz.getFirstValue("wavelength"), dnz.getFirstValue("crystal_rotz"), dnz.getFirstValue("crystal_roty"), dnz.getFirstValue("crystal_rotx"), dnz.getFirstValue("mosaicity"), new Double(-1.0), new Double(1.0), new Double(-1.0), new Double(-1.0), new Double(-1.0), new Double(-1.0)}));
            dotx.write(hklxy_str);
            dotx.write(format.dotx_end.sprintf(new Object[]{dnz.getFirstValue("boxe_size_x"), dnz.getFirstValue("boxe_size_y"), dnz.getFirstValue("spot_profile"), dnz.getFirstValue("spot_radius"), dnz.getFirstValue("spot_radius"), dnz.getFirstValue("background_radius"), dnz.getFirstValue("background_radius"), dnz.getFirstValue("resolution_limits"), dnz.getFirstValue("wavelength"), dnz.getFirstValue("monochromator"), dnz.getFirstValue("phi_start"), dnz.getFirstValue("phi_end"), dnz.getFirstValue("mosaicity"), dnz.getFirstValue("cell"), dnz.getFirstValue("crystal_rotx"), dnz.getFirstValue("crystal_roty"), dnz.getFirstValue("crystal_rotz"), dnz.getFirstValue("image_template"), dnz.getFirstValue("detector"), dnz.getFirstValue("spg"), dnz.getFirstValue("cassette_rotz"), dnz.getFirstValue("distance_mm"), dnz.getFirstValue("beam_x"), dnz.getFirstValue("beam_y"), dnz.getFirstValue("film_rotation")}));
            dotx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write_dotx(Dnz dnz, FFormat format, String dotx_fname, String hklxy_str) {
        try {
            FileWriter dotx = new FileWriter(dotx_fname);
            dotx.write("   Generated with XDS2DENZO (by Sandor Brockhauser)\n");
            int l = 0;
            while (l < 3) {
                dotx.write(format.dotx_mat.sprintf(new Object[]{new Double(dnz.Amat.get(l, 0)), new Double(dnz.Amat.get(l, 1)), new Double(dnz.Amat.get(l, 2)), new Double(dnz.Umat.get(l, 0)), new Double(dnz.Umat.get(l, 1)), new Double(dnz.Umat.get(l, 2))}));
                ++l;
            }
            dotx.write(format.dotx_par.sprintf(new Object[]{new Double(dnz.phi_start), new Double(dnz.phi_end), new Double(dnz.distance_pix), new Double(dnz.wavelength), new Double(dnz.crystal_rotz), new Double(dnz.crystal_roty), new Double(dnz.crystal_rotx), new Double(dnz.mosaicity), new Double(-1.0), new Double(1.0), new Double(-1.0), new Double(-1.0), new Double(-1.0), new Double(-1.0)}));
            dotx.write(hklxy_str);
            dotx.write(format.dotx_end.sprintf(new Object[]{new Double(dnz.boxe_size_x), new Double(dnz.boxe_size_y), dnz.spot_profile, new Double(dnz.spot_radius), new Double(dnz.spot_radius), new Double(dnz.background_radius), new Double(dnz.background_radius), dnz.resolution_limits, new Double(dnz.wavelength), new Double(dnz.monochromator), new Double(dnz.phi_start), new Double(dnz.phi_end), new Double(dnz.mosaicity), dnz.cell, new Double(dnz.crystal_rotx), new Double(dnz.crystal_roty), new Double(dnz.crystal_rotz), dnz.image_template, dnz.detector, dnz.spg, new Double(dnz.cassette_rotz), new Double(dnz.distance_mm), new Double(dnz.beam_x), new Double(dnz.beam_y), new Double(dnz.film_rotation)}));
            dotx.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double d_min(double det_diameter, double det_distance, double wavelength) {
        return 1.0 / (2.0 * Math.sin(Math.atan(det_diameter / 2.0 / det_distance) / 2.0) / wavelength);
    }

    public String opReadCl(String filename) {
        String content = new String("");
        try {
            FileInputStream inputFile = new FileInputStream(filename);
            FileChannel inCh = inputFile.getChannel();
            long fileSize = inCh.size();
            byte[] inArray = new byte[(int)fileSize];
            inputFile.read(inArray);
            content = String.valueOf(content) + new String(inArray);
            inCh.close();
            inputFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return content;
    }

    public Vector map(String func, String[] tmp) {
        Vector<Object> list = new Vector<Object>();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].length() != 0) {
                Number item2;
                if (func == "double" || func == "float") {
                    try {
                        item2 = new Double(tmp[i]);
                        list.addElement(item2);
                    }
                    catch (NumberFormatException item2) {}
                } else if (func == "int") {
                    try {
                        item2 = new Integer(tmp[i]);
                        list.addElement(item2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (func == "string") {
                    list.addElement(tmp[i]);
                }
            }
            ++i;
        }
        return list;
    }

    public Object getXpar(String _str, String match) {
        return this.getXpar(_str, match, 80, "double");
    }

    public Object getXpar_mixedMode(String _str, String _match, int limit, String func) {
        String[] tmp;
        String str = _str;
        String match = _match;
        str = str.toLowerCase();
        match = match.toLowerCase();
        int start = str.indexOf(match) + match.length();
        int end = start + limit;
        if (start < match.length()) {
            Stac_Out.println("WARNING: String \"" + match + "\" has not been found in the text.");
            tmp = new String[]{"", ""};
        } else {
            if (end > str.length()) {
                end = str.length();
            }
            tmp = str.substring(start, end).split("\n")[0].split("\\s+");
        }
        return this.map(func, tmp);
    }

    public Object getXpar(String _str, String _match, int limit, String func) {
        String[] tmp;
        int start = _str.indexOf(_match) + _match.length();
        int end = start + limit;
        if (start < _match.length()) {
            Stac_Out.println("WARNING: String \"" + _match + "\" has not been found in the text.");
            tmp = new String[]{"", ""};
        } else {
            if (end > _str.length()) {
                end = _str.length();
            }
            tmp = _str.substring(start, end).split("\n")[0].split("\\s+");
        }
        return this.map(func, tmp);
    }

    public void read_correct_info(String infname, ParamTable pTable) {
        pTable.clear();
        String corr = this.opReadCl(infname);
        String corrp = corr.substring(corr.indexOf("PARAMETERS USING ALL IMAGES") + 100, corr.indexOf("DETERMINATION OF RECIPROCAL") - 100);
        String corri = corr.substring(0, 1500);
        pTable.setValueList("rot", this.getXpar(corrp, "ROTATION AXIS"));
        pTable.setValueList("beam", this.getXpar(corrp, "COORDINATES (REC. ANGSTROEM)"));
        pTable.setSingleValue("distance", ((Vector)this.getXpar(corrp, "DETECTOR DISTANCE (mm)")).elementAt(0));
        pTable.setValueList("origin", this.getXpar(corrp, "(PIXELS) OF DIRECT BEAM"));
        pTable.setValueList("a", this.getXpar(corrp, "CELL A-AXIS"));
        pTable.setValueList("b", this.getXpar(corrp, "CELL B-AXIS"));
        pTable.setValueList("c", this.getXpar(corrp, "CELL C-AXIS"));
        pTable.setValueList("cell", this.getXpar(corrp, "UNIT CELL PARAMETERS"));
        pTable.setSingleValue("mosaicity", ((Vector)this.getXpar(corrp, "CRYSTAL MOSAICITY (DEGREES)")).elementAt(0));
        Vector pixelSize = new Vector();
        pixelSize.addElement(((Vector)this.getXpar(corri, "QX=", 10, "double")).elementAt(0));
        pixelSize.addElement(((Vector)this.getXpar(corri, "QY=", 10, "double")).elementAt(0));
        pTable.setValueList("pixel_size", pixelSize);
        Vector tempStr = (Vector)this.getXpar(corri, "TEMPLATE_OF_DATA_FRAMES=", 80, "string");
        pTable.setSingleValue("template", ((String)tempStr.elementAt(0)).replace('?', '#'));
        pTable.setSingleValue("symmetry", ((Vector)this.getXpar(corrp, "SPACE GROUP NUMBER", 80, "int")).elementAt(0));
        pTable.setSingleValue("detector", ((Vector)this.getXpar(corri, "DETECTOR=", 40, "string")).elementAt(0));
        pTable.setSingleValue("phi_init", ((Vector)this.getXpar(corri, "STARTING_ANGLE=", 15, "double")).elementAt(0));
        pTable.setSingleValue("num_init", ((Vector)this.getXpar(corri, "STARTING_FRAME=", 15, "int")).elementAt(0));
        pTable.setSingleValue("delta_phi", ((Vector)this.getXpar(corri, "OSCILLATION_RANGE=", 15, "double")).elementAt(0));
        pTable.setSingleValue("divergence_esd", ((Vector)this.getXpar(corri, "BEAM_DIVERGENCE_E.S.D.=", 15, "double")).elementAt(0));
        pTable.setSingleValue("polarization", ((Vector)this.getXpar(corri, "FRACTION_OF_POLARIZATION=", 15, "double")).elementAt(0));
        pTable.setValueList("resolution_range", this.getXpar(corri, "INCLUDE_RESOLUTION_RANGE=", 20, "double"));
        pTable.setSingleValue("npixel_x", ((Vector)this.getXpar(corri, "NX=", 7, "int")).elementAt(0));
        pTable.setSingleValue("npixel_y", ((Vector)this.getXpar(corri, "NY=", 7, "int")).elementAt(0));
        pTable.setSingleValue("friedel", ((Vector)this.getXpar(corri, "FRIEDEL'S_LAW=", 7, "string")).elementAt(0));
    }

    public Vector reshape(Vector data, int size) {
        int ct = 0;
        int rowct = 0;
        int i = 0;
        int maxsize = data.size();
        while (ct < maxsize) {
            Vector row = new Vector();
            i = 0;
            while (i < size && ct < maxsize) {
                row.addElement(data.elementAt(ct));
                ++i;
                ++ct;
            }
            data.setElementAt(row, rowct);
            ++rowct;
        }
        if (i == 0) {
            --rowct;
        }
        data.setSize(rowct);
        return data;
    }

    public Vector expand(Vector data) {
        Vector p = new Vector();
        int i = 0;
        while (i < data.size()) {
            int j = 0;
            while (j < ((Vector)data.elementAt(i)).size()) {
                p.addElement(((Vector)data.elementAt(i)).elementAt(j));
                ++j;
            }
            ++i;
        }
        return p;
    }

    public Vector read_xds_hkl(String hkl_str, String ftype) {
        hkl_str = hkl_str.substring(hkl_str.indexOf("!END_OF_HEADER") + 15, hkl_str.indexOf("!END_OF_DATA"));
        Vector hkl_num = this.map("double", hkl_str.split("\\s+"));
        int _len = hkl_num.size();
        if (ftype == "INTEGRATE") {
            hkl_num = this.reshape(hkl_num, 19);
        } else if (ftype == "XDS_ASCII") {
            hkl_num = this.reshape(hkl_num, 11);
        }
        return hkl_num;
    }

    public double[] cross(double[] a, double[] b) {
        double[] p = new double[]{0.0, 0.0, 0.0};
        p[0] = a[1] * b[2] - a[2] * b[1];
        p[1] = -a[0] * b[2] + a[2] * b[0];
        p[2] = a[0] * b[1] - a[1] * b[0];
        return p;
    }

    public double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public double[] mmul(Matrix m, double[] v) {
        double[] p = new double[]{0.0, 0.0, 0.0};
        p[0] = m.get(0, 0) * v[0] + m.get(0, 1) * v[1] + m.get(0, 2) * v[2];
        p[1] = m.get(1, 0) * v[0] + m.get(1, 1) * v[1] + m.get(1, 2) * v[2];
        p[2] = m.get(2, 0) * v[0] + m.get(2, 1) * v[1] + m.get(2, 2) * v[2];
        return p;
    }

    public double[] smul(double[] a, double s) {
        double[] p = new double[]{0.0, 0.0, 0.0};
        p[0] = a[0] * s;
        p[1] = a[1] * s;
        p[2] = a[2] * s;
        return p;
    }

    public double angle(double[] a, double[] b) {
        double l = this.dot(a, b) / this.len(b) / this.len(a);
        l = Math.max(-1.0, Math.min(1.0, l));
        return Math.acos(l);
    }

    public double len(double[] a) {
        return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    public double[] normal(double[] a) {
        double len = this.len(a);
        double[] p = new double[]{0.0, 0.0, 0.0};
        if (len > 0.0) {
            p[0] = a[0] / len;
            p[1] = a[1] / len;
            p[2] = a[2] / len;
        }
        return p;
    }

    public double sqr(double a) {
        return a * a;
    }

    public void SetupDenzoMissettingAngles(Matrix Ub, ParamTable dnz) {
        Matrix3d CA = new Matrix3d(Ub.getRowPackedCopy());
        double[] cell = new double[6];
        double[] tcell = new double[6];
        this.dnzcel(CA, cell, tcell);
        Matrix3d Bdz = new Matrix3d();
        this.dnzbmt(tcell, Bdz);
        Vector3d vertical = new Vector3d(1.0, 0.0, 0.0);
        Vector3d spindle = new Vector3d(0.0, 0.0, 1.0);
        Vector3d U0y = new Vector3d();
        Bdz.transform((Tuple3d)spindle, (Tuple3d)U0y);
        U0y.normalize();
        Vector3d U0xi = new Vector3d();
        Bdz.transform((Tuple3d)vertical, (Tuple3d)U0xi);
        Vector3d U0x = new Vector3d();
        U0x.scaleAdd(-1.0 * U0xi.dot(U0y), (Tuple3d)U0y, (Tuple3d)U0xi);
        U0x.normalize();
        Vector3d U0z = new Vector3d();
        U0z.cross(U0x, U0y);
        Matrix3d U0 = new Matrix3d();
        U0.setRow(0, U0x);
        U0.setRow(1, U0y);
        U0.setRow(2, U0z);
        Matrix3d Bdzm1 = new Matrix3d(Bdz);
        Bdzm1.invert();
        Matrix3d Udz = new Matrix3d(CA);
        Udz.mul(Bdzm1);
        Matrix3d U0m1 = new Matrix3d(U0);
        U0m1.invert();
        Udz.mul(U0m1);
        Vector3d phixyz2 = new Vector3d();
        this.gnspxg(Udz, phixyz2, new Matrix3d(new double[]{0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0}));
        Stac_Out.println("phixyz(Udz): " + phixyz2);
        dnz.setSingleDoubleValue("crystal_rotx", phixyz2.z);
        dnz.setSingleDoubleValue("crystal_roty", phixyz2.y);
        dnz.setSingleDoubleValue("crystal_rotz", phixyz2.x);
    }

    public void ConvertInputFormat(String infile1, String infile2, String inputType, String outfile) {
        File fp = new File(outfile);
        fp.delete();
        if (inputType.toLowerCase().equals("mosflm")) {
            String fname = outfile;
            Stac_Out.print("Conversion from Mosflm to Denzo format: " + fname + " ...");
            try {
                int j;
                ParamTable dnz = new ParamTable();
                String MosflmMatrixFileName = infile1;
                String MosflmSettingsFileName = infile2;
                FileInputStream MosflmMatrixFile = new FileInputStream(MosflmMatrixFileName);
                TextReader mmf = new TextReader(MosflmMatrixFile);
                Matrix Ub = new Matrix(3, 3);
                Matrix Ur = new Matrix(3, 3);
                int i = 0;
                while (i < 3) {
                    j = 0;
                    while (j < 3) {
                        Ub.set(i, j, mmf.getDouble());
                        ++j;
                    }
                    ++i;
                }
                mmf.getln();
                mmf.getln();
                i = 0;
                while (i < 3) {
                    j = 0;
                    while (j < 3) {
                        Ur.set(i, j, mmf.getDouble());
                        ++j;
                    }
                    ++i;
                }
                double[] celldim = new double[6];
                int i2 = 0;
                while (i2 < 6) {
                    celldim[i2] = mmf.getDouble();
                    ++i2;
                }
                double[] misset = new double[3];
                int i3 = 0;
                while (i3 < 3) {
                    misset[i3] = mmf.getDouble();
                    ++i3;
                }
                dnz.setSingleValue("cell", " " + celldim[0] + " " + celldim[1] + " " + celldim[2] + " " + celldim[3] + " " + celldim[4] + " " + celldim[5]);
                String msf = this.opReadCl(MosflmSettingsFileName);
                msf = msf.toLowerCase();
                dnz.setSingleValue("phi_init", ((Vector)this.getXpar(msf, " phi ", 20, "double")).elementAt(0));
                dnz.setSingleValue("phi_start", ((Vector)this.getXpar(msf, " phi ", 20, "double")).elementAt(0));
                dnz.setSingleValue("phi_end", ((Vector)this.getXpar(msf, " phi ", 20, "double")).elementAt(1));
                dnz.setSingleDoubleValue("delta_phi", dnz.getFirstDoubleValue("phi_end") - dnz.getFirstDoubleValue("phi_start"));
                dnz.setSingleValue("image_template", ((Vector)this.getXpar(msf, "template ", 80, "string")).elementAt(0));
                msf = this.opReadCl(new File(new File(MosflmSettingsFileName).getCanonicalPath()).getParentFile() + File.separator + "bestfile.par");
                msf = msf.toLowerCase();
                dnz.setSingleValue("beam_x", ((Vector)this.getXpar(msf, "beam ", 80, "double")).elementAt(0));
                dnz.setSingleValue("beam_y", ((Vector)this.getXpar(msf, "beam ", 80, "double")).elementAt(1));
                dnz.setSingleValue("diameter", ((Vector)this.getXpar(msf, "diameter ", 80, "double")).elementAt(0));
                String msf_dec = (String)((Vector)this.getXpar(msf, "detector ", 80, "string")).elementAt(0);
                dnz.setSingleValue("detector", this.detector_xds2denzo(msf_dec, dnz.getFirstDoubleValue("diameter")));
                dnz.setSingleValue("pixel_size_x", ((Vector)this.getXpar(msf, "pixel ", 80, "double")).elementAt(0));
                dnz.setSingleValue("pixel_size_y", ((Vector)this.getXpar(msf, "pixel ", 80, "double")).elementAt(0));
                dnz.setSingleValue("wavelength", ((Vector)this.getXpar(msf, "wavelength ", 80, "double")).elementAt(0));
                dnz.setSingleValue("distance_mm", ((Vector)this.getXpar(msf, "distance ", 80, "double")).elementAt(0));
                dnz.setSingleValue("distance_pix", dnz.getFirstDoubleValue("distance_mm") / dnz.getFirstDoubleValue("pixel_size_x"));
                dnz.setSingleValue("mosaicity", ((Vector)this.getXpar(msf, "cmosaic", 80, "double")).elementAt(0));
                dnz.setSingleValue("spg", ((Vector)this.getXpar(msf, "symmetry ", 80, "string")).elementAt(0));
                double rad = dnz.getFirstDoubleValue("diameter") / 2.0 - Math.max(Math.abs(dnz.getFirstDoubleValue("diameter") / 2.0 - dnz.getFirstDoubleValue("beam_x")), Math.abs(dnz.getFirstDoubleValue("diameter") / 2.0 - dnz.getFirstDoubleValue("beam_y")));
                double res = dnz.getFirstDoubleValue("wavelength") / 2.0 / Math.sin(Math.atan(rad / dnz.getFirstDoubleValue("distance_mm")) / 2.0);
                dnz.setSingleValue("resolution_limits", "  50.0   " + res);
                dnz.setSingleValue("monochromator", ((Vector)this.getXpar(msf, "polarisation ", 80, "double")).elementAt(0));
                dnz.setSingleDoubleValue("cassette_rotz", 0.0);
                dnz.setSingleDoubleValue("film_rotation", 0.0);
                dnz.setSingleDoubleValue("spot_radius", 0.0);
                Matrix RotX = new Matrix(3, 3);
                Matrix RotY = new Matrix(3, 3);
                Matrix RotZ = new Matrix(3, 3);
                this.Rotation(RotX, 1, 2, misset[0]);
                this.Rotation(RotY, 0, 2, misset[1]);
                this.Rotation(RotZ, 0, 1, misset[2]);
                Matrix Rot = new Matrix(3, 3);
                Rot = RotZ.times(RotY.times(RotX));
                Matrix U = new Matrix(3, 3);
                U = Rot.times(Ur);
                Matrix Uinv = new Matrix(3, 3);
                Uinv = U.inverse();
                Matrix B = new Matrix(3, 3);
                B = Uinv.times(Ub);
                PrintfFormat pform = new PrintfFormat("%16.7lE");
                Ub = Ub.times(1.0 / dnz.getFirstDoubleValue("wavelength"));
                Matrix corrMatrix = new Matrix((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
                U = U.times(corrMatrix);
                Ub = Ub.times(corrMatrix);
                Matrix corr2Matrix = new Matrix((double[][])new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}});
                Ub = corr2Matrix.times(Ub);
                dnz.setDoubleValueList("Amat", Ub.getRowPackedCopy());
                dnz.setDoubleValueList("Umat", U.getRowPackedCopy());
                this.SetupDenzoMissettingAngles(Ub, dnz);
                dnz.dump();
                int spot_radius = 2;
                int bkg_radius = spot_radius + 1;
                dnz.setSingleDoubleValue("boxe_size_x", (spot_radius + 3) * 2);
                dnz.setSingleDoubleValue("boxe_size_y", (spot_radius + 3) * 2);
                dnz.setSingleDoubleValue("background_radius", (double)bkg_radius * dnz.getFirstDoubleValue("pixel_size_x"));
                dnz.setSingleValue("spot_profile", this.spot_profile((int)dnz.getFirstDoubleValue("boxe_size_x"), (int)dnz.getFirstDoubleValue("boxe_size_y"), bkg_radius, spot_radius));
                int i4 = 0;
                while (i4 < 1) {
                    boolean image_num = true;
                    dnz.setSingleDoubleValue("phi_end", dnz.getFirstDoubleValue("phi_init") + (double)image_num * dnz.getFirstDoubleValue("delta_phi"));
                    dnz.setSingleDoubleValue("phi_start", dnz.getFirstDoubleValue("phi_end") - dnz.getFirstDoubleValue("delta_phi"));
                    FFormat FMT = new FFormat();
                    String hklxy_str = "";
                    this.write_dotx("MOSFLM2DENZO", dnz, FMT, fname, hklxy_str);
                    ++i4;
                }
                Stac_Out.println(" finished");
            }
            catch (Exception ex1) {
                Stac_Out.println(" ERROR!");
            }
        } else if (inputType.toLowerCase().equals("xds")) {
            try {
                double mosaicity_conversion_factor = 4.41;
                double r2d = 57.29577951308232;
                ParamTable SPGlib = new ParamTable(new Object[][]{{new Integer(1), "P1", "P1", new Integer(1)}, {new Integer(3), "P2", "P2", new Integer(2)}, {new Integer(4), "P21", "P2(1)", new Integer(2)}, {new Integer(5), "C2", "C2", new Integer(4)}, {new Integer(16), "P222", "P222", new Integer(4)}, {new Integer(17), "P2221", "P222(1)", new Integer(4)}, {new Integer(18), "P21212", "P2(1)2(1)2", new Integer(4)}, {new Integer(19), "P212121", "P2(1)2(1)2(1)", new Integer(4)}, {new Integer(21), "C222", "C222", new Integer(8)}, {new Integer(20), "C2221", "C222(1)", new Integer(8)}, {new Integer(22), "F222", "F222", new Integer(16)}, {new Integer(23), "I222", "I222", new Integer(8)}, {new Integer(24), "I212121", "I2(1)2(1)2(1)", new Integer(8)}, {new Integer(75), "P4", "P4", new Integer(4)}, {new Integer(76), "P41", "P4(1)", new Integer(4)}, {new Integer(77), "P42", "P4(2)", new Integer(4)}, {new Integer(78), "P43", "P4(3)", new Integer(4)}, {new Integer(89), "P422", "P422", new Integer(8)}, {new Integer(90), "P4212", "P42(1)2", new Integer(8)}, {new Integer(91), "P4122", "P4(1)22", new Integer(8)}, {new Integer(92), "P41212", "P4(1)2(1)2", new Integer(8)}, {new Integer(93), "P4222", "P4(2)22", new Integer(8)}, {new Integer(94), "P42212", "P4(2)2(1)2", new Integer(8)}, {new Integer(95), "P4322", "P4(3)22", new Integer(8)}, {new Integer(96), "P43212", "P4(3)2(1)2", new Integer(8)}, {new Integer(79), "I4", "I4", new Integer(8)}, {new Integer(80), "I41", "I4(1)", new Integer(8)}, {new Integer(97), "I422", "I422", new Integer(16)}, {new Integer(98), "I4122", "I4(1)22", new Integer(16)}, {new Integer(143), "P3", "P3", new Integer(3)}, {new Integer(144), "P31", "P3(1)", new Integer(3)}, {new Integer(145), "P32", "P3(2)", new Integer(3)}, {new Integer(149), "P312", "P312", new Integer(6)}, {new Integer(150), "P321", "P321", new Integer(6)}, {new Integer(151), "P3112", "P3(1)12", new Integer(6)}, {new Integer(152), "P3121", "P3(1)21", new Integer(6)}, {new Integer(153), "P3212", "P3(2)12", new Integer(6)}, {new Integer(154), "P3221", "P3(2)21", new Integer(6)}, {new Integer(168), "P6", "P6", new Integer(6)}, {new Integer(169), "P61", "P6(1)", new Integer(6)}, {new Integer(170), "P65", "P6(5)", new Integer(6)}, {new Integer(171), "P62", "P6(2)", new Integer(6)}, {new Integer(172), "P64", "P6(4)", new Integer(6)}, {new Integer(173), "P63", "P6(3)", new Integer(6)}, {new Integer(177), "P622", "P622", new Integer(12)}, {new Integer(178), "P6122", "P6(1)22", new Integer(12)}, {new Integer(179), "P6522", "P6(5)22", new Integer(12)}, {new Integer(180), "P6222", "P6(2)22", new Integer(12)}, {new Integer(181), "P6422", "P6(4)22", new Integer(12)}, {new Integer(182), "P6322", "P6(3)22", new Integer(12)}, {new Integer(146), "H3", "R3", new Integer(9)}, {new Integer(155), "H32", "R32", new Integer(18)}, {new Integer(195), "P23", "P23", new Integer(12)}, {new Integer(198), "P213", "P2(1)3", new Integer(12)}, {new Integer(207), "P432", "P432", new Integer(24)}, {new Integer(208), "P4232", "P4(2)32", new Integer(24)}, {new Integer(212), "P4332", "P4(3)32", new Integer(24)}, {new Integer(213), "P4132", "P4(1)32", new Integer(24)}, {new Integer(196), "F23", "F23", new Integer(48)}, {new Integer(209), "F432", "F432", new Integer(96)}, {new Integer(210), "F4132", "F4(1)32", new Integer(96)}, {new Integer(197), "I23", "I23", new Integer(24)}, {new Integer(199), "I213", "I2(1)3", new Integer(24)}, {new Integer(211), "I432", "I432", new Integer(48)}, {new Integer(214), "I4132", "I4(1)32", new Integer(48)}});
                ParamTable film_rotation_DB = new ParamTable(new String[]{"MARCCD133", "MARCCD165", "ADSCQ4R", "ADSCQ210", "ADSCQ315", "DIP2", "MAR225"}, new double[]{-90.0, 0.0, 90.0, 90.0, 90.0, -90.0, 90.0});
                ParamTable cassette_rotz_DB = new ParamTable(new String[]{"MARCCD133", "MARCCD165", "ADSCQ4R", "ADSCQ210", "ADSCQ315", "DIP2", "MAR225"}, new double[]{0.0, 90.0, 0.0, 0.0, 0.0, 0.0, 0.0});
                boolean image_num_list = true;
                ParamTable xdsPar = new ParamTable();
                String infile = infile1;
                File inFile = new File(infile);
                String xds_dir = String.valueOf(inFile.getParent()) + File.separator;
                this.read_correct_info(infile, xdsPar);
                String hkl_name = "INTEGRATE.HKL";
                int iZD = 7;
                int irXYD = 5;
                int ncol = 18;
                if (hkl_name == "INTEGRATE.HKL") {
                    iZD = 7;
                    irXYD = 5;
                    ncol = 18;
                } else if (hkl_name == "XDS_ASCII.HKL") {
                    iZD = 7;
                    irXYD = 4;
                    ncol = 10;
                }
                hkl_name = String.valueOf(xds_dir) + hkl_name;
                Vector hkl_xds = new Vector();
                double D = xdsPar.getFirstDoubleValue("distance") / xdsPar.getFirstDoubleValue("pixel_size");
                Vector XY = new Vector();
                int i = 0;
                while (i < hkl_xds.size()) {
                    Vector XYn = new Vector();
                    int j = irXYD + 1;
                    while (j >= irXYD) {
                        XYn.addElement(((Vector)hkl_xds.elementAt(i)).elementAt(j));
                        --j;
                    }
                    XY.addElement(XYn);
                    ++i;
                }
                double X0 = (Double)xdsPar.getValueList("origin").elementAt(1);
                double Y0 = xdsPar.getFirstDoubleValue("origin");
                Vector<Double> OBL = new Vector<Double>();
                int i5 = 0;
                while (i5 < XY.size()) {
                    OBL.addElement(new Double(D / Math.sqrt(D * D + ((Double)((Vector)XY.elementAt(i5)).elementAt(0) - X0) * ((Double)((Vector)XY.elementAt(i5)).elementAt(0) - X0) + ((Double)((Vector)XY.elementAt(i5)).elementAt(1) - Y0) * ((Double)((Vector)XY.elementAt(i5)).elementAt(1) - Y0))));
                    ++i5;
                }
                Vector hklxy = new Vector();
                int i6 = 0;
                while (i6 < hkl_xds.size()) {
                    Vector XYn = new Vector();
                    int j = 0;
                    while (j < 5) {
                        XYn.addElement(((Vector)hkl_xds.elementAt(i6)).elementAt(j));
                        ++j;
                    }
                    XYn.addElement(OBL.elementAt(i6));
                    j = 0;
                    while (j < 2) {
                        XYn.addElement(((Vector)XY.elementAt(i6)).elementAt(j));
                        ++j;
                    }
                    hklxy.addElement(XYn);
                    ++i6;
                }
                double[] a = xdsPar.getDoubleVector("a");
                double[] b = xdsPar.getDoubleVector("b");
                double[] c = xdsPar.getDoubleVector("c");
                double[] beam = xdsPar.getDoubleVector("beam");
                double[] rot = xdsPar.getDoubleVector("rot");
                double volum = this.dot(this.cross(a, b), c);
                double[] ar = this.smul(this.cross(b, c), 1.0 / volum);
                double[] br = this.smul(this.cross(c, a), 1.0 / volum);
                double[] cr = this.smul(this.cross(a, b), 1.0 / volum);
                double wavelength = 1.0 / this.len(beam);
                double[] cammat_Y = this.normal(rot);
                double[] cammat_X = this.normal(this.cross(cammat_Y, beam));
                double[] cammat_Z = this.cross(cammat_X, cammat_Y);
                double[][] cammat_XYZ = new double[][]{cammat_X, cammat_Y, cammat_Z};
                Matrix cammat = new Matrix((double[][])cammat_XYZ);
                Matrix Amat = new Matrix((double[][])new double[][]{this.mmul(cammat, ar), this.mmul(cammat, br), this.mmul(cammat, cr)}).transpose();
                Matrix3d CA = new Matrix3d(Amat.getRowPackedCopy());
                double[] cell = new double[6];
                double[] tcell = new double[6];
                this.dnzcel(CA, cell, tcell);
                Matrix3d Bdz = new Matrix3d();
                this.dnzbmt(tcell, Bdz);
                Matrix3d Bdzm1 = new Matrix3d(Bdz);
                Bdzm1.invert();
                Matrix3d Udz = new Matrix3d(CA);
                Udz.mul(Bdzm1);
                Matrix3d B = new Matrix3d();
                Matrix3d Bm1t = new Matrix3d();
                Matrix3d U = new Matrix3d();
                Matrix3d UB = new Matrix3d();
                Vector3d phixyz = new Vector3d();
                this.dnzcnv(cell, CA, B, Bm1t, U, phixyz, UB);
                Stac_Out.println("phixyz: " + phixyz);
                Vector3d phixyz2 = new Vector3d();
                this.gnspxg(Udz, phixyz2);
                Stac_Out.println("phixyz(Udz): " + phixyz2);
                ParamTable dnz = new ParamTable();
                this.SetupDenzoMissettingAngles(Amat, dnz);
                dnz.setDoubleValueList("Amat", Amat.getRowPackedCopy());
                dnz.setDoubleValueList("Umat", new double[]{Udz.m20, Udz.m21, Udz.m22, Udz.m00, Udz.m01, Udz.m02, Udz.m10, Udz.m11, Udz.m12});
                dnz.setSingleDoubleValue("wavelength", wavelength);
                dnz.setSingleDoubleValue("delta_phi", xdsPar.getFirstDoubleValue("delta_phi"));
                dnz.setSingleDoubleValue("pixel_size_x", xdsPar.getFirstDoubleValue("pixel_size"));
                dnz.setSingleDoubleValue("pixel_size_y", xdsPar.getDoubleValueAt("pixel_size", 1));
                dnz.setSingleDoubleValue("distance_pix", xdsPar.getFirstDoubleValue("distance") / dnz.getFirstDoubleValue("pixel_size_x"));
                dnz.setSingleDoubleValue("distance_mm", xdsPar.getFirstDoubleValue("distance"));
                dnz.setSingleDoubleValue("phi_init", xdsPar.getFirstDoubleValue("phi_init"));
                dnz.setSingleDoubleValue("mosaicity", mosaicity_conversion_factor * xdsPar.getFirstDoubleValue("mosaicity"));
                dnz.setSingleDoubleValue("beam_x", xdsPar.getDoubleValueAt("origin", 1) * xdsPar.getDoubleValueAt("pixel_size", 1));
                dnz.setSingleDoubleValue("beam_y", xdsPar.getDoubleValueAt("origin", 0) * xdsPar.getDoubleValueAt("pixel_size", 0));
                dnz.setSingleValue("image_template", xdsPar.getFirstStringValue("template"));
                dnz.setSingleValue("spg", SPGlib.getFirstStringValue(xdsPar.getFirstValue("symmetry")).toLowerCase());
                dnz.setSingleDoubleValue("monochromator", xdsPar.getFirstDoubleValue("polarization"));
                dnz.setSingleDoubleValue("spot_radius", dnz.getFirstDoubleValue("distance_mm") * Math.tan(2.5 * xdsPar.getFirstDoubleValue("divergence_esd") * Math.PI / 180.0));
                dnz.setSingleDoubleValue("diameter", Math.min((double)xdsPar.getFirstIntegerValue("npixel_x") * dnz.getFirstDoubleValue("pixel_size_x"), (double)xdsPar.getFirstIntegerValue("npixel_y") * dnz.getFirstDoubleValue("pixel_size_y")));
                dnz.setSingleValue("cell", new PrintfFormat("%.3f  %.3f  %.3f  %.3f  %.3f  %.3f  ").sprintf(xdsPar.getValueList("cell").toArray()));
                dnz.setSingleValue("detector", this.detector_xds2denzo(xdsPar.getFirstStringValue("detector"), dnz.getFirstDoubleValue("diameter")));
                Vector resolution_limits = xdsPar.getValueList("resolution_range");
                if (Math.min((Double)resolution_limits.elementAt(0), (Double)resolution_limits.elementAt(1)) == 0.0) {
                    Double maxRes = new Double(Math.max((Double)resolution_limits.elementAt(0), (Double)resolution_limits.elementAt(1)));
                    resolution_limits.clear();
                    resolution_limits.addElement(maxRes);
                    resolution_limits.addElement(new Double(Math.min(Math.min(dnz.getFirstDoubleValue("diameter"), dnz.getFirstDoubleValue("distance_mm")), dnz.getFirstDoubleValue("wavelength"))));
                }
                dnz.setSingleValue("resolution_limits", new PrintfFormat("%.2f  %.2f").sprintf(resolution_limits.toArray()));
                String _detector = this.detector2strategy(xdsPar.getFirstStringValue("detector"), dnz.getFirstDoubleValue("diameter"));
                dnz.setSingleDoubleValue("film_rotation", film_rotation_DB.getFirstDoubleValue(_detector));
                dnz.setSingleDoubleValue("cassette_rotz", cassette_rotz_DB.getFirstDoubleValue(_detector));
                int spot_radius = (int)(dnz.getFirstDoubleValue("spot_radius") / dnz.getFirstDoubleValue("pixel_size_x") + 0.5);
                int bkg_radius = spot_radius + 1;
                dnz.setSingleDoubleValue("boxe_size_x", (spot_radius + 3) * 2);
                dnz.setSingleDoubleValue("boxe_size_y", (spot_radius + 3) * 2);
                dnz.setSingleDoubleValue("background_radius", (double)bkg_radius * dnz.getFirstDoubleValue("pixel_size_x"));
                dnz.setSingleValue("spot_profile", this.spot_profile((int)dnz.getFirstDoubleValue("boxe_size_x"), (int)dnz.getFirstDoubleValue("boxe_size_y"), bkg_radius, spot_radius));
                String[] fn = dnz.getFirstStringValue("image_template").split("/");
                String prefix = fn[fn.length - 1].split("\\.")[0].replaceAll("#", "");
                String dotx_fname_fmt = String.valueOf(prefix) + "%.3d.x.xds";
                int i7 = 0;
                while (i7 < 1) {
                    int image_num = 1;
                    String dotx_fname = outfile;
                    dnz.setSingleDoubleValue("phi_end", dnz.getFirstDoubleValue("phi_init") + (double)image_num * dnz.getFirstDoubleValue("delta_phi"));
                    dnz.setSingleDoubleValue("phi_start", dnz.getFirstDoubleValue("phi_end") - dnz.getFirstDoubleValue("delta_phi"));
                    Vector<Boolean> frame_filter = new Vector<Boolean>();
                    int j = 0;
                    while (j < hkl_xds.size()) {
                        frame_filter.addElement(new Boolean((double)image_num > (Double)((Vector)hkl_xds.elementAt(j)).elementAt(iZD) && (Double)((Vector)hkl_xds.elementAt(j)).elementAt(iZD) >= (double)(image_num - 1)));
                        ++j;
                    }
                    Vector hklxy_select = new Vector(hklxy);
                    int j2 = 0;
                    int selJ = 0;
                    while (j2 < hklxy.size()) {
                        if (((Boolean)frame_filter.elementAt(j2)).booleanValue()) {
                            ++selJ;
                        } else {
                            hklxy_select.removeElementAt(selJ);
                        }
                        ++j2;
                    }
                    int nref = hklxy_select.size();
                    String out_fmt1 = ">>> Number of reflection selected for frame %4d : %d";
                    Stac_Out.println(new PrintfFormat(out_fmt1).sprintf(new Object[]{new Integer(image_num), new Integer(nref)}));
                    FFormat FMT = new FFormat();
                    String hklxy_strFMT = new String("");
                    int j3 = 0;
                    while (j3 < nref) {
                        hklxy_strFMT = String.valueOf(hklxy_strFMT) + FMT.refl;
                        ++j3;
                    }
                    String hklxy_str = new PrintfFormat(hklxy_strFMT).sprintf(this.expand(hklxy_select).toArray());
                    this.write_dotx("XDS2DENZO", dnz, FMT, dotx_fname, hklxy_str);
                    ++i7;
                }
            }
            catch (Exception ex1) {
                Stac_Out.println(" ERROR!");
            }
        } else {
            try {
                String infile = infile1;
                FileChannel srcChannel = new FileInputStream(infile).getChannel();
                FileChannel dstChannel = new FileOutputStream(outfile).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void dnzcel(Matrix3d Adz, double[] cell, double[] tcell) {
        double[] tsin = new double[6];
        double[] tcos = new double[6];
        double rtod = 45.0 / Math.atan(1.0);
        Vector3d row = new Vector3d();
        Adz.getColumn(0, row);
        tcell[0] = row.length();
        Adz.getColumn(1, row);
        tcell[1] = row.length();
        Adz.getColumn(2, row);
        tcell[2] = row.length();
        tcell[3] = Math.acos((Adz.m01 * Adz.m02 + Adz.m11 * Adz.m12 + Adz.m21 * Adz.m22) / (tcell[1] * tcell[2]));
        tcell[4] = Math.acos((Adz.m00 * Adz.m02 + Adz.m10 * Adz.m12 + Adz.m20 * Adz.m22) / (tcell[0] * tcell[2]));
        tcell[5] = Math.acos((Adz.m00 * Adz.m01 + Adz.m10 * Adz.m11 + Adz.m20 * Adz.m21) / (tcell[0] * tcell[1]));
        tsin[0] = Math.sin(tcell[3]);
        tsin[1] = Math.sin(tcell[4]);
        tsin[2] = Math.sin(tcell[5]);
        tcos[0] = Math.cos(tcell[3]);
        tcos[1] = Math.cos(tcell[4]);
        tcos[2] = Math.cos(tcell[5]);
        tcell[3] = tcell[3] * rtod;
        tcell[4] = tcell[4] * rtod;
        tcell[5] = tcell[5] * rtod;
        double vst2 = 1.0 - tcos[0] * tcos[0] - tcos[1] * tcos[1] - tcos[2] * tcos[2] + 2.0 * tcos[0] * tcos[1] * tcos[2];
        double vst = Math.sqrt(vst2);
        cell[0] = tsin[0] / tcell[0] / vst;
        cell[1] = tsin[1] / tcell[1] / vst;
        cell[2] = tsin[2] / tcell[2] / vst;
        cell[3] = Math.acos((tcos[1] * tcos[2] - tcos[0]) / (tsin[1] * tsin[2])) * rtod;
        cell[4] = Math.acos((tcos[0] * tcos[2] - tcos[1]) / (tsin[0] * tsin[2])) * rtod;
        cell[5] = Math.acos((tcos[0] * tcos[1] - tcos[2]) / (tsin[0] * tsin[1])) * rtod;
    }

    public void moscel(double wave, Matrix3d m, Vector3d len, Vector3d angl) {
        Vector3d v = new Vector3d();
        m.getColumn(0, v);
        len.x = v.length() * wave;
        m.getColumn(1, v);
        len.y = v.length() * wave;
        m.getColumn(2, v);
        len.z = v.length() * wave;
        double[] v1 = new double[]{0.0, 0.0, 0.0};
        double[] v2 = new double[]{0.0, 0.0, 0.0};
        m.getColumn(1, v1);
        m.getColumn(2, v2);
        angl.x = this.angle(v1, v2) * 180.0 / Math.PI;
        m.getColumn(0, v1);
        angl.y = this.angle(v1, v2) * 180.0 / Math.PI;
        m.getColumn(1, v2);
        angl.z = this.angle(v1, v2) * 180.0 / Math.PI;
    }

    public void dnzbmt(double[] tcell, Matrix3d Bdz) {
        double[] tsin = new double[3];
        double[] tcos = new double[3];
        double dtor = Math.atan(1.0) / 45.0;
        int i = 0;
        while (i < 3) {
            tsin[i] = Math.sin(dtor * tcell[i + 3]);
            tcos[i] = Math.cos(dtor * tcell[i + 3]);
            ++i;
        }
        Bdz.m00 = tcell[0] * tsin[2];
        Bdz.m10 = tcell[0] * tcos[2];
        Bdz.m20 = 0.0;
        Bdz.m01 = 0.0;
        Bdz.m11 = tcell[1];
        Bdz.m21 = 0.0;
        double a13 = (tcos[1] - tcos[2] * tcos[0]) / tsin[2];
        Bdz.m02 = tcell[2] * a13;
        Bdz.m12 = tcell[2] * tcos[0];
        double tas = tsin[0] * tsin[0] - a13 * a13;
        double a33 = Math.sqrt(tas);
        Bdz.m22 = tcell[2] * a33;
    }

    public void dnzcnv(double[] cell, Matrix3d Adz, Matrix3d B, Matrix3d Bm1t, Matrix3d U, Vector3d phixyz, Matrix3d UB) {
        Matrix3d Bm1 = new Matrix3d();
        Matrix3d Q = new Matrix3d(new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        this.mkbmat(cell, B, 1.0);
        Bm1t.invert(B);
        Bm1t.transpose();
        UB.mul(Q, Adz);
        Bm1.invert(B);
        U.mul(UB, Bm1);
        this.gnspxg(U, phixyz);
    }

    public void gnspxg(Matrix3d rmat, Vector3d rphi) {
        Matrix3d phivec = new Matrix3d(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        this.gnspxg(rmat, rphi, phivec);
    }

    public void gnspxg(Matrix3d rmat, Vector3d rphi, Matrix3d phivec) {
        boolean succes = true;
        double rtod = 45.0 / Math.atan(1.0);
        rphi.x = 0.0;
        rphi.y = 0.0;
        rphi.z = 0.0;
        Vector3d r1 = new Vector3d();
        Vector3d r2 = new Vector3d();
        Vector3d r3 = new Vector3d();
        phivec.getRow(0, r1);
        phivec.getRow(1, r2);
        phivec.getRow(2, r3);
        this.solveu(rmat, r1, r2, r3, false, rphi, succes);
        Stac_Out.println("solveau= " + succes);
        rphi.scale(rtod);
    }

    public void solveu(Matrix3d rotmat, Vector3d axis1, Vector3d axis2, Vector3d axis3, boolean create, Vector3d rot, boolean succes) {
        double[] rotv1 = new double[3];
        double[] rotv1p = new double[3];
        double[] rot2v1 = new double[3];
        double[] rot1p = new double[2];
        double[] rot2p = new double[2];
        double[] rot3p = new double[2];
        double[] perp1 = new double[3];
        double[] rotm1p = new double[3];
        double[] tsinc = new double[3];
        double[] tcosc = new double[3];
        double[] sumdif = new double[2];
        Matrix3d rotm1 = new Matrix3d();
        double twopi = Math.PI * 2;
        if (create) {
            return;
        }
        double p12 = axis1.dot(axis2);
        double p23 = axis2.dot(axis3);
        double p13 = axis1.dot(axis3);
        double det123 = axis1.x * axis2.y * axis3.z - axis1.z * axis2.y * axis3.x + axis1.y * axis2.z * axis3.x - axis1.x * axis2.z * axis3.y + axis1.z * axis2.x * axis3.y - axis1.y * axis2.x * axis3.z;
        rotv1[0] = rotmat.getElement(0, 0) * axis1.x + rotmat.getElement(0, 1) * axis1.y + rotmat.getElement(0, 2) * axis1.z;
        rotv1[1] = rotmat.getElement(1, 0) * axis1.x + rotmat.getElement(1, 1) * axis1.y + rotmat.getElement(1, 2) * axis1.z;
        rotv1[2] = rotmat.getElement(2, 0) * axis1.x + rotmat.getElement(2, 1) * axis1.y + rotmat.getElement(2, 2) * axis1.z;
        double p3r1 = axis3.x * rotv1[0] + axis3.y * rotv1[1] + axis3.z * rotv1[2];
        double cos2f = p13 - p12 * p23;
        double sin2f = -det123;
        if (cos2f == 0.0 && sin2f == 0.0) {
            succes = false;
            return;
        }
        double scnorm = Math.sqrt(sin2f * sin2f + cos2f * cos2f);
        double rhs = (p3r1 - p12 * p23) / scnorm;
        if (rhs >= 1.000002) {
            succes = false;
            return;
        }
        if (rhs < -1.000002) {
            succes = false;
            return;
        }
        if (rhs >= 1.0) {
            rhs = 1.0;
        } else if (rhs < -1.0) {
            rhs = -1.0;
        }
        double b = Math.atan2(sin2f /= scnorm, cos2f /= scnorm);
        double amb = Math.acos(rhs);
        rot2p[0] = amb + b;
        if (rot2p[0] > Math.PI) {
            rot2p[0] = rot2p[0] - twopi;
        }
        if (rot2p[0] < -Math.PI) {
            rot2p[0] = rot2p[0] + twopi;
        }
        rot2p[1] = -amb + b;
        if (rot2p[1] > Math.PI) {
            rot2p[1] = rot2p[1] - twopi;
        }
        if (rot2p[1] < -Math.PI) {
            rot2p[1] = rot2p[1] + twopi;
        }
        double rot3o = rot.z;
        perp1[0] = axis1.y * axis2.z - axis1.z * axis2.y;
        perp1[1] = axis1.z * axis2.x - axis1.x * axis2.z;
        perp1[2] = axis1.x * axis2.y - axis1.y * axis2.x;
        double perp1n = Math.sqrt(perp1[0] * perp1[0] + perp1[1] * perp1[1] + perp1[2] * perp1[2]);
        if (perp1n <= 0.0) {
            succes = false;
            return;
        }
        perp1[0] = perp1[0] / perp1n;
        perp1[1] = perp1[1] / perp1n;
        perp1[2] = perp1[2] / perp1n;
        int isol = 1;
        while (isol <= 2) {
            double sinr2 = Math.sin(rot2p[isol - 1]);
            double cosr2 = Math.cos(rot2p[isol - 1]);
            this.rotaxi(sinr2, cosr2, axis2, false, new double[]{axis1.x, axis1.y, axis1.z}, rot2v1);
            double pr23 = rot2v1[0] * axis3.x + rot2v1[1] * axis3.y + rot2v1[2] * axis3.z;
            rotv1p[0] = rotv1[0] - pr23 * axis3.x;
            rotv1p[1] = rotv1[1] - pr23 * axis3.y;
            rotv1p[2] = rotv1[2] - pr23 * axis3.z;
            rot2v1[0] = rot2v1[0] - pr23 * axis3.x;
            rot2v1[1] = rot2v1[1] - pr23 * axis3.y;
            rot2v1[2] = rot2v1[2] - pr23 * axis3.z;
            double rnorm = rotv1p[0] * rotv1p[0] + rotv1p[1] * rotv1p[1] + rotv1p[2] * rotv1p[2];
            if (rnorm <= 0.0) {
                rot3p[isol - 1] = 0.0;
            } else {
                double cosr3 = (rotv1p[0] * rot2v1[0] + rotv1p[1] * rot2v1[1] + rotv1p[2] * rot2v1[2]) / rnorm;
                double sinr3 = (rot2v1[0] * rotv1p[1] * axis3.z - rot2v1[2] * rotv1p[1] * axis3.x + rot2v1[1] * rotv1p[2] * axis3.x - rot2v1[0] * rotv1p[2] * axis3.y + rot2v1[2] * rotv1p[0] * axis3.y - rot2v1[1] * rotv1p[0] * axis3.z) / rnorm;
                rot3p[isol - 1] = Math.atan2(sinr3, cosr3);
                if (rot3p[isol - 1] > Math.PI) {
                    rot3p[isol - 1] = rot3p[isol - 1] - twopi;
                }
            }
            double sinr2m = Math.sin(-rot2p[isol - 1]);
            double cosr2m = Math.cos(-rot2p[isol - 1]);
            double sinr3m = Math.sin(-rot3p[isol - 1]);
            double cosr3m = Math.cos(-rot3p[isol - 1]);
            int j = 1;
            while (j <= 3) {
                double[] vin = new double[3];
                double[] vout = new double[3];
                rotmat.getColumn(j - 1, vin);
                this.rotaxi(sinr3m, cosr3m, axis3, false, vin, vout);
                this.rotaxi(sinr2m, cosr2m, axis2, false, vout, vin);
                rotm1.setColumn(j - 1, vin);
                ++j;
            }
            rotm1p[0] = rotm1.getElement(0, 0) * perp1[0] + rotm1.getElement(0, 1) * perp1[1] + rotm1.getElement(0, 2) * perp1[2];
            rotm1p[1] = rotm1.getElement(1, 0) * perp1[0] + rotm1.getElement(1, 1) * perp1[1] + rotm1.getElement(1, 2) * perp1[2];
            rotm1p[2] = rotm1.getElement(2, 0) * perp1[0] + rotm1.getElement(2, 1) * perp1[1] + rotm1.getElement(2, 2) * perp1[2];
            double cosr1 = perp1[0] * rotm1p[0] + perp1[1] * rotm1p[1] + perp1[2] * rotm1p[2];
            double sinr1 = perp1[0] * rotm1p[1] * axis1.z - perp1[2] * rotm1p[1] * axis1.x + perp1[1] * rotm1p[2] * axis1.x - perp1[0] * rotm1p[2] * axis1.y + perp1[2] * rotm1p[0] * axis1.y - perp1[1] * rotm1p[0] * axis1.z;
            rot1p[isol - 1] = Math.atan2(sinr1, cosr1);
            sumdif[isol - 1] = this.dif2pi(rot.x, rot1p[isol - 1]) * this.dif2pi(rot.x, rot1p[isol - 1]) + this.dif2pi(rot.y, rot2p[isol - 1]) * this.dif2pi(rot.y, rot2p[isol - 1]) + this.dif2pi(rot.z, rot3p[isol - 1]) * this.dif2pi(rot.z, rot3p[isol - 1]);
            ++isol;
        }
        if (sumdif[0] < sumdif[1]) {
            rot.x = rot1p[0];
            rot.y = rot2p[0];
            rot.z = rot3p[0];
        } else {
            rot.x = rot1p[1];
            rot.y = rot2p[1];
            rot.z = rot3p[1];
        }
        succes = true;
    }

    public void rotaxi(double sinang, double cosang, Vector3d axis, boolean nder, double[] vecin, double[] vecout) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double csr = cosang;
        double vcr = 1.0 - csr;
        double snr = sinang;
        if (!nder) {
            x = (vcr * axis.x * axis.x + csr) * vecin[0] + (vcr * axis.x * axis.y - snr * axis.z) * vecin[1] + (vcr * axis.x * axis.z + snr * axis.y) * vecin[2];
            y = (vcr * axis.y * axis.x + snr * axis.z) * vecin[0] + (vcr * axis.y * axis.y + csr) * vecin[1] + (vcr * axis.y * axis.z - snr * axis.x) * vecin[2];
            z = (vcr * axis.z * axis.x - snr * axis.y) * vecin[0] + (vcr * axis.z * axis.y + snr * axis.x) * vecin[1] + (vcr * axis.z * axis.z + csr) * vecin[2];
        }
        vecout[0] = x;
        vecout[1] = y;
        vecout[2] = z;
    }

    public void write_gnsdef(String gnsfile, Vector3d[] par) {
        PrintfFormat gnsFmt = new PrintfFormat("# Data for GNS program (note all in fixed format)\n# Definition of goniostat\n#XXXX.xxxxxXXXX.xxxxxXXXX.xxxxx\n    1.00000   0.00000   0.00000     # Source vector s0\n#cccccccccXXXX.xxxxxXXXX.xxxxxXXXX.xxxxx\nOmega       %8.5f  %8.5f  %8.5f\nKappa       %8.5f  %8.5f  %8.5f   # sin alpha 0 cos alpha\nPhi         %8.5f  %8.5f  %8.5f\nKappaTrans  %8.5f  %8.5f  %8.5f\nPhiTrans    %8.5f  %8.5f  %8.5f\nKappaTransD %8.5f  %8.5f  %8.5f\nPhiTransD   %8.5f  %8.5f  %8.5f\n");
        try {
            FileWriter gnsdef = new FileWriter(gnsfile);
            gnsdef.write("#   Generated by GNSDEF Calibrator (from Sandor Brockhauser)\n");
            Object[] params = new Double[par.length * 3];
            int i = 0;
            while (i < par.length) {
                params[i * 3 + 0] = new Double(par[i].x);
                params[i * 3 + 1] = new Double(par[i].y);
                params[i * 3 + 2] = new Double(par[i].z);
                ++i;
            }
            gnsdef.write(gnsFmt.sprintf(params));
            gnsdef.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void Denzo2GNS(Matrix3d mat) {
        Matrix3d denzo2gns = new Matrix3d(new double[]{0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0});
        mat.mul(denzo2gns);
    }

    public void GNS2Denzo(Matrix3d mat) {
        Matrix3d denzo2gns = new Matrix3d(new double[]{0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0});
        denzo2gns.invert();
        mat.mul(denzo2gns, mat);
    }

    public void GenerateEquivalentMatrices(Matrix3d OM, Vector VecEq) {
        Matrix3d ActualNT = new Matrix3d();
        Vector3d ActualUVW = new Vector3d();
        Vector3d ActualVec = new Vector3d();
        boolean[] len_as = new boolean[27];
        boolean[] len_bs = new boolean[27];
        boolean[] len_cs = new boolean[27];
        double lenSqrtLimitPercent = 0.01;
        Vector3d v = new Vector3d();
        OM.getColumn(0, v);
        double lenas = v.lengthSquared();
        OM.getColumn(1, v);
        double lenbs = v.lengthSquared();
        OM.getColumn(2, v);
        double lencs = v.lengthSquared();
        Vector3d uvw = new Vector3d();
        Vector3d newabc = new Vector3d();
        int col = 0;
        uvw.x = -1.0;
        while (uvw.x <= 1.0) {
            uvw.y = -1.0;
            while (uvw.y <= 1.0) {
                uvw.z = -1.0;
                while (uvw.z <= 1.0) {
                    OM.transform((Tuple3d)uvw, (Tuple3d)newabc);
                    double newabclen = newabc.lengthSquared();
                    len_as[col] = Math.abs(newabclen - lenas) <= lenas * lenSqrtLimitPercent;
                    len_bs[col] = Math.abs(newabclen - lenbs) <= lenbs * lenSqrtLimitPercent;
                    len_cs[col] = Math.abs(newabclen - lencs) <= lencs * lenSqrtLimitPercent;
                    uvw.z += 1.0;
                    ++col;
                }
                uvw.y += 1.0;
            }
            uvw.x += 1.0;
        }
        int col1 = 0;
        ActualNT.m00 = -1.0;
        while (ActualNT.m00 <= 1.0) {
            ActualNT.m10 = -1.0;
            while (ActualNT.m10 <= 1.0) {
                ActualNT.m20 = -1.0;
                while (ActualNT.m20 <= 1.0) {
                    if (len_as[col1]) {
                        int col2 = 0;
                        ActualNT.m01 = -1.0;
                        while (ActualNT.m01 <= 1.0) {
                            ActualNT.m11 = -1.0;
                            while (ActualNT.m11 <= 1.0) {
                                ActualNT.m21 = -1.0;
                                while (ActualNT.m21 <= 1.0) {
                                    if (len_bs[col2]) {
                                        int col3 = 0;
                                        ActualNT.m02 = -1.0;
                                        while (ActualNT.m02 <= 1.0) {
                                            ActualNT.m12 = -1.0;
                                            while (ActualNT.m12 <= 1.0) {
                                                ActualNT.m22 = -1.0;
                                                while (ActualNT.m22 <= 1.0) {
                                                    if (len_cs[col3] && ActualNT.determinant() == 1.0) {
                                                        Matrix3d ActualOM = new Matrix3d(ActualNT);
                                                        VecEq.addElement(ActualOM);
                                                    }
                                                    ActualNT.m22 += 1.0;
                                                    ++col3;
                                                }
                                                ActualNT.m12 += 1.0;
                                            }
                                            ActualNT.m02 += 1.0;
                                        }
                                    }
                                    ActualNT.m21 += 1.0;
                                    ++col2;
                                }
                                ActualNT.m11 += 1.0;
                            }
                            ActualNT.m01 += 1.0;
                        }
                    }
                    ActualNT.m20 += 1.0;
                    ++col1;
                }
                ActualNT.m10 += 1.0;
            }
            ActualNT.m00 += 1.0;
        }
    }

    public void CalculateRotation(Matrix3d m, AxisAngle4d aa, double eps) {
        double s;
        Matrix3d a = new Matrix3d(m);
        a.normalize();
        double trace = a.m00 + a.m11 + a.m22 + 1.0;
        Quat4d q1 = new Quat4d();
        if (trace > eps) {
            s = 0.5 / Math.sqrt(trace);
            q1.w = 0.25 / s;
            q1.x = (a.m21 - a.m12) * s;
            q1.y = (a.m02 - a.m20) * s;
            q1.z = (a.m10 - a.m01) * s;
        } else if (a.m00 > a.m11 && a.m00 > a.m22) {
            s = 2.0 * Math.sqrt(1.0 + a.m00 - a.m11 - a.m22);
            q1.x = 0.25 * s;
            q1.y = (a.m01 + a.m10) / s;
            q1.z = (a.m02 + a.m20) / s;
            q1.w = (a.m12 - a.m21) / s;
        } else if (a.m11 > a.m22) {
            s = 2.0 * Math.sqrt(1.0 + a.m11 - a.m00 - a.m22);
            q1.x = (a.m01 + a.m10) / s;
            q1.y = 0.25 * s;
            q1.z = (a.m12 + a.m21) / s;
            q1.w = (a.m02 - a.m20) / s;
        } else {
            s = 2.0 * Math.sqrt(1.0 + a.m22 - a.m00 - a.m11);
            q1.x = (a.m02 + a.m20) / s;
            q1.y = (a.m12 + a.m21) / s;
            q1.z = 0.25 * s;
            q1.w = (a.m01 - a.m10) / s;
        }
        if (q1.w > 1.0) {
            q1.normalize();
        }
        aa.angle = 2.0 * Math.acos(q1.w);
        s = Math.sqrt(1.0 - q1.w * q1.w);
        if (s < 0.001) {
            aa.x = q1.x;
            aa.y = q1.y;
            aa.z = q1.z;
        } else {
            aa.x = q1.x / s;
            aa.y = q1.y / s;
            aa.z = q1.z / s;
        }
    }

    public double dif2pi(double a, double b) {
        double dif2piv = a - b;
        if (dif2piv > Math.PI) {
            dif2piv = Math.PI * 2 - dif2piv;
        } else if (dif2piv < -Math.PI) {
            dif2piv += Math.PI * -2;
        }
        return dif2piv;
    }

    public double angleDegreeDiff(double a, double b) {
        double dif2piv = a - b;
        if (dif2piv < 0.0) {
            dif2piv *= -1.0;
            dif2piv -= (double)((int)(dif2piv / 360.0)) * 360.0;
            dif2piv = 360.0 - dif2piv;
        } else {
            dif2piv -= (double)((int)(dif2piv / 360.0)) * 360.0;
        }
        if (dif2piv > 180.0) {
            dif2piv = -(360.0 - dif2piv);
        }
        return dif2piv;
    }

    public double angleInRange(double a, double b) {
        double dif2piv = a - b;
        double range = 360.0;
        int ct = (int)(dif2piv / range);
        if (dif2piv < 0.0) {
            --ct;
        }
        dif2piv -= (double)ct * range;
        return dif2piv += b;
    }

    public double sine(double cosang) {
        return Math.sqrt(1.0 - cosang * cosang);
    }

    public void mkbmat(double[] cell, Matrix3d bmat, double lamda) {
        int[] laxs = new int[3];
        int[] laxv = new int[]{1, 2, 3};
        double[] parm = new double[9];
        double[] star = new double[9];
        double[] winkel = new double[3];
        double dg2rd = Math.atan(1.0) / 45.0;
        double aa = cell[0];
        double bb = cell[1];
        double cc = cell[2];
        double ca = Math.cos(cell[3] * dg2rd);
        double cb = Math.cos(cell[4] * dg2rd);
        double cg = Math.cos(cell[5] * dg2rd);
        double sa = Math.sin(cell[3] * dg2rd);
        double sb = Math.sin(cell[4] * dg2rd);
        double sg = Math.sin(cell[5] * dg2rd);
        double pv = Math.sqrt(1.0 - ca * ca - cb * cb - cg * cg + 2.0 * ca * cb * cg);
        star[0] = sa / (aa * pv);
        star[1] = sb / (bb * pv);
        star[2] = sg / (cc * pv);
        star[3] = (cb * cg - ca) / (sb * sg);
        star[4] = (cg * ca - cb) / (sg * sa);
        star[5] = (ca * cb - cg) / (sa * sb);
        int i = 3;
        while (i < 6) {
            star[i + 3] = this.sine(star[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            winkel[i] = Math.acos(star[i + 3]) / dg2rd;
            star[i] = star[i] * lamda;
            parm[i + 3] = star[i];
            parm[i + 6] = winkel[i] * dg2rd;
            ++i;
        }
        double pvstar = Math.sqrt(1.0 - star[3] * star[3] - star[4] * star[4] - star[5] * star[5] + 2.0 * star[3] * star[4] * star[5]);
        int lax = laxv[0];
        int lup = laxv[1];
        int lin = laxv[2];
        i = 0;
        while (i < 3) {
            laxs[i] = laxv[i] < 0 ? -1 : 1;
            ++i;
        }
        bmat.setElement(1, lax - 1, 0.0);
        bmat.setElement(2, lax - 1, 0.0);
        bmat.setElement(2, lup - 1, 0.0);
        bmat.setElement(0, lax - 1, star[-1 + lax] * (double)laxs[0]);
        bmat.setElement(0, lup - 1, star[-1 + lup] * star[2 + lin] * (double)laxs[0]);
        bmat.setElement(0, lin - 1, star[-1 + lin] * star[2 + lup] * (double)laxs[0]);
        bmat.setElement(1, lup - 1, star[-1 + lup] * star[5 + lin] * (double)laxs[1]);
        bmat.setElement(1, lin - 1, -star[-1 + lin] * (double)laxs[1] / star[5 + lin] * (star[2 + lup] * star[2 + lin] - star[2 + lax]));
        bmat.setElement(2, lin - 1, star[-1 + lin] / star[5 + lin] * (double)laxs[2] * pvstar);
    }

    public void denzo2mosflm_matrices_by_gonset(Matrix3d CA, double[] cell, double[] tcell, Matrix3d B, Matrix3d Bm1t, Matrix3d U, Matrix3d UB, Vector3d phixyz) {
        PrintfFormat sp;
        double[] corr_r;
        Stac_Out.println("Denzo Adz:");
        int i = 0;
        while (i < 3) {
            double[] corr_r2 = new double[3];
            CA.getRow(i, corr_r2);
            PrintfFormat sp2 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp2.sprintf(new Object[]{new Double(corr_r2[0]), new Double(corr_r2[1]), new Double(corr_r2[2])}));
            ++i;
        }
        this.dnzcel(CA, cell, tcell);
        Matrix3d Bdz = new Matrix3d();
        Stac_Out.print("        Real cell:");
        PrintfFormat sp3 = new PrintfFormat("%12.8lg %12.8lg %12.8lg %12.8lg %12.8lg %12.8lg");
        Stac_Out.println(sp3.sprintf(new Object[]{new Double(cell[0]), new Double(cell[1]), new Double(cell[2]), new Double(cell[3]), new Double(cell[4]), new Double(cell[5])}));
        Stac_Out.print("  Reciprocal cell:");
        sp3 = new PrintfFormat("%12.8lg %12.8lg %12.8lg %12.8lg %12.8lg %12.8lg");
        Stac_Out.println(sp3.sprintf(new Object[]{new Double(tcell[0]), new Double(tcell[1]), new Double(tcell[2]), new Double(tcell[3]), new Double(tcell[4]), new Double(tcell[5])}));
        this.dnzbmt(tcell, Bdz);
        Matrix3d Bdzm1 = new Matrix3d(Bdz);
        Bdzm1.invert();
        Matrix3d Udz = new Matrix3d(CA);
        Udz.mul(Bdzm1);
        Stac_Out.println("Denzo Umat:");
        int i2 = 0;
        while (i2 < 3) {
            corr_r = new double[3];
            Udz.getRow(i2, corr_r);
            sp = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp.sprintf(new Object[]{new Double(corr_r[0]), new Double(corr_r[1]), new Double(corr_r[2])}));
            ++i2;
        }
        this.dnzcnv(cell, CA, B, Bm1t, U, phixyz, UB);
        Stac_Out.println("Mosflm Umat:");
        i2 = 0;
        while (i2 < 3) {
            corr_r = new double[3];
            U.getRow(i2, corr_r);
            sp = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp.sprintf(new Object[]{new Double(corr_r[0]), new Double(corr_r[1]), new Double(corr_r[2])}));
            ++i2;
        }
        Stac_Out.print("     phixyz:");
        PrintfFormat sp4 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
        Stac_Out.println(sp4.sprintf(new Object[]{new Double(phixyz.x), new Double(phixyz.y), new Double(phixyz.z)}));
    }

    public void get_matrices_by_gonset(String infile, Vector3d phixyz) {
        String corr = this.opReadCl(infile);
        String[] tmp = corr.split("\n");
        Matrix3d CA = new Matrix3d();
        Matrix3d C = new Matrix3d();
        int l = 0;
        while (l < 3) {
            Vector par = this.map("double", tmp[l + 1].split("\\s+"));
            CA.setElement(l, 0, ((Double)par.elementAt(0)).doubleValue());
            CA.setElement(l, 1, ((Double)par.elementAt(1)).doubleValue());
            CA.setElement(l, 2, ((Double)par.elementAt(2)).doubleValue());
            C.setElement(l, 0, ((Double)par.elementAt(3)).doubleValue());
            C.setElement(l, 1, ((Double)par.elementAt(4)).doubleValue());
            C.setElement(l, 2, ((Double)par.elementAt(5)).doubleValue());
            ++l;
        }
        double[] cell = new double[6];
        double[] tcell = new double[6];
        Matrix3d B = new Matrix3d();
        Matrix3d Bm1t = new Matrix3d();
        Matrix3d U = new Matrix3d();
        Matrix3d UB = new Matrix3d();
        this.denzo2mosflm_matrices_by_gonset(CA, cell, tcell, B, Bm1t, U, UB, phixyz);
    }

    public void read_gnsdef(String gnsfile, Vector3d[] okp) {
        String corr = this.opReadCl(gnsfile);
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < 7) {
            okp[l] = new Vector3d();
            ++l;
        }
        Vector3d s0 = new Vector3d();
        int l2 = 0;
        int out = 0;
        while (out < 8 && l2 < tmp1.length) {
            if (!tmp1[l2].startsWith("#", 0)) {
                String[] tmp2 = tmp1[l2].split("\\s+");
                ++out;
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if (out == 1) {
                    s0.x = new Double(tmp2[0 + offset]);
                    s0.y = new Double(tmp2[1 + offset]);
                    s0.z = new Double(tmp2[2 + offset]);
                } else {
                    okp[out - 2].x = new Double(tmp2[1 + offset]);
                    okp[out - 2].y = new Double(tmp2[2 + offset]);
                    okp[out - 2].z = new Double(tmp2[3 + offset]);
                }
            }
            ++l2;
        }
    }

    public void change_denzo_matrices_by_gonset(StacBCM bcm, String infile, double omega, double omegaCurrent, double kappa, double kappaCurrent, double phi, double phiCurrent, String outfile) {
        try {
            PrintfFormat sp;
            double[] corr_r;
            ParamTable pTable = new ParamTable();
            this.read_denzo_x(infile, pTable);
            pTable.dump();
            Matrix3d CA = new Matrix3d(pTable.getDoubleVector("Amat"));
            Matrix3d C = new Matrix3d(pTable.getDoubleVector("Umat"));
            double[] cell = new double[6];
            double[] tcell = new double[6];
            Stac_Out.println("Denzo Adz:");
            int i = 0;
            while (i < 3) {
                double[] corr_r2 = new double[3];
                CA.getRow(i, corr_r2);
                PrintfFormat sp2 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
                Stac_Out.println(sp2.sprintf(new Object[]{new Double(corr_r2[0]), new Double(corr_r2[1]), new Double(corr_r2[2])}));
                ++i;
            }
            this.dnzcel(CA, cell, tcell);
            Matrix3d Bdz = new Matrix3d();
            Stac_Out.print("        Real cell:");
            PrintfFormat sp3 = new PrintfFormat("%12.8lg %12.8lg %12.8lg %12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp3.sprintf(new Object[]{new Double(cell[0]), new Double(cell[1]), new Double(cell[2]), new Double(cell[3]), new Double(cell[4]), new Double(cell[5])}));
            Stac_Out.print("  Reciprocal cell:");
            sp3 = new PrintfFormat("%12.8lg %12.8lg %12.8lg %12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp3.sprintf(new Object[]{new Double(tcell[0]), new Double(tcell[1]), new Double(tcell[2]), new Double(tcell[3]), new Double(tcell[4]), new Double(tcell[5])}));
            this.dnzbmt(tcell, Bdz);
            Matrix3d Bdzm1 = new Matrix3d(Bdz);
            Bdzm1.invert();
            Matrix3d Udz = new Matrix3d(CA);
            Udz.mul(Bdzm1);
            Stac_Out.println("Denzo Umat:");
            int i2 = 0;
            while (i2 < 3) {
                double[] corr_r3 = new double[3];
                Udz.getRow(i2, corr_r3);
                PrintfFormat sp4 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
                Stac_Out.println(sp4.sprintf(new Object[]{new Double(corr_r3[0]), new Double(corr_r3[1]), new Double(corr_r3[2])}));
                ++i2;
            }
            Matrix3d B = new Matrix3d();
            Matrix3d Bm1t = new Matrix3d();
            Matrix3d U = new Matrix3d();
            Matrix3d UB = new Matrix3d();
            Vector3d phixyz = new Vector3d();
            this.dnzcnv(cell, CA, B, Bm1t, U, phixyz, UB);
            Stac_Out.println("Mosflm Umat:");
            int i3 = 0;
            while (i3 < 3) {
                double[] corr_r4 = new double[3];
                U.getRow(i3, corr_r4);
                PrintfFormat sp5 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
                Stac_Out.println(sp5.sprintf(new Object[]{new Double(corr_r4[0]), new Double(corr_r4[1]), new Double(corr_r4[2])}));
                ++i3;
            }
            Stac_Out.print("     phixyz:");
            PrintfFormat sp6 = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
            Stac_Out.println(sp6.sprintf(new Object[]{new Double(phixyz.x), new Double(phixyz.y), new Double(phixyz.z)}));
            Matrix3d C2 = new Matrix3d();
            Matrix3d C2A = new Matrix3d();
            Vector3d[] okp = new Vector3d[7];
            bcm.getCalibration(okp);
            Stac_Out.println("omega: " + omega + "; omegaC: " + omegaCurrent + "\nkappa: " + kappa + "; kappaC: " + kappaCurrent + "\nphi  : " + phi + "; phiC  : " + phiCurrent);
            AxisAngle4d axisRotOmegaBack = new AxisAngle4d(okp[0], -omegaCurrent / 180.0 * Math.PI);
            AxisAngle4d axisRotKappaBack = new AxisAngle4d(okp[1], -kappaCurrent / 180.0 * Math.PI);
            AxisAngle4d axisRotPhiBack = new AxisAngle4d(okp[2], -phiCurrent / 180.0 * Math.PI);
            AxisAngle4d axisRotOmega = new AxisAngle4d(okp[0], omega / 180.0 * Math.PI);
            AxisAngle4d axisRotKappa = new AxisAngle4d(okp[1], kappa / 180.0 * Math.PI);
            AxisAngle4d axisRotPhi = new AxisAngle4d(okp[2], phi / 180.0 * Math.PI);
            Matrix3d RotOmegaBack = new Matrix3d();
            RotOmegaBack.setIdentity();
            Matrix3d RotKappaBack = new Matrix3d();
            RotKappaBack.set(axisRotKappaBack);
            Matrix3d RotPhiBack = new Matrix3d();
            RotPhiBack.set(axisRotPhiBack);
            Matrix3d RotOmega = new Matrix3d();
            pTable.setSingleDoubleValue("phi_init", omega);
            RotOmega.setIdentity();
            Matrix3d RotKappa = new Matrix3d();
            RotKappa.set(axisRotKappa);
            Matrix3d RotPhi = new Matrix3d();
            RotPhi.set(axisRotPhi);
            Matrix3d ActRot = new Matrix3d(RotOmega);
            ActRot.mul(RotKappa);
            ActRot.mul(RotPhi);
            ActRot.mul(RotPhiBack);
            ActRot.mul(RotKappaBack);
            ActRot.mul(RotOmegaBack);
            Matrix3d denzo2gns = new Matrix3d(new double[]{0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0});
            Matrix3d ActRot2 = new Matrix3d();
            ActRot2.mul(denzo2gns, C);
            Stac_Out.println("C matrix in gns space (should be Umat in Mosflm?):");
            int i4 = 0;
            while (i4 < 3) {
                corr_r = new double[3];
                ActRot2.getRow(i4, corr_r);
                sp = new PrintfFormat("%9.5lg %9.5lg %9.5lg");
                Stac_Out.println(sp.sprintf(new Object[]{new Double(corr_r[0]), new Double(corr_r[1]), new Double(corr_r[2])}));
                ++i4;
            }
            ActRot.mul(denzo2gns);
            denzo2gns.invert();
            ActRot.mul(denzo2gns, ActRot);
            Stac_Out.println("Final ActRot:");
            i4 = 0;
            while (i4 < 3) {
                corr_r = new double[3];
                ActRot.getRow(i4, corr_r);
                sp = new PrintfFormat("%12.8lg %12.8lg %12.8lg");
                Stac_Out.println(sp.sprintf(new Object[]{new Double(corr_r[0]), new Double(corr_r[1]), new Double(corr_r[2])}));
                ++i4;
            }
            C2.mul(ActRot, C);
            C2A.mul(ActRot, CA);
            pTable.setDoubleValueList("Amat", new double[]{C2A.m00, C2A.m01, C2A.m02, C2A.m10, C2A.m11, C2A.m12, C2A.m20, C2A.m21, C2A.m22});
            pTable.setDoubleValueList("Umat", new double[]{C2.m00, C2.m01, C2.m02, C2.m10, C2.m11, C2.m12, C2.m20, C2.m21, C2.m22});
            i4 = 0;
            while (i4 < 1) {
                boolean image_num = true;
                pTable.setSingleDoubleValue("phi_end", pTable.getFirstDoubleValue("phi_init") + (double)image_num * pTable.getFirstDoubleValue("delta_phi"));
                pTable.setSingleDoubleValue("phi_start", pTable.getFirstDoubleValue("phi_end") - pTable.getFirstDoubleValue("delta_phi"));
                FFormat FMT = new FFormat();
                String hklxy_str = "";
                this.write_dotx("DENZOMANIPULATOR_GS", pTable, FMT, outfile, hklxy_str);
                ++i4;
            }
        }
        catch (Exception ex1) {
            Stac_Out.println(" ERROR!");
        }
    }

    public void read_denzo_x(String infname, ParamTable pTable) {
        try {
            pTable.clear();
            String corr = this.opReadCl(infname);
            String[] tmp = corr.split("\n");
            Matrix3d CA = new Matrix3d();
            Matrix3d C = new Matrix3d();
            int l = 0;
            while (l < 3) {
                Vector par = this.map("double", tmp[l + 1].split("\\s+"));
                CA.setElement(l, 0, ((Double)par.elementAt(0)).doubleValue());
                CA.setElement(l, 1, ((Double)par.elementAt(1)).doubleValue());
                CA.setElement(l, 2, ((Double)par.elementAt(2)).doubleValue());
                C.setElement(l, 0, ((Double)par.elementAt(3)).doubleValue());
                C.setElement(l, 1, ((Double)par.elementAt(4)).doubleValue());
                C.setElement(l, 2, ((Double)par.elementAt(5)).doubleValue());
                ++l;
            }
            pTable.setDoubleValueList("Amat", new double[]{CA.m00, CA.m01, CA.m02, CA.m10, CA.m11, CA.m12, CA.m20, CA.m21, CA.m22});
            pTable.setDoubleValueList("Umat", new double[]{C.m00, C.m01, C.m02, C.m10, C.m11, C.m12, C.m20, C.m21, C.m22});
            Vector par = this.map("double", tmp[4].substring(0, 87).split("\\s+"));
            pTable.setSingleValue("phi_start", ((Vector)this.getXpar(corr, "oscillation start", 15, "double")).elementAt(0));
            pTable.setSingleValue("phi_end", ((Vector)this.getXpar(corr, " end ", 15, "double")).elementAt(0));
            pTable.setSingleValue("phi_init", ((Vector)this.getXpar(corr, "oscillation start", 15, "double")).elementAt(0));
            pTable.setSingleDoubleValue("delta_phi", pTable.getFirstDoubleValue("phi_end") - pTable.getFirstDoubleValue("phi_start"));
            pTable.setSingleValue("distance_pix", par.elementAt(2));
            pTable.setSingleValue("crystal_rotz", par.elementAt(4));
            pTable.setSingleValue("crystal_roty", par.elementAt(5));
            pTable.setSingleValue("crystal_rotx", par.elementAt(6));
            pTable.setSingleValue("wavelength", ((Vector)this.getXpar(corr, "wavelength", 15, "double")).elementAt(0));
            pTable.setSingleValue("mosaicity", ((Vector)this.getXpar(corr, "mosaicity", 15, "double")).elementAt(0));
            pTable.setSingleValue("spot_radius", ((Vector)this.getXpar(corr, "spot ", 25, "double")).elementAt(0));
            pTable.setSingleValue("background_radius", ((Vector)this.getXpar(corr, "background ", 25, "double")).elementAt(0));
            int spot_radius = 6;
            int bkg_radius = spot_radius + 1;
            pTable.setSingleDoubleValue("boxe_size_x", (spot_radius + 3) * 2);
            pTable.setSingleDoubleValue("boxe_size_y", (spot_radius + 3) * 2);
            pTable.setSingleValue("spot_profile", this.spot_profile((int)pTable.getFirstDoubleValue("boxe_size_x"), (int)pTable.getFirstDoubleValue("boxe_size_y"), bkg_radius, spot_radius));
            pTable.setSingleValue("resolution_limits", corr.substring(corr.indexOf("resolution limits  ") + "resolution limits  ".length(), corr.indexOf("resolution limits") + 80).split("\n")[0]);
            pTable.setSingleValue("monochromator", ((Vector)this.getXpar(corr, "monochromator", 15, "double")).elementAt(0));
            pTable.setSingleValue("cell", corr.substring(corr.indexOf("unit cell   ") + "unit cell   ".length(), corr.indexOf("unit cell") + 80).split("\n")[0]);
            pTable.setSingleValue("image_template", corr.substring(corr.indexOf("raw data file"), corr.indexOf("raw data file") + 100).split("'")[1]);
            pTable.setSingleValue("detector", corr.substring(corr.indexOf("format ") + "format ".length(), corr.indexOf("format") + 80).split("\n")[0]);
            pTable.setSingleValue("spg", ((Vector)this.getXpar(corr, "space group", 80, "string")).elementAt(0));
            pTable.setSingleValue("cassette_rotz", ((Vector)this.getXpar(corr.substring(corr.indexOf("cassette"), corr.indexOf("cassette") + 80), "rotz", 15, "double")).elementAt(0));
            pTable.setSingleValue("distance_mm", ((Vector)this.getXpar(corr, "distance", 15, "double")).elementAt(0));
            pTable.setSingleValue("beam_x", ((Vector)this.getXpar(corr, "x beam", 15, "double")).elementAt(0));
            pTable.setSingleValue("beam_y", ((Vector)this.getXpar(corr, "y beam", 15, "double")).elementAt(0));
            pTable.setSingleValue("film_rotation", ((Vector)this.getXpar(corr, "film rotation", 15, "double")).elementAt(0));
        }
        catch (Exception ex1) {
            Stac_Out.println(" ERROR!");
        }
    }

    public double AlignmentRanking(Point3d trans, double omega, double kappa, double phi, StacBCM bcm, Matrix3d OMUB) {
        double rank = -1.0;
        if (bcm.checkDatumTrans(new Point3d(omega, kappa, phi), trans)) {
            Vector3d[] okp = new Vector3d[7];
            bcm.getCalibration(okp);
            Matrix3d osc = new Matrix3d();
            osc.set(new AxisAngle4d(okp[0], omega / 180.0 * Math.PI));
            OMUB.mul(osc, OMUB);
            rank = 0.0;
            int i = 0;
            while (i < 3) {
                Vector3d reciprocalVec = new Vector3d();
                OMUB.getColumn(i, reciprocalVec);
                double angle = reciprocalVec.angle(okp[0]);
                if (angle > 1.5707963267948966) {
                    angle = Math.PI - angle;
                }
                double lenFac = 1.0 / reciprocalVec.length();
                double actRank = (90.0 - (angle *= 57.29577951308232)) * lenFac;
                rank += (actRank - rank) / (double)(3 * i + 1);
                rank += (actRank - rank) / (double)(3 * i + 2);
                angle = reciprocalVec.angle(new Vector3d(1.0, 0.0, 0.0));
                if (angle > 1.5707963267948966) {
                    angle = Math.PI - angle;
                }
                lenFac = 1.0 / reciprocalVec.length();
                actRank = (90.0 - (angle *= 57.29577951308232)) * lenFac;
                rank += (actRank - rank) / (double)(3 * i + 3);
                ++i;
            }
        }
        return rank;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getOptAlign(String workDir) {
        try {
            omhkl = new Vector<String>(0);
            this.CallExternalStrategy_orig(workDir, "strategy_OptAlign.todo", "ALIGN ALL\nTURBO 10\n");
            outf = new FileInputStream("strategy.out");
            out = new TextReader(outf);
            compl = 999.0;
            h = 0.0;
            k = 0.0;
            l = 0.0;
            ang = 999.0;
            while (out.ready()) {
                block11: {
                    ln = out.getln();
                    if (compl == 999.0) {
                        if (!ln.startsWith("different starting orientations for") || !((c = new Double((ln = ln.substring("different starting orientations for".length())).split("%")[0]).doubleValue()) > 0.0) || !(c <= 100.0)) continue;
                        compl = c;
                        ang = 999.0;
                        continue;
                    }
                    try {
                        items = ln.split("\\s+");
                        off = 0;
                        if (items[0].length() == 0) {
                            ++off;
                        }
                        h1 = new Double(items[off + 0]);
                        k1 = new Double(items[off + 1]);
                        l1 = new Double(items[off + 2]);
                        cang = new Double(items[off + 6]);
                        if ((h1 != 0.0 || k1 != 0.0 || l1 != 0.0) && cang != 0.0) {
                            if (!(cang < ang)) continue;
                            ang = cang;
                            h = h1;
                            k = k1;
                            l = l1;
                            continue;
                        }
                        System.out.println((String)null);
                        continue;
                    }
                    catch (Exception e) {
                        if (!(ang < 999.0)) break block11;
                        actSolution = "(" + h + " " + k + " " + l + ")";
                        newSol = true;
                        i = 0;
                        ** while (i < omhkl.size() / 3)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (actSolution.equalsIgnoreCase((String)omhkl.elementAt(i * 3))) {
                            newSol = false;
                            break;
                        }
                        ++i;
                        continue;
                    }
lbl47:
                    // 2 sources

                    if (newSol) {
                        omhkl.addElement(actSolution);
                        omhkl.addElement("(" + (h == 0.0 ? 1 : 0) + " " + (k == 0.0 ? 1 : 0) + " " + (l == 0.0 ? 1 : 0) + ")");
                        omhkl.addElement("Optimal align for compl=" + compl);
                    }
                }
                compl = 999.0;
            }
            return omhkl;
        }
        catch (Exception ex1) {
            Stac_Out.println(" ERROR!");
            return null;
        }
    }

    public void CallExternalStrategy_orig(String options) {
        this.CallExternalStrategy_orig(".", "strategy.todo", options);
    }

    public void CallExternalStrategy_orig(String workDir, String todofile, String options) {
        try {
            ParamTable denzoTable = new ParamTable();
            this.read_denzo_x("name0.x", denzoTable);
            FileWriter dstStream = new FileWriter(todofile);
            dstStream.write(new PrintfFormat("XFILE name0.x\nCOMPLETENESS 100 99 98\nNBINS 10\nPSFILE auto_strategy.ps\nFORMAT %s\nSPACE GROUP %s\nRESOLUTION %s\n" + options).sprintf(new Object[]{this.detector_denzo2strategy(denzoTable.getFirstStringValue("detector")), denzoTable.getFirstValue("spg"), denzoTable.getFirstValue("resolution_limits")}));
            dstStream.flush();
            dstStream.close();
        }
        catch (IOException e) {
            Stac_Out.println("Problem with generating the strategy.todo file: " + todofile);
        }
        try {
            String osName = System.getProperty("os.name");
            String[] cmd = new String[3];
            String mycmd = new String("p:\\work\\dev\\STAC\\gonset\\argtest.exe sutike < argtest.log");
            if (osName.equals("Windows NT") || osName.equals("Windows XP")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else if (osName.equals("Windows 95")) {
                cmd[0] = "command.com";
                cmd[1] = "/C";
            } else {
                String cmdPre = new String("cd " + workDir + ";");
                cmdPre = cmdPre.concat("rm STAC_strategy.align;");
                mycmd = String.valueOf(cmdPre) + "$STACDIR/strategy/strategy < " + todofile;
                cmd[0] = "sh";
                cmd[1] = "-c";
            }
            cmd[2] = mycmd;
            Runtime rt = Runtime.getRuntime();
            Stac_Out.println("Executing " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            Process proc = rt.exec(cmd);
            int exitVal = 0;
            try {
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", "strategy.out");
                errorGobbler.start();
                outputGobbler.start();
                exitVal = proc.waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Stac_Out.println("Process exitValue: " + exitVal);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Vector orderMeasuredTransDataPoints(Vector data, boolean useOrigin) {
        Vector<AxisAngle4d> pointsOrdered = new Vector<AxisAngle4d>();
        double actualAngle = -1.0;
        double smallestAngle = 0.0;
        if (useOrigin) {
            pointsOrdered.addElement(new AxisAngle4d(0.0, 0.0, 0.0, 0.0));
            actualAngle = 0.0;
        }
        int i = 0;
        while (i < data.size()) {
            int nextPt = -1;
            smallestAngle = 370.0;
            int j = 0;
            while (j < data.size()) {
                double currangle = this.angleInRange(((AxisAngle4d)data.elementAt((int)j)).angle, 0.0);
                if (currangle > actualAngle && currangle < smallestAngle) {
                    smallestAngle = currangle;
                    nextPt = j;
                }
                ++j;
            }
            if (nextPt == -1) break;
            AxisAngle4d d = new AxisAngle4d();
            d.set((AxisAngle4d)data.elementAt(nextPt));
            pointsOrdered.addElement(d);
            actualAngle = smallestAngle;
            ++i;
        }
        return pointsOrdered;
    }

    public Vector3d calculateRegressionPlane(Vector data, boolean useOrigin) {
        Vector pointsOrdered = this.orderMeasuredTransDataPoints(data, useOrigin);
        return this.calculateRegressionPlane(pointsOrdered);
    }

    public Vector3d calculateRegressionPlane(Vector pointsOrdered) {
        Vector3d normal = new Vector3d();
        normal.set(0.0, 0.0, 0.0);
        if (pointsOrdered.size() <= 0) {
            return normal;
        }
        Vector3d prevV = new Vector3d();
        Vector3d fixPt = new Vector3d();
        Vector3d actPt = new Vector3d();
        actPt.x = ((AxisAngle4d)pointsOrdered.elementAt((int)0)).x;
        actPt.y = ((AxisAngle4d)pointsOrdered.elementAt((int)0)).y;
        actPt.z = ((AxisAngle4d)pointsOrdered.elementAt((int)0)).z;
        Vector3d newV = new Vector3d();
        int i = 0;
        while (i < pointsOrdered.size()) {
            newV.x = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).x;
            newV.y = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).y;
            newV.z = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).z;
            fixPt.add((Tuple3d)newV);
            ++i;
        }
        fixPt.scale((double)(1 / pointsOrdered.size()));
        prevV.sub((Tuple3d)actPt, (Tuple3d)fixPt);
        i = 1;
        while (i < pointsOrdered.size()) {
            actPt.x = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).x;
            actPt.y = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).y;
            actPt.z = ((AxisAngle4d)pointsOrdered.elementAt((int)i)).z;
            newV.sub((Tuple3d)actPt, (Tuple3d)fixPt);
            Vector3d actV = new Vector3d();
            actV.cross(prevV, newV);
            normal.add((Tuple3d)actV);
            prevV.set((Tuple3d)newV);
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public Vector3d calculateRegressionPlane_SVD(Vector pointsOrdered) {
        double smax;
        Vector3d normal = new Vector3d();
        double[][] data = new double[pointsOrdered.size()][3];
        int i = 0;
        while (i < pointsOrdered.size()) {
            ((AxisAngle4d)pointsOrdered.elementAt(i)).get(data[i]);
            ++i;
        }
        Matrix orig = new Matrix(data);
        SingularValueDecomposition svd = new SingularValueDecomposition(orig);
        double[] sigma = svd.getSingularValues();
        double smin = smax = sigma[0];
        int i2 = 1;
        while (i2 < sigma.length) {
            if (sigma[i2] > smax) {
                smax = sigma[i2];
            } else if (sigma[i2] < smin) {
                smin = sigma[i2];
            }
            ++i2;
        }
        Matrix u = svd.getU();
        Matrix v = svd.getV();
        int k = 0;
        while (k < 3) {
            double dp = 1.0 / sigma[k];
            int j = 0;
            while (j < u.getRowDimension()) {
                ++j;
            }
            ++k;
        }
        return normal;
    }

    public Vector3d calculateRegressionPlane_SVD2(Vector pointsOrdered) {
        double smax;
        int j;
        Vector3d normal = new Vector3d();
        double[][] data = new double[pointsOrdered.size()][4];
        double[][] dataNew = new double[pointsOrdered.size()][3];
        double[] centroid = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        while (i < pointsOrdered.size()) {
            ((AxisAngle4d)pointsOrdered.elementAt(i)).get(data[i]);
            j = 0;
            while (j < 3) {
                int n = j;
                centroid[n] = centroid[n] + data[i][j];
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < 3) {
            int n = j2++;
            centroid[n] = centroid[n] / (double)pointsOrdered.size();
        }
        i = 0;
        while (i < pointsOrdered.size()) {
            j = 0;
            while (j < 3) {
                dataNew[i][j] = data[i][j] - centroid[j];
                ++j;
            }
            ++i;
        }
        Matrix orig = new Matrix(dataNew);
        SingularValueDecomposition svd = new SingularValueDecomposition(orig);
        double[] sigma = svd.getSingularValues();
        double smin = smax = sigma[0];
        int sminIndex = 0;
        int i2 = 1;
        while (i2 < sigma.length) {
            if (sigma[i2] > smax) {
                smax = sigma[i2];
            } else if (sigma[i2] < smin) {
                sminIndex = i2;
                smin = sigma[i2];
            }
            ++i2;
        }
        Matrix v = svd.getV();
        normal.set(v.getMatrix(0, sminIndex, 2, sminIndex).getRowPackedCopy());
        int i3 = 0;
        while (i3 < pointsOrdered.size()) {
            double diff = normal.x * dataNew[i3][0] + normal.y * dataNew[i3][1] + normal.z * dataNew[i3][2];
            Stac_Out.println("Point (" + data[i3][3] + ";" + data[i3][0] + "," + data[i3][1] + "," + data[i3][2] + ") dist from regression plane: " + diff);
            ++i3;
        }
        Vector3d fixPt = new Vector3d();
        Vector3d actPt = new Vector3d();
        Vector3d prePt = new Vector3d();
        Vector3d newV = new Vector3d();
        Vector3d preV = new Vector3d();
        Vector3d actV = new Vector3d();
        fixPt.set(data[pointsOrdered.size() - 1]);
        actPt.set(data[pointsOrdered.size() / 2]);
        prePt.set(data[0]);
        preV.sub((Tuple3d)prePt, (Tuple3d)fixPt);
        newV.sub((Tuple3d)actPt, (Tuple3d)fixPt);
        actV.cross(preV, newV);
        if (actV.dot(normal) <= 0.0) {
            normal.scale(-1.0);
        }
        return normal;
    }

    public double calculatePointOnRotationAxis(Vector pointsOrdered, Vector3d rotAxis, Vector3d rotPt) {
        double recE = 0.0;
        if (pointsOrdered.size() < 2) {
            rotPt.set(0.0, 0.0, 0.0);
        } else if (pointsOrdered.size() == 2) {
            double phiRot = (((AxisAngle4d)pointsOrdered.elementAt((int)1)).angle - ((AxisAngle4d)pointsOrdered.elementAt((int)0)).angle) / 180.0 * Math.PI;
            Vector3d actTrans = new Vector3d(((AxisAngle4d)pointsOrdered.elementAt((int)1)).x - ((AxisAngle4d)pointsOrdered.elementAt((int)0)).x, ((AxisAngle4d)pointsOrdered.elementAt((int)1)).y - ((AxisAngle4d)pointsOrdered.elementAt((int)0)).y, ((AxisAngle4d)pointsOrdered.elementAt((int)1)).z - ((AxisAngle4d)pointsOrdered.elementAt((int)0)).z);
            if (actTrans.length() != 0.0) {
                Vector3d rot = new Vector3d(rotAxis);
                rot.normalize();
                if (Math.tan(-phiRot / 2.0) != 0.0) {
                    rotPt.cross(rotAxis, actTrans);
                    rotPt.normalize();
                    rotPt.scale(actTrans.length() / Math.tan(-phiRot / 2.0));
                } else {
                    rotPt.set((Tuple3d)actTrans);
                }
                rotPt.sub((Tuple3d)actTrans);
                rotPt.scale(0.5);
            } else {
                rotPt.set((Tuple3d)actTrans);
            }
            rotPt.sub((Tuple3d)new Vector3d(((AxisAngle4d)pointsOrdered.elementAt((int)0)).x, ((AxisAngle4d)pointsOrdered.elementAt((int)0)).y, ((AxisAngle4d)pointsOrdered.elementAt((int)0)).z));
        } else {
            Matrix3d rotZ = new Matrix3d();
            if (rotAxis.x != 0.0) {
                rotZ.rotZ((double)(rotAxis.x < 0.0 ? -1 : 1) * Math.acos(rotAxis.y / Math.sqrt(this.sqr(rotAxis.x) + this.sqr(rotAxis.y))));
            }
            Matrix3d rotX = new Matrix3d();
            if (rotAxis.x != 0.0 || rotAxis.y != 0.0) {
                rotX.rotX(Math.acos(rotAxis.z / Math.sqrt(this.sqr(rotAxis.x) + this.sqr(rotAxis.y) + this.sqr(rotAxis.z))));
            }
            Matrix3d trafo = new Matrix3d();
            trafo.mul(rotX, rotZ);
            Vector2d[] pts2d = new Vector2d[pointsOrdered.size()];
            int i = 0;
            while (i < pointsOrdered.size()) {
                Point3d pt = new Point3d(((AxisAngle4d)pointsOrdered.elementAt((int)i)).x, ((AxisAngle4d)pointsOrdered.elementAt((int)i)).y, ((AxisAngle4d)pointsOrdered.elementAt((int)i)).z);
                trafo.transform((Tuple3d)pt);
                pts2d[i] = new Vector2d(pt.x, pt.y);
                ++i;
            }
            Point3d avgPt = new Point3d(0.0, 0.0, 0.0);
            int i2 = 1;
            while (i2 < pts2d.length - 1) {
                double a1 = pts2d[i2].x - pts2d[i2 - 1].x;
                double b1 = pts2d[i2].y - pts2d[i2 - 1].y;
                double c1 = -a1 * (pts2d[i2].x + pts2d[i2 - 1].x) / 2.0 - b1 * (pts2d[i2].y + pts2d[i2 - 1].y) / 2.0;
                double a2 = pts2d[i2 + 1].x - pts2d[i2].x;
                double b2 = pts2d[i2 + 1].y - pts2d[i2].y;
                double c2 = -a2 * (pts2d[i2 + 1].x + pts2d[i2].x) / 2.0 - b2 * (pts2d[i2 + 1].y + pts2d[i2].y) / 2.0;
                if (a1 * b2 != a2 * b1) {
                    double x = -(c1 * b2 - c2 * b1) / (a1 * b2 - a2 * b1);
                    double y = -(c1 * a2 - c2 * a1) / (b1 * a2 - b2 * a1);
                    avgPt.x += (x - avgPt.x) / (double)i2;
                    avgPt.y += (y - avgPt.y) / (double)i2;
                }
                ++i2;
            }
            trafo.invert();
            trafo.transform((Tuple3d)avgPt);
            rotPt.set((Tuple3d)avgPt);
            rotPt.scale(-1.0);
        }
        recE = 0.0;
        Point3d actTrans = new Point3d(((AxisAngle4d)pointsOrdered.elementAt((int)0)).x, ((AxisAngle4d)pointsOrdered.elementAt((int)0)).y, ((AxisAngle4d)pointsOrdered.elementAt((int)0)).z);
        double actualRot = ((AxisAngle4d)pointsOrdered.elementAt((int)0)).angle;
        int i = 1;
        while (i < pointsOrdered.size()) {
            Point3d newTrans = new Point3d(actTrans);
            AxisAngle4d rot = new AxisAngle4d();
            Matrix3d rotMat = new Matrix3d();
            rot.set(rotAxis, (((AxisAngle4d)pointsOrdered.elementAt((int)i)).angle - actualRot) / 180.0 * Math.PI);
            rotMat.set(rot);
            newTrans.add((Tuple3d)rotPt);
            newTrans.scale(-1.0);
            rotMat.transform((Tuple3d)newTrans);
            newTrans.add((Tuple3d)rotPt);
            newTrans.scale(-1.0);
            Vector3d diffTrans = new Vector3d((Tuple3d)newTrans);
            diffTrans.sub((Tuple3d)new Point3d(((AxisAngle4d)pointsOrdered.elementAt((int)i)).x, ((AxisAngle4d)pointsOrdered.elementAt((int)i)).y, ((AxisAngle4d)pointsOrdered.elementAt((int)i)).z));
            if (diffTrans.length() > recE) {
                recE = diffTrans.length();
            }
            ++i;
        }
        return recE;
    }

    public Point3d CalculateTranslation(Point3d actTrans, double actualKappa, double Kappa, double actualPhi, double Phi, StacBCM bcm) {
        Point3d newTrans = new Point3d(actTrans);
        Vector3d[] okp = new Vector3d[7];
        bcm.getCalibration(okp);
        AxisAngle4d rot = new AxisAngle4d();
        Matrix3d rotMat = new Matrix3d();
        if (actualKappa != 0.0) {
            rot.set(okp[5], -actualKappa / 180.0 * Math.PI);
            rotMat.set(rot);
            newTrans.add((Tuple3d)okp[3]);
            newTrans.scale(-1.0);
            rotMat.transform((Tuple3d)newTrans);
            newTrans.add((Tuple3d)okp[3]);
            newTrans.scale(-1.0);
        }
        rot.set(okp[6], (Phi - actualPhi) / 180.0 * Math.PI);
        rotMat.set(rot);
        newTrans.add((Tuple3d)okp[4]);
        newTrans.scale(-1.0);
        rotMat.transform((Tuple3d)newTrans);
        newTrans.add((Tuple3d)okp[4]);
        newTrans.scale(-1.0);
        rot.set(okp[5], Kappa / 180.0 * Math.PI);
        rotMat.set(rot);
        newTrans.add((Tuple3d)okp[3]);
        newTrans.scale(-1.0);
        rotMat.transform((Tuple3d)newTrans);
        newTrans.add((Tuple3d)okp[3]);
        newTrans.scale(-1.0);
        return newTrans;
    }

    public String OMFileType(String filename) {
        File file = new File(filename);
        if (file.getAbsolutePath().endsWith(".x")) {
            return "denzo";
        }
        if (file.getAbsolutePath().endsWith(".mat")) {
            return "mosflm";
        }
        if (file.getAbsolutePath().endsWith(".LP")) {
            return "xds";
        }
        return "mosflm";
    }

    public ParamTable LoadOMDescriptorTable(String file, StacBCM bcm) {
        ParamTable omdesc = new ParamTable();
        try {
            double o = 0.0;
            double k = 0.0;
            double p = 0.0;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int fnd = 0;
            boolean omtypeIsSpecified = false;
            String corr = this.opReadCl(file);
            String[] tmp1 = corr.split("\n");
            int l = 0;
            while (l < tmp1.length) {
                String[] tmp2;
                if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                    int offset = 0;
                    if (tmp2[0].length() == 0) {
                        ++offset;
                    }
                    if (offset < tmp2.length) {
                        String value;
                        String name = tmp2[0 + offset];
                        if (name.equalsIgnoreCase("OMFILENAME")) {
                            value = tmp2[1 + offset];
                            omdesc.setSingleValue("OMFILENAME", value);
                            if (!omtypeIsSpecified) {
                                omdesc.setSingleValue("OMTYPE", this.OMFileType(value).toLowerCase());
                            }
                        } else if (name.equalsIgnoreCase("OMTYPE")) {
                            value = tmp2[1 + offset];
                            omtypeIsSpecified = true;
                            omdesc.setSingleValue("OMTYPE", value.toLowerCase());
                        } else {
                            value = tmp2[1 + offset];
                            if (name.equalsIgnoreCase("stac_omega")) {
                                o = new Double(value);
                                fnd |= 1;
                            } else if (name.equalsIgnoreCase("stac_kappa")) {
                                k = new Double(value);
                                fnd |= 2;
                            } else if (name.equalsIgnoreCase("stac_phi")) {
                                p = new Double(value);
                                fnd |= 4;
                            } else if (name.equalsIgnoreCase("stac_X")) {
                                x = new Double(value);
                                fnd |= 8;
                            } else if (name.equalsIgnoreCase("stac_Y")) {
                                y = new Double(value);
                                fnd |= 0x10;
                            } else if (name.equalsIgnoreCase("stac_Z")) {
                                z = new Double(value);
                                fnd |= 0x20;
                            }
                        }
                    }
                }
                ++l;
            }
            if (!(fnd & true)) {
                o = bcm.loadMotorPosition("Omega", corr);
            }
            if ((fnd & 2) == 0) {
                k = bcm.loadMotorPosition("Kappa", corr);
            }
            if ((fnd & 4) == 0) {
                p = bcm.loadMotorPosition("Phi", corr);
            }
            if ((fnd & 8) == 0) {
                x = bcm.loadMotorPosition("X", corr);
            }
            if ((fnd & 0x10) == 0) {
                y = bcm.loadMotorPosition("Y", corr);
            }
            if ((fnd & 0x20) == 0) {
                z = bcm.loadMotorPosition("Z", corr);
            }
            omdesc.setSingleValue("omega", new Double(o).toString());
            omdesc.setSingleValue("kappa", new Double(k).toString());
            omdesc.setSingleValue("phi", new Double(p).toString());
            omdesc.setSingleValue("X", new Double(x).toString());
            omdesc.setSingleValue("Y", new Double(y).toString());
            omdesc.setSingleValue("Z", new Double(z).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return omdesc;
    }

    public Vector getHKLforOrthogonalBeamAlignment(String v1, String v2, String fname, StacBCM bcm) {
        try {
            String OMfilename;
            Vector<String> omhkl = new Vector<String>(0);
            String OMtype = new String("mosflm");
            ParamTable omdesc = this.LoadOMDescriptorTable(fname, bcm);
            if (omdesc.getFirstStringValue("OMFILENAME") != null) {
                OMfilename = omdesc.getFirstStringValue("OMFILENAME");
                OMtype = omdesc.getFirstStringValue("OMTYPE");
            } else {
                OMfilename = fname;
                OMtype = this.OMFileType(OMfilename);
            }
            String MosflmSettingsFileName = "";
            if (OMtype.equalsIgnoreCase("mosflm")) {
                File inFile = new File(OMfilename);
                String my_dir = String.valueOf(inFile.getParent()) + File.separator;
                MosflmSettingsFileName = String.valueOf(my_dir) + "mosflm.inp";
            }
            this.ConvertInputFormat(OMfilename, MosflmSettingsFileName, OMtype, "OMhkl.x");
            double anglelimit = 1.0;
            double[] cell = new double[6];
            double[] tcell = new double[6];
            Matrix3d B = new Matrix3d();
            Matrix3d Bm1t = new Matrix3d();
            Matrix3d U = new Matrix3d();
            Vector3d phixyz = new Vector3d();
            Matrix3d osc = new Matrix3d();
            ParamTable OMT = new ParamTable();
            this.read_denzo_x("OMhkl.x", OMT);
            Matrix3d OMU = new Matrix3d(OMT.getDoubleVector("Amat"));
            Matrix3d OMA = new Matrix3d(OMT.getDoubleVector("Umat"));
            Matrix3d OMAi = new Matrix3d(OMA);
            OMAi.invert();
            Matrix3d OMUB = new Matrix3d(OMA);
            this.denzo2mosflm_matrices_by_gonset(OMU, cell, tcell, B, Bm1t, U, OMUB, phixyz);
            osc.set(new AxisAngle4d(0.0, 0.0, 1.0, OMT.getFirstDoubleValue("phi_start") / 180.0 * Math.PI));
            OMUB.mul(osc, OMUB);
            Stac_Out.println("OM hkl :\n" + OMUB.toString());
            Vector3d[] okp = new Vector3d[7];
            bcm.getCalibration(okp);
            Matrix3d OMUBinv = new Matrix3d(OMUB);
            OMUBinv.invert();
            Vector3d spindle = new Vector3d(okp[0]);
            OMUBinv.transform((Tuple3d)spindle);
            omhkl.addElement("(" + spindle.x + " " + spindle.y + " " + spindle.z + ")");
            Vector3d beam = new Vector3d(1.0, 0.0, 0.0);
            OMUBinv.transform((Tuple3d)beam);
            omhkl.addElement("(" + beam.x + " " + beam.y + " " + beam.z + ")");
            return omhkl;
        }
        catch (Exception ex1) {
            Stac_Out.println(" ERROR!");
            return null;
        }
    }

    public Vector getHKLfromOMFile(String fname, StacBCM bcm) {
        try {
            String OMfilename;
            Vector<String> omhkl = new Vector<String>(0);
            String OMtype = new String("mosflm");
            ParamTable omdesc = this.LoadOMDescriptorTable(fname, bcm);
            if (omdesc.getFirstStringValue("OMFILENAME") != null) {
                OMfilename = omdesc.getFirstStringValue("OMFILENAME");
                OMtype = omdesc.getFirstStringValue("OMTYPE");
            } else {
                OMfilename = fname;
                OMtype = this.OMFileType(OMfilename);
            }
            String MosflmSettingsFileName = "";
            if (OMtype.equalsIgnoreCase("mosflm")) {
                File inFile = new File(OMfilename);
                String my_dir = String.valueOf(inFile.getParent()) + File.separator;
                MosflmSettingsFileName = String.valueOf(my_dir) + "mosflm.inp";
            }
            this.ConvertInputFormat(OMfilename, MosflmSettingsFileName, OMtype, "OMhkl.x");
            double anglelimit = 1.0;
            double[] cell = new double[6];
            double[] tcell = new double[6];
            Matrix3d B = new Matrix3d();
            Matrix3d Bm1t = new Matrix3d();
            Matrix3d U = new Matrix3d();
            Vector3d phixyz = new Vector3d();
            Matrix3d osc = new Matrix3d();
            ParamTable OMT = new ParamTable();
            this.read_denzo_x("OMhkl.x", OMT);
            Matrix3d OMU = new Matrix3d(OMT.getDoubleVector("Amat"));
            Matrix3d OMA = new Matrix3d(OMT.getDoubleVector("Umat"));
            Matrix3d OMAi = new Matrix3d(OMA);
            OMAi.invert();
            Matrix3d OMUB = new Matrix3d(OMA);
            this.denzo2mosflm_matrices_by_gonset(OMU, cell, tcell, B, Bm1t, U, OMUB, phixyz);
            osc.set(new AxisAngle4d(0.0, 0.0, 1.0, OMT.getFirstDoubleValue("phi_start") / 180.0 * Math.PI));
            OMUB.mul(osc, OMUB);
            Stac_Out.println("OM hkl :\n" + OMUB.toString());
            Vector3d[] okp = new Vector3d[7];
            bcm.getCalibration(okp);
            Matrix3d OMUBinv = new Matrix3d(OMUB);
            OMUBinv.invert();
            Vector3d spindle = new Vector3d(okp[0]);
            OMUBinv.transform((Tuple3d)spindle);
            omhkl.addElement("(" + spindle.x + " " + spindle.y + " " + spindle.z + ")");
            Vector3d beam = new Vector3d(1.0, 0.0, 0.0);
            OMUBinv.transform((Tuple3d)beam);
            omhkl.addElement("(" + beam.x + " " + beam.y + " " + beam.z + ")");
            return omhkl;
        }
        catch (Exception ex1) {
            Stac_Out.println(" ERROR!");
            return null;
        }
    }

    class Dnz {
        Matrix Amat;
        Matrix Umat;
        double delta_phi;
        double phi_start;
        double phi_end;
        double phi_init;
        double pixel_size_x;
        double pixel_size_y;
        double distance_pix;
        double wavelength;
        double diameter;
        double mosaicity;
        double boxe_size_x;
        double boxe_size_y;
        double spot_radius;
        double background_radius;
        double monochromator;
        double crystal_rotx;
        double crystal_roty;
        double crystal_rotz;
        double cassette_rotz;
        double distance_mm;
        double beam_x;
        double beam_y;
        double film_rotation;
        String spg;
        String cell;
        String detector;
        String image_template;
        String spot_profile;
        String resolution_limits;

        Dnz() {
        }
    }

    class FFormat {
        PrintfFormat dotx_mat = new PrintfFormat("%15.8f%15.8f%15.8f%10.6f%10.6f%10.6f\n");
        PrintfFormat dotx_par = new PrintfFormat("%12.5f%12.5f%12.5f%12.5f%10.4f%10.4f%10.4f%10.4f%2d%2d%2d%2d%2d%2d\n");
        String refl = new String("%4d%4d%4d 0%8.1f   100.0   1.00%6.1f %5.3f%7.1f%7.1f 1.000    99.9\n");
        PrintfFormat dotx_end = new PrintfFormat(" 999%4d%4d\n%s\nspot elliptical %5.3f %5.3f    0.0\nbackground elliptical %5.3f %5.3f    0.0\ngoniostat single axis\nmotor axis  0.000000  1.000000  0.000000\nprofile fitting radius   22.00\nresolution limits  %s\nwavelength  %.5f\nmonochromator   %.3f\noscillation start  %.2f end  %.2f\nmosaicity   %.3f\nspindle axis   0   0   1 vertical axis   1   0   0\nunit cell    %s\ncrystal rotx %8.3f roty %8.3f  rotz %8.3f\nsector        1\nraw data file '%s'\nformat %s\nspace group %s\ncassette rotx   0.0 roty    0.0 rotz    %.2f 2 theta    0.00\ndistance %7.2f\nx beam %8.3f  y beam %8.3f\nfilm rotation   %.2f\ncrossfire y  0.000 x  0.000 xy  0.000\n");
        PrintfFormat strategy_inp = new PrintfFormat("XFILE %s\nCOMPLETENESS 100 99 98 97 96 95\nNBINS 10\n>NFRAME %d\nPSFILE %s\nFORMAT %s\nSPACE GROUP %s\n>RESOLUTION %s\n%s\n");

        FFormat() {
        }
    }
}

