/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_PluginSlot;
import stacgui.Stac_ReqMsg;
import stacgui.Stac_RespMsg;
import stacgui.Stac_Session;

public class StacBCM
extends Stac_PluginSlot {
    Stac_BCMplugin activePlugin;
    ParamTable BCM_Descriptor;

    public StacBCM(Stac_Session session) {
        super(session, "BCM");
        String BCMplugin = null;
        this.activePlugin = (Stac_BCMplugin)this.changePlugin("BCMplugin_base");
        this.BCM_Descriptor = new ParamTable();
        this.read_specdef(System.getProperty("BCMDEF"), this.BCM_Descriptor);
        try {
            BCMplugin = this.BCM_Descriptor.getFirstStringValue("BCM_Plugin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!BCMplugin.equals("BCMplugin_base")) {
            this.activePlugin = (Stac_BCMplugin)this.changePlugin(BCMplugin);
        }
    }

    public void read_specdef(String specfile, ParamTable Descr) {
        this.activePlugin.read_specdef(specfile, Descr);
    }

    public void getCalibration(Vector3d[] okp) {
        this.activePlugin.getCalibration(this.BCM_Descriptor, okp);
    }

    public void setCalibration(Vector3d[] par) {
        this.activePlugin.setCalibration(this.BCM_Descriptor, par);
    }

    double getMotorPosition(String motorName) {
        try {
            return this.activePlugin.getMotorPosition(motorName);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    double loadMotorPosition(String motorName, String data) {
        return this.activePlugin.loadMotorPosition(motorName, data);
    }

    void setMotorPosition(String motorName, double newValue) {
        try {
            this.activePlugin.setMotorPosition(motorName, newValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void moveMotor(String motorName, double newValue) {
        try {
            this.activePlugin.moveMotor(motorName, newValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getMotorSpeed(String motorName) {
        try {
            return this.activePlugin.getMotorSpeed(motorName);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private void setMotorSpeed(String motorName, double newValue) {
        try {
            if (newValue != 0.0 && newValue != Double.POSITIVE_INFINITY) {
                this.activePlugin.setMotorSpeed(motorName, newValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ParamTable getMotorParams(String motorName) {
        ParamTable params = new ParamTable();
        try {
            params = this.activePlugin.getMotorParams(motorName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return params;
    }

    void moveMotors(ParamTable newPositions) {
        try {
            this.activePlugin.moveMotors(newPositions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void moveMotorsSyncronized(ParamTable newPositions) {
        try {
            this.activePlugin.moveMotorsSyncronized(newPositions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initMotors() {
        try {
            this.activePlugin.initMotors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean checkDatumTrans(Point3d dat, Point3d trans) {
        return this.activePlugin.checkDatumTrans(dat, trans);
    }

    void getCurrentTrans(Point3d trans) {
        trans.x = this.getMotorPosition("X");
        trans.y = this.getMotorPosition("Y");
        trans.z = this.getMotorPosition("Z");
    }

    void getCurrentDatum(Point3d dat) {
        dat.x = this.getMotorPosition("Omega");
        dat.y = this.getMotorPosition("Kappa");
        dat.z = this.getMotorPosition("Phi");
    }

    void getCurrentDatumTrans(Point3d dat, Point3d trans) {
        trans.x = this.getMotorPosition("X");
        trans.y = this.getMotorPosition("Y");
        trans.z = this.getMotorPosition("Z");
        dat.x = this.getMotorPosition("Omega");
        dat.y = this.getMotorPosition("Kappa");
        dat.z = this.getMotorPosition("Phi");
    }

    void moveToDatum(double o, double k, double p) {
        ParamTable motorVal = new ParamTable();
        motorVal.setSingleDoubleValue("Omega", o);
        motorVal.setSingleDoubleValue("Kappa", k);
        motorVal.setSingleDoubleValue("Phi", p);
        this.moveMotors(motorVal);
    }

    void moveToTrans(double x, double y, double z) {
        ParamTable motorVal = new ParamTable();
        motorVal.setSingleDoubleValue("X", x);
        motorVal.setSingleDoubleValue("Y", y);
        motorVal.setSingleDoubleValue("Z", z);
        this.moveMotors(motorVal);
    }

    void moveToDatumTrans(double o, double k, double p, double x, double y, double z) {
        ParamTable motorVal = new ParamTable();
        motorVal.setSingleDoubleValue("Omega", o);
        motorVal.setSingleDoubleValue("Kappa", k);
        motorVal.setSingleDoubleValue("Phi", p);
        motorVal.setSingleDoubleValue("X", x);
        motorVal.setSingleDoubleValue("Y", y);
        motorVal.setSingleDoubleValue("Z", z);
        this.moveMotors(motorVal);
    }

    void moveToDatumTransSync(double o, double k, double p, double x, double y, double z) {
        ParamTable motorVal = new ParamTable();
        motorVal.setSingleDoubleValue("Omega", o);
        motorVal.setSingleDoubleValue("Kappa", k);
        motorVal.setSingleDoubleValue("Phi", p);
        motorVal.setSingleDoubleValue("X", x);
        motorVal.setSingleDoubleValue("Y", y);
        motorVal.setSingleDoubleValue("Z", z);
        this.moveMotorsSyncronized(motorVal);
    }

    public void loadDatumTrans(Point3d dat, Point3d trans, String data) {
        trans.x = this.loadMotorPosition("X", data);
        trans.y = this.loadMotorPosition("Y", data);
        trans.z = this.loadMotorPosition("Z", data);
        dat.x = this.loadMotorPosition("Omega", data);
        dat.y = this.loadMotorPosition("Kappa", data);
        dat.z = this.loadMotorPosition("Phi", data);
    }

    public String saveDatumTrans(double o, double k, double p, double x, double y, double z) {
        ParamTable motorVal = new ParamTable();
        motorVal.setSingleDoubleValue("Omega", o);
        motorVal.setSingleDoubleValue("Kappa", k);
        motorVal.setSingleDoubleValue("Phi", p);
        motorVal.setSingleDoubleValue("X", x);
        motorVal.setSingleDoubleValue("Y", y);
        motorVal.setSingleDoubleValue("Z", z);
        String motorSave = new String("");
        this.activePlugin.saveMotorPositions(motorVal, motorSave);
        return motorSave;
    }

    void resetTrans() {
        this.setMotorPosition("X", 0.0);
        this.setMotorPosition("Y", 0.0);
        this.setMotorPosition("Z", 0.0);
    }

    void resetDatum() {
        this.setMotorPosition("Omega", 0.0);
        this.setMotorPosition("Kappa", 0.0);
        this.setMotorPosition("Phi", 0.0);
    }

    protected Stac_RespMsg process(Stac_ReqMsg req) {
        return null;
    }
}

