/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_AlignmentPlugin;
import stacgui.Stac_AlignmentReqMsg;
import stacgui.Stac_AlignmentRespMsg;
import stacgui.Stac_PluginSlot;
import stacgui.Stac_ReqMsg;
import stacgui.Stac_RespMsg;
import stacgui.Stac_Session;

public class StacAlignment
extends Stac_PluginSlot {
    Stac_AlignmentPlugin activePlugin;

    public StacAlignment(Stac_Session session) {
        super(session, "Alignment");
        String AlignmentPlugin = null;
        ParamTable Descriptor = new ParamTable();
        this.read_specdef(System.getProperty("BCMDEF"), Descriptor);
        try {
            AlignmentPlugin = Descriptor.getFirstStringValue("Alignment_Plugin");
        }
        catch (Exception e) {
            AlignmentPlugin = null;
        }
        if (AlignmentPlugin == null) {
            Descriptor.setSingleValue("Alignment_Plugin", "AlignmentPlugin_gonset");
            AlignmentPlugin = Descriptor.getFirstStringValue("Alignment_Plugin");
        }
        this.activePlugin = (Stac_AlignmentPlugin)this.changePlugin(AlignmentPlugin);
    }

    public void interpret_specdef(String specline, ParamTable Descr) {
        String name;
        if (specline.startsWith("#", 0)) {
            return;
        }
        String[] tmp2 = specline.split("\\s+");
        if (tmp2.length == 0) {
            return;
        }
        int offset = 0;
        if (tmp2[0].length() == 0) {
            ++offset;
        }
        if ((name = tmp2[0 + offset]).equals("Alignment_Plugin")) {
            String value = tmp2[1 + offset];
            Descr.setSingleValue(name, value);
        }
    }

    public void read_specdef(String specfile, ParamTable Descr) {
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl(specfile);
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            this.interpret_specdef(tmp1[l], Descr);
            ++l;
        }
    }

    String CalculateAlignment(String OMfile, Vector3d datum, Point3d trans, Vector orientations, StacBCM bcm, StacUtil utils) {
        try {
            return this.activePlugin.CalculateAlignment(OMfile, datum, trans, orientations, bcm, utils);
        }
        catch (Exception e) {
            return "";
        }
    }

    protected Stac_RespMsg process(Stac_ReqMsg req) {
        Stac_AlignmentRespMsg response = new Stac_AlignmentRespMsg(this.session, req);
        if (req instanceof Stac_AlignmentReqMsg) {
            Stac_AlignmentReqMsg alignReq = (Stac_AlignmentReqMsg)req;
            try {
                String OMfile = alignReq.get_OMfile();
                Vector3d datum = alignReq.get_datum();
                Point3d trans = alignReq.get_trans();
                Vector orientations = alignReq.get_orienattions();
                StacBCM bcm = alignReq.get_bcm();
                StacUtil utils = alignReq.get_utils();
                String possibleDatumsFile = this.CalculateAlignment(OMfile, datum, trans, orientations, bcm, utils);
                response.set_possibleDatumsFile(possibleDatumsFile);
                if (possibleDatumsFile.equals("")) {
                    response.getClass();
                    response.status = 2;
                } else {
                    response.getClass();
                    response.status = 0;
                }
            }
            catch (Exception e) {
                response.getClass();
                response.status = 2;
            }
        }
        return response;
    }

    public String getCreditString() {
        try {
            return this.activePlugin.getCreditString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

