/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import stacgui.ReorientTableModel;
import stacgui.STAC_GUI_Button_Panel;
import stacgui.STAC_GUI_File_Chooser_Panel;
import stacgui.StacBCM;
import stacgui.StacMainWin;
import stacgui.StacUtil;
import stacgui.Stac_Button_actionAdapter;
import stacgui.Stac_FileChooser;
import stacgui.Stac_Out;

public class STAC_OrientationPanel
extends JPanel
implements STAC_GUI_File_Chooser_Panel,
STAC_GUI_Button_Panel {
    StacUtil utils;
    StacBCM bcm;
    StacMainWin stacmainwin;
    STAC_GUI_Button_Panel remotelistener;
    Dimension rbSize = new Dimension(150, 30);
    Dimension rbdSize = new Dimension(300, 30);
    Dimension fsbSize = new Dimension(30, 30);
    Dimension tfSize = new Dimension(400, 30);
    Dimension tfnSize = new Dimension(10, 30);
    JButton jButtonRLeftAdd = new JButton("Add New");
    JButton jButtonRLeftDelete = new JButton("Del Selected");
    public JButton jButtonOptAlign = new JButton("Smallest Oscillation");
    JTextField jTextFieldRGF = new JTextField();
    JButton jButtonRGF = new JButton("", STAC_OrientationPanel.createImageIcon("images/folder.gif"));
    JButton jButtonRLeftGetFile = new JButton("Get a new from file:");
    ReorientTableModel reorientTableModel = new ReorientTableModel();
    public JTable jTableReorient = new JTable(this.reorientTableModel);
    JPanel jpanelRight = new JPanel();
    JScrollPane jpanelReorientTable = new JScrollPane(this.jTableReorient);

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = STAC_OrientationPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public STAC_OrientationPanel(StacUtil utils, StacBCM bcm) {
        this.init(utils, bcm, false, this);
    }

    public STAC_OrientationPanel(StacUtil utils, StacBCM bcm, STAC_GUI_Button_Panel listener) {
        this.init(utils, bcm, false, listener);
    }

    public STAC_OrientationPanel(StacUtil utils, StacBCM bcm, StacMainWin StacMainWin2) {
        this.stacmainwin = StacMainWin2;
        this.init(utils, bcm, true, this);
    }

    public void init(StacUtil utils, StacBCM bcm, boolean stand_alone, STAC_GUI_Button_Panel listener) {
        this.utils = utils;
        this.bcm = bcm;
        this.remotelistener = listener;
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel jPanelRLeft = new JPanel();
        this.add(jPanelRLeft);
        jPanelRLeft.setLayout(new BoxLayout(jPanelRLeft, 3));
        JLabel jLabelRLTitle = new JLabel("Reorientations:");
        jPanelRLeft.add((Component)jLabelRLTitle, null);
        jLabelRLTitle.setMinimumSize(this.rbSize);
        jLabelRLTitle.setMaximumSize(this.rbSize);
        jLabelRLTitle.setPreferredSize(this.rbSize);
        JPanel jPanelRLeftAD = new JPanel();
        jPanelRLeft.add((Component)jPanelRLeftAD, null);
        jPanelRLeftAD.setLayout(new BoxLayout(jPanelRLeftAD, 2));
        jPanelRLeftAD.add(Box.createHorizontalGlue());
        jPanelRLeftAD.add(this.jButtonRLeftAdd);
        this.jButtonRLeftAdd.setMinimumSize(this.rbSize);
        this.jButtonRLeftAdd.setMaximumSize(this.rbSize);
        this.jButtonRLeftAdd.setPreferredSize(this.rbSize);
        this.jButtonRLeftAdd.setToolTipText("Add a new entry to the Reorientation list");
        this.jButtonRLeftAdd.addActionListener(new Stac_Button_actionAdapter(this));
        jPanelRLeftAD.add(this.jButtonRLeftDelete);
        this.jButtonRLeftDelete.setMinimumSize(this.rbSize);
        this.jButtonRLeftDelete.setMaximumSize(this.rbSize);
        this.jButtonRLeftDelete.setPreferredSize(this.rbSize);
        this.jButtonRLeftDelete.setToolTipText("Remove the selected entries from the Reorientation list");
        this.jButtonRLeftDelete.addActionListener(new Stac_Button_actionAdapter(this));
        jPanelRLeftAD.add(Box.createHorizontalGlue());
        JPanel jPanelRLeftOA = new JPanel();
        jPanelRLeft.add(jPanelRLeftOA);
        jPanelRLeftOA.setLayout(new BoxLayout(jPanelRLeftOA, 2));
        jPanelRLeftOA.add(Box.createHorizontalGlue());
        jPanelRLeftOA.add(this.jButtonOptAlign);
        this.jButtonOptAlign.setMinimumSize(this.rbdSize);
        this.jButtonOptAlign.setMaximumSize(this.rbdSize);
        this.jButtonOptAlign.setPreferredSize(this.rbdSize);
        this.jButtonOptAlign.setToolTipText("Add the optimal orientation for smallest oscillation range");
        this.jButtonOptAlign.addActionListener(new Stac_Button_actionAdapter(this.remotelistener));
        jPanelRLeftOA.add(Box.createHorizontalGlue());
        JPanel jPanelRLeftGetFile = new JPanel();
        jPanelRLeft.add(jPanelRLeftGetFile);
        jPanelRLeftGetFile.setLayout(new BoxLayout(jPanelRLeftGetFile, 2));
        jPanelRLeftGetFile.add(Box.createHorizontalGlue());
        jPanelRLeftGetFile.add(this.jButtonRLeftGetFile);
        this.jButtonRLeftGetFile.setMinimumSize(this.rbdSize);
        this.jButtonRLeftGetFile.setMaximumSize(this.rbdSize);
        this.jButtonRLeftGetFile.setPreferredSize(this.rbdSize);
        this.jButtonRLeftGetFile.setToolTipText("Get the reorienation vectors from the file specified");
        this.jButtonRLeftGetFile.addActionListener(new Stac_Button_actionAdapter(this));
        jPanelRLeftGetFile.add(Box.createHorizontalGlue());
        JPanel jPanelRLeftGF = new JPanel();
        jPanelRLeft.add((Component)jPanelRLeftGF, null);
        jPanelRLeftGF.setLayout(new BoxLayout(jPanelRLeftGF, 2));
        jPanelRLeftGF.add((Component)this.jTextFieldRGF, null);
        this.jTextFieldRGF.setToolTipText("Input Descriptor, or Matrix Definiton file for old alignment");
        this.jTextFieldRGF.setMinimumSize(this.tfnSize);
        this.jTextFieldRGF.setMaximumSize(this.tfSize);
        this.jTextFieldRGF.setPreferredSize(this.tfSize);
        jPanelRLeftGF.add((Component)this.jButtonRGF, null);
        this.jButtonRGF.addActionListener(new Stac_FileChooser(this));
        this.jButtonRGF.setMinimumSize(this.fsbSize);
        this.jButtonRGF.setMaximumSize(this.fsbSize);
        this.jButtonRGF.setPreferredSize(this.fsbSize);
        this.jButtonRGF.setToolTipText("Select the file");
        jPanelRLeftGF.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelRLeftGF.add(Box.createHorizontalGlue());
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add(this.jpanelReorientTable);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add(Box.createHorizontalGlue());
        this.reorientTableModel.setTable(this.jTableReorient);
        this.jTableReorient.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel reorientColumnModel = new DefaultTableColumnModel();
        this.createTableColumnModel(this.reorientTableModel, reorientColumnModel);
    }

    private void createTableColumnModel(AbstractTableModel tableModel, DefaultTableColumnModel columnModel) {
        int modelColumnNumber = 0;
        while (modelColumnNumber < tableModel.getColumnCount()) {
            TableColumn column = new TableColumn(modelColumnNumber);
            column.setHeaderValue(tableModel.getColumnName(modelColumnNumber));
            switch (modelColumnNumber) {
                case 0: 
                case 1: {
                    column.setMinWidth(100);
                    column.setPreferredWidth(100);
                    break;
                }
                case 2: {
                    column.setMinWidth(200);
                }
            }
            columnModel.addColumn(column);
            ++modelColumnNumber;
        }
        this.jTableReorient.setColumnModel(columnModel);
    }

    public void FileChooser_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        File file = null;
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
        }
        if (file == null) {
            return;
        }
        if (e.getSource() instanceof JButton) {
            Stac_Out.println("USER ACTION: Button pressed (Orientation Panel - Fileselect: " + file.getAbsolutePath() + " - " + ((JButton)e.getSource()).getText() + ")");
        }
        if (e.getSource() == this.jButtonRGF) {
            this.jTextFieldRGF.setText(file.getAbsolutePath());
        }
    }

    public void Button_actionAdapter(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            Stac_Out.println("USER ACTION: Button pressed (STAC Orinetation Panel: " + ((JButton)e.getSource()).getText() + ")");
        }
        if (e.getSource() == this.jButtonRLeftAdd) {
            int rowct = this.jTableReorient.getRowCount();
            ReorientTableModel tmodel = (ReorientTableModel)this.jTableReorient.getModel();
            this.jTableReorient.setValueAt("", rowct, tmodel.getColId("V1"));
        } else if (e.getSource() == this.jButtonRLeftDelete) {
            int numOfVecs = this.jTableReorient.getSelectedRowCount();
            int[] vecIDs = this.jTableReorient.getSelectedRows();
            ReorientTableModel tmodel = (ReorientTableModel)this.jTableReorient.getModel();
            int i = vecIDs.length - 1;
            while (i >= 0) {
                tmodel.setValueAt("ClearRow", vecIDs[i], vecIDs[i]);
                --i;
            }
        } else if (e.getSource() == this.jButtonRLeftGetFile) {
            Vector OM = this.utils.getHKLfromOMFile(this.jTextFieldRGF.getText(), this.bcm);
            if (OM != null && OM.size() >= 2) {
                int rowct = this.jTableReorient.getRowCount();
                ReorientTableModel tmodel = (ReorientTableModel)this.jTableReorient.getModel();
                this.jTableReorient.setValueAt(OM.elementAt(0), rowct, tmodel.getColId("V1"));
                this.jTableReorient.setValueAt(OM.elementAt(1), rowct, tmodel.getColId("V2"));
                this.jTableReorient.setValueAt("Alignment as in " + this.jTextFieldRGF.getText(), rowct, tmodel.getColId("Comment"));
            }
        } else if (e.getSource() == this.jButtonOptAlign) {
            this.stacmainwin.ConvertInputFormat();
            Vector OM = this.utils.getOptAlign(".");
            this.addOrientationRequest(OM);
        }
    }

    public void addOrientationRequest(Vector list) {
        if (list != null && list.size() >= 3) {
            int ct = 0;
            while (ct < list.size() / 3) {
                int rowct = this.jTableReorient.getRowCount();
                ReorientTableModel tmodel = (ReorientTableModel)this.jTableReorient.getModel();
                this.jTableReorient.setValueAt(list.elementAt(ct * 3 + 0), rowct, tmodel.getColId("V1"));
                this.jTableReorient.setValueAt(list.elementAt(ct * 3 + 1), rowct, tmodel.getColId("V2"));
                this.jTableReorient.setValueAt(list.elementAt(ct * 3 + 2), rowct, tmodel.getColId("Comment"));
                ++ct;
            }
        }
    }

    public Vector getOrientationRequest() {
        Vector<Object> orientations = new Vector<Object>(0);
        int[] vecIDs = this.jTableReorient.getSelectedRows();
        ReorientTableModel tmodel = (ReorientTableModel)this.jTableReorient.getModel();
        tmodel.setValueAt("ActivateCells", 0, 0);
        if (vecIDs.length != 0) {
            int i = 0;
            while (i < vecIDs.length) {
                orientations.addElement(this.jTableReorient.getValueAt(vecIDs[i], tmodel.getColId("v1")));
                orientations.addElement(this.jTableReorient.getValueAt(vecIDs[i], tmodel.getColId("v2")));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.jTableReorient.getRowCount()) {
                orientations.addElement(this.jTableReorient.getValueAt(i, tmodel.getColId("v1")));
                orientations.addElement(this.jTableReorient.getValueAt(i, tmodel.getColId("v2")));
                ++i;
            }
        }
        return orientations;
    }
}

