/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import stacgui.AlignTableModel;
import stacgui.PrintfFormat;
import stacgui.STAC_GUI_Button_Panel;
import stacgui.StacBCM;
import stacgui.StacMainWin;
import stacgui.StacUtil;
import stacgui.Stac_Button_actionAdapter;
import stacgui.Stac_Out;
import stacgui.StrategyTableCellRenderer;

public class STAC_DatumPanel
extends JPanel
implements STAC_GUI_Button_Panel {
    StacUtil utils;
    StacBCM bcm;
    Dimension rbSize = new Dimension(100, 30);
    Dimension rbdSize = new Dimension(200, 30);
    Dimension fsbSize = new Dimension(30, 30);
    Dimension tfSize = new Dimension(1000, 30);
    Dimension tfnSize = new Dimension(10, 30);
    JLabel jLabelAlignVector = new JLabel();
    AlignTableModel alignTableModel = new AlignTableModel();
    JTable jTable1 = new JTable(this.alignTableModel);
    JScrollPane jpanelTable = new JScrollPane(this.jTable1);
    StrategyTableCellRenderer generalTableCellRenderer = new StrategyTableCellRenderer(true);
    JTextField jTFEvalO = new JTextField();
    JTextField jTFEvalK = new JTextField();
    JTextField jTFEvalP = new JTextField();
    JTextField jTFEvalX = new JTextField();
    JTextField jTFEvalY = new JTextField();
    JTextField jTFEvalZ = new JTextField();
    JButton jButtonEval_getP = new JButton();
    JTextField jTFEvalO2 = new JTextField();
    JTextField jTFEvalK2 = new JTextField();
    JTextField jTFEvalP2 = new JTextField();
    JTextField jTFEvalX2 = new JTextField();
    JTextField jTFEvalY2 = new JTextField();
    JTextField jTFEvalZ2 = new JTextField();
    JButton jButtonClear = new JButton();
    JButton jButtonEval_getP2 = new JButton();
    StacMainWin mainWin;

    public STAC_DatumPanel(StacUtil utils, StacBCM bcm, StacMainWin mainWin) {
        this.utils = utils;
        this.bcm = bcm;
        this.mainWin = mainWin;
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add((Component)this.jLabelAlignVector, null);
        this.jLabelAlignVector.setText("Alignment Vectors:");
        this.jLabelAlignVector.setBounds(new Rectangle(10, 0, 123, 34));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add((Component)this.jpanelTable, null);
        this.jpanelTable.getViewport().add(this.jTable1);
        this.jpanelTable.setBounds(new Rectangle(9, 38, 558, 99));
        this.jTable1.setToolTipText("Standard Allignment Vectors");
        this.jTable1.setAutoscrolls(true);
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setDefaultRenderer(Object.class, this.generalTableCellRenderer);
        this.jTable1.setDefaultRenderer(String.class, this.generalTableCellRenderer);
        this.jTable1.setDefaultRenderer(Double.class, this.generalTableCellRenderer);
        this.jTable1.setDefaultRenderer(Integer.class, this.generalTableCellRenderer);
        JPanel jPanelEvalTrans = new JPanel();
        this.add(jPanelEvalTrans);
        jPanelEvalTrans.setLayout(new BoxLayout(jPanelEvalTrans, 2));
        jPanelEvalTrans.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelEvalTrans.add(Box.createRigidArea(new Dimension(this.rbSize)));
        JLabel jLabelEvalTransO = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransO, null);
        jLabelEvalTransO.setText("Omega");
        jLabelEvalTransO.setHorizontalAlignment(0);
        jLabelEvalTransO.setMinimumSize(this.tfnSize);
        jLabelEvalTransO.setMaximumSize(this.tfSize);
        jLabelEvalTransO.setPreferredSize(this.tfSize);
        JLabel jLabelEvalTransK = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransK, null);
        jLabelEvalTransK.setText("Kappa");
        jLabelEvalTransK.setHorizontalAlignment(0);
        jLabelEvalTransK.setMinimumSize(this.tfnSize);
        jLabelEvalTransK.setMaximumSize(this.tfSize);
        jLabelEvalTransK.setPreferredSize(this.tfSize);
        JLabel jLabelEvalTransP = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransP, null);
        jLabelEvalTransP.setText("Phi");
        jLabelEvalTransP.setHorizontalAlignment(0);
        jLabelEvalTransP.setMinimumSize(this.tfnSize);
        jLabelEvalTransP.setMaximumSize(this.tfSize);
        jLabelEvalTransP.setPreferredSize(this.tfSize);
        JLabel jLabelEvalTransX = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransX, null);
        jLabelEvalTransX.setText("X");
        jLabelEvalTransX.setHorizontalAlignment(0);
        jLabelEvalTransX.setMinimumSize(this.tfnSize);
        jLabelEvalTransX.setMaximumSize(this.tfSize);
        jLabelEvalTransX.setPreferredSize(this.tfSize);
        JLabel jLabelEvalTransY = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransY, null);
        jLabelEvalTransY.setText("Y");
        jLabelEvalTransY.setHorizontalAlignment(0);
        jLabelEvalTransY.setMinimumSize(this.tfnSize);
        jLabelEvalTransY.setMaximumSize(this.tfSize);
        jLabelEvalTransY.setPreferredSize(this.tfSize);
        JLabel jLabelEvalTransZ = new JLabel();
        jPanelEvalTrans.add((Component)jLabelEvalTransZ, null);
        jLabelEvalTransZ.setText("Z");
        jLabelEvalTransZ.setHorizontalAlignment(0);
        jLabelEvalTransZ.setMinimumSize(this.tfnSize);
        jLabelEvalTransZ.setMaximumSize(this.tfSize);
        jLabelEvalTransZ.setPreferredSize(this.tfSize);
        jPanelEvalTrans.add(Box.createRigidArea(this.rbSize));
        jPanelEvalTrans.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel jPanelEvalTransf = new JPanel();
        this.add(jPanelEvalTransf);
        jPanelEvalTransf.setLayout(new BoxLayout(jPanelEvalTransf, 2));
        jPanelEvalTransf.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelEvalTransf.add(Box.createRigidArea(new Dimension(this.rbSize)));
        jPanelEvalTransf.add((Component)this.jTFEvalO, null);
        this.jTFEvalO.setToolTipText("Current Omega Angle");
        this.jTFEvalO.setMinimumSize(this.tfnSize);
        this.jTFEvalO.setMaximumSize(this.tfSize);
        this.jTFEvalO.setPreferredSize(this.tfSize);
        this.jTFEvalO.setEditable(false);
        jPanelEvalTransf.add((Component)this.jTFEvalK, null);
        this.jTFEvalK.setToolTipText("Current Kappa Angle");
        this.jTFEvalK.setMinimumSize(this.tfnSize);
        this.jTFEvalK.setMaximumSize(this.tfSize);
        this.jTFEvalK.setPreferredSize(this.tfSize);
        this.jTFEvalK.setEditable(false);
        jPanelEvalTransf.add((Component)this.jTFEvalP, null);
        this.jTFEvalP.setToolTipText("Current Phi Angle");
        this.jTFEvalP.setMinimumSize(this.tfnSize);
        this.jTFEvalP.setMaximumSize(this.tfSize);
        this.jTFEvalP.setPreferredSize(this.tfSize);
        this.jTFEvalP.setEditable(false);
        jPanelEvalTransf.add((Component)this.jTFEvalX, null);
        this.jTFEvalX.setToolTipText("Current X Translation");
        this.jTFEvalX.setMinimumSize(this.tfnSize);
        this.jTFEvalX.setMaximumSize(this.tfSize);
        this.jTFEvalX.setPreferredSize(this.tfSize);
        this.jTFEvalX.setEditable(false);
        jPanelEvalTransf.add((Component)this.jTFEvalY, null);
        this.jTFEvalY.setToolTipText("Current Y Translation");
        this.jTFEvalY.setMinimumSize(this.tfnSize);
        this.jTFEvalY.setMaximumSize(this.tfSize);
        this.jTFEvalY.setPreferredSize(this.tfSize);
        this.jTFEvalY.setEditable(false);
        jPanelEvalTransf.add((Component)this.jTFEvalZ, null);
        this.jTFEvalZ.setToolTipText("Current Z Translation");
        this.jTFEvalZ.setMinimumSize(this.tfnSize);
        this.jTFEvalZ.setMaximumSize(this.tfSize);
        this.jTFEvalZ.setPreferredSize(this.tfSize);
        this.jTFEvalZ.setEditable(false);
        this.jButtonEval_getP.setText("Mv Sel.");
        this.jButtonEval_getP.setMinimumSize(this.rbSize);
        this.jButtonEval_getP.setMaximumSize(this.rbSize);
        this.jButtonEval_getP.setPreferredSize(this.rbSize);
        this.jButtonEval_getP.setToolTipText("Move the gonio to the uppermost selection");
        this.jButtonEval_getP.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonEval_getP.setEnabled(true);
        jPanelEvalTransf.add((Component)this.jButtonEval_getP, null);
        jPanelEvalTransf.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel thisSepLine = new JPanel();
        this.add(thisSepLine);
        thisSepLine.setLayout(new BoxLayout(thisSepLine, 2));
        thisSepLine.add(Box.createRigidArea(new Dimension(10, 10)));
        JTextField jTF3SepL = new JTextField();
        thisSepLine.add((Component)jTF3SepL, null);
        jTF3SepL.setEditable(false);
        jTF3SepL.setMinimumSize(new Dimension(1, 3));
        jTF3SepL.setMaximumSize(new Dimension(2000, 3));
        jTF3SepL.setPreferredSize(new Dimension(1, 3));
        thisSepLine.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel jPanelEvalTransf2 = new JPanel();
        this.add(jPanelEvalTransf2);
        jPanelEvalTransf2.setLayout(new BoxLayout(jPanelEvalTransf2, 2));
        jPanelEvalTransf2.add(Box.createRigidArea(new Dimension(10, 10)));
        this.jButtonClear.setText("Clear:");
        this.jButtonClear.setMinimumSize(this.rbSize);
        this.jButtonClear.setMaximumSize(this.rbSize);
        this.jButtonClear.setPreferredSize(this.rbSize);
        this.jButtonClear.setToolTipText("Clear the edit fileds");
        this.jButtonClear.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonClear.setEnabled(true);
        jPanelEvalTransf2.add((Component)this.jButtonClear, null);
        jPanelEvalTransf2.add((Component)this.jTFEvalO2, null);
        this.jTFEvalO2.setToolTipText("Current Omega Angle");
        this.jTFEvalO2.setMinimumSize(this.tfnSize);
        this.jTFEvalO2.setMaximumSize(this.tfSize);
        this.jTFEvalO2.setPreferredSize(this.tfSize);
        jPanelEvalTransf2.add((Component)this.jTFEvalK2, null);
        this.jTFEvalK2.setToolTipText("Current Kappa Angle");
        this.jTFEvalK2.setMinimumSize(this.tfnSize);
        this.jTFEvalK2.setMaximumSize(this.tfSize);
        this.jTFEvalK2.setPreferredSize(this.tfSize);
        jPanelEvalTransf2.add((Component)this.jTFEvalP2, null);
        this.jTFEvalP2.setToolTipText("Current Phi Angle");
        this.jTFEvalP2.setMinimumSize(this.tfnSize);
        this.jTFEvalP2.setMaximumSize(this.tfSize);
        this.jTFEvalP2.setPreferredSize(this.tfSize);
        jPanelEvalTransf2.add((Component)this.jTFEvalX2, null);
        this.jTFEvalX2.setToolTipText("Current X Translation");
        this.jTFEvalX2.setMinimumSize(this.tfnSize);
        this.jTFEvalX2.setMaximumSize(this.tfSize);
        this.jTFEvalX2.setPreferredSize(this.tfSize);
        this.jTFEvalX2.setEditable(false);
        jPanelEvalTransf2.add((Component)this.jTFEvalY2, null);
        this.jTFEvalY2.setToolTipText("Current Y Translation");
        this.jTFEvalY2.setMinimumSize(this.tfnSize);
        this.jTFEvalY2.setMaximumSize(this.tfSize);
        this.jTFEvalY2.setPreferredSize(this.tfSize);
        this.jTFEvalY2.setEditable(false);
        jPanelEvalTransf2.add((Component)this.jTFEvalZ2, null);
        this.jTFEvalZ2.setToolTipText("Current Z Translation");
        this.jTFEvalZ2.setMinimumSize(this.tfnSize);
        this.jTFEvalZ2.setMaximumSize(this.tfSize);
        this.jTFEvalZ2.setPreferredSize(this.tfSize);
        this.jTFEvalZ2.setEditable(false);
        this.jButtonEval_getP2.setText("Mv Edit");
        this.jButtonEval_getP2.setMinimumSize(this.rbSize);
        this.jButtonEval_getP2.setMaximumSize(this.rbSize);
        this.jButtonEval_getP2.setPreferredSize(this.rbSize);
        this.jButtonEval_getP2.setToolTipText("Move the gonio to the edited position");
        this.jButtonEval_getP2.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonEval_getP2.setEnabled(true);
        jPanelEvalTransf2.add((Component)this.jButtonEval_getP2, null);
        jPanelEvalTransf2.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
    }

    public Point3d CalculateCalibratedTranslation(double[] angles, Point3d dat, Point3d trn) {
        double actualKappa = dat.y;
        double actualPhi = dat.z;
        try {
            actualKappa = new Double(this.mainWin.jTFKappa.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            actualPhi = new Double(this.mainWin.jTFPhi.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            trn.x = new Double(this.mainWin.jTFTransX.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            trn.y = new Double(this.mainWin.jTFTransY.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            trn.z = new Double(this.mainWin.jTFTransZ.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        double omega = angles[0];
        double kappa = angles[1];
        double phi = angles[2];
        Point3d trans = this.utils.CalculateTranslation(trn, actualKappa, kappa, actualPhi, phi, this.bcm);
        return trans;
    }

    void EvalGetCurrentDatumTrans() {
        Point3d trn = new Point3d();
        Point3d dat = new Point3d();
        int[] vecIDs = this.jTable1.getSelectedRows();
        this.bcm.getCurrentDatumTrans(dat, trn);
        double o = dat.x;
        double k = dat.y;
        double p = dat.z;
        double x = trn.x;
        double y = trn.y;
        double z = trn.z;
        boolean recalcTrans = false;
        if (vecIDs.length > 0) {
            AlignTableModel amodel = (AlignTableModel)this.jTable1.getModel();
            o = (Double)this.jTable1.getValueAt(vecIDs[0], amodel.getColId("omega"));
            k = (Double)this.jTable1.getValueAt(vecIDs[0], amodel.getColId("kappa"));
            p = (Double)this.jTable1.getValueAt(vecIDs[0], amodel.getColId("phi"));
            String tr = (String)this.jTable1.getValueAt(vecIDs[0], amodel.getColId("Trans"));
            tr = tr.substring(1, tr.length() - 1);
            String[] tmp = tr.split(";");
            try {
                x = new Double(tmp[0]);
                y = new Double(tmp[1]);
                z = new Double(tmp[2]);
            }
            catch (Exception e) {
                recalcTrans = true;
            }
        }
        if (recalcTrans) {
            double[] angles = new double[]{o, k, p};
            Point3d pts = new Point3d();
            pts = this.CalculateCalibratedTranslation(angles, dat, trn);
            x = pts.x;
            y = pts.y;
            z = pts.z;
        }
        this.bcm.moveToDatumTransSync(o, k, p, x, y, z);
        this.bcm.getCurrentDatumTrans(dat, trn);
        this.jTFEvalO.setText(new PrintfFormat("%.4f").sprintf(dat.x));
        this.jTFEvalK.setText(new PrintfFormat("%.4f").sprintf(dat.y));
        this.jTFEvalP.setText(new PrintfFormat("%.4f").sprintf(dat.z));
        this.jTFEvalX.setText(new PrintfFormat("%.4f").sprintf(trn.x));
        this.jTFEvalY.setText(new PrintfFormat("%.4f").sprintf(trn.y));
        this.jTFEvalZ.setText(new PrintfFormat("%.4f").sprintf(trn.z));
        Stac_Out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        Stac_Out.println("!!!  Spec user oscillation start: !!!");
        Stac_Out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    void EvalGetCurrentDatumTrans2() {
        Point3d trn = new Point3d();
        Point3d dat = new Point3d();
        this.bcm.getCurrentDatumTrans(dat, trn);
        double o = dat.x;
        double k = dat.y;
        double p = dat.z;
        double x = trn.x;
        double y = trn.y;
        double z = trn.z;
        boolean recalcTrans = false;
        try {
            o = new Double(this.jTFEvalO2.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            k = new Double(this.jTFEvalK2.getText());
            recalcTrans = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            p = new Double(this.jTFEvalP2.getText());
            recalcTrans = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            x = new Double(this.jTFEvalX2.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            y = new Double(this.jTFEvalY2.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            z = new Double(this.jTFEvalZ2.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recalcTrans) {
            double[] angles = new double[]{o, k, p};
            Point3d pts = new Point3d();
            pts = this.CalculateCalibratedTranslation(angles, dat, trn);
            x = pts.x;
            y = pts.y;
            z = pts.z;
        }
        this.bcm.moveToDatumTransSync(o, k, p, x, y, z);
        this.bcm.getCurrentDatumTrans(dat, trn);
        this.jTFEvalO2.setText(new PrintfFormat("%.4f").sprintf(dat.x));
        this.jTFEvalK2.setText(new PrintfFormat("%.4f").sprintf(dat.y));
        this.jTFEvalP2.setText(new PrintfFormat("%.4f").sprintf(dat.z));
        this.jTFEvalX2.setText(new PrintfFormat("%.4f").sprintf(trn.x));
        this.jTFEvalY2.setText(new PrintfFormat("%.4f").sprintf(trn.y));
        this.jTFEvalZ2.setText(new PrintfFormat("%.4f").sprintf(trn.z));
    }

    public void Button_actionAdapter(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            Stac_Out.println("USER ACTION: Button pressed (STAC Datum Panel: " + ((JButton)e.getSource()).getText() + ")");
        }
        if (e.getSource() == this.jButtonEval_getP) {
            this.EvalGetCurrentDatumTrans();
        } else if (e.getSource() == this.jButtonEval_getP2) {
            this.EvalGetCurrentDatumTrans2();
        } else if (e.getSource() == this.jButtonClear) {
            this.jTFEvalO2.setText("");
            this.jTFEvalK2.setText("");
            this.jTFEvalP2.setText("");
        }
    }

    public void clearTable() {
        if (this.jTable1.getRowCount() > 0) {
            this.jTable1.setValueAt("ClearTable", 0, 0);
        }
    }

    public void addTableRow(Vector actRow) {
        String v1 = (String)actRow.elementAt(0);
        String v2 = (String)actRow.elementAt(1);
        Double omega = (Double)actRow.elementAt(2);
        Double kappa = (Double)actRow.elementAt(3);
        Double phi = (Double)actRow.elementAt(4);
        String trans = (String)actRow.elementAt(5);
        Double rank = (Double)actRow.elementAt(6);
        AlignTableModel amodel = (AlignTableModel)this.jTable1.getModel();
        int newrow = this.jTable1.getRowCount();
        this.jTable1.setValueAt(new Double(newrow + 1), newrow, amodel.getColId("ID"));
        this.jTable1.setValueAt(v1, newrow, amodel.getColId("v1"));
        this.jTable1.setValueAt(v2, newrow, amodel.getColId("v2"));
        this.jTable1.setValueAt(omega, newrow, amodel.getColId("omega"));
        this.jTable1.setValueAt(kappa, newrow, amodel.getColId("kappa"));
        this.jTable1.setValueAt(phi, newrow, amodel.getColId("phi"));
        this.jTable1.setValueAt(trans, newrow, amodel.getColId("trans"));
        this.jTable1.setValueAt(rank, newrow, amodel.getColId("rank"));
    }

    public void setTable(Vector dataRows) {
        this.clearTable();
        AlignTableModel amodel = (AlignTableModel)this.jTable1.getModel();
        int i = 0;
        while (i < dataRows.size()) {
            this.addTableRow((Vector)dataRows.elementAt(i));
            ++i;
        }
    }

    public Vector getDatumRequest() {
        Vector<Object> orientations = new Vector<Object>(0);
        int[] vecIDs = this.jTable1.getSelectedRows();
        AlignTableModel tmodel = (AlignTableModel)this.jTable1.getModel();
        tmodel.setValueAt("ActivateCells", 0, 0);
        if (vecIDs.length != 0) {
            int i = 0;
            while (i < vecIDs.length) {
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("v1")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("v2")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("omega")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("kappa")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("phi")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("trans")));
                orientations.addElement(this.jTable1.getValueAt(vecIDs[i], tmodel.getColId("rank")));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.jTable1.getRowCount()) {
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("v1")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("v2")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("omega")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("kappa")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("phi")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("trans")));
                orientations.addElement(this.jTable1.getValueAt(i, tmodel.getColId("rank")));
                ++i;
            }
        }
        return orientations;
    }
}

