/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import dna.xml.Beam;
import dna.xml.Cell;
import dna.xml.Index_response;
import dna.xml.Kappa_alignment_request;
import dna.xml.Kappa_alignment_response;
import dna.xml.Kappa_collect_settings;
import dna.xml.Kappa_motor_setting;
import dna.xml.Kappa_possible_alignment;
import dna.xml.Kappa_strategy_request;
import dna.xml.Kappa_strategy_response;
import dna.xml.Kappa_strategy_sweep;
import dna.xml.Matrix;
import dna.xml.Status;
import dna.xml.types.Status_code;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacAlignment;
import stacgui.StacBCM;
import stacgui.StacStrategy;
import stacgui.StacUtil;
import stacgui.Stac_AlignmentReqMsg;
import stacgui.Stac_AlignmentRespMsg;
import stacgui.Stac_Out;
import stacgui.Stac_Session;

public class STAC_DNA_listener {
    Stac_Session session;
    StacUtil utils;
    StacBCM bcm;
    StacAlignment alignment;
    StacStrategy strategy;

    public STAC_DNA_listener(String[] args) {
        String req = "";
        String workDir = "";
        this.session = new Stac_Session();
        try {
            req = args[0];
            workDir = args[1];
            if (workDir.length() > 1 && workDir.substring(0, 1).equals("-")) {
                workDir = new String(workDir.substring(1));
            }
        }
        catch (Exception e) {
            this.session.errorMsg("Insufficient number of arguments passed");
        }
        this.bcm = new StacBCM(this.session);
        this.utils = new StacUtil();
        if (req.equalsIgnoreCase("kappa_alignment")) {
            this.alignment = new StacAlignment(this.session);
            this.AlignmentCalculation_requested(workDir);
        } else if (req.equalsIgnoreCase("kappa_strategy")) {
            this.strategy = new StacStrategy(this.session);
            this.StrategyCalculation_requested(workDir);
        } else if (req.equalsIgnoreCase("kappa_collect_settings")) {
            this.BCMaction_requested(workDir);
        } else if (req.equalsIgnoreCase("kappa_settings_request")) {
            this.BCMinfo_requested(workDir);
        } else {
            Stac_Out.println("Unrecognised Request: " + req);
        }
    }

    void convertDNAformat(String workDir) {
        Index_response _index_response = null;
        try {
            String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_STAC_Index_response");
            StringReader reader = new StringReader(xml_message);
            _index_response = (Index_response)Unmarshaller.unmarshal(Index_response.class, (Reader)reader);
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        String matfile = String.valueOf(workDir) + "DNA_mosflm.mat";
        PrintfFormat prnFmt = new PrintfFormat("%8.5f  %8.5f  %8.5f\n%8.5f  %8.5f  %8.5f\n%8.5f  %8.5f  %8.5f\n       0.000       0.000       0.000\n%8.5f  %8.5f  %8.5f\n%8.5f  %8.5f  %8.5f\n%8.5f  %8.5f  %8.5f\n%8.5f  %8.5f  %8.5f  %8.5f  %8.5f  %8.5f\n       0.000       0.000       0.000\n");
        try {
            FileWriter mfile = new FileWriter(matfile);
            Object[] params = new Double[24];
            int ct = 0;
            Matrix mat = _index_response.getSolution().getOrientation().getA_matrix();
            params[ct++] = new Double(mat.getE11());
            params[ct++] = new Double(mat.getE12());
            params[ct++] = new Double(mat.getE13());
            params[ct++] = new Double(mat.getE21());
            params[ct++] = new Double(mat.getE22());
            params[ct++] = new Double(mat.getE23());
            params[ct++] = new Double(mat.getE31());
            params[ct++] = new Double(mat.getE32());
            params[ct++] = new Double(mat.getE33());
            mat = _index_response.getSolution().getOrientation().getU_matrix();
            params[ct++] = new Double(mat.getE11());
            params[ct++] = new Double(mat.getE12());
            params[ct++] = new Double(mat.getE13());
            params[ct++] = new Double(mat.getE21());
            params[ct++] = new Double(mat.getE22());
            params[ct++] = new Double(mat.getE23());
            params[ct++] = new Double(mat.getE31());
            params[ct++] = new Double(mat.getE32());
            params[ct++] = new Double(mat.getE33());
            Cell cellParam = _index_response.getSolution().getOrientation().getCell();
            params[ct++] = new Double(cellParam.getA());
            params[ct++] = new Double(cellParam.getB());
            params[ct++] = new Double(cellParam.getC());
            params[ct++] = new Double(cellParam.getAlpha());
            params[ct++] = new Double(cellParam.getBeta());
            params[ct++] = new Double(cellParam.getGamma());
            mfile.write(prnFmt.sprintf(params));
            mfile.close();
        }
        catch (IOException mfile) {
            // empty catch block
        }
        String mosfile = String.valueOf(workDir) + "DNA_mosflm.inp";
        prnFmt = new PrintfFormat("scanner %s\ngain 0.4\nsynchrotron polar 0.99\ndispersion  0.0002\ndivergence  0.001 0.001\ngenf genfile.gen\nwavelength  0.97944\ndistance    165.00\nbeam  %8.3f  %8.3f\nmosaic  %4.2f\ndirectory  %s\ntemplate   %s\nextention  %s\nimage 1  phi   0.00  to   %8.2f\n");
        try {
            String msf = this.utils.opReadCl(String.valueOf(workDir) + "bestfile.par");
            msf = msf.toLowerCase();
            Double phi_delta = (Double)((Vector)this.utils.getXpar(msf, "phiwidth ", 80, "double")).elementAt(0);
            FileWriter mfile = new FileWriter(mosfile);
            Object[] params = new Object[8];
            int ct = 0;
            params[ct++] = "marc";
            Beam beamValue = _index_response.getSolution().getRefinement().getBeam_shift().getNew_beam();
            params[ct++] = new Double(beamValue.getX());
            params[ct++] = new Double(beamValue.getY());
            params[ct++] = new Double(_index_response.getMosaicity_value());
            params[ct++] = "/tmp/dna";
            params[ct++] = "ref###";
            params[ct++] = "img";
            params[ct++] = phi_delta;
            mfile.write(prnFmt.sprintf(params));
            mfile.close();
        }
        catch (IOException msf) {
            // empty catch block
        }
        String denzoname = String.valueOf(workDir) + "name0.x";
        this.utils.ConvertInputFormat(matfile, mosfile, "mosflm", denzoname);
    }

    void AlignmentCalculation_requested(String workDir) {
        this.convertDNAformat(workDir);
        Kappa_alignment_request _kappa_alignment_request = null;
        try {
            String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_kappa_alignment_request");
            StringReader reader = new StringReader(xml_message);
            _kappa_alignment_request = (Kappa_alignment_request)Unmarshaller.unmarshal(Kappa_alignment_request.class, (Reader)reader);
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        Vector<String> orientations = new Vector<String>(0);
        int i = 0;
        while (i < _kappa_alignment_request.getDesired_orientationCount()) {
            orientations.addElement(_kappa_alignment_request.getDesired_orientation(i).getV1());
            orientations.addElement(_kappa_alignment_request.getDesired_orientation(i).getV2());
            ++i;
        }
        Kappa_alignment_response _kappa_alignment_response = new Kappa_alignment_response();
        Status stat = new Status();
        stat.setCode(Status_code.OK);
        String credit = "";
        String calcType = "";
        if ("SPECIAL".equalsIgnoreCase((String)orientations.elementAt(0))) {
            Vector res = new Vector(0);
            if ("OptAlign".equalsIgnoreCase((String)orientations.elementAt(1))) {
                res = this.utils.getOptAlign(workDir);
                credit = "using STRATEGY";
                calcType = "SPECIAL Optimal Alignment ";
            }
            try {
                int i2 = 0;
                while (i2 < res.size() / 3) {
                    Kappa_possible_alignment possibleOrientation = new Kappa_possible_alignment();
                    possibleOrientation.setV1((String)res.elementAt(3 * i2 + 0));
                    possibleOrientation.setV2((String)res.elementAt(3 * i2 + 1));
                    possibleOrientation.setOmega(0.0);
                    possibleOrientation.setKappa(0.0);
                    possibleOrientation.setPhi(0.0);
                    possibleOrientation.setTrans((String)res.elementAt(3 * i2 + 2));
                    possibleOrientation.setRank(0.0);
                    _kappa_alignment_response.addPossible_orientation(possibleOrientation);
                    ++i2;
                }
            }
            catch (Exception ex2) {
                stat.setCode(Status_code.ERROR);
            }
        } else {
            Point3d datumGet = new Point3d();
            Point3d actualTrans = new Point3d();
            try {
                String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_STAC_Kappa_Settings");
                StringReader reader = new StringReader(xml_message);
                Kappa_collect_settings _kappa_collect_settings = (Kappa_collect_settings)Unmarshaller.unmarshal(Kappa_collect_settings.class, (Reader)reader);
                ParamTable datumtrans = new ParamTable();
                int i3 = 0;
                while (i3 < _kappa_collect_settings.getMotorSettingsCount()) {
                    datumtrans.setSingleDoubleValue(_kappa_collect_settings.getMotorSettings(i3).getMotorName(), _kappa_collect_settings.getMotorSettings(i3).getMotorValue());
                    ++i3;
                }
                datumGet.set(datumtrans.getFirstDoubleValue("Omega"), datumtrans.getFirstDoubleValue("Kappa"), datumtrans.getFirstDoubleValue("Phi"));
                actualTrans.set(datumtrans.getFirstDoubleValue("X"), datumtrans.getFirstDoubleValue("Y"), datumtrans.getFirstDoubleValue("Z"));
            }
            catch (Exception ex) {
                datumGet.set(0.0, 0.0, 0.0);
                actualTrans.set(0.0, 0.0, 0.0);
            }
            Vector3d datum = new Vector3d((Tuple3d)datumGet);
            String alignFile = "";
            Stac_AlignmentReqMsg req = new Stac_AlignmentReqMsg(this.session, workDir, datum, actualTrans, orientations, this.bcm, this.utils);
            Stac_AlignmentRespMsg alignResp = (Stac_AlignmentRespMsg)this.alignment.handle(req);
            int n = alignResp.status;
            alignResp.getClass();
            if (n == 0) {
                alignFile = String.valueOf(workDir) + alignResp.possibleDatumsFile;
            }
            credit = this.alignment.getCreditString();
            try {
                Stac_Out.println("File to be read: " + alignFile);
                FileInputStream GonsetResultFile = new FileInputStream(alignFile);
                DataInputStream grf = new DataInputStream(GonsetResultFile);
                try {
                    while (true) {
                        double v1x = grf.readDouble();
                        double v1y = grf.readDouble();
                        double v1z = grf.readDouble();
                        double v2x = grf.readDouble();
                        double v2y = grf.readDouble();
                        double v2z = grf.readDouble();
                        double omega = grf.readDouble();
                        double kappa = grf.readDouble();
                        double phi = grf.readDouble();
                        String trans = grf.readUTF();
                        double rank = grf.readDouble();
                        Kappa_possible_alignment possibleOrientation = new Kappa_possible_alignment();
                        possibleOrientation.setV1("(" + v1x + ";" + v1y + ";" + v1z + ")");
                        possibleOrientation.setV2("(" + v2x + ";" + v2y + ";" + v2z + ")");
                        possibleOrientation.setOmega(omega);
                        possibleOrientation.setKappa(kappa);
                        possibleOrientation.setPhi(phi);
                        possibleOrientation.setTrans(trans);
                        possibleOrientation.setRank(rank);
                        _kappa_alignment_response.addPossible_orientation(possibleOrientation);
                    }
                }
                catch (IOException grfex) {
                    grf.close();
                    GonsetResultFile.close();
                }
            }
            catch (Exception ex2) {
                stat.setCode(Status_code.ERROR);
            }
        }
        _kappa_alignment_response.setStatus(stat);
        _kappa_alignment_response.setComment(String.valueOf(calcType) + "Calculation performed by STAC (" + credit + ")");
        StringWriter stringWriter = new StringWriter();
        String xml_string = "";
        try {
            _kappa_alignment_response.marshal((Writer)stringWriter);
            xml_string = stringWriter.toString();
            FileWriter responseFile = new FileWriter(String.valueOf(workDir) + "STAC_DNA_kappa_alignment_response");
            responseFile.write(xml_string);
            responseFile.close();
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        catch (IOException ex) {
            Stac_Out.println("IOException: " + ex);
        }
    }

    void StrategyCalculation_requested(String workDir) {
        this.convertDNAformat(workDir);
        Point3d datumGet = new Point3d();
        Point3d actualTrans = new Point3d();
        Vector3d datum = new Vector3d((Tuple3d)datumGet);
        Kappa_strategy_request _kappa_strategy_request = null;
        Object _index_response = null;
        try {
            String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_kappa_strategy_request");
            StringReader reader = new StringReader(xml_message);
            _kappa_strategy_request = (Kappa_strategy_request)Unmarshaller.unmarshal(Kappa_strategy_request.class, (Reader)reader);
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        Vector<Vector3d> desiredDatums = new Vector<Vector3d>(0);
        int i = 0;
        while (i < _kappa_strategy_request.getDesired_datumCount()) {
            Vector3d newDatum = new Vector3d(_kappa_strategy_request.getDesired_datum(i).getOmega(), _kappa_strategy_request.getDesired_datum(i).getKappa(), _kappa_strategy_request.getDesired_datum(i).getPhi());
            desiredDatums.addElement(newDatum);
            ++i;
        }
        String alignFile = String.valueOf(workDir) + this.strategy.CalculateStrategy(workDir, datum, desiredDatums, this.bcm, this.utils);
        String credit = this.strategy.getCreditString();
        Status stat = new Status();
        stat.setCode(Status_code.OK);
        Kappa_strategy_response _kappa_strategy_response = new Kappa_strategy_response();
        try {
            Stac_Out.println("File to be read: " + alignFile);
            FileInputStream ResultFile = new FileInputStream(alignFile);
            DataInputStream grf = new DataInputStream(ResultFile);
            try {
                while (true) {
                    int strategyID = grf.readInt();
                    double omegaStart = grf.readDouble();
                    double omegaEnd = grf.readDouble();
                    double kappa = grf.readDouble();
                    double phi = grf.readDouble();
                    double completion = grf.readDouble();
                    double res = grf.readDouble();
                    double rank = grf.readDouble();
                    Kappa_strategy_sweep possibleSweep = new Kappa_strategy_sweep();
                    possibleSweep.setStrategyID(strategyID);
                    possibleSweep.setOmegaStart(omegaStart);
                    possibleSweep.setOmegaEnd(omegaEnd);
                    possibleSweep.setKappa(kappa);
                    possibleSweep.setPhi(phi);
                    possibleSweep.setCompleteness(completion);
                    possibleSweep.setRank(rank);
                    _kappa_strategy_response.addGenerated_sweep(possibleSweep);
                }
            }
            catch (IOException grfex) {
                grf.close();
                ResultFile.close();
            }
        }
        catch (Exception ex2) {
            stat.setCode(Status_code.ERROR);
        }
        _kappa_strategy_response.setStatus(stat);
        _kappa_strategy_response.setComment("Calculation performed by STAC (" + credit + ")");
        StringWriter stringWriter = new StringWriter();
        String xml_string = "";
        try {
            _kappa_strategy_response.marshal((Writer)stringWriter);
            xml_string = stringWriter.toString();
            FileWriter responseFile = new FileWriter(String.valueOf(workDir) + "STAC_DNA_kappa_strategy_response");
            responseFile.write(xml_string);
            responseFile.close();
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        catch (IOException ex) {
            Stac_Out.println("IOException: " + ex);
        }
    }

    void BCMaction_requested(String workDir) {
        Kappa_collect_settings _kappa_collect_settings = null;
        try {
            String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_kappa_collect_settings_request");
            StringReader reader = new StringReader(xml_message);
            _kappa_collect_settings = (Kappa_collect_settings)Unmarshaller.unmarshal(Kappa_collect_settings.class, (Reader)reader);
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        ParamTable newPositions = new ParamTable();
        int i = 0;
        while (i < _kappa_collect_settings.getMotorSettingsCount()) {
            newPositions.setSingleDoubleValue(_kappa_collect_settings.getMotorSettings(i).getMotorName(), _kappa_collect_settings.getMotorSettings(i).getMotorValue());
            ++i;
        }
        double omega = this.utils.angleInRange(newPositions.getFirstDoubleValue("Omega"), 0.0);
        double kappa = this.utils.angleInRange(newPositions.getFirstDoubleValue("Kappa"), -5.0);
        double phi = this.utils.angleInRange(newPositions.getFirstDoubleValue("Phi"), 0.0);
        Point3d actualTrans = new Point3d();
        Point3d actualDatum = new Point3d();
        this.bcm.getCurrentDatumTrans(actualDatum, actualTrans);
        Point3d trans = this.utils.CalculateTranslation(actualTrans, actualDatum.y, kappa, actualDatum.z, phi, this.bcm);
        newPositions.setSingleDoubleValue("X", trans.x);
        newPositions.setSingleDoubleValue("Y", trans.y);
        newPositions.setSingleDoubleValue("Z", trans.z);
        this.bcm.moveMotorsSyncronized(newPositions);
        Status stat = new Status();
        stat.setCode(Status_code.OK);
        stat.setMessage("BCM action performed by STAC");
        StringWriter stringWriter = new StringWriter();
        String xml_string = "";
        try {
            stat.marshal((Writer)stringWriter);
            xml_string = stringWriter.toString();
            FileWriter responseFile = new FileWriter(String.valueOf(workDir) + "STAC_DNA_kappa_collect_settings_status");
            responseFile.write(xml_string);
            responseFile.close();
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        catch (IOException ex) {
            Stac_Out.println("IOException: " + ex);
        }
    }

    void BCMgeneralAction_requested(String workDir) {
        Kappa_collect_settings _kappa_collect_settings = null;
        try {
            String xml_message = this.utils.opReadCl(String.valueOf(workDir) + "DNA_kappa_collect_settings_request");
            StringReader reader = new StringReader(xml_message);
            _kappa_collect_settings = (Kappa_collect_settings)Unmarshaller.unmarshal(Kappa_collect_settings.class, (Reader)reader);
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        ParamTable newPositions = new ParamTable();
        int i = 0;
        while (i < _kappa_collect_settings.getMotorSettingsCount()) {
            newPositions.setSingleDoubleValue(_kappa_collect_settings.getMotorSettings(i).getMotorName(), _kappa_collect_settings.getMotorSettings(i).getMotorValue());
            ++i;
        }
        this.bcm.moveMotorsSyncronized(newPositions);
        Status stat = new Status();
        stat.setCode(Status_code.OK);
        stat.setMessage("BCM action performed by STAC");
        StringWriter stringWriter = new StringWriter();
        String xml_string = "";
        try {
            stat.marshal((Writer)stringWriter);
            xml_string = stringWriter.toString();
            FileWriter responseFile = new FileWriter(String.valueOf(workDir) + "STAC_DNA_kappa_collect_settings_status");
            responseFile.write(xml_string);
            responseFile.close();
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        catch (IOException ex) {
            Stac_Out.println("IOException: " + ex);
        }
    }

    void BCMinfo_requested(String workDir) {
        Point3d trans = new Point3d();
        Point3d datum = new Point3d();
        this.bcm.getCurrentDatumTrans(datum, trans);
        Kappa_collect_settings kapSet = new Kappa_collect_settings();
        Kappa_motor_setting motSet = new Kappa_motor_setting();
        motSet.setMotorName("Omega");
        motSet.setMotorValue(datum.x);
        kapSet.addMotorSettings(motSet);
        motSet = new Kappa_motor_setting();
        motSet.setMotorName("Kappa");
        motSet.setMotorValue(datum.y);
        kapSet.addMotorSettings(motSet);
        motSet = new Kappa_motor_setting();
        motSet.setMotorName("Phi");
        motSet.setMotorValue(datum.z);
        kapSet.addMotorSettings(motSet);
        motSet = new Kappa_motor_setting();
        motSet.setMotorName("X");
        motSet.setMotorValue(trans.x);
        kapSet.addMotorSettings(motSet);
        motSet = new Kappa_motor_setting();
        motSet.setMotorName("Y");
        motSet.setMotorValue(trans.y);
        kapSet.addMotorSettings(motSet);
        motSet = new Kappa_motor_setting();
        motSet.setMotorName("Z");
        motSet.setMotorValue(trans.z);
        kapSet.addMotorSettings(motSet);
        kapSet.setComment("BCM query performed by STAC");
        StringWriter stringWriter = new StringWriter();
        String xml_string = "";
        try {
            kapSet.marshal((Writer)stringWriter);
            xml_string = stringWriter.toString();
            FileWriter responseFile = new FileWriter(String.valueOf(workDir) + "STAC_DNA_kappa_settings_response");
            responseFile.write(xml_string);
            responseFile.close();
        }
        catch (MarshalException mex) {
            Stac_Out.println("MarshallException:" + (Object)((Object)mex));
        }
        catch (ValidationException vex) {
            Stac_Out.println("ValidationException: " + (Object)((Object)vex));
        }
        catch (IOException ex) {
            Stac_Out.println("IOException: " + ex);
        }
    }

    public static void main(String[] args) {
        new STAC_DNA_listener(args);
    }
}

