/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import stacgui.ParamTableInt;
import stacgui.Stac_Out;

public class ParamTable
implements ParamTableInt {
    Vector pnames = new Vector();
    Vector pvalues = new Vector();

    public ParamTable() {
    }

    public ParamTable(Object[][] initData) {
        int i = 0;
        while (i < initData.length) {
            Vector<Object> actValueList = new Vector<Object>();
            int j = 1;
            while (j < initData[i].length) {
                actValueList.addElement(initData[i][j]);
                ++j;
            }
            this.setValueList(initData[i][0], actValueList);
            ++i;
        }
    }

    public ParamTable(String[] initNames, double[] initData) {
        int i = 0;
        while (i < initNames.length) {
            this.setSingleValue(initNames[i], new Double(initData[i]));
            ++i;
        }
    }

    public ParamTable(DataInputStream in) {
        this.load(in);
    }

    public ParamTable(ParamTable in) {
        try {
            int size = in.pnames.size();
            int i = 0;
            while (i < size) {
                String name = (String)in.pnames.elementAt(i);
                Vector list = new Vector();
                Vector origlist = (Vector)in.pvalues.elementAt(i);
                int j = 0;
                while (j < origlist.size()) {
                    list.addElement(origlist.elementAt(j));
                    ++j;
                }
                this.pnames.addElement(name);
                this.pvalues.addElement(list);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int findNameOfStarting(Object name) throws Exception {
        int index = 0;
        if (!(name instanceof String)) {
            throw new Exception("The passed Object is not a String");
        }
        index = 0;
        while (index < this.pnames.size()) {
            if (this.pnames.elementAt(index) instanceof String && ((String)name).startsWith((String)this.pnames.elementAt(index))) break;
            ++index;
        }
        if (index >= this.pnames.size()) {
            throw new Exception("Has not found any String in the table that would be contained by the String passed");
        }
        return index;
    }

    public Object getNameForParam(Object firstParam) throws Exception {
        int index = 0;
        index = 0;
        while (index < this.pnames.size()) {
            if (((Vector)this.pvalues.elementAt(index)).size() >= 1 && ((Vector)this.pvalues.elementAt(index)).elementAt(0).equals(firstParam)) break;
            ++index;
        }
        if (index >= this.pnames.size()) {
            throw new Exception("Has not found any Name in the table that would contained the parameter as its first value");
        }
        return this.pnames.elementAt(index);
    }

    public void removeOldValueList(Object name) {
        int index = this.pnames.indexOf(name);
        if (index == -1) {
            return;
        }
        this.pnames.removeElementAt(index);
        this.pvalues.removeElementAt(index);
    }

    public void setValueList(Object name, Object valueList) {
        this.removeOldValueList(name);
        this.pnames.addElement(name);
        this.pvalues.addElement(valueList);
    }

    public void setDoubleValueList(Object name, double[] valueList) {
        this.removeOldValueList(name);
        this.pnames.addElement(name);
        Vector<Double> v = new Vector<Double>();
        int l = 0;
        while (l < valueList.length) {
            v.addElement(new Double(valueList[l]));
            ++l;
        }
        this.pvalues.addElement(v);
    }

    public void setSingleValue(Object name, Object value) {
        this.removeOldValueList(name);
        this.pnames.addElement(name);
        Vector<Object> singleParam = new Vector<Object>();
        singleParam.addElement(value);
        this.pvalues.addElement(singleParam);
    }

    public void setSingleDoubleValue(Object name, double value) {
        this.removeOldValueList(name);
        this.pnames.addElement(name);
        Vector<Double> singleParam = new Vector<Double>();
        singleParam.addElement(new Double(value));
        this.pvalues.addElement(singleParam);
    }

    public void setDoubleValueAt(Object name, int pos, double value) {
        Vector<Double> valueList = this.getValueList(name);
        if (valueList == null) {
            this.removeOldValueList(name);
            this.pnames.addElement(name);
            valueList = new Vector<Double>();
            this.pvalues.addElement(valueList);
        }
        while (valueList.size() < pos) {
            valueList.addElement(new Double(0.0));
        }
        valueList.setElementAt(new Double(value), pos);
    }

    public Vector getValueList(Object name) {
        try {
            return (Vector)this.pvalues.elementAt(this.pnames.indexOf(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector getValueListOfStarting(Object name) {
        try {
            return (Vector)this.pvalues.elementAt(this.findNameOfStarting(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getValueAt(Object name, int pos) {
        try {
            return this.getValueList(name).elementAt(pos);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getFirstValue(Object name) {
        try {
            return this.getValueList(name).elementAt(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getFirstValueOfStarting(Object name) {
        try {
            return this.getValueListOfStarting(name).elementAt(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFirstStringValue(Object name) {
        try {
            return (String)this.getFirstValue(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFirstStringValueOfStarting(Object name) {
        try {
            return (String)this.getFirstValueOfStarting(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getFirstDoubleValue(Object name) {
        try {
            return (Double)this.getFirstValue(name);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public int getFirstIntegerValue(Object name) {
        try {
            return (Integer)this.getFirstValue(name);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getDoubleValueAt(Object name, int pos) {
        try {
            return (Double)this.getValueAt(name, pos);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double[] getDoubleVector(Object name) {
        try {
            double[] vl = new double[this.getValueList(name).size()];
            int i = 0;
            while (i < vl.length) {
                vl[i] = this.getDoubleValueAt(name, i);
                ++i;
            }
            return vl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clear() {
        this.pnames.clear();
        int i = 0;
        while (i < this.pvalues.size()) {
            ((Vector)this.pvalues.elementAt(i)).clear();
            ++i;
        }
        this.pvalues.clear();
    }

    public void dump() {
        Stac_Out.println("ParamTable: (size = " + this.pvalues.size() + ")");
        int i = 0;
        while (i < this.pvalues.size()) {
            int size = ((Vector)this.pvalues.elementAt(i)).size();
            Stac_Out.println("  parameter name: " + this.pnames.elementAt(i) + " (number of values = " + size + ")");
            Stac_Out.println("    " + (Vector)this.pvalues.elementAt(i));
            ++i;
        }
    }

    public void load(DataInputStream in) {
        try {
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                String name = in.readUTF();
                Vector<String> list = new Vector<String>();
                int vsize = in.readInt();
                int j = 0;
                while (j < vsize) {
                    String velement = in.readUTF();
                    list.addElement(velement);
                    ++j;
                }
                this.pnames.addElement(name);
                this.pvalues.addElement(list);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(DataOutputStream out) {
        try {
            out.writeInt(this.pnames.size());
            int i = 0;
            while (i < this.pnames.size()) {
                out.writeUTF("" + this.pnames.elementAt(i));
                Vector list = (Vector)this.pvalues.elementAt(i);
                out.writeInt(list.size());
                int j = 0;
                while (j < list.size()) {
                    out.writeUTF("" + list.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

