/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import stacgui.MotorWidget_actionAdapter;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacBCM;

class MotorWidget
extends JPanel {
    StacBCM bcm;
    String motorName = "";
    boolean rotMotor = true;
    ParamTable motorParams;
    JButton title = new JButton();
    JButton goLeft = new JButton();
    JSlider mvThere = new JSlider();
    JButton goRight = new JButton();
    JTextField stepSize = new JTextField();
    JButton getPos = new JButton();
    JTextField whereToGo = new JTextField();
    JButton goThere = new JButton();
    Dimension rbSize = new Dimension(100, 30);
    Dimension rbdSize = new Dimension(200, 30);
    Dimension fsbSize = new Dimension(30, 30);
    Dimension fsdbSize = new Dimension(60, 30);
    Dimension tfSize = new Dimension(1000, 30);
    Dimension tfnSize = new Dimension(10, 30);

    public MotorWidget(String motor, boolean rotMotor, StacBCM stacbcm) {
        this.mvThere.setEnabled(false);
        this.setLayout(new BoxLayout(this, 2));
        this.add((Component)this.title, null);
        this.title.setMinimumSize(this.rbSize);
        this.title.setMaximumSize(this.rbSize);
        this.title.setPreferredSize(this.rbSize);
        this.title.setToolTipText("Resyncronise with BCM");
        this.title.addActionListener(new MotorWidget_actionAdapter(this));
        this.title.setEnabled(true);
        this.add((Component)this.goLeft, null);
        this.goLeft.setText("<<");
        this.goLeft.setMinimumSize(this.fsdbSize);
        this.goLeft.setMaximumSize(this.fsdbSize);
        this.goLeft.setPreferredSize(this.fsdbSize);
        this.goLeft.setToolTipText("Decrease the Position by the Given Distance");
        this.goLeft.addActionListener(new MotorWidget_actionAdapter(this));
        this.goLeft.setEnabled(true);
        this.add((Component)this.mvThere, null);
        this.mvThere.addChangeListener(new MotorWidget_actionAdapter(this));
        this.mvThere.setPaintTicks(true);
        this.mvThere.setPaintLabels(true);
        this.mvThere.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.mvThere.setSnapToTicks(false);
        this.mvThere.setEnabled(true);
        this.add((Component)this.goRight, null);
        this.goRight.setText(">>");
        this.goRight.setMinimumSize(this.fsdbSize);
        this.goRight.setMaximumSize(this.fsdbSize);
        this.goRight.setPreferredSize(this.fsdbSize);
        this.goRight.setToolTipText("Increase the Position by the Given Distance");
        this.goRight.addActionListener(new MotorWidget_actionAdapter(this));
        this.goRight.setEnabled(true);
        this.add((Component)this.stepSize, null);
        if (rotMotor) {
            this.stepSize.setText("10.0");
        } else {
            this.stepSize.setText("0.05");
        }
        this.stepSize.setToolTipText("Change the Size of the Steps");
        this.stepSize.setMinimumSize(this.rbSize);
        this.stepSize.setMaximumSize(this.rbSize);
        this.stepSize.setPreferredSize(this.rbSize);
        this.add((Component)this.getPos, null);
        this.getPos.setText("GetPos");
        this.getPos.setMinimumSize(this.rbSize);
        this.getPos.setMaximumSize(this.rbSize);
        this.getPos.setPreferredSize(this.rbSize);
        this.getPos.setToolTipText("Get the Current Position");
        this.getPos.addActionListener(new MotorWidget_actionAdapter(this));
        this.getPos.setEnabled(true);
        this.add((Component)this.whereToGo, null);
        this.whereToGo.setToolTipText("Current/[Candidate] Position");
        this.whereToGo.setMinimumSize(this.rbSize);
        this.whereToGo.setMaximumSize(this.rbSize);
        this.whereToGo.setPreferredSize(this.rbSize);
        this.add((Component)this.goThere, null);
        this.goThere.setText("Mv to");
        this.goThere.setMinimumSize(this.rbSize);
        this.goThere.setMaximumSize(this.rbSize);
        this.goThere.setPreferredSize(this.rbSize);
        this.goThere.setToolTipText("Move to the Specified Position");
        this.goThere.addActionListener(new MotorWidget_actionAdapter(this));
        this.goThere.setEnabled(true);
        this.activate(motor, rotMotor, stacbcm);
        this.mvThere.setEnabled(true);
    }

    void changePosition(double chg, boolean relative) {
        if (!this.mvThere.isEnabled()) {
            return;
        }
        if (relative) {
            this.getPosition();
        }
        this.bcm.moveMotor(this.motorName, chg);
        this.getPosition();
    }

    void getPosition() {
        this.mvThere.setEnabled(false);
        double pos = this.bcm.getMotorPosition(this.motorName);
        this.mvThere.setValue((int)pos);
        this.whereToGo.setText(new PrintfFormat("%.3f").sprintf(pos));
        this.mvThere.setEnabled(true);
    }

    void activate(String motor, boolean rotMotor, StacBCM stacbcm) {
        this.motorName = motor;
        this.rotMotor = rotMotor;
        this.bcm = stacbcm;
        this.motorParams = this.bcm.getMotorParams(this.motorName);
        this.mvThere.setEnabled(false);
        this.title.setText(String.valueOf(this.motorName) + ":");
        if (rotMotor) {
            this.mvThere.setMajorTickSpacing(90);
            this.mvThere.setMinorTickSpacing(10);
            this.mvThere.setMinimum(Math.max(-600, (int)this.motorParams.getFirstDoubleValue("minpos")));
            this.mvThere.setMaximum(Math.min(600, (int)this.motorParams.getFirstDoubleValue("maxpos")));
            this.mvThere.setValue((int)this.motorParams.getFirstDoubleValue("pos"));
            this.whereToGo.setText(new PrintfFormat("%.3f").sprintf(this.motorParams.getFirstDoubleValue("pos")));
        } else {
            this.mvThere.setMajorTickSpacing(2);
            this.mvThere.setMinorTickSpacing(1);
            this.mvThere.setMinimum(Math.max(-5, (int)this.motorParams.getFirstDoubleValue("minpos")));
            this.mvThere.setMaximum(Math.min(5, (int)this.motorParams.getFirstDoubleValue("maxpos")));
            this.mvThere.setValue((int)this.motorParams.getFirstDoubleValue("pos"));
            this.whereToGo.setText(new PrintfFormat("%.3f").sprintf(this.motorParams.getFirstDoubleValue("pos")));
        }
        this.mvThere.setEnabled(true);
    }
}

