/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.behaviors.picking.PickMouseBehavior;
import com.sun.j3d.utils.behaviors.picking.PickRotateBehavior;
import com.sun.j3d.utils.behaviors.picking.PickTranslateBehavior;
import com.sun.j3d.utils.behaviors.picking.PickZoomBehavior;
import com.sun.j3d.utils.behaviors.picking.PickingCallback;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.web3d.j3d.loaders.Web3DLoader;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.renderer.j3d.browser.VRMLBrowserCanvas;
import stacgui.DemoFrame;
import stacgui.ParamTable;
import stacgui.StacUtil;
import stacgui.Stac_Out;

public class LoaderDemo
extends DemoFrame {
    JButton jBNav = new JButton();
    JButton jBEdit = new JButton();
    JButton jBOperate = new JButton();
    JLabel jLMode = new JLabel();
    JComboBox jCBDevice = new JComboBox();
    JButton jBDecrease = new JButton();
    JButton jBIncrease = new JButton();
    JButton jBGo = new JButton();
    JTextField jTFStep = new JTextField();
    Vector deviceList = new Vector();
    Vector collidingDeviceList = new Vector();
    StacUtil utils = new StacUtil();
    private MouseRotate mr = null;
    private MouseTranslate mt = null;
    private MouseZoom mz = null;
    private PickRotateBehavior pickRotate = null;
    private PickTranslateBehavior pickTranslate = null;
    private PickZoomBehavior pickZoom = null;
    private PickDragBehavior pickDrag = null;
    private static boolean staticLoad = false;
    private VRMLBrowserCanvas mainCanvas;
    private SimpleUniverse universe;
    private View view;
    private VRMLClock clock;
    private BranchGroup sceneRoot;
    private TransformGroup examineGroup;
    private BranchGroup sceneGroup;
    private TransformGroup vpTransGroup;
    private Label urlLabel;

    public LoaderDemo(String vGonioFileName) {
        super(vGonioFileName);
        Container content_pane = this.getContentPane();
        content_pane.setLayout(new BorderLayout());
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setDoubleBuffer(1);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dev = env.getDefaultScreenDevice();
        GraphicsConfiguration gfxConfig = dev.getBestConfiguration((GraphicsConfigTemplate)template);
        Canvas3D canvas = new Canvas3D(gfxConfig);
        content_pane.add("Center", (Component)canvas);
        this.urlLabel = new Label("File:");
        content_pane.add("North", this.urlLabel);
        JPanel south = new JPanel();
        content_pane.add("South", south);
        south.setLayout(new BoxLayout(south, 2));
        south.add(this.jBNav);
        this.jBNav.setText("Navigate");
        this.jBNav.setPreferredSize(new Dimension(100, 34));
        this.jBNav.setToolTipText("Mouse Navigation");
        this.jBNav.addActionListener(new Button_actionAdapter(this));
        south.add(this.jBEdit);
        this.jBEdit.setText("Edit");
        this.jBEdit.setPreferredSize(new Dimension(100, 34));
        this.jBEdit.setToolTipText("Mouse Editing of the Objects");
        this.jBEdit.addActionListener(new Button_actionAdapter(this));
        south.add(this.jBOperate);
        this.jBOperate.setText("Operate");
        this.jBOperate.setPreferredSize(new Dimension(100, 34));
        this.jBOperate.setToolTipText("Mouse Editing of the Objects");
        this.jBOperate.addActionListener(new Button_actionAdapter(this));
        JPanel southRight = new JPanel();
        south.add(southRight);
        southRight.setLayout(new BoxLayout(southRight, 3));
        JPanel southRUp = new JPanel();
        southRight.add(southRUp);
        southRUp.setLayout(new BoxLayout(southRUp, 2));
        southRUp.add(this.jLMode);
        this.jLMode.setText("Navigation");
        this.jLMode.setPreferredSize(new Dimension(100, 34));
        southRUp.add(this.jCBDevice);
        this.jCBDevice.setPreferredSize(new Dimension(200, 34));
        this.jCBDevice.addItem("???");
        this.jCBDevice.enableInputMethods(false);
        this.jCBDevice.setEnabled(false);
        this.jCBDevice.addActionListener(new Button_actionAdapter(this));
        JPanel southRDown = new JPanel();
        southRight.add(southRDown);
        southRDown.setLayout(new BoxLayout(southRDown, 2));
        southRDown.add(Box.createHorizontalGlue());
        southRDown.add(this.jBDecrease);
        this.jBDecrease.setText("-");
        this.jBDecrease.setPreferredSize(new Dimension(50, 34));
        this.jBDecrease.setMinimumSize(new Dimension(50, 34));
        this.jBDecrease.setMaximumSize(new Dimension(50, 34));
        this.jBDecrease.setToolTipText("Decreasing the Position of the Objects");
        this.jBDecrease.addActionListener(new Button_actionAdapter(this));
        southRDown.add(this.jTFStep);
        this.jTFStep.setText("1.0");
        this.jTFStep.setToolTipText("Stepsize for Increasing/Decreasing the Position");
        this.jTFStep.setMinimumSize(new Dimension(100, 34));
        this.jTFStep.setMaximumSize(new Dimension(100, 34));
        this.jTFStep.setPreferredSize(new Dimension(100, 34));
        southRDown.add(this.jBIncrease);
        this.jBIncrease.setText("+");
        this.jBIncrease.setPreferredSize(new Dimension(50, 34));
        this.jBIncrease.setMinimumSize(new Dimension(50, 34));
        this.jBIncrease.setMaximumSize(new Dimension(50, 34));
        this.jBIncrease.setToolTipText("Increasing the Position of the Objects");
        this.jBIncrease.addActionListener(new Button_actionAdapter(this));
        southRDown.add(this.jBGo);
        this.jBGo.setText("GO");
        this.jBGo.setPreferredSize(new Dimension(50, 34));
        this.jBGo.setMinimumSize(new Dimension(50, 34));
        this.jBGo.setMaximumSize(new Dimension(50, 34));
        this.jBGo.setToolTipText("Set the Position of the Objects");
        this.jBGo.addActionListener(new Button_actionAdapter(this));
        southRDown.add(Box.createHorizontalGlue());
        this.universe = new SimpleUniverse(canvas);
        SimpleUniverse.setJ3DThreadPriority((int)5);
        ViewingPlatform viewingPlatform = this.universe.getViewingPlatform();
        this.vpTransGroup = viewingPlatform.getViewPlatformTransform();
        Viewer viewer = this.universe.getViewer();
        this.view = viewer.getView();
        this.view.setBackClipDistance(1000.0);
        this.view.setFieldOfView(this.view.getFieldOfView() / 8.0);
        this.sceneRoot = new BranchGroup();
        Transform3D transform = new Transform3D();
        this.examineGroup = new TransformGroup(transform);
        this.examineGroup.setCapability(14);
        this.examineGroup.setCapability(12);
        this.examineGroup.setCapability(13);
        this.examineGroup.setCapability(17);
        this.examineGroup.setCapability(18);
        this.examineGroup.setCapability(1);
        this.sceneRoot.addChild((Node)this.examineGroup);
        BoundingSphere behaviorBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        this.mr = new MouseRotate();
        this.mr.setTransformGroup(this.examineGroup);
        this.mr.setSchedulingBounds((Bounds)behaviorBounds);
        this.sceneRoot.addChild((Node)this.mr);
        this.mt = new MouseTranslate();
        this.mt.setTransformGroup(this.examineGroup);
        this.mt.setSchedulingBounds((Bounds)behaviorBounds);
        this.sceneRoot.addChild((Node)this.mt);
        this.mz = new MouseZoom();
        this.mz.setTransformGroup(this.examineGroup);
        this.mz.setSchedulingBounds((Bounds)behaviorBounds);
        this.sceneRoot.addChild((Node)this.mz);
        KeyNavigatorBehavior keyNavBeh = new KeyNavigatorBehavior(this.universe.getViewingPlatform().getViewPlatformTransform());
        keyNavBeh.setSchedulingBounds((Bounds)behaviorBounds);
        this.sceneRoot.addChild((Node)keyNavBeh);
        MyPickCallbackClass myPickCallback = new MyPickCallbackClass();
        this.pickRotate = new PickRotateBehavior(this.sceneRoot, canvas, (Bounds)new BoundingSphere());
        this.pickRotate.setEnable(false);
        this.sceneRoot.addChild((Node)this.pickRotate);
        this.pickRotate.setupCallback((PickingCallback)myPickCallback);
        this.pickTranslate = new PickTranslateBehavior(this.sceneRoot, canvas, (Bounds)new BoundingSphere());
        this.pickTranslate.setEnable(false);
        this.sceneRoot.addChild((Node)this.pickTranslate);
        this.pickTranslate.setupCallback((PickingCallback)myPickCallback);
        this.pickZoom = new PickZoomBehavior(this.sceneRoot, canvas, (Bounds)new BoundingSphere());
        this.pickZoom.setEnable(false);
        this.sceneRoot.addChild((Node)this.pickZoom);
        this.pickZoom.setupCallback((PickingCallback)myPickCallback);
        this.pickDrag = new PickDragBehavior(this.sceneRoot, canvas, (Bounds)new BoundingSphere());
        this.pickDrag.setEnable(false);
        this.sceneRoot.addChild((Node)this.pickDrag);
        Appearance app = new Appearance();
        app.setCapability(9);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(0.2f, 0.4f, 0.8f);
        app.setColoringAttributes(ca);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.setSize(800, 600);
        this.setLocation(0, 40);
        this.setVisible(true);
        if (vGonioFileName != null) {
            this.LoadVirtualGonio(vGonioFileName);
        }
        this.SetLighting(this.sceneRoot);
        this.sceneRoot.compile();
    }

    public void read_section(String section, ParamTable Descr) {
        String[] tmp1 = section.split("\n");
        int l = 1;
        while (l < tmp1.length) {
            String[] tmp2;
            if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if (tmp2.length > offset + 1) {
                    String name = tmp2[0 + offset];
                    Vector<String> params = new Vector<String>();
                    int i = offset + 1;
                    while (i < tmp2.length) {
                        params.addElement(tmp2[i]);
                        ++i;
                    }
                    Descr.setValueList(name, params);
                }
            }
            ++l;
        }
    }

    public void read_section(String[] sections, String name, ParamTable pTable) {
        int i = 0;
        while (i < sections.length) {
            String[] tmp = sections[i].split("\\s+");
            if (tmp.length >= 2 && tmp[1].startsWith(name)) {
                this.read_section(sections[i], pTable);
                return;
            }
            ++i;
        }
    }

    public void LoadDevice(String[] sections, String name, TransformGroup parent) {
        ParamTable vDeviceDescriptor = new ParamTable();
        this.read_section(sections, name, vDeviceDescriptor);
        MyTransformGroup tg = new MyTransformGroup("null");
        tg = this.loadFile(String.valueOf(System.getProperty("STACDIR")) + "/BEAMLINE_DESCR/" + vDeviceDescriptor.getFirstStringValue("filename"), parent);
        if (tg == null) {
            return;
        }
        String pickable = vDeviceDescriptor.getFirstStringValue("Pickable");
        if (pickable != null && (pickable.equalsIgnoreCase("yes") || pickable.equalsIgnoreCase("true"))) {
            tg.setCapability(1);
            String tag = null;
            try {
                tag = vDeviceDescriptor.getFirstStringValue("Motor");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jCBDevice.addItem(tag == null ? vDeviceDescriptor.getFirstStringValue("Motor") : tag);
            this.deviceList.addElement(tg);
        } else {
            tg.clearCapability(1);
        }
        String collidable = vDeviceDescriptor.getFirstStringValue("Collidable");
        if (collidable != null && (collidable.equalsIgnoreCase("yes") || collidable.equalsIgnoreCase("true"))) {
            tg.setCapability(0);
        } else {
            tg.clearCapability(0);
        }
        String colliding = vDeviceDescriptor.getFirstStringValue("Colliding");
        if (colliding != null && (colliding.equalsIgnoreCase("yes") || colliding.equalsIgnoreCase("true"))) {
            tg.setCapability(0);
            this.collidingDeviceList.addElement(tg);
        } else {
            tg.clearCapability(0);
        }
        tg.setUserData(vDeviceDescriptor);
        Vector subDevices = vDeviceDescriptor.getValueList("holds");
        int i = 0;
        while (subDevices != null && i < subDevices.size()) {
            this.LoadDevice(sections, (String)subDevices.elementAt(i), tg);
            ++i;
        }
    }

    public void LoadVirtualGonio(String fname) {
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl(fname);
        String[] tmp1 = corr.split("SECTION");
        ParamTable vGonioDescriptor = new ParamTable();
        this.read_section(tmp1, "virtual_goniometer", vGonioDescriptor);
        Vector rootDevices = vGonioDescriptor.getValueList("holds");
        int i = 0;
        while (rootDevices != null && i < rootDevices.size()) {
            this.LoadDevice(tmp1, (String)rootDevices.elementAt(i), this.examineGroup);
            ++i;
        }
    }

    public void gotoLocation(URL url) {
        this.mainCanvas.loadWorld(url.toString());
    }

    public void gotoLocation(File file) {
        try {
            this.gotoLocation(file.toURL());
        }
        catch (MalformedURLException mue) {
            this.statusLabel.setText(mue.getMessage());
        }
    }

    protected void setWarning(String msg) {
        this.statusLabel.setText(msg);
    }

    protected void setError(String msg) {
        this.statusLabel.setText(msg);
    }

    private MyTransformGroup loadFile(String file, TransformGroup node) {
        MyTransformGroup newTrfGrp = new MyTransformGroup(file);
        int flag = -1;
        if (staticLoad) {
            flag &= 0xFFFFFFF7;
        }
        Web3DLoader loader = new Web3DLoader(-1);
        File f = new File(file);
        if (!f.exists() || f.exists() && !f.isFile()) {
            Stac_Out.println("Can't load the specified file: " + file);
            return null;
        }
        URL url = null;
        Scene scene = null;
        try {
            url = new URL(file);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            scene = loader.load(file);
        }
        catch (Exception e) {
            Stac_Out.println("Exception loading URL:" + e);
            e.printStackTrace();
            System.exit(0);
        }
        if (scene != null) {
            this.sceneGroup = scene.getSceneGroup();
            this.sceneGroup.setCapability(17);
            this.sceneGroup.setCapability(3);
            this.sceneGroup.setCapability(12);
            this.sceneGroup.setCapability(13);
            this.DisableLighting((Node)this.sceneGroup);
            this.sceneGroup.compile();
            BranchGroup newBranchGrp = new BranchGroup();
            newTrfGrp.setCapability(14);
            newTrfGrp.setCapability(12);
            newTrfGrp.setCapability(13);
            newTrfGrp.setCapability(17);
            newTrfGrp.setCapability(18);
            newTrfGrp.addChild((Node)this.sceneGroup);
            newBranchGrp.addChild((Node)newTrfGrp);
            node.addChild((Node)newBranchGrp);
            this.setViewpoint();
            this.urlLabel.setText(String.valueOf(this.urlLabel.getText()) + file + "; ");
        }
        return newTrfGrp;
    }

    private void setViewpoint() {
        Transform3D viewTrans = new Transform3D();
        Transform3D eyeTrans = new Transform3D();
        Vector3f pos = new Vector3f(0.0f, 0.0f, 10.0f);
        eyeTrans.set(pos);
        viewTrans.mul(eyeTrans);
        this.vpTransGroup.setTransform(viewTrans);
    }

    private void setupLighting(Scene scene) {
        Light[] lights = scene.getLightNodes();
        if (lights == null) {
            this.SetLighting(this.sceneRoot);
        }
    }

    private void DisableLighting(Node node) {
        if (node instanceof Group) {
            ((Group)node).setCapability(12);
            ((Group)node).setCapability(13);
            int i = ((Group)node).numChildren() - 1;
            while (i >= 0) {
                if (((Group)node).getChild(i) instanceof Light) {
                    ((Group)node).removeChild(i);
                } else {
                    this.DisableLighting(((Group)node).getChild(i));
                }
                --i;
            }
        }
    }

    private void SetLighting(BranchGroup sceneRoot) {
        BranchGroup lightBG = new BranchGroup();
        BoundingSphere lightBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        AmbientLight headLight = new AmbientLight();
        headLight.setCapability(13);
        headLight.setInfluencingBounds((Bounds)lightBounds);
        DirectionalLight headLight2 = new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(-1.0f, -1.0f, -1.0f));
        headLight2.setCapability(13);
        headLight2.setInfluencingBounds((Bounds)lightBounds);
        lightBG.addChild((Node)headLight2);
        lightBG.addChild((Node)headLight);
        sceneRoot.addChild((Node)lightBG);
    }

    public void checkCube() {
        BranchGroup newBranchGrp = new BranchGroup();
        TransformGroup newTrfGrp = new TransformGroup();
        newTrfGrp.setCapability(14);
        newTrfGrp.setCapability(12);
        newTrfGrp.setCapability(13);
        newTrfGrp.setCapability(17);
        newTrfGrp.setCapability(18);
        newTrfGrp.setCapability(1);
        newTrfGrp.addChild((Node)new ColorCube(0.4));
        newBranchGrp.addChild((Node)newTrfGrp);
        this.examineGroup.addChild((Node)newBranchGrp);
        this.urlLabel.setText(String.valueOf(this.urlLabel.getText()) + "ColorCube" + "; ");
    }

    public static void main(String[] args) {
        Object locString = null;
        if (args.length == 0) {
            Stac_Out.println("No file to display");
            Stac_Out.println("Usage: java LoaderDemo [-static] pathname | URL");
            System.exit(0);
        }
        staticLoad = args[0].equals("-static");
        String filename = args.length == 1 ? args[0] : args[1];
        LoaderDemo demo = new LoaderDemo(String.valueOf(System.getProperty("STACDIR")) + "/BEAMLINE_DESCR/vBCM.dat");
        demo.universe.addBranchGraph(demo.sceneRoot);
    }

    public class MyPickCallbackClass
    implements PickingCallback {
        public void transformChanged(int type, TransformGroup tg) {
            if (tg instanceof MyTransformGroup) {
                if (LoaderDemo.this.jLMode.getText().charAt(0) == 'E') {
                    LoaderDemo.this.jLMode.setText("Edit: " + ((MyTransformGroup)tg)._name);
                } else {
                    LoaderDemo.this.jLMode.setText("Operate: " + ((MyTransformGroup)tg)._name);
                }
            }
        }
    }

    public class PickDragBehavior
    extends PickMouseBehavior {
        private TransformGroup currentTG;

        PickDragBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
            super(canvas, root, bounds);
            this.setSchedulingBounds(bounds);
        }

        public void updateScene(int xpos, int ypos) {
            TransformGroup tg = null;
            SceneGraphPath[] tgList = this.pickScene.pickAllSorted(xpos, ypos);
            if (tgList == null) {
                return;
            }
            int i = 0;
            while (i < tgList.length) {
                tg = (TransformGroup)this.pickScene.pickNode(tgList[i], 32);
                if (tg instanceof MyTransformGroup) break;
                ++i;
            }
            if (i == tgList.length) {
                return;
            }
            if (tg != null && tg.getCapability(17) && tg.getCapability(18) && tg instanceof MyTransformGroup) {
                this.currentTG = tg;
                LoaderDemo.this.jLMode.setText("Operate: ");
                LoaderDemo.this.jCBDevice.setSelectedItem(((ParamTable)((MyTransformGroup)tg).getUserData()).getFirstStringValue("filename"));
            }
        }
    }

    public class CollisionDetector
    extends Behavior {
        private boolean inCollision = false;
        private Bounds bound = null;
        private WakeupOnCollisionEntry wEnter;
        private WakeupOnCollisionExit wExit;
        private Appearance app;
        private ColoringAttributes ca1;
        private ColoringAttributes ca2;
        private Vector collidingDevices = new Vector();
        private Vector wEnterColl = new Vector();
        private Vector wExitColl = new Vector();
        private int collCounter = 0;

        public CollisionDetector(Bounds bound, Appearance app) {
            this.bound = bound;
            this.app = app;
            this.inCollision = false;
            this.ca1 = new ColoringAttributes();
            this.ca1.setColor(0.9f, 0.3f, 0.2f);
            this.ca2 = new ColoringAttributes();
            this.ca2.setColor(0.2f, 0.4f, 0.8f);
        }

        public CollisionDetector(Vector devices, Appearance app) {
            this.app = app;
            this.inCollision = false;
            this.ca1 = new ColoringAttributes();
            this.ca1.setColor(0.9f, 0.3f, 0.2f);
            this.ca2 = new ColoringAttributes();
            this.ca2.setColor(0.2f, 0.4f, 0.8f);
            int i = 0;
            while (i < devices.size()) {
                this.collidingDevices.addElement(devices.elementAt(i));
                ++i;
            }
        }

        public void initialize() {
            if (this.bound != null) {
                this.wEnter = new WakeupOnCollisionEntry(this.bound);
                this.wExit = new WakeupOnCollisionExit(this.bound);
                this.wakeupOn((WakeupCondition)this.wEnter);
            } else if (this.collidingDevices.size() > 0) {
                int i = 0;
                while (i < this.collidingDevices.size()) {
                    this.wEnter = new WakeupOnCollisionEntry((Node)((MyTransformGroup)((Object)this.collidingDevices.elementAt(i))));
                    this.wEnterColl.addElement(this.wEnter);
                    this.wakeupOn((WakeupCondition)this.wEnter);
                    this.wExit = new WakeupOnCollisionExit((Node)((MyTransformGroup)((Object)this.collidingDevices.elementAt(i))));
                    this.wExitColl.addElement(this.wExit);
                    ++i;
                }
            }
        }

        public void processStimulus(Enumeration criteria) {
            if (this.bound != null) {
                boolean bl = this.inCollision = !this.inCollision;
                if (this.inCollision) {
                    this.app.setColoringAttributes(this.ca1);
                    this.wakeupOn((WakeupCondition)this.wExit);
                } else {
                    this.app.setColoringAttributes(this.ca2);
                    this.wakeupOn((WakeupCondition)this.wEnter);
                }
            } else {
                this.collCounter = (WakeupCondition)criteria instanceof WakeupOnCollisionEntry ? ++this.collCounter : --this.collCounter;
                if (this.collCounter == 1) {
                    this.app.setColoringAttributes(this.ca1);
                } else if (this.collCounter <= 0) {
                    this.app.setColoringAttributes(this.ca2);
                    this.collCounter = 0;
                }
                this.wakeupOn((WakeupCondition)criteria);
            }
        }
    }

    public class MyTransformGroup
    extends TransformGroup {
        public String _name;

        public MyTransformGroup(String name) {
            this._name = name;
        }
    }

    class Button_actionAdapter
    implements ActionListener {
        LoaderDemo adaptee;

        Button_actionAdapter(LoaderDemo adaptee) {
            this.adaptee = adaptee;
        }

        public void DoOperation(double modification, boolean absolute) {
            ParamTable userData = (ParamTable)LoaderDemo.this.pickDrag.currentTG.getUserData();
            if (userData == null) {
                return;
            }
            Transform3D currentTrafo = new Transform3D();
            LoaderDemo.this.pickDrag.currentTG.getTransform(currentTrafo);
            String rotational = userData.getFirstStringValue("Rotational");
            if (rotational != null && (rotational.equalsIgnoreCase("yes") || rotational.equalsIgnoreCase("true"))) {
                Vector axis = userData.getValueList("AxisLocation");
                Vector3d rotCenter = new Vector3d();
                try {
                    rotCenter.set(new Double((String)axis.elementAt(0)).doubleValue(), new Double((String)axis.elementAt(1)).doubleValue(), new Double((String)axis.elementAt(2)).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Vector3d toRotCenter = new Vector3d(rotCenter);
                toRotCenter.scale(-1.0);
                axis = userData.getValueList("AxisDirection");
                Vector3d rotAxis = new Vector3d(0.0, 0.0, 1.0);
                try {
                    rotAxis.set(new Double((String)axis.elementAt(0)).doubleValue(), new Double((String)axis.elementAt(1)).doubleValue(), new Double((String)axis.elementAt(2)).doubleValue());
                    if (rotAxis.length() <= 1.0E-6) {
                        rotAxis.set(0.0, 0.0, 1.0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Transform3D moveToCenter = new Transform3D();
                moveToCenter.set(toRotCenter);
                Transform3D moveFromCenter = new Transform3D();
                moveFromCenter.set(rotCenter);
                Transform3D trf = new Transform3D();
                trf.mul(currentTrafo, moveFromCenter);
                trf.mul(moveToCenter, trf);
                Matrix3d currRot = new Matrix3d();
                trf.get(currRot);
                AxisAngle4d aa = new AxisAngle4d();
                LoaderDemo.this.utils.CalculateRotation(currRot, aa, 1.0E-5);
                Vector3d actRot = new Vector3d();
                actRot.x = aa.x;
                actRot.y = aa.y;
                actRot.z = aa.z;
                if (actRot.dot(rotAxis) < 0.0) {
                    aa.angle = -aa.angle;
                }
                aa.x = rotAxis.x;
                aa.y = rotAxis.y;
                aa.z = rotAxis.z;
                aa.angle = absolute ? modification * Math.PI / 180.0 : (aa.angle += modification * Math.PI / 180.0);
                trf.set(aa);
                trf.mul(trf, moveToCenter);
                trf.mul(moveFromCenter, trf);
                LoaderDemo.this.pickDrag.currentTG.setTransform(trf);
            } else {
                Vector axis = userData.getValueList("AxisDirection");
                Vector3d rotAxis = new Vector3d(0.0, 0.0, 1.0);
                try {
                    rotAxis.set(new Double((String)axis.elementAt(0)).doubleValue(), new Double((String)axis.elementAt(1)).doubleValue(), new Double((String)axis.elementAt(2)).doubleValue());
                    if (rotAxis.length() <= 1.0E-6) {
                        rotAxis.set(0.0, 0.0, 1.0);
                    }
                }
                catch (Exception toRotCenter) {
                    // empty catch block
                }
                rotAxis.normalize();
                Vector3d currentTrans = new Vector3d();
                currentTrafo.get(currentTrans);
                if (absolute) {
                    currentTrans.set(0.0, 0.0, 0.0);
                }
                rotAxis.scale(modification);
                currentTrans.add((Tuple3d)rotAxis);
                currentTrafo.setTranslation(currentTrans);
                LoaderDemo.this.pickDrag.currentTG.setTransform(currentTrafo);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.adaptee.jBNav) {
                LoaderDemo.this.pickRotate.setEnable(false);
                LoaderDemo.this.pickTranslate.setEnable(false);
                LoaderDemo.this.pickZoom.setEnable(false);
                LoaderDemo.this.pickDrag.setEnable(false);
                LoaderDemo.this.mr.setEnable(true);
                LoaderDemo.this.mt.setEnable(true);
                LoaderDemo.this.mz.setEnable(true);
                LoaderDemo.this.jLMode.setText("Navigation");
                LoaderDemo.this.jCBDevice.setSelectedItem("???");
                LoaderDemo.this.jCBDevice.setEnabled(false);
            } else if (e.getSource() == this.adaptee.jBEdit) {
                LoaderDemo.this.mr.setEnable(false);
                LoaderDemo.this.mt.setEnable(false);
                LoaderDemo.this.mz.setEnable(false);
                LoaderDemo.this.pickDrag.setEnable(false);
                LoaderDemo.this.pickRotate.setEnable(true);
                LoaderDemo.this.pickTranslate.setEnable(true);
                LoaderDemo.this.pickZoom.setEnable(true);
                LoaderDemo.this.jLMode.setText("Edit: ");
                LoaderDemo.this.jCBDevice.setSelectedItem("???");
                LoaderDemo.this.jCBDevice.setEnabled(false);
            } else if (e.getSource() == this.adaptee.jBOperate) {
                LoaderDemo.this.pickRotate.setEnable(false);
                LoaderDemo.this.pickTranslate.setEnable(false);
                LoaderDemo.this.pickZoom.setEnable(false);
                LoaderDemo.this.mr.setEnable(true);
                LoaderDemo.this.mt.setEnable(true);
                LoaderDemo.this.mz.setEnable(true);
                LoaderDemo.this.pickDrag.setEnable(true);
                LoaderDemo.this.jLMode.setText("Operate: ");
                LoaderDemo.this.jCBDevice.setEnabled(true);
            } else if (e.getSource() == this.adaptee.jBDecrease) {
                if (LoaderDemo.this.jLMode.getText().charAt(0) == 'O') {
                    this.DoOperation(-1.0 * new Double(LoaderDemo.this.jTFStep.getText()), false);
                }
            } else if (e.getSource() == this.adaptee.jBIncrease) {
                if (LoaderDemo.this.jLMode.getText().charAt(0) == 'O') {
                    this.DoOperation(new Double(LoaderDemo.this.jTFStep.getText()), false);
                }
            } else if (e.getSource() == this.adaptee.jBGo) {
                if (LoaderDemo.this.jLMode.getText().charAt(0) == 'O') {
                    this.DoOperation(new Double(LoaderDemo.this.jTFStep.getText()), true);
                }
            } else if (e.getSource() == this.adaptee.jCBDevice && LoaderDemo.this.jLMode.getText().charAt(0) == 'O') {
                int device = LoaderDemo.this.jCBDevice.getSelectedIndex();
                if (--device < 0) {
                    device = 0;
                    LoaderDemo.this.jCBDevice.setSelectedIndex(device);
                }
                LoaderDemo.this.pickDrag.currentTG = (MyTransformGroup)((Object)LoaderDemo.this.deviceList.elementAt(device));
            }
        }
    }
}

