/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import javax.swing.JLabel;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;

public class DownloadProgressListener
implements ProgressListener {
    private JLabel statusLabel;
    private ErrorReporter reporter;

    public DownloadProgressListener(JLabel status, ErrorReporter rep) {
        this.statusLabel = status;
        this.reporter = rep;
    }

    public void connectionEstablished(ProgressEvent evt) {
        this.statusLabel.setText(evt.getMessage());
    }

    public void handshakeInProgress(ProgressEvent evt) {
        this.statusLabel.setText(evt.getMessage());
    }

    public void downloadStarted(ProgressEvent evt) {
        this.statusLabel.setText(evt.getMessage());
    }

    public void downloadUpdate(ProgressEvent evt) {
        ResourceConnection conn = evt.getSource();
        URI uri = conn.getURI();
        StringBuffer buf = new StringBuffer(uri.toExternalForm());
        buf.append(" (");
        buf.append(evt.getValue());
        buf.append(")");
        this.statusLabel.setText(buf.toString());
    }

    public void downloadEnded(ProgressEvent evt) {
        String msg = String.valueOf(evt.getMessage()) + " complete";
        this.statusLabel.setText(msg);
        this.reporter.messageReport(msg);
    }

    public void downloadError(ProgressEvent evt) {
        this.statusLabel.setText(evt.getMessage());
        this.reporter.errorReport(evt.getMessage(), null);
    }
}

