/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.URN;
import org.ietf.uri.URNResolverService;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.Web3DResourceFactory;
import org.web3d.net.resolve.Web3DURNResolver;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;

public abstract class DemoFrame
extends JFrame
implements ActionListener {
    private static final String UMEL_INSTALL_DIR = null;
    private static final String GEOVRML_INSTALL_DIR = null;
    private static final String UMEL_PREFIX = "umel";
    private static final String GEOVRML_PREFIX = "geovrml";
    protected JTextField urlTextField;
    private JButton locationGoButton;
    protected JLabel statusLabel;

    public DemoFrame(String title) {
        super(title);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dev = env.getDefaultScreenDevice();
        this.urlTextField = new JTextField();
        this.urlTextField.setText(System.getProperty("user.dir"));
        this.urlTextField.addActionListener(this);
        this.urlTextField.requestFocus();
        this.locationGoButton = new JButton(" Go! ");
        this.locationGoButton.addActionListener(this);
        JLabel l1 = new JLabel("Location: ");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)l1, "West");
        p1.add((Component)this.locationGoButton, "East");
        p1.add((Component)this.urlTextField, "Center");
        Container content_pane = this.getContentPane();
        content_pane.add((Component)p1, "North");
        this.statusLabel = new JLabel("Enter a world to load");
        content_pane.add((Component)this.statusLabel, "South");
        this.setSize(600, 600);
        this.setLocation(40, 40);
        this.setDefaultCloseOperation(3);
    }

    public abstract void gotoLocation(URL var1);

    public abstract void gotoLocation(File var1);

    protected abstract void setWarning(String var1);

    protected abstract void setError(String var1);

    protected void setupProperties(BrowserCore core, WorldLoaderManager loader) {
        FileNameMap fn_map;
        ContentHandlerFactory c_fac;
        System.setProperty("sun.awt.font.advancecache", "off");
        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
        System.setProperty("java.content.handler.pkgs", "vlc.content");
        URIResourceStreamFactory res_fac = URI.getURIResourceStreamFactory();
        if (!(res_fac instanceof Web3DResourceFactory)) {
            res_fac = new Web3DResourceFactory(res_fac);
            URI.setURIResourceStreamFactory((URIResourceStreamFactory)res_fac);
        }
        if (!((c_fac = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
            c_fac = new VRMLContentHandlerFactory(core, loader, c_fac);
            URI.setContentHandlerFactory((ContentHandlerFactory)c_fac);
        }
        if (!((fn_map = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
            fn_map = new VRMLFileNameMap(fn_map);
            URI.setFileNameMap((FileNameMap)fn_map);
        }
        Web3DURNResolver resolver = new Web3DURNResolver();
        resolver.registerPrefixLocation(UMEL_PREFIX, UMEL_INSTALL_DIR);
        resolver.registerPrefixLocation(GEOVRML_PREFIX, GEOVRML_INSTALL_DIR);
        URN.addResolver((URNResolverService)resolver);
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.locationGoButton || src == this.urlTextField) {
            String location = this.urlTextField.getText();
            File f = new File(location);
            if (f.exists()) {
                if (f.isDirectory()) {
                    this.setError("File is a directory");
                } else {
                    this.gotoLocation(f);
                    this.statusLabel.setText("World Loaded Successfully");
                }
            } else {
                try {
                    URL url = new URL(location);
                    this.gotoLocation(url);
                    this.statusLabel.setText("World Loaded Successfully");
                }
                catch (MalformedURLException mue) {
                    this.setError("Invalid URL: " + location);
                }
            }
        }
    }
}

