/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class AlignTableModel
extends AbstractTableModel {
    private String[] alignColumnNames = new String[]{"ID", "V1", "V2", "Omega", "Kappa", "Phi", "Trans", "Rank"};
    private Vector[] alignData = new Vector[this.alignColumnNames.length];

    public AlignTableModel() {
        int i = 0;
        while (i < this.alignColumnNames.length) {
            this.alignData[i] = new Vector(0);
            ++i;
        }
    }

    public int getColumnCount() {
        return this.alignColumnNames.length;
    }

    public int getRowCount() {
        return this.alignData[0].size();
    }

    public String getColumnName(int col) {
        return this.alignColumnNames[col];
    }

    public int getColId(String name) {
        int i = 0;
        while (i < this.alignColumnNames.length) {
            if (this.alignColumnNames[i].equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Object getValueAt(int row, int col) {
        return this.alignData[col].elementAt(row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setValueAt(Object value, int row, int col) {
        if (value == "ClearTable") {
            int i = 0;
            while (i < this.alignColumnNames.length) {
                this.alignData[i].removeAllElements();
                ++i;
            }
            this.fireTableStructureChanged();
        } else if (value != "ActivateCells") {
            if (row >= 0 && row < this.getRowCount() && col >= 0 && col < this.getColumnCount()) {
                this.alignData[col].setElementAt(value, row);
                this.fireTableCellUpdated(row, col);
            } else if (row == this.getRowCount()) {
                int i = 0;
                while (i < this.alignColumnNames.length) {
                    this.alignData[i].addElement(value);
                    ++i;
                }
                this.fireTableStructureChanged();
            }
        }
    }
}

