/****************************************************************************

                     uMatrix C++ Matrix Library

    Copyright (C) 1996  David Weber, Michael Sipe and Rajesh Shenoy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    David Weber can be contacted at weber@ece.cmu.edu or 
    http://www.ece.cmu.edu/afs/ece/usr/weber/.home-page.html

****************************************************************************/
#include<compatibilita.h>
#ifndef lapack_included
#define lapack_included
/*
$Author: shenoy $
$Revision: 1.7 $
$Log: lapack.h,v $
 * Revision 1.7  1996/08/12  22:18:31  shenoy
 * 1. Added the function zheev to overload uSymEig for Complex
 *
 * Revision 1.6  1996/08/09  22:40:58  shenoy
 * Added the expert drivers cgeevx, sgeevx, dgeevx and zgeevx to lapack.h
 * file
 *
 * Revision 1.5  1996/06/17  15:36:09  weber
 * Added Gnu library public license header
 *
 * Revision 1.4  1996/04/18  15:29:12  weber
 * Fixes to allow libg++ 2.7.x with the standard template library complex
 * class to be used if it is present. The code remains compatible with
 * previous versions of libg++
 *
Revision 1.3  1995/09/28 04:25:45  weber
Fixed a stupid typo

 * Revision 1.2  1995/09/28  04:23:49  weber
 * Added headers for the Xgemm blas routines. I also added RCS headers
 *

 */

#include <complex.h>

extern "C"  // Lapack declarations
{
void sgetrf_( int *m, int *n, float *A, int *lda, int *ipiv, int*info );
void sgetri_( int *n, float *A, int *lda, int *ipiv, float* work, int *lwork,
              int *info );
void dgetrf_( int *m, int *n, double *A, int *lda, int *ipiv, int*info );
void dgetri_( int *n, double *A, int *lda, int *ipiv, double* work, int *lwork,
              int *info );
void cgetrf_( int *m, int *n, fComplex *A, int *lda, int *ipiv, 
	      int *info );
void cgetri_( int *n, fComplex *A, int *lda, int *ipiv, 
	      fComplex *work, int *lwork, int *info );
void zgetrf_( int *m, int *n, Complex *A, int *lda, int *ipiv, 
	      int *info );
void zgetri_( int *n, Complex *A, int *lda, int *ipiv, Complex *work, 
	      int *lwork, int *info );

void dgeev_( char * jobvl, char* jobvr, int *N, double *A, int *lda,
	     double *wr, double *wi, double *vl, int *ldvl, double *vr,
	     int *ldvr, double *work, int *lwork, int *info );
void dsyev_( char *jobz, char *uplo, int *N, double *a, int *lda, double *w,
             double *work, int *lwork, int *info );

void sgeev_( char * jobvl, char* jobvr, int *N, float *A, int *lda,
	     float *wr, float *wi, float *vl, int *ldvl, float *vr,
	     int *ldvr, float *work, int *lwork, int *info );
void ssyev_( char *jobz, char *uplo, int *N, float *a, int *lda, float *w,
             float *woArk, int *lwork, int *info );

void cgeev_( char * jobvl, char* jobvr, int *N, fComplex *A, int *lda,
	     fComplex *w, fComplex *vl, int *ldvl, fComplex *vr,
	     int *ldvr, fComplex *work, int *lwork, float *rwork, 
	     int *info );
void cgeevx_( char *balanc, char *jobvl, char *jobvr, char *sense, int
	      *N, fComplex *A, int *lda, fComplex *w, fComplex *vl,
	      int *ldvl, fComplex *vr, int *ldvr, int *ilo, int *ihi,
	      float *scale, float *abnrm, float *rconde, float
	      *rcondv, fComplex *work, int *lwork, float *rwork,  
	     int *info );
void sgeevx_( char *balanc, char *jobvl, char *jobvr, char *sense, int
	      *N, float *A, int *lda, float *wr, float *wi, float *vl,
	      int *ldvl, float *vr, int *ldvr, int *ilo, int *ihi,
	      float *scale, float *abnrm, float *rconde, float
	      *rcondv, float *work, int *lwork, int *iwork,  
	     int *info );

void zgeevx_( char *balanc, char *jobvl, char *jobvr, char *sense, int
	      *N, Complex *A, int *lda, Complex *w, Complex *vl,
	      int *ldvl, Complex *vr, int *ldvr, int *ilo, int *ihi,
	      double *scale, double *abnrm, double *rconde, double
	      *rcondv, Complex *work, int *lwork, double *rwork,  
	     int *info );
void dgeevx_( char *balanc, char *jobvl, char *jobvr, char *sense, int
	      *N, double *A, int *lda, double *wr, double *wi, double *vl,
	      int *ldvl, double *vr, int *ldvr, int *ilo, int *ihi,
	      double *scale, double *abnrm, double *rconde, double
	      *rcondv, double *work, int *lwork, int *iwork,  
	     int *info );

void cheev_( char *jobz, char *uplo, int *N, fComplex *a, int *lda, 
	     float *w, fComplex *work, int *lwork, float *rwork,
	     int *info );
void zheev_( char *jobz, char *uplo, int *N, Complex *a, int *lda, 
	     double *w, Complex *work, int *lwork, double *rwork,
	     int *info );

void sgelss_( int *m, int *n, int *nrhs, float *A, int *lda, float *b, 
	    int *ldb, float *s, float *rcond, int *rank, float *work,
	    int *lwork, int *info );

void cgelss_( int *m, int *n, int *nrhs, fComplex *A, int *lda, fComplex *b,
	    int *ldb, float *s, float *rcond, int *rank, fComplex *work,
	    int *lwork, float *rwork, int *info );

void dgelss_( int *m, int *n, int *nrhs, double *A, int *lda, double *b, 
	    int *ldb, double *s, double *rcond, int *rank, double *work, 
	    int *lwork, int *info );

void zgelss_( int *m, int *n, int *nrhs, Complex *A, int *lda, Complex *b, 
	    int *ldb, double *s, double *rcond, int *rank, Complex *work, 
	    int *lwork, double *rwork, int *info );

void sgesvd_(char *jobu, char *jobvt, int *m,int *n,  float *A, int *lda,
	     float *s, float * U, int *ldu, float *VT, int *ldvt, float *work, 
	     int *lwork, int *info);
void cgesvd_(char *jobu, char *jobvt, int *m,int *n,  fComplex *A, int *lda,
	     float *s, fComplex * U, int *ldu, fComplex *VT, int *ldvt,
	     fComplex *work, int *lwork, float *rwork, int *info);
void dgesvd_(char *jobu, char *jobvt, int *m,int *n,  double *A, int *lda,
	     double *s, double * U, int *ldu, double *VT, int *ldvt, 
	     double *work, int *lwork, int *info);
void zgesvd_(char *jobu, char *jobvt, int *m,int *n,  Complex *A, int *lda,
	     double *s, Complex * U, int *ldu, Complex *VT, int *ldvt,
	     Complex *work, int *lwork, double *rwork, int *info);

// BLAS stuff we use
void sgemm_( char *transa, char *transb, int *m, int *n, int *k, 
	     float *alpha, float *a, int *Ida, float *b, int *Idb, 
	     float *beta, float* c, int *Idc );
void dgemm_( char *transa, char *transb, int *m, int *n, int *k, 
	     double *alpha, double *a, int *Ida, double *b, int *Idb, 
	     double *beta, double* c, int *Idc );
void cgemm_( char *transa, char *transb, int *m, int *n, int *k, 
	     fComplex *alpha, fComplex *a, int *Ida, fComplex *b, int *Idb, 
	     fComplex *beta, fComplex* c, int *Idc );
void zgemm_( char *transa, char *transb, int *m, int *n, int *k, 
	     Complex *alpha, Complex *a, int *Ida, Complex *b, int *Idb, 
	     Complex *beta, Complex* c, int *Idc );


void saxpy_(int *n, float *a, float *x, int *inx, float *y, int *incy);
void daxpy_(int *n, double *a, double  *x, int *inx, double  *y, int *incy);
void caxpy_(int *n, fComplex *a, fComplex *x, int *inx,fComplex *y, int *incy);
void zaxpy_(int *n,Complex *a,Complex *x, int *inx,Complex *y, int *incy);

void dcopy_(int *n,double *dx,int *incx,double * dy, int * incy); 
void scopy_(int *n,float *dx,int *incx,float * dy, int * incy); 

}

#endif







