/***************************************************************************
                          asfhfs.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

//  mpage -W 120 -1 -f -X -v -Ftimes -b A4   asfhfs.cc 
 
#include<stdio.h>
#include<iostream.h>
#include<string.h>
#include<math.h>
#include<complex.h> 
#include<nMatrix/nMatrix.h>
#include <nMatrix/nLapack.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"


#include<Sparsa.h>

#include"asfhfs.h"

extern char opzioni[];

#define PACKETBUFF 1000

void serialuMatrix(fichier &f, uMatrix<double> &a);

#define Abs(a) ( ((a)>0)?  (a):(-(a))  )
#define Min(a,b) ( ((a)<(b))?  (a):(b) )
#define Max(a,b) ( ((a)>(b))?  (a):(b) )



// #define DEBUG
#define tDEBUG

int **i_matrice(int n,int m)
{
  int  **i;
  if(n==1) 
    {
      i=new int *;
    }
  else
    {
      i=new int * [n] ;
    } 
  for(int k=0; k<n;k++)
    {
      if(m==1) 
	{
	  i[k]=new int ;
	}
      else
	{
	  i[k]=new int [m] ;
	}
    }
  return i;
}


void LIVELLO::serializza(fichier &f)
{
  f.serialcomment("n=");
  f.serialchar(&n);
  f.serialcomment("l=");
  f.serialchar(&l);
  f.serialcomment("mz=");
  f.serialchar(&mz);
  f.serialcomment("sz=");
  f.serialchar(&sz, LINEASALTO);
}

void LIMITATIONS::serializza(fichier &f)
{
  f.serialcomment("LIMITAZIONE");
  f.serialcomment("jz=");
  f.serialdouble(&jz);
  f.serialcomment("minSz=");
  f.serialdouble(&minSz);
  f.serialcomment("maxSz=");
  f.serialdouble(&maxSz, LINEASALTO);
}


void DETERMINANTE::stampa()
{
  for(int i=0; i< nel ;i++)
    { 
      livello[i].stampa();
    }
}

void DETERMINANTE::riordinalivelli()
{
  LIVELLO dum;
  for(int i=0; i<nel-1;i++)
    {
      int count =0;
      for(int j=0;j<nel-1-i;j++)
	{
	  if(livello[j]>livello[j+1])
	    {
	      dum=livello[j];
	      livello[j]=livello[j+1];
	      livello[j+1]=dum;
	      segno=-segno;
	      count++;
	    }
	}
      if(count==0) break;
    }
    preMz= Mz(*this);
    preSz= Sz(*this);

};

int  DETERMINANTE::not_doubly_occuped(int is)
{
  for(int i=0; i<is;i++)
    {
      if(livello[i]==livello[is]) { /* cout << "no\n";  */return 0 ; }
    }
  for(int i=is+1; i<nel;i++)
    {
      if(livello[i]==livello[is]) {/*  cout << "no\n"; */ return 0;}
    }
  return 1;
}


void DETERMINANTE::copia(DETERMINANTE &a)
{
  if(nel!=a.nel)
    {
      resize(a.nel);
    }
  memcpy(livello,a.livello, nel*sizeof(LIVELLO));
  segno=a.segno;
  tavola=0;
  preMz=a.preMz;
  preSz=a.preSz;
};


DETERMINANTE::DETERMINANTE()
{
  /*  cout << " SONO in DTE\n"; */
  nel=0;
  livello=0;
  tavola=0;
  segno=1;
}

void DETERMINANTE::creatoreDETERMINANTE()
{
  /*  cout << " SONO in DTE\n"; */
  nel=0;
  livello=0;
  tavola=0;
  segno=1;
}

DETERMINANTE::DETERMINANTE(int n)
{
  nel=0;
  livello=0;
  resize(n);
  tavola=0;
}

void DETERMINANTE::serializza(fichier &f)
{
  f.serialcomment("DETERMINANTE\n");
  f.serialcomment("NEL=");
  f.serialint(&nel, LINEASALTO);
  if(f.serial==LEGGI) resize(nel);
  f.serialcomment("LIVELLI\n");
  for(int i=0; i<nel; i++)
    {
      livello[i].serializza(f);
    }
  
  f.serialcomment("SEGNO\n");
 
  f.serialint(&segno);
  if(f.serial==LEGGI) {
  	preMz=Mz(*this);
  	preSz=Sz(*this);
  }

}





DETERMINANTE::~DETERMINANTE()
{
  /* cout << " sono in ~DTER\n"; */
  if(livello && nel)
      delete (char*) livello;

  nel=0;
  livello=0;
  if(tavola)
    {
      distruggitavola();
    }
}

void DETERMINANTE::creatavola(int N,int L)
{
  tavola=new int *** [N];
  tavola--;
  for(int in=1; in<=N;in++)
    {
      tavola[in]=new int ** [L+1];
      
      for(int il=0; il<=L;il++)
	{
	  tavola[in][il] =new int * [2*L+1];
	  tavola[in][il]+=L;
  
	  for(int im=-L; im<=L;im++)
	    {
	      tavola[in][il][im] =new int  [3];
	      tavola[in][il][im] +=1;	  
	    }
	}
    }
}

void DETERMINANTE::preparatavola()
{
  if (tavola) return;
  int N,L;
  get_max_nl(N,L);
  creatavola(N,L);
  for(int in=1; in<=N;in++) for(int il=0; il<=L;il++) 
    for(int im=-L; im<=L;im++) for(int is=-1; is<=1;is++)
      tavola[in][il][im][is]=-1;
  
  for(int i=0; i<nel;i++)
    {
      tavola[getlevel(i).n][getlevel(i).l][getlevel(i).mz][  (getlevel(i).sz) ]
	= i;
    }
}


void DETERMINANTE::distruggitavola()
{
  if(tavola==0) return;
  int N,L;
  get_max_nl(N,L);
  
  for(int in=1; in<=N;in++)
    {
      for(int il=0; il<=L;il++)
	{ 
	  for(int im=-L; im<=L;im++)
	    {
	      delete (tavola[in][il][im]-1);
	    }
	  tavola[in][il]-=L;
	  delete tavola[in][il];
	}
      delete tavola[in];
    }
  tavola++;
  delete tavola;
  tavola=0;
}



void DETERMINANTE::resize(int n)
{
  distruggitavola();
  if(nel) delete  (char*) livello;
  livello=0;
  nel=n;
  if(nel) 
    {
	  livello=(LIVELLO*) new char [nel*sizeof(LIVELLO)];
	  for(int i=0;i<nel;i++) livello[i].creatorLIVELLO();
    }
}

void DETERMINANTE::get_max_nl(int &n,int &l)
{
  n=0;
  l=0;
  for(int i=0;i<nel;i++)
    {
      if(n<livello[i].n) n=livello[i].n;
      if(l<livello[i].l) l=livello[i].l;    
    }
}


double  BUFFERDET::scalareordinato(DETERMINANTE &a)
{
  double  result=0.0;
  double dot;
  for(int i=0 ; i< inuse; i++)
    {
    	dot=dotordinato(determinanti[i],a);
    	if(dot!=0) {
	      result += coefficienti[i]*dot;
	      break;
	    }
    }
  return result;
};


DETERMINANTE & BUFFERDET::operator () (int i)
{
  if(i>=n_det || i<0)
    {
      cout << " i = " << i << " in DETERMINANTE & operator () (int i) \n";
      cout << " n_det = " << n_det << endl;
      exit(0);
    }
  if(i>inuse || i<0)
    {
      cout << " i = " << i << " in DETERMINANTE & operator () (int i) \n";
      cout << " inuse= " << inuse << endl;
      exit(0);
    }
  return determinanti[i];
};

TIPOFATTORE & BUFFERDET::getcoef(int i)
{
  if(i>=n_det || i<0)
    {
      cout << " i = " << i  << " n_det = " << n_det<< " in TIPOFATTORE & BUFFERDET::getcoef(int i) \n";
      exit(0);
    }
  if(i>inuse || i<0)
    {
      cout << " i = " << i << " in TIPOFATTORE & BUFFERDET::getcoef(int i)\n";
      cout << " inuse= " << inuse << endl;
      exit(0);
    }
  return coefficienti[i];
};
 
BUFFERDET::BUFFERDET()
{
  n_det=0;
  nel=0;
  determinanti=0;
  coefficienti=0;
  inuse=0;
}

void BUFFERDET::aggiungi(DETERMINANTE &s, double fattore)
{
	if(fattore==0) return;
	double d;
	for(int i=0; i<inuse; i++) {
		d= dotordinato(determinanti[i],s );
		if(	d!=0) {
			coefficienti[i] +=fattore*d;
			return;
		}
	}
	atleast(inuse+1 ,s.getnel(),2);
	determinanti[inuse]= s ;
	coefficienti[inuse]  = fattore;
	inuse+=1;
}		


	
BUFFERDET::~BUFFERDET()
{
  libera();
}

void BUFFERDET::libera()
{
    for(int i=0; i< n_det; i++)
    {
      determinanti[i].~DETERMINANTE();
    }
   
  delete  (char*) determinanti;
  delete coefficienti;
  n_det=0;
  nel=0;
  determinanti=0;
  coefficienti=0;
  inuse=0;
}

void BUFFERDET::atleast(int nd, int ne, int resize)
{
  if(nd>n_det || ne > nel)
    {
      if(resize==BUFFERDETRESIZEERASE)
	{
	  libera();
	  n_det=nd;
	  nel=ne;
	    {
	      determinanti=(DETERMINANTE*)new char[n_det*sizeof(DETERMINANTE)];
	      for(int i=0;i<n_det;i++) determinanti[i].creatoreDETERMINANTE();
	    }
	  for(int i=0; i< n_det; i++)
	    {
	      determinanti[i].resize(nel);
	    }
	  coefficienti = new TIPOFATTORE [n_det];
	  inuse=0;
	}
      else if(resize==BUFFERDETRESIZECOPY  && ne==nel)
	{
	  nd+=PACKETBUFF;
	  DETERMINANTE* newdet=(DETERMINANTE*)new char[nd*sizeof(DETERMINANTE)];
	  for(int i=0;i<nd;i++) newdet[i].creatoreDETERMINANTE();


	  double * newcoeff = new TIPOFATTORE [nd];
	  memcpy(newcoeff, coefficienti, inuse*sizeof(TIPOFATTORE));

	  for(int i=0; i< nd; i++)
	    {
	      newdet[i].resize(nel);
	    }
	  for(int i=0;i<inuse;i++) newdet[i].copia( determinanti[i]  );

	  int saveinuse=inuse;
	  libera();
	  coefficienti=newcoeff;
	  determinanti=newdet;
	  n_det=nd;
	  nel=ne;
	  inuse=saveinuse;
	}
      else   // se non c'e' il permesso di fare un resize si blocca
	{
	  cout << " resize non permesso in atleast \n";
	  exit(0);
	}
    }
}



//       L+*L-
// si applica L+*L- ad a e i determinanti risultanti si
// aggiungono a buffer
void operatoreLLpm(DETERMINANTE &a, BUFFERDET &buffer,double fatdet, COUCHE *parziale,SOTTOSPAZIO * Sp )
{
  int Nel=a.getnel();
  DETERMINANTE s1,s2;
  double fattore1,fattore2;
  for (int i=0; i<Nel; i++)
    {
      // cio permette di restringer l'operatore a un guscio dato
      if(parziale  && (*parziale) != COUCHE(a.getlevel(i).n,a.getlevel(i).l)  )
	{
	  continue; 
	}
      // se il guscio e' completamente pieno gli operatori danno zero
      if(Sp && (Sp->qnl(a.getlevel(i).n, a.getlevel(i).l))==2*(2*a.getlevel(i).l +1))
	{
	  continue;
	}
	 
      s1.copia(a);
      s1.getlevel(i).mz -=1; // si applica L-
      if( s1.getlevel(i).Lis_physical()  && s1.not_doubly_occuped(i))
	{
	  fattore1 = (a.getlevel(i).l+a.getlevel(i).mz)   // a e lo stato di partenza per la transizione
	    *(a.getlevel(i).l-a.getlevel(i).mz+1);
	  for (int j=0; j<Nel; j++)
	    {

	      if( parziale  && (*parziale) !=  COUCHE(s1.getlevel(j).n,s1.getlevel(j).l)   )
		{
		  continue;
		}
	      if(Sp && (Sp->qnl(s1.getlevel(j).n, s1.getlevel(j).l))==2*(2*s1.getlevel(j).l +1))
		{
		  continue;
		}
	      s2.copia(s1);
	      s2.getlevel(j).mz +=1;         // Si applica L+
	      if( s2.getlevel(j).Lis_physical() && s2.not_doubly_occuped(j))
		{
		  fattore2 = ((s1.getlevel(j)).l - s1.getlevel(j).mz  )   // s1 e lo stato di partenza per la transizione
		    *(s1.getlevel(j).l + s1.getlevel(j).mz    + 1);

			s2.riordinalivelli();
			
			buffer.aggiungi(s2,sqrt(fattore1*fattore2)*fatdet);		
		}
	   }
	}
    }
}


//       S+*S-
// si applica S+*S- ad a e i determinanti risultanti si
// aggiungono a buffer

void operatoreSSpm(DETERMINANTE &a, BUFFERDET &buffer, double fatdet, COUCHE *  parziale, SOTTOSPAZIO * Sp)
{
  int Nel=a.getnel();
  DETERMINANTE s1,s2;
  double fattore1,fattore2;

  for (int i=0; i<Nel; i++)
    {
      if( parziale  && (*parziale) !=  COUCHE(a.getlevel(i).n,a.getlevel(i).l)   )
	{
	  continue;
	}
      if(Sp && (Sp->qnl(a.getlevel(i).n, a.getlevel(i).l))==2*(2*a.getlevel(i).l +1))
	{
	  continue;
	}
      s1.copia(a);
      s1.getlevel(i).sz -=2;
      if( s1.getlevel(i).Sis_physical()  && s1.not_doubly_occuped(i)  )
	{

	  fattore1  = (0.5 +a.getlevel(i).sz*0.5)
	    *(0.5-a.getlevel(i).sz*0.5+1);
	  
	  for (int j=0; j<Nel; j++)
	    {

	      if( parziale  && (*parziale) !=  COUCHE(s1.getlevel(j).n,s1.getlevel(j).l)   )
		{
		  continue;
		}
	      if(Sp && (Sp->qnl(s1.getlevel(j).n, s1.getlevel(j).l))==2*(2*s1.getlevel(j).l +1))
		{
		  continue;
		}
	      s2.copia(s1);
	      s2.getlevel(j).sz +=2;
	      if( s2.getlevel(j).Sis_physical()  && s2.not_doubly_occuped(j))
		{

		  fattore2=(0.5-s1.getlevel(j).sz*0.5 )
		    *(0.5+s1.getlevel(j).sz*0.5 + 1);
		
		
		  buffer.aggiungi(s2 ,sqrt(fattore1*fattore2)*fatdet );
	
		}
	    }
	}
    }
}

double preMz(DETERMINANTE &a)
{
  return a.preMz;
 // return Mz(a);
}
double preSz(DETERMINANTE &a)
{
  return a.preSz;
  // return  Sz(a);
}


double Mz(DETERMINANTE &a, COUCHE * parziale)
{
  double somma =0;
  for(int j=0; j<a.getnel(); j++)
    {
      if( parziale  && (*parziale) !=  COUCHE(a.getlevel(j).n,a.getlevel(j).l)        )
	{
	  continue;
	}
      somma += a.getlevel(j).mz;
    }
  return somma;
}

double Sz(DETERMINANTE &a, COUCHE * parziale)
{
  double somma =0;
  for(int j=0; j<a.getnel(); j++)
    {
      if( parziale  && (*parziale) !=  COUCHE(a.getlevel(j).n,a.getlevel(j).l)        )
	{
	  continue;
	}
      somma += a.getlevel(j).sz*0.5;
    }
  return somma;
}


//  S+*L-    +     L+*S-
void operatoreSLpm(DETERMINANTE &a, BUFFERDET &buffer, double fatdet , COUCHE *parziale,SOTTOSPAZIO * Sp )
{
  int Nel=a.getnel();
  DETERMINANTE s1,s2;
  double fattore1,fattore2;
  for (int i=0; i<Nel; i++)
    {

      if( parziale  && (*parziale) !=  COUCHE(a.getlevel(i).n,a.getlevel(i).l)        )
	{
	  continue;
	}

      if(Sp && (Sp->qnl(a.getlevel(i).n, a.getlevel(i).l))==2*(2*a.getlevel(i).l +1))
	{
	  continue;
	}      

      s1.copia(a);
      s1.getlevel(i).sz -=2;
      if( s1.getlevel(i).Sis_physical()  && s1.not_doubly_occuped(i)  )
	{
	  fattore1  = (0.5 +a.getlevel(i).sz*0.5)
	    *(0.5-a.getlevel(i).sz*0.5+1);
	  for (int j=0; j<Nel; j++)
	    {
	      if( parziale  && (*parziale) !=  COUCHE(s1.getlevel(j).n,s1.getlevel(j).l)        )
		{
		  continue;
		}
	      if(Sp && (Sp->qnl(s1.getlevel(j).n, s1.getlevel(j).l))==2*(2*s1.getlevel(j).l +1))
		{
		  continue;
		}      

	      s2.copia(s1);
	      s2.getlevel(j).mz +=1;
	      if( s2.getlevel(j).Lis_physical()  && s2.not_doubly_occuped(j))
		{
		  fattore2 = 
		    (s1.getlevel(j).l-s1.getlevel(j).mz )
		    *(s1.getlevel(j).l+s1.getlevel(j).mz + 1);

		
		  s2.riordinalivelli();
		  buffer.aggiungi(s2,  sqrt(fattore1*fattore2)*fatdet );
		}
	    }
	}
    }
  for (int i=0; i<Nel; i++)
    {

      if( parziale  && (*parziale) !=  COUCHE(a.getlevel(i).n,a.getlevel(i).l)        )
	{
	  continue;
	}

      if(Sp && (Sp->qnl(a.getlevel(i).n, a.getlevel(i).l))==2*(2*a.getlevel(i).l +1))
	{
	  continue;
	}      


      s1.copia(a);
      s1.getlevel(i).mz -=1;
      if( s1.getlevel(i).Lis_physical()  && s1.not_doubly_occuped(i)  )
	{
	  fattore1  = ( s1.getlevel(i).l +a.getlevel(i).mz)
	    *(s1.getlevel(i).l  -a.getlevel(i).mz+1);

	  for (int j=0; j<Nel; j++)
	    {

	      if( parziale  && (*parziale) !=  COUCHE(s1.getlevel(j).n,s1.getlevel(j).l)        )
		{
		  continue;
		}

	      if(Sp && (Sp->qnl(s1.getlevel(j).n, s1.getlevel(j).l))==2*(2*s1.getlevel(j).l +1))
		{
		  continue;
		}      

	      s2.copia(s1);
	      s2.getlevel(j).sz +=2;

	      if( s2.getlevel(j).Sis_physical()  && s2.not_doubly_occuped(j))
		{
		  fattore2  = (0.5-s1.getlevel(j).sz*0.5 )
		    *(0.5+s1.getlevel(j).sz*0.5 + 1);

		
      s2.riordinalivelli();
      buffer.aggiungi(s2, sqrt(fattore1*fattore2)*fatdet );

		}
	    }
	}
    }
}

int  spaiatiordinatimulti( DETERMINANTE &a,  DETERMINANTE &b, int *ia, int *ib,
			  int &cspa, int &cspb,
			  int maxnspa, int maxnspb)
{
  int ca=0,cb=0;
  // int cspa=0,cspb=0;
  while(ca< a.getnel()  &&  cb<b.getnel())
    {
      if(a.getlevel(ca)==b.getlevel(cb)) 
	{
	  ca++;
	  cb++;
	}
      else if( a.getlevel(ca) > b.getlevel(cb)   )
	{
	  ib[cspb]=cb;
	  cspb++;
	  if(cspb>maxnspb)  return 0;
	  cb++;
	}
      else if( b.livello[cb] > a.livello[ca]   )
	{
	  ia[cspa]=ca;
	  cspa++;
	  if(cspa>maxnspa)  return 0;
	  ca++;
	}
    }
  
  while(ca< a.getnel()  ||   cb<b.getnel())
    {
      if( cb  < b.getnel()   )
	{
	  ib[cspb]=cb;
	  cspb++;
	  if(cspb>maxnspb)  return 0;
	  cb++;
	}
      if( ca  < a.getnel()   )
	{
	  ia[cspa]=ca;
	  cspa++;
	  if(cspa>maxnspa)  return 0;
	  ca++;
	}
    } 
  if( (a.getnel()-cspa) != (b.getnel()-cspb))
    {
      cout << " non capisco \n";
      exit(0);
    }
  return 1;
}

int spaiatiordinati(DETERMINANTE &a , DETERMINANTE &b, int *ia, int *ib)
{
  if(a.nel!=b.nel)
    {
      cout << " spaiati  fra due determinanti aventi nel differente\n";
      exit(0);
    }
 
  int ca=0,cb=0;
  int cspa=0,cspb=0;
  while(ca < a.getnel()  &&  cb < b.getnel())
    {
      if(a.getlevel(ca)==b.getlevel(cb)) 
				{
	  			ca++;
	  			cb++;
				}
      else if( a.getlevel(ca) > b.getlevel(cb)   )
				{
	 	 			ib[cspb]=cb;
	  			cspb++;
	  			cb++;
				}
      else if( b.livello[cb] > a.livello[ca]   )
				{
	  			ia[cspa]=ca;
	  			cspa++;
	  			ca++;
			}
    }

  while(ca< a.getnel()  ||   cb<b.getnel())
    {
      if( cb  < b.getnel()   )
	{
	  ib[cspb]=cb;
	  cspb++;
	  cb++;
	}
      if( ca  < a.getnel()   )
	{
	  ia[cspa]=ca;
	  cspa++;
	  ca++;
	}
    } 
  if(cspa!=cspb)
    {
      cout << " non capisco \n";
      exit(0);
    }
  return cspa;
}


 
int possibileduecorpiordinati(DETERMINANTE &a , DETERMINANTE &b, 
			      COUCHE &ca1, COUCHE &ca2, COUCHE &cb1, COUCHE &cb2  )
{
  if(a.getnel()!=b.getnel())
    {
      cout << " spaiati  fra due determinanti aventi nel differente\n";
      exit(0);
    }
  COUCHE cdum(0,0);
  int ca=0,cb=0;
  int cspa=0,cspb=0;
  while(ca< a.getnel()  &&  cb<b.getnel())
    {
      if(a.getlevel(ca)==b.getlevel(cb)) 
	{
	  ca++;
	  cb++;
	}
      else if( a.getlevel(ca) > b.getlevel(cb)   )
	{
	  cspb++;
	  if(cspb>2) return 0;
	  cdum.n=b.livello[cb].n;
	  cdum.l=b.livello[cb].l;
	  if(cdum!=cb1 && cdum!=cb2) return 0;
	  cb++;
	}
      else if( b.livello[cb] > a.livello[ca]   )
	{
	  cspa++;
	  if(cspa>2) return 0;
	  cdum.n=a.livello[ca].n;
	  cdum.l=a.livello[ca].l;
	  if(cdum!=ca1 && cdum!=ca2) return 0;
	  ca++;
	}
    }

  while(ca< a.nel  ||   cb<b.nel)
    {
      if( cb  < b.nel   )
	{
	  cspb++;
	  if(cspb>2) return 0;
	  cdum.n=b.livello[cb].n;
	  cdum.l=b.livello[cb].l;
	  if(cdum!=cb1 && cdum!=cb2) return 0;
	  cb++;
	}
      if( ca  < a.nel   )
	{
	  cspa++;
	  if(cspa>2) return 0;
	  cdum.n=a.livello[ca].n;
	  cdum.l=a.livello[ca].l;
	  if(cdum!=ca1 && cdum!=ca2) return 0;
	  ca++;
	}
    } 
  if(cspa!=cspb)
    {
      cout << " non capisco \n";
      exit(0);
    }
  return (cspa<=2);
}






 
int possibileuncorpoordinati(DETERMINANTE &a , DETERMINANTE &b, 
			      COUCHE &ca1, COUCHE &cb1 )
{
  if(a.nel!=b.nel)
    {
      cout << " spaiati  fra due determinanti aventi nel differente\n";
      exit(0);
    }
  COUCHE cdum(0,0);
  int ca=0,cb=0;
  int cspa=0,cspb=0;
  int loa=1, lob=1;

  if( ca1.n<0) loa=0;
  if( cb1.n<0) lob=0;


  while(ca< a.nel  &&  cb<b.nel)
    {
      if(a.getlevel(ca)==b.getlevel(cb)) 
	{
	  ca++;
	  cb++;
	}
      else if( a.getlevel(ca) > b.getlevel(cb)   )
	{
	  cspb++;
	  if(cspb>1) return 0;
	  if(loa)
	    {
	      cdum.n=b.livello[cb].n;
	      cdum.l=b.livello[cb].l;
	      if(cdum!=cb1 ) return 0;
	    }
	  cb++;
	}
      else if( b.getlevel(cb) > a.getlevel(ca)   )
	{
	  cspa++;
	  if(cspa>1) return 0;
	  if(loa)
	    {
	      cdum.n=a.livello[ca].n;
	      cdum.l=a.livello[ca].l;
	      if(cdum!=ca1 ) return 0;
	    }
	  ca++;
	}
    }

  while(ca< a.nel  ||   cb<b.nel)
    {
      if( cb  < b.nel   )
	{
	  cspb++;
	  if(cspb>1) return 0;
	  if(lob)
	    {
	      cdum.n=b.livello[cb].n;
	      cdum.l=b.livello[cb].l;
	      if(cdum!=cb1 ) return 0;
	    }
	  cb++;
	}
      if( ca  < a.nel   )
	{
	  cspa++;
	  if(cspa>1) return 0;
	  if(loa)
	    {
	      cdum.n=a.livello[ca].n;
	      cdum.l=a.livello[ca].l;
	      if(cdum!=ca1) return 0;
	    }
	  ca++;
	}
    } 
  if(cspa!=cspb)
    {
      cout << " non capisco \n";
      exit(0);
    }
  return (cspa<=1);
}



double  dotordinato(DETERMINANTE &a , DETERMINANTE &b)
{
    
  if(a.nel!=b.nel)
    {
      cout << " scalare fra due determinanti aventi nel differente\n";
      exit(0);
    }
  if( memcmp(a.livello,b.livello, a.nel*sizeof(LIVELLO))==0)
    {
      return a.segno*b.segno;
 
    }
  else
    {
      return 0;
    }
  return 0;
}


void asfhfs::inizializzaautostato()
{
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  autostato.resize(newcolumns);
  autostato=0.0;
  autostato(0)=1.0;

}


void  calcolodegliR(double ****Kkx, double ** y, double *x,int is,int it,
		    int iu,int iv, int n_grille,int kmin, int kmax, double *R,
		    uMatrix<double> &RidS, uMatrix<double> &RidD )
{
  double puisx[n_grille];
  double func[n_grille];
  for(int ex=0; ex<n_grille; ex++) puisx[ex] =  1.0;
  
  for(int l=1;l<=kmin;l++)
    for(int ex=0; ex<n_grille; ex++) puisx[ex] *=  x[ex];
  
  for(int l=kmin; l<=kmax;l++)
    {
      for(int ex=0; ex<n_grille; ex++)
	{
	  func[ex]=y[is][ex]*y[it][ex]*
	    (Kkx[iu][iv][l][ex]
           /puisx[ex]/x[ex]+ 
	     (Kkx[iu][iv][-l-1][n_grille-1]-
	      Kkx[iu][iv][-l-1][ex])*puisx[ex] ) ;
	}
      R[l]=integrate(func,x,n_grille);
      if(l!=0)
	{
	  if(RidS.rows() &&  RidD.rows())
	    {
	      int i1=is,i2=it,j1=iu,j2=iv,d;
	      if(i1>i2)
		{
		  d=i2;
		  i2=i1;
		  i1=d;
		}
	      if(j1>j2)
		{
		  d=j2;
		  j2=j1;
		  j1=d;
		}	
	      if( (i1!=i2 && i1!=j1) || (j1!=j2 && j2!= i2) )
		{
		  cout << " La riduzione degli integrali di Slater non"
		    " e' ancora ben messa a punto per il caso   "
		    " multiconfigurazionale \n";
		  exit(0);
		}
	      int A,B;
	      A=i1;
	      if(i2!=i1)
		{
		  B=i2;
		}
	      else
		{
		  B=j1;
		}
	      double  rid=0;
	      if  ( !(rid=RidS(A)) ) rid=RidS(B);
	      if(rid) R[l]*=rid;
	      if  ( !(rid=RidD(A,B)))   rid=RidD(B,A)    ;
	      if(rid) R[l]*=rid;
	    }
	}
      for(int ex=0; ex<n_grille; ex++) puisx[ex] *=  x[ex];
    }
}

void asfhfs::calcolaoccmixed(uMatrix<double> &occmixed)
{
  cout << " sono in  calcolaoccmixed , autostato ="<< autostato << endl;
  occmixed=0.0;
  int col=0;
  for(int i=0; i<nsottospazi;i++)
    {
      double ps=0;
      for(int j=0; j<sottospazi[i].dim();j++)
	{
	  ps+=autostato(col)*autostato(col);
	  col++;
	}
      DETERMINANTE *dt;
      int n,l;
      dt=sottospazi[i].base_canonica+sottospazi[i].inizio;
      for(int j=0; j< dt->getnel(); j++)
	{
	  n=dt->getlevel(j).n;
	  l=dt->getlevel(j).l;
	  occmixed(num_orbitale(n,l))+=ps;
	}
    }
};


void calcolaelementiKin( double **y, double **ykin, double *x, int n_grille, 
			 int n_stati, double Z, uMatrix<double> &J, 
			 uMatrix<int> /* noforb */ ,uMatrix<int> loforb )
{
  J=0.0;
  double func[n_grille];
  for (int is=0; is<n_stati;is++)
    {
      for (int js=is; js<n_stati;js++)
	{
	  if(loforb(is)==loforb(js))  // evitiamo gli elementi inutili
	    {
	      for(int i=0; i< n_grille;i++)
		{
		  func[i]=y[js][i]*(ykin[is][i]-y[is][i]*Z/x[i]);
		  // ykin e calcolata della seguente maniera in hfs.cc
		  //
		  // ykin[is][i]=(E[is]-v[i])*y[is][i]-v_non_local[is][i];
		  // In hfs c`e la possibilta di testare ykin
		}
	      J(is,js)=integrate(func,x,n_grille); 
	    }
	  else
	    {
	      J(is,js)=0.0;
	    }
	  J(js,is)=J(is,js);
	}
    }
}

int asfhfs::onediff(int  sa,int  sb ,int & na,int & la,int&  nb,int&  lb)
{
  cout << "cerco in onediff il onediff sui " << nel << " stati \n";
  
  int aTdiff,Tdiff,diff;
  Tdiff=0;
  aTdiff=0;

  for(int i=0; i< nel; i++)
    {
      diff =(int)(occsottospazio(sa,i) - occsottospazio(sb,i));
      Tdiff  += diff;
      aTdiff +=Abs(diff);
      
      if( diff == 1)
	{
	  na= noforb(i);
	  la= loforb(i);
	}
      else  if( diff == -1)
	{
	  nb= noforb(i);
	  lb= loforb(i);
	}
    }
  if( Tdiff==0 && aTdiff==2 )
    {
      return 1;
    }
  else
    {
      return 0;
    }
  
  return 0;
  
}


int asfhfs::duediff(int  sa,int  sb ,int & nas,int & las,  int & nat,int & lat,
		    int&  nbu,int&  lbu,   int&  nbv,int&  lbv    )
{
  cout << "cerco in duediff il onediff sui " << nel << " stati \n";
  
  int aTdiff,Tdiff,diff;
  Tdiff=0;
  aTdiff=0;
  
  nas=0;
  nbu=0;

  for(int i=0; i< nel; i++)
    {
      
      diff =(int)(occsottospazio(sa,i) - occsottospazio(sb,i));
      Tdiff  += diff;
      aTdiff +=Abs(diff);
      

      if( diff == 1)
	{
	  if(nas==0)
	    {
	      nas= noforb(i);
	      las= loforb(i);
	    }
	  else
	    {
	      nat= noforb(i);
	      lat= loforb(i);
	    }
	}
      else  if( diff == -1)
	{
	  if(nbu==0)
	    {
	      nbu= noforb(i);
	      lbu= loforb(i);
	    }
	  else
	    {
	      nbv= noforb(i);
	      lbv= loforb(i);
	    }
	}
    }
  
  if( Tdiff==0 && aTdiff==4 )
    {
      return 1;
    }
  else
    {
      return 0;
    }
  return 0;
}



void calcolaelementiSO( double **y, double *x, int n_grille, int n_stati, double /* Z */,double *E,	uMatrix<double> &SO)
{
  SO=0.0;
  double func[n_grille];
  for (int is=0; is<n_stati;is++)
    {
      for (int js=is; js<n_stati;js++)
	{
	  for(int i=0; i< n_grille;i++)
	    {
	      func[i]=y[js][i]*y[is][i]*fabs(E[i])/x[i] /2.  /  137.2 /  137.2;
	    }
	  SO(is,js)=integrate(func,x,n_grille); 
	  SO(js,is)=SO(is,js);
	}
    }
}

void calcolaelementiSONew( double **y, double *x, int n_grille, int n_stati, double /* Z */,double *E,	uMatrix<double> &SO)
{
  SO=0.0;
  double func[n_grille];
  double *Ei, *Ej;
  for (int is=0; is<n_stati;is++)
    {
      Ei= E + is*n_grille;
      for (int js=is; js<n_stati;js++)
	{
	  Ej= E + js*n_grille;
	  for(int i=0; i< n_grille;i++)
	    {
	      // cout << Ei[i]  << endl;
	      func[i]=y[js][i]*y[is][i]*fabs(Ei[i])/x[i] /2.  /  137.2 /  137.2;
	    }
	  SO(is,js)=integrate(func,x,n_grille); 
	  SO(js,is)=SO(is,js);
	}
    }
}

// ricordarsi che autostato deve essere configurato
// prima della chiamata a preparamatricione
//
void asfhfs::preparamatricione()
{
  // **************************************
  // ** Si trova la dimensione del problema
  // **
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  // *********************************
  // ** si da la giusta dimensione al matricione
  matricione.azzera();

  // ************************************
  // ** si calcolano le occupazioni medie

  uMatrix<double>  occmixed(loforb.rows());
  calcolaoccmixed(occmixed);

  // *****************************************
  // ** Gli ingredienti di base sono
  // ** L`operatore cinetico
  // ** gli integrali di slater
  // ** Lo spin-orbita

  // ** operatore cinetico + Z
  uMatrix<double> J( hfs.n_stati,  hfs.n_stati );
  hfs.calcolakin();
  calcolaelementiKin(hfs.y, hfs.ykin, hfs.x, hfs.n_grille, hfs.n_stati, hfs.Z, 
		 J,noforb,loforb);
  cout << " dopo Kin J est " << J ;

  // ** Slater: questa operazione permette di aggiornare le funzioni Kkx
  hfs.calcola_slater();

  cout << " Slater calcolati \n";

  // ** Spin orbita
  uMatrix<double> SO( hfs.n_stati,  hfs.n_stati );
  {

    double Esfer[hfs.n_stati * hfs.n_grille];
    hfs.calcolaEsfericomixedNew(occmixed.address(), Esfer);
    cout << " OK  edNew \n";
    calcolaelementiSONew(hfs.y, hfs.x, hfs. n_grille, hfs.n_stati, hfs.Z,  Esfer,
			 SO); 
    cout << " OK  SONew \n";
  }
  

  cout << " SO  calcolati \n";

  // **
  // ***************************************************
  
  
  // ***************************************************
  // ** Aggiunta dei termini cinetici diagonali
  // ** e dello spin orbita intra-sottospazio
  {
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	double qis;
	for(int is=0; is< hfs.n_stati; is++)
	  {
	    qis=sottospazi[i].qnl(noforb(is),loforb(is));
	    cout <<" termini cinetici " <<  qis << endl;
	      if(qis>0 )
		{
		  for(int sot=Acolumns;sot< Acolumns+sottospazi[i].dim();sot++)
		    {
		    cout << " aggiungo "<< J(is,is)*qis << " " << sot << endl;
		      //  matricione.sommaH(sot,sot,J(is,is)*qis);
					matparziali[mappaH0].sommaH(sot,sot,J(is,is)*qis);
		    }
		
		  if(SO(is,is) != 0.0  && qis != 2*(2*loforb(is)+1) )
		    {
		      aggiungiSOamatricione(matparziali[mappaH0],sottospazi[i],sottospazi[i],
					    SO(is,is), noforb(is),loforb(is), noforb(is),loforb(is),
					    Acolumns,  Acolumns  );
		    }
		  if(uz.rows() && uz(is)!=0.0)
		    {
		      cout << " aggiungo lo Spin "  << endl;
		      aggiungiSpinZamatricione(matparziali[mappaHsz(is)],sottospazi[i], uz(is),
					       noforb(is), loforb(is), Acolumns);
		      cout << " aggiungo lo Spin OK"  << endl;
		    }
		
		}
	  }
	
	// matricione.salvasufile("dopocinetici");
	cout << " ciao 0  " << endl;

  // matricione.stampa();
  	
	
	if(cristallo.rows())
	  {
	    if(statoC>=0 && statoC<nstati)
	      {
		cout << " aggiungo il cristallo statoC=" << statoC << endl;
		cout << cristallo << endl;
		aggiungiCristalloamatricione( matparziali[mappaCrist],sottospazi[i],sottospazi[i],
					     cristallo,noforb(statoC),loforb(statoC),
					     noforb(statoC),loforb(statoC),
					     Acolumns,Acolumns);
		cout << " aggiungo il cristallo OK!!  statoC=" << statoC << endl;
	      }
	  }
	Acolumns+=sottospazi[i].dim();
      }
  }
  // **
  // *****************************************************

  // cout << " ciao " << endl;

  // matricione.stampa();
  
  // ********************************************************************************************
  // ** Consideriamo tutte le coppie di livelli is,it
  // ** Per ogni coppia consideriamo l`interazione diretta is,it <-> is,it
  // ** e quella di scambio   is,it <-> it,is
        
  for(int is=0; is<hfs.n_stati; is++)
    {
      for(int it=is; it<hfs.n_stati; it++)
	{
	  int kmin,kmax;
	  
	  // **************************************
	  // ** calcolo dei F
	  // **
	  kmin=0;
	  kmax=2*Min(loforb(is),loforb(it));
	  double F[kmax+1];
	  calcolodegliR( hfs.Kkx , hfs.y,hfs.x,  is , is, it, it , hfs.n_grille, kmin,
	  							 kmax, F,RidS,RidD );
	  // **
	  // **************************************
	  
	  // **********************************************
	  // ** calcolo dei G
	  // **
	  kmin=Abs(loforb(is)-loforb(it));
	  kmax=loforb(is)+loforb(it);	  
	  double G[kmax+1];
	  calcolodegliR( hfs.Kkx , hfs.y,hfs.x, is , it, is, it , hfs.n_grille, kmin, kmax, G ,RidS,RidD);
	  // **
	  // ***********************************************
	  
	  // ****************************************************
	  // ** Loop su tutti i sottospazi
	  // **
	
	  int Acolumns=0;
	  int qis,qit;
	  Risolutore *matpar=0;

	
	if(RidD.rows() && ( RidD(is,it)>=0 || RidD(it,is)>=0   )     ) {
					matpar= matparziali + mappaHridd(is,it) ;
					cout << " *******ciaociao \n";
	} else 	if(RidS.rows() && RidS(is)>=0) {
					matpar= matparziali + mappaHrids(is) ;
				cout << " *******ciaociao 1\n";
	} else if(RidS.rows() && RidS(it)>=0) {
					matpar= matparziali + mappaHrids(it) ;
				cout << " *******ciaociao 2\n";
	}
	cout << " matpar " << matpar << endl;
	  for(int i=0; i<nsottospazi;i++)
	    {
	      qis=sottospazi[i].qnl(noforb(is),loforb(is));
	      qit=sottospazi[i].qnl(noforb(it),loforb(it));
	      cout << " is= " << is << " it= " << it << endl;
	      cout << "cuicu qis qit" << qis<< "  "  << qit <<endl;


	      if(qis>0 && qit>0 )
		{
		  
		  // ** parte diretta  is->is ; it-> it
		  // ** 
		  quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],matpar, sottospazi[i],sottospazi[i],F,
						    noforb(is),loforb(is), noforb(is),loforb(is),
						    noforb(it),loforb(it), noforb(it),loforb(it),
						    Acolumns,Acolumns);

		  // ** parte scambiata  is->it ; it-> is
		  if(is!=it)
		    {
		      quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],matpar,sottospazi[i],sottospazi[i],G,
							noforb(is),loforb(is), noforb(it),loforb(it),
							noforb(it),loforb(it), noforb(is),loforb(is),
							Acolumns,Acolumns);
		      
		    }
		  Acolumns+=sottospazi[i].dim();
		}
	    }
	  // **
	  // *******************************************************
	}
    }
  // **
  // *************************************************************************************************
  

  
  cout << " OK 1\n";
   cout << " ciao " << endl;

  matricione.stampa();

  // Facendo un loop di  is su tutti gli stati
  // Vogliamo considerare le transizioni  riguardanti una couche n,l  is di partenza 
  // dove l'occupazione di is rimane costante, e riguardanti un'altra couche 
  // che pero cambia di occupazione e ci fa cambiare di configurazione
  // La transizione deve quindi avvenire fra due sottospazi diversi (A e B)
  // i quali abbiano due couche con occupazioni spaiate di +1 e -1
  // Inneschiamo quindi un loop su is,  sul   sottospazio di partenza
  // e di seguito su quello di arrivo,
  // per ogni coppia cosi ottenuta si controllano le occupazioni
  // e se c'e il +1 e -1 si da il tutto ad aggiungi.....
  // una volta per la diretta is -> is; mario->pippo  e una volta
  // per lo scambio is -> pippo; mario-> is
  
  
  for(int is=0; is<hfs.n_stati; is++) 
    // questo loop sul livello  spettatore
    // e` stato messo esterno, ma potrebbe altrettanto bene esser in interno
    // (e forse sarebbe meglio)
    {  
      int Acolumns=0;
      int Bcolumns=0;
      int qis;
      for(int i=0; i<nsottospazi;i++)
	{
	  qis=sottospazi[i].qnl(noforb(is),loforb(is));
	    if(qis>0)
	      {     
		// Se il sottospazio A ha elettroni nel livello is
		// si innesca allora il loop sul sottospazio B != A
		Bcolumns=Acolumns +sottospazi[i].dim() ;
		for(int j=i+1 ; j<nsottospazi; j++) 
		  {
		    int na,la,nb,lb;
		    if( onediff( i, j ,na,la,nb,lb)  )
		      {
			// B e raggiungibila da A con una transizione (na,la) -> (nb,lb)
			//                            ovvero ia ->ib
			//      oppure con lo scambio ia->is ; is->ib
		  
			int kmin,kmax;
			int ia,ib;
			ia=num_orbitale(na,la);
			ib=num_orbitale(nb,lb);
			int ls=loforb(is);
			
			// **************************************
			// ** calcolo dei F
			// **
			kmin=abs(la-lb);
			kmax=Min(2*ls,la+lb);
			double F[kmax+1];
			calcolodegliR( hfs.Kkx , hfs.y,hfs.x, ia , ib, is, is ,
				       hfs.n_grille, kmin, kmax, F,RidS,RidD );
			// **
			// ****************************************
			
			// **********************************************
			// ** calcolo dei G
			// **
			kmin=Max(abs(la-ls), abs(lb-ls) );
			kmax=Min(ls+la,ls+lb);
			double G[kmax+1];
			
			calcolodegliR( hfs.Kkx , hfs.y,hfs.x, ia , is, is, ib ,
				       hfs.n_grille, kmin, kmax, G,RidS,RidD );
			
			// **
			// **************************************************
			
			// ***************************************************************
			// ** Aggiunta di diretto e scambio a matricione
			quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],NULL,
							  sottospazi[i],sottospazi[j],F,
							  noforb(is),loforb(is),
							  noforb(is),loforb(is),
							  na,la,nb,lb,
							  Acolumns,Bcolumns);
			
			quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],NULL,
							  sottospazi[i],sottospazi[j],G,
							  na,la,noforb(is),loforb(is),
							  noforb(is),loforb(is),nb,lb,
							  Acolumns,Bcolumns);
			// **
			// *****************************************************************
		      }
		    Bcolumns+=sottospazi[j].dim();
		  }
	      }
	  Acolumns+=sottospazi[i].dim();
	}
    }




  // **************************************************************
  // ** si aggiungono i termini monoparticellari fuori diagonale
  // **
  {
    int Acolumns=0;
    int Bcolumns=0;

    for(int i=0; i<nsottospazi;i++)
      {
	Bcolumns = Acolumns+sottospazi[i].dim() ;
	for(int j=i+1 ; j<nsottospazi;  j++)
	  {
	    int na,la,nb,lb,ia=0,ib=0;
	    if(onediff( i, j ,na,la,nb,lb))
	      {  // si aggiungono i termini monoparticellari fuori diagonale
		if(la==lb)
		  {
		    ia=num_orbitale(na,la);
		    ib=num_orbitale(nb,lb);
		    aggiungiKineamatricione(matparziali[mappaH0],sottospazi[i],
					    sottospazi[j],
					    J(ia,ib), ia,ib,
					    Acolumns ,  Bcolumns  ,noforb,loforb);
		  }
		if(SO(ia,ib)!=0.0)
		  {
		    aggiungiSOamatricione(matparziali[mappaH0],sottospazi[i],sottospazi[j],
					  SO(ia,ib), noforb(ia), loforb(ia),noforb(ib),loforb(ib),
					  Acolumns ,  Bcolumns );
		  }
	      }
	    Bcolumns+=sottospazi[j].dim();
	  }
	Acolumns+=sottospazi[i].dim();
      }
  }
  
  
  // Inneschiamo quindi un loop   sul   sottospazio di partenza
  // e di seguito su quello di arrivo,
  // per ogni coppia cosi ottenuta si controllano le occupazioni
  // e se c'e il +2 e -2 si da il tutto ad aggiungi.....
  // una volta per la diretta ias -> ibt; iau -> ibv  e una volta
  // per lo scambio  ias -> ibv; iau -> ibt 


  {  
    int Acolumns=0;
    int Bcolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	// si innesca allora il loop sul sottospazio B != A
	Bcolumns =Acolumns +sottospazi[i].dim() ;
	for(int j=i+1 ; j<nsottospazi; j++) 
	  {  
	    int nas,las, nbt,lbt, nau,lau, nbv,lbv;
	    if( duediff( i, j, nas,las,nau,lau,// salto dal det a al det b
			 nbt,lbt,nbv,lbv )  )
	      {
		int kmin,kmax;
		int ias,ibt;
		int iau,ibv;
		ias=num_orbitale(nas,las);
		ibt=num_orbitale(nbt,lbt);
		iau=num_orbitale(nau,lau);
		ibv=num_orbitale(nbv,lbv);
		
		// **************************************
		// ** calcolo dei F
		// **
		kmin=Max(abs(las-lbt),abs(lau-lbv));
		kmax=Min(las+lbt,lau+lbv);
		double F[kmax+1];
		calcolodegliR( hfs.Kkx , hfs.y,hfs.x,
			       ias , ibt, iau, ibv ,
			       hfs.n_grille, kmin, kmax, F,RidS,RidD );
		
		// **********************************************
		// ** calcolo dei G
		// **
		kmin=Max(abs(las-lbv),abs(lau-lbt));
		kmax=Min(las+lbv,lau+lbt);
		double G[kmax+1];
		calcolodegliR( hfs.Kkx , hfs.y,hfs.x,
			       ias , ibv, iau, ibt ,
			       hfs.n_grille, kmin, kmax, G,RidS,RidD );

		quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],NULL,
						  sottospazi[i],sottospazi[j],F,
						  nas,las,
						  nbt,lbt,
						  nau,lau,nbv,lbv,
						  Acolumns,Bcolumns);
		quatrelevelsaggiungiFGamatricione(matparziali[mappaH0],NULL,
						  sottospazi[i],sottospazi[j],G,
						  nas,las,
						  nbv,lbv,
						  nau,lau,nbt,lbt,
						  Acolumns,Bcolumns);
	      }
	    Bcolumns += sottospazi[j].dim();
	  }    
	Acolumns+=sottospazi[i].dim();
      }
  }

  cout << " OK 1\n";
   cout << " ciao FINE" << endl;

  matricione.azzera();
	for(int i=0; i< parzialiattivi; i++) {
		matricione.somma(matparziali[i]);
	}


}
void asfhfs::azzeramatricione()
{

  matricione.azzera();
};

  
void asfhfs::inizializza_hfs(char * nomefiledettaglihfs)
{
  int maxn=0;
  int maxl=0;
  int n,l;
  for(int i=0; i<n_det;i++)
    {
      collezione[i].get_max_nl(n,l);
      if(maxn<n) maxn=n;
      if(maxl<l) maxl=l;
    }
  cout << "maxl maxn " << maxl << " " << maxn << endl;
  num_orbitale.resize(maxn+1,maxl+1);
  num_orbitale=-1;

  //
  // si mette a punto la matrice num_orbitale
  int norb=0;
  for(int i=0; i<n_det;i++)
    {
      for(int j=0; j<nel;j++)
	{
	  n=collezione[i].getlevel(j).n;
	  l=collezione[i].getlevel(j).l;
	  if(num_orbitale(n,l)==-1)
	    {
	      num_orbitale(n,l)=norb;
	      norb++;
	    }
	}  
    }
  cout << " ci sono " << norb << " orbitali\n";
  cout << " ci sono " <<nsottospazi << " sottospazi\n";
  // 
  // si calcolano le occupazioni per i sottospazi
   
  occsottospazio.resize(nsottospazi,norb);
  occsottospazio=0.0;

  DETERMINANTE *det;
  for(int i=0; i<nsottospazi;i++)
    {
      det= &(sottospazi[i].base_canonica[sottospazi[i].inizio]);
      for(int j=0; j<nel;j++)
	{
	  n=det->getlevel(j).n;
	  l=det->getlevel(j).l;
	  occsottospazio(i,num_orbitale(n,l))=occsottospazio(i,num_orbitale(n,l))+1;
	}  
    }

  //
  // si mettono a punto i numeri quantici da rifilare a hfs
  noforb.resize(norb);
  loforb.resize(norb);
  for(int i=0; i<=maxn;i++)
    {
      for(int j=0;j<=maxl;j++)
	{
	  if(num_orbitale(i,j)>=0)
	    {
	      noforb(num_orbitale(i,j))=i;
	      loforb(num_orbitale(i,j))=j;
	    }
	}
    }
  

  
  FILE *dati= fopen(nomefiledettaglihfs, "r");
  if(dati==0)
    {
      cout << " problemi apertura file" << nomefiledettaglihfs << "   \n";
      exit(0);
    }
  {
    FILE *tmp = fopen("temp.dat", "w");
    char c;
    int toggle = 1;
    while(!feof(dati))
      {
	c = getc(dati);
	if( (c=='{' && toggle) || ( c=='}' && toggle==0)  )
	  {
	    toggle = 1-toggle ;
	  }
	else if(toggle==1)
	  {
	    putc(c,tmp);
	  }
      }
    fclose(tmp);
    fclose(dati);
  }
  dati= fopen("temp.dat", "r");
  
  
  int  n_grille;
  double Z,ro,rinf;
  fscanf(dati,"%lg  %d",&Z,&n_grille);
  fscanf(dati,"%lg %lg",&ro,&rinf);
  fclose(dati);
  //*****************************************************
  //** On fixe les parametres. La memoire necessaire est allouee
  hfs.set_parametres(Z,  n_grille, norb);

  //*****************************************************
  //**  On dit a atomo quels etas on veut consider
  //**  int L[n_stati],N[n_stati];
  cout << " noforb\n"<< noforb<<endl;
  cout << " loforb\n"<< loforb<<endl;
  hfs.set_stati(  noforb.address(),  loforb.address());
  //*************************************************************
  //**  Pour chaque etats on lui dit la quel c est l occupation
  //** si utilizza all'uopo l occupazione del sottospazio 0
  cout << " occupazioni " << endl << occsottospazio ;
  hfs.set_occ(occsottospazio.address() );
 //****************************************************************
  //**   cette instruction initialise la grille (grille logarithmique 
  //**       allant de ro -> rinf )
  cout << ro << " " << rinf << endl;
  hfs.set_grille(ro,rinf);
  //**  Cette fonction initialise le potentiel atomique
  // hfs.set_pot_tf(1.0);
  hfs.set_pot_coul();
  cout << " find \n";
  hfs.find_wave_functions();
  cout << " consistenza \n";
  hfs.consistenza( METODOSOSTITUZIONE ,1.0e-12,0.1); 
  cout << " ciao "<< hfs.energiaLDA(0)<< "\n";
  hfs.find_wave_functions();
  cout << " ciao 2\n";
  

  cout << " slater\n";
  hfs.calcola_slater();
  cout << " slater OK \n";
  cout <<"!!!!!!!!!!!!!!!! energia  SLATER  = ";
  {
    double e=hfs.energiaSlater();
    cout << e << endl;
  }

  for (int j=0; j< hfs.get_n_stati(); j++)
    cout << hfs.get_energia(j) << " " ;
  cout << endl;
};

void asfhfs::inizializza_Cristallo(char *nome)
{
  
  RidS.resize(nstati);
  RidD.resize(nstati,nstati);
  uz.resize(nstati);

  mappaHrids.resize(nstati);
  mappaHridd.resize(nstati,nstati);
  mappaHsz.resize(nstati);

  RidS=-1;
  RidD=-1;
  uz=0.0;
  
  FILE *dati= fopen(nome, "r");
  if(dati==0)
    {
      cout << " problemi apertura file in inizializza_Cristallo" << nome << "   \n";
      exit(0);
    }
  {
    FILE *tmp = fopen("temp.dat", "w");
    char c;
    int toggle = 1;
    while(!feof(dati))
      {
	c = getc(dati);
	if( (c=='{' && toggle) || ( c=='}' && toggle==0)  )
	  {
	    toggle = 1-toggle ;
	  }
	else if(toggle==1)
	  {
	    putc(c,tmp);
	  }
      }
    fclose(tmp);
    fclose(dati);
  }
  dati= fopen("temp.dat", "r");

  int nrids;
  fscanf(dati,"%d",&nrids);
  int dum;
  for(int i=0; i<nrids; i++)
    {
      fscanf(dati,"%d",&dum);
      if(dum<0 || dum>=nstati)
			{
	  		cout << " Problema dum<0 ||dum>=nstati\n";
	  		exit(0);
			}
			if(parzialiattivi>=MAXPARZIALI) {
				cout << " parzialiattivi>=MAXPARZIALI   " << endl;
				exit(0);
			}
			char *nuovastringa=new char[80];
			sprintf(nuovastringa,"slaterridottiSguscio%d",dum);
			mappaparziali[parzialiattivi]=nuovastringa;
			mappaHrids(dum)=parzialiattivi;
			parzialiattivi++;
			
      fscanf(dati,"%le",&RidS(dum));
    }
 
  int nridD;
  fscanf(dati,"%d",&nridD);
  int dim;
  for(int i=0; i<nridD; i++)
    {
      fscanf(dati,"%d",&dum);
      fscanf(dati,"%d",&dim);
      if(dum<0 || dum>=nstati || dim<0 || dim>=nstati)
	{
	  cout << " Problema dum<0 || dum>=nstati || dim<0 || dim>=nstati\n";
	  exit(0);
	}
	
			char *nuovastringa=new char[80];
			sprintf(nuovastringa,"slaterridottiDguscio%d_%d",dum,dim);
			mappaparziali[parzialiattivi]=nuovastringa;
			mappaHridd(dum,dim)=parzialiattivi;
			mappaHridd(dim,dum)=parzialiattivi;
			parzialiattivi++;

	
      fscanf(dati,"%le",&RidD(dum,dim));
    }
  
  int nuz;
  fscanf(dati,"%d",&nuz);
  for(int i=0; i<nuz; i++)
    {
      fscanf(dati,"%d",&dum);
      if(dum<0 || dum>=nstati)
	{
	  cout << " Problema dum<0 ||dum>=nstati\n";
	  exit(0);
	}

			char *nuovastringa=new char[80];
			sprintf(nuovastringa,"Scambioguscio%d",dum);
			mappaparziali[parzialiattivi]=nuovastringa;
			mappaHsz(dum)=parzialiattivi;
			parzialiattivi++;
      fscanf(dati,"%le",&uz(dum));
    }

  fscanf(dati,"%d",&statoC);
  if(statoC>=0 && statoC<nstati)
    {
      int l=loforb(statoC);
      int dim=2*l+1;
      cristallo.resize(dim,dim);
      for(int i=0; i<dim;i++)
	for(int j=0; j<dim; j++)
	  {
	    fscanf(dati,"%le",&cristallo(i,j));
	  }
    }

  fclose(dati);
}



int SOTTOSPAZIO::qnl(int n, int l)
{
  DETERMINANTE *det;
  // si prende il primo determinante della base perche tanto
  // in un dato sottospazion qnl e costante
  det=base_canonica + inizio;
  int q=0;
  int nel=det->getnel();
  for(int i=0; i< nel; i++)
    {
      if( det->getlevel(i).n==n && det->getlevel(i).l==l)
	{
	  q++;
	}
    }
  return q;
};


void  SOTTOSPAZIO::operator=(SOTTOSPAZIO & a )
{
  // dim_can=a.dim_can;
  base_canonica=a.base_canonica;
	inizio=a.inizio;
	fine=a.fine;

  operatore=a.operatore;

  n_sottospazi=a.n_sottospazi;

  if(n_sottospazi)
    {
      sottospazi =  new  SOTTOSPAZIO[n_sottospazi];
    }
  else
    {
      sottospazi=0;
    }

  for(int i=0; i< n_sottospazi;i++)
    {
      sottospazi[i]=a.sottospazi[i];
    }
};


SOTTOSPAZIO & SOTTOSPAZIO::getsottospazio(int n)
{
  if(n<0 || n>=n_sottospazi) 
    {
      cout << " n<0 || n>=n_sottospazi dans SOTTOSPAZIO & getsottospazio\n";
      exit(0);
    }
  return sottospazi[n];
};


void SOTTOSPAZIO::stampa()
{
  cout << "\n******** SOTTOSPAZIO ********\n";
  DETERMINANTE *pd;
  for(int i=inizio; i<fine ; i++)
    {
      pd= &(base_canonica[i]);
      cout << " determinante base canonica " << i << endl;
      pd -> stampa();
    }
  cout << " matrice operatore \n";
  operatore.scrivi();

  cout << " questo sottospazio ha " << n_sottospazi<< " sottospazi\n";
  for(int i=0; i< n_sottospazi; i++) sottospazi[i].stampa();
}



void SOTTOSPAZIO::settaLL()
{
  int nel=base_canonica[0].getnel();

  operatore.pulisci();

  DETERMINANTE *pd,*pdn;
  BUFFERDET  buffer;

  buffer.atleast(PACKETBUFF,nel  ,1);

  double mz;

  for(int i=inizio; i< fine; i++)
    {
      buffer.inuse=0;
      pd= &(base_canonica[i]);
      // pd -> stampa();
      operatoreLLpm(*pd ,  buffer, 1, NULL, this);
      mz= Mz(*pd);
      for(int j=i; j<fine; j++)
	{
	  pdn = &(base_canonica[j]);
	  double sc=buffer.scalareordinato(*pdn);
	  if(sc) {
	  	  operatore.aggiungiElemento(sc,j,i);
	  	  if(i!=j)operatore.aggiungiElemento(sc,i,j);
	  }
	  if(j==i) operatore.aggiungiElemento(mz*(mz-1),j,i);
	}
  }
};

void SOTTOSPAZIO::settaSS()
{
  int nel=base_canonica[0].getnel();

  operatore.pulisci();

  DETERMINANTE *pd,*pdn;
  BUFFERDET  buffer;

  double sz;

  buffer.atleast(PACKETBUFF,nel  ,1);

  for(int i=inizio; i< fine; i++)
    {
      buffer.inuse=0;
      pd= &(base_canonica[i]);
      operatoreSSpm(*pd ,  buffer, 1,NULL, this);
      sz= Sz(*pd);
      for(int j=i; j<fine; j++)
	  {
	    pdn = &(base_canonica[j]);
	    double sc=buffer.scalareordinato(*pdn);
	    if(sc) {
	  	  operatore.aggiungiElemento(sc, j,i);
	  	  if(i!=j) operatore.aggiungiElemento(sc, i,j);
	    }
	  if(j==i) operatore.aggiungiElemento(sz*(sz-1),j,i) ;
	}
    }
};



void SOTTOSPAZIO::settaJJ()
{

  int nel=base_canonica[0].getnel();

  operatore.pulisci();

  DETERMINANTE *pd,*pdn;
  BUFFERDET  buffer;

  double jz;

  buffer.atleast(PACKETBUFF,nel  ,1);

  for(int i=inizio; i< fine; i++)
    {
      buffer.inuse=0;
      pd= &(base_canonica[i]);
      cout << " operatoreSLpm\n";
      operatoreSLpm(*pd ,  buffer, 1, NULL, this); 
      cout << " operatoreLLpm\n";
      operatoreLLpm(*pd ,  buffer, 1, NULL, this); 
      cout << " operatoreSSpm\n";
      operatoreSSpm(*pd ,  buffer, 1, NULL, this);
      cout << " OK\n";
       jz= Sz(*pd)+Mz(*pd);
      for(int j=i; j<fine; j++)
	{
	  pdn = &(base_canonica[j]);
	  double sc=buffer.scalareordinato(*pdn);
	  if(sc) {
	  	operatore.aggiungiElemento(sc,j,i);
	  	operatore.aggiungiElemento(sc,i,j);
	  }
	  if(j==i) operatore.aggiungiElemento(jz*(jz-1)  ,j,i) ;
	}
    } 
};



SOTTOSPAZIO::SOTTOSPAZIO():operatore()
{
  base_canonica=0;
  // dim_can=0;
  n_sottospazi=0;
  sottospazi=0;
  inizio=0;
  fine=0;
}

SOTTOSPAZIO::~SOTTOSPAZIO()
{
  for(int i=0; i< n_sottospazi; i++)
    {
      sottospazi[i].~SOTTOSPAZIO();
    }
   if(sottospazi) delete  [] sottospazi;
}

void SOTTOSPAZIO::inizializza(DETERMINANTE *collezione,int a, int b)
{
  base_canonica=collezione;
  inizio=a;
  fine=b;
}


void SOTTOSPAZIO::serializza(fichier &f)
{
  f.serialcomment("SOTTOSPAZIO\n");
  f.serialcomment("basecanonicaimposatatadaasfhfs\n");
  f.serialint(&inizio, LINEASALTO);
  f.serialint(&fine  , LINEASALTO);
}


void asfhfs::serializza(fichier &f)
{
  // tutto fuorche i dati che servono solamente
  // a costruire le configurazione di base
  f.serialcomment("ATOMO_ASFERICO\n");
  f.serialcomment("nstati ");
  f.serialint(&nstati, LINEASALTO);
 
  f.serialcomment("nel  ");  f.serialint(&nel, LINEASALTO); 

  // f.serialcomment("defjz  ");  f.serialdouble(&defjz, LINEASALTO); 
  f.serialcomment("defjz  ");
  defjz.serializza(f);

  f.serialcomment("ndet  ");  f.serialint(&n_det, LINEASALTO); 
    
   
  if(f.serial==LEGGI)
    {
      collezione = (DETERMINANTE*) new char [sizeof( DETERMINANTE)*n_det];
      for(int i=0; i<n_det;i++)  collezione[i].creatoreDETERMINANTE();
      cout << " LETTURA\n";
    }
  char buffer[80];
  for(int i=0; i<n_det; i++)
    {
      sprintf(buffer,"DETERMINANTECANONICO_%d\n",i);
      f.serialcomment(buffer);
      collezione[i].serializza(f);
    }
  if(f.serial==LEGGI)
    {
      loforb.resize(nstati);
      noforb.resize(nstati);
    }
  f.serialcomment("noforbloforb\n");
  for(int i=0; i<noforb.rows(); i++)
    {
      f.serialint(&noforb(i));
      f.serialint(&loforb(i), LINEASALTO);
    }

  
  int dimr,dimc;
  f.serialcomment("num_orbitale\n");
  f.serialcomment("dimensioni ");
  if(f.serial==SCRIVI)
    {
      dimr= num_orbitale.rows();
      dimc=num_orbitale.columns();
    }

  f.serialint(&dimr);
  f.serialint(&dimc);
  f.saltolinea();

  if(f.serial==LEGGI)
    {
      num_orbitale.resize(dimr,dimc);
    }

  for(int i=0; i<dimr;i++)
    {
      for(int j=0; j<dimc; j++)
	{
	  f.serialint(&num_orbitale(i,j) );
	}
      f.saltolinea();
    }
  
  f.serialcomment("nsottospazi ");
  f.serialint(&nsottospazi, LINEASALTO);
  
  if(f.serial==LEGGI )
    {
      sottospazi = new SOTTOSPAZIO[nsottospazi];
    }
  cout << " sottospazi = " << nsottospazi << endl;
  for(int i=0; i< nsottospazi; i++)
    {
      sprintf(buffer,"SOTTOSPAZIO%d\n",i);
      f.serialcomment(buffer);
      sottospazi[i].serializza(f);
      sottospazi[i].base_canonica=collezione ; 
    }
  cout << " SOTTOSPAZI OK \n";
  // int dimr,dimc;
  f.serialcomment("dimensionieval\n");
  if(f.serial==SCRIVI)
    {
      dimr=eVal.rows();
      dimc=eVal.columns();
    }

  f.serialint(&dimr);
  f.serialint(&dimc);
  f.saltolinea();

  cout << dimr << " " <<dimc << endl;

  if(f.serial==LEGGI)
    {
      eVal.resize(dimr,dimc);
    }
  
  for(int i=0; i<dimr;i++)
    {
      for(int j=0; j<dimc; j++)
	{
	  f.serialdouble(& eVal(i,j) );
	}
      f.saltolinea();
    }
  cout << " eVect OK \n";
  // int dimr,dimc;
  f.serialcomment("dimensionieVect\n");
  if(f.serial==SCRIVI)
    {
      dimr=eVect.rows();
      dimc=eVect.columns();
    }

  f.serialint(&dimr);
  f.serialint(&dimc);
  f.saltolinea();

  if(f.serial==LEGGI)
    {
      eVect.resize(dimr,dimc);
    }
  
  for(int i=0; i<dimr;i++)
    {
      for(int j=0; j<dimc; j++)
	{
	  f.serialdouble(& eVect(i,j) );
	}
      f.saltolinea();
    }


  if(f.serial==SCRIVI)  
    {
      if(   strstr(opzioni,"nientemomenti")==0)
	{
	  calcolagliSzMzmedi();
	}
      else
	{
	  szz.resize(dimc);szz=0.0;
	  mzz.resize(dimc);mzz=0.0;
	}
    }
  cout << " calcolamediSzMz  OK \n";
  f.serialcomment("Sz");
  serialuMatrix(f,szz);
  f.serialcomment("Mzz");
  serialuMatrix(f,mzz);

  if(f.serial==SCRIVI)
    {
      if( strstr(opzioni,"nientemomenti")==0)
	{      
	  calcolagliLLmedi();
	}
      else
	{
	  LL.resize(dimc); LL=0.0;
	  LLLL.resize(dimc);LLLL=0.0;
	  LLpar.resize(dimc,nstati);LLpar=0.0;
	  srmqdLL.resize(dimc); srmqdLL=0.0;
	}
    }
  cout << " calcolamediLL OK \n";
  f.serialcomment("LLmedi");
  serialuMatrix(f,LL);
  f.serialcomment("LLparzialimedi");
  serialuMatrix(f,LLpar);
  f.serialcomment("LLLLmedi");
  serialuMatrix(f,LLLL);
  f.serialcomment("srmqdLLmedi");
  serialuMatrix(f,srmqdLL);

  if(f.serial==SCRIVI)
    {
      if( strstr(opzioni,"nientemomenti")==0)
	{      
	  calcolagliSSmedi();
	}
      else
	{
	  SS.resize(dimc); SS=0.0;
	  SSSS.resize(dimc);SSSS=0.0;
	  SSpar.resize(dimc,nstati);SSpar=0.0;
	  srmqdSS.resize(dimc); srmqdSS=0.0;
	}
    } 

  cout << " calcolamediSS OK \n";
  f.serialcomment("SSmedi");
  serialuMatrix(f,SS);
  f.serialcomment("SSparzialimedi");
  serialuMatrix(f,SSpar);
  f.serialcomment("SSSSmedi");
  serialuMatrix(f,SSSS);
  f.serialcomment("srmqdSSmedi");
  serialuMatrix(f,srmqdSS);

  
  if(f.serial==SCRIVI)  
    {
      if(  strstr(opzioni,"nientemomenti")==0)
	{
	  calcolagliSLmedi();
	}
      else
	{
	  SL.resize(dimc);SL=0.0;
	  SLpar.resize(dimc,nstati);SLpar=0.0;
	}
    }

  
  cout << " calcolamediSL OK \n";
  f.serialcomment("SLparzialimedi");
  serialuMatrix(f,SLpar);
 
  if(f.serial==SCRIVI) 
    {
      JJ.resize(SL.rows());
      for(int i=0; i< JJ.rows(); i++)
	{
	  JJ(i)=SS(i)+LL(i)+2*SL(i);
	}
    }
  serialuMatrix(f,JJ);
  
  
  hfs.serializza(f);
  cout << " OK  OK \n";
}


void asfhfs::inizializza_sottospazi()
{
    {
      sottospazi =  new SOTTOSPAZIO[nstrut];
    }

  nsottospazi=nstrut;
  for(int is=0; is< nstrut; is++)
    {
      sottospazi[is].base_canonica=collezione ;
      int start= (is>0) ? fine_struttura[is-1] : 0 ;
      sottospazi[is].inizializza(collezione,start,fine_struttura[is] );
    }
};

void asfhfs::lettura(char * nome)
{
  {
    FILE *dati= fopen(nome, "r");
    if(!dati)
      {
				cout << " file "<< nome<<" non esistente\n";
				exit(0);
      }
    FILE *tmp = fopen("temp.dat", "w");
    char c;
    int toggle = 1;
    while(!feof(dati))
      {
	c = getc(dati);
	if( (c=='{' && toggle) || ( c=='}' && toggle==0)  )
	  {
	    toggle = 1-toggle ;
	  }
	else if(toggle==1)
	  {
	    putc(c,tmp);
	  }
      }


	 fprintf(tmp,"\n");

    fclose(tmp);
    fclose(dati);
  } 
  
  FILE *dati= fopen("temp.dat", "r");
  
  // legge il numero di strutture nl
  //  int nstrut;
  {
    fscanf(dati,"%d",&nstrut);
  }
  if(nstrut==1)  
    {
      fine_struttura = new int;
    }
  else 
    {
      fine_struttura = new int [ nstrut ];
    }
  // legge il numero  di stati nl
  // int nstati;
  {
    fscanf(dati,"%d",&nstati);
  }
  // legge i numeri quantici N e L
  if(nstati==1)
    {
      N= new int ;L=new int ;  deg=new int ;
    }
  else
    {
      N= new int [nstati];L=new int [nstati];  deg=new int [nstati];
    }
  {
    for(int i=0; i<nstati;i++) 
      {
	fscanf(dati,"%d %d,",&N[i],&L[i]);
	deg[i]=2*(2*L[i]+1);
      }
  }
  // legge le occupazioni
    occ=i_matrice(nstrut,nstati);
    {
      int totold=0,tot=0;
      for(int i=0; i<nstrut; i++)
	{
	  tot=0;
	  for(int n=0; n< nstati; n++)
	    {
	      fscanf(dati,"%d",&(occ[i][n]));
	      tot +=occ[i][n] ;
	    }
	  if(i!=0 && tot!=totold)
	    {
	      cout << " il numero di elettroni non e' costante " << endl ;
	      exit(0);
	    }
	  totold=tot;
	}
      nel =tot;
    }
    // legge la proiezione dello spin totale J=S+L lungo z
    fscanf(dati,"%le",&defjz.jz);
    cout << " defjz est " << defjz.jz << endl;
    fscanf(dati,"%le",&defjz.minSz);
    cout << "minSz  est " <<defjz.minSz  << endl;
    fscanf(dati,"%le",& defjz.maxSz  );
    cout << " maxSz  est " << defjz.maxSz  << endl;

    fscanf(dati,"%s",opzioni);
		cout << opzioni ;
		if(feof(dati))
      {
				cout << " ATTENZIONE!!!!!!!!!!"<<endl;
				cout << " la fine del file e stata raggiunta \n";
				exit(0);
      }
    fclose(dati);
} 

void ricorsiva_determinanti( int *occD, int nstati,
			    int *ND, int * LD, int * degD,
			    DETERMINANTE &costruendo,
			     int messi, int imin,int nf,
			    int & result, LIMITATIONS &defjz, int azione,
			    DETERMINANTE * collezione, int Stato);

int asfhfs::conta_determinanti()
{
  int result=0;
  double par= ((nel %2)==0)? 0:0.5 ;
  if( fabs(defjz.jz) < 99 &&  fabs(par-fabs(defjz.jz-((int) defjz.jz)))>0.0001)
    {
      cout<< " Il valore di Jz("<<defjz.jz<<
	" definito in input non e compatibile con il numero di elettroni"<<nel
	  <<endl;
      exit(0);
    }
  DETERMINANTE costruendo;
  //  costruendo.livello= new LIVELLO [nel];
  // costruendo.nel=nel;
  costruendo.resize( nel  );
  int stato=0;
  for(int is=0; is< nstrut; is++)
    {
      ricorsiva_determinanti(occ[is],nstati,N,L,deg,
			     costruendo, 0,0,0,
			     result, defjz, NONCREARE,NULL,stato);
      fine_struttura[is]=result;
    }
  n_det=result;
  return result; 
}


void asfhfs::crea_determinanti()
{
  int result=0;
  double par= ((nel %2)==0)? 0:0.5 ;
  if( fabs(par-fabs(defjz.jz-((int) defjz.jz)))>0.0001)
    {
      cout<< " Il valore di Jz("<<defjz.jz<<
	" definito in input non e compatibile con il numero di elettroni"<<nel  <<endl;
      exit(0);
    }
  DETERMINANTE costruendo;
  costruendo.resize(nel);
  int stato=0;

    {
      collezione = (DETERMINANTE*) new char [sizeof( DETERMINANTE)*n_det];
      for(int i=0; i<n_det;i++)  collezione[i].creatoreDETERMINANTE();
    }
  for(int i=0; i< n_det; i++)
    {
      collezione[i].resize(nel);
    }

  for(int is=0; is< nstrut; is++)
    {
      	ricorsiva_determinanti(occ[is],nstati,N,L,deg,
			     costruendo, 0,0,0,
			     result, defjz, CREA,collezione ,stato);
      	fine_struttura[is]=result;
    }
  n_det=result;
}

void asfhfs::diagonalizzaH (double dene)
{
  matricione.diagonalizzaH (dene,eVect,  eVal );
};


void ricorsiva_determinanti( int *occD, int nstati,
			    int *ND, int * LD, int * degD,
			    DETERMINANTE &costruendo,
			     int messi, int imin,int nf,
			    int & result, LIMITATIONS & defjz, int azione,
			    DETERMINANTE * collezione, int Stato)
{
  int occ=occD[Stato];
  int N=ND[Stato];
  int L=LD[Stato];
  int deg=degD[Stato];

  if(nf==costruendo.getnel())
    {
      if(messi!=occ)
	{
	  cout << " problem \n";
	  exit(0);
	}
      // calcolo dello  dello spin lungo z
      double Sz=0;
      double Jz=0;
      for(int k=0; k< costruendo.getnel(); k++)
	{
	  Jz += costruendo.getlevel(k).sz*0.5+costruendo.getlevel(k).mz ;
	  Sz += costruendo.getlevel(k).sz*0.5 ;
	}
      // controllo dello spin
      if((Jz!=defjz.jz  )&& defjz.jz<99        || Sz<defjz.minSz || Sz>defjz.maxSz       )
	{
	  return ;
	}
      else
	{
	  if(azione==CREA)
	    {
	      collezione[result].copia(costruendo);
	      collezione[result].riordinalivelli();
		  collezione[result].setsegno(1);
	    }
	  result++;
	}
      return;
    }
  
  if(messi<occ)
    {
      for(int ip=imin; ip<(deg-(occ-1-messi)); ip++)
	{
	  costruendo.getlevel(nf).n=N;
	  costruendo.getlevel(nf).l=L;
	  costruendo.getlevel(nf).mz= (ip % (deg/2)) -L;
	  costruendo.getlevel(nf).sz=(ip < deg/2 ) ? -1 : 1 ;
	  ricorsiva_determinanti( occD, nstati,
				  ND,  LD,degD,
				  costruendo,messi+1,ip+1,nf+1,
				  result, defjz,  azione,
				  collezione, Stato)    ;
	}
    }
  else
    {
      if(Stato<nstati)
	{
	  Stato++;
	  messi=0;
	}
      ricorsiva_determinanti( occD, nstati,
			      ND,  LD,degD,
			      costruendo,messi,0,nf,
			      result, defjz,  azione,
			      collezione, Stato)    ;
    }
};




void  aggiungiSOamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazioA,
			    SOTTOSPAZIO &spazioB,
			    double SO, int na, int la, int nb, int lb ,
			    int Acolumns,  int Bcolumns  )
{
  DETERMINANTE *da, *db;
  
  TIPOFATTORE  elmat=0,fatt;
  
  static DETERMINANTE dres;
  
  int nel=(spazioA.base_canonica+spazioA.inizio)->getnel();
  int spa[nel],spb[nel];
  
  
  // controlliamo che la transizione non sia assurda
  if(lb!=la)
    {
      cout << " transizione assurda in aggiungiSOamatricione \n";
      exit(0);
    }
  
  COUCHE Ca(na,la);
  COUCHE Cb(nb,lb) ; 
  

  double precouMza[spazioB.fine];
  double precouSza[spazioB.fine];
  double precouMzb[spazioB.fine];
  double precouSzb[spazioB.fine];
	for(int i=0; i<spazioB.fine; i++) {
		precouMza[i]=-101;
		precouSza[i]=-101;
		precouMzb[i]=-101;
		precouSzb[i]=-101;
	}

  for(int rba=spazioA.inizio; rba<spazioA.fine; rba++)
    {
      da= spazioA.base_canonica+rba;
      da->preparatavola();
      double mza,mzb, sza,szb;
      double mzaCa,szaCa,  mzaCb,szaCb;
      double mzbCa,szbCa,  mzbCb,szbCb;
      
      mza=Mz(*da);
      sza=Sz(*da);
      
      mzaCa=Mz(*da, &Ca);
      szaCa=Sz(*da, &Ca);
      mzaCb=Mz(*da, &Cb);
      szaCb=Sz(*da, &Cb);
      
      
      for(int rbb=spazioB.inizio; rbb< spazioB.fine; rbb++)
	{    
	  
	  db= spazioB.base_canonica+rbb;
	  
	  mzb  =preMz(*db);
	  szb  =preSz(*db);
	  
	  if( (mza+sza)!= (mzb+szb) ) continue;
	
	
	
	  if(precouMza[rbb]<-100)  {
	  		mzbCa = precouMza[rbb] =Mz(*db, &Ca) ;
	  } else {
		    mzbCa = precouMza[rbb] ;
	  }
	
	
	  if(precouSza[rbb]<-100)  {
	  		szbCa = precouSza[rbb] =Sz(*db, &Ca) ;
	  } else {
		    szbCa = precouSza[rbb] ;
	  }
	  		
	  	
	  if(precouMzb[rbb]<-100)  {
	  		mzbCb = precouMzb[rbb] =Mz(*db, &Cb) ;
	  } else {
		    mzbCb = precouMzb[rbb] ;
	  }
	

	
	  if(precouSzb[rbb]<-100)  {
	  		szbCb = precouSzb[rbb] =Sz(*db, &Cb) ;
	  } else {
		    szbCb = precouSzb[rbb] ;
	  }
	
	
	

	  
	  if( (mzaCa+szaCa + mzaCb+szaCb )!= (mzbCa+szbCa +mzbCb+szbCb ) ) continue;
	  
	  if( fabs(mzaCa -mzbCa )>1.001  ) continue; 

	  db->preparatavola();
	  // possiamo controllare che da e db differiscano per
	  // al piu' 2 stati
	  // if(spaiati(*da,*db)<=2)    //  break;
	  if(possibileuncorpoordinati(*da,*db,Ca, Cb ))
	    {
	      // se da e db sono lo stesso stato
	      // considereremo solamente la parte Lz*Sz di
	      // L.S= (L+*S- +  L-*S)/2  +  Lz*Sz	  
	      if(spaiatiordinati(*da,*db,spa,spb)==0)
		{ 
		  // controlliamo solo che na==nb e la==lb
		  if(na!=nb || la!=lb)
		    {
		      cout << " problema na!=nb || la!=lb in aggiungiSOamatricione con spaiati(da,db)==0\n";
		      exit(0);
		    }
		  elmat=0;
		  fatt = dotordinato(*da,*db);
		  for(int ma=-la;ma<=la;ma++)
		    {
		      for(int sa=-1;sa<=1;sa+=2)
			{
			  if((da->gettavola(na,la,ma,sa))>=0)	
			    {
			      elmat += SO*fatt* ma*sa *0.5;
			    }
			}
		    }
		}
	      // se da e db  non  sono lo stesso stato
	      // considereremo solamente la parte non diagonale di
	      // L.S= (L+*S- +  L-*S)/2  +  Lz*Sz	 	
	      else
		{
		  int ia,ib;
		  spaiatiordinati(*da,*db,spa,spb);
		  ia=spa[0];
		  ib=spb[0];
		  int Na,Nb,La,Lb, Ma,Mb;
		  double Sa,Sb;
		  
		  Na= da->  getlevel( ia).n;
		  La= da->  getlevel( ia).l;
		  Ma= da->  getlevel( ia).mz;
		  Sa= da->  getlevel( ia).sz;
		  
		  Nb= db->  getlevel( ib).n;
		  Lb= db->  getlevel( ib).l;
		  Mb= db->  getlevel( ib).mz;
		  Sb= db->  getlevel( ib).sz;
		  
		  
		  // guardiamo se la differenza involve i livelli
		  // giusti, se no brekkiamo al rbb seguente
		  //( questo controllo ha solo effetto quando spazioA==spazioB)
		  if(Na!=na || Nb !=nb || La!=la || Lb!=lb) 
		    {
		      elmat=0;
		    }
		  else
		    {
		      
		      
		      // abbiamo gia controllato che sia la==lb
		      
		      if( Mb == Ma+1 && Sb == Sa-2 ) // L+
			{
			  dres.copia(*da);
			  dres.getlevel(ia)=db->getlevel(ib);
			  dres.riordinalivelli();
			  fatt=dotordinato(dres,*db);
			  
			  elmat = SO*fatt*sqrt( (La-Ma)*(Lb+Mb) ) *0.5;
			}
		      else if(Ma == Mb+1  && Sa == Sb-2 ) // L-
			{
			  dres.copia(*da);
			  dres.getlevel(ia)=db->getlevel(ib);
			  dres.riordinalivelli();
			  fatt=dotordinato(dres,*db);
			  
			  elmat = SO*fatt* sqrt( (La+Ma)*(Lb-Mb) )  *0.5; 
			}
		      else
			{
			  elmat=0;
			}
		    }
		}
	      cout << " per la coppia " << rba <<  "  " << rbb << " elmat= " << elmat << endl;
	      if(elmat!=0)
		{
  
		  matricione.sommaH(Bcolumns+rbb, Acolumns+rba,
				    elmat );
		  if(Acolumns!=Bcolumns)
		    {
		      matricione.sommaH( Acolumns+rba, Bcolumns+rbb,
					 elmat );	
		    }
		}
	    }
	}
    }
}

void  aggiungiSpinZamatricione(Risolutore &matricione,
			       SOTTOSPAZIO &spazioA,
			       double uz, int na, int la,
			       int Acolumns  )
{
  COUCHE c(na,la);
  DETERMINANTE *da;
  double elmat;
  for(int rba=spazioA.inizio; rba<spazioA.fine; rba++)
    {
      da= spazioA.base_canonica+rba;
      elmat=uz*Sz(*da,&c);
      matricione.sommaH(Acolumns+rba, Acolumns+rba,
			elmat  );	
      
    }
}

void  aggiungiCristalloamatricione(Risolutore &matricione,
				   SOTTOSPAZIO &spazioA,
				   SOTTOSPAZIO &spazioB,
				   uMatrix<double> cristallo, int na, int la, int nb, int lb ,
				   int Acolumns,  int Bcolumns  )
{
  //CristalloAB
  if(cristallo.columns()!=2*la+1 || cristallo.rows()!=2*lb+1)
    {
      cout << " Kaputt skfjghfd in aggiungiCristalloamatricione\n";
      exit(0);
    }
  DETERMINANTE *da=0, *db=0;
  
  TIPOFATTORE  elmat=0, fatt;
  
  static DETERMINANTE dres;
  
  int nel=(spazioA.base_canonica+spazioA.inizio)->getnel();
  int spa[nel],spb[nel];
  
  for(int rba=spazioA.inizio; rba<spazioA.fine; rba++)
    {
      da= spazioA.base_canonica+rba;
      da->preparatavola();
      COUCHE Ca(na,la);
      double sza=Sz(*da);
      for(int rbb=spazioB.inizio; rbb< spazioB.fine; rbb++)
	{      
	  db= spazioB.base_canonica   +   rbb;
	  db->preparatavola();
	  // possiamo controllare che da e db differiscano per
	  // al piu' 2 stati
	  // if(spaiati(*da,*db)<=2)    //  break;
	  COUCHE Cb(nb,lb) ; 
	  if( sza==Sz(*db) &&  possibileuncorpoordinati(*da,*db,Ca, Cb ))
	    {
	      // se da e db sono lo stesso stato
	      // considereremo solamente la parte Lz*Sz di
	      // L.S= (L+*S- +  L-*S)/2  +  Lz*Sz	  
	      if(spaiatiordinati(*da,*db,spa,spb)==0)
		{ 
		  // controlliamo solo che na==nb e la==lb
		  if(na!=nb || la!=lb)
		    {
		      cout << " problema na!=nb || la!=lb in aggiungiCristalloamatricione con spaiati(da,db)==0\n";
		      exit(0);
		    }
		  
		  elmat=0;
		  for(int ma=-la;ma<=la;ma++)
		    {
		      for(int sa=-1;sa<=1;sa+=2)
			{
			  if((da->gettavola(na,la,ma,sa))>=0)	
			    {
			      elmat += cristallo(la+ma,la+ma) ;
			    }
			}
		    }
		  if(fabs(elmat) !=0.0) {
		    fatt = dotordinato(*da,*db);
		    elmat *= fatt;
		  }
		  
		}
	      else
		{
		  int ia,ib;
		  int dum=spaiatiordinati(*da,*db,spa,spb);
		  cout << dum<<"\n";
		  ia=spa[0];
		  ib=spb[0];
		  int Na,Nb,La,Lb, Ma,Mb;
		  double Sa,Sb;
		  static LIVELLO leva, levb;
		  
		  leva= da->  getlevel( ia);
		  levb= db->  getlevel( ib);
		  
		  Na= leva.n;
		  La= leva.l;
		  Ma= leva.mz;
		  Sa= leva.sz;
		  
		  Nb= levb.n;
		  Lb= levb.l;
		  Mb= levb.mz;
		  Sb= levb.sz;
		  
		  
		  // guardiamo se la differenza involve i livelli
		  // giusti, se no brekkiamo al rbb seguente
		  //( questo controllo ha solo effetto quando spazioA==spazioB)
		  if(Na!=na || Nb !=nb || La!=la || Lb!=lb  ) 
		    {
		      elmat=0;
		    }
		  else
		    {
		      dres.copia(*da);
		      dres.getlevel(ia)=db->getlevel(ib);
		      dres.riordinalivelli();
		      elmat = cristallo(Lb+Mb,La+Ma) ;
		      if(elmat!=0) {
			fatt=dotordinato(dres,*db);
			elmat = fatt*elmat ;
		      }
		    }
		}
	      cout << "Aggiungi cristallo :  per la coppia " << rba <<  "  " << rbb << " elmat= " << elmat << endl;
	      if(elmat!=0)
		{	  
		  matricione.sommaH(Bcolumns+rbb, Acolumns+rba, elmat  );
		  if(Acolumns!=Bcolumns)
		    {
		      matricione.sommaH( Acolumns+rba, Bcolumns+rbb,
					 elmat  );	
		    }
		}
	    }  
	}
    }
}


void  aggiungiKineamatricione(Risolutore &matricione,
			      SOTTOSPAZIO &spazioA,
			      SOTTOSPAZIO &spazioB,
			      double J, int orbia, int orbib,
			      int Acolumns,  int Bcolumns, uMatrix<int> &noforb, 
			      uMatrix<int> &loforb  )
{
  int nel=(spazioA.base_canonica+spazioA.inizio)->getnel();
  int spa[nel],spb[nel];

  DETERMINANTE *da, *db;

  TIPOFATTORE  elmat, fatt;

  static DETERMINANTE dres;
	
  // controlliamo che la transizione non sia assurda

  if(loforb(orbia) != loforb(orbib) )
    {
      cout << " transizione assurda in aggiungiKineamatricione \n";
      exit(0);
    }
  
  for(int rba=spazioA.inizio; rba<spazioA.fine; rba++)
    {
      da= spazioA.base_canonica+rba;
      da->preparatavola();
      for(int rbb=spazioB.inizio; rbb< spazioB.fine; rbb++)
	{      
	  db= spazioB.base_canonica+rbb;
	  db->preparatavola();
	  // possiamo controllare che da e db differiscano per
	  // al piu' 2 stati
	  int spdadb;
	  if( (spdadb=spaiatiordinati(*da,*db,spa,spb)) >1) continue;
	  
	  // se da e db sono lo stesso stato
	  // considereremo solamente la parte Lz*Sz di
	  // L.S= (L+*S- +  L-*S)/2  +  Lz*Sz	  
	  if(spdadb==0)
	    { 
	      // controlliamo solo che ia == ib
	      if(orbia != orbib)
		{
		  cout << " problema iia != ib n aggiungiKineamatricione con spaiati(da,db)==0\n";
		  exit(0);
		}
	      elmat=0;
	      fatt = dotordinato(*da,*db);
	      int na=noforb(orbia);
	      int la=loforb(orbia);

	      for(int ma=-la;ma<=la;ma++)
		{
		  for(int sa=-1;sa<=1;sa+=2)
		    {
		      if((da->gettavola(na,la,ma,sa))>=0)	
			{
			  elmat += J*fatt ;
			}
		    }
		}
	    }
	  else
	    {
	      int ia,ib;
	      ia=spa[0];
	      ib=spb[0];

	      int Na,Nb,La,Lb, Ma,Mb;
	      double Sa,Sb;
	      
	      Na= da->  getlevel( ia).n;
	      La= da->  getlevel( ia).l;
	      Ma= da->  getlevel( ia).mz;
	      Sa= da->  getlevel( ia).sz;
	      
	      Nb= db->  getlevel( ib).n;
	      Lb= db->  getlevel( ib).l;
	      Mb= db->  getlevel( ib).mz;
	      Sb= db->  getlevel( ib).sz;
	      

	      // guardiamo se la differenza involve i livelli
	      // giusti, se no brekkiamo al rbb seguente
	      //( questo controllo ha solo effetto quando spazioA==spazioB)

	      if( La!=loforb(ia) || Lb != loforb(ib) ||
		  Na!=noforb(ia) || Nb != noforb(ia) ||
		  Ma!=Mb || Sa!=Sb )
		{
		  continue;
		}


	      dres.copia(*da);
	      dres.getlevel(ia)=db->getlevel(ib);
	      dres.riordinalivelli();
 	      fatt=dotordinato(dres,*db);
	      
	      elmat = J*fatt;
	      	  
      	    }
	  if(elmat!=0)
	    {
	      matricione.sommaH(Bcolumns+rbb, Acolumns+rba, elmat  );
	      if(Acolumns!=Bcolumns)
		{
		  matricione.sommaH( Acolumns+rba, Bcolumns+rbb,
				     elmat 
				     );
		}
	    }
	}
    }  
}
 
void quatrelevelsaggiungiFGamatricione(Risolutore &matricione,Risolutore *matrid,
				       SOTTOSPAZIO &spazioA,
				       SOTTOSPAZIO &spazioB,
				       double * G,
				       int na1,int la1, // a1 va in b1
				       int nb1,int lb1,
				       int na2,int la2,     // a2 va in b2 
				       int  nb2, int lb2,
				       int offseta,
				       int offsetb)
{
 
  DETERMINANTE *da, *db;
  TIPOFATTORE  elmat,elmatrid;
  TIPOFATTORE  add=0.0,addrid=0,fatt;

  int kmin,kmax;  
  kmax= Min(la1+lb1, la2+lb2);
  kmin=Max(Abs(la1-lb1),Abs(la2-lb2));


  COUCHE ca1(na1,la1), ca2(na2,la2), cb1(nb1,lb1), cb2(nb2,lb2);
  int Qa1,Qa2;
  Qa1=spazioA.qnl(na1,la1);
  Qa2=spazioA.qnl(na2,la2);

  for(int rba=spazioA.inizio; rba<spazioA.fine; rba++)
    {
      da= spazioA.base_canonica+rba;
      da->preparatavola();
      if( (rba % (spazioA.fine/30) )==0 ) cout << rba << endl;
      for(int rbb=spazioB.inizio; rbb< spazioB.fine; rbb++)
		{
	  	{
	    	if(offseta==offsetb)
	      	{
				if(Qa1==2*(2*la1+1) ||  Qa2==2*(2*la2+1))
		  		{
		    	if(rbb!=rba) continue;
		  		}
		    	if( (ca1!=cb1 || ca2!=cb2) &&  (ca1!=cb2 || ca2!=cb1) ) return;
	      	}
	  }
	 db= spazioB.base_canonica+rbb ;
	  db->preparatavola() ;
	  // possiamo controllare che da e db differiscano per
	  // al piu' 4 stati
	  // Inoltre lo spin non cambia
	  if( preSz(*da)==preSz(*db) && preMz(*da)==preMz(*db) && possibileduecorpiordinati(*da,*db, ca1,ca2,cb1,cb2      ) )
	    {
	      elmat=0;
	      elmatrid=0;
	      // obbiettivo: trovare per ogni coppia  formata da
	      // un livello di partenza in da e uno di arrivo in db,
	      // aventi na1,la1 e nb1,lb1,(e stesso spin)  una seconda coppia
	      // con  numeri quantici na2 la2 e nb2 lb2 ma con Dmz opposto
	      int ma1,sa1,mb1,sb1;
	      int ma2,sa2,mb2,sb2;
	      int a1,b1,a2=0,b2=0;
	      static DETERMINANTE dres;
	      /*
		kit securite pour la nacelle, la nacelle
		il se trouvent dans le primebolle
		attacher sur les ceinture a l' arriere de la megane
		prendre la nacelle,matela autour de la tete
		plastique  que on me dans la nacelle*
		Alaise en coton epais cottoneau derniere titoir 
		du primebolle, un des desux qui sont a gauche
		a mettre su rle premier matelat
		Un T shirts
		Sac de voyage violet parce que il y a beaucoupdes choses a ramener
		Sac sport 
	       */
	      for(ma1=-la1;ma1<=la1;ma1++)
		{
		  for(sa1=-1;sa1<=1;sa1+=2)
		    {
		      if((a1=da->gettavola(na1,la1,ma1,sa1))>=0)
			{
			  sb1=sa1;
			  for(mb1=-lb1;mb1<=lb1;mb1++)
			    {
			      if((b1=db->gettavola(nb1,lb1,mb1,sb1))>=0)
				{
				  for(ma2=-la2;ma2<=la2;ma2++)
				    {
				      mb2=ma2+ma1-mb1;
				      if( mb2>=-lb2 && mb2 <= lb2)
					{
					  for(sa2=-1;sa2<=1;sa2+=2)
					    {
					      sb2=sa2;
					      if((a2=da->gettavola(na2,la2,ma2,sa2))>=0 &&
						 (b2=db->gettavola(nb2,lb2,mb2,sb2))>=0 &&
						  a2!=a1 && b2!=b1
						 )
						{
						  // ora bisogna controllare 
						  // che la transizione a1->b1 e a2->b2
						  // dia, a partire da da, uno stato parallelo a db

						  int ab1,ab2;

						  ab1=da->gettavola(db->getlevel(b1));
						  ab2=da->gettavola(db->getlevel(b2));
						  
						  int doublycheck=0;
						  if( (ab1<0 || ab1==a1 || ab1==a2 ) && ( ab2<0 || ab2==a1 || ab2==a2 ) )
						    {
						      // nessuno stato doppio
						      doublycheck=1;
						    }
						  else 
						    {
						      doublycheck=0;
						    }
						  

						  if(doublycheck)
						    {
						      // finalmente possiamo fare il 
						      // prodotto scalare fra dres e db
 
						      dres.copia(*da);
						      dres.getlevel(a1)=db->getlevel(b1);
						      dres.getlevel(a2)=db->getlevel(b2);
						      
						      dres.riordinalivelli();
						      fatt=dotordinato(dres,*db);
						      if(fatt!=0)
							{
							  add=0.0;
							  addrid=0.0;
							  int segno;
							  for(int l=kmin; l<=kmax;l++)
							    {
							      segno=( (ma2+mb1) % 2 ==0  )? 1:-1;
							      // segno=1;
							      if(l>=Abs(mb1-ma1) )
								{
									double dum;
								  dum=fatt*segno*G[l]*
								    Atomo_sferico::trej(lb1,l,la1,-mb1,mb1-ma1,ma1)*
								    Atomo_sferico::trej(lb1,l,la1,0,0,0)*
								    Atomo_sferico::trej(la2,l,lb2,-ma2 ,ma2-mb2,mb2)*
								    Atomo_sferico::trej(la2,l,lb2,0 ,0 ,0 )*
								    sqrt((2.*la1+1)*(2*lb1+1)*
									 (2*la2+1)*(2*lb2+1));
									if(l==0 ||  matrid==0) add+=dum;
									else     addrid+=dum;
								  /*
								    cout << " **************************** " << endl;
								    cout << " transizione " << a1 << "-->" << b1<<endl;
								    cout << " transizione " << a2 << "-->" << b2<<endl;
								    cout << segno << endl;
								    cout << fatt << endl;
								    cout << G[l] << "l= " << l << endl;
								    cout << Atomo_sferico::trej(lb1,l,la1,0,0,0)<< endl;
								    cout << Atomo_sferico::trej(lb1,l,la1,-mb1,mb1-ma1,ma1)<< endl;
								    cout << Atomo_sferico::trej(la2,l,lb2,0 ,0 ,0 )<< endl;
								    cout << Atomo_sferico::trej(la2,l,lb2,-ma2 ,ma2-mb2,mb2)<< endl;
								    */
								}
							    }
							  elmat+=add;
							  elmatrid+=addrid;
							}
						    }
						} 
					    }		  
					}
				    }
				}
			    }
			}
		    }
		}
	      if(elmat!=0 || elmatrid!=0) // guardare la simmetria quando i due sottospazi sono diversi
		{

		  // questa divisione si effettua perche nel loop di chiamata
		  // si ha it >= is
		  // Se invece e una transizione fra due couche differenti
		  // C`e gia un fattore 1/2 per via della simmetria
		  //
		  if( offseta == offsetb  && na1==na2 &&  la1==la2 )
		    {
		      elmat *=0.5;
		      elmatrid *=0.5;
		    }
		  	  
		  // cout << " si aggiunge " << elmat << endl;
		  if(matrid && elmatrid!=0 ) matrid->sommaH(offsetb+rbb, offseta+rba, elmatrid   );
		  if(elmat!=0)               matricione.sommaH(offsetb+rbb, offseta+rba, elmat   );
		  // questa simmetrizzazione si effettua perche nel loop
		  // di chiamata si economizza su spazioA precedente spazioB
		  if(offseta!=offsetb)
		    {
					 if(matrid && elmatrid!=0 ) matrid->sommaH(offseta+rba,offsetb+rbb,elmatrid);	
					 if(elmat!=0) matricione.sommaH( offseta+rba, offsetb+rbb, elmat );
		    }
		  
		}
	    }
	}
    }
  
};


void  Risolutore::resize(int n)
{
 }

void Risolutore::azzera()
{
  matricione.pulisci();
}



void Risolutore::sommaH(int  i,int j, double add)
{
  matricione.aggiungiElemento(add,i,j);
}
		
void immagazzina(Lanczos &lnczs,double shift,int nv,int inversione,
	 uMatrix<double>& eVect,uMatrix<double>&  eVal  , int dim  )
{
  uMatrix<double> aggiunta;
  int na;
  na=0;
  
  int aggiuntayes[nv];
  
  for(int i=0; i< nv ; i++) {
    aggiuntayes[i]=0;
  }
  for(int i=0; i<nv; i++) {
    double e= (inversione==1) ?  (1./lnczs.geteigenvalue(i) - shift) : ( lnczs.geteigenvalue(i)-shift) ;
    printf("%20.12e\n", e);
  }		
  for(int i=0; i<nv; i++) {
    
    if(eVal.rows()) {
      double e= (inversione==1) ?  (1./lnczs.geteigenvalue(i) - shift) : ( lnczs.geteigenvalue(i)-shift) ;
      {
	aggiuntayes[i]=0;
	if (e+shift > 0)  {
	  
	  double s;
	  for(int k=0; k<eVect.columns(); k++)
	    {
	      if(fabs(e-eVal(k ))<1.0e-8) {
		
		s=scalare( lnczs.geteigenvector(i)    ,   eVect.address() +k*eVect.rows()    ,   dim);
		somma(     lnczs.geteigenvector(i)    ,   eVect.address() +k*eVect.rows()    ,      -s,dim);			
		
	      }	
	    }
	  for(int k=0; k<i; k++)
	    {
	      
	      s=scalare( lnczs.geteigenvector(i)    ,     lnczs.geteigenvector(k)      ,   dim);
	      somma(     lnczs.geteigenvector(i)    ,  lnczs.geteigenvector(k)     ,      -s,dim);			
	      
	    }
	  cout << " residuo= " << fabs( scalare ( lnczs.geteigenvector(i)   ,  lnczs.geteigenvector(i), dim)) << endl;
	  if(  (s=fabs( scalare ( lnczs.geteigenvector(i)   ,  lnczs.geteigenvector(i), dim)))  >1.0e-8    ) {
	    normalizza( lnczs.geteigenvector(i), sqrt(s),dim) ;
	    aggiuntayes[i]=1;
	  }
	}
      }
      if(aggiuntayes[i]) na++;
    } else {
      aggiuntayes[i]=1;
      na++;
    }		
  }
  
  
  if(!na) return;
  aggiunta.resize(dim, na);
  
  int count =0;
  
  for(int i=0; i<nv; i++) {
    if(aggiuntayes[i]) {	
      memcpy(aggiunta.address()+dim*count, lnczs.geteigenvector(i), dim*sizeof(double));
      cout << " aggiungo vettore avente scalare " << scalare (lnczs.geteigenvector(i),lnczs.geteigenvector(i), dim) << endl;
      count++;
    }
  }

  if(eVect.rows()==0) {
    eVect = 	aggiunta;
  } else {
    if(na)     eVect = JoinH(eVect, aggiunta);
  }
  aggiunta.resize( na);
  
  count=0;
  for(int i=0; i<nv; i++) {
    if(aggiuntayes[i]) {	
      double e= (inversione==1) ?  (1./lnczs.geteigenvalue(i) - shift) : ( lnczs.geteigenvalue(i)-shift) ;
      aggiunta(count)=e;
      count++;
    }
  }
  
  if(eVal.rows()==0) {
    eVal = 	aggiunta;
  } else {
    if(na)     eVal = JoinV(eVal, aggiunta);
  }	
  cout << " aggiunti " << eVal.rows() <<" valori "<<  endl;
};


void Risolutore::diagonalizzaH ( double dene, uMatrix<double>& eVect, uMatrix<double>& eVal )
{
  Lanczos lnczs;
  // matricione.scrivi();
	
  matricione.gohersch();
  double shift=-matricione.goherschMin()  +1.0e-4 ;
  int inversione = 1;
  int nv=5;

  eVect.resize(0,0);
  eVal .resize(0,0);
  lnczs.setMatrice(&matricione, inversione);

		

	for(;;) {
	  cout << " cerca\n";
	  	cout << " shift " << shift << endl;
	    int k=lnczs.cerca(nv,shift,2.0e-16);
	
	
	    cout << " k = " << k << " shift = " << shift << endl;
		/*
		for(int i=0; i<nv-1; i++) {
			for(int j=0; j< nv-1-i;j++) {
				if(lnczs.geteigenvalue(j) >lnczs.geteigenvalue(j+1) ) {
				
					double dum;
					dum=lnczs.geteigenvalue(j) ;
					lnczs.geteigenvalue(j) =lnczs.geteigenvalue(j+1);
					lnczs.geteigenvalue(j+1) = dum;
					
					double *ptr;
					ptr=lnczs.geteigenvector(j) ;
					lnczs.geteigenvector(j) =lnczs.geteigenvector(j+1);
					lnczs.geteigenvector(j+1) = ptr;
				}
			
			}
		}
       */	
	    int last=0;
	    for(int i=0; i<nv-1; i++) {
			if(fabs(lnczs.geteigenvalue(i+1)-lnczs.geteigenvalue(i)) >1.0e-5) last=i;
	    }
		if( fabs(1/lnczs.geteigenvalue(last)-1/lnczs.geteigenvalue(0)) <1.0e-4 ) {
			if(nv*4< matricione.dim) {
				nv+=5;
			   continue;
			 }
		}
		cout << " immagazzina \n";
		immagazzina(lnczs,shift,last+1,inversione, eVect, eVal  , matricione.dim  );
		cout << " immagazzina OK  \n";
			shift -= Max(fabs(1./lnczs.geteigenvalue(last)), fabs(1./lnczs.geteigenvalue(0))  )-1.0e-5;
	  if( -shift -eVal(0) >dene  || eVal.rows() >= matricione.dim) break;	
	}
};

double Risolutore::prodottoscalare(  uMatrix<double>& a , uMatrix<double>&    b    )
{
	if(b.rows()<matricione.dim  ||     a.rows()<matricione.dim    ) {
		cout << " problema  (b.size()<matricione.dim) in Risolutore::prodottoscalare\n";
		exit(0);
	}
	static uMatrix<double> p;
	p.resize(b.rows());
	
	p=0.0;
	matricione.Moltiplica(p.address(),  b.address()   );
    double res=scalare(p.address(), a.address(), matricione.dim) ;
	

  return res;
};


void Risolutore::salvasufile(char *nome)
{
	matricione.scrivi(nome);

}

void Risolutore::addizionadafile(char *nome, double f)
{
  matricione.somma(nome,f);
}

void Risolutore::inizializza(Sparsa3A & m)
{
  matricione.inizializza(m);
}





void asfhfs::calcolagliLLmedi()
{
  // **************************************
  // ** Si trova la dimensione del problema
  // **
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  

  matricione.azzera();
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	aggiungiLLamatricione(matricione,sottospazi[i],Acolumns  );
	Acolumns+=sottospazi[i].dim();
      }
  }

  LL.resize(eVect.columns());
  LLLL.resize(eVect.columns());
  srmqdLL.resize(eVect.columns());
  LLpar.resize(eVect.columns(),nstati);
  LLLL=0.0;
  srmqdLL=0.0;

  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
      //autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
    LL(i)=matricione.prodottoscalare(autostato, autostato);
    }
	cout << " OK 1 \n";
  matricione.azzera();
  
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {

	aggiungiLLLLamatricione(matricione,sottospazi[i],Acolumns  );
	
	Acolumns+=sottospazi[i].dim();
      }
  }
  	cout << " OK 2 \n";

  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex(0,1, eVect.rows()-1),uIndex(i),autostato);
      LLLL(i)=matricione.prodottoscalare(autostato, autostato);
    }
  	cout << " OK OK \n";

  for(int i=0; i<eVect.columns(); i++)
    {
      srmqdLL(i)=sqrt(LLLL(i)-LL(i)*LL(i));
    }
 
  for(int stato=0; stato< loforb.rows(); stato++)
    {  
      matricione.azzera();
      int Acolumns=0;
      for(int i=0; i<nsottospazi ;i++)
	{
	  COUCHE stato(noforb(stato),loforb(stato));
	  aggiungiLLamatricione(matricione,sottospazi[i],Acolumns, &stato );
	  Acolumns+=sottospazi[i].dim();
	}
      for(int i=0; i<eVect.columns(); i++)
	{
	  eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
	  // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
	  LLpar(i, stato)=matricione.prodottoscalare(autostato, autostato);
		cout << " OK 3 \n";

	}
    }
}


void asfhfs::calcolagliSLmedi()
{
  // **************************************
  // ** Si trova la dimensione del problema
  // **
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  

  matricione.azzera();

  SLpar.resize(eVect.columns(),nstati);
  SLpar=0.0;
  for(int stato=0; stato< nstati; stato++)
    {  
      matricione.azzera();
      int Acolumns=0;
      for(int i=0; i<nsottospazi;i++)
	{
	  COUCHE stato(noforb(stato),loforb(stato));
	  aggiungiSLamatricione(matricione,sottospazi[i],Acolumns, &stato );
	  Acolumns+=sottospazi[i].dim();
	}
      for(int i=0; i<eVect.columns(); i++)
	{
	  eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
	  // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
	  SLpar(i, stato)=0.5*matricione.prodottoscalare(autostato, autostato);
	}
    }
  

  SL.resize(eVect.columns());

  matricione.azzera();
  int Acolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      aggiungiSLamatricione(matricione,sottospazi[i],Acolumns, NULL );
      Acolumns+=sottospazi[i].dim();
    }
  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
      // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
      SL(i)=0.5*matricione.prodottoscalare(autostato, autostato);
    }
}


void asfhfs::calcolagliSzMzmedi()
{
  // **************************************
  // ** Si trova la dimensione del problema
  // **
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  

  matricione.azzera();
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	aggiungiSzamatricione(matricione,sottospazi[i],Acolumns  );
	Acolumns+=sottospazi[i].dim();
      }
  }
  
  szz.resize(eVect.columns(),nstati);
  
  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
      // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
      szz(i)=matricione.prodottoscalare(autostato, autostato);
    }

  matricione.azzera();
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	aggiungiMzamatricione(matricione,sottospazi[i],Acolumns  );
	Acolumns+=sottospazi[i].dim();
      }
  }
  
  mzz.resize(eVect.columns(),nstati);
  
  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
      // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
      mzz(i)=matricione.prodottoscalare(autostato, autostato);
    } 
}

void asfhfs::calcolagliSSmedi()
{
  // **************************************
  // ** Si trova la dimensione del problema
  // **
  int newcolumns=0;
  for(int i=0; i<nsottospazi;i++)
    {
      newcolumns+=sottospazi[i].dim();
    }
  
  // ************************************************
  // ** si da la giusta dimensione al matricione
  matricione.resize(newcolumns);
  matricione.azzera();
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {
	aggiungiSSamatricione(matricione,sottospazi[i],Acolumns  );
	Acolumns+=sottospazi[i].dim();
      }
  }

  SS.resize(eVect.columns());
  SSSS.resize(eVect.columns());
  srmqdSS.resize(eVect.columns());
  SSpar.resize(eVect.columns(),nstati);

  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
      // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
      SS(i)=matricione.prodottoscalare(autostato, autostato);
    }

  matricione.azzera();
  
  {  
    int Acolumns=0;
    for(int i=0; i<nsottospazi;i++)
      {

	aggiungiSSSSamatricione(matricione,sottospazi[i],Acolumns  );
	
	Acolumns+=sottospazi[i].dim();
      }
  }
  
  for(int i=0; i<eVect.columns(); i++)
    {
      eVect.extract(uIndex(0,1, eVect.rows()-1),uIndex(i),autostato);
      SSSS(i)=matricione.prodottoscalare(autostato, autostato);
    }
  
  for(int i=0; i<eVect.columns(); i++)
    {
      double d=SSSS(i)-SS(i)*SS(i);
      srmqdSS(i)=(d>0) ? sqrt(d):0;
    }
 
  for(int stato=0; stato< nstati; stato++)
    {  
      matricione.azzera();
      int Acolumns=0;
      for(int i=0; i<nsottospazi;i++)
	{
	  COUCHE stato(noforb(stato),loforb(stato));
	  aggiungiSSamatricione(matricione,sottospazi[i],Acolumns, &stato );
	  Acolumns+=sottospazi[i].dim();
	}
      for(int i=0; i<eVect.columns(); i++)
	{
	  eVect.extract(uIndex (0,1, eVect.rows()-1) ,uIndex(i), autostato);
	  // autostato=eVect(uIndex (0,1, eVect.rows()-1) ,uIndex(i));
	  SSpar(i, stato)=matricione.prodottoscalare(autostato, autostato);
	}
    }
}




  
void  aggiungiLLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale )
{
  int nel=(spazio.base_canonica+spazio.inizio)->getnel();

  DETERMINANTE *da, *db;

  TIPOFATTORE  elmat;

  static DETERMINANTE dres;
  
  
  BUFFERDET  buffer;
  
  nel=  spazio.base_canonica[0].getnel();
  buffer.atleast(PACKETBUFF,nel  ,1);
  
  double mz;
  //////////
 
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      buffer.inuse=0;
      operatoreLLpm(*da,buffer, 1.0, parziale,&spazio );
      mz= Mz(*da, parziale);
      for(int rbb=rba; rbb< spazio.fine; rbb++)
	{      
	  db= spazio.base_canonica+rbb;
	  
	  elmat=buffer.scalareordinato(*db);
	  
	  if(da==db) elmat+=mz*(mz-1);
	  
	  if(elmat!=0)
	    {
	      matricione.sommaH(Acolumns+rbb, Acolumns+rba, 
				elmat  );
	      if(rba!=rbb)
		{

		      matricione.sommaH( Acolumns+rba, Acolumns+rbb,
					 elmat );
		
		}		     
	    }
	}
    }
}



  
void  aggiungiSLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale )
{
  DETERMINANTE *da, *db;

  TIPOFATTORE  elmat;

  static DETERMINANTE dres;

  BUFFERDET  buffer;
  
  int nel=  spazio.base_canonica[0].getnel();
  buffer.atleast(PACKETBUFF,nel  ,1);
  
  double mz,sz;
  //////////
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      buffer.inuse=0;
      operatoreSLpm(*da,buffer, 1.0, parziale,&spazio );

      mz= Mz(*da, parziale);
      sz= Sz(*da, parziale);

      for(int rbb=rba; rbb< spazio.fine ; rbb++)
	{      
	  db= spazio.base_canonica+rbb;
	  
	  elmat =buffer.scalareordinato(*db);
	
	  if(da==db) elmat +=2*mz*sz*dotordinato(*da,*db);
	
	
		if(elmat!=0) {
			   matricione.sommaH( Acolumns+rba, Acolumns+rbb,elmat  );
				if(rba!=rbb) {
			  		 matricione.sommaH( Acolumns+rbb, Acolumns+rba,elmat  );
				}
		}	
	 }
	 }
}





void  aggiungiSSamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale )
{
  DETERMINANTE *da, *db;

  TIPOFATTORE  elmat;

  static DETERMINANTE dres;
  
  
  BUFFERDET  buffer;
  
  int nel=  spazio.base_canonica[0].getnel();
  buffer.atleast(PACKETBUFF,nel  ,1);
  
  double sz;
  //////////
 
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      buffer.inuse=0;
      
      operatoreSSpm(*da , buffer, 1.0, parziale, &spazio);

      sz= Sz(*da, parziale);

      for(int rbb=rba; rbb< spazio.fine; rbb++)
	{      

	  db= spazio.base_canonica+rbb;
	  
	  elmat=buffer.scalareordinato(*db);
	  
	  if(da==db) elmat+=sz*(sz-1);
	  
	  if(elmat!=0)
	    {
	      matricione.sommaH(Acolumns+rbb, Acolumns+rba, 
				elmat );
	      if(rba!=rbb)
		{
		  
		  matricione.sommaH( Acolumns+rba, Acolumns+rbb,
				     elmat );
		  
		}		     
	    }
	}
    }
}



void  aggiungiSzamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale )
{
  DETERMINANTE *da;

  double sz;
  
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      sz= Sz(*da,parziale);
      if(sz) {
	      matricione.sommaH(Acolumns+rba, Acolumns+rba,
				sz  );
		}	
    }
}


void  aggiungiMzamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale )
{
  DETERMINANTE *da;

  double mz;
  
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      mz= Mz(*da,parziale);

      matricione.sommaH(Acolumns+rba, Acolumns+rba,
			mz );	      
    }
}



void  aggiungiLLLLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns )
{
  DETERMINANTE *da, *db, *dt;

  TIPOFATTORE  elmat;

  static DETERMINANTE dres;
  
  
  BUFFERDET  buffer, buffer2;
  
  int nel=  spazio.base_canonica[0].getnel();
  buffer.atleast(PACKETBUFF,nel  ,1);
  buffer2.atleast(PACKETBUFF,nel  ,1);
  
  double mz;
  //////////
 
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      buffer.inuse=0;
      operatoreLLpm(*da,buffer,1, NULL, &spazio);

      mz= Mz(*da);

      buffer.aggiungi(*da,mz*(mz-1));

      buffer2.inuse=0;
      
      for(int i=0; i<buffer.inuse; i++)
	{
	  dt=&buffer(i);
	  operatoreLLpm(*dt,buffer2,   buffer.getcoef(i), NULL, &spazio );
	  mz= Mz(*dt);
      buffer2.aggiungi(*dt , mz*(mz-1)*  buffer.getcoef(i)   );
	

	}
      
      for(int rbb=rba; rbb< spazio.fine; rbb++)
	{      
	  db= spazio.base_canonica+rbb;
	  elmat=buffer2.scalareordinato(*db);
    	  if(elmat!=0)
	    {
	      // abbiamo finalmente l'elemento di matrice fra rba e rbb
	      // Ora si ragiona in termini di colonna
	      matricione.sommaH(Acolumns+rbb, Acolumns+rba, 
				elmat );
	      if(rba!=rbb)
		{
		  matricione.sommaH( Acolumns+rba, Acolumns+rbb,
				     elmat  );
		}		     
	    }
	}
    }
}




void  aggiungiSSSSamatricione(Risolutore &matricione,
			      SOTTOSPAZIO &spazio, int Acolumns )
{
  DETERMINANTE *da, *db, *dt;
  
  TIPOFATTORE  elmat;
  
  static DETERMINANTE dres;
  
  
  BUFFERDET  buffer, buffer2;
  
  int nel=  spazio.base_canonica[0].getnel();
  buffer.atleast(PACKETBUFF,nel  ,1);
  buffer2.atleast(PACKETBUFF,nel  ,1);
  
  double sz;
  //////////
  
  for(int rba=spazio.inizio; rba<spazio.fine; rba++)
    {
      da= spazio.base_canonica+rba;
      buffer.inuse=0;
      operatoreSSpm(*da,buffer, 1, NULL, &spazio );
      
      sz= Sz(*da );
      buffer.aggiungi(*da,sz*(sz-1) );

      
      buffer2.inuse=0;
      
      for(int i=0; i<buffer.inuse; i++)
	{
	  dt=&buffer(i);
	  operatoreSSpm(*dt,buffer2,   buffer.getcoef(i) ,  NULL, &spazio);
	  sz= Sz(*dt);
     buffer2.aggiungi(*dt,sz*(sz-1)*buffer.getcoef(i) );
	

	}
      
      
      for(int rbb=rba; rbb< spazio.fine; rbb++)
	{      
	  db= spazio.base_canonica+rbb;
	  
	  elmat=buffer2.scalareordinato(*db);
	  
    	  if(elmat!=0)
	    {
	      matricione.sommaH(Acolumns+rbb, Acolumns+rba, 
				elmat  );
	      if(rba!=rbb)
		{
		  matricione.sommaH( Acolumns+rba, Acolumns+rbb,
				     elmat  );
		}		     
	    }
	}
    }
}

void serialuMatrix(fichier &f, uMatrix<double> &a)
{
  int dimr,dimc;
  if(f.serial==SCRIVI)
    {
      dimr=a.rows();
      dimc=a.columns();
    }
  f.serialint(&dimr);
  f.serialint(&dimc);
  f.saltolinea();

  if(f.serial==LEGGI)  a .resize(dimr,dimc);
  for(int i=0; i<dimr;i++)  
    {
      for(int j=0; j<dimc; j++)
	{
	  f.serialdouble(& a(i,j) );
	}
      f.saltolinea();
    }
}


