/***************************************************************************
                          integrate.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#include<iostream.h>
#include"integrate.h"
void integrate(double *f, double *fint, double *x, int Nx )
{
  double sfin,sgro;
  
  if(Nx<3)
    {
      cout << " Errore: Nx<3 (Nx=" << Nx << " nella routine integrate \n";
      exit(0);
    }
  int i;
  sfin=0.0;
  sgro=0.0;
  fint[0]=0.0;
  for( i=2;i< (Nx) ;i+=2)
    {
      sgro=sgro+ (f[i-2]+ f[i])*(x[i]-x[i-2]);       

      sfin=sfin+(f[i-2] + f[i-1])*(x[i-1]-x[i-2]);
      sfin=sfin+(f[i-1]+f[i])*(x[i]-x[i-1]);

      fint[i]=(4*sfin-sgro)/6.;
    }  
  
  double d,h;
  double p,q,r;
  double fp,fq,fr;
  for( i=1;i< (Nx) ;i+=2)
    {
      if(i<Nx-1)
	{
	  d=x[i]-x[i-1];
	  h=x[i+1]-x[i];

	  p=d*(2*d+3*h)/6/(d+h);
	  q=d*(d+3*h)/6./h;
	  r=-d*d*d/6./h/(d+h);

	  fp=f[i-1];
	  fq=f[i];
	  fr=f[i+1];

	  fint[i]=fint[i-1]+p*fp+q*fq+r*fr;
	}
      else
	{
	  h=x[i-1]-x[i-2];
	  d=x[i]-x[i-1];
	  p=-d*d*d/6./h/(d+h);
	  q=d*(d+3*h)/6./h;
	  r=d*(2*d+3*h)/6/(d+h);

	  fp=f[i-2];
	  fq=f[i-1];
	  fr=f[i];

	  fint[i]=fint[i-1]+p*fp+q*fq+r*fr;
	}
    }
}


double  integrate(double *f,  double *x, int Nx )
{
  double sfin,sgro,sum;
  
  if(Nx<3)
    {
      cout << " Errore: Nx<3 (Nx=" << Nx << " nella routine integrate \n";
      exit(0);
    }
  int i;
  sfin=0.0;
  sgro=0.0;
  sum=0.0; 

  for( i=2;i< (Nx) ;i+=2)
    {
      sgro=sgro+ (f[i-2]+ f[i])*(x[i]-x[i-2]);

      sfin=sfin+(f[i-2] + f[i-1])*(x[i-1]-x[i-2]);
      sfin=sfin+(f[i-1]+f[i])*(x[i]-x[i-1]);

      sum=(4*sfin-sgro)/6.;
    }  
  double d,h;
  double p,q,r;
  double fp,fq,fr;
  {
     i=(Nx>>1)*2;

    if(i!=Nx)
      {
	h=x[i-1]-x[i-2];
	d=x[i]-x[i-1];
	p=-d*d*d/6./h/(d+h);
	q=d*(d+3*h)/6./h;
	r=d*(2*d+3*h)/6/(d+h);
	
	fp=f[i-2];
	fq=f[i-1];
	fr=f[i];
	
	sum=sum + p*fp+q*fq+r*fr;
      }
  }
  return sum;

}


