#ifndef _LINEAR_INTERPOLATION
#define _LINEAR_INTERPOLATION
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <complex.h>
#include "Linear_Interpolation.h"
#include <string.h>

long conta_linee(char *s);
char * successivo( char *c);

template<class Typex, class Typef>
class Linear_Interpolation
{
  long DIM;
public:
  Typex *x;
  Typef *f;

  
  inline Linear_Interpolation() { DIM=0;}  ;
  inline Linear_Interpolation(Linear_Interpolation const & data);
  inline ~Linear_Interpolation() 
        { 
	 if(DIM) 
	 { delete x; delete f;}
	};
   

  void   resize(long  n) ;
  inline long size() const { return DIM;};

  void read_file(char *nome, int ncol=2 , int xcol=1);         
  void read_file_unacol(char *nome, int ncol=1 );         
  void write_file(char *nome);         
  inline Typex  start() { return x[0];};
  inline Typex  end()  { return x[DIM-1];};
  void   dividi( Typef d); 
  void   dividi(  Linear_Interpolation & d);
  void   add( Typef d); 
  void   add(  Linear_Interpolation & d);
  void   sub( Typef d); 
  void   sub(  Linear_Interpolation & d);
  void   mul( Typef d); 
  void   mul(  Linear_Interpolation & d);
  void   shift( Typex  d); 
 

  Typef  operator()(Typex p) const ;
  
  void operator=(Linear_Interpolation<Typex,Typef> const &data) ;
  void operator=(Typef data) ;


  Typef derivata(Typex p)	const;


};

template<class Typex,class Typef>
void   Linear_Interpolation<Typex, Typef>::resize( long  n) 
   {                  
     if(DIM) { delete x; delete f;} ;
     DIM=n;
     x = new Typex [DIM];
     f = new Typef [DIM]; 
   } 



template<class Typex,class Typef>
void   Linear_Interpolation<Typex, Typef>::read_file( char *nome, int ncol, int xcol) 
   {    
     char linea[2000];               
     long  n=conta_linee(nome);
     
     resize(n);
     FILE *dumf=  fopen(nome,"r");
     if( !dumf)
	{ 
	  cout <<  "problemi di apertura file "  << endl ;
	  exit(0);
	}	
     fclose(dumf);
     int count=0;
     Typef dum;
    ifstream file(nome);
    while(!file.eof() && count < n )
     {

       int mass = ( xcol< ncol) ? ncol:xcol;
       for(int i=1 ;i<=mass  ;i++)
	 {
	   if(xcol<ncol && i<=xcol) file >> x[count];
	   if(xcol<ncol && i>xcol) file  >> f[count];
	   if(xcol>ncol && i<=ncol) file >> f[count];
	   if(xcol>ncol && i> ncol) file >> x[count];
	 }

       /*
       for(int i=1 ;i<xcol  ;i++) file >> dum ;
       file  >> x[count];
       for(int i=xcol+1 ;i<ncol ;i++)
	 {
	   file >> dum ;
	 }
       file >> f[count]; 
       */


       // si mangia quel che resta della linea
       file.getline(linea,2000);
       
       count++ ;
     }
}

template<class Typex,class Typef>
void   Linear_Interpolation<Typex, Typef>::read_file_unacol( char *nome, int ncol) 
   {    
     char linea[2000];               
     long  n=conta_linee(nome);
     
     resize(n);
     FILE *dumf=  fopen(nome,"r");
     if( !dumf)
	{ 
	  cout <<  "problemi di apertura file "  << endl ;
	  exit(0);
	}	
     fclose(dumf);
     int count=0;
     Typef dum;
    ifstream file(nome);
    while(!file.eof() && count < n )
     {
       x[count]=count;
       for(int i=1 ;i<ncol ;i++)
	 {
	   file >> dum ;
	 }
       file >> f[count]; 

       // si mangia quel che resta della linea
       file.getline(linea,2000);
       
       count++ ;
     }
}


template<class Typex ,class Typef>
void   Linear_Interpolation<Typex, Typef>::write_file( char *nome) 
   {                  
     ofstream  file(nome);
     for(int i=0; i<DIM; i++)
       {
	 file << x[i] << "  " << f[i] << endl;
       }
}


     

template<class Typex ,class Typef>   
void   Linear_Interpolation<Typex, Typef>::dividi( Typef d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]/=d;
    }
} 
template<class Typex ,class Typef>   
void   Linear_Interpolation<Typex, Typef>::dividi
(  Linear_Interpolation<Typex, Typef> & d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]/=d(x[i]);
    }
} 
template<class Typex,class Typef>   
void   Linear_Interpolation<Typex, Typef>::add( Typef d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]+=d;
    }
} 
template<class Typex , class Typef>   
void   Linear_Interpolation<Typex, Typef>::add
(  Linear_Interpolation<Typex, Typef> & d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]+=d(x[i]);
    }
} 
template<class Typex ,class Typef>   
void   Linear_Interpolation<Typex, Typef>::sub( Typef d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]-=d;
    }
} 
template<class Typex ,class Typef>   
void   Linear_Interpolation<Typex, Typef>::sub
(  Linear_Interpolation<Typex, Typef> & d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]-=d(x[i]);
    }
} 

template<class Typex,class Typef>   
void   Linear_Interpolation<Typex, Typef>::mul( Typef d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]*=d;
    }
} 

template<class Typex,class Typef>   
void   Linear_Interpolation<Typex, Typef>::shift( Typex  d)
{
  for(int i=0; i<DIM; i++)
    {
      x[i]+=d;
    }
} 

template<class Typex,class Typef>   
void   Linear_Interpolation<Typex, Typef>::mul
(  Linear_Interpolation<Typex, Typef> & d)
{
  for(int i=0; i<DIM; i++)
    {
      f[i]*=d(x[i]);
    }
} 




template<class Typex,class Typef>
Typef Linear_Interpolation<Typex, Typef>::operator()(Typex p)	const
{
  int ascnd;
  long ju,jm,jl;


  jl=-1;
  ju=DIM;
  ascnd=(x[DIM-1] > x[0]);
  if( (p>x[DIM-1] && p>x[0]) ||  (p<x[DIM-1] && p<x[0]) )
    {
      return 0;
    }

  if( p==x[0]) return f[0];
  if( p==x[DIM-1]) return f[DIM-1];

  while (ju-jl > 1) 
  {
		jm=(ju+jl) >> 1;
		if (p > x[jm] == ascnd) jl=jm;
		else  ju=jm;
  }
  return  (   f[jl]*(x[ju]-p) + f[ju]*(p-x[jl]) ) / ( x[ju]-x[jl] ) ;
}


template<class Typex,class Typef>
Typef Linear_Interpolation<Typex, Typef>::derivata(Typex p)	const
{
  int ascnd;
  long ju,jm,jl;


  jl=-1;
  ju=DIM;
  ascnd=(x[DIM-1] > x[0]);
  if( (p>x[DIM-1] && p>x[0]) ||  (p<x[DIM-1] && p<x[0]) )
    {
      return 0;
    }

  if( p==x[0]) return f[0];
  if( p==x[DIM-1]) return f[DIM-1];

  while (ju-jl > 1) 
  {
		jm=(ju+jl) >> 1;
		if (p > x[jm] == ascnd) jl=jm;
		else  ju=jm;
  }
  return  (   - f[jl] +  f[ju] ) / ( x[ju]-x[jl] ) ;
}


template<class Typex,class Typef>
Linear_Interpolation<Typex, Typef>::Linear_Interpolation
( Linear_Interpolation<Typex, Typef> const & data )
{

  DIM = data.DIM;
  x = new Typex [DIM];
  f = new Typef [DIM];
  memcpy(x,data.x, DIM*sizeof( Typex   ) );
  memcpy(f,data.f, DIM*sizeof( Typef   ) );
}


template<class Typex,class Typef>
void Linear_Interpolation<Typex, Typef>::operator=(Linear_Interpolation<Typex,Typef> const &data)
{
  if (DIM)
    {
      delete x;
      delete f;
    }  
  DIM = data.DIM;
  x = new Typex [DIM];
  f = new Typef [DIM];
  
  memcpy(x,data.x, DIM*sizeof( Typex   ) );
  memcpy(f,data.f, DIM*sizeof( Typef   ) );

};

template<class Typex,class Typef>
void Linear_Interpolation<Typex, Typef>::operator=( Typef data)
{
 if (DIM)
    {
	for(int i=0; i<DIM; i++)
	{
		f[i]=data;
	}	
    }  
 
};
float maxf(Linear_Interpolation<float,float> &a);
double maxf(Linear_Interpolation<double, double> &a) ;
float minf(Linear_Interpolation<float, float> &a) ;
 double minf(Linear_Interpolation<double, double> &a);

/*
template <class Type, class Typef>
Typef  maxf( const Linear_Interpolation<Type,Typef > &a )
{
	Typef  max = a.f[0];
	int n=a.size();
	for(int i=0; i<n;i++)
	{
		if(max<a.f[i]) max=a.f[i];
	}	
	return max;
};

template <class Type, class Typef>
Typef minf( const Linear_Interpolation<Type,Typef> &a)
{
	Typef  min = a.f[0];
	int n=a.size();
	for(int i=0; i<n;i++)
	{
		if(min>a.f[i]) min=a.f[i];
	}	
	return min;
};
   */
#endif 











