/***************************************************************************
                          asfhfs.h  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#define TIPOFATTORE double
// #define TIPOFATTORE complex<double>

int **i_matrice(int n,int m);


  /** La struttura COUCHE, che ha un uso molto limitato, serve
       a passare in argomento n ed l d'un solo colpo ad una
       funzione e semplificare la scrittura del programma */
class COUCHE {
public:
  COUCHE( int nn, int ll) { n=nn;  l=ll; };
  int n,l;
};

/**
 Questa classe rappresnta un livello n,l,mz,sz. Ogni numero quantico
 e' rappresentato dan un byte. Il numero sz e' rappresentato
 da 1 per 0.5 e -1 per -0.5 (logicamente perche un byte
 assume valori interi).

 Svariate funzioni membro o amiche permettono di confrontare
 livelli fra di loro.
*/
class LIVELLO {
public:
  char n; 
  char l;
  char mz;
  char sz;
  /** questo operatore controlla l'uguaglianza fra a e b.
      Il confronto sei esegue per comparazione di zone di memoria
      usando la funzione memcmp.
  */
  friend inline int operator == ( LIVELLO &a, LIVELLO &b);
  /** questo operatore controlla  se  a e maggiore di  b.
      Il confronto sei esegue per comparazione di zone di memoria
      usando la funzione memcmp.
  */
  friend inline int operator  > ( LIVELLO &a, LIVELLO &b);
  /**
   <pre>
     return ( a.l == b.l && a.mz == b.mz &&  a.sz==b.sz  );
    </pre>
  */
  friend inline int stessaparteangolare(LIVELLO &a, LIVELLO &b);

  /**
   <pre>
				return mz >= -l && mz <= l;
   </pre>
  */
  inline int Lis_physical() {return mz>=-l && mz<=l; };
  /**
   <pre>
				return sz==-1 || sz==1;
   </pre>
  */
  inline int Sis_physical() {return sz==-1 || sz==1; };

	/** stampa allo schermo  i numeri quantici
	*/
  inline void  stampa() { printf("n=%d;l=%d;mz=%d;sz=%d\n",n,l,mz,sz); };

  /** Crea livello inizializzandolo con dei numeri quantici non fisici
  */
  inline LIVELLO() {n=-1,l=-1;mz=0;sz=0; };

  /** Crea livello inizializzandolo con i numeri quantici dati in input
  */
  inline LIVELLO(int na, int la, int ma, int sa) {n=na,l=la;mz=ma;sa=0; };


  /** La struttura COUCHE, che ha un uso molto limitato, serve
       a passare in argomento n ed l d'un solo colpo ad una
       funzione e semplificare la scrittura del programma */
  inline COUCHE couche() {return COUCHE(n,l);};

  inline void creatorLIVELLO() {};
  /** serializza sul file f
  */
  void serializza(fichier &f);
};


inline int operator ==(LIVELLO &a, LIVELLO &b)
{
  return ( memcmp(&a,&b, sizeof(LIVELLO))==0);
};



inline int operator > (LIVELLO &a, LIVELLO &b)
{
  int res;
  res=(memcmp(&a,&b, sizeof(LIVELLO))>0);
  return (res );
};

inline int stessaparteangolare(LIVELLO &a, LIVELLO &b)
{
   return ( a.l == b.l && a.mz == b.mz &&  a.sz==b.sz  );
};


/**
  Questa classe e' un'array di livelli.
  Per motivi di rapidita i livelli sono ordinati. La classe
  contiene l'intero segno che serve a tenere traccia della
  permutazione necessaria a portare l'array di livelli in forma
  ordinata.
*/
class DETERMINANTE  {
public:
  DETERMINANTE();
  void creatoreDETERMINANTE() ;
  /** crea un determinante con n elettroni  */
  DETERMINANTE(int n);
  ~DETERMINANTE();
	/** adatta la dimensione dell'array di livelli a n elettroni  */
  void resize(int n);
  /** copia il determinante a */
  void copia(DETERMINANTE &a);

  /** controlla che il livello iesimo non sia presente due volte nell'array */
  int  not_doubly_occuped(int i);
  /** stampa allo schermo la pappardella*/
  void stampa();
  /** ritorna il numero di elettroni */
  inline int getnel() { return nel ; }
  /** ritorna il livello n */
  inline LIVELLO & getlevel(int n) { return livello[n]; }

	
	/** Sempre il prodotto scalare, ma si suppongono che i livelli
	    siano ordinati. Questo accelera di molto la funzione
	*/
  friend double  dotordinato (DETERMINANTE &a , DETERMINANTE &b);
  /**
	   riordina i livelli in modo crescente
  */
  void riordinalivelli();
	

  /**Da 1 se e' possibile passare dal determinante a a quello b con un'interazione
     a due corpi che coinvolge  i gusci ca1, ca2 in a, e cb1 e cb2 in b.
     Altrimenti zero.

     Si suppone che un riordino in a e b sia stato precedentemente fatto.
  */
  friend  int possibileduecorpiordinati(DETERMINANTE &a , DETERMINANTE &b,
				      COUCHE &ca1, COUCHE &ca2, COUCHE &cb1, COUCHE &cb2  );
				
  /** da il numero dei livelli di a che non si trovano in b
    che s uguale a quello dei livelli  di b che non si trovano in a.
	  Le posizioni dei livelli spaiati sono memorizzate negli array ia e ib.
	
     Si suppone che un riordino in a e b sia stato precedentemente fatto.
   */				
  friend int spaiatiordinati(class DETERMINANTE &a, class DETERMINANTE &b, int *ia, int *ib);

	/** torna il numero di livelli spaiati  questa funzione e prevista per
	    il caso multiconfigurazionale in cui a e b possono avere un numero diverso
	    di elettroni
	*/
  friend int  spaiatiordinatimulti(class DETERMINANTE &a, class DETERMINANTE &b, int *, int *, int &nspa, int &nspb,
				  int maxnspa, int maxnspb);
	/**
	   Da 1 se e' possibile passare dal determinante a a quello b con un'interazione
     a un  corpi che coinvolge  i gusci ca  in a, e cb   in b.
     Altrimenti zero
	
     Si suppone che un riordino in a e b sia stato precedentemente fatto.
  */
  friend int possibileuncorpoordinati(class DETERMINANTE &a, class DETERMINANTE &b, class COUCHE &ca, class COUCHE &cb);

  /**
		copia il determinante a
	*/
  inline void operator =(DETERMINANTE &a) {copia(a);};

  /**  da il massimo n e il massimo l dei livelli presenti nel determinante  */
  void get_max_nl(int &n,int &l);
  
	/** Si crea una tavola con lo scopo di risalire alla posizione
	    di un livello cercato nel determinante, conoscendo i numeri quantici
	    n,l,mz,sz.
	
	    Gli argomenti N ed L servono a dimensionare la tavola. Devono essere
	    ottenuti con get_max_nl(int &n,int &l).
			Questa funzione crea unicamente la tavola
	    */
  void creatavola(int N,int L);

  	/** La  tavola serve a risalire alla posizione
	    di un livello cercato nel determinante, conoscendo i numeri quantici
	    n,l,mz,sz.
	
			Questa funzione inizializza la tavola con le buone posizioni la tavola
	    */
  void preparatavola();

  /**
		libera la memoria riservata per la tavola.
  */
  void distruggitavola();
  /**
    ottiene la posizione dello stato avente numeri
    quantici n,l,mz,sz
  */
  inline int gettavola(int n,int l,int mz,int sz)
  {
    return tavola[n][l][mz][sz];
  };

  /**
    ottiene la posizione del livello niv.
    La struttura LIVELLO non e' altro che
    i quattro numeri quantici

    @see LIVELLO
  */

  inline int gettavola(LIVELLO &niv) { 
    return  gettavola(niv.n, niv.l, niv.mz, niv.sz);
  };

  /** serializza il determinante  */
  void serializza(fichier &f);

  /** ottiene il segno associato al determinante  */
  int getsegno() { return segno;};
  void  setsegno(int s) {  segno=s;};

private:
 int nel;
 LIVELLO * livello;
 int **** tavola;
 int segno;
public:
 double preSz;
 double preMz;

};

#define BUFFERDETRESIZEERASE  1
#define BUFFERDETRESIZECOPY   2
/**
   Qesta classe serve a registrare il risultato dell'applicazione di un operatore
   Su un determinante.
	 Il risultato di un operatore su di un determinante e' in generale
	 una combinazione lineare di determinanti.
	
	 Per questo scopo BUFFERDET e' composto da un'array di determinant e di
	 un'array di coefficienti
*/

class BUFFERDET {
public:
  BUFFERDET();
  ~BUFFERDET();
  /** esegue un controllo sulla memoria allocata. Se
      le memoria e' insufficiente:

       - in caso  resize==BUFFERDETRESIZEERASE (che e 1)
         la si distrugge e
         se ne crea al suo posto una quantita sufficiente per nd determinanti
          aventi ne elettroni.

			- in caso  resize==BUFFERDETRESIZECOPY (che e 1)
         se ne crea al suo posto una quantita sufficiente per ne determinanti
          aventi ne elettroni. Prima di distruggere la vecchia la si ricopia
          sulla nuova

      - altrimenti si emette un messaggio di errore e si blocca il programma

          */
  void atleast(int nd, int ne, int resize=1);

  /**  libera tutta la memoria */
  void libera();

  /**  ritorna la referenza al determinante iesimo */
  DETERMINANTE & operator () (int i) ;

  /**  ritorna la referenza al coefficiente del determinante iesimo */
  TIPOFATTORE  & getcoef(int i);



  /**  effettua la somma dei prodotti scalari di a con ognuno
       dei determinanti del buffer moltiplicati per i coefficienti rispettivi.

       Si suppone che a sia ordinato per andare piu veloci
       */
  double scalareordinato(DETERMINANTE &a);

  void aggiungi(DETERMINANTE &s, double fattore);

  /** questo numero dice quanti determinanti compongono il buffer
      Questo numero deve eseere per foza minore del numero massimo
      permesso dalla memoria allocata.*/
  int inuse;
private:
  /** numero massimo dei determinanti che possono essere memorizzati
      Questo numero viene settato da atleast che alloca anche la memoria
      corrispondente*/
  int n_det;
  /** numero di elettroni presenti in ciascuno dei determinanti.
      Questo numero viene settato da  @ref atleast
  */
  int nel;
  /** array di determinanti */
  DETERMINANTE *determinanti;
  /** array di coefficienti */
  TIPOFATTORE *coefficienti;
};

inline int operator !=( COUCHE a,  COUCHE b)
{
  int res=(a.n!=b.n || a.l!=b.l);
  return res;
}

class SOTTOSPAZIO;


void operatoreLLpm(DETERMINANTE &a, BUFFERDET &buffer,double fatdet=1.0,COUCHE *parziale=NULL,SOTTOSPAZIO *Sp=NULL);
void operatoreSSpm(DETERMINANTE &a, BUFFERDET &buffer,double fatdet=1.0,COUCHE *parziale=NULL,SOTTOSPAZIO *Sp=NULL);
void operatoreSLpm(DETERMINANTE &a, BUFFERDET &buffer,double fatdet=1.0,COUCHE *parziale=NULL,SOTTOSPAZIO *Sp=NULL);
double Mz(DETERMINANTE &a, COUCHE *parziale=NULL);
double Sz(DETERMINANTE &a, COUCHE *parziale=NULL);
double  dot(DETERMINANTE &a , DETERMINANTE &b);



#define NONCREARE 0
#define CREA      1
#include<Sparsa/Sparsa.h>

class Risolutore {
public:
  void resize(int n);
  void azzera();
  void sommaH(int  i,int j, double add);
  void diagonalizzaH ( double Dene, uMatrix<double>& eVect, uMatrix<double>& eVal ) ;
  double prodottoscalare(  uMatrix<double>& a , uMatrix<double>&    b    );
  inline void stampa(){ 
    matricione.scrivi();
   }
  void salvasufile(char *nome);
  void addizionadafile(char *nome, double f);
 inline void somma(Risolutore & a, double f=1) { matricione.somma(a.matricione,f); }
 void inizializza(Sparsa3A & m);
private:
  Sparsa3A   matricione;
};


class LIMITATIONS {
 public:
  double jz;
  double minSz,maxSz;
  void serializza(fichier &f);
};


class gaussian ;
/**
  l'atomo asferico in tutto il suo splendore.
*/
class asfhfs
{
 public:
  /**
      in lettura si legge un file  di questo tipo
      <pre>
----------------------------------------
1  { numero di strutture nl }

6  { numero di stati }

  { numeri quantici nl }
1 0
2 0
2 1
3 0
3 1
4 3

   { occupazioni }

 2 2 6  2 6  6

99  { spin totale ( Jz ) lungo Z}

2  3  { MinSz MaxSz }

nessunaopzione
------------------------------------------
      </pre>

      Il primo numero e' il numero di configurazioni. Per ora ho sempre
      usato 1, ma tutto il programma e' concepito per poter funzionare
      con delle multiconfigurazioni..........e con dei multicasini...

      Quindi il numero di gusci

      Per ogni guscio i numeri n e l.

      Per ogni guscio le occupazioni

      Il momento totale Jz lungo z. Se questo numero
      e' piu grande o uguale a 99 nessuna restrizione sullo spin e' fatta

      MinSz e MaxSz sono delle restrizioni sulla componente Sz

      L'ultima stringa serve a passare delle opzioni.
      Piu' opzioni possono essere specificate allo stesso tempo.
      Il tutto deve formare un'unica stringa. Un'opzione
      e' attivata quando la parola chive corrispondente e'
      presente in una qualsiasi posizione all'interno della stringa.

      Les parole chiave  possibili sono  scaricamatricione e  nientemomenti.

      La loro azione sara specificata altrove.


      La funzione legge soltanto le specificazioni. Non inizializza l'atomo.

  */
  void lettura(char * nome);
  /**
		 conta quanti determinanti ci sono in accordo con le specificazioni
		 lette dalla procedura lettura
  */
  int  conta_determinanti();
  /**
		 Crea tutti i  determinanti che sono in accordo con le specificazioni
		 lette dalla procedura lettura.
		
		 Questa funzione crea dunque la base canonica
  */
  void crea_determinanti();

  /**
     crea i sottospazi. Nel caso monoconfigurazionale
     questa funzione creera solo un unico sottospazio
     avente per base la base canonica.

     Nel caso multiconfigurazionale creera tanti
     sottospazi quanti sono le configurazioni.
     La base di un dato sottospazio sara quella
     porzione della base canonica che realizza la configurazione
     a cui corrisponde il sottospazio dato
  */
  void inizializza_sottospazi();

  /**
    Questa funzione inizializza la parte radiale:

      - funzioni d'onda

      - integrali di slater, spin orbita...

      - in generale tutto quel che riguarda la classe Atomo_sferico

    La carica del nucleo, il numero di punti della griglia,
    r0 (il raggio minimo del magliaggio) e rinf (il raggio
    massimo del magliaggio) vengono letti nel file
    di nome  nomefiledettaglihfs
  */
  void inizializza_hfs(char * nomefiledettaglihfs);

  /**
     legge da un file i parametri del campo cristallino.
			Questo file e nel formato:
			<pre>
1          { numero di gusci su cui applicare la riduzione }
5  0.8     { per ognuno dei gusci da ridurre,si da  il numero del guscio
						( che e' il numero di apparizione nelle specificazioni del
						  primo file di input) e il fattore per cui si moltiplicano
						  gli integrali di Slater agenti fra due elettroni di cui almeno uno
						  giace sul guscio in questione.
						  (il primo guscio e' il guscio numero 0)
					 }


1            { numero di coppie di guscio  gusci su cui applicare la riduzione }
5 5 0.875      { per ogni coppia  da ridurre,si da  i numeri  dei due gusci
						   (che e' il numero di apparizione nelle specificazioni del
						   primo file di input) e il fattore per cui si moltiplicano
						   gli integrali di Slater agenti fra due elettroni che giacciono uno su un guscio
						   e uno sull'altro dei due gusci specificati.
						
						   In questo caso si e' voluto remoltiplicare  per 0.875 gli integrali
						   fra due elettroni del guscio 5 che insieme al fattore 0.8  specificato qui sopra
						   da una riduzione totale di 0.7 per gli integrali agenti fra due elettroni
						   dello stesso guscio numero 5
					   }

2           { numero di gusci a cui si applica un campo di scambio       }
2 0.01       { il numero del guscio seguito dall'energia dell'interazione un unita atomiche
              per uno spin  di un elettrone +1/2 nella direzione z si aggiunge 0.01 UA
              per uno spine di un elettrone -1/2 nella direzione z si toglie   0.01 UA
              }

5 0.1        { Secondo guscio a cui applicare il campo di scambio }


5            { Se non si vuole applicare il campo cristallino mettere -1
               Se no il numero del guscio su cui si applica il campo cristallino.
               In questo caso il guscio numero 5.
               Se si specifica un guscio si fa seguir una matrice (2*l+1)x(2*l+1)
               dove l e' il momento angolare del guscio.
               Nell'esempio si tratta di un guscio d.
                }

0.05            0               0               0               0.05
0               0.0             0               0               0
0               0               .1              0               0
0               0               0               0.0             0
0.05            0               0               0               0.05


			</pre>

  */

  void inizializza_Cristallo(char *nomefilecristallo);

  /**
     prepara il matricione che descrive l'hamiltoniana
  */
  void preparamatricione();

  void uniscisottospazi();
  void calcolaoccmixed(uMatrix<double> &occmixed);
  int  onediff(int  i,int  j ,int & na,int & la,int&  nb,int&  lb);
  int  duediff(int  sa,int  sb ,int & nas,int & las,  int & nat,int & lat,
	       int&  nbu,int&  lbu,   int&  nbv,int&  lbv    );

	
  void inizializzaautostato();

  /**
     diagonalizza il matricione
  */
  void diagonalizzaH (double dene ) ;
  
  void calcolagliLLmedi();
  void calcolagliSSmedi();
  void calcolagliSLmedi();
  void calcolagliSzMzmedi();
  
  void serializza(fichier &f);
  
  void scaricamatricione(char * nome) { matricione.salvasufile(nome); };
  void resizematricione(int n) { matricione.resize(n);};
  void azzeramatricione();
  void addizionaamatricione(char * nome, double f) { matricione.addizionadafile(nome,f); };
 

  friend void 	  calcoladisturbidiagonali(  asfhfs  &atomiA,   gaussian *   orbitaliA,  int attivoA,  double  posx,double  posy,double  posz, 
					     asfhfs  &atomiB,   gaussian *   orbitaliB,  int attivoB, FILE * diago    );

  // private:
 public:
  
  int nstrut;   //  il numero di strutture nl
  int nstati;   // numero  di stati nl
  int * N, *L,*deg; //  i numeri quantici N e L
  int **occ;   // le occupazioni per ogni struttura e stato  occ=i_matrice(nstrut,nstati);
  int nel;     // numero totale di elettroni
  LIMITATIONS defjz;
  int *fine_struttura; // gli intervalli di ogni struttura
  // nell'array di determinanti
  int n_det; // il numero di determinanti
  DETERMINANTE *collezione;
  int nsottospazi;
  SOTTOSPAZIO  *sottospazi;

  Atomo_sferico hfs;
  uMatrix<int> num_orbitale; // tavola che permette di reperire l'orbitale
                            // conoscendo n e l

  uMatrix<double> occsottospazio; // per ogni sottospazio il numero 
                                  // di elettroni in ogni orbitale
  uMatrix<int> loforb,noforb; // i numeri quantici n e l, per ogni orbitale


  Risolutore matricione;
#define MAXPARZIALI 20
	Risolutore matparziali[MAXPARZIALI];
	char *mappaparziali[MAXPARZIALI];
#define mappaH0  0
#define mappaCrist  1
	uMatrix<int>  mappaHsz;
	uMatrix<int>  mappaHrids;
	uMatrix<int>  mappaHridd;
	int parzialiattivi;
	
	asfhfs(){ mappaparziali[mappaH0]= "H0base"    ;
 					mappaparziali[mappaCrist]= "HCrist"    ;
					parzialiattivi=mappaCrist+1;
					noforb.resize(0);
					loforb.resize(0);};


  uMatrix<double> autostato;

  uMatrix<double> eVal,eVect;

  uMatrix<double> LL, LLLL, srmqdLL,LLpar;
  uMatrix<double> SS, SSSS, srmqdSS, SSpar;
  uMatrix<double> JJ, JJJJ, srmqdJJ, JJpar;
  uMatrix<double> SL, SLpar;
  uMatrix<double> mzz,szz;

  uMatrix<double> RidS;
  uMatrix<double> RidD;

  uMatrix<double> uz;
  int statoC;
  uMatrix<double> cristallo; 
  
};




#define MAXEIG 5
  /**
		un sottospazio e' rappresentato da una base di vettori ortogonali.
		Ogni vettore e' una combinazione di determinanti.
		Questi determinanti appartengono ad una base canonica,
		dove ogni vettore della base e' un determinante, e la base canonica
		e' di dimensione superiore o uguale alla dimensione della base.
		
		Tutti i determinanti appartengono ad una monoconfigurazione
		(hanno gli stessi numeri di occupazione per i gusci n,l).

		
		Il sottospazio piu semplice e' quello dove la base e' un sottoinsieme
		della base canonica.
		Attraverso alcune funzioni membro si possono in seguito calcolare
		gli operatori JJ,SS, o LL e diagonalizzare la base, ottenendo
		una scomposizione in autospazi di uno o piu di questi operatori.
		
		La classe sottospazio ha come membro un puntatore ad un array
		di sottospazi che come default e nullo ma in caso di diagonalizzazione
		puntera ai sottospazi in cui si scompone il sottospazio

  */

class SOTTOSPAZIO {
public:
  SOTTOSPAZIO();
  void creatoreSOTTOSPAZIO() ;
  ~SOTTOSPAZIO();

	/** inizializza il puntatore base canonica con collezione ( i due
	    punteranno quindi alla stessa zona di memoria).  La base
	    e' definita come il sottoinsieme della base canonica
	    che va da collezione[start] a collezione[start+dim-1]
	*/
  void inizializza(DETERMINANTE *collezione,int start,
		   int end);



	/**
		un'oggetto di tipo sottospazio ha  il membro
		operatore che e' una matrice che puo' essere
		inizializzata e, in seguito diagonalizzata
		per scomporre il sottospazio in sottospazi
		minori
		
		Questa matrice puo' rappresentare LL,JJ o SS.
		La funzione settaLL calcola l'azione di LL
		nel sottospazio e mette il risultato nella
		matrice operatore.
	*/
  void settaLL();
	/**  come settaLL ma per SS      */
  void settaSS();
	/**  come settaLL ma per JJ     */
  void settaJJ();


  
  void stampa();

  int dim() { return fine -inizio; }
  void operator=(SOTTOSPAZIO & a );
  
  /**
  la base canonica contiene tutti i determinanti
    su cui si lavora
  La base definisce il sottospazio. Ogni colonna della base
  definisce un vettore della base
  I coefficienti della riga n_ieme moltiplicano il
   determinante base_canonica[corrispondenza[n]]
   L'operatore ha dimensione dimXdim dove dim
  e il numero di righe della base

  questo e' un array condiviso : da non distru
  */
  DETERMINANTE *base_canonica;

  /** numero di determinanti componenti la base canonica */
  //  non serve int dim_can;


  /**
       Questa matrice serve a calcolare i differenti operatori
  */
  Sparsa3A operatore;

  /**
    nel caso il sottospazio sia stato scomposto in sottospazi,
    questa funzione ritorna il sottospazio n della scomposizione.
  */
  SOTTOSPAZIO & getsottospazio(int n);
  /**
			ritorna il numero di sottospazi della scomposizione.
  */
  inline int get_n_sottospazi() { return n_sottospazi;};


  /**
    Abbiamo detto che un sottospazio e' monoconfigurazionale.
		
    Questa funzione dice quanti elettroni ci sono nel guscio n,l
  */
  int qnl(int n, int l);


  friend class asfhfs;
  void stampaautovalori();
  void serializza(fichier &f);
  int inizio;
  int fine;

private:

  int n_sottospazi;
  SOTTOSPAZIO *sottospazi;
};


#ifdef KDOC
class FUNZIONI_VARIE {
#endif
/** pippo */
void  aggiungiLLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns , COUCHE *parziale=NULL);
			
void  aggiungiLLLLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns );


void  aggiungiSSamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns , COUCHE *parziale=NULL);
void  aggiungiSzamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns , COUCHE *parziale=NULL);
void  aggiungiMzamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns , COUCHE *parziale=NULL);
void  aggiungiSSSSamatricione(Risolutore &matricione,
			      SOTTOSPAZIO &spazio, int Acolumns );


void  aggiungiSLamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazio, int Acolumns, COUCHE  *parziale );
			
			
void  aggiungiKineamatricione(Risolutore &matricione,
			      SOTTOSPAZIO &spazioA,
			      SOTTOSPAZIO &spazioB,
			      double J, int orbia, int orbib,
			      int Acolumns,  int Bcolumns  , uMatrix<int> &noforb,
			      uMatrix<int> &loforb);

void quatrelevelsaggiungiFGamatricione(Risolutore &matricione,Risolutore *matpar,
				       SOTTOSPAZIO &spazioA,
				       SOTTOSPAZIO &spazioB,
				       double * G,
				       int na1,int la1, // a1 va in b1
				       int nb1,int lb1,
				       int na2,int la2,     // a2 va in b2
				       int  nb2, int lb2,
				       int offseta,
				       int offsetb);


void  aggiungiSOamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazioA,
			    SOTTOSPAZIO &spazioB,
			    double SO, int na, int la, int nb, int lb ,
			    int Acolumns,  int Bcolumns  );

void  aggiungiSpinZamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazioA,
			    double uz, int na, int la,
			    int Acolumns  );

void  aggiungiCristalloamatricione(Risolutore &matricione,
			    SOTTOSPAZIO &spazioA,
			    SOTTOSPAZIO &spazioB,
			    uMatrix<double> cristallo, int na, int la, int nb, int lb ,
			    int Acolumns,  int Bcolumns  );

double preMz(DETERMINANTE &a);


double preJz(DETERMINANTE &a);




#ifdef KDOC
};
#endif
