/***************************************************************************
                          schrofree.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <iostream.h>
#include <complex.h>

#ifndef PI
#define PI M_PI
#endif


void  schrofreeWKB(double E,double *r, double *V, double *y,double * y_amp,
		   double *y_phase,
		  double &aJ, double &aY,  int &wkb_start,
		  int N,double  l, int normalize )
{
  
  //************************************************
  //**  questo shift e necessario se i vettori
  //**  nel programma chiamante partono da 0
  //**  (in schro i vettori partono da 1)
  r--;
  V--;
  y--;
  y_amp--;
  y_phase--;
  //**
  //************************************************
  
  
  
  int j;
  
  
  
  
  double h[N+1],R,dh,dl,dh2,dl2,dp;
  double Gh,Gl,G0;
  double ca,cb,ep,em,y1,y2;
  
  for(int i=1;i<=N;i++) h[i]=r[i+1]-r[i];
  
  // ** comme default wkb_start est a l'exterieur de l'intervalle
  wkb_start= 2*N;
  
  //------------ Propagation de  1 a Inf  ----------------------
  
  for(int i=1;i<=2;i++)
    {
      y[i] = exp((l+1)*log(r[i]));
    }
  
  for(int i=2;i<N;i++)
    {
      dh = r[i+1]-r[i];
      dl = r[i  ]-r[i-1];
      G0 = 2*(V[i]  -E);
      if(fabs(G0*dh*dl)<1.0/4.)
	{
	  dh2= dh*dh;
	  dl2=dl*dl;
	  dp = dh*dl;
	  R  = dh2 + dl2 + dp ;
	  Gh = 2*(V[i+1]-E);
	  Gl = 2*(V[i-1]-E);
	  
	  y[i+1] = y[i]+( y[i]*(dh+(dl*Gh*(R-2*dl2)+G0*(dh+dl)*(R+2*dh*dl))/12)
			  -y[i-1]*dh*(1.-Gl*(R-2*dh2)/12.)
			  )/
	    (dl*(1.-Gh*(R-2*dl2)/12.));
	}
      else
	{
	  if(G0<0.0 && i>4   && i < N-1 )  // on a besoin d'un peut de marge
	    {
	      // printf( " choix du WKB\n");
	      wkb_start = i-2 ; // le point i n'est pas encore calculee
	      break;           // on a besoin de deux points au moins
	    }
	  else
	    {
	      ep = exp(dl*sqrt(G0));
	      em = 1./ep;
	      y2=y[i];
	      y1=y[i-1];
	      dl=r[i]-r[i-1];
	      dh=r[i+1]-r[i];
	      cb=em*(y2-y1*ep)/(em-ep);
	      ca=ep*(y1*em-y2)/(em-ep);
	      ep = exp(dh*sqrt(G0));
	      em = 1./ep;
	      y[i+1]=ca*ep+cb*em;
	    }
	}
      if(fabs(y[i+1])>1e8) 
	{
	  double fact= 1./fabs(y[i+1]) ;
	  int count =0;
	  for(j=i+1;j>=1;j--) 
            {
	      if(y[j]==0) count++;
	      else count =0;
	      if(count > 2) break;
	      y[j]=y[j]*fact; 
	    }
	}
      
    }
  
  // On controle que il n'y ai pas des merdes
  
  for(int i=wkb_start;i<=N;i++) 
    {
      if(V[i]>E)
	{
	  cout << " Stop dans schro free, le choix de wkb doit etre"
	    " plus malin \n";
	  exit(0);
	}
    }
  
  if ( wkb_start < N)
    {
      //*****************************************************************
      // On termine la fonction libre avec une forme WKB au 3eme ordre
      //*****************************************************************
      
      double  Q[N+1];
      for(int i=wkb_start-1; i<=N; i++)
	{
	  Q[i]= -2.*(E-V[i]); // Q est negatif (onde)
	}
      
      double S0[N+1],S1[N+1],S2[N+1],S3[N+1] ;
      {
	double RR,Qp,Qpp,dl,dh,dl2,dh2;
	for(int i=wkb_start;i<=N-1;i++)
	  {
	    dl=r[i]-r[i-1];
	    dh=r[i+1]-r[i];
	    dl2=dl*dl;
	    dh2=dh*dh;
	    RR=dh*dl*(dh+dl);
	    
	    // derivees premiere et deuxieme
	    Qp  = ( (dh2-dl2)*Q[i] -dh2*Q[i-1]+dl2*Q[i+1])/RR;
	    Qpp =2.*(dh*Q[i-1]+dl*Q[i+1]-(dh+dl)*Q[i])/RR;
	    
	    S3[i]=-Qpp /16./Q[i]/Q[i] + 5./64.*Qp*Qp/Q[i]/Q[i]/Q[i];
	    S1[i]=-0.25*log(-Q[i]);  // Q est negatif
	  }
	// en N on assume que les derivees ne varient pas beaucoup
	S3[N]=-Qpp /16./Q[N]/Q[N] + 5./64.*Qp*Qp/Q[N]/Q[N]/Q[N];
	S1[N]=-0.25*log(-Q[N]); // Q est negatif
	
	S0[wkb_start]=S2[wkb_start]=0.;
	
	for(int i=wkb_start+1; i<=N;i++)
	  {
	    S0[i]=S0[i-1]+0.5*(sqrt(-Q[i])+sqrt(-Q[i-1]))*(r[i]-r[i-1]);
	    S2[i]=S2[i-1]-(sqrt(-Q[i])*S3[i]+sqrt(-Q[i-1])*S3[i-1])
	      *(r[i]-r[i-1]);
	  }
	
	// *******************************************************************
	// **   determinazione della fase e dell'ampiezza  iniziali
	double ph0, amp0;
	int segno;
	{
	  double c;
	  c= exp( S1[wkb_start+1]+S3[wkb_start+1] -
		  S1[wkb_start  ]-S3[wkb_start  ] );
	  double y1,y2;
	  y1=y[wkb_start];
	  y2=y[wkb_start+1];
	  double cd,sd;
	  cd=cos( S0[wkb_start+1]+S2[wkb_start+1]);
	  sd=sin( S0[wkb_start+1]+S2[wkb_start+1]);
	  
	  double racin;
	  racin = c*c*y1*y1 + y2*y2 - 2*c*y1*y2*cd ;
	  if(racin <= 0 )
	    {
	      cout << " Problema con racin = " << racin << "STOP \n";
	      exit(0);
	    }
	  racin=sqrt(racin);
	  ph0= asin(c *y1* sd /racin );
	  if(sd==0)
	    {
	      cout << " Problema con sd = " << sd << "STOP \n";
	      exit(0);
	    }
	  amp0 =  racin/sd/c;
	  if((y2-y1)<0)
	    {
	      segno=-1;
	    }
	  else
	    {
	      segno=1;
	    }
	}
	
	
	{
	  for(int i=wkb_start;i<=N;i++)
	    {
	      y_phase[i] = ph0 + segno*(S0[i]+S2[i]);
	      y_amp  [i] = amp0 * exp( S1[i]+S3[i] -
				       S1[wkb_start  ]-S3[wkb_start  ] );
	    }
	  // cout << "wkb_startwkb_start " << wkb_start << endl ;
	}
      }
      
      //******
      // raccord
      //***
      double norm;
      {
	void bessjy(double x,double xnu,double *ri,double *rk,double *rip,
		    double *rkp);
	double dery,yy, xx;
	// ****************************************************************
	// ** Ici on a besoin de y de sa derive dans un point de raccord xx
	// ** La methode est different selon que on soit dans WKB ou dehors
	if(wkb_start<N) 
	  {
	    double derq;
	    derq = sqrt( 2*(E-V[N]))*(1 -S3[N]*2  );
	    dery = -y_amp[N]*cos(y_phase[N]) *derq   +(y_amp[N]-y_amp[N-1])*
	      sin(y_phase[N])/(r[N]-r[N-1]) ;
	    yy=y_amp[N]*sin(y_phase[N]);
	    xx= r[N];
	  }
	else
	  {
	    yy=0.5*(y[N]+y[N-1]);
	    dery= (y[N]-y[N-1])/(r[N] - r[N-1]);
	    xx = 0.5*(r[N] + r[N-1]);
	  }
	
	double qinf=sqrt( 2*(E-V[N]  +0.5*l*(l+1)/r[N]/r[N]));
	
	
	double FJ,FY,GJ,GY;
	bessjy( xx * qinf , l+0.5 , &FJ,&FY,&GJ,&GY ); 
	
	
	GJ *= qinf ;
	GY *= qinf ;
	
	double x  =  xx ;
	double sx = sqrt(x);
	
	GJ  = GJ*sx + 0.5*FJ/sx;
	GY  = GY*sx + 0.5*FY/sx;
	
	FJ *=    sx;
	FY *=    sx;
	double det= -GJ*FY +GY*FJ;
	aJ  = ( GY*yy  -FY*dery)/det;
	aY  = (-GJ*yy +FJ*dery)/det;
      }
      //******************
      // renormalisation
      //*****************
      // double ymax=0.;
      //for(int i=1;i<=N;i++) if(y[i]>ymax) ymax=y[i];
      if(normalize)
	{
	  norm=1./sqrt(2.0*(aJ*aJ+aY*aY)/PI);
	  norm *= sqrt(2/PI);
	  aJ *=norm;
	  aY *=norm; 
	  for(int i=1; i<=N;i++) y[i]     *= norm ;
	  for(int i=1; i<=N;i++) y_amp[i] *= norm ;
	}
  }
  // ******************************************************
  // Preparation a sortir de la routine : 
  // ici les array partent de 1, mais le default c'est 0, toijours
  wkb_start--;
}






   
   

   
