/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/* @(#) $Source: GetCCDFrame.h V2.5 by P. Daly, P. Boesecke Jul 1997    $ */
/**************************************************************************/
/* GetCCDFrame.h                                                          */
/**************************************************************************/

#ifndef _GETDLDFRAME_ROUTINES 
#define _GETDLDFRAME_ROUTINES

#define HScalerLen 32 
#define HScalerNameLen 10

  extern int 
     ReadCCDData (FILE *stream, int FrameNumber, void **Start),
     ReadCCDDataV1 (FILE *stream, int FrameNumber, void **Start),
     GetMaxCCDNumber (FILE *stream, int *Maximum),
     ReadCCDType (FILE *stream, int *X, int *Y, int *DataLength,
                   int * OffsetX, int * OffsetY),
     ReadCCDScalars (FILE *stream, char **HmDldVersion, 
         float Scalars[HScalerLen],
         char *ScalarName[HScalerLen],
         float ScalarZero[HScalerLen],
         float Scalaralib[HScalerLen],
         float *ScalarDepth,
         int *ScalarI0, int *ScalarI1,
         int *ScalarAnode, int *ScalarTime,
         int *ScalarI0S, int *ScalarI1S,
         int *ScalarAnodeS, int *ScalarTimeS,
         float *HmDeltaTime, 
         char HmStartTime[],
         int FrameNumber),
     ReadCCDInfo(FILE * stream, 
         char * DetectorType[], 
         char * MachineInfo[],
         char * OpticsInfo[],
         char * StationInfo[],
         char * ProposalInfo[]),
     ReadCCDExperiment(FILE * stream,
         char * Title[], char * ExperimentInfo[],
         float * enter_1, float * Center_2, int * ICenter,
         float * PixSize_1, float * PixSize_2, int * IPixSize,
         float * WaveLength, int * IWaveLength,
         float * SampleDistance, int * ISampleDistance,
	 float * DetectorPosition, int * IDetectorPosition,
         float * DataValueOffset, int * IDataValueOffset,
         float * Dummy, int * IDummy);

#endif /* _GETDLDFRAME_ROUTINES */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

