
/****************************************************************************
*  Include                                                                  *
****************************************************************************/
# include <errno.h>
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>
  
# include "raster.h" 

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<N> \"<rasterorientation string>\""

main (int argc, char *argv[])
{ static const char * Main_Error="ERROR: rasori";
  int errval=0;
  long value=-1l;
  const char *ps, *string;
  long N;
  long *order=NULL;
  long det;
  long *inv_order=NULL;
  long inv_det;
  int i;
  long *buffer;
  long *inv_buffer;
  char *order_string=NULL;
  char *inv_order_string=NULL;
  long raster_number;
  long inv_raster_number;

  double *mat=NULL;
  double *inv_mat=NULL;
  double *mul_mat=NULL;

  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) N = strtol(argv[1], NULL, 0l);

  if (argc>2) string = argv[2];

  printf("     N = %ld\n", N);
  printf("string = >%s<\n", string);
  printf("strlen(%s) = %ld\n",string,strlen(string));

  if ( !(buffer = (long*) malloc( sizeof( long ) * (N+1) )) ) {
    errval=-1;
    return(errval);
  }

  if ( !(inv_buffer = (long*) malloc( sizeof( long ) * (N+1) )) ) {
    errval=-1;
    return(errval);
  }

  ps=string;
  order = raster_str2order( buffer, N+1, N, ps, &ps, &errval);

  printf("\n");
  printf("errval    = %d\n",errval);
  if (order)
    for (i=0;i<=N;i++) printf("order[%d] = %ld\n",i,order[i]);

  printf("rest string = >>%s<<\n",ps);

  switch (errval) {
    case 0: // OK
            break;
    case 1: fprintf(stderr,"%s %s\n",Main_Error,
                    "memory allocation error (output array)");
            break;
    case 2:  fprintf(stderr,"%s %s\n",Main_Error,
                    "memory allocation error (internal)");
            break;
    case 3: fprintf(stderr,"%s %s\n",Main_Error,
                   "explicit duplication");
            break;
    case 4: fprintf(stderr,"%s %s\n",Main_Error,
                    "outside range");
            break;
    case 5: fprintf(stderr,"%s %s\n",Main_Error,
                    "implicit duplication");
            break;
    case 6: fprintf(stderr,"%s %s\n",Main_Error,
                    "not enough parameters");
            break;
    case 7: fprintf(stderr,"%s %s\n",Main_Error,
                    "conversion OK, but too many parameters");
            break;
    case 8: fprintf(stderr,"%s %s\n",Main_Error,
                    "conversion from raster number failed");
            break;
    case 9: fprintf(stderr,"%s %s\n",Main_Error,
                    "buffer size too small (nelem<n+1)");
            break;
  } // switch

  if (order) {
    order_string=raster_order2str( NULL, 0, order, &errval );

    raster_number = raster_order2number ( order );

    det = raster_order_determinante ( order );

    printf("raster_number=%ld, order_string=>>%s<<, det=%ld\n",
      raster_number, order_string, det);

    inv_order = raster_order_inversion ( inv_buffer, N+1, order );

    inv_order_string=raster_order2str( NULL, 0, inv_order, &errval );

    inv_raster_number = raster_order2number ( inv_order );

    inv_det = raster_order_determinante ( inv_order );

    printf("inv_raster_number=%ld, inv_order_string=>>%s<<, inv_det=%ld\n",
      inv_raster_number, inv_order_string, inv_det);

    mat = raster_order2matrix ( NULL, 0, order );

    raster_fprint_matrix( stdout, N, N, mat, "matrix" );

    inv_mat = raster_order2matrix ( NULL, 0, inv_order );

    raster_fprint_matrix( stdout, N, N, inv_mat, "inv_matrix" );

    mul_mat = raster_matrix_product ( NULL, 0, inv_mat, mat, N, N, N );

    raster_fprint_matrix( stdout, N, N, mul_mat, "inv_matrix*matrix" );

  }

  if (order_string) free( order_string );
  if (inv_order_string) free( inv_order_string );

  free( buffer );
  free( inv_buffer );

  if (mat) free(mat);
  if (inv_mat) free(inv_mat);
  if (mul_mat) free(mul_mat);

  return( errval );

} /* main */
