/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    table.h

SYNOPSIS

    #include "table.h"

DESCRIPTION

    Header of the module "table.c"

***********************************************************************---*/
#ifndef _TABLE_
# define _TABLE_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

# define TABLE_MAXLEN 127  /* maximum length of a delimiter (without final 0)*/

typedef struct table_XYData {
  const char * XLabel, * YLabel; // label of X and Y data
  double * X, * Y;               // X and Y data pairs
  long len;                      // actual number of data pairs
  long buflen;                   // allocated size of X- and Y-buffer
  long index;                    // last used index
} TableXYData;

/*===========================================================================*/

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern TableXYData
     * table_newXYData( long buflen );

PUBLIC extern int
       table_freeXYData( TableXYData * xydata );

PUBLIC extern int
       table_freeXYDataAll( void );

PUBLIC extern void
       table_Init( double empty,   const char * comment, 
                   const char * limline, const char * limcol );

PUBLIC extern int
       table_ReadXYDouble( TableXYData * xydata, const char * filename,
                           long skiplines, long skipchars, int swap,
                           long posx, long posy, long maxcnt );

PUBLIC extern void 
       table_printXYData( FILE * out, TableXYData * xydata );
 
PUBLIC extern double
       table_LinIntXYDouble( TableXYData * xydata, double s );

PUBLIC extern void
       table_LinIntXYReset( TableXYData * xydata );

#endif
