/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    refract.h

SYNOPSIS

    #include "refract.h"

DESCRIPTION
    Header of the module "refract.c"
***********************************************************************---*/
#ifndef _REFRACT_
# define _REFRACT_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

typedef struct refract_dir {
  int    status;
  double sinTwoTheta;
  double cosTwoTheta;
  double sinAlpha;
  double cosAlpha;
  } RefractDir;

/*===========================================================================*/

/***************************************************************************
* Functions                                                                *
***************************************************************************/
PUBLIC extern int 
       refract_Init ( FILE * out, double Delta, double Psi, double Chi );

PUBLIC extern RefractDir 
       refract_Angles ( RefractDir Beamp );

PUBLIC extern void
       refract_PrintBeam ( FILE * out, RefractDir Beamp ),
       refract_PrintParams ( FILE * out );

#endif
