/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++
1 SaxsSeparation.inc

2 DESCRIPTION
  Private include file of "SaxsInput.c"
  Separation of Prefix, Name and Suffix.
  See PUBLIC functions.

2 CALL
  The function output is a pointer to the substring s2 in s1.
  s1 and s2 have undetermined lengths and are terminated with a string end
  mark '\0'. sout has the lenght len.

  char * RightFR ( char * s1, char * s2, char * sout, int len )
  Searches from the end of s1 for the first appearance of the substring s2
  and copies the part to the right of the substring to sout.
  sout has the length len. If s2 is not found the whole string s1 is copied.

  char * LeftFR ( char * s1, char * s2, char * sout, int len )
  Searches from the end of s1 for the first appearance of the substring s2
  and copies the part to the left of the substring to sout.
  sout has the length len. If s2 is not found sout is empty.

  char * RightFL ( char * s1, char * s2, char * sout, int len )
  Searches from the left in s1 for the first appearance of the substring s2
  and copies the part to the right of the substring to sout.
  sout has the length len. If s2 is not found sout is empty.

  char * LeftFL ( char * s1, char * s2, char * sout, int len )
  Searches from the left in s1 for the first appearance of the substring s2
  and copies the part to the left of the substring to sout.
  sout has the length len. If s2 is not found the whole string s1 is copied.

2 HISTORY
  29-Dec-1994 PB creation
  10-Jan-1995 PB installed on RED
  12-Jan-1995 PB warning suppressed by explicit type transformations
  21-Sep-1995 PB SCopyLine : if (s1) added for check of NULL
  11-Oct-1996 PB included as include file into SaxsInput.c
                 SCopyLine replaced by CopyLine
---*/

#ifndef PRIVATE
#  define PRIVATE static
#endif

#ifndef PUBLIC
#  define PUBLIC
#endif

/***************************************************************************
* RightFR :
***************************************************************************/
PUBLIC char * RightFR ( char * s1, char * s2, char * sout, int len )
{
        char * p1;
        char * p2;
        char * p3;
        int  s2len;
        s2len = strlen(s2);
        p3 = (char *) NULL;
        p1 = s1;
        /* look for the last appearance of s2 in s1 */
        if (s2len>0)
          while ( (p2=(char *) strstr(p1,s2)) != (char *) NULL ) {
                p1=p2+s2len;
                p3=p2;
                }
        CopyLine(p1,sout,len,0);
        return(p3);
} /* RightFR */

/***************************************************************************
* LeftFR :
***************************************************************************/
PUBLIC char * LeftFR ( char * s1, char * s2, char * sout, int len )
{
        char * p1;
        char * p2;
        char * p3;
        int    s2len;
        int    soutlen;
        s2len = strlen(s2);
        p3 = (char *) NULL;
        p1 = s1;
        /* look for the last appearance of s2 in s1 */
        if (s2len>0)
                while ( (p2=(char *) strstr(p1,s2)) != (char *) NULL ) {
                        p1=p2+s2len; p3=p2;
                        }
        soutlen = 0;
        if (p3!=(char *) NULL) {
                soutlen = 1 + (int) (p3-s1);
                if (soutlen>len) soutlen=len;
                }
        CopyLine(s1,sout,soutlen,0);
        return(p3);
} /* LeftFR */

/***************************************************************************
* RightFL :
***************************************************************************/
PUBLIC char * RightFL ( char * s1, char * s2, char * sout, int len )
{
        char * p1;
        char * p2;
        char * p3;
        int  s2len;
        s2len = strlen(s2);
        p3 = (char *) NULL;
        p1 = (char *) NULL;
        /* look for the first appearance of s2 in s1 */
        if (s2len>0)
                if ( (p2=(char *) strstr(s1,s2)) != (char *) NULL ) {
                        p1=p2+s2len;
                        p3=p2;
                        }
        CopyLine(p1,sout,len,0);
        return(p3);
} /* RightFL */

/***************************************************************************
* LeftFL :
***************************************************************************/
PUBLIC char * LeftFL ( char * s1, char * s2, char * sout, int len )
{
        char * p2;
        char * p3;
        int    s2len;
        int    soutlen;
        s2len = strlen(s2);
        p3 = (char *) NULL;
        /* look for the first appearance of s2 in s1 */
        if (s2len>0)
                if ( (p2=(char *) strstr(s1,s2)) != (char *) NULL )
                        { p3=p2; }
        soutlen = len;
        if (p3!=(char *) NULL) {
                soutlen = 1 + (int) (p3-s1);
                if (soutlen>len) soutlen=len;
                }
        CopyLine(s1,sout,soutlen,0);
        return(p3);
} /* LeftFL */

/****************************************************************************/

