/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/* @(#) $Source: SaxsInput.h V4.31 by Peter Boesecke 2001-09-14  $        */
/**************************************************************************/
/* SaxsInput.h                                                            */
/**************************************************************************/

#ifndef _SAXS_INPUT
# define _SAXS_INPUT

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>
# include "edfio.h"

# include "SaxsExpression.h"

/***************************************************************************
* Special Definitions                                                      *
***************************************************************************/

# ifndef CommentChar
#   define CommentChar '#'
# endif

# define WildCard               "="
# define SkipToken              "..."
# define InputLineLength        EdfMaxLinLen+1 

# define DevSeparator ":"
# define DirSeparator "/"
# define ExtSeparator "."

 enum EditFlag {
  Collapse  = (0x1 << 0), /* remove all blanks from the line. NOTE: if this
                              value is omitted multiple blanks are replaced
                              by single spaces */
  Trim      = (0x1 << 1), /* strip leading and trailing blanks from line */
  UpperCase = (0x1 << 2), /* \ convert the line to the given case. */
  LowerCase = (0x1 << 3), /* / These options are mutually exclusive. */
  UnComment = (0x1 << 4)  /* strip comments (uses global value CommentChar
                              to specify the comment character). Comments
                              begin with the said CommentChar and last until
                              the end of the line */
  }; /* enum */


/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern char
    *SaxsInputVersion( void );
   extern int
    GetLong (FILE *Fptr,long int *Value,int Flag,char *Prompt,long int DefVal),
    GetInteger (FILE *Fptr, int *Value, int Flag, char *Prompt, int DefVal),
    GetReal (FILE *Fptr, float *Value, int Flag, char *Prompt, float DefVal),
    GetDouble (FILE *Fptr, double *Value, int Flag, \
                                      char *Prompt, double DefVal),
    GetString (FILE *Fptr, char **Value, int Flag, char *Prompt, char *DefVal),
    GetLine (FILE *Fptr  , char  Value[InputLineLength], int Flag, \
	     char *Prompt, char * DefVal);
   extern void
    CopyLine( const char * s1, char * sout, int len , int conversion ),
    EditLine (int EditFlag, char *str);
  /* --- separation.inc */
   extern char
    *RightFR  ( char * s1, char * s2, char * sout, int len ),
    *LeftFR   ( char * s1, char * s2, char * sout, int len ),
    *RightFL  ( char * s1, char * s2, char * sout, int len ),
    *LeftFL   ( char * s1, char * s2, char * sout, int len );

#endif /* _SAXS_INPUT */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

