/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    SaxsExpression.h

SYNOPSIS

    #include "SaxsExpression.h"

DESCRIPTION
    Header of the module "SaxsExpression.c"
***********************************************************************---*/
#ifndef _SAXSEXPRESSION_
# define _SAXSEXPRESSION_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type 
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type 
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "SaxsError.h"
# include "SaxsInput.h"
# include "gamma.h"

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern long longexpr( const char * s, int * pstatus);

PUBLIC extern float floatexpr( const char * s, int * pstatus);

PUBLIC extern double doubleexpr( const char * s, int * pstatus);

PUBLIC extern int errval2status( int errval );

#endif
