# include "strlib.h"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<string> <sep>"

main (int argc, char *argv[])
{
  int errval, level=1;
  char *lasts,*lasts1;
  char *string="",*string1=NULL, *string2=NULL, *string3=NULL;
  char *sep="", *sep1=NULL, *sep2=NULL, *sep3=NULL;
  char *value, *value1, *value2, *value3;

  int cnt=0,cnt1=0,cnt2=0,cnt3=0;

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) string = argv[1];
  if (argc>2) sep = argv[2];

  printf("string = >%s<\n", string);
  printf("strlen(%s) = %d\n",string,strlen(string));
  printf("sep = >%s<\n", sep);
  printf("strlen(%s) = %d\n",sep,strlen(sep));

  string1 = strlib_newstr( string );
  sep1 = strlib_newstr( sep );

  string2 = strlib_newstr( string );
  sep2 = strlib_newstr( sep );

  string3 = strlib_newstr( string );
  sep3 = strlib_newstr( sep );

  printf("================ strlib_tok_r =================\n");
  cnt=0;
  value = strlib_tok_r( string, sep, &lasts );
  while ( value ) {
    printf("token %d = >>%s<<\n",cnt,value);
    value = strlib_tok_r( NULL, sep, &lasts );
    cnt++;
  }

  printf("================ strtok_r =================\n");
  cnt1=0;
  value1 = strtok_r( string1, sep1, &lasts1 );
  while ( value1 ) {
    printf("token %d = >>%s<<\n",cnt1,value1);
    value1 = strlib_tok_r( NULL, sep1, &lasts1 );
    cnt1++;
  }

  if (string1) free(string1);
  if (sep1) free(sep1);

  printf("================ strlib_tok =================\n");
  cnt2=0;
  value2 = strlib_tok( string2, sep2 );
  while ( value2 ) {
    printf("token %d = >>%s<<\n",cnt2,value2);
    value2 = strlib_tok( NULL, sep2 );
    cnt2++;
  }
  if (string2) free(string2);
  if (sep2) free(sep2);

  printf("================ strtok =================\n");
  cnt3=0;
  value3 = strtok( string3, sep3 );
  while ( value3 ) {
    printf("token %d = >>%s<<\n",cnt3,value3);
    value3 = strtok( NULL, sep3 );
    cnt3++;
  }
  if (string3) free(string3);
  if (sep3) free(sep3);

  printf("===========================================\n");
  printf("finished\n");

} /* main */



