
/****************************************************************************
*  Include                                                                  *
****************************************************************************/
# include <errno.h>
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>
  
# include "raster.h" 
# include "rot3d.h" 
# include "numio.h" 

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "\"<rasterorientation string>\" [<rot_1> <rot_2> <rot_3>]"

main (int argc, char *argv[])
{ static const char * Main_Error="ERROR: rasori";
  int errval=0;
  long value=-1l;
  const char *ps, *string;
  long N=3;
  long *order=NULL;
  long det;
  long *inv_order=NULL;
  long inv_det;
  int i;
  long *buffer;
  long *inv_buffer;
  char *order_string=NULL;
  char *inv_order_string=NULL;
  long raster_number;
  long inv_raster_number;

  double *T=NULL;
  double *inv_T=NULL;
  double *mul_T=NULL;

  double Angle[3];
  double TAngle[3];
  double R[3][3];
  double RT[3][3];
  double TRT[3][3];

  double rot_1=0.0l, rot_2=0.0l, rot_3=0.0l;

  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) string = argv[1];

  if (argc>2) Angle[0]=num_str2double ( argv[2], NULL, &errval );
  if (errval) return( errval );
  if (argc>3) Angle[1]=num_str2double ( argv[3], NULL, &errval );
  if (errval) return( errval );
  if (argc>4) Angle[2]=num_str2double ( argv[4], NULL, &errval );
  if (errval) return( errval );

  printf("order = >%s<\n", string);
  printf("Angle[0] = %lg_deg (%lg)\n", Angle[0]*180.0/NUM_PI, Angle[0]);
  printf("Angle[1] = %lg_deg (%lg)\n", Angle[1]*180.0/NUM_PI, Angle[1]);
  printf("Angle[2] = %lg_deg (%lg)\n", Angle[2]*180.0/NUM_PI, Angle[2]);

  if ( !(buffer = (long*) malloc( sizeof( long ) * (N+1) )) ) {
    errval=-1;
    return(errval);
  }

  if ( !(inv_buffer = (long*) malloc( sizeof( long ) * (N+1) )) ) {
    errval=-1;
    return(errval);
  }

  ps=string;
  order = raster_str2order( buffer, N+1, N, ps, &ps, &errval);

//  printf("\n");
//  printf("errval    = %d\n",errval);
//  if (order)
//    for (i=0;i<=N;i++) printf("order[%d] = %ld\n",i,order[i]);
//  printf("rest string = >>%s<<\n",ps);

  switch (errval) {
    case 0: // OK
            break;
    case 1: fprintf(stderr,"%s %s\n",Main_Error,
                    "memory allocation error (output array)");
            break;
    case 2:  fprintf(stderr,"%s %s\n",Main_Error,
                    "memory allocation error (internal)");
            break;
    case 3: fprintf(stderr,"%s %s\n",Main_Error,
                   "explicit duplication");
            break;
    case 4: fprintf(stderr,"%s %s\n",Main_Error,
                    "outside range");
            break;
    case 5: fprintf(stderr,"%s %s\n",Main_Error,
                    "implicit duplication");
            break;
    case 6: fprintf(stderr,"%s %s\n",Main_Error,
                    "not enough parameters");
            break;
    case 7: fprintf(stderr,"%s %s\n",Main_Error,
                    "conversion OK, but too many parameters");
            break;
    case 8: fprintf(stderr,"%s %s\n",Main_Error,
                    "conversion from raster number failed");
            break;
    case 9: fprintf(stderr,"%s %s\n",Main_Error,
                    "buffer size too small (nelem<n+1)");
            break;
  } // switch

  if (order) {
    order_string=raster_order2str( NULL, 0, order, &errval );

    raster_number = raster_order2number ( order );

    det = raster_order_determinante ( order );

    printf("raster_number=%ld, order_string=>>%s<<, det=%ld\n",
      raster_number, order_string, det);

    inv_order = raster_order_inversion ( inv_buffer, N+1, order );

    inv_order_string=raster_order2str( NULL, 0, inv_order, &errval );

    inv_raster_number = raster_order2number ( inv_order );

    inv_det = raster_order_determinante ( inv_order );

    printf("inv_raster_number=%ld, inv_order_string=>>%s<<, inv_det=%ld\n",
      inv_raster_number, inv_order_string, inv_det);

    T = raster_order2matrix ( NULL, 0, order );

    raster_fprint_matrix( stdout, N, N, T, "T" );

    inv_T = raster_order2matrix ( NULL, 0, inv_order );

    raster_fprint_matrix( stdout, N, N, inv_T, "inv_T" );

    rot3d_matrix(Angle, R);

    raster_fprint_matrix( stdout, N, N, (double*) R, "rot3d_matrix" );


//  PUBLIC extern double * raster_matrix_product ( double * buffer, size_t nelem,
//                                                 double A[], double B[],
//                                                 int L, int M, int N );


    raster_matrix_product ( (double *) RT, N*N, (double *) R, T, N, N, N );

    raster_matrix_product ( (double *) TRT, N*N, inv_T, (double *) RT, N, N, N );

    raster_fprint_matrix( stdout, N, N, (double*) TRT, "TRT" );

    rot3d_angles(TAngle, TRT);

    printf("TAngle[0] = %lg_deg (%lg)\n", TAngle[0]*180.0/NUM_PI, TAngle[0]);
    printf("TAngle[1] = %lg_deg (%lg)\n", TAngle[1]*180.0/NUM_PI, TAngle[1]);
    printf("TAngle[2] = %lg_deg (%lg)\n", TAngle[2]*180.0/NUM_PI, TAngle[2]);


  }

  if (order_string) free( order_string );
  if (inv_order_string) free( inv_order_string );

  free( buffer );
  free( inv_buffer );

  if (T) free(T);
  if (inv_T) free(inv_T);
  if (mul_T) free(mul_T);

  return( errval );

} /* main */
