/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++
1 HELPEX.C

2 PURPOSE

2 HISTORY
  27-Dec-1995 PB
  30-Oct-2004 PB MAKE_FUNCTION
  12-Feb-2005 PB stderr
  23-Apr-2007 PB <string.h>

---*/

# include <stdlib.h>
# include <errno.h>
# include <stdio.h>
# include <unistd.h>
# include <string.h>

# define TRUE      1
# define FALSE     0
# define Usage     "helpex <file name>"
# define START     "/*+""++"
# define STOP      "--""-*/"
# define MAXCOL    78
# define MAXLINE   23
# define BUFLEN    1000
/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/

#if MAKE_FUNCTION
# define MAIN main_helpex
#else
# define MAIN main
#endif

int MAIN (int argc, char *argv[])
{ char buffer[BUFLEN];
  FILE * stream;
  char * s;
  int  show = FALSE;

  if (argc<=1) { printf("%s\n",Usage); return(-1); }

  if (!(stream = fopen(argv[1],"r"))) { 
    fprintf(stderr,"file not found\n");return(-1); 
  }

  while (s=fgets(buffer,BUFLEN,stream)) {
    if (s=(char *) strstr(buffer,START)) show=TRUE;
    if (show) printf("%s",buffer);
    if (s=(char *) strstr(buffer,STOP)) show=FALSE;
    }

  fclose(stream);

  return(0);

} /* MAIN */
