// VOLUME BROWSER - VUES ORTHOGONALES

// paquetages ImageJ
import ij.*;
import ij.gui.*;
import ij.process.*;
import ij.plugin.filter.PlugInFilter;
// version plugin:
//import ij.plugin.*;
import ij.io.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

//___________________________________________________________________________________________
// Le plugin implemente l'interface PlugInFilter
// il ne peut fonctionner que si une image est ouverte


public class Volume_Browser implements PlugInFilter {

	private ImagePlus myImp;
	public int setup(String arg, ImagePlus imp) {
		myImp=imp;
		return DOES_8G+STACK_REQUIRED;
	}
	
	public void run(ImageProcessor ip) {
		OrthoViews mesVues=new OrthoViews(myImp);
		ImageWindow win=myImp.getWindow();
	}
}

/*
// version plugin:
public class Volume_Browser3 implements PlugIn {
	public void run(String arg) {
		ImagePlus myImp=WindowManager.getCurrentImage();
		
		if (myImp==null) {
			IJ.noImage();
			return;
		}
		int stackSize=myImp.getStackSize();
		if (stackSize<2) {
			IJ.showMessage("Volume Browser","Stack required");
			return;
		}
		OrthoViews mesVues=new OrthoViews(myImp);
	}
}
*/
//___________________________________________________________________________________________

class OrthoViews {

	private ImagePlus impWo;		// image source
	private ImageCanvas wcanvas;	// canvas de l'image source

	private Xview vueX;				// vue orthogonale X
	private Yview vueY;				// vue orthogonale Y
	private Zview vueZ;				// vue orthogonale Z
	
	private Rectangle fenX;				// memorisation des coordonnees des vues (coin superieur droit)
	private Rectangle fenY;
	private Rectangle fenZ;

	private int xMouseClicked;		// memorisation du dernier point clique a la souris
	private int yMouseClicked;
	private int zMouseClicked;		// couche dans la laquelle le clic a ete effectue

	ToolBar barre;
	
	// CONSTRUCTEUR
	public OrthoViews(ImagePlus imp) {

		impWo=imp;					// recuperation de l'image source

		vueX=new Xview(impWo);		// creation des vues
		vueY=new Yview(impWo);
		vueZ=new Zview(impWo);
		
		fenX=new Rectangle();
		fenY=new Rectangle();
		fenZ=new Rectangle();
		
		xMouseClicked=0;			// definition du premier point clique par defaut...
		yMouseClicked=0;
		zMouseClicked=0;			// ...dans la premiere couche
		
		// recuperation du canvas de l'image source
		wcanvas=impWo.getWindow().getCanvas();
		
		// ajout d'un ecouteur CanvasMouseListener au canvas de l'image source
		CanvasMouseListener impWMouseListener=new CanvasMouseListener();
		wcanvas.addMouseListener(impWMouseListener);

		WinListener impWinListener=new WinListener();
		impWo.getWindow().addWindowListener(impWinListener);
		
		// creation d'une barre d'outil toolBar
		barre=new ToolBar();
		barre.setVisible(true);
	}

	//_______________________________________________
	// ecouteur de canvas de fenetre:
	// memorise les clics de souris (coordonnees et numero de couche)
	
	private class CanvasMouseListener extends MouseAdapter {
		public void mousePressed(MouseEvent e) {
			xMouseClicked=e.getX();
			yMouseClicked=e.getY();
			// lit la couche courante
			zMouseClicked=impWo.getCurrentSlice();
		}
	}	
		
	private class WinListener extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			barre.closeAllWindows();
			barre.dispose();
		}
	}
	
	//___________________________________________________________________________________________
	// barre d'outil implementant tous les boutons
	// la fermeture de la fenetre de la barre d'outil ferme toutes les vues

	public class ToolBar extends JFrame implements ActionListener {
	
		private JButton buttonSlice;		// Slices views (une seule couche par vue)
		private JButton buttonStack;		// Stacks views (le volume complet dans chaque vue)
		private JButton buttonCloseAll;		// Close all windows (ferme les trois fenetres de vues)

		private JButton buttonPrevX;
		private JButton buttonNextX;
		private JTextField txtNumSliceX;
		private JButton buttonGotoX;

		private JButton buttonPrevY;
		private JButton buttonNextY;
		private JTextField txtNumSliceY;
		private JButton buttonGotoY;
		
		private JButton buttonPrevZ;
		private JButton buttonNextZ;
		private JTextField txtNumSliceZ;
		private JButton buttonGotoZ;

		private ImageIcon icBar;

		File currentPath;					// chemin courant d'Image J		
		String absPath;						// chemin absolu des icones reconstruit

		// CONSTRUCTEUR
		public ToolBar() {
			try {
				currentPath=new File(".");
				absPath=currentPath.getCanonicalPath()+File.separator+"plugins"+File.separator+"icons"+File.separator;
				icBar=new ImageIcon(absPath+"logoesrf.gif");
			}
			catch(IOException e){IJ.error("Exception:\n"+e);}
			
			setIconImage(icBar.getImage());
			setTitle("Volume Browser");

			Rectangle rAppli=new Rectangle();
			rAppli=IJ.getInstance().getBounds();
			setBounds(rAppli.x+rAppli.width/2,rAppli.y+rAppli.height,295,160);
			setResizable(false);

			Container contenu=getContentPane();
			GridBagLayout g=new GridBagLayout();
			contenu.setLayout(g);
			GridBagConstraints c=new GridBagConstraints();
			// pas d'ajustement de taille des composants
			c.fill=c.NONE;
			c.gridheight=	1;		
			c.gridwidth=	4;
			c.weightx=		33;
			c.weighty=		25;
			
			// ecouteur de fermeture de la barre d'outil
			ToolBarListener ear=new ToolBarListener();
	 		addWindowListener(ear);

			// bouton d'affichage des vues (une couche par vue)		
			c.gridx=		0;
			c.gridy=		0;

			//buttonSlice=new JButton("Slices views");
			ImageIcon icSlice=new ImageIcon(absPath+"pieslicelarge.gif");
			buttonSlice=new JButton(icSlice);
			contenu.add(buttonSlice,c);
			buttonSlice.addActionListener(this);
			buttonSlice.setToolTipText("Slices views");
			//buttonSlice.setBorder(BorderFactory.createRaisedBevelBorder());
			
			// bouton d'affichage des vues (un volume complet par vue)
			c.gridx=		4;
			c.gridy=		0;
			//buttonStack=new JButton("Stacks views");
			ImageIcon icStack=new ImageIcon(absPath+"pielarge.gif");
			buttonStack=new JButton(icStack);
			contenu.add(buttonStack,c);
			buttonStack.addActionListener(this);
			buttonStack.setToolTipText("Stacks views");
			//buttonStack.setBorder(BorderFactory.createRaisedBevelBorder());
	
			// bouton de fermeture des vues
			c.gridx=		8;
			c.gridy=		0;
			//buttonCloseAll=new JButton("Close");
			ImageIcon icClose=new ImageIcon(absPath+"closeviews.gif");
			buttonCloseAll=new JButton(icClose);
			contenu.add(buttonCloseAll,c);
			buttonCloseAll.addActionListener(this);
			buttonCloseAll.setToolTipText("Close views");
			//buttonCloseAll.setBorder(BorderFactory.createRaisedBevelBorder());

			//______________________________________________

			c.gridwidth=	1;
			c.weightx=		25;
						
			// bouton de vueX precedente
			c.gridx=		1;
			c.gridy=		1;
			buttonPrevX=new JButton("<");
			contenu.add(buttonPrevX,c);
			buttonPrevX.addActionListener(this);
			buttonPrevX.setToolTipText("Previous X view");

			// bouton de vueX suivante
			c.gridx=		2;
			c.gridy=		1;
			buttonNextX=new JButton(">");
			contenu.add(buttonNextX,c);
			buttonNextX.addActionListener(this);
			buttonNextX.setToolTipText("Next X view");


			// Zone de texte de vueX numero
			c.gridwidth=	3;
			c.weightx=		25;
			
			c.gridx=		5;
			c.gridy=		1;
			txtNumSliceX=new JTextField(4);
			contenu.add(txtNumSliceX,c);
			txtNumSliceX.setToolTipText("Go to X view...");

			c.gridwidth=	1;
			c.weightx=		25;

			// bouton de validation de zone de texte de vueX numero
			c.gridx=		10;
			c.gridy=		1;
			buttonGotoX=new JButton("Go to X");
			contenu.add(buttonGotoX,c);
			buttonGotoX.addActionListener(this);
			buttonGotoX.setToolTipText("Go to X view...");

			//______________________________________________
						
			// bouton de vueY precedente
			c.gridx=		1;
			c.gridy=		2;
			buttonPrevY=new JButton("<");
			contenu.add(buttonPrevY,c);
			buttonPrevY.addActionListener(this);
			buttonPrevY.setToolTipText("Previous Y view");

			// bouton de vueY suivante
			c.gridx=		2;
			c.gridy=		2;
			buttonNextY=new JButton(">");
			contenu.add(buttonNextY,c);
			buttonNextY.addActionListener(this);
			buttonNextY.setToolTipText("Next Y view");
			
			// Zone de texte de vueY numero
			c.gridx=		7;
			c.gridy=		2;
			txtNumSliceY=new JTextField(4);
			contenu.add(txtNumSliceY,c);
			txtNumSliceY.setToolTipText("Go to Y view...");
			
			// bouton de validation de zone de texte de vueY numero
			c.gridx=		10;
			c.gridy=		2;
			buttonGotoY=new JButton("Go to Y");
			contenu.add(buttonGotoY,c);
			buttonGotoY.addActionListener(this);
			buttonGotoY.setToolTipText("Go to Y view...");
			
			//______________________________________________
						
			// bouton de vueZ precedente
			c.gridx=		1;
			c.gridy=		3;
			buttonPrevZ=new JButton("<");
			contenu.add(buttonPrevZ,c);
			buttonPrevZ.addActionListener(this);
			buttonPrevZ.setToolTipText("Previous Z view");

			// bouton de vueZ suivante
			c.gridx=		2;
			c.gridy=		3;
			buttonNextZ=new JButton(">");
			contenu.add(buttonNextZ,c);
			buttonNextZ.addActionListener(this);
			buttonNextZ.setToolTipText("Next Z view");
			
			// Zone de texte de vueZ numero
			c.gridx=		7;
			c.gridy=		3;
			txtNumSliceZ=new JTextField(4);
			contenu.add(txtNumSliceZ,c);
			txtNumSliceZ.setToolTipText("Go to Z view...");
			
			// bouton de validation de zone de texte de vueZ numero
			c.gridx=		10;
			c.gridy=		3;
			buttonGotoZ=new JButton("Go to Z");
			contenu.add(buttonGotoZ,c);
			buttonGotoZ.addActionListener(this);
			buttonGotoZ.setToolTipText("Go to Z view...");

		}

		public void closeX() {
			// if image created
			if (vueX.getCreation()==true) {
				// if image open
				if (vueX.getImpView().getWindow().isClosed()==false) {
					vueX.getImpView().getWindow().close();
					vueX=new Xview(impWo);
				}
				else vueX=new Xview(impWo);
			}
		}
		
		public void closeY() {
			// if image created
			if (vueY.getCreation()==true) {
				// if image open
				if (vueY.getImpView().getWindow().isClosed()==false) {
					vueY.getImpView().getWindow().close();
					vueY=new Yview(impWo);
				}
				else vueY=new Yview(impWo);
			}
		}
		
		public void closeZ() {
			// if image created
			if (vueZ.getCreation()==true) {
				// if image open
				if (vueZ.getImpView().getWindow().isClosed()==false) {
					vueZ.getImpView().getWindow().close();
					vueZ=new Zview(impWo);
				}
				else vueZ=new Zview(impWo);
			}
		}
		//_______________________________________________
		// methode de fermeture des vues
		
		public void closeAllWindows() {
			closeX();			
			closeY();
			closeZ();
		}
		
		//_______________________________________________
		// gestion des evenements clics des boutons
		
		public void actionPerformed(ActionEvent e) {
			Object b=e.getSource();

			// memorisation des positions des fenetres
			if (vueX.getImpView().getWindow()!=null)
				fenX=vueX.getImpView().getWindow().getBounds();
			if (vueY.getImpView().getWindow()!=null)
				fenY=vueY.getImpView().getWindow().getBounds();
			if (vueZ.getImpView().getWindow()!=null)
				fenZ=vueZ.getImpView().getWindow().getBounds();
			
			// ----- Slices views -----
			
			if (b==buttonSlice) {
				closeAllWindows();
				// reaffichage des fenetres
				vueX.sliceProcess(yMouseClicked,fenX);
				vueY.sliceProcess(xMouseClicked,fenY);
				vueZ.sliceProcess(zMouseClicked+1,fenZ);
			}
			
			// ----- Stacks views -----
			
			if (b==buttonStack) {
				closeAllWindows();
				// reaffichage des fenetres
				vueX.stackProcess(yMouseClicked,fenX);
				vueY.stackProcess(xMouseClicked,fenY);
				vueZ.stackProcess(zMouseClicked,fenZ);
			}
			
			// ----- Close all windows -----
			
			if (b==buttonCloseAll) {
				// remise a zero des positions de fenetres
				fenX=new Rectangle();
				fenY=new Rectangle();
				fenZ=new Rectangle();
				xMouseClicked=0;
				yMouseClicked=0;
				zMouseClicked=0;				
				closeAllWindows();
				
			// __________________
				
			// ----- Prec X -----
			}
			
			if (b==buttonPrevX) {
				if (yMouseClicked>0) {
					closeX();
					yMouseClicked--;
					vueX.sliceProcess(yMouseClicked,fenX);
				}
			}
			
			// ----- Next X -----
			if (b==buttonNextX) {
				if (yMouseClicked<(vueX.getImpSource().getStackSize()-1)) {
					closeX();
					yMouseClicked++;
					vueX.sliceProcess(yMouseClicked,fenX);
				}
			}
			
			// ----- Goto X -----				
			if (b==buttonGotoX) {
				try {
					int lu=Integer.parseInt(txtNumSliceX.getText());
					if (lu>=0 && lu<vueX.getImpSource().getStackSize()) {
						closeX();
						yMouseClicked=lu;
						vueX.sliceProcess(yMouseClicked,fenX);
					}
				}
				catch(NumberFormatException exn) {IJ.error("Bad parameter");}
			}
			// __________________
				
			// ----- Prec Y -----
			
			if (b==buttonPrevY) {
				if (xMouseClicked>0) {
					closeY();
					xMouseClicked--;
					vueY.sliceProcess(xMouseClicked,fenY);
				}
			}
			
			// ----- Next Y -----
			if (b==buttonNextY) {
				if (xMouseClicked<(vueY.getImpSource().getStackSize()-1)) {
					closeY();
					xMouseClicked++;
					vueY.sliceProcess(xMouseClicked,fenY);
				}
			}
			
			// ----- Goto Y -----				
			if (b==buttonGotoY) {
				try {
					int lu=Integer.parseInt(txtNumSliceY.getText());
					if (lu>=0 && lu<vueY.getImpSource().getStackSize()) {
						closeY();
						xMouseClicked=lu;
						vueY.sliceProcess(xMouseClicked,fenY);
					}
				}
				catch(NumberFormatException exn) {IJ.error("Bad parameter");}
			}
			// __________________
				
			// ----- Prec Z -----
			
			if (b==buttonPrevZ) {
				if (zMouseClicked>0) {
					closeZ();
					zMouseClicked--;
					vueZ.sliceProcess(zMouseClicked+1,fenZ);
				}
			}
			
			// ----- Next Z -----
			if (b==buttonNextZ) {
				if (zMouseClicked<(vueZ.getImpSource().getStackSize()-1)) {
					closeZ();
					zMouseClicked++;
					vueZ.sliceProcess(zMouseClicked+1,fenZ);
				}
			}
			
			// ----- Goto Z -----				
			if (b==buttonGotoZ) {
				try {
					int lu=Integer.parseInt(txtNumSliceZ.getText());
					if (lu>=0 && lu<vueZ.getImpSource().getStackSize()) {
						closeZ();
						zMouseClicked=lu;
						vueZ.sliceProcess(zMouseClicked+1,fenZ);
					}
				}
				catch(NumberFormatException exn) {IJ.error("Bad parameter");}
			}
		}
		
		//_______________________________________________
		// ecouteur de fermeture de la fenetre contenant la barre d'outil
		// declenche la fermeture des vues
		
		public class ToolBarListener extends WindowAdapter {
			public void windowClosing(WindowEvent e) {
				closeAllWindows();
			}
		}
	}
}

//_______________________________________________
// classe abstraite pour les vues

abstract class View extends JFrame {

	// decalage de l'affichage des fenetres de vues par rapport a la fenetre de travail
	// 10= 1/10 de largeur de la fenetre source
	// 3=  1/3 de largeur de la fenetre source
	
	// decalage horizontal
	private static int WINDOW_H_SHIFT=6;
	
	// decalage vertical
	private static int WINDOW_V_SHIFT=8;
	
	private ImagePlus impS;		// image source
	private ImagePlus impV;		// image de la vue a generer
	
	private byte[] pixelsS;		// tableau de pixels de la source
	private byte[] pixelsV;		// tableau de pixels de la vue a generer

	
	private ImageStack Vstack;	// ImageStack de l'image a creer

	protected StackWindow winStack;
	protected ImageWindow win;

	private int w;				// largeur de l'image source en pixels
	private int h;				// hauteur de l'image source en pixels
	
	private boolean creation;	// false = pas de vue generee 
								// true  = une vue a ete generee

	protected String icon;		// icone de la fenetre

	private File currentPath;	// chemin courant d'Image J		
	protected String absPath;	// chemin absolu des icones reconstruit

	// CONSTRUCTEUR
	public View(ImagePlus imp) {
		try {
			currentPath=new File(".");
			absPath=currentPath.getCanonicalPath()+File.separator+"plugins"+File.separator+"icons"+File.separator;
		}
		catch(IOException e){IJ.error("Exception:\n"+e);}
		
		impS=imp;
		// creation d'une image
		impV=NewImage.createByteImage (null,0,0,0,NewImage.FILL_WHITE);
		Vstack=impS.createEmptyStack();		

		w=impS.getStack().getWidth();
		h=impS.getStack().getHeight();
	
		creation=false;		// la vue n'est pas encore generee
	}

	// methode abstraite pour la generation de la vue sous forme de volume
	abstract public void stackProcess(int depth, Rectangle fen);
	
	// methode abstraite pour la generation de la vue sous forme d'une simple image	
	abstract public void sliceProcess(int sc, Rectangle fen);

	// methodes d'acces aux membres
	public boolean		getCreation() 			{return creation;}
	public ImagePlus	getImpSource()			{return impS;}
	public ImagePlus	getImpView() 			{return impV;}
	public Object 		getPixelsV()			{return pixelsV;}

	// reinitialisation de pixelsV (tableau de pixels de la vue a generer)
	public void initPixelsV() {
		pixelsV=new byte[w*h];
		// remplissage du tableau "vide" en blanc
		for(int i=0;i<(w*h);i++)
			pixelsV[i]=(byte)255;
	}
	
	// lecture d'une couche et copie dans le tableau de pixels
	public void setPixelsS(int index) {
		pixelsS=new byte[w*h];
		pixelsS=(byte[])impS.getStack().getPixels(index);
	}
	
	// ajout d'une couche donnee a la vue (avec un label)
	// couche representee par son tableau de pixels
	public void addPixelsV(Object pixelArray,String label) {
		// add the generated slice to the new stack
		Vstack.addSlice(null,pixelArray);
		impV.setStack(label,Vstack);
	}
	
	// copie d'une ligne verticale du tableau de pixels de la source dans
	// une ligne horizontale du tableau de pixels de la vue a generer
	// fournir les indices de la ligne de la source et de la destination
	
	// correspond a une rotation de 45 degres, execution plus rapide
	
	public void VLineToHline(int indVline,int indHline) {
		// p= offset sur la ligne du point a copier (de 0 a Largeur)
		// pour tous les points de la ligne
		int line=indHline*w;
		for(int p=0;p<w;p++) {
			// copie point par point
			// correspond a un deplacement dans la source verticalement (bond par ligne)
			// correspond a un deplacement dans la vue horizontalement (deplacement de point en point)
			pixelsV[line+p]=pixelsS[(p*w)+indVline];
		}
	}
		
	// copie d'une ligne horizontale du tableau de pixels de la source dans
	// une ligne retournee horizontalement
	
	// correspond a une rotation de 180 degres, execution plus rapide
	
	public void reverseHline(int indHlineSource,int indHlineDest) {
		// p= offset sur la ligne du point a copier (de 0 a Largeur)
		// pour tous les points de la ligne
		int lineSource=indHlineSource*w;
		int lineDest=indHlineDest*w;
		for(int p=0;p<w;p++) {
			// copie point par point
			// correspond a un deplacement dans la source source horizontalement (de point en point)
			// correspond a un deplacement dans la vue horizontalement, mais dans l'autre sens
			pixelsV[lineDest+p]=pixelsS[lineSource+(w-p-1)];
		}
	}
	
	// methodes d'affichage de la vue

	// vue sous forme de volume complet a la position par defaut
	public void printStack(int slice, Rectangle fen) {
		Rectangle r=new Rectangle();
		r=impS.getWindow().getBounds();
		
		winStack=new StackWindow(impV);
		winStack.showSlice(slice);

		if (fen.x!=0 && fen.y!=0 && fen.width!=0 && fen.height!=0)
			impV.getWindow().setBounds(fen.x,fen.y,fen.width,fen.height);
		else 
			impV.getWindow().setBounds(r.x+(r.width/WINDOW_H_SHIFT),r.y+(r.height/WINDOW_V_SHIFT),r.width,r.height);
		
		impV.show();
		impV.updateAndDraw();
		creation=true;
	}
	
	// vue sous forme de volume complet, decalee de "coeff" * largeurs de fenetres
	public void printStack(int slice, int coeff, Rectangle fen) {
		Rectangle r=new Rectangle();
		r=impS.getWindow().getBounds();
		
		winStack=new StackWindow(impV);
		winStack.showSlice(slice);

		if (fen.x!=0 && fen.y!=0 && fen.width!=0 && fen.height!=0)
			impV.getWindow().setBounds(fen.x,fen.y,fen.width,fen.height);
		else 
			impV.getWindow().setBounds(r.x+(coeff*r.width/WINDOW_H_SHIFT),r.y+(coeff*r.height/WINDOW_V_SHIFT),r.width,r.height);
		
		impV.show();
		impV.updateAndDraw();
		creation=true;
	}
	
	// vue sous forme de simple image (slice)
	public void printSlice(Rectangle fen) {
		Rectangle r=new Rectangle();
		r=impS.getWindow().getBounds();
		
		win=new ImageWindow(impV);
		
		if (fen.x!=0 && fen.y!=0 && fen.width!=0 && fen.height!=0)
			impV.getWindow().setBounds(fen.x,fen.y,fen.width,fen.height);
		else 
			impV.getWindow().setBounds(r.x+(r.width/WINDOW_H_SHIFT),r.y+(r.height/WINDOW_V_SHIFT),r.width,r.height);
		impV.show();
		impV.updateAndDraw();
		creation=true;
	}
	
	// vue sous forme de simple image, decalee de "coeff" * largeurs de fenetres
	public void printSlice(int coeff, Rectangle fen) {
		Rectangle r=new Rectangle();
		r=impS.getWindow().getBounds();
		
		win=new ImageWindow(impV);
		
		if (fen.x!=0 && fen.y!=0 && fen.width!=0 && fen.height!=0)
			impV.getWindow().setBounds(fen.x,fen.y,fen.width,fen.height);
		else
			impV.getWindow().setBounds(r.x+(coeff*r.width/WINDOW_H_SHIFT),r.y+(coeff*r.height/WINDOW_V_SHIFT),r.width,r.height);
		impV.show();
		impV.updateAndDraw();
		creation=true;
	}
}

//_______________________________________________
// vue orthogonale X

class Xview extends View {

	public Xview(ImagePlus imp) {
		super(imp);
		icon=absPath+"slicex.gif";
	}
	
	public void stackProcess(int depth, Rectangle fen) {
		int sc;	// index de la couche a creer
		int sr;	// index de la couche a lire
		int n=getImpSource().getStackSize();
		// pour chaque couche du volume a generer
		for(sc=0;sc<n;sc++) {
			// pour inverser l'ordre des couches faire: for(sc=n-1;sc>=0;sc--)
			initPixelsV();

			// pour chaque couche du volume initial
			for(sr=0;sr<n;sr++) {
				setPixelsS(sr+1);
				reverseHline(sc,sr);
			}
			addPixelsV(getPixelsV(),"X");
		}
		printStack(depth+1,fen);
		ImageIcon ic=new ImageIcon(icon);
		winStack.setIconImage(ic.getImage());
	}
	
	public void sliceProcess(int sc, Rectangle fen) {
		int sr;	// index de la couche a lire
		int n=getImpSource().getStackSize();
		// pour inverser l'ordre des couches faire: for(sc=n-1;sc>=0;sc--)
		initPixelsV();
		// pour chaque couche du volume initial
		for(sr=0;sr<n;sr++) {
			setPixelsS(sr+1);
			reverseHline(sc,sr);
		}
		addPixelsV(getPixelsV(),"X "+sc);
		printSlice(fen);
		ImageIcon ic=new ImageIcon(icon);
		win.setIconImage(ic.getImage());
	}
}

//_______________________________________________
// vue orthogonale Y

class Yview extends View {

	public Yview(ImagePlus imp) {
		super(imp);
		icon=absPath+"slicey.gif";
	}
	
	public void stackProcess(int depth, Rectangle fen) {
		int sc;	// index de la couche a creer
		int sr;	// index de la couche a lire
		int n=getImpSource().getStackSize();
		
		// pour chaque couche du volume a generer
		for(sc=0;sc<n;sc++) {
			// pour inverser l'ordre des couches faire: for(sc=n-1;sc>=0;sc--)
			initPixelsV();

			// pour chaque couche du volume initial
			for(sr=0;sr<n;sr++) {
				setPixelsS(sr+1);
				VLineToHline(sc,sr);
			}
			addPixelsV(getPixelsV(),"Y");
		}
		printStack(depth+1,2,fen);
		ImageIcon ic=new ImageIcon(icon);
		winStack.setIconImage(ic.getImage());
	}
	
	public void sliceProcess(int sc, Rectangle fen) {
		int sr;	// index de la couche a lire
		int n=getImpSource().getStackSize();
		// pour inverser l'ordre des couches faire: for(sc=n-1;sc>=0;sc--)
		initPixelsV();
			// pour chaque couche du volume initial
		for(sr=0;sr<n;sr++) {
			setPixelsS(sr+1);
			VLineToHline(sc,sr);
		}
		addPixelsV(getPixelsV(),"Y "+sc);
		printSlice(2,fen);
		ImageIcon ic=new ImageIcon(icon);
		win.setIconImage(ic.getImage());
	}
}

//_______________________________________________
// vue orthogonale Z
// (duplique la source, qui est consideree comme vue de dessus)

class Zview extends View {

	public Zview(ImagePlus imp) {
		super(imp);
		icon=absPath+"slicez.gif";
	}
	public void stackProcess(int depth, Rectangle fen) {
		int s;	// index de la couche a lire et a creer
		int n=getImpSource().getStackSize();
		
		for(s=1;s<(n+1);s++) {
			addPixelsV(getImpSource().getStack().getPixels(s),"Z");
		}
		printStack(depth,3,fen);
		ImageIcon ic=new ImageIcon(icon);
		winStack.setIconImage(ic.getImage());
	}
	public void sliceProcess(int s, Rectangle fen) {
		addPixelsV(getImpSource().getStack().getPixels(s),"Z "+(s-1));
		printSlice(3,fen);
		ImageIcon ic=new ImageIcon(icon);
		win.setIconImage(ic.getImage());
	}
}