[Setup]
MessagesFile=compiler:japanese.isl
AppName=GrWin OtBNXECu
AppVerName=GrWin Version  0.99.9b
DefaultDirName={sd}\GrWin
DisableProgramGroupPage=yes
OutputDir=..
OutputBaseFilename=lGrWn0999b
UninstallDisplayIcon={app}\grwnd.ico

[Messages]
; *** "Welcome" wizard page
WelcomeLabel2=̃Rs[^ [name/ver] CXg[܂B%n%nÂo[W [name] fBXNɑ݂ĂƁCCXg[炪QƂĂ܂삵Ȃꍇ܂BāC̃CXg[Ă邩ǂȂꍇɂ͌Âo[W [name] ACXg[ĂB܂CCXg[̖蔭邽߁Aݎs̑̃AvP[Vׂĕ邱Ƃ߂܂B
SelectComponentsLabel2=̃yCŎgpRpCIC̃yCł̓CXg[Kv̂ȂR|[lg̃`FbNOĂB̃yCŁu㋉ҌvIꍇɂ́Cst@CȂǃRpCɈˑȂʂ̃t@C͑ỎʂŎw肵uCXg[ṽfBNgɃRs[܂̂ŁC̃CXg[̎sIɁCpXȂǂŐݒ肷Kv܂B̃yCŕ̃RpCp̃R|[lgIƎIɁu㋉ҌvɂȂ܂̂ŒӂĂB%n%nꍇ́uցvNbNĂB

[Dirs]
Name: "{app}\demo"; Components: demo
Name: "{app}\pgplot"; Tasks: pgplot
;Name: "{app}\GrWinTk"; Tasks: GrWinTk

[Types]
Name: "mingw"; Description: "MinGW 2.x p"
Name: "cygwin"; Description: "Cygwin 1.3.x p"
Name: "watcom"; Description: "Open Watcom C/C++ and Fortran p"
Name: "bcc"; Description: "Borland C/C++ and f2c p"
Name: "dmc"; Description: "Digital Mars C/C++ and f2c p"
Name: "intel"; Description: "Intel C++ / Fortran Compiler p"
Name: "vcpp"; Description: "Microsoft Visual C++ / f2c p"
Name: "vf"; Description: "Microsoft Visual C++ / Compaq Visual Fortran p"
Name: "mingw32m"; Description: "gcc-2.95.2-mingw32 (MSCVCRT) p"
Name: "mingw32"; Description: "gcc-2.95.2-mingw32 (CRTDLL) p"
Name: "cygb20"; Description: "gcc-2.95.2-cygb20 p"
Name: "uwin"; Description: "gcc-2.95.2-uwin p"
Name: "custom"; Description: "㋉Ҍ"; Flags: iscustom

[Components]
Name: "main"; Description: "vt@C"; Types: custom mingw cygwin intel vcpp vf watcom bcc dmc uwin mingw32 mingw32m cygb20; Flags: fixed
Name: "demo"; Description: "Tv"; Types: mingw cygwin intel vcpp vf watcom bcc dmc uwin mingw32 mingw32m cygb20
Name: "mingw"; Description: "MinGW 2.x Ήt@C"; Types: mingw
Name: "cygwin"; Description: "Cygwin 1.3.x Ήt@C"; Types: cygwin
Name: "intel"; Description: "Intel C++ / Fortran Compiler Ήt@C"; Types: intel
Name: "vcpp"; Description: "Microsoft Visual C++ / f2c Ήt@C"; Types: vcpp
Name: "vf"; Description: "Microsoft Visual C++ / Compaq Visual Fortran Ήt@C"; Types: vf
Name: "watcom"; Description: "Open Watcom C/C++ and Fortran Ήt@C"; Types: watcom
Name: "bcc"; Description: "Borland C/C++ and f2c Ήt@C"; Types: bcc
Name: "dmc"; Description: "Digital Mars C/C++ and f2c Ήt@C"; Types: dmc
Name: "uwin"; Description: "gcc-2.95.2-uwin Ήt@C"; Types: uwin
Name: "mingw32"; Description: "gcc-2.95.2-mingw32 (CRTDLL) Ήt@C"; Types: mingw32
Name: "mingw32m"; Description: "gcc-2.95.2-mingw32 (MSCVCRT) Ήt@C"; Types: mingw32m
Name: "cygb20"; Description: "gcc-2.95.2-cygb20 Ήt@C"; Types: cygb20

[Tasks]
Name: "NOcalcomp"; Description: "GrWin0 ( Calcomp Ȃ ) ̃CXg["
Name: "calcomp"; Description: "Ɨ Calcomp CũCXg["
Name: "pgplot"; Description: "Pgplot CũCXg["
;Name: "GKS"; Description: "GKS CũCXg["
;Name: "GrWinTk"; Description: "GrWin c[Lbg̃CXg["
 Name: "f2c"; Description: "f2c CũCXg["; Flags: unchecked

[Files]
Source: "..\..\GrWnd\RES\grwnd.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "bin\grwnd.exe"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "bin\grwnd.ini"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999b.html"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999b.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "README.html"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "README.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999b.iss"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "qanda.html"; DestDir: "{app}"; Components: main; Flags: ignoreversion

Source: "f77chk\f77chk.pl"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "f77chk\f77chk.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "..\GrWinTk\build\library.def"; DestDir: "{code:exe}"; Components: main; Tasks: pgplot; Flags: ignoreversion

Source: "..\pgplot-MinGW\grfont.dat"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pgplot.doc"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\rgb.txt"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgplot.doc"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgdemo17.ini"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\Makefile"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\cpg\cpgdemo.c"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo1.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo2.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo3.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo4.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo5.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo6.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo7.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo8.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo9.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo10.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo11.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo12.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo13.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo14.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo15.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo16.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo17.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgdemo17.ini"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion

Source: "demo\ball.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bitmap.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bitmap.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bitmap.txt"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bounce.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bounce.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bounce.txt"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dp.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dspexf.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dspexf.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\gwdemo17.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\gwdemo17.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\jonathan1.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\jonathan2.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\make.mak"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\Makefile"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mixmodes.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mixmodes.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mixmodes.txt"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mlwndws.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mlwndws.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose_d.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose_d.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.txt"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon_f.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample1.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample1.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample2.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample2.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\shot.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\shot.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\soliton.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\soliton.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tblfonts.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tblfonts.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\trigfn.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\trigfn.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\trigfn.txt"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstmlvp.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstmlvp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstttsmrk.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstttsmrk.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstwinapp.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstwinapp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:bcc}\Include"; Components: bcc; Flags: ignoreversion
Source: "bcc\GrWin.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Flags: ignoreversion
Source: "bcc\GrWin0.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Tasks: NOcalcomp; Flags: ignoreversion
Source: "bcc\Calcomp.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Tasks: calcomp; Flags: ignoreversion
Source: "bcc\gwbcc.bat"; DestDir: "{code:exe}"; Components: bcc; Flags: ignoreversion
Source: "bcc\gwbccw.bat"; DestDir: "{code:exe}"; Components: bcc; Flags: ignoreversion
Source: "bcc\gwf2bcc.bat"; DestDir: "{code:exe}"; Components: bcc; Flags: ignoreversion
Source: "..\pgplot-bcc\cpgplot.h"; DestDir: "{code:bcc}\Include"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-bcc\pgplot.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-bcc\cpgplot.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-bcc\pggwf2bcc.bat"; DestDir: "{code:exe}"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-bcc\pggwbcc.bat"; DestDir: "{code:exe}"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-bcc\pggwbccw.bat"; DestDir: "{code:exe}"; Components: bcc; Tasks: pgplot; Flags: ignoreversion
Source: "bcc\f2c.h"; DestDir: "{code:bcc}\Include"; Components: bcc; Flags: ignoreversion
Source: "bcc\f2c.lib"; DestDir: "{code:bcc}\Lib"; Components: bcc; Flags: ignoreversion
Source: "bcc\f2c.exe"; DestDir: "{code:exe}"; Components: bcc; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:dmc}\include"; Components: dmc; Flags: ignoreversion
Source: "dmc\GrWin.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Flags: ignoreversion
Source: "dmc\GrWin0.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Tasks: NOcalcomp; Flags: ignoreversion
Source: "dmc\Calcomp.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Tasks: calcomp; Flags: ignoreversion
Source: "dmc\gwdmc.bat"; DestDir: "{code:exe}"; Components: dmc; Flags: ignoreversion
Source: "dmc\gwdmcw.bat"; DestDir: "{code:exe}"; Components: dmc; Flags: ignoreversion
Source: "dmc\gwf2dmc.bat"; DestDir: "{code:exe}"; Components: dmc; Flags: ignoreversion
Source: "..\pgplot-dmc\cpgplot.h"; DestDir: "{code:dmc}\include"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-dmc\pgplot.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-dmc\cpgplot.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-dmc\pggwf2dmc.bat"; DestDir: "{code:exe}"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-dmc\pggwdmc.bat"; DestDir: "{code:exe}"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-dmc\pggwdmcw.bat"; DestDir: "{code:exe}"; Components: dmc; Tasks: pgplot; Flags: ignoreversion
Source: "dmc\f2c.h"; DestDir: "{code:dmc}\include"; Components: dmc; Flags: ignoreversion
Source: "dmc\f2c.lib"; DestDir: "{code:dmc}\lib"; Components: dmc; Flags: ignoreversion
Source: "dmc\f2c.exe"; DestDir: "{code:exe}"; Components: dmc; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:intel}\Include"; Components: intel; Flags: ignoreversion
Source: "Intel\GrWin.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Flags: ignoreversion
Source: "Intel\GrWin0.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Tasks: NOcalcomp; Flags: ignoreversion
Source: "Intel\calcomp.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Tasks: calcomp; Flags: ignoreversion
Source: "Intel\gwifl.bat"; DestDir: "{code:exe}"; Components: intel; Flags: ignoreversion
Source: "Intel\gwicl.bat"; DestDir: "{code:exe}"; Components: intel; Flags: ignoreversion
Source: "Intel\gwiclw.bat"; DestDir: "{code:exe}"; Components: intel; Flags: ignoreversion
Source: "..\pgplot-Intel\cpgplot.h"; DestDir: "{code:intel}\Include"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-Intel\pgplot.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-Intel\cpgplot.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-Intel\pggwifl.bat"; DestDir: "{code:exe}"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-Intel\pggwicl.bat"; DestDir: "{code:exe}"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-Intel\pggwiclw.bat"; DestDir: "{code:exe}"; Components: intel; Tasks: pgplot; Flags: ignoreversion
Source: "Intel\f2c\f2c.h"; DestDir: "{code:intel}\Include"; Components: intel; Tasks: f2c; Flags: ignoreversion
Source: "Intel\f2c\f2c.lib"; DestDir: "{code:intel}\Lib"; Components: intel; Tasks: f2c; Flags: ignoreversion
Source: "Intel\f2c\f2c.exe"; DestDir: "{code:exe}"; Components: intel; Tasks: f2c; Flags: ignoreversion
Source: "Intel\f2c\gwf2icl.bat"; DestDir: "{code:exe}"; Components: intel; Tasks: f2c; Flags: ignoreversion
Source: "..\pgplot-Intel\f2c\pggwf2icl.bat"; DestDir: "{code:exe}"; Components: intel; Tasks: pgplot f2c; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Flags: ignoreversion
Source: "vcppML\gwcl.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "vcppML\gwclw.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "..\pgplot-vcpp\cpgplot.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pgplot.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\cpgplot.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwcl.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwclw.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "vcpp\GrWin.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\GrWin0.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: NOcalcomp; Flags: ignoreversion
Source: "vcpp\Calcomp.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: calcomp; Flags: ignoreversion
Source: "vcpp\f2c.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\f2c.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\f2c.exe"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\gwf2cl.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwf2cl.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:vfcpp}\Include"; Components: vf; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion
Source: "vcppML\GrWin.lib"; DestDir: "{code:vf}\Lib"; Components: vf; Flags: ignoreversion
Source: "vcppML\GrWin0.lib"; DestDir: "{code:vf}\Lib"; Components: vf; Tasks: NOcalcomp; Flags: ignoreversion
Source: "vcppML\Calcomp.lib"; DestDir: "{code:vf}\Lib"; Components: vf; Tasks: calcomp; Flags: ignoreversion
Source: "vcppML\gwdf.bat"; DestDir: "{code:exe}"; Components: vf; Flags: ignoreversion
Source: "vcppML\gwcl.bat"; DestDir: "{code:exe}"; Components: vf; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion
Source: "vcppML\gwclw.bat"; DestDir: "{code:exe}"; Components: vf; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion
Source: "..\pgplot-vcpp\cpgplot.h"; DestDir: "{code:vfcpp}\Include"; Components: vf; Tasks: pgplot; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwdf.bat"; DestDir: "{code:exe}"; Components: vf; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwcl.bat"; DestDir: "{code:exe}"; Components: vf; Tasks: pgplot; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwclw.bat"; DestDir: "{code:exe}"; Components: vf; Tasks: pgplot; Check: DirCheck({code:vfcpp}\Include); Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:watcom}\include"; Components: watcom; Flags: ignoreversion
Source: "watcom\GrWin.lib"; DestDir: "{code:watcom}\lib386"; Components: watcom; Flags: ignoreversion
Source: "watcom\GrWin0.lib"; DestDir: "{code:watcom}\lib386"; Components: watcom; Tasks: NOcalcomp; Flags: ignoreversion
Source: "watcom\Calcomp.lib"; DestDir: "{code:watcom}\lib386"; Components: watcom; Tasks: calcomp; Flags: ignoreversion
Source: "watcom\gwwcl.bat"; DestDir: "{code:exe}"; Components: watcom; Flags: ignoreversion
Source: "watcom\gwwclw.bat"; DestDir: "{code:exe}"; Components: watcom; Flags: ignoreversion
Source: "watcom\gwwfl.bat"; DestDir: "{code:exe}"; Components: watcom; Flags: ignoreversion
Source: "..\pgplot-watcom\cpgplot.h"; DestDir: "{code:watcom}\include"; Components: watcom; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-watcom\pgplot.lib"; DestDir: "{code:watcom}\lib386"; Components: watcom; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-watcom\cpgplot.lib"; DestDir: "{code:watcom}\lib386"; Components: watcom; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-watcom\pggwwfl.bat"; DestDir: "{code:exe}"; Components: watcom; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-watcom\pggwwcl.bat"; DestDir: "{code:exe}"; Components: watcom; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-watcom\pggwwclw.bat"; DestDir: "{code:exe}"; Components: watcom; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:cygb20}\include"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\libGrWin.a"; DestDir: "{code:cygb20}\H-i586-cygwin32\lib"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\libGrWin0.a"; DestDir: "{code:cygb20}\H-i586-cygwin32\lib"; Components: cygb20; Tasks: NOcalcomp; Flags: ignoreversion
Source: "cygb20\libcalcomp.a"; DestDir: "{code:cygb20}\H-i586-cygwin32\lib"; Components: cygb20; Tasks: calcomp; Flags: ignoreversion
Source: "cygb20\gwf77.bat"; DestDir: "{code:exe}"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\gwgcc.bat"; DestDir: "{code:exe}"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\gwgpp.bat"; DestDir: "{code:exe}"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\gwgccw.bat"; DestDir: "{code:exe}"; Components: cygb20; Flags: ignoreversion
Source: "cygb20\gwgppw.bat"; DestDir: "{code:exe}"; Components: cygb20; Flags: ignoreversion
Source: "..\pgplot-cygb20\cpgplot.h"; DestDir: "{code:cygb20}\include"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\libpgplot.a"; DestDir: "{code:cygb20}\H-i586-cygwin32\lib"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\libcpgplot.a"; DestDir: "{code:cygb20}\H-i586-cygwin32\lib"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\pggwf77.bat"; DestDir: "{code:exe}"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\pggwgcc.bat"; DestDir: "{code:exe}"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\pggwgpp.bat"; DestDir: "{code:exe}"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\pggwgccw.bat"; DestDir: "{code:exe}"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygb20\pggwgppw.bat"; DestDir: "{code:exe}"; Components: cygb20; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:cygwin}\usr\include"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\libGrWin.a"; DestDir: "{code:cygwin}\lib"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\libGrWin0.a"; DestDir: "{code:cygwin}\lib"; Components: cygwin; Tasks: NOcalcomp; Flags: ignoreversion
Source: "cygwin\libcalcomp.a"; DestDir: "{code:cygwin}\lib"; Components: cygwin; Tasks: calcomp; Flags: ignoreversion
Source: "cygwin\gwf77.bat"; DestDir: "{code:exe}"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\gwgcc.bat"; DestDir: "{code:exe}"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\gwgpp.bat"; DestDir: "{code:exe}"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\gwgccw.bat"; DestDir: "{code:exe}"; Components: cygwin; Flags: ignoreversion
Source: "cygwin\gwgppw.bat"; DestDir: "{code:exe}"; Components: cygwin; Flags: ignoreversion
Source: "..\pgplot-cygwin\cpgplot.h"; DestDir: "{code:cygwin}\usr\include"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\libpgplot.a"; DestDir: "{code:cygwin}\lib"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\libcpgplot.a"; DestDir: "{code:cygwin}\lib"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\pggwf77.bat"; DestDir: "{code:exe}"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\pggwgcc.bat"; DestDir: "{code:exe}"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\pggwgpp.bat"; DestDir: "{code:exe}"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\pggwgccw.bat"; DestDir: "{code:exe}"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-cygwin\pggwgppw.bat"; DestDir: "{code:exe}"; Components: cygwin; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:mingw}\include"; Components: mingw; Flags: ignoreversion
Source: "MinGW\libGrWin.a"; DestDir: "{code:mingw}\lib"; Components: MinGW; Flags: ignoreversion
Source: "MinGW\libGrWin0.a"; DestDir: "{code:mingw}\lib"; Components: MinGW; Tasks: NOcalcomp; Flags: ignoreversion
Source: "MinGW\libcalcomp.a"; DestDir: "{code:mingw}\lib"; Components: MinGW; Tasks: calcomp; Flags: ignoreversion
Source: "MinGW\gwf77.bat"; DestDir: "{code:exe}"; Components: MinGW; Flags: ignoreversion
Source: "MinGW\gwgcc.bat"; DestDir: "{code:exe}"; Components: MinGW; Flags: ignoreversion
Source: "MinGW\gwgpp.bat"; DestDir: "{code:exe}"; Components: MinGW; Flags: ignoreversion
Source: "MinGW\gwgccw.bat"; DestDir: "{code:exe}"; Components: MinGW; Flags: ignoreversion
Source: "MinGW\gwgppw.bat"; DestDir: "{code:exe}"; Components: MinGW; Flags: ignoreversion
Source: "..\pgplot-MinGW\cpgplot.h"; DestDir: "{code:mingw}\include"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\libpgplot.a"; DestDir: "{code:mingw}\lib"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\libcpgplot.a"; DestDir: "{code:mingw}\lib"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pggwf77.bat"; DestDir: "{code:exe}"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pggwgcc.bat"; DestDir: "{code:exe}"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pggwgpp.bat"; DestDir: "{code:exe}"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pggwgccw.bat"; DestDir: "{code:exe}"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-MinGW\pggwgppw.bat"; DestDir: "{code:exe}"; Components: MinGW; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:mingw32}\i386-mingw32\include"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\libGrWin.a"; DestDir: "{code:mingw32}\i386-mingw32\lib"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\libGrWin0.a"; DestDir: "{code:mingw32}\i386-mingw32\lib"; Components: mingw32; Tasks: NOcalcomp; Flags: ignoreversion
Source: "mingw32\libcalcomp.a"; DestDir: "{code:mingw32}\i386-mingw32\lib"; Components: mingw32; Tasks: calcomp; Flags: ignoreversion
Source: "mingw32\gwf77.bat"; DestDir: "{code:exe}"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\gwgcc.bat"; DestDir: "{code:exe}"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\gwgpp.bat"; DestDir: "{code:exe}"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\gwgccw.bat"; DestDir: "{code:exe}"; Components: mingw32; Flags: ignoreversion
Source: "mingw32\gwgppw.bat"; DestDir: "{code:exe}"; Components: mingw32; Flags: ignoreversion
Source: "..\pgplot-mingw32\cpgplot.h"; DestDir: "{code:mingw32}\i386-mingw32\include"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\libpgplot.a"; DestDir: "{code:mingw32}\i386-mingw32\lib"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\libcpgplot.a"; DestDir: "{code:mingw32}\i386-mingw32\lib"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\pggwf77.bat"; DestDir: "{code:exe}"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\pggwgcc.bat"; DestDir: "{code:exe}"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\pggwgpp.bat"; DestDir: "{code:exe}"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\pggwgccw.bat"; DestDir: "{code:exe}"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32\pggwgppw.bat"; DestDir: "{code:exe}"; Components: mingw32; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:mingw32m}\i386-mingw32msvc\include"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\libGrWin.a"; DestDir: "{code:mingw32m}\i386-mingw32msvc\lib"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\libGrWin0.a"; DestDir: "{code:mingw32m}\i386-mingw32msvc\lib"; Components: mingw32m; Tasks: NOcalcomp; Flags: ignoreversion
Source: "mingw32m\libcalcomp.a"; DestDir: "{code:mingw32m}\i386-mingw32msvc\lib"; Components: mingw32m; Tasks: calcomp; Flags: ignoreversion
Source: "mingw32m\gwf77.bat"; DestDir: "{code:exe}"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\gwgcc.bat"; DestDir: "{code:exe}"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\gwgpp.bat"; DestDir: "{code:exe}"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\gwgccw.bat"; DestDir: "{code:exe}"; Components: mingw32m; Flags: ignoreversion
Source: "mingw32m\gwgppw.bat"; DestDir: "{code:exe}"; Components: mingw32m; Flags: ignoreversion
Source: "..\pgplot-mingw32m\cpgplot.h"; DestDir: "{code:mingw32m}\i386-mingw32msvc\include"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\libpgplot.a"; DestDir: "{code:mingw32m}\i386-mingw32msvc\lib"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\libcpgplot.a"; DestDir: "{code:mingw32m}\i386-mingw32msvc\lib"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\pggwf77.bat"; DestDir: "{code:exe}"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\pggwgcc.bat"; DestDir: "{code:exe}"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\pggwgpp.bat"; DestDir: "{code:exe}"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\pggwgccw.bat"; DestDir: "{code:exe}"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-mingw32m\pggwgppw.bat"; DestDir: "{code:exe}"; Components: mingw32m; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:uwin}\usr\gnu\include"; Components: uwin; Flags: ignoreversion
Source: "uwin\libGrWin.a"; DestDir: "{code:uwin}\usr\gnu\lib"; Components: uwin; Flags: ignoreversion
Source: "uwin\libGrWin0.a"; DestDir: "{code:uwin}\usr\gnu\lib"; Components: uwin; Tasks: NOcalcomp; Flags: ignoreversion
Source: "uwin\libcalcomp.a"; DestDir: "{code:uwin}\usr\gnu\lib"; Components: uwin; Tasks: calcomp; Flags: ignoreversion
Source: "uwin\gwf77.bat"; DestDir: "{code:exe}"; Components: uwin; Flags: ignoreversion
Source: "uwin\gwgcc.bat"; DestDir: "{code:exe}"; Components: uwin; Flags: ignoreversion
Source: "uwin\gwgpp.bat"; DestDir: "{code:exe}"; Components: uwin; Flags: ignoreversion
Source: "uwin\gwgccw.bat"; DestDir: "{code:exe}"; Components: uwin; Flags: ignoreversion
Source: "uwin\gwgppw.bat"; DestDir: "{code:exe}"; Components: uwin; Flags: ignoreversion
Source: "..\pgplot-uwin\cpgplot.h"; DestDir: "{code:uwin}\usr\gnu\include"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\libpgplot.a"; DestDir: "{code:uwin}\usr\gnu\lib"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\libcpgplot.a"; DestDir: "{code:uwin}\usr\gnu\lib"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\pggwf77.bat"; DestDir: "{code:exe}"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\pggwgcc.bat"; DestDir: "{code:exe}"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\pggwgpp.bat"; DestDir: "{code:exe}"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\pggwgccw.bat"; DestDir: "{code:exe}"; Components: uwin; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-uwin\pggwgppw.bat"; DestDir: "{code:exe}"; Components: uwin; Tasks: pgplot; Flags: ignoreversion

[Code]
var
	dmc_base: String;
	watcom_base: String;
	bcc_base: String;
	cygb20_base: String;
	cygwin_base: String;
	mingw_base: String;
	mingw32_base: String;
	mingw32m_base: String;
	uwin_base: String;
	intel_base: String;
	vcpp_base: String;
	vf_base: String; vfcpp_base: String;
	system_drive: String;
	program_files: String;

function InitializeSetup(): Boolean;
begin
	dmc_base := '';
	watcom_base := '';
	bcc_base := '';
	cygb20_base := '';
	cygwin_base := '';
	mingw_base := '';
	mingw32_base := '';
	mingw32m_base := '';
	uwin_base := '';
	intel_base := '';
	vcpp_base := '';
	vf_base := ''; vfcpp_base := '';
	system_drive := ExpandConstant('{sd}');
	program_files := ExpandConstant('{pf}');

	{ Let Setup run }
	Result := True;
end;

function GetBaseDir(Default, Description, Check: String): String;
var
	Ok: Boolean;
	YesNo: Integer;
begin
	Result := Default;
	ScriptDlgPageOpen();
	{ Set some captions }
	ScriptDlgPageSetCaption(Description);
	ScriptDlgPageSetSubCaption1(Check + ' CXg[Ăꏊw肵ĂB');
	ScriptDlgPageSetSubCaption2('tH_[IĂCuցvNbNĂ');
	{ Ask for a dir until the user has entered one or click Back or Cancel }
	Ok := InputDir('', Result);
	if Ok then begin
		while Ok and not FileExists(Result + '\' + Check) do begin
			YesNo := MsgBox(Check + ' ܂񂪁C' + Result + ' ɃCXg[𑱍s܂H', mbError, MB_YESNOCANCEL or MB_DEFBUTTON2);
			if YesNo = idYes then begin
			Ok := False;
			end else if YesNo = idNo then begin
				Ok := InputDir('', Result);
				if not Ok then Result := '';
			end else begin
				Ok := False;
				Result := '';
			end;
		end;
		ScriptDlgPageClose(True);
	end else
		Result := '';
end;

function dmc(Default: String): String;
begin
  if dmc_base = '' then
    dmc_base := GetBaseDir(system_drive + '\dm', 'Digital Mars C/C++ and f2c', '\bin\dmc.exe');
  Result := dmc_base;
end;

function watcom(Default: String): String;
begin
  if watcom_base = '' then
    watcom_base := GetBaseDir(system_drive + '\watcom', 'Open Watcom C/C++ and Fortran', '\h\stdio.h');
  Result := watcom_base;
end;

function bcc(Default: String): String;
begin
  if bcc_base = '' then
    bcc_base := GetBaseDir(system_drive + '\Borland\bcc55', 'Borland C/C++ and f2c', '\Include\stdio.h');
  Result := bcc_base;
end;

function cygb20(Default: String): String;
begin
  if cygb20_base = '' then
    cygb20_base := GetBaseDir(system_drive + '\cygb20', 'gcc-2.95.2-cygb20', '\H-i586-cygwin32\i586-cygwin32\include\stdio.h');
  Result := cygb20_base;
end;

function cygwin(Default: String): String;
begin
  if cygwin_base = '' then
    cygwin_base := GetBaseDir(system_drive + '\cygwin', 'Cygwin-1.3.x', '\bin\cygwin1.dll');
  Result := cygwin_base;
end;

function MinGW(Default: String): String;
begin
  if mingw_base = '' then
    mingw_base := GetBaseDir(system_drive + '\MinGW', 'MinGW-2.x', '\include\stdio.h');
  Result := mingw_base;
end;

function mingw32(Default: String): String;
begin
  if mingw32_base = '' then
    mingw32_base := GetBaseDir(system_drive + '\mingw32', 'gcc-2.95.2-mingw32 (CRTDLL)', '\i386-mingw32\include\stdio.h');
  Result := mingw32_base;
end;

function mingw32m(Default: String): String;
begin
  if mingw32m_base = '' then
    mingw32m_base := GetBaseDir(system_drive + '\mingw32', 'gcc-2.95.2-mingw32 (MSCVCRT)', '\i386-mingw32msvc\include\stdio.h');
  Result := mingw32m_base;
end;

function uwin(Default: String): String;
begin
  if uwin_base = '' then
    uwin_base := GetBaseDir(program_files + '\UWIN', 'gcc-2.95.2-uwin', '\usr\gnu\i386-pc-uwin\bin\as.exe');
  Result := uwin_base;
end;

function intel(Default: String): String;
begin
  if intel_base = '' then
    intel_base := GetBaseDir(program_files + '\intel\Compiler70\IA32', 'Intel C++ / Fortran Compiler', '\Include\stdarg.h');
  Result := intel_base;
end;

function vcpp(Default: String): String;
begin
  if vcpp_base = '' then
    vcpp_base := GetBaseDir(program_files + '\Microsoft Visual Studio\VC98', 'Microsoft Visual C++ / f2c', '\include\stdio.h');
  Result := vcpp_base;
end;

function vf(Default: String): String;
begin
	if vf_base = '' then begin
		vf_base := GetBaseDir(program_files + '\Microsoft Visual Studio\VF98', 'Compaq Visual Fortran', 'Bin\df.exe');
		if DirExists(vf_base + '..\VC98') then vfcpp_base := vf_base + '..\VC98';
	end;
	Result := vf_base;
end;
function vfcpp(Default: String): String;
begin
	if vfcpp_base = '' then
		vfcpp_base := GetBaseDir(program_files + '\Microsoft Visual Studio\VC98', 'Microsoft Visual C++', 'Bin\cl.exe');
		if DirExists(vfcpp_base + '..\VF98') then vf_base := vfcpp_base + '..\VF98';
	Result := vfcpp_base;
end;

function exe(Default: String): String;
var
	SetupType: String;
begin
	SetupType := WizardSetupType(True);
	if SetupType = 'dummy' then begin
	end else if SetupType = 'MinGW 2.x p' then begin
		Result := ExpandConstant('{code:mingw}\bin');
	end else if SetupType = 'Cygwin 1.3.x p' then begin
		Result := ExpandConstant('{code:cygwin}\bin');
	end else if SetupType = 'Open Watcom C/C++ and Fortran p' then begin
		Result := ExpandConstant('{code:watcom}\binnt');
	end else if SetupType = 'Borland C/C++ and f2c p' then begin
		Result := ExpandConstant('{code:bcc}\Bin');
	end else if SetupType = 'Digital Mars C/C++ and f2c p' then begin
		Result := ExpandConstant('{code:dmc}\bin');
	end else if SetupType = 'Intel C++ / Fortran Compiler p' then begin
		Result := ExpandConstant('{code:intel}\Bin');
	end else if SetupType = 'Microsoft Visual C++ / f2c p' then begin
		Result := ExpandConstant('{code:vcpp}\Bin');
	end else if SetupType = 'Microsoft Visual C++ / Compaq Visual Fortran p' then begin
		Result := ExpandConstant('{code:vf}\Bin');
	end else if SetupType = 'gcc-2.95.2-mingw32 (MSCVCRT) p' then begin
		Result := ExpandConstant('{code:mingw32m}\bin');
	end else if SetupType = 'gcc-2.95.2-mingw32 (CRTDLL) p' then begin
		Result := ExpandConstant('{code:mingw32}\bin');
	end else if SetupType = 'gcc-2.95.2-cygb20 p' then begin
		Result := ExpandConstant('{code:cygb20}\H-i586-cygwin32\bin');
	end else if SetupType = 'gcc-2.95.2-uwin p' then begin
		Result := ExpandConstant('{code:uwin}\usr\gnu\bin');
	end else begin
		Result := ExpandConstant('{app}\bin');
	end;
{  MsgBox(Result, mbError, MB_OK);}
end;

function DirCheck(DirName: String): Boolean;
begin
	Result := DirExists(DirName);
end;
