/* Text.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*1
eLXgptHg̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETTXT(IRTN, H, A, IO, K, KB, FACE)
    INTEGER IRTN, IO, K, KB
    REAL H, A
    CHARACTER FACE*(*)

[C] int GWsettxt(float H, float A, int IO, int K, int KB, char *FACE);
-------------------------------------------------------------------------------
()
   eLXgptHg̑ݒ肷Bgp\ȃtHg TrueType tHg
   ݁BtHg󔒂̏ꍇ̓ftH[g܂͑OgpꂽtHgg
   BtHg '*' ̏ꍇAݒ肵ŃtHg̐Ɏsꍇ
   ɂ́CtHgE_CAOĂяoB
-------------------------------------------------------------------------------
(͕ϐ)
      H = tHg̍([hWn)
          0 ̏ꍇ̓ftH[glg
          ̏ꍇ݂͌̒lg
      A = tHǧXp(deg/360Cv; |A| < 1.0)
          |A| >= 1.0 ̏ꍇ݂͌̒lg
     IO = _̈ʒuw肷
        = 0: 
        = 1:  (ftHg)
        = 2: E
        = 3: E
        = 4: 
        = 5: 
        = 6: 
        = 7: E
        = 8: 
      K = ̘_Fԍ(GWCOLOR ̍Q)
          -1 ̏ꍇ͌ݒlg
     KB = ̔wiF̘_Fԍ(GWCOLOR ̍Q)
          -1 ̏ꍇ͌ݒlg
        = -100: (default)
   FACE = TrueType tHg
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Text Font Attributes
*******************************************************************************
[F] SUBROUTINE GWSETTXT(IRTN, H, A, IO, K, KB, FACE)
    INTEGER IRTN, IO, K, KB
    REAL H, A
    CHARACTER FACE*(*)

[C] int GWsettxt(float H, float A, int IO, int K, int KB, char *FACE);
-------------------------------------------------------------------------------
Description
   Set attributes for the current text font.   Only a face name of an installed 
   TrueType font can be specified to the input parameter FACE.  When a space is 
   specified to the string variable FACE the face name of the current text font 
   is not changed.   If failed to create a font using the specified parameters, 
   or FACE is set as '*', a font dialog is used to create the current text font.

Input
    H > 0: height in world coordinate system
      = 0: use default value
      < 0: not changed
    A = angle (in deg/360, counterclockwise; |A| < 1.0)
        not changed if |A| >= 1.0
   IO = set the reference point at
      = 0: center
      = 1: bottom-left (default)
      = 2: bottom-right
      = 3: top-right
      = 4: top-left
      = 5: left
      = 6: bottom
      = 7: right
      = 8: top
    K = logical color number (see GWCOLOR) for text color
      = -1: not changed
   KB = logical color number (see GWCOLOR) for text-background color
      = -1: not changed
      = -100: transparent(default)
 FACE = TrueType face name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETTXT "^";
int GWSETTXT(int *ret, float *height, float *angle, int *ref, 
				int *fgc, int *bkc, CHARACTER *face)
#else
int GWSETTXT(int *ret, float *height, float *angle, int *ref, 
				int *fgc, int *bkc, char *face, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETTXT(int *ret, float *height, float *angle, int *ref, 
				int *fgc, int *bkc, char *face, int l)
#else
int gwsettxt_(int *ret, float *height, float *angle, int *ref, 
				int *fgc, int *bkc, char *face, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWsettxt(*height, *angle, *ref, *fgc, *bkc, _copyBuff(nDOC, face->p, face->l)));
#else
	return (*ret = GWsettxt(*height, *angle, *ref, *fgc, *bkc, _copyBuff(nDOC, face, l)));
#endif
}

int GWsettxt(float h, float a, int o, int c, int b, char *face)
{
	int ia = (int)(a*IPI2), ih;

	if(h >= 0.0) 
		ih = WCtoLPh(h);
	else
		ih = -1;

	return GW_settext(nDOC, ih, ia, o, c, b, face);
}

int GW_settext(int nDoc, int h, int a, int o, int c, int b, char *face)
{
	int cf = 0;

	if(h == 0) 
		h = GW_Params(nDoc)->p.GW_Dh/LINESPERHEIGHT;
	if(h > 0 && h != GW_Params(nDoc)->p.GW_Th) {
		GW_Params(nDoc)->p.GW_Th = h;
		++cf;
	}

	if(abs(a) < IPI2) {
		if(a < 0) a += IPI2;
		if(GW_Params(nDoc)->p.GW_Ta != a) {
			GW_Params(nDoc)->p.GW_Ta = a;
			++cf;
		}
	}

	if(o > -1 && o < 9) GW_Params(nDoc)->p.GW_To = o;

	if((c != -1) && (GW_Params(nDoc)->p.GW_Tc != c)) {
		GW_Params(nDoc)->p.GW_Tc = c;
		++cf;
	}

	if(b != -1) GW_Params(nDoc)->p.GW_Tb = b;

	_setBuff(nDoc, face);
	if(face && *face) ++cf;
	return _command2(nDoc, GW_GENDOTOOL, TOOL_SETTEXT, cf);
}


/*0
TCY̎擾
*******************************************************************************
[F] SUBROUTINE GWGETTXT(IRTN, W, H, X, Y, TXT)
    INTEGER IRTN
    REAL W, H, X, Y
    CHARACTER TXT*(*)

[C] int GWgettxt(float *W, float *H, float *X, float *Y, char *TXT);
-------------------------------------------------------------------------------
()
    ̃[hWnł̕ƍ擾B
-------------------------------------------------------------------------------
(͕ϐ)
     W = ̕([hWn)
     H = ̍([hWn)
     X = _̃ItZbgXW([hWn)
     Y = _̃ItZbgYW([hWn)
   TXT = 
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Text Extent
*******************************************************************************
[F] SUBROUTINE GWGETTXT(IRTN, W, H, X, Y, TXT)
    INTEGER IRTN
    REAL W, H, X, Y
    CHARACTER TXT*(*)

[C] int GWgettxt(float *W, float *H, float *X, float *Y, char *TXT);
-------------------------------------------------------------------------------
Description
    Retrieve extent of a text string in the world coordinate.

Inget
     W = width of the string in the world coordinate
     H = height of the string in the world coordinate
     X = the world x-coordinate of the offset of the reference point
     Y = the world y-coordinate of the offset of the reference point
   TXT = string

Outget
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETTXT "^";
int GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
			  CHARACTER *text)
#else
int GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
			  char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
			  char *text, int l)
#else
int gwgettxt_(int *ret, float *w, float *h, float *x, float *y, 
			  char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWgettxt(w, h, x, y, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GWgettxt(w, h, x, y, _copyBuff(nDOC, text, l)));
#endif
}

int GWgettxt(float *w, float *h, float *x, float *y, char *txt)
{
	int u, v, ox, oy, ret;
	ret = GW_gettext(nDOC, &u, &v, &ox, &oy, txt);
	if(ret <= 0) return ret;
	if(w) *w = LPtoWCw(u);
	if(h) *h = LPtoWCh(v);
	if(x) *x = LPtoWCw(ox);
	if(y) *y = LPtoWCh(oy);
	return ret;
}

int GW_gettext(int nDoc, int *u, int *v, int *ox, int *oy, char *txt)
{
	int ret;
	_setBuff(nDoc, txt);
	ret = _command1(nDoc, GW_CMD, CMD_GETTEXTSIZE);
	if(ret <= 0) return ret;
	if(u) *u = GW_Params(nDoc)->c.i.p0;
	if(v) *v = GW_Params(nDoc)->c.i.p1;
	if(ox) *ox = GW_Params(nDoc)->c.i.p2;
	if(oy) *oy = GW_Params(nDoc)->c.i.p3;
	return nDoc;
}


/*1
(eLXg)̕`
*******************************************************************************
[F] SUBROUTINE GWPUTTXT(IRTN, X, Y, TXT)
    INTEGER IRTN
    REAL X, Y
    CHARACTER TXT*(*)

[C] int GWputtxt(float X, float Y, char *TXT);
-------------------------------------------------------------------------------
()
    OtBNXEEBhEɕo͂BtHg̎ނ GWSETTXT 
    ܂́Cj[o[ [Options] => [Font] ŕύXB͓̕eƃtH
    g̎ނɈˑ邽ߐݒłȂBႦ GWFMAX() gȂǂāC
    ̍̓_̍WɁCp (GWINDOW Q) ͈̔͂傫Oꂽ_w肷
    ƁC͂̑Ȍo͕̒ɏo͂B
-------------------------------------------------------------------------------
(͕ϐ)
     X = _ X W([hWn)
     Y = _ Y W([hWn)
   TXT = o͕
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Text String
*******************************************************************************
[F] SUBROUTINE GWPUTTXT(IRTN, X, Y, TXT)
    INTEGER IRTN
    REAL X, Y
    CHARACTER TXT*(*)

[C] int GWputtxt(float X, float Y, char *TXT);
-------------------------------------------------------------------------------
Description
    Draw a text string on the current window using the current text font.   
    Attributes of the current text font can be changed by GWSETTXT or manually 
    from [Options] -> [Font] at the menu bar.   The width of the string cannot 
    be set because it depends on the contents and the font using.   If a point 
    far outside the paper (see GWINDOW) as the bottom-left corner of the string 
    to be drawn is specified, by using GWFMAX() for example, the output string 
    follows the previous one.

Input
     X = the world x-coordinate of the reference point of the string
     Y = the world y-coordinate of the reference point of the string
   TXT = string to be drawn

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPUTTXT "^";
int GWPUTTXT(int *ret, float *x, float *y, CHARACTER *text)
#else
int GWPUTTXT(int *ret, float *x, float *y, char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPUTTXT(int *ret, float *x, float *y, char *text, int l)
#else
int gwputtxt_(int *ret, float *x, float *y, char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	char *p = _copyBuff(nDOC, text->p, text->l);
#else
	char *p = _copyBuff(nDOC, text, l);
#endif
	if((2*GW_X1  - GW_X2 - *x)*(2*GW_X2  - GW_X1 - *x) > 0
	|| (2*GW_Y1  - GW_Y2 - *y)*(2*GW_Y2  - GW_Y1 - *y) > 0)
		return (*ret = GW_puttext(nDOC, BIGXY, BIGXY, p));
	else
		return (*ret = GW_puttext(nDOC, WCtoLPx(*x), WCtoLPy(*y), p));
}

int GWputtxt(float x, float y, char *text)
{
	if((2*GW_X1  - GW_X2 - x)*(2*GW_X2  - GW_X1 - x) > 0
	|| (2*GW_Y1  - GW_Y2 - y)*(2*GW_Y2  - GW_Y1 - y) > 0)
		return GW_puttext(nDOC, BIGXY, BIGXY, text);
	else
		return GW_puttext(nDOC, WCtoLPx(x), WCtoLPy(y), text);
}

int GW_puttext(int nDoc, int x, int y, char *txt)
{
	_setBuff(nDoc, txt);
	if(_command(nDoc, GW_GENDOTOOL, TOOL_TEXT, x, y)) 
		return nDoc;
	return 0;
}


/*1
LtHg̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETSYM(IRTN, H, A, IO, K, KB, FACE)
    INTEGER IRTN, IO, K, KB
    REAL H, A
    CHARACTER FACE*(*)

[C] int GWsetsym(float H, float A, int IO, int K, int KB, char *FACE);
-------------------------------------------------------------------------------
()
   LtHg̑ݒ肷Bgp\ȃtHg TrueType tHĝ݁B
   tHg󔒂̏ꍇ̓ftH[g܂͑OgpꂽtHgg
   Bݒ肵ŃtHg̐Ɏsꍇɂ́CtHgE_CAO
   ĂяoB
-------------------------------------------------------------------------------
(͕ϐ)
    H = tHg̍([hWn)
        0 ̏ꍇ̓ftH[glg
        ̏ꍇ݂͌̒lg
    A = tHǧXp(deg/360Cv; |A| < 1.0)
        |A| >= 1.0 ̏ꍇ݂͌̒lg
   IO = _̈ʒuw肷
      = 0:  (ftHg)
      = 1: 
      = 2: E
      = 3: E
      = 4: 
      = 5: 
      = 6: 
      = 7: E
      = 8: 
    K = ̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
   KB = ̔wiF̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
      = -100: (default)
 FACE = TrueType tHg
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Symbol Font Attributes
*******************************************************************************
[F] SUBROUTINE GWSETSYM(IRTN, H, A, IO, K, KB, FACE)
    INTEGER IRTN, IO, K, KB
    REAL H, A
    CHARACTER FACE*(*)

[C] int GWsetsym(float H, float A, int IO, int K, int KB, char *FACE);
-------------------------------------------------------------------------------
Description
   Set attributes for the current symbol font.  Only a face name of an installed 
   TrueType font can be specified to the input parameter FACE.  When a space is 
   specified to the string variable FACE the face name of the current symbol font 
   is not changed.   If failed to create a font using the specified parameters, a 
   font dialog is used to create the current symbol font.  

Input
    H > 0: height in the world coordinate system
      = 0: use the default value
      < 0: not changed
    A = angle (in deg/360, counterclockwise; |A| < 1.0)
        not changed if |A| >= 1.0
   IO = set the reference point at
      = 0: center (default)
      = 1: bottom-left
      = 2: bottom-right
      = 3: top-right
      = 4: top-left
      = 5: left
      = 6: bottom
      = 7: right
      = 8: top
    K = logical color number (see GWCOLOR) for text color
      = -1: not changed
   KB = logical color number (see GWCOLOR) for text-background color
      = -1: not changed
      = -100: transparent(default)
 FACE = TrueType face name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETSYM "^";
int GWSETSYM(int *ret, float *h, float *a, int *o, int *c, int *b, CHARACTER *face)
#else
int GWSETSYM(int *ret, float *h, float *a, int *o, int *c, int *b, char *face, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETSYM(int *ret, float *h, float *a, int *o, int *c, int *b, char *face, int l)
#else
int gwsetsym_(int *ret, float *h, float *a, int *o, int *c, int *b, char *face, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWsetsym(*h, *a, *o, *c, *b, _copyBuff(nDOC, face->p, face->l)));
#else
	return (*ret = GWsetsym(*h, *a, *o, *c, *b, _copyBuff(nDOC, face, l)));
#endif
}

int GWsetsym(float h, float a, int o, int c, int b, char *face)
{
	int ia = (int)(a*IPI2), ih;

	if(h >= 0.0) 
		ih = WCtoLPh(h);
	else
		ih = -1;

	return GW_setsymbol(nDOC, ih, ia, o, c, b, face);
}

int GW_setsymbol(int nDoc, int h, int a, int o, int c, int b, char *face)
{
	int ret = 0;
	int cf = 0;

	if(h == 0) 
		h = GW_Params(nDoc)->p.GW_Dh/LINESPERHEIGHT;
	if((h > 0) && (GW_Params(nDoc)->p.GW_Sh != h)) {
		GW_Params(nDoc)->p.GW_Sh = h;
		++ret;
		++cf;
	}

	if(abs(a) < IPI2) {
		if(a < 0) a += IPI2;
		if(GW_Params(nDoc)->p.GW_Sa != a) {
			GW_Params(nDoc)->p.GW_Sa = a;
			++ret;
			++cf;
		}
	}

	if(o > -1 && o < 9) {
		GW_Params(nDoc)->p.GW_So = o;
		++ret;
	}

	if(c != -1) {
		if(GW_Params(nDoc)->p.GW_Sc != c) {
			GW_Params(nDoc)->p.GW_Sc = c;
			++cf;
		}
		++ret;
	}

	if(b != -1) {
		GW_Params(nDoc)->p.GW_Sb = b;
		++ret;
	}

	_setBuff(nDoc, face);
	if(face && *face) ++cf;
	if(ret)
		return _command2(nDoc, GW_GENDOTOOL, TOOL_SETSYMBOL, cf);
	return ret;
}


/*0
L̃TCY擾
*******************************************************************************
[F] SUBROUTINE GWGETSYM(IRTN, W, H, IC)
    INTEGER IRTN, IC
    REAL W, H

[C] int GWgetsym(float *W, float *H, int IC);
-------------------------------------------------------------------------------
()
    L̃[hWnł̕ƍ擾B
-------------------------------------------------------------------------------
(͕ϐ)
     W = L̕([hWn)
     H = L̍([hWn)
    IC = LR[h(0`255)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Symbol Extent
*******************************************************************************
[F] SUBROUTINE GWGETSYM(IRTN, W, H, IC)
    INTEGER IRTN, IC
    REAL W, H

[C] int GWgetsym(float *W, float *H, int IC);
-------------------------------------------------------------------------------
Description
    Retrieve extent of a symbol in the world coordinate.

Inget
     W = width of the symbol in the world coordinate
     H = height of the symbol in the world coordinate
    IC = symbol code (0..255)

Outget
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETSYM "^";
#endif
int GWGETSYM(int *ret, float *w, float *h, int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETSYM(int *ret, float *w, float *h, int *c)
#else
int gwgetsym_(int *ret, float *w, float *h, int *c)
#endif
#endif
{
	return (*ret = GWgetsym(w, h, *c));
}

int GWgetsym(float *w, float *h, int c)
{
	int u, v, ret;
	ret = GW_getsymbol(nDOC, &u, &v, c);
	if(w) *w = LPtoWCw(u);
	if(h) *h = LPtoWCh(v);
	return ret;
}

int GW_getsymbol(int nDoc, int *u, int *v, int c)
{
	int ret;
	ret = _command2(nDoc, GW_CMD, CMD_GETSYMBOL, c);
	if(ret <= 0) return ret;
	if(u) *u = GW_Params(nDoc)->c.i.p1;
	if(v) *v = GW_Params(nDoc)->c.i.p2;
	return nDoc;
}


/*1
L̏o
*******************************************************************************
[F] SUBROUTINE GWPUTSYM(IRTN, X, Y, IC)
    INTEGER IRTN, IC
    REAL X, Y

[C] int GWputsym(float X, float Y, int IC);
-------------------------------------------------------------------------------
()
    OtBNXEEBhEɋLo͂BL̑ GWSETSYM ܂́C
    j[o[ [Options] => [Symbol] ŕύXBftHg̋LtHgƂ
    Ă Windows TrueType tHg "WingDings" gpB
-------------------------------------------------------------------------------
(͕ϐ)
    X = L̒S_ X W([hWn)
    Y = L̒S_ Y W([hWn)
   IC = LR[h(0`255)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Symbol
*******************************************************************************
[F] SUBROUTINE GWPUTSYM(IRTN, X, Y, IC)
    INTEGER IRTN, IC
    REAL X, Y

[C] int GWputsym(float X, float Y, int IC);
-------------------------------------------------------------------------------
Description
    Draw a symbol character on the current window using the current symbol font.   
    Attributes of the current symbol font can be changed by GWSETSYM or manually 
    from [Options] -> [Symbol] at the menu bar.   On default the face name is 
    assumed to be "WingDings".   The attributes of the current symbol font are 
    not changed.

Input
    X = the world x-coordinate of the center of the symbol
    Y = the world y-coordinate of the center of the symbol
   IC = symbol code (0..255)

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPUTSYM "^";
#endif
int GWPUTSYM(int *ret, float *x, float *y, int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPUTSYM(int *ret, float *x, float *y, int *c)
#else
int gwputsym_(int *ret, float *x, float *y, int *c)
#endif
#endif
{
	return (*ret = GWputsym(*x, *y, *c));
}

int GWputsym(float x, float y, int c)
{
	return GW_putsymbol(nDOC, WCtoLPx(x), WCtoLPy(y), c);
}

int GW_putsymbol(int nDoc, int x, int y, int c)
{
	if(c < 0)
		c = GW_Params(nDoc)->p.GW_Sn;
	else
		GW_Params(nDoc)->p.GW_Sn = c;

	GW_Params(nDoc)->Work.Buffer[0] = (char)c;
	if(_command(nDoc, GW_GENDOTOOL, TOOL_SYMBOL, x, y)) 
		return nDoc;
	return 0;
}


/*0
bZ[W̕\
*******************************************************************************
[F] SUBROUTINE GWSETMSG(IRTN, TXT)
    INTEGER IRTN
    CHARACTER TXT*(*)

[C] int GWsetmsg(char *TXT);
-------------------------------------------------------------------------------
()
    Xe[^Xo[ɃbZ[W\B
-------------------------------------------------------------------------------
(͕ϐ)
   TXT = bZ[W̕
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Status Bar
*******************************************************************************
[F] SUBROUTINE GWSETMSG(IRTN, TXT)
    INTEGER IRTN
    CHARACTER TXT*(*)

[C] int GWsetmsg(char *TXT);
-------------------------------------------------------------------------------
Description
    Display a text string at the status bar.

Input
   TXT = string to be displayed

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETMSG "^";
int GWSETMSG(int *ret, CHARACTER *text)
#else
int GWSETMSG(int *ret, char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETMSG(int *ret, char *text, int l)
#else
int gwsetmsg_(int *ret, char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_setmsg(nDOC, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GW_setmsg(nDOC, _copyBuff(nDOC, text, l)));
#endif
}

int GWsetmsg(char *text)
{
	return GW_setmsg(nDOC, text);
}

int GW_setmsg(int nDoc, char *txt)
{
	_setBuff(nDoc, txt);
	if(_command1(nDoc, GW_CMD, CMD_STATUSBAR)) 
		return nDoc;
	return 0;
}


/*0
bZ[W{bNX
*******************************************************************************
[F] INTEGER FUNCTION MSGBOX(TXT)
    CHARACTER TXT*(*)

[C] int GWmsgbox(char *TXT);
-------------------------------------------------------------------------------
()
    bZ[W{bNX\Cǂ̃{^ꂽ̒l𓾂B
-------------------------------------------------------------------------------
(͕ϐ)
   TXT = bZ[W̕
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    1: YES {^ꂽꍇ
   -1: NO {^ꂽꍇ
    0: ̑
_______________________________________________________________________________
*/
/*E
Message Box
*******************************************************************************
[F] INTEGER FUNCTION MSGBOX(TXT)
    CHARACTER TXT*(*)

[C] int GWmsgbox(char *TXT);
-------------------------------------------------------------------------------
Description
    Popup a message box, and get the ending status of the selected button.

Input
   TXT = string to be displayed in the message box

Output
   None

Return value
    1: YES button was selected
   -1: NO button was selected
    0: otherwise
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux MSGBOX "^";
int MSGBOX(CHARACTER *text)
#else
int MSGBOX(char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall MSGBOX(char *text, int l)
#else
int msgbox_(char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return GW_msgbox(nDOC, _copyBuff(nDOC, text->p, text->l));
#else
	return GW_msgbox(nDOC, _copyBuff(nDOC, text, l));
#endif
}

int GWmsgbox(char *text)
{
	return GW_msgbox(nDOC, text);
}

int GW_msgbox(int nDoc, char *txt)
{
	_setBuff(nDoc, txt);
	if(!_command2(nDoc, GW_CMD, CMD_MESSAGEBOX, 0))
		return 0;
	switch(GW_Params(nDoc)->c.i.p0) {
	case IDYES:
		return 1;
	case IDNO:
		return -1;
	default:
		return 0;
	}
}
