/* RGB.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

int SysColor[] = {
	COLOR_SCROLLBAR,           // 0
	COLOR_BACKGROUND,          // 1
	COLOR_ACTIVECAPTION,       // 2
	COLOR_INACTIVECAPTION,     // 3
	COLOR_MENU,                // 4
	COLOR_WINDOW,              // 5
	COLOR_WINDOWFRAME,         // 6
	COLOR_MENUTEXT,            // 7
	COLOR_WINDOWTEXT,          // 8
	COLOR_CAPTIONTEXT,         // 9
	COLOR_ACTIVEBORDER,        // 10
	COLOR_INACTIVEBORDER,      // 11
	COLOR_APPWORKSPACE,        // 12
	COLOR_HIGHLIGHT,           // 13
	COLOR_HIGHLIGHTTEXT,       // 14
	COLOR_BTNFACE,             // 15
	COLOR_BTNSHADOW,           // 16
	COLOR_GRAYTEXT,            // 17
	COLOR_BTNTEXT,             // 18
	COLOR_INACTIVECAPTIONTEXT, // 19
	COLOR_BTNHIGHLIGHT         // 20
};

/*1
sNZ̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETPXL(IRTN, X, Y, K)
    INTEGER IRTN, K
    REAL X, Y

[C] int GWsetpxl(float X, float Y, int K);
-------------------------------------------------------------------------------
()
    (X,Y) Ŏw肳ꂽ_̃sNZɘ_Fԍ (GWCOLOR Q) ݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   X = _ X W([hWn)
   Y = _ Y W([hWn)
   K = _Fԍ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Pixel
*******************************************************************************
[F] SUBROUTINE GWSETPXL(IRTN, X, Y, K)
    INTEGER IRTN, K
    REAL X, Y

[C] int GWsetpxl(float X, float Y, int K);
-------------------------------------------------------------------------------
Description
    Set the logical color value to the pixel at the point specified by x and y.

Input
   X = the world x-coordinate of the point
   Y = the world y-coordinate of the point
   K = the logical color value

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETPXL "^";
#endif
int GWSETPXL(int *ret, float *x, float *y, int *k)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETPXL(int *ret, float *x, float *y, int *k)
#else
int gwsetpxl_(int *ret, float *x, float *y, int *k)
#endif
#endif
{
	return (*ret = GW_setpixel(nDOC, WCtoLPx(*x), WCtoLPy(*y), *k));
}

int GWsetpxl(float x, float y, int k)
{
	return GW_setpixel(nDOC, WCtoLPx(x), WCtoLPy(y), k);
}

int GW_setpixel(int nDoc, int x, int y, int k)
{
	GW_Params(nDoc)->c.i.p0 = k;
	if(_command(nDoc, GW_GENDOTOOL, TOOL_PIXEL, x, y))
			return nDoc;
	return 0;
}


/*0
sNZ̘_Fԍ̎擾
*******************************************************************************
[F] SUBROUTINE GWGETPXL(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWgetpxl(float X, float Y);
-------------------------------------------------------------------------------
()
    (X,Y) Ŏw肳ꂽ_̘_Fԍ (GWCOLOR Q) 擾B
-------------------------------------------------------------------------------
(͕ϐ)
   X = _ X W([hWn)
   Y = _ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = _Fԍ (ꍇ)
      = -1 (s̏ꍇ)
_______________________________________________________________________________
*/
/*E
Get Pixel
*******************************************************************************
[F] SUBROUTINE GWGETPXL(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWgetpxl(float X, float Y);
-------------------------------------------------------------------------------
Description
    Retrieve the logical color value of the pixel at the point specified by x 
    and y.

Input
   X = the world x-coordinate of the point
   Y = the world y-coordinate of the point

Output
 IRTN = the logical color value (if succeeded)
      = -1 (if failed)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETPXL "^";
#endif
int GWGETPXL(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETPXL(int *ret, float *x, float *y)
#else
int gwgetpxl_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GW_getpixel(nDOC, WCtoLPx(*x), WCtoLPy(*y)));
}

int GWgetpxl(float x, float y)
{
	return GW_getpixel(nDOC, WCtoLPx(x), WCtoLPy(y));
}

int GW_getpixel(int nDoc, int x, int y)
{
	if(_command2(nDoc, GW_PIXEL, x, y))
		return GW_Params(nDoc)->c.i.p0;
	return -1;
}


/*1
F̐ݒ
*******************************************************************************
[F] SUBROUTINE GWCOLOR(IRTN, K, IDST)
    INTEGER IRTN, K, IDST

[C] int GWcolor(int K, int IDST);
-------------------------------------------------------------------------------
()
   _Fԍ K Ŏw肳ꂽF IDST ɐݒ肷BK = -1 ̏ꍇ́uF̐ݒv_
   CAO{bNXőI΂ꂽFݒ肳B_FԍƂ́Cȉɒ`Ă
   eFɑΉÂꂽԍ̂ƁB

    m_Fԍn: Ӗ
            0..19 : Windows Wpbg
                0 : 
                1 : IF
                2 : Â
                3 : I[u
                4 : Z
                5 : 
                6 : ΐ
                7 : DF
                8 : 邢
                9 : F
               10 : DF
               11 : DF
               12 : ZDF
               13 : 
               14 : 
               15 : 
               16 : 
               17 : Ԏ
               18 : F
               19 : 
           20..35 : uF̐ݒv_CAO{bNX́u쐬Fv(0..15)
    0x02000000
     ..0x02ffffff :   COLORREF l
               -1 : uF̐ݒv_CAO{bNXőIꂽF
               -2 : ݂̑OiF
               -3 : ݂̔wiF
               -4 : ݂̃y̐F
               -5 : ݂̃uV̐F
               -6 : ݂̃}[N̐F
               -7 : ݂̃}[N̔wiF
               -8 : ݂̃eLXg̐F
               -9 : ݂̃eLXg̔wiF
              -10 : ݂̋L̐F
              -11 : ݂̋L̔wiF
              -12 : ݂̃sNZF
             -100 :  (wiFp)
           ̑ : uF̐ݒv_CAO{bNXőIꂽF
-------------------------------------------------------------------------------
(͕ϐ)
       K = _Fԍ
    IDST = ݒ
           1: OiF
           2: wiF
           3: y̐F
           4: uV̐F
           5: }[N̐F
           6: }[N̔wiF
           7: eLXg̐F
           8: eLXg̔wiF
           9: L̐F
          10: L̔wiF
          11: sNZF
      20..35: uF̐ݒv_CAO{bNX́u쐬Fv(0..15)
      ̑: ݒ肵Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Color
*******************************************************************************
[F] SUBROUTINE GWCOLOR(IRTN, K, IDST)
    INTEGER IRTN, K, IDST

[C] int GWcolor(int K, int IDST);
-------------------------------------------------------------------------------
Description
   Set a color specified by the logical color value (LCV) K to the destination 
   IDST.  When K = -1 a color-selection dialog box is popped up, and the 
   selected color is set to the destination.  The LCV's are defined as follows:

            0..19 : reserved by Windows
                0 : black
                1 : dark red
                2 : dark green
                3 : dark yellow
                4 : dark blue
                5 : dark magenta
                6 : dark cyan
                7 : light gray
                8 : money green
                9 : sky blue
               10 : cream
               11 : medium gray
               12 : dark gray
               13 : red
               14 : green
               15 : yellow
               16 : blue
               17 : magenta
               18 : cyan
               19 : white
           20..35 : custom colors made by a color-selection dialog box, which 
                    can be popped up from [Options] -> [Color] at the menu bar.
    0x02000000
     ..0x02ffffff : palette-relative RGB specifiers ("PALETTERGB[W]")
               -1 : color specified by a color-selection dialog box
               -2 : current foreground color
               -3 : current background color
               -4 : current pen color
               -5 : current brush color
               -6 : current mark color
               -7 : current mark-background color
               -8 : current text color
               -9 : current text-background color
              -10 : current symbol color
              -11 : current symbol-background color
              -12 : current pixel color
             -100 : transparent (for background colors)
           others : color specified by a color-selection dialog box

Input
       K = logical color value (LCV)
    IDST = destination
           1: foreground color
           2: background color
           3: pen color
           4: brush color
           5: mark color
           6: mark-background color
           7: text color
           8: text-background color
           9: symbol color
          10: symbol-background color
          11: pixel color
      20..35: custom colors (0..15)
      others: neglected

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCOLOR "^";
#endif
int GWCOLOR(int *ret, int *k, int *dest)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCOLOR(int *ret, int *k, int *dest)
#else
int gwcolor_(int *ret, int *k, int *dest)
#endif
#endif
{
	return (*ret = GWcolor(*k, *dest));
}

int GWcolor(int k, int dest)
{
	return GW_color(nDOC, k, dest);
}

int GW_color(int nDoc, int k, int dest)
{
	return _command(nDoc, GW_GENDOTOOL, TOOL_SETCOLOR, k, dest);
//	return _command(nDoc, GW_CMD, CMD_SETCOLOR, k, dest);
}


/*0
_FԍRGB(OF)ɕϊ
*******************************************************************************
[F] SUBROUTINE GWGETRGB(IRTN, K, IR, IG, IB)
    INTEGER IRTN, K, IR, IG, IB

[C] int GWgetrgb(int K, int *IR, int *IG, int *IB);
-------------------------------------------------------------------------------
()
    _Fԍ K OF (IR,IG,IB) ɕϊB
-------------------------------------------------------------------------------
(͕ϐ)
    K = _Fԍ
-------------------------------------------------------------------------------
(o͕ϐ)
   IR = F RED   (0-255)
   IG = F GREEN (0-255)
   IB = F BLUE  (0-255)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get RGB
*******************************************************************************
[F] SUBROUTINE GWGETRGB(IRTN, K, IR, IG, IB)
    INTEGER IRTN, K, IR, IG, IB

[C] int GWgetrgb(int K, int *IR, int *IG, int *IB);
-------------------------------------------------------------------------------
Description
    Translate a logical color value to RGB.

Input
    K = the logical color value

Output
   IR = the intensity of the red color (0-255).
   IG = the intensity of the green color (0-255).
   IB = the intensity of the blue color (0-255).
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETRGB "^";
#endif
int GWGETRGB(int *ret, int *k, int *r, int *g, int *b)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETRGB(int *ret, int *k, int *r, int *g, int *b)
#else
int gwgetrgb_(int *ret, int *k, int *r, int *g, int *b)
#endif
#endif
{
	return (*ret = GW_getrgb(nDOC, *k, r, g, b));
}

int GWgetrgb(int k, int *r, int *g, int *b)
{
	return GW_getrgb(nDOC, k, r, g, b);
}

int GW_getrgb(int nDoc, int k, int *r, int *g, int *b)
{
	if(!_command2(nDoc, GW_CMD, CMD_GETRGB, k))
		return 0;

	k = GW_Params(nDoc)->y;
	GW_asgn(b, k%256);
	k /= 256;
	GW_asgn(g, k%256);
	k /= 256;
	GW_asgn(r, k);
	if(k < 256)
		return nDoc;
	return 0;
}


/*0
RGB(OF)_Fԍւ̕ϊ
*******************************************************************************
[F] INTEGER FUNCTION KRGB(IR, IG, IB)
    INTEGER IR, IG, IB

[C] int GWkrgb(int IR, int IG, int IB);
-------------------------------------------------------------------------------
()
   GWSETPEN  GWSETBRS ȂǁC_Fԍ̎w肪KvȏꍇɁCOF(IR,IG,IB)
   疾IɐFꍇɗpBIR,IG,IB ׂ̂Ă 0 ` 255 ͈̔
   ɂꍇɂ͑Ή_FԍԂ,ȊȌꍇɂ́uF̐ݒv_CA
   O{bNXJ߂̔ԍԂB_Fԍɂďڂ GWCOLOR ̍Q
   ƁB
-------------------------------------------------------------------------------
(͕ϐ)
  IR = F RED   (0-255)
  IG = F GREEN (0-255)
  IB = F BLUE  (0-255)
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    _Fԍ( GWCOLOR Q)
_______________________________________________________________________________
*/
/*E
Set RGB
*******************************************************************************
[F] INTEGER FUNCTION KRGB(IR, IG, IB)
    INTEGER IR, IG, IB

[C] int GWkrgb(int IR, int IG, int IB);
-------------------------------------------------------------------------------
Description
   Translate the RGB value specified by (IR, IG, IB) into the corresponding 
   logical color value.   This may be used, for example, GWSETPEN and GWSETBRS, 
   which require logical color values as an input parameter.   The logical 
   color value is an internal representation of colors in the GrWin Library 
   (see GWCOLOR).

Input
  IR = the intensity of the red color (0-255).
  IG = the intensity of the green color (0-255).
  IB = the intensity of the blue color (0-255).

Output
   None

Return value
    the resultant logical color value (see GWCOLOR)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux KRGB "^";
#endif
int KRGB(int *r, int *g, int *b)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall KRGB(int *r, int *g, int *b)
#else
int krgb_(int *r, int *g, int *b)
#endif
#endif
{
	return GW_krgb(*r, *g, *b);
}

int GWkrgb(int r, int g, int b)
{
	return GW_krgb(r, g, b);
}

int GW_krgb(int r, int g, int b)
{
	if((r < 0) || (r > 255) || (g < 0) || (g > 255) || (b < 0) || (b > 255))
		return -999;		// to call dialog box
	return PALETTERGB(r,g,b);
}


/*0
 COLORREF l_Fԍւ̕ϊ
*******************************************************************************
[F] INTEGER FUNCTION KCOLOR(IC)
    INTEGER IC

[C] int GWkcolor(int IC);
-------------------------------------------------------------------------------
()
   COLORREF l_Fԍɕϊ邽߂ɎgpBCOLORREF lƂ Windows 
   gpĂCF̓\̂ƁBڂ́CWindows ֌W̎QƁB
-------------------------------------------------------------------------------
(͕ϐ)
  IC = F COLORREF l
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    _Fԍ( GWCOLOR Q)
_______________________________________________________________________________
*/
/*E
Get COLORREF value
*******************************************************************************
[F] INTEGER FUNCTION KCOLOR(IC)
    INTEGER IC

[C] int GWkcolor(int IC);
-------------------------------------------------------------------------------
Description
   Translate the COLORREF value specified by IC into the corresponding logical 
   color value.   COLORREF is 32-bit values used as color values in Windows, 
   in the following hexadecimal form as 0x00bbggrr, where 0xbb, 0xgg and 0xrr 
   are intensities of the blue, green and red colors, respectively.   The 
   logical color value is an internal representation of colors in the GrWin 
   Library (see GWCOLOR).

Input
  IC = COLORREF value to be transformed

Output
   None

Return value
    the resultant logical color value (see GWCOLOR)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux KCOLOR "^";
#endif
int KCOLOR(int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall KCOLOR(int *c)
#else
int kcolor_(int *c)
#endif
#endif
{
	return GW_kcolor(*c);
}

int GWkcolor(int c)
{
	return GW_kcolor(c);
}

int GW_kcolor(int c)
{
	if(c < 0)
		return -999;		// to call dialog box
	return ((c & 0x00ffffff) | 0x02000000);
}


/*0
Windows pbgԍ_Fԍւ̕ϊ
*******************************************************************************
[F] INTEGER FUNCTION IPALETTE(IP)
    INTEGER IP

[C] int GWipalette(int IP);
-------------------------------------------------------------------------------
()
   GWSETPEN  GWSETBRS ȂǁC_Fԍ̎w肪KvȏꍇɁCWindows pbg
   ԍ_Fԍɕϊ邽߂ɎgpBIɂ PALETTEINDEX }N [W] 
    call ĂDCfbNXl IP > 19  Windows pbgpł邩
   ǂ͎gpĂfBXvCJ[hȂǃVXeɈˑ̂ŒӁB
-------------------------------------------------------------------------------
(͕ϐ)
  IP = FWindows pbgԍ (0..255)
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    _Fԍ( GWCOLOR Q)
_______________________________________________________________________________
*/
/*E
Windows Palette
*******************************************************************************
[F] INTEGER FUNCTION IPALETTE(IP)
    INTEGER IP

[C] int GWipalette(int IP);
-------------------------------------------------------------------------------
Description
   Translate an index IP to a logical-color palette entry on Windows into the 
   corresponding logical color value.   This may be used, for example, GWSETPEN 
   and GWSETBRS, which require logical color values as an input parameter.   
   The logical color value is an internal representation of colors in the GrWin 
   Library (see GWCOLOR). 

Input
  IP = Windows palette number (0..255)

Output
   None

Return value
    the resultant logical color value (see GWCOLOR)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux IPALETTE "^";
#endif
int IPALETTE(int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall IPALETTE(int *c)
#else
int ipalette_(int *c)
#endif
#endif
{
	return GW_ipalette(*c);
}

int GWipalette(int c)
{
	return GW_ipalette(c);
}

int GW_ipalette(int c)
{
	if((c < 0) || (c >= 256))
		return -999;		// to call dialog box
	return PALETTEINDEX(c);
}


/*0
p\ȐFpbg̎擾
*******************************************************************************
[F] SUBROUTINE GWNCOLOR(IRTN)
    INTEGER IRTN

[C] int GWncolor(void);
-------------------------------------------------------------------------------
()
   p\ȐFpbg = (ŏIpbgԍ{P) 擾B̃o[W
   ͗p\ȐFpbg 36 ŌŒBpbgԍ 0..19  Windows ̕WF
   pbgŁCݒl͕ύXłȂ(0 = , 19 = )Bpbgԍ 20..35 ͐F
   ̐ݒv_CAO{bNXŕύX(GWCOLOR ̍Q)B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = 36 = (ŏIpbgԍ{P)
_______________________________________________________________________________
*/
/*E
Get Palette Number
*******************************************************************************
[F] SUBROUTINE GWNCOLOR(IRTN)
    INTEGER IRTN

[C] int GWncolor(void);
-------------------------------------------------------------------------------
Description
   Get the number of pallets available.  In the current version of the GrWin 
   library this value is set fixed as 36.   The palette numbers 0..19 are 
   reserved for the Windows (see GWCOLOR) and 0 for the black and 19 for the 
   white.   The palette numbers 20..35 are reserved for the custom colors, 
   which can be made by a color-selection dialog box popped up from [Options] 
   -> [Color] at the menu bar.  

Input
   None

Output
   IRTN = 36
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWNCOLOR "^";
#endif
int GWNCOLOR(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWNCOLOR(int *ret)
#else
int gwncolor_(int *ret)
#endif
#endif
{
	return (*ret = NCOLOR - 1);
}

int GWncolor(void)
{
	return (NCOLOR - 1);
}


/*0
JX^J[̕ۑ
*******************************************************************************
[F] SUBROUTINE GWSAVECC(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWsavecc(char *FN);
-------------------------------------------------------------------------------
()
   JX^J[t@CɕۑB
-------------------------------------------------------------------------------
(͕ϐ)
  FN = t@C
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Save Custom Color
*******************************************************************************
[F] SUBROUTINE GWSAVECC(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWsavecc(char *FN);
-------------------------------------------------------------------------------
Description
   Save the Windows custom color table into a file

Input
  FN = file name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVECC "^";
int GWSAVECC(int *ret, CHARACTER *fname)
#else
int GWSAVECC(int *ret, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVECC(int *ret, char *fname, int l)
#else
int gwsavecc_(int *ret, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWsavecc(_copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GWsavecc(_copyBuff(nDOC, fname, l)));
#endif
}

int GWsavecc(char *fname)
{
	if(_setBuff(nDOC, fname) == 0) _setBuff(nDOC, "*.clr");
	if(_command1(nDOC, GW_CMD, CMD_FILE_DIALOG) != IDOK)
		return 0;
	return GW_savecc(nDOC, GW_pBuffer);
}

int GW_savecc(int nDoc, char *fname)
{
	FILE* ofile;
	int i, r, g, b;
	if(fname && (ofile = fopen(fname, "w"))) {
		for(i = 0; i < 16; ++i) {
			GW_getrgb(nDoc, i+20, &r, &g, &b);
#if defined(__MINGW32__) || defined(_UWIN) || (defined(__CYGWIN32__) && defined(IMAGE_SIZEOF_FILE_HEADER))		// Cygb20
			fprintf(ofile, "0x%8.8lx\n", RGB(r, g, b));
#else
			fprintf(ofile, "0x%8.8x\n", RGB(r, g, b));
#endif
		}
		return i;
	}
	return 0;
}


/*0
JX^J[̕
*******************************************************************************
[F] SUBROUTINE GWLOADCC(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWloadcc(char *FN);
-------------------------------------------------------------------------------
()
   JX^J[t@C畜BJX^J[i[Ăt@C
   ̏́Cesɂ COLORREF l 0x02XXXXXX ̌`Ŏw肵 16 s
   Ȃ(XXXXXX  16 i 6 )BGWSAVECC ō쐬̂͂̂܂ܓǂނƂ
   B
-------------------------------------------------------------------------------
(͕ϐ)
  FN = t@C
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Load Custom Color
*******************************************************************************
[F] SUBROUTINE GWLOADCC(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWloadcc(char *FN);
-------------------------------------------------------------------------------
Description
   Restore the Windows custom color table from a file.   The file consists of 
   16 lines, and each line has the form of "0x02bbggrr" as a string, where 
   0x00bbggrr is the COLORREF value of the entry.   Any file created with 
   GWSAVECC can be loaded as is by this routine.

Input
  FN = file name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLOADCC "^";
int GWLOADCC(int *ret, CHARACTER *fname)
#else
int GWLOADCC(int *ret, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLOADCC(int *ret, char *fname, int l)
#else
int gwloadcc_(int *ret, char *fname, int l)
#endif
#endif
{
	FILE *fp;
#ifdef __WATCOMC__
	if(!_copyBuff(nDOC, fname->p, fname->l)) _setBuff(nDOC, "*.clr");
#else
	if(!_copyBuff(nDOC, fname, l)) _setBuff(nDOC, "*.clr");
#endif
	if((fp = fopen(GW_pBuffer, "r"))) {
		fclose(fp);
	} else {
		if(_command1(nDOC, GW_CMD, CMD_FILE_DIALOG) != IDOK)
			return (*ret = 0);
	}
	return (*ret = GW_loadcc(nDOC, GW_pBuffer));
}

int GWloadcc(char *fname)
{
	FILE *fp;
	if(_setBuff(nDOC, fname) == 0) _setBuff(nDOC, "*.clr");
	if((fp = fopen(GW_pBuffer, "r"))) {
		fclose(fp);
	} else {
		if(_command1(nDOC, GW_CMD, CMD_FILE_DIALOG) != IDOK)
			return 0;
	}
	return GW_loadcc(nDOC, GW_pBuffer);
}

int GW_loadcc(int nDoc, char *fname)
{
	FILE* ifile;
	int i;
	COLORREF c;
	if(fname && (ifile = fopen(fname, "r"))) {
		for(i = 0; i < 16; ++i) {
			fscanf(ifile, "%x\n", (int*)&c);
			GW_color(nDoc, ((c & 0x00ffffff) | 0x02000000), i+20);
		}
		return i;
	}
	return 0;
}


/*0
VXeɐݒ肳ĂF̎擾
*******************************************************************************
[F] SUBROUTINE GWSYSCLR(IRTN, IDX)
    INTEGER IRTN, IDX

[C] int GWsysclr(int IDX);
-------------------------------------------------------------------------------
()
   IDX Ŏw肳ꂽF (CORORREF l) 擾Bڂ Win32 API ɂ
   ̐鎑ŁC GetSysColor() ̍ڂQƂĂB
-------------------------------------------------------------------------------
(͕ϐ)
  IDX = 0: SCROLLBAR
        1: BACKGROUND
        2: ACTIVECAPTION
        3: INACTIVECAPTION
        4: MENU
        5: WINDOW
        6: WINDOWFRAME
        7: MENUTEXT
        8: WINDOWTEXT
        9: CAPTIONTEXT
       10: ACTIVEBORDER
       11: INACTIVEBORDER
       12: APPWORKSPACE
       13: HIGHLIGHT
       14: HIGHLIGHTTEXT
       15: BTNFACE
       16: BTNSHADOW
       17: GRAYTEXT
       18: BTNTEXT
       19: INACTIVECAPTIONTEXT
       20: BTNHIGHLIGHT

-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = CORORREF l (Windows ֌W̎Q)
_______________________________________________________________________________
*/
/*E
Get System Color
*******************************************************************************
[F] SUBROUTINE GWSYSCLR(IRTN, IDX)
    INTEGER IRTN, IDX

[C] int GWsysclr(int IDX);
-------------------------------------------------------------------------------
Description
   Get system color information specified.   To know details of the system 
   color, refer to documents about GetSysColor() of Win32 API.

Input
  IDX = 0: SCROLLBAR
        1: BACKGROUND
        2: ACTIVECAPTION
        3: INACTIVECAPTION
        4: MENU
        5: WINDOW
        6: WINDOWFRAME
        7: MENUTEXT
        8: WINDOWTEXT
        9: CAPTIONTEXT
       10: ACTIVEBORDER
       11: INACTIVEBORDER
       12: APPWORKSPACE
       13: HIGHLIGHT
       14: HIGHLIGHTTEXT
       15: BTNFACE
       16: BTNSHADOW
       17: GRAYTEXT
       18: BTNTEXT
       19: INACTIVECAPTIONTEXT
       20: BTNHIGHLIGHT

Output
  IRTN = CORORREF values (Windows)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSYSCLR "^";
#endif
int GWSYSCLR(int *ret, int *index)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSYSCLR(int *ret, int *index)
#else
int gwsysclr_(int *ret, int *index)
#endif
#endif
{
	return (*ret = GW_syscolor(*index));
}

int GWsysclr(int index)
{
	return GW_syscolor(index);
}

COLORREF GW_syscolor(int nindex)
{
	return GetSysColor(SysColor[nindex]);
}
