/* Misc.c
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*0
eTCY̎擾/ݒ
*******************************************************************************
[F] SUBROUTINE GWSIZE(IRTN, N, IW, IH)
    INTEGER IRTN, N, IX, IY

[C] int GWsize(int N, int *IW, int *IH);
-------------------------------------------------------------------------------
()
    eTCYʒu̎擾^ݒsBCN > 0 ̏ꍇ͎擾CN < 0 ̏
    ͐ݒsBĈڂ͕ύXłȂBt[ETCY
    ݒ莞 IW = IH = 0 w肷ƌ݂̃EBhEɃt[tBbg
    Beʒu͎w肵EBhE̍́CΉeEBhE̍
    ΍WBʃTCŶ݂́CGWOPEN(X)  GWINIT(X) ̌Ăяoɂ
    {CȕOɂ擾łB
-------------------------------------------------------------------------------
(͕ϐ)
  |N| = 1: upvTCY (sNZ)
       *2:  ʃTCY (sNZ)
        3:  t[(g)ETCY (sNZ)
        4:  t[(g)ʒu (sNZ) / ʓ
        5:  EBhEir[jETCY (sNZ)
        6:  EBhEir[jʒu (sNZ) / t[
        7:  r[|[gETCY (sNZ)
        8:  r[|[gʒu (sNZ) / r[
        9:  ftHǵupvTCY (sNZ)
       10:  Ȃǂɉ肳𑜓x (DPI)
       11:  ̃}[W (0.1 mm P)
      *12:  v^̗pTCY (0.1 mm P)
      *13:  v^̉𑜓x (DPI)
     > 13:  `
(͕ϐ: N < 0 ̏ꍇ)
    IW = 
    IH = 
-------------------------------------------------------------------------------
(o͕ϐ: N > 0 ̏ꍇ)
    IW = 
    IH = 
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get/Set Size
*******************************************************************************
[F] SUBROUTINE GWSIZE(IRTN, N, IW, IH)
    INTEGER IRTN, N, IX, IY

[C] int GWsize(int N, int *IW, int *IH);
-------------------------------------------------------------------------------
Description
   Gets a size or a position if N > 0, or set a size or a position if N < 0.  
   The item(s) marked with '*' cannot be set to change.  If IW = 0 or IH = 0 is 
   specified in setting the current frame size (N = 3) the frame fits the view. 
   Each position is the set of the relative coordinates of the top-left corner 
   of the specified window measured from the top-left corner of its parent 
   window.  Only the size of the display surface (N = 2) can be retrieved before 
   the initialization of the library, say a call to GWOPEN or GWINIT.

Input
    N = 1:  the current `paper' size (in pixels).
       *2:  the size of the display surface (in pixels).
        3:  the current size of the frame (in pixels).
        4:  the current position of the frame (in pixels) on the display.
        5:  the current size of the view (in pixels).
        6:  the current position of the view (in pixels) in the parent frame.
        7:  the current view port size (in pixels).
        8:  the current view port position (in pixels) in the parent view.
        9:  the default `paper' size (in pixels).
       10:  the resolution assumed in printing, etc. (in dpi).
       11:  the current margin in printing (in 0.1 mm).
      *12:  the paper size for a working printer (in 0.1 mm), if any.
      *13:  the resolution (in dpi) for a working printer, if any.
     > 13:  not defined

Input (when N < 0)
    IW = Width
    IH = Height

Output (when N > 0)
    IW = Width
    IH = Height
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSIZE "^";
#endif
int GWSIZE(int *ret, int *n, int *w, int *h)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSIZE(int *ret, int *n, int *w, int *h)
#else
int gwsize_(int *ret, int *n, int *w, int *h)
#endif
#endif
{
	return (*ret = GW_wsize(nDOC, *n, w, h));
}

int GWsize(int n, int *w, int *h)
{
	return GW_wsize(nDOC, n, w, h);
}


/*0
AXyNg̎擾
*******************************************************************************
[F] REAL FUNCTION GWASPECT(N)

[C] float GWaspect(int N);
-------------------------------------------------------------------------------
()
   eAXyNg擾BႦ, [rbg}bv] ܂ [I]̃r[E
   [hŐ^~`ɂ́C, AR = GWASPECT(-1) ƂƁCc([h
   Wn) 1:AR ̑ȉ~`ΗǂB
-------------------------------------------------------------------------------
(͕ϐ)
    N = AXyNg̎
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    N = 1:  ݒ肳ĂupvTCỸAXyNg
        2:  EBhEETCỸAXyNg
        3:  t[(g)ETCỸAXyNg
        4:  ʃTCỸAXyNg
        5:  v^̉𑜓x(DPI)̃AXyNg
        6:  v^̗pTCỸAXyNg
        7:  ݂̃r[|[gETCY(sNZl)̃AXyNg
   ̑:  ^~(␳`)`߂̃AXyNg
   ܂́CG[ER[h ( <= 0 )
_______________________________________________________________________________
*/
/*E
Get Aspect Ratio
*******************************************************************************
[F] REAL FUNCTION GWASPECT(N)

[C] float GWaspect(int N);
-------------------------------------------------------------------------------
Description
   Get aspect ratios defined as ratios of the width and the height of 
   rectangles.  To draw a circle, not an ellipse, in [Bitmap] or [Isotropic] 
   display mode draw an ellipse with a bounding rectangle with the ratio 
   obtained by GWASPECT(-1) in the world coordinate system (WCS), for example.

Input
   N = sort of aspect ratio

Output
  None

Return value
  If N = 1:  the aspect ratio of the `paper' size (in pixels).
         2:  the aspect ratio of the current size of the view (in pixels).
         3:  the aspect ratio of the current size of the frame (in pixels).
         4:  the aspect ratio of the size of the display surface (in pixels).
         5:  the aspect ratio of the resolution (in dpi) of a working printer.
         6:  the aspect ratio of the paper size of a working printer (in pixels).
         7:  the aspect ratio of the current view port size (in pixels).
 otherwise:  the aspect ratio needed to draw a circle (in WCS).
 
 On error an error code ( <= 0 ) is returned.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWASPECT "^";
#endif
float GWASPECT(int *n)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
float __stdcall GWASPECT(int *n)
#else
float gwaspect_(int *n)
#endif
#endif
{
	int w, h;

	if((*n < 1) || (*n > 7))
		return (GW_PM?1.0f:((float)fabs(GW_RX/GW_RY)));

	GW_wsize(nDOC, *n, &w, &h);
	return (float)w/(float)h;
}

float GWaspect(int n)
{
	int w, h;

	if((n < 1) || (n > 7))
		return (GW_PM?1.0f:((float)fabs(GW_RX/GW_RY)));

	GW_wsize(nDOC, n, &w, &h);
	return (float)w/(float)h;
}


/*0
_̍ől
*******************************************************************************
[F] REAL FUNCTION GWFMAX()

[C] float GWfmax(void);
-------------------------------------------------------------------------------
()
   _̍őlԂB
-------------------------------------------------------------------------------
(͕ϐ)
    Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
    Ȃ
-------------------------------------------------------------------------------
(Ԃl)
    _̍ől
_______________________________________________________________________________
*/
/*E
Maximum value of Floating Point Numbers
*******************************************************************************
[F] REAL FUNCTION GWFMAX()

[C] float GWfmax(void);
-------------------------------------------------------------------------------
Description
   Returns the maximum floating point value.

Input
   None

Output
   None

Return value
   the maximum floating point value
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFMAX "^";
#endif
float GWFMAX(void)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
float __stdcall GWFMAX(void)
#else
float gwfmax_(void)
#endif
#endif
{
	return FLT_MAX;
}

float GWfmax(void)
{
	return FLT_MAX;
}

/*0
o[Wԍ̎擾
*******************************************************************************
[F] SUBROUTINE GWVERSION(IRTN,IS,STR)
    INTEGER IRTN, IS
    CHARACTER STR*(*)

[C] int GWversion(int IS, char *STR, int l);
-------------------------------------------------------------------------------
()
   CuEt@Cɖߍ܂Ăo[WԍȂǂ̕擾B
   ̃[`͖{CȕOɂĂяoD
-------------------------------------------------------------------------------
(͕ϐ)
   IS = ̎
        0: 擾\ȕ̌𕶎 STR ɕԂD
        1: J}(',')ŋ؂ꂽo[WԍDꂼꐔl傫قǁC
           o[WVƂ\D
        2: K grwnd.exe ̃o[Wԍ
        3: 쐬
        4: 쌠\
        5: rhԍ
     l = ()ϐ STR ̒
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN > 擾\ȕ̌i݂̔łł 5 j
       = 0: Ȕԍw肳ꂽƂ
       = - (擾悤Ƃ̒) < 0: ŝƂ
   STR = 擾
_______________________________________________________________________________
*/
/*E
Get Version Numbers
*******************************************************************************
[F] SUBROUTINE GWVERSION(IRTN,IS,STR)
    INTEGER IRTN, IS
    CHARACTER STR*(*)

[C] int GWversion(int IS, char *STR, int l);
-------------------------------------------------------------------------------
Description
   Retrieve embedded strings, e.g. for the version number, in the library 
   file.  This can be called befor the initialization of the library.

Input
   IS specifies the string to be retrieved
      = 0: the number of the strings that can be retrieved is returned in STR 
           as a string
        1: the version numbers separated by commas, for each of which the 
           larger it is the later the version is.
        2: the version number of the grwnd.exe compatible with the library.
        3: the creation date
        4: copyright
        5: build No.
     l = length of the string (character) variable STR

Output
 IRTN > the number of the strings that can be retrieved (currently 5)
      = 0; if the specified number for a string is invalid
      = - (the length of the string to be retrieved) < 0; if failed
  STR = the retrieved string
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWVERSION "^";
int GWVERSION(int *ret, int *n, CHARACTER *s)
#else
int GWVERSION(int *ret, int *n, char *s, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWVERSION(int *ret, int *n, char *s, int l)
#else
int gwversion_(int *ret, int *n, char *s, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	int l = s->l;
	if((*ret = GWversion(*n, s->p, l)) > 0)
		while(--l >= *ret) s->p[l] = ' ';
#else
	if((*ret = GWversion(*n, s, l)) > 0)
		while(--l >= *ret) s[l] = ' ';
#endif
	return (*ret);
}

int GWversion(int i, char *s, int l)
{
	int n;
	char buff[4];
	switch(i) {
	case 0:
		sprintf(buff, "%d", GW_NUMBER_OF_STRINGS);
		if((n = strlen(buff)) >= l - 1) return -n;
		sprintf(s, "%d", GW_NUMBER_OF_STRINGS);
		break;
	case 1:
		if((n = strlen(GW_PRODUCTVERSION)) >= l - 1) return -n;
		sprintf(s, "%s", GW_PRODUCTVERSION);
		break;
	case 2:
		if((n = strlen(GW_GRWNDVER)) >= l - 1) return -n;
		sprintf(s, "%s", GW_GRWNDVER);
		break;
	case 3:
		if((n = strlen(GW_CREATIONTIME)) >= l - 1) return -n;
		sprintf(s, "%s", GW_CREATIONTIME);
		break;
	case 4:
		if((n = strlen(GW_COPYRIGHT)) >= l - 1) return -n;
		sprintf(s, "%s", GW_COPYRIGHT);
		break;
	case 5:
		if((n = 10) >= l - 1) return -n;
		sprintf(s, "%d", GW_MAGIC);
		break;
	default:
		return 0;
	}
	return GW_NUMBER_OF_STRINGS;
}


/*0
R\[EL[{[h
*******************************************************************************
[F] INTEGER FUNCTION KBHIT()

[C] int kbhit(void);
-------------------------------------------------------------------------------
()
   R\[ʂŉĂL[̃R[hԂBĂȂ 0 
   ԂBgwkybrd QƁB
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(߂l)
   L[ER[hiL[ĂȂ 0j
_______________________________________________________________________________
*/
/*E
Get Keyboard Status On Console
*******************************************************************************
[F] INTEGER FUNCTION KBHIT()

[C] int kbhit(void);
-------------------------------------------------------------------------------
Description
   Get the keyboard status on the console window where the application started 
   up.  The return value is 0 if no key is down (see GWKYBRD). 

Input
   None

Output
   None

Return value
   keyboard status
_______________________________________________________________________________
*/

#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall KBHIT(void)
{
	return _kbhit();
}
#else
#if !defined(_MSC_VER) && !defined(__BORLANDC__)
int kbhit_(void)
{
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__) || defined(__CYGWIN32__) || defined(__LCC__)
	return kbhit();
#else
	return _kbhit();
#endif
}
#endif
#endif


/*0
R\[ł̃L[ER[h̎擾
*******************************************************************************
[F] INTEGER FUNCTION KBGETCH(N)
    INTEGER N

[C] int kbgetch(int N);
-------------------------------------------------------------------------------
()
   R\[1oCg̃L[ER[h擾BL[ĂȂΉ
   ܂ő҂B Iɂ C  getch() ܂ getche() ĂяoĂB
-------------------------------------------------------------------------------
(͕ϐ)
   N  = 0: GR[Ȃ
     <> 0: GR[
-------------------------------------------------------------------------------
(o͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(߂l)
   擾L[ER[h
_______________________________________________________________________________
*/
/*E
Get a Key Code On Console
*******************************************************************************
[F] INTEGER FUNCTION KBGETCH(N)
    INTEGER N

[C] int kbgetch(int N);
-------------------------------------------------------------------------------
Description
   Wait until a key is down and then get the key code on the console window 
   where the application started up.   Internally getch() or getche() is 
   called in this routine.

Input
   N  = 0: whithout echoing
     <> 0: whith echoing

Output
   None

Return value
   key code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux KBGETCH "^";
#endif
int KBGETCH(int *n)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall KBGETCH(int *n)
#else
int kbgetch_(int *n)
#endif
#endif
{
	if(*n) return getche();
	return getch();
}

int kbgetch(int n)
{
	if(n) return getche();
	return getch();
}
