/* LowLevel.c
 *
 * Copyright (C) 1998-2002 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin/english/
 *
 */

#include "gw.h"

#include <ctype.h>
#ifdef _MSC_VER
#include <mbstring.h>
#endif

BOOL bNoConsole = FALSE;
BOOL bIsGUI = TRUE;
BOOL bJoin = FALSE;
BOOL bFloatX = FALSE;
UINT CodePage = 0;

LPVOID pCliFileMap = NULL;
int GrWnd_nCli = 0;				// Cli # = (1 .. MAXAPPS)
int GrWnd_nCliID = 0;			// unique ID of this Cli
HWND GrWnd_hWnd = NULL;
char GrWnd_Version[BUFFLEN];
char CommandLine[256];

int nDOC = 0;					// current doc number
char cDOC = ' ';				// (char)(nDOC + 0x20)
int nOpen = -1;					// # of window opened

LPVOID		FileMaps[MAXDOCS];
WndParams*	GW_pParams = NULL;
LPSTR		GW_pBuffer = NULL;
INT*		GW_pData = NULL;
POINT*		GW_pPoints = NULL;

const char GrWnd_About[] = GW_GRWNDVER;
const char GrWnd_Copyright[] = GW_COPYRIGHT;
const char GrWnd_ProductVersion[] = GW_PRODUCTVERSION;

int nError = 0;

char PathName[MAX_PATH];
char FileMapName[BUFFLEN];		// FileMapName of this Cli

COPYDATASTRUCT cds;
char cmdbuff[MAX_PATH+BUFFLEN], msgbuff[BUFFLEN], *cmdline = NULL;

static char strTester[MAX_PATH];

int JoinGW(int nCli, int nDoc, int bDo, char *str);
LPVOID OpenFileMap(LPCTSTR fmapname);
int GWFindWindow(void);
void DiscardConnection(int nDoc);
int _printf(int nDoc, const char *fmt, ...);
void ErrorMessage(int fatal, const char *fmt, ...);
LRESULT CALLBACK GrWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
LRESULT OpenGrWndApp(HINSTANCE hinst);
void ReleaseFileMap(LPVOID pFileMap);
int _command(int nDoc, char c, int x, int y, int z);
int _command1(int nDoc, char c, int x);
int _command2(int nDoc, char c, int x, int y);
int _setBuff(int nDoc, char *str);
char *_copyBuff(int nDoc, char *str, int l);
int _errcheck(int ret);
int _sendmsg(int len);
BOOL _checkver(void);

LPVOID OpenFileMap(LPCTSTR fmapname)
{
	HANDLE hFileMap;
	LPVOID pFileMap;
	if((hFileMap 
			= OpenFileMapping(FILE_MAP_WRITE, TRUE, fmapname)) == NULL) 
		return NULL;
	if((pFileMap 
			= MapViewOfFile(hFileMap, FILE_MAP_WRITE, 0, 0, 0)) == NULL) {
//		CloseHandle(hFileMap);
		return NULL;
	}
	return pFileMap;
}

int GWFindWindow(void)
{
	int n, l1, l2, l3;
	for(n = 1; n <= MAXINSTS; ++n) {
		sprintf(FileMapName, "%s%d", szWndClsName, n);	// file map n
		if(pCliFileMap) {
			ReleaseFileMap(pCliFileMap);
			pCliFileMap = NULL;
			GrWnd_nCliID = 0;
		}
		if((pCliFileMap = OpenFileMap(FileMapName))) {	// Common file map
			if(sscanf((char*)pCliFileMap, "%d,%d,%d,%[^\n]", 
					&l1, &l2, &l3, GrWnd_Version) == 4) {
				if(l1 == 0) {			// a new instance of grwnd.exe found
					GrWnd_nCli = n;				// Seq # of the instance
					GrWnd_hWnd = (HWND)l2;
					GrWnd_nCliID = l3;
					break;
				}
			}
		}
		if(pCliFileMap) {
			ReleaseFileMap(pCliFileMap);
			pCliFileMap = NULL;
			GrWnd_nCliID = 0;
		}
	}
	return GrWnd_nCliID;
}

void DiscardConnection(int n)
{
	if(nOpen <= 0) 
		return;

	if((n >= 0) && (n < MAXDOCS) && FileMaps[n]) {
#ifdef DBUG
		ErrorMessage(0, "ReleaseFileMap(FileMaps[%d])", n);
#endif
		ReleaseFileMap(FileMaps[n]);
		FileMaps[n] = NULL;
		--nOpen;
	} else for(n = 0; (nOpen > 0 && n < MAXDOCS); ++n) {	// nDoc = wnd# used in WndAppExe
		if(FileMaps[n]) {
#ifdef DBUG
			ErrorMessage(0, "ReleaseFileMap(FileMaps[%d])", n);
#endif
			ReleaseFileMap(FileMaps[n]);
			FileMaps[n] = NULL;
			--nOpen;
		}
	}
	if(pCliFileMap) {
#ifdef DBUG
		ErrorMessage(0, "ReleaseFileMap(pCliFileMap)", n);
#endif
		ReleaseFileMap(pCliFileMap);
		pCliFileMap = NULL;
		GrWnd_nCliID = 0;
	}
	GW_pParams = NULL;
	GW_pBuffer = NULL;
	GW_pData   = NULL;
	GW_pPoints = NULL;
	GrWnd_hWnd = NULL;
	nDOC = 0;
	cDOC = ' ';
	GrWnd_nCli = 0;
	strcpy(FileMapName, "");
}

///////////////////////////////////////////////////////////////////////
int _printf(int nDoc, const char *fmt, ...)
{
	int ret;
	va_list args;
	va_start(args, fmt);
	ret = vsprintf((char *)GW_Buffer(nDoc), fmt, args);
	va_end(args);
	return ret;
}

////////////////////////////////////////////////////////////////////////
void ErrorMessage(int fatal, const char *fmt, ...)
{
	char buff[BUFFLEN];
	va_list args;
	va_start(args, fmt);
	vsprintf(buff, fmt, args);
	va_end(args);
	if(bIsGUI) {
		switch(MessageBox(NULL, buff, NULL, 
			(fatal?MB_OK:MB_ABORTRETRYIGNORE) | MB_ICONERROR | MB_TOPMOST)) {
		case IDABORT:
			if(nOpen > 0) GW_quit(-1);
		case IDCANCEL:
		case IDIGNORE:
			return;
		}
	} else {
		fprintf(stderr, "%s\n", buff);
		if(fatal && (nOpen > 0)) GW_quit(-1);
	}
}


///////////////////////////////////////////////////////////////////////
static char* FindOnPath(char* strName)
{
	LPTSTR pstrPlace = NULL;
	DWORD dwNeeded, dwTemp;
	char strGWEnv[MAX_PATH] = "", strTemp[MAX_PATH] = "", *pstrThisOne, *p;
	WIN32_FIND_DATA	find;
	HANDLE hFind;
	LPTSTR lpszEnvironmentBlock;

	// get the path of the app
	strcpy(strTemp, PathName);
#ifdef _MSC_VER
	if((p = _mbsrchr(strTemp,'\\'))) 
#else
	if((p = strrchr(strTemp,'\\'))) 
#endif
		*p = '\0';
	dwTemp = strlen(strTemp);	// length of the extra string for search path

	// get the PATH setting from the environment
	lpszEnvironmentBlock = GetEnvironmentStrings();
	dwNeeded = GetEnvironmentVariable(GRWINDIR, NULL, 0);
	if(dwNeeded && dwNeeded < MAX_PATH) {
		GetEnvironmentVariable(GRWINDIR, strGWEnv, MAX_PATH); 
		dwTemp += strlen(strGWEnv);
	}
	dwNeeded = GetEnvironmentVariable("PATH", NULL, 0);
	if((dwNeeded | dwTemp) && (pstrPlace = (LPTSTR)malloc(dwNeeded+dwTemp+5))) {
		p = strGWEnv;
#ifdef _MSC_VER
		while(_mbsncmp(p, " ", 1) == 0) ++p;
#else
		while(strncmp(p, " ", 1) == 0) ++p;
#endif
		strcpy(pstrPlace, p);
		if(strlen(pstrPlace) > 0) 
			strcat(pstrPlace, ";");
		strcat(pstrPlace, strTemp);
		if(strlen(pstrPlace) > 0) 
			strcat(pstrPlace, ";");
		if(!dwNeeded) 
			strcat(pstrPlace, ".");
		else {
			strcat(pstrPlace, ".;");
			GetEnvironmentVariable("PATH", pstrPlace+strlen(pstrPlace), 
				dwNeeded);
		}
	} else {
		if(pstrPlace) free(pstrPlace);
		FreeEnvironmentStrings(lpszEnvironmentBlock);
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERRENV);
		else ErrorMessage(1, IDS_EN_ERRENV);
		exit(1);
		return NULL;
	}
	FreeEnvironmentStrings(lpszEnvironmentBlock);

	// loop through the settings in the environment
	pstrThisOne = (char *)strtok(pstrPlace, ";");
	while (pstrThisOne != NULL) {
		strcpy(strTester, pstrThisOne);
		if(strTester[strlen(strTester)-1] != '\\') strcat(strTester, "\\");
		strcat(strTester, strName);
		hFind = FindFirstFile(strTester, &find);
		if (hFind != INVALID_HANDLE_VALUE) {
			if(pstrPlace) free(pstrPlace);
			FindClose(hFind);
			return strTester;
		}
		pstrThisOne = (char *)strtok(NULL, ";");
	}
	if(pstrPlace) free(pstrPlace);
	if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_NOFILE, strName);
	else ErrorMessage(1, IDS_EN_NOFILE, strName);
	exit(1);
	return NULL;
}

LRESULT CALLBACK GrWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT ret = 0;
	STARTUPINFO suInfo;
	PROCESS_INFORMATION procInfo;
	switch (msg) {
		case WM_CREATE:
			memset(&suInfo, 0, sizeof(suInfo));
			suInfo.cb = sizeof(suInfo);
			if(CreateProcess(
				FindOnPath(WndAppExe), 
				CommandLine, 
				NULL, 
				NULL, 
				FALSE, 
				0, 
				NULL, 
				NULL, 
				&suInfo, 
				&procInfo) == FALSE) return FALSE;
			if(WaitForInputIdle(procInfo.hProcess, MSWAIT))
				ret = (-1);
			DestroyWindow(hWnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return(DefWindowProc(hWnd, msg, wParam, lParam));
	}
	return ret;
}

// launch grwnd.exe
LRESULT OpenGrWndApp(HINSTANCE hinst)
{
	HWND hWnd;
	MSG lpMsg;
	WNDCLASS myProg;
	myProg.style			=CS_HREDRAW | CS_VREDRAW;
	myProg.lpfnWndProc		=GrWndProc;
	myProg.cbClsExtra		=0;
	myProg.cbWndExtra		=0;
	myProg.hInstance		=hinst;
	myProg.hIcon			=NULL;
	myProg.hCursor			=LoadCursor(NULL, IDC_ARROW);
	myProg.hbrBackground	=GetStockObject(WHITE_BRUSH);
	myProg.lpszMenuName		=NULL;
	myProg.lpszClassName	=szWndClsName;
	if (!RegisterClass(&myProg))
		return FALSE;
	hWnd = CreateWindow(szWndClsName,
		szWndAppName,
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		hinst,
		NULL);
	ShowWindow(hWnd, SW_HIDE);
	UpdateWindow(hWnd);
	while (GetMessage(&lpMsg, NULL, 0, 0)) {
		TranslateMessage(&lpMsg);
		DispatchMessage(&lpMsg);
	}
	return (lpMsg.wParam);
}

void ReleaseFileMap(LPVOID pFileMap)
{
	if(IsWindow(GrWnd_hWnd)) {
		if(pFileMap && !UnmapViewOfFile((char*)pFileMap)) {
			if(CodePage == JPNCP)
				ErrorMessage(1, IDS_JP_ERRUMAP, GetLastError());
			else
				ErrorMessage(1, IDS_EN_ERRUMAP, GetLastError());
		}
	}
}

int _getsizes(int n, int *w, int *h)
{
	int ret = 0;
	if(!pCliFileMap) {
		if(CodePage == JPNCP)
			ErrorMessage(1, IDS_JP_ERRCOMM);
		else
			ErrorMessage(1, IDS_EN_ERRCOMM);
		DiscardConnection(-1);
		exit(1);
	}
	if(w) ret += 1;
	if(h) ret += 2;
	sprintf((LPSTR)pCliFileMap, "%d;%d;%d;%d;", n, ret, w?*w:0, h?*h:0);
	ret = _command0(GW_WSIZE, 0x20, 0x20);
	if(n < 0) 
		return ret;
	if(sscanf((LPCTSTR)pCliFileMap, "3;%d;%d;", w, h) < 2) 
		return 0;
	return ret;
}

int _command0(char c, char d, char e)
{
	sprintf(cmdbuff, "%c%c%c", c, d, e);
	return _errcheck(_sendmsg(4));
}

int _command(int nDoc, char c, int x, int y, int z)
{
	int ret;
	GW_Params(nDoc)->x = x;
	GW_Params(nDoc)->y = y;
	GW_Params(nDoc)->z = z;
	sprintf(cmdbuff, "%c%c", c, nDoc+0x20);
	ret = _errcheck(_sendmsg(3));
	return ret;
}

int _command1(int nDoc, char c, int x)
{
	int ret;
	GW_Params(nDoc)->x = x;
	sprintf(cmdbuff, "%c%c", c, nDoc+0x20);
	ret = _errcheck(_sendmsg(3));
	return ret;
}

int _command2(int nDoc, char c, int x, int y)
{
	int ret;
	GW_Params(nDoc)->x = x;
	GW_Params(nDoc)->y = y;
	sprintf(cmdbuff, "%c%c", c, nDoc+0x20);
	ret = _errcheck(_sendmsg(3));
	return ret;
}

int _setBuff(int nDoc, char *str)
{
	if(str == NULL) {
		GW_Buffer(nDoc)[0] = '\0';
		return 0;
	}
	if(str != GW_Buffer(nDoc)) return sprintf(GW_Buffer(nDoc), "%s", str);
	return strlen(GW_Buffer(nDoc));
}

char *_copyBuff(int nDoc, char *str, int l)
{
	if(str == NULL) {
		GW_Buffer(nDoc)[0] = '\0';
		return NULL;
	}
	l = min(l,(int)MAXBUFFER-1);
	strncpy(GW_Buffer(nDoc), str, l);
	GW_Buffer(nDoc)[l] = '\0';
	while((--l >= 0) && (GW_Buffer(nDoc)[l] == ' ')) 
			GW_Buffer(nDoc)[l] = '\0';
	return GW_Buffer(nDoc);
}


int _errcheck(int ret)
{
	if(ret > SHRT_MIN) return ret;

	switch(ret) {
	case _GWQUIT_:
//		ErrorMessage(0, "Quit");
		return 1;
	case _GWCLOSED_:
//		ErrorMessage(1, "Closed");
		DiscardConnection(-1);
		GrWnd_hWnd = NULL;
		return 0;
	case _GWEXIT0_:
//		ErrorMessage(1, "Exit");
		DiscardConnection(-1);
		exit(0);
		break;
	case _GWABORT_:
//		ErrorMessage(1, "Abort");
		GW_quit(0);
		exit(0);
	case _GWFATALERR_:
		if(CodePage == JPNCP)
			ErrorMessage(1, IDS_JP_ERRFATAL);
		else
			ErrorMessage(1, IDS_EN_ERRFATAL);
		DiscardConnection(-1);
		exit(1);
	}
//	ErrorMessage(0, "Error %d", -ret);
//	exit(1);
	return ret;
}


int _systest(void)
{
	int ret = -1;
	if(nDOC > 0) {
		GW_Params(nDOC)->x = 1;
		sprintf(cmdbuff, "%c%c", GW_SYSCHECK, cDOC);
		if(_sendmsg(3) != _GWFATALERR_) return 1;
		GW_Params(nDOC)->x = 2;
		sprintf(cmdbuff, "%c%c", GW_SYSCHECK, cDOC);
		if(_sendmsg(3) != INT_MAX) return 2;
		ret = 0;
	}
	return ret;
}


int _sendmsg(int len)
{
	int ret = INT_MIN;

	if(len > BUFFLEN) {
		ErrorMessage(0, "Internal buffer overflow[%s]", cmdbuff);
		DiscardConnection(-1);
		exit(1);
	}
	if(GrWnd_hWnd) {
		if(!IsWindow(GrWnd_hWnd)) {
			if(cmdbuff[0] == GW_INIT) {
				if(CodePage == JPNCP)
					ErrorMessage(1, IDS_JP_ZOMBI, WndAppExe, WndAppExe);
				else
					ErrorMessage(1, IDS_EN_ZOMBI, WndAppExe, WndAppExe);
			} else {
				if(CodePage == JPNCP)
					ErrorMessage(1, IDS_JP_UNEXPCT);
				else
					ErrorMessage(1, IDS_EN_UNEXPCT);
			}
			DiscardConnection(-1);
			exit(1);
		}
#ifdef DEBUG
		ErrorMessage(0, "_sendmsg(%s) = ", cmdbuff);
#endif
		cds.cbData = len;
		ret = SendMessage(GrWnd_hWnd, WM_COPYDATA, (WPARAM)NULL, (LPARAM)&cds);
#ifdef DEBUG
		ErrorMessage(0, "_sendmsg(%s) = %d", cmdbuff, ret);
#endif
	}
	return ret;
}


int _senddata(int nDoc, LPCVOID p, int n)			// n = length in BYTE
{
	int i0 = 0, len;

	while(n > 0) {
		len = min(n, (int)MAXBYTES);
		memcpy(GW_Bytes(nDoc), p, len);
		if(!_command(nDoc, GW_CMD, CMD_DATA, i0, len)) {
			_command1(nDoc, GW_CMD, CMD_DELTOOL);
			return 0;
		}
		i0 += len;
		(BYTE*)p  += len;
		n  -= len;
	}
	return nDoc;
}


int _polydo(int nDoc, int nTool, LPCVOID p, int n)	// n = length in BYTE
{
	if(_command1(nDoc, GW_GENTOOL, nTool)) {
		if(_senddata(nDoc, p, n)) {
			_command1(nDoc, GW_CMD, CMD_DOTOOL);
			return nDoc;
		} else
			_command1(nDoc, GW_CMD, CMD_DELTOOL);
	}
	return 0;
}

BOOL _checkver(void)
{
	int Lver[5], Gver[5];
	if(strcmp(GrWnd_Version, GrWnd_ProductVersion)) {
		Gver[0] = sscanf(GrWnd_Version, "%d,%d,%d,%d", 
			Gver+1, Gver+2, Gver+3, Gver+4);
			// Product Version of GrWnd.exe
		Lver[0] = sscanf(GrWnd_ProductVersion, 
			"%d,%d,%d,%d", Lver+1, Lver+2, Lver+3, Lver+4);
			// Product Version of the library
		if(Gver[0] != Lver[0]) {
			if(CodePage == JPNCP) ErrorMessage(0, 
				IDS_JP_OLDEXE, GrWnd_ProductVersion, WndAppExe);
			else ErrorMessage(0, 
				IDS_EN_OLDEXE, WndAppExe, GrWnd_ProductVersion);
			return FALSE;
		} else {
			int OldLib = 0;
			int i;
			for(i=1; i < Gver[0]; ++i) 
				if(Lver[i] < Gver[i]) {
					OldLib = 1;
					break;
				} else if(Lver[i] > Gver[i]) {
					OldLib = -1;
					break;
				}
			if(OldLib == 0) return TRUE;
			if(OldLib > 0) {
				if(CodePage == JPNCP) ErrorMessage(0, IDS_JP_OLDLIB, 
					WndAppExe, GrWnd_Version, GrWnd_ProductVersion);
				else ErrorMessage(0, IDS_EN_OLDLIB, 
					GrWnd_ProductVersion, WndAppExe, GrWnd_Version);
			} else if(OldLib < 0) {
				if(CodePage == JPNCP) ErrorMessage(0, IDS_JP_OLDEXE2, 
					GrWnd_ProductVersion, WndAppExe, GrWnd_Version);
				else ErrorMessage(0, IDS_EN_OLDEXE2, 
					WndAppExe, GrWnd_Version, GrWnd_ProductVersion);
			}
		}
	}
	return FALSE;
}

static void GW_syscheck(void)
{
	cds.dwData = (DWORD)FROMAPP;
	cds.lpData = (LPVOID)cmdbuff;
	sprintf(cmdbuff, "%c,0", GW_SYSCHECK);
	*(int*)(cmdbuff+4) = sizeof(WndParams);
	if(_sendmsg(8) != sizeof(GWParams)) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_VERSION, 1);
		else ErrorMessage(1, IDS_EN_VERSION, 1);
		DiscardConnection(-1);
		exit(1);
	}
	sprintf(cmdbuff, "%c,1", GW_SYSCHECK);
	*(float*)(cmdbuff+4) = _GWFLOATTST_;
	if(_sendmsg(8) != MAXPOINTS) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_INVALIDSYS, 1);
		else ErrorMessage(1, IDS_EN_INVALIDSYS, 1);
		DiscardConnection(-1);
		exit(1);
	}
	sprintf(cmdbuff, "%c,2", GW_SYSCHECK);
	*(double*)(cmdbuff+4) = _GWDOUBLETST_;
	if(_sendmsg(12) != INT_MAX) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_INVALIDSYS, 2);
		else ErrorMessage(1, IDS_EN_INVALIDSYS, 2);
		DiscardConnection(-1);
		exit(1);
	}
#if FLOATCHECK
	sprintf(cmdbuff, "%c,3", GW_SYSCHECK);
	*(float*)(cmdbuff+4) = (float)(_GWDOUBLETST_*_GWFLOATTST_);
	if(_sendmsg(8) == INT_MIN) 
		bFloatX = TRUE;
	else {
		if(CodePage == JPNCP) ErrorMessage(0, IDS_JP_INVALIDSYS, 3);
		else ErrorMessage(0, IDS_EN_INVALIDSYS, 3);
		bFloatX = TRUE;
	}
#endif
}
//////////////////////// GrWin routines ////////////////////////////////
int GW_init(int bri, int x, int y, int w, int h, int a, int m, int z, int d)
{
//	HANDLE hIOMutex = NULL;

	int n;
	char Option[BUFFLEN], *p;

	if(!bJoin) {
		if(GrWnd_nCli) return 0;	/* open already */

		if(nOpen < 0) {
			for(n = 0; n < MAXDOCS; ++n)	// nDoc = wnd# used in WndAppExe
				FileMaps[n] = NULL;
			nOpen = 0;
		}

		GetModuleFileName(NULL, PathName, MAX_PATH);
		bIsGUI = IsWinGUI(PathName);		// not a console app ?
		CodePage = GetACP();
		if(!IsValidCodePage(CodePage))
			CodePage = USCP;				// Windows 3.1 Latin 1
	}
	if(bJoin || GWFindWindow()) {
		if(bri >= 0) {
			if(!(bri & 0x10000)) {
				if(bri & 1) {
					GW_mode(0, 1, 1);
				} else {
					GW_mode(0, 1, 0);
				}
			}
			if(!(bri & 0x20000)) {
				if(bri & 2) {
					GW_mode(0, 2, 1);
				} else {
					GW_mode(0, 2, 0);
				}
			}
			if(!(bri & 0x40000)) {
				if(bri & 4) {
					GW_mode(0, 3, 1);
				} else {
					GW_mode(0, 3, 0);
				}
			}
			if(!(bri & 0x80000)) {
				if(bri & 8) {
					GW_mode(0, 4, 1);
				} else {
					GW_mode(0, 4, 0);
				}
			}
			if(!(bri & 0x100000)) {
				if(bri & 16) {
					GW_mode(0, 5, 1);
				} else {
					GW_mode(0, 5, 0);
				}
			}
			if(!(bri & 0x200000)) {
				if(bri & 32) {
					GW_mode(0, 6, 1);
				} else {
					GW_mode(0, 6, 0);
				}
			}
		}
		if(x >= 0 && y >= 0) {
			GW_wsize(0, 4, &x, &y);
		}
		if(w > 0 && h > 0) {
			GW_wsize(0, 3, &x, &y);
		}
		if(a > 0 && a <= 4) {
			GW_arrange(0, a);
		}
		if(m >= 0 && m <= 14) {
			GWshowfr(m);
		}
		if(z > 0 && z <= 4) {
			GWshowfr(z+10);
		}
		if(d > 0 && d <= 1200) {
			GW_wsize(0, 10, &d, &d);
		}
	} else {
		CommandLine[0] = '\0';
		if(bri >= 0) {
			if(!(bri & 0x10000)) {
				if(bri & 1) {
					sprintf(Option, " /t");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /T");
					strcat(CommandLine, Option);
				}
			}
			if(!(bri & 0x20000)) {
				if(bri & 2) {
					sprintf(Option, " /b");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /B");
					strcat(CommandLine, Option);
				}
			}
			if(!(bri & 0x40000)) {
				if(bri & 4) {
					sprintf(Option, " /r");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /R");
					strcat(CommandLine, Option);
				}
			}
			if(!(bri & 0x80000)) {
				if(bri & 8) {
					sprintf(Option, " /i");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /I");
					strcat(CommandLine, Option);
				}
			}
			if(!(bri & 0x100000)) {
				if(bri & 16) {
					sprintf(Option, " /l");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /L");
					strcat(CommandLine, Option);
				}
			}
			if(!(bri & 0x200000)) {
				if(bri & 32) {
					sprintf(Option, " /o");
					strcat(CommandLine, Option);
				} else {
					sprintf(Option, " /O");
					strcat(CommandLine, Option);
				}
			}
		}

		if(x >= 0 && y >= 0) {
			sprintf(Option, " /p%d,%d", x, y);
			strcat(CommandLine, Option);
		}
		if(w > 0 && h > 0) {
			sprintf(Option, " /s%d,%d", w, h);
			strcat(CommandLine, Option);
		}
		if(a > 0 && a <= 4) {
			sprintf(Option, " /a%d", a);
			strcat(CommandLine, Option);
		}
		if(m >= 0 && m <= 14) {
			sprintf(Option, " /m%d", m);
			strcat(CommandLine, Option);
		}
		if(z > 0 && z <= 4) {
			sprintf(Option, " /z%d", z);
			strcat(CommandLine, Option);
		}
		if(d > 0 && d <= 1200) {
			sprintf(Option, " /dpi%d", d);
			strcat(CommandLine, Option);
		}
	}
	if(bJoin) return GrWnd_nCli;

	// Open graphics window if necessary
	if(!pCliFileMap) {
		// Get GrWnd_nCli, GrWnd_hWnd & GrWnd_nCliID
		OpenGrWndApp(GetModuleHandle(NULL));	// launch grwnd.exe
		GWFindWindow();
	}
	if(!GrWnd_hWnd) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_NOTFOUND, WndAppExe);
		else ErrorMessage(1, IDS_EN_NOTFOUND, WndAppExe);
		DiscardConnection(-1);
		exit(1);
	}
	_checkver();

	cmdline = GetCommandLine();
	if(*cmdline == '"') bNoConsole = TRUE;
		// App launched not from command prompt

	GW_syscheck();

	sprintf(cmdbuff, "%c,%d,", GW_INIT, GrWnd_nCliID);
	p = &(cmdbuff[strlen(cmdbuff)]);
	GetCurrentDirectory(BUFFLEN-1, p);
	p = &(cmdbuff[strlen(cmdbuff)]);
	*p++ = GWSEPARATOR;
	*p = '\0';
//	if(strlen(cmdbuff)+strlen(PathName)+strlen(GrWnd_About)+2 > BUFFLEN) {
//		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERRPATH);
//		else ErrorMessage(1, IDS_EN_ERRPATH);
//	}
	strcat(cmdbuff, PathName);			// add full path name for the app
	p = &(cmdbuff[strlen(cmdbuff)]);
	*p++ = GWSEPARATOR;
	*p = '\0';
	strcat(cmdbuff, GrWnd_About);		// add Version Info

	// send GW_INIT command
	if(((int)_sendmsg(strlen(cmdbuff)+1)) != GrWnd_nCliID) {	// send GW_INIT
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERRINIT);
		else ErrorMessage(1, IDS_EN_ERRINIT);
		DiscardConnection(-1);
		exit(1);
	}
	return GrWnd_nCli;
}


int JoinGW(int nCli, int nDoc, int bDo, char *str)
{
	char tmpFileMapName[BUFFLEN];				// FileMapName of this Cli
	LPVOID pTmpFileMap;
	char DocName[BUFFLEN];
	int tmp_nCli;
	int n, l1 = 0, l2, l3, nCli0 = 1, nCli1 = MAXINSTS;

	if(str) *str = '\0';
	if(nCli > 0) nCli0 = nCli1 = nCli;
	for(tmp_nCli = nCli0; tmp_nCli <= nCli1; ++tmp_nCli) {
		sprintf(tmpFileMapName, "%s%d", szWndClsName, tmp_nCli);
		if((pTmpFileMap = OpenFileMap(tmpFileMapName))) {
			if(nOpen < 0) {
				for(n = 0; n < MAXDOCS; ++n)	// nDoc = wnd# used in WndAppExe
					FileMaps[n] = NULL;
				nOpen = 0;
			}
			if(CodePage == 0) {
				GetModuleFileName(NULL, PathName, MAX_PATH);
				bIsGUI = IsWinGUI(PathName);	// not a console app ?
				CodePage = GetACP();
				if(!IsValidCodePage(CodePage))
					CodePage = USCP;			// Windows 3.1 Latin 1
			}
			GrWnd_hWnd = 0;
			DocName[0] = '\0';
			if((sscanf((char*)pTmpFileMap, "%d,%d,%d,%[^\n]", 
					&l1, &l2, &l3, GrWnd_Version) == 4) && (l1 == 0)) {
			} else if((sscanf((char*)pTmpFileMap, "%d,%[^\n]\n%d,%d,%[^\n]", 
				&l1, DocName, &l2, &l3, GrWnd_Version) == 5) && (l1 > 0)) {
			} else {
				ReleaseFileMap(pTmpFileMap);
				continue;
			}
			GrWnd_hWnd = (HWND)l2;
			GrWnd_nCliID = l3;
			_checkver();
			cmdline = GetCommandLine();
			if(*cmdline == '"') bNoConsole = TRUE;	
				// App launched not from command prompt

			GW_syscheck();

			if(l1) {
				if(nDoc <= 0) nDoc = l1;
				sprintf(cmdbuff, "%s%d:%d", szWndClsName, tmp_nCli, nDoc);
					// file map name

				FileMaps[nDoc] = OpenFileMap(cmdbuff);
				if(!(FileMaps[nDoc])) {
					ReleaseFileMap(pTmpFileMap);
					pTmpFileMap = NULL;
					if(CodePage == JPNCP) 
						ErrorMessage(0, IDS_JP_ERRJOIN, IDS_JP_ERRJOIN_R2);
					else 
						ErrorMessage(0, IDS_EN_ERRJOIN, IDS_EN_ERRJOIN_R2);
					exit(1);
				}
				++nOpen;

				nDOC = nDoc;
				cDOC = (char)(nDOC + 0x20);
				GrWnd_nCli = tmp_nCli;
				pCliFileMap = pTmpFileMap;
				strcpy(FileMapName, tmpFileMapName);
				GW_pParams = (WndParams*)(FileMaps[nDoc]);
				GW_pBuffer = GW_pParams->Work.Buffer;
				GW_pData   = GW_pParams->Work.Data;
				GW_pPoints = &(GW_pParams->Work.Points[0]);
				if(str) sprintf(str, "%d:%d %s", GrWnd_nCli, nDOC, DocName);
				if(!bDo) {
					DiscardConnection(nDOC);
					return nDoc;
				} else if(GW_mode(nDOC, 4, -1) > 0) {	// Inquiring
					char text[40];
					if(CodePage == JPNCP) 
						sprintf(text, IDS_JP_JOIN, GrWnd_nCli, nDOC, DocName);
					else 
						sprintf(text, IDS_EN_JOIN, GrWnd_nCli, nDOC, DocName);
					if(GW_msgbox(nDOC, text) != 1) {
						DiscardConnection(nDOC);
						return 0;
					}
				}

#ifdef DEBUG
				printf("Class name of this client window = %s\n", GW_pBuffer);
#endif
				return nDoc;
			} else {
				ReleaseFileMap(pTmpFileMap);
				GrWnd_hWnd = NULL;
				GrWnd_nCliID = 0;
				continue;
			}
		}
	}
	return 0;
}


int GW_join(int nDoc, int nCli, int bDo, char *str)
{
	if(GrWnd_nCli) return 0;	/* open already */

	if((JoinGW(nCli, nDoc, bDo, str) <= 0) && ((nDoc <= 0) || (JoinGW(nCli, 0, bDo, str) <= 0))) {
		GrWnd_nCli = 0;
		bJoin = FALSE;
		return 0;
	}
	bJoin = TRUE;
	return nDOC;
}


int GW_quit(int bPause)
{
	int ret = 0;

	if(bPause >= 0 && IsWindow(GrWnd_hWnd)) {
		sprintf(cmdbuff, "%c,%d,", GW_QUIT, bPause);
			// popup MessageBox if bPause
		ret = _sendmsg(strlen(cmdbuff)+1);
	}
	DiscardConnection(-1);
	if(!bIsGUI && bPause && bNoConsole) {
		fprintf(stdout, "> ");
		fflush(stderr);
		getchar();
	}
	return ret;
}


int GW_open(int nDoc, int Width, int Height, int fc, int bc, 
	int Mode, char *fname)
{
	if(bJoin) {
		if(Width > 0 && Height > 0) 
			GW_wsize(nDOC, 4, &Width, &Height);
		if(fc >= 0) GW_color(nDOC, fc, 1);
		if(bc >= 0) GW_color(nDOC, bc, 2);
		if(Mode >= 0) GWshowwn(nDOC, Mode);
		bJoin = FALSE;
		return nDOC;
	}

	if(!pCliFileMap) {
		if(!GW_init(-1, -1, -1, -1, -1, -1, -1, -1, -1)) 
			return 0;
	}

	// send a command to initialize
	if(fname && (strlen(fname) > 0)) 
		sprintf(cmdbuff, "%c,%d,%d,%d,%d,%d,%d,%s", 
			GW_OPEN, nDoc, Width, Height, fc, bc, Mode, fname);
	else sprintf(cmdbuff, "%c,%d,%d,%d,%d,%d,%d,", 
		GW_OPEN, nDoc, Width, Height, fc, bc, Mode);
	if((int)_errcheck(_sendmsg(strlen(cmdbuff)+1)) <= 0) {	// send GW_OPEN
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERROPEN);
		else ErrorMessage(1, IDS_EN_ERROPEN);
		DiscardConnection(-1);
		exit(1);
	}
	if(pCliFileMap)
		sscanf((LPCTSTR)pCliFileMap, "%d,%[^\n]", &nDoc, msgbuff);	// get nDoc
	else {
		if(CodePage == JPNCP)
			ErrorMessage(1, IDS_JP_ERRCOMM);
		else
			ErrorMessage(1, IDS_EN_ERRCOMM);
		DiscardConnection(-1);
		exit(1);
	}

	sprintf(cmdbuff, "%s%d:%d", szWndClsName, GrWnd_nCli, nDoc);
		// file map name

	FileMaps[nDoc] = OpenFileMap(cmdbuff);
	if(!(FileMaps[nDoc])) {
		if(CodePage == JPNCP)
			ErrorMessage(0, IDS_JP_ERRWND, nDoc);
		else
			ErrorMessage(0, IDS_EN_ERRWND, nDoc);
		return 0;
	}
	++nOpen;

	nDOC = nDoc;
	cDOC = (char)(nDOC + 0x20);
	GW_pParams = (WndParams*)(FileMaps[nDoc]);
	GW_pBuffer = GW_pParams->Work.Buffer;
	GW_pData   = GW_pParams->Work.Data;
	GW_pPoints = &(GW_pParams->Work.Points[0]);

#ifdef DEBUG
	printf("Class name of this client window = %s\n", GW_pBuffer);
#endif

//	_command1(nDoc, GW_GENDOTOOL, TOOL_RESET);
//	_command(nDoc, GW_CMD, CMD_SETOGN, 0, 1);
	return _command2(nDoc, GW_CMD, CMD_SAVEVP, 0);	// init VP = 0
}


int GW_close(int nDoc)
// close windows associated with this client
//     nDoc == 0: the current window
//     nDoc  > 0: window # to be closed
//     nDoc  < 0: all windows
{
	int n, n1 = 0, n2 = MAXDOCS;

	if(nDoc == 0) nDoc = nDOC;
	if(nDoc > 0 && nDoc < MAXDOCS) {
		n1 = nDoc;
		n2 = nDoc+1;
	}
	for(n = n1; n < n2; ++n) {
		if(FileMaps[n]) {
			ReleaseFileMap(FileMaps[n]);
			FileMaps[n] = NULL;
			--nOpen;
			sprintf(cmdbuff, "%c%c", GW_CLOSE, n+0x20);
			nDOC = _errcheck(_sendmsg(3));	// next Doc
			cDOC = (char)(nDOC + 0x20);
		}
	}
	if(nDOC > 0) _command1(nDOC, GW_CMD, CMD_SELWIN);	// activate
	return nDOC;
}

int GW_wsize(int nDoc, int n, int *width, int *height)
{
	int ret = 0, w, h;
	HDC hdc;
	if(nDoc == 0) {			// no document open
		if(!GrWnd_nCli) {	// not yet initialized
			if(n == WSZ_SCREEN) {
				hdc = GetDC(NULL);
				GW_asgn(width, GetDeviceCaps(hdc, HORZRES));
				GW_asgn(height, GetDeviceCaps(hdc, VERTRES));
				ReleaseDC(NULL,hdc);
				return 1;
			} else
				return 0;
		} else if(abs(n) > 0 && abs(n) < WSZ_N) {
			if(n > 0) {
				w = width?*width:-1;
				h = height?*height:-1;
				ret = _getsizes(n, &w, &h);
				if(ret) {
					GW_asgn(width, w);
					GW_asgn(height, h);
				}
			} else
				ret = _getsizes(n, width, height);
		}
		return ret;
	}
	if(n > 0 && n < WSZ_N) {
		ret = _command1(nDoc, GW_WSIZE, n);
		GW_asgn(width, GW_Params(nDoc)->c.i.p0);
		GW_asgn(height, GW_Params(nDoc)->c.i.p1);
	} else if(n < 0 && n > -WSZ_N) {
		if(!width || !height)
			ret = _command(nDoc, GW_WSIZE, n, 0, 0);
		else
			ret = _command(nDoc, GW_WSIZE, n, *width, *height);
	} else
		return 0;
	return ret;
}

int GW_viewmode(int nDoc, int m)
{
	if(nDoc) {				// no document open
		if(_command2(nDoc, GW_CMD, CMD_VIEWMODE, m) && 
			sscanf(GW_Buffer(nDoc), "%d,", &m))
			return m;
	} else {
		if(GrWnd_nCli) 	// initialized
			return _command0(GW_MODE, 0x20, (char)(m+0x20));
	}
	return 0;
}

int GW_idle(int nDoc, int *ch, int *u, int *v, int ms)
{
	int ret;
	GW_Params(nDoc)->x = CMD_IDLELOOP;
	GW_Params(nDoc)->y = ms;
	if(u)
		GW_Params(nDoc)->c.i.p2 = *u;
	else
		GW_Params(nDoc)->c.i.p2 = -1;
	if(v)
		GW_Params(nDoc)->c.i.p3 = *v;
	else
		GW_Params(nDoc)->c.i.p3 = -1;
	cmdbuff[0] = GW_CMD;
	cmdbuff[1] = nDoc+0x20;
	cmdbuff[2] = '\0';
	if((ret = _errcheck(_sendmsg(3)))) {
		GW_asgn(ch, GW_Params(nDoc)->c.i.p1);
		GW_asgn(u, GW_Params(nDoc)->c.i.p2);
		GW_asgn(v, GW_Params(nDoc)->c.i.p3);
	}
	return ret;
}

int GW_idle2(int nDoc, int *ch, int *u, int *v, int ms)
{
	int ret;
	GW_Params(nDoc)->x = CMD_IDLELOOP2;
	GW_Params(nDoc)->y = ms;
	if(u)
		GW_Params(nDoc)->c.i.p2 = *u;
	else
		GW_Params(nDoc)->c.i.p2 = -1;
	if(v)
		GW_Params(nDoc)->c.i.p3 = *v;
	else
		GW_Params(nDoc)->c.i.p3 = -1;
	cmdbuff[0] = GW_CMD;
	cmdbuff[1] = nDoc+0x20;
	cmdbuff[2] = '\0';
	if((ret = _errcheck(_sendmsg(3)))) {
		GW_asgn(ch, GW_Params(nDoc)->c.i.p1);
		GW_asgn(u, GW_Params(nDoc)->c.i.p2);
		GW_asgn(v, GW_Params(nDoc)->c.i.p3);
	}
	return ret;
}

int GW_kybrd(int nDoc, int *ch, int *cnt, int *flg, int t)
// t = 0: 
//     1: wait for a non-system key input
//     2: wait for a key down
//     3: wait for a key up
//  otherwise: keyboard status at the monent
{
	int ret;
	GW_Params(nDoc)->x = CMD_KEYBOARD;
	switch(t) {
	case 1:
		GW_Params(nDoc)->y = ONCHAR;
		break;
	case 2:
		GW_Params(nDoc)->y = KEYDOWN;
		break;
	case 3:
		GW_Params(nDoc)->y = KEYUP;
		break;
	default:
		GW_Params(nDoc)->y = t;
	}
//	if(ch && (*ch < 0)) ch = NULL;
//	if(cnt && (*cnt < 0)) cnt = NULL;
//	if(flg && (*flg < 0)) flg = NULL;
	cmdbuff[0] = GW_CMD;
	cmdbuff[1] = nDoc+0x20;
	cmdbuff[2] = '\0';
	if((ret = _errcheck(_sendmsg(3)))) {
		GW_asgn(ch, GW_Params(nDoc)->c.i.p1);
		GW_asgn(cnt, GW_Params(nDoc)->c.i.p2);
		GW_asgn(flg, GW_Params(nDoc)->c.i.p3);
	}
	return ret;
}

int GW_putmark(int nDoc, int u, int v)
{
	GW_Params(nDoc)->x = TOOL_MARK;
	GW_Params(nDoc)->c.i.p1 = u;
	GW_Params(nDoc)->c.i.p2 = v;
	cmdbuff[0] = GW_GENDOTOOL;
	cmdbuff[1] = nDoc+0x20;
	cmdbuff[2] = '\0';
	return _errcheck(_sendmsg(3));
}

int GW_move2(int nDoc, int u, int v)
{
	int ret;
	if((GW_Params(nDoc)->p.GW_pu != u) || (GW_Params(nDoc)->p.GW_pv != v)) {
		GW_Params(nDoc)->x = TOOL_MOVE2;
		GW_Params(nDoc)->y = u;
		GW_Params(nDoc)->z = v;
		cmdbuff[0] = GW_GENDOTOOL;
		cmdbuff[1] = nDoc+0x20;
		cmdbuff[2] = '\0';
		if((ret = _errcheck(_sendmsg(3)))) {
			GW_Params(nDoc)->p.GW_pu = u;
			GW_Params(nDoc)->p.GW_pv = v;
		}
	} else
		ret = nDoc;
	return ret;
}

int GW_line2(int nDoc, int u, int v)
{
	int ret;
	GW_Params(nDoc)->y = u;
	GW_Params(nDoc)->z = v;
	cmdbuff[0] = GW_GENDOTOOL;
	cmdbuff[1] = nDoc+0x20;
	cmdbuff[2] = '\0';
	if((GW_Params(nDoc)->p.GW_pu < 0) || (GW_Params(nDoc)->p.GW_pu < 0))
		GW_Params(nDoc)->x = TOOL_MOVE2;
	else
		GW_Params(nDoc)->x = TOOL_LINE2;
	if((ret = _errcheck(_sendmsg(3)))) {
		GW_Params(nDoc)->p.GW_pu = u;
		GW_Params(nDoc)->p.GW_pv = v;
	}
	return ret;
}
