/* Globals.h
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#ifndef GLOBALSHINCLUDED
#define	GLOBALSHINCLUDED

#define DPI				(3.141592653589793238)
#define DPI2			(DPI*2)
#define PI				(3.141592f)
#define PI2				(PI*2)
#define IPI2			(3600)

#define FLOATCHECK	1

#define _GWQUIT_		INT_MIN+5
#define _GWCLOSED_		INT_MIN+4
#define _GWEXIT0_		INT_MIN+3
#define _GWABORT_		INT_MIN+2
#define _GWFATALERR_	INT_MIN+1
#define _GWFLOATTST_	-PI
#define _GWDOUBLETST_	-DPI

#define INVERTNOT		0x00990066
#define BIGXY			32767

#define LINESPERHEIGHT		30
#define GWSEPARATOR		';'

#define GRWINDIR		"GRWINDIR"
#define WndAppExe		"grwnd.exe"
#define szWndClsName 	"GrWnd"		// Class name used also as Icon & Menu names
#define szWndAppName 	"Graphics Window"

#define JPNCP		932		// {
#define USCP		1252	// Windows 3.1čiANSIj
#define MSWAIT 		60000	// wait time in opening GrWnd
#define MAXINSTS	16		// Max # of instances of grwnd.exe
#define MAXDOCS 	64		// Max # of documents per client
#define BUFFLEN		256
#define MAXPOINTS	256
#define MAXFLOATS	(MAXPOINTS*sizeof(POINT)/sizeof(FLOAT))
#define MAXDBLS		(MAXPOINTS*sizeof(POINT)/sizeof(double))
#define MAXDATA		(MAXPOINTS*sizeof(POINT)/sizeof(INT))
#define MAXBUFFER	(MAXPOINTS*sizeof(POINT)/sizeof(TCHAR))
#define MAXBYTES	(MAXPOINTS*sizeof(POINT))
#define NCOLOR 		36
#define FROMAPP 	1

#define NPEN		10
#define NBRUSH		8
#define NHATCH		6
#define NROP2		16			// # of ROP2 modes
#define NROP3		16			// # of ROP3 modes
#define NCURSOR		10

#define CAPPOINT	1
#define CAPRECT		2
#define CAPLINE		4
#define CAPVEC		8
#define CAPTURE		15
#define SLEEP		16
#define KEYUP		32
#define KEYDOWN		64
#define ONCHAR		128
#define IDLELOOP	256

#define IDLE		511		// CAPPOINT | ... | IDLELOOP
#define SETPANE		512		// IDLE + 1

#define FLG_PSTYLE	1
#define FLG_PWIDTH	2
#define FLG_PCOLOR	4

#define FLG_PEN		7		// FLG_PSTYLE + FLG_PWIDTH + FLG_PCOLOR

#define FLG_ROP2	8
#define FLG_BSTYLE	16
#define FLG_BCOLOR	32
#define FLG_BHATCH	64

#define FLG_BRS		112		// FLG_BSTYLE + FLG_BCOLOR + FLG_BHATCH
#define FLG_PENBRS	127

#define FLG_MTYPE	128
#define FLG_MSIZE	256
#define FLG_MCOLOR	512
#define FLG_MBACK	1024
#define FLG_MROP2	2048

#define FLG_MRK		3968

#define FLG_TEXT	4096	// not used
#define FLG_SYMBOL	8192	// not used

#define FLG_ALL		16383

enum _GWTOOLS {
	TOOL_FIRST,		// 0

// 
	TOOL_ANCHOR,	// 1
	TOOL_RESET,
	TOOL_SLEEP,
	TOOL_SLEEP2,

// set attributes
	TOOL_SETCOLOR,	// 5
	TOOL_SETGDI,
	TOOL_SETXFORM,
	TOOL_SETRGN,
	TOOL_SETTEXT,
	TOOL_SETSYMBOL,
	TOOL_MOVE2,		// 11

	TOOL_EMF,		// 12
	TOOL_DIB,
	TOOL_MARK,
	TOOL_TEXT,
	TOOL_SYMBOL,	// 16

	TOOL_FLOOD,		// 17

	TOOL_CLEAR,		// 18
	TOOL_PIXEL,

	TOOL_LINE2,		// 20
	TOOL_RECTANGLE,
	TOOL_SOLIDRECT,
	TOOL_ROUNDRECT,
	TOOL_ELLIPSE,
	TOOL_ARC,
	TOOL_CHORD,
	TOOL_PIE,
	TOOL_POLYGON,
	TOOL_BEZIER,
	TOOL_POLYLINE,	// 30

	TOOL_OG,
	TOOL_PLOT,
	TOOL_TTS,
	TOOL_TTSPEN,
	TOOL_TTSMARK,

	TOOL_LAST
};

/* Command */
enum _GWCMD {
	GW_GENDOTOOL = 'A',
	GW_CMD,
	GW_CAPTURE,
	GW_BITMAP,
	GW_WSIZE,
	GW_PIXEL,			// get pixel
	GW_SHOWWIN,
	GW_DRAW,
	GW_OPEN,
	GW_CLOSE,
	GW_INIT,
	GW_QUIT,
	GW_EMF,
	GW_GENTOOL,
	GW_SYSCHECK,
	GW_MODE,
	GW_TORTOISE,
	GWD_TORTOISE,
	GW_LAST
};

enum _TTS {
	TTS_SPAWN = 'A',
	TTS_TURN,
	TTS_FORWARD,
	TTS_SHIFT,
	TTS_MOVE2,
	TTS_CLONE,
	TTS_REMOVE,
	TTS_SETPOS,
	TTS_SETDIR,
	TTS_SETCOL,
	TTS_SETPEN,
	TTS_SETMRK,
	TTS_SETSYM,
	TTS_SETBMP,
	TTS_SETCMB,
	// 
	TTS_GETPOS,
	TTS_GETDIR,
	TTS_GETCOL,
	TTS_GETPEN,
	TTS_GETMRK,
	TTS_GETSYM,
	TTS_GETBMP,
	TTS_GETCMB,
	TTS_N
};

enum _CMD {
	CMD_MOUSE,		// 0
	CMD_KEYBOARD,
	CMD_STATUSBAR,
	CMD_MESSAGEBOX,
	CMD_REFRESH,
	CMD_ERASE,
	CMD_PRINT,
	CMD_CAPIMAGE,
	CMD_CLIPIMAGE,
	CMD_GETRGB,
	CMD_MODE,		// 10
	CMD_FILE_LOAD,
	CMD_FILE_SAVE,
	CMD_FILE_DIALOG,
	CMD_INPUT,
	CMD_VIEWMODE,
	CMD_ARRANGE,
	CMD_GETTEXTSIZE,
	CMD_GETSYMBOL,
	CMD_VIEWPORT,
	CMD_ALLOC,		// 20
	CMD_FREE,
	CMD_SELWIN,
	CMD_SETOGN,
	CMD_SAVEVP,
	CMD_SELVP,
	CMD_FLUSH,
	CMD_ERASEALL,
	CMD_RESET,
	CMD_ANCHOR,
	CMD_GETXFORM,	// 30
	CMD_GETVP,
	CMD_IDLELOOP,
	CMD_IDLELOOP2,
	CMD_BACKGROUND,
	CMD_EVENT,
	CMD_DATA,
	CMD_DOTOOL,
	CMD_DELTOOL,
	CMD_TIMER,
	CMD_CTIME,
	CMD_SETWINDOW,
	CMD_N
};

enum _ZOOMMODE {
	GWZ_BACK,
	GWZ_BITMAP,
	GWZ_ISOTROPIC,
	GWZ_FIT,
	GWZ_TOTAL,
	GWZ_IN,
	GWZ_PAINT
};

enum _GWT_OBJECTS {
	GWT_PEN = 1,	// == 1; do not change
	GWT_MRK,		// == 2; do not change
	GWT_SYM,		// == 3; do not change
	GWT_BMP,
	GWT_CMB,
	GWT_OBJ
};

enum _SHOWMODE {
	SHW_HIDE,
	SHW_MAXIMIZE,
	SHW_MINIMIZE,
	SHW_RESTORE,
	SHW_SHOW,
	SHW_SHOWMAXIMIZED,
	SHW_SHOWMINIMIZED,
	SHW_SHOWMINNOACTIVE,
	SHW_SHOWNA,
	SHW_SHOWNOACTIVATE,
	SHW_SHOWNORMAL,		// 10
	SHF_TOPMOST,
	SHF_NOTOPMOST,
	SHF_TOP,
	SHF_BOTTOM,
	SH_NSHOWMODE
};

enum _ARRANGE {
	ARNG_CASCADE = 1,
	ARNG_HORIZONTAL,
	ARNG_VERTICAL,
	ARNG_ICONARRANGE,
	ARNG_ACTIVATE,
	ARNG_MAXIMIZE,
	ARNG_RESTORE,
	ARNG_DESTROY,
	ARNG_N
};

enum _BMP {
	DIB_SET,
	DIB_LOADFILE,
	DIB_SAVEFILE,
	DIB_COPY,
	DIB_ATTR,
	DIB_MAKE,
	DIB_DATA,
	DIB_FONT,
	DIB_DEL,
	DIB_N
};

enum _EMF {
	EMF_BEGIN,
	EMF_END,
	EMF_LOADFILE,
	EMF_SAVEFILE,
	EMF_COPY,
	EMF_DEL,
	EMF_ATTR,
	EMF_MARK,
	EMF_N
};

enum WSIZE {
	WSZ_DOC = 1,
	WSZ_SCREEN,
	WSZ_FRAME,
	WPS_FRAME,
	WSZ_VIEW,
	WPS_VIEW,
	WSZ_VIEWPORT,
	WPS_VIEWPORT,
	WSZ_DFLTPSZ,
	WSZ_DFLTDPI,
	WSZ_PRNMRGN,
	WSZ_PRNTRES,
	WSZ_PRNTDPI,
	WSZ_PIXEL,
	WSZ_N
};

enum _MARKTYPE {
	Mt_DOT = 0,
	Mt_SOLIDSQ,
	Mt_CROSS,
	Mt_X,
	Mt_XCROSS,
	Mt_SQUARE,
	Mt_CIRCLE,
	Mt_N
};

enum _SYSCOLOR {
	Sc_SCROLLBAR,           // 0
	Sc_BACKGROUND,          // 1
	Sc_ACTIVECAPTION,       // 2
	Sc_INACTIVECAPTION,     // 3
	Sc_MENU,                // 4
	Sc_WINDOW,              // 5
	Sc_WINDOWFRAME,         // 6
	Sc_MENUTEXT,            // 7
	Sc_WINDOWTEXT,          // 8
	Sc_CAPTIONTEXT,         // 9
	Sc_ACTIVEBORDER,        // 10
	Sc_INACTIVEBORDER,      // 11
	Sc_APPWORKSPACE,        // 12
	Sc_HIGHLIGHT,           // 13
	Sc_HIGHLIGHTTEXT,       // 14
	Sc_BTNFACE,             // 15
	Sc_BTNSHADOW,           // 16
	Sc_GRAYTEXT,            // 17
	Sc_BTNTEXT,             // 18
	Sc_INACTIVECAPTIONTEXT, // 19
	Sc_BTNHIGHLIGHT,        // 20
	Sc_N
};

enum _OBJCOLOR {
	CLR_DEFBK,		// default background color
	CLR_FG,			// 1: color of item with odd # is initialized black
	CLR_BK,			// 2: color of item with even # is initialized white
	CLR_PEN,		// 3: 
	CLR_BRUSH,		// 4: 
	CLR_MARK,		// 5: 
	CLR_MARKBK,		// 6: 
	CLR_TEXT,		// 7: 
	CLR_TEXTBK,		// 8: 
	CLR_SYMBOL,		// 9: 
	CLR_SYMBOLBK,	//10: 
	CLR_PIXEL,		//11: 
	CLR_NOBJ,			// number of colors for objects + 1
	CLR_NCUSTOM = 20	// number of custom colors
};

enum _BRUSH {
	Bt_NULLBRUSH,
	Bt_SOLIDBRUSH,
	Bt_HATCHED,
	Bt_BSPATTERN,
	Bt_DIBPATTERN,
	Bt_DIBPATTERNPT
};

enum _REGION {
	GWR_COPY,
	GWR_AND,
	GWR_OR,
	GWR_DIFF,
	GWR_XOR,
	GWR_NRGNOP
};

enum _GDI {
	GDI_PEN,
	GDI_BRUSH,
	GDI_MARK,
	GDI_FONT,
	GDI_BITMAP,		// not used
	GDI_RGN,		// not used
	GDI_PALETTE,	// not used
	GDI_NGDIOBJ		// number of GDI objects
};

typedef struct _WNDPARAMS {
	FLOAT GW_Rx, GW_Ry;					// GW_Du*NLDC/WC = LDC/WC
	FLOAT GW_x1, GW_y1, GW_x2, GW_y2;	// ViewPort in WC
	FLOAT GW_u1, GW_v1, GW_u2, GW_v2;	// ViewPort in NLDC
	INT GW_Dw, GW_Dh		;			// paper size in pixels
	INT GW_Du, GW_Pm;	// LDC/NLDC, coordinate mode(0: World coordinate)
	INT GW_u0, GW_v0;

	INT GW_Og;			// current object group number; |GW_Og| < 32768

	INT GW_pu, GW_pv;	// previous point in LDCS
	DWORD GW_flags;							// flags for settings
	INT GW_Gm;								// polygon-filling mode
	INT GW_Cf, GW_Cb;						// foreground, background color
	INT GW_Ps, GW_Pw, GW_Pc, GW_Px;			// pen
	INT GW_Bs, GW_Bh, GW_Bc;				// brush
	INT GW_In, GW_Im, GW_It, GW_Io, GW_Ib;	// bitmap
	INT GW_Mt, GW_Ms, GW_Mc, GW_Mb, GW_Mm;	// mark
	INT GW_Ta, GW_Th, GW_To, GW_Tc, GW_Tb;			// text
	INT GW_Sa, GW_Sn, GW_Sh, GW_So, GW_Sc, GW_Sb;	// symbol
	INT GW_D1, GW_D2, GW_D3;				// dummy
	INT GW_Fn, GW_Fo;						// emf
} GWParams;		// sizeof(GWParams) == 208 == 16*13

typedef struct _WNDPPARAMS {
	GWParams p;

	INT x, y, z;
	union params_
	{
		struct
		{
			INT p0, p1, p2, p3;
		} i;
		struct
		{
			FLOAT y, yh, x, xh;
		} f;
		struct
		{
			double y, x;
		} d;
	} c;
	union work_area
	{
		POINT 	Points[MAXPOINTS];
		FLOAT 	Floats[MAXFLOATS];
		double 	Doubles[MAXDBLS];
		INT		Data[MAXDATA];
		BYTE	Bytes[MAXBYTES];
		TCHAR	Buffer[MAXBUFFER];
	} Work;
} WndParams;

#define WCtoLPx(x)	(GW_PM?floor5(x):floor5(GW_U0+((x)-GW_X1)*GW_RX))
#define LPtoWCx(u)	(GW_PM?((FLOAT)(u)):(GW_X1+((FLOAT)(u)-GW_U0)/GW_RX))
#define WCtoLPw(w)	(GW_PM?floor5(w):floor5((w)*fabs(GW_RX)))
#define LPtoWCw(w)	(GW_PM?((FLOAT)(w)):((FLOAT)((w)/fabs(GW_RX))))
#define WCtoLPdx(w)	(GW_PM?floor5(w):floor5((w)*GW_RX))
#define LPtoWCdx(w)	(GW_PM?((FLOAT)(w)):((FLOAT)((w)/GW_RX)))

#define WCtoLPy(y)	(GW_PM?floor5(y):floor5(GW_V0-((y)-GW_Y1)*GW_RY))
#define LPtoWCy(v)	(GW_PM?((FLOAT)(v)):(GW_Y1-((FLOAT)(v)-GW_V0)/GW_RY))
#define WCtoLPh(h)	(GW_PM?floor5(h):floor5((h)*fabs(GW_RY)))
#define LPtoWCh(h)	(GW_PM?((FLOAT)(h)):((FLOAT)((h)/fabs(GW_RY))))
#define WCtoLPdy(h)	(GW_PM?floor5(h):floor5((h)*GW_RY))
#define LPtoWCdy(h)	(GW_PM?((FLOAT)(h)):((FLOAT)((h)/GW_RY)))

#endif
