/* Events.c
 *
 * Copyright (C) 1998-2002 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"
#include <ctype.h>


/*0
L[{[hEXe[^X
*******************************************************************************
[F] SUBROUTINE GWKYBRD(IRTN, ICH, NCNT, IFLG, M)
    INTEGER IRTN, ICH, NCNT, IFLG, M

[C] int GWkybrd(int *ICH, int *NCNT, int *IFLG, int M);
-------------------------------------------------------------------------------
()
   ANeBuȃEBhEł̃L[{[h擾Bďo M ̒lɂ蓮
   삪قȂ(ȉQ)BωȂ(IRTN = 0)ƂCICH, NCNT, IFLG ̊e
   ̒l͕ωȂB
-------------------------------------------------------------------------------
(͕ϐ)
   M = 0   L[{[h擾Ēɐ߂
       1   VXeL[(L[Ȃ)C̃R[h ASCII R[hւ
           ϊI܂ő҂D
       2   ǂꂩL[܂ő҂
       3   ǂꂩL[܂ő҂
   ̑  L[ĂƂ͂̃L[܂ő҂CĂяoꂽƂ
           ̃L[{[hԂDL[ĂȂƂ͒ɐ߂
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = L[Ă΂̃L[̉zR[h(ĂȂƂ 0)
  ICH = ŌɉꂽVXeL[(L[Ȃ)̕R[h
 NCNT = L[Ƃ̃L[̉
 IFLG = tOBӖ̂rbg͈ȉ̒ʂF

          0-7  XL R[h (OEM ˑ̒l)
            8  t@NV L[␔L[pbh̃L[ȂǁCgL[̏
                1
        11-12  Windows Ŏgp
           13  Alt L[Ԃłق̃L[ꍇ 1CȊO 0
           14  OɃL[Ăꍇ 1CĂꍇ 0
           15  ϊ (L[𗣂Ăꍇ 1CĂꍇ 0)
*/
/*E
Get Keyboard Status On Window
*******************************************************************************
[F] SUBROUTINE GWKYBRD(IRTN, ICH, NCNT, IFLG, M)
    INTEGER IRTN, ICH, NCNT, IFLG, M

[C] int GWkybrd(int *ICH, int *NCNT, int *IFLG, int M);
-------------------------------------------------------------------------------
Description
   Gets the keyboard status on the associated window.  Depending on the value 
   of the argument M specified when invoked, the control returns in different 
   ways as seen in the following descriptions.   For each of ICH, NCNT and IFLG 
   the value remains unchanged if no change was detected (IRTN = 0).

Input
     M = 0: returns immediately with the keyboard status
         1: after a keystroke, e.g. SHIFT+A, waits for the compretion of the 
            translation to a nonsystem character (ASCII code).
         2: waits for a key down
         3: waits for a key up
 otherwise: if a key down was detected, waits for the key up and then returns 
            with the keyboard status on invoked, otherwise returns immediately

Output
 IRTN = The virtual-key code (Windows) if the key is down, 0 otherwise.
  ICH = The key code for the last nonsystem key down.
 NCNT = Repeat count (the number of times the keystroke is repeated as a result 
        of the user holding down the key).
 IFLG = Flags with meaningful bits listed as follows:

          0-7  Scan code (OEM-dependent value).
            8  Extended key, such as a function key or a key on the numeric keypad 
               (1 if it is an extended key).
           13  Context code (1 if the ALT key is held down while the key is 
               pressed; otherwise 0).
           14  Previous key state (1 if the key is down before the call, 0 if 
               the key is up).
           15  Transition state (1 if the key is being released, 0 if the key 
               is being pressed).
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWKYBRD "^";
#endif
int GWKYBRD(int *ret, int *ch, int *cnt, int *flg, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWKYBRD(int *ret, int *ch, int *cnt, int *flg, int *m)
#else
int gwkybrd_(int *ret, int *ch, int *cnt, int *flg, int *m)
#endif
#endif
{
	return (*ret = GW_kybrd(nDOC, ch, cnt, flg, *m));
}

int GWkybrd(int*ch, int *cnt, int *flg, int m)
{
	return GW_kybrd(nDOC, ch, cnt, flg, m);
}


/*0
}EX
*******************************************************************************
[F] SUBROUTINE GWMOUSE(IRTN, IRB, X, Y)
    INTEGER IRTN, IRB
    REAL X, Y

[C] int GWmouse(int *IRB, float *X, float *Y);
-------------------------------------------------------------------------------
()
   JgEEBhEł̃}EX擾B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = {^̏ (ĂȂƂ 0)
  IRB = E{^̏ (ĂȂƂ 0)
    X = }EXE|C^ X W([hWn)
    Y = }EXE|C^ Y W([hWn)
_______________________________________________________________________________
*/
/*E
Get Mouse Status
*******************************************************************************
[F] SUBROUTINE GWMOUSE(IRTN, IRB, X, Y)
    INTEGER IRTN, IRB
    REAL X, Y

[C] int GWmouse(int *IRB, float *X, float *Y);
-------------------------------------------------------------------------------
Description
   Gets the mouse status on the current window.

Input
   None

Output
 IRTN = The left button status. (0 when up)
  IRB = The right button status. (0 when up)
    X = X coordinate of the mouse pointer in World Coordinate System.
    Y = Y coordinate of the mouse pointer in World Coordinate System.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWMOUSE "^";
#endif
int GWMOUSE(int *ret, int *R, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWMOUSE(int *ret, int *R, float *x, float *y)
#else
int gwmouse_(int *ret, int *R, float *x, float *y)
#endif
#endif
{
	return (*ret = GWmouse(R, x, y));
}

int GWmouse(int *R, float *x, float *y)
{
	int u, v, ret;
	ret = GW_mouse(nDOC, R, &u, &v);
	GW_asgn(x, LPtoWCx(u));
	GW_asgn(y, LPtoWCy(v));
	return ret;
}

int GW_mouse(int nDoc, int *R, int *x, int *y)
{
	if(_command1(nDoc, GW_CMD, CMD_MOUSE)) {
		GW_asgn(x, GW_Params(nDoc)->c.i.p0);
		GW_asgn(y, GW_Params(nDoc)->c.i.p1);
		GW_asgn(R, GW_Params(nDoc)->c.i.p3);
		return GW_Params(nDoc)->c.i.p2;
	}
	return 0;
}


/*0
C^[oE^C}[
*******************************************************************************
[F] SUBROUTINE GWTIMER(IRTN, MS, N)
    INTEGER IRTN, MS, N

[C] int GWtimer(int MS, int N);
-------------------------------------------------------------------------------
()
   N != 0 ̏ꍇ̓C^[o^C}[NBN == 0 ̏ꍇɂ̓C^[o
   ^C}[~BC^[o^C}[Nƈ̎ԊԊu MS (~
   bP) Ń^C}[ECxgB^C}[ECxgǂ
    GWEVENT Ŏ擾BN > 0 ̏ꍇɂ N ̃^C}[ECxg𔭐
   C^C}[͒~B
-------------------------------------------------------------------------------
(͕ϐ)
    MS = ^C}[ECxg𔭐鎞ԊԊu(~bP)
     N  > 0: C^[o^C}[NC^C}[ECxg N 񔭐
        < 0: C^[o^C}[̋N
       == 0: C^[o^C}[̒~
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Interval Timer
*******************************************************************************
[F] SUBROUTINE GWTIMER(IRTN, MS, N)
    INTEGER IRTN, MS, N

[C] int GWtimer(int MS, int N);
-------------------------------------------------------------------------------
Description
   Starts the interval timer if N != 0 or stops it if N == 0.   The interval 
   timer generates timer events, which can be detected by GWEVENT, at regular 
   intervals specified with MS (milliseconds). If N > 0 the interval timer 
   stops after generating N timer events. 

Input
    MS  = the time interval between timer events (milliseconds)
     N  > 0: generates N timer events, and then stops the interval timer
        < 0: starts the interval timer
       == 0: stops the interval timer
Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTIMER "^";
#endif
int GWTIMER(int *ret, int *MS, int *N)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTIMER(int *ret, int *MS, int *N)
#else
int gwtimer_(int *ret, int *MS, int *N)
#endif
#endif
{
	return (*ret = GWtimer(*MS, *N));
}

int GWtimer(int MS, int N)
{
	return GW_timer(nDOC, MS, N);
}

int GW_timer(int nDoc, int MS, int N)
{
	return _command(nDoc, GW_CMD, CMD_TIMER, MS, N);
}


/*0
CxgԂ̎擾
*******************************************************************************
[F] SUBROUTINE GWEVENT(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWevent(float *X, float *Y);
-------------------------------------------------------------------------------
()
   JgEEBhẼCxgԂ擾BCxgԂ́CC^[o^
   C}[̐ݒ莞Ԃo߂CL[{[h̃{^}EX{^ƁC
   ̎_̃}EXJ[\̈ʒuƂƂɃZbgC{[`̌Ăяo
   ܂ŕێB{[`̌ĂяoCCxgԂ̓ZbgB
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN: Cxg
       >  0: ꂽL[̉zR[h
       = -1: }EX̍{^ꂽ
       = -2: }EX̉E{^ꂽ
       = -3: ^C}[ECxgiGWTIMER QƁj
     X = }EXE|C^ X W([hWn)
     Y = }EXE|C^ Y W([hWn)
_______________________________________________________________________________
*/
/*E
Get Event Status
*******************************************************************************
[F] SUBROUTINE GWEVENT(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWevent(float *X, float *Y);
-------------------------------------------------------------------------------
Description
   Gets the event status on the current window.   The event status is set with 
   the current mouse position when an event such that a key on the keyboard or 
   on the mouse is down or the interval timer is expired is detected, and is 
   kept until this routine is called.   The event status is reset by a call to 
   this routine.

Input
   None

Output
 IRTN =  0: no event detected
      >  0: the virtual-key code (Windows) of the key down detected last
      = -1: the left mouse button down
      = -2: the right mouse button down
      = -3: interval timer expired (see GWTIMER)
    X = the world X coordinate of the mouse pointer.
    Y = the world Y coordinate of the mouse pointer.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWEVENT "^";
#endif
int GWEVENT(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWEVENT(int *ret, float *x, float *y)
#else
int gwevent_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GWevent(x, y));
}

int GWevent(float *x, float *y)
{
	int u, v, ret;
	ret = GW_event(nDOC, &u, &v);
	GW_asgn(x, LPtoWCx(u));
	GW_asgn(y, LPtoWCy(v));
	return ret;
}

int GW_event(int nDoc, int *x, int *y)
{
	if(_command1(nDoc, GW_CMD, CMD_EVENT)) {
		GW_asgn(x, GW_Params(nDoc)->c.i.p0);
		GW_asgn(y, GW_Params(nDoc)->c.i.p1);
		return GW_Params(nDoc)->c.i.p2;
	}
	return 0;
}


/*0
AChO
*******************************************************************************
[F] SUBROUTINE GWIDLE(IRTN, ICH, X, Y, MSEC)
    INTEGER IRTN, ICH, MSEC
    REAL X, Y

[C] int GWidle(int *ICH, float *X, float *y, int MSEC);
-------------------------------------------------------------------------------
()
   L[{[h當͂邩}EX{^܂ŁC邢͎w肵
   Ԃo߂܂ŃAChOԂɂBAChO̓AvP[V
   䂪߂Ȃ̂ŁC̊ԁCAvP[V͒~B}EXɂW
   L[{[h͂҂ꍇC邢́CAvP[V̎s𒆒fĈ
   ʃ[h̕ύXȂǁCj[sꍇɗpłBIRTN ɂ̓ACh
   OԂ̌oߎԂԂBAChOԂł̓J[\L[Ń}EX|C^
   邱ƂłB
-------------------------------------------------------------------------------
(͕ϐ)
 MSEC = AChOԂ̏i~bPʁjB0 ܂͕̒lw肷 5 
        ɐݒ肳B
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN  = AChOoߎԁi~bPʁj
  ICH > 0: ꂽL[̕R[h(ASCII)
      = 0: AChOԂ̏ɒBꍇ
       -1: }EX̍{^ꂽꍇ
       -2: }EX̉E{^ꂽꍇ
    X = }EXE|C^ X W([hWn)
    Y = }EXE|C^ Y W([hWn)
*/
/*E
Idling
*******************************************************************************
[F] SUBROUTINE GWIDLE(IRTN, ICH, X, Y, MSEC)
    INTEGER IRTN, ICH, MSEC
    REAL X, Y

[C] int GWidle(int *ICH, float *X, float *y, int MSEC);
-------------------------------------------------------------------------------
Description
   Leaves the status of the application in idling mode, during which the 
   control is not returned and the execution of the application is suspended, 
   until a keyboard input or a mouse button down is detected, or the specified 
   time is elapsed.  In the idling mode the menu operations, e.g. Print, and 
   moves of the mouse pointer by the cursor keys can be done.

Input
   MSEC = the maximum elapsed time (milliseconds) for the idling.  If 0 or 
          a negative value is specified, the maximum elapsed time is set as 
          300000 (5 minutes).

Output
  IRTN  = the elapsed time (milliseconds)
  ICH > 0: the key code (ASCII) for the detected nonsystem key down
      = 0: the specified elapsed time expired
       -1: the left mouse button down was detected
       -2: the right mouse button down was detected
    X = the world x-coordinate of the mouse pointer
    Y = the world y-coordinate of the mouse pointer
*/


/*0
AChO 2
*******************************************************************************
[F] SUBROUTINE GWIDLE2(IRTN, ICH, X, Y, MSEC)
    INTEGER IRTN, ICH, MSEC
    REAL X, Y

[C] int GWidle2(int *ICH, float *X, float *y, int MSEC);
-------------------------------------------------------------------------------
()
   ̓p[^ MSEC ɂCAChOԂ̏vɂ鎞
   (GWSLEEP2 Q) Ŏw肷_ƁCIRTN ɕԂloߎԂł͂ȂC[^[
   ̓v̎ł_ GWIDLE ƓBv̏ 
   GWSLEEP2 ōsƂłB
*/
/*E
Idling 2
*******************************************************************************
[F] SUBROUTINE GWIDLE2(IRTN, ICH, X, Y, MSEC)
    INTEGER IRTN, ICH, MSEC
    REAL X, Y

[C] int GWidle2(int *ICH, float *X, float *y, int MSEC);
-------------------------------------------------------------------------------
Description
   Is the same as GWIDLE except that the meaning of the input parameter MSEC 
   is the time (milliseconds) measured by the internal clock (see GWSLEEP2) at 
   which the idling is stopped if no event that causes the termination of the 
   idling mode is detected, and the return value is not the elapsed time but 
   the time of the internal clock.   The internal clock can be reset to be 0 
   using GWSLEEP2.
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWIDLE2 "^";
#endif
int GWIDLE2(int *ret, int *ch, float *x, float *y, int *ms)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWIDLE2(int *ret, int *ch, float *x, float *y, int *ms)
#else
int gwidle2_(int *ret, int *ch, float *x, float *y, int *ms)
#endif
#endif
{
	return (*ret = GWidle2(ch, x, y, *ms));
}

int GWidle2(int *ch, float *x, float *y, int ms)
{
	int u, v, ret;
	ret = GW_idle2(nDOC, ch, &u, &v, ms);
	GW_asgn(x, LPtoWCx(u));
	GW_asgn(y, LPtoWCy(v));
	return ret;
}


#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWIDLE "^";
#endif
int GWIDLE(int *ret, int *ch, float *x, float *y, int *ms)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWIDLE(int *ret, int *ch, float *x, float *y, int *ms)
#else
int gwidle_(int *ret, int *ch, float *x, float *y, int *ms)
#endif
#endif
{
	return (*ret = GWidle(ch, x, y, *ms));
}

int GWidle(int *ch, float *x, float *y, int ms)
{
	int u, v, ret;
	ret = GW_idle(nDOC, ch, &u, &v, ms);
	GW_asgn(x, LPtoWCx(u));
	GW_asgn(y, LPtoWCy(v));
	return ret;
}


/*1
X[v
*******************************************************************************
[F] SUBROUTINE GWSLEEP(IRTN, MS)
    INTEGER IRTN, MS

[C] int GWsleep(int MS);
-------------------------------------------------------------------------------
()
    ~ (1/1000) bPʂŎs~B
-------------------------------------------------------------------------------
(͕ϐ)
   MS = s~鎞(~bP)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Sleep
*******************************************************************************
[F] SUBROUTINE GWSLEEP(IRTN, MS)
    INTEGER IRTN, MS

[C] int GWsleep(int MS);
-------------------------------------------------------------------------------
Description
    Suspends execution for the specified time in milliseconds.

Input
   MS = the time, in milliseconds, for which to suspend execution.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSLEEP "^";
#endif
int GWSLEEP(int *ret, int *ms)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSLEEP(int *ret, int *ms)
#else
int gwsleep_(int *ret, int *ms)
#endif
#endif
{
	if(*ms < 0)
		return (*ret = 0);
	return (*ret = GW_sleep(nDOC, *ms));
}

int GWsleep(int ms)
{
	if(ms < 0)
		return 0;
	return GW_sleep(nDOC, ms);
}

int GW_sleep(int nDoc, int ms)
{
	if(_command2(nDoc, GW_GENDOTOOL, TOOL_SLEEP, ms)) 
		return nDoc;
	return 0;
}


/*1
X[v 2
*******************************************************************************
[F] SUBROUTINE GWSLEEP2(IRTN, MS)
    INTEGER IRTN, MS

[C] int GWsleep2(int MS);
-------------------------------------------------------------------------------
()
    w肵ɒB܂Ŏs~B ( > 0, ~bP) ̌v͊e
    EBhEƂɗpӂꂽvɂčsB͕ϐ MS  0 ܂
    ̐lw肵ꍇɂ́Cv̎ |MS| ɏCɐ
    ߂ (s~Ȃ)B܂CMS Ɍ݂̓v̎O̎ 
    ( > 0) w肳ꂽꍇɂɐ䂪߂Bv̓EBhẼI[
    v 0 ɏBv̎ GWCTIME Ŏ擾łB
-------------------------------------------------------------------------------
(͕ϐ)
     MS > 0: sĊJ̗\莞 (~bP)
       <= 0: v |MS| ̒lɏ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = Ăяo̓v̎ (~bP)
_______________________________________________________________________________
*/
/*E
Sleep 2
*******************************************************************************
[F] SUBROUTINE GWSLEEP2(IRTN, MS)
    INTEGER IRTN, MS

[C] int GWsleep2(int MS);
-------------------------------------------------------------------------------
Description
    Suspends execution until the specified wake-up time is up.  The time 
    ( > 0, in milliseconds) is measured with the internal clock associated with 
    the current window.  If a value MS <= 0 is specified, the time of the 
    internal clock is set to be |MS| and the control is returned immediately.
    If the wake-up time specified with MS (> 0) is earlier than the current 
    time, which can be obtained by GWCTIME, the control is returned immediately.
    On opening a window the time of the associated internal clock is reset to 
    be 0.

Input
    MS > 0: the wake-up time (in milliseconds) at which the control is to be 
            returned.
      <= 0: the time of the internal clock is initialized with the value |MS|

Output
  IRTN = the time (in milliseconds) of the internal clock at the invocation
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSLEEP2 "^";
#endif
int GWSLEEP2(int *ret, int *ms)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSLEEP2(int *ret, int *ms)
#else
int gwsleep2_(int *ret, int *ms)
#endif
#endif
{
	if(*ms < 0)
		return (*ret = 0);
	return (*ret = GW_sleep2(nDOC, *ms));
}

int GWsleep2(int ms)
{
	if(ms < 0)
		return 0;
	return GW_sleep2(nDOC, ms);
}

int GW_sleep2(int nDoc, int ms)
{
	if(_command2(nDoc, GW_GENDOTOOL, TOOL_SLEEP2, ms)) 
		return nDoc;
	return 0;
}


/*0
ݎ̎擾
*******************************************************************************
[F] SUBROUTINE GWCTIME(IRTN)
    INTEGER IRTN

[C] int GWctime(void);
-------------------------------------------------------------------------------
()
    EBhEƂɗpӂꂽv̌ݎ (~bP) 擾B
-------------------------------------------------------------------------------
(͕ϐ)
     Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ݎ (~bP)
_______________________________________________________________________________
*/
/*E
Get Current time
*******************************************************************************
[F] SUBROUTINE GWCTIME(IRTN)
    INTEGER IRTN

[C] int GWctime(void);
-------------------------------------------------------------------------------
Description
    Gets the current time (in milliseconds) of the internal clock associated 
    with the current window.  

Input
    None

Output
  IRTN = the current time of the internal clock (in milliseconds)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCTIME "^";
#endif
int GWCTIME(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCTIME(int *ret)
#else
int gwctime_(int *ret)
#endif
#endif
{
	return (*ret = GW_ctime(nDOC));
}

int GWctime(void)
{
	return GW_ctime(nDOC);
}

int GW_ctime(int nDoc)
{
	return _command1(nDoc, GW_CMD, CMD_CTIME);
}


/*0
|[Y
*******************************************************************************
[F] SUBROUTINE GWPAUSE(IRTN, TXT)
    INTEGER IRTN
    CHARACTER TXT*(*)

[C] int GWpause(char *TXT);
-------------------------------------------------------------------------------
()
    bZ[W{bNX\C{^܂ő҂B
-------------------------------------------------------------------------------
(͕ϐ)
   TXT = bZ[W̕
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Pause
*******************************************************************************
[F] SUBROUTINE GWPAUSE(IRTN, TXT)
    INTEGER IRTN
    CHARACTER TXT*(*)

[C] int GWpause(char *TXT);
-------------------------------------------------------------------------------
Description
    Pops up a message box, and wait for a button selected.

Input
   TXT = string to be displayed in the message box

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPAUSE "^";
int GWPAUSE(int *ret, CHARACTER *txt)
#else
int GWPAUSE(int *ret, char *txt, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPAUSE(int *ret, char *txt, int l)
#else
int gwpause_(int *ret, char *txt, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_pause(nDOC, _copyBuff(nDOC, txt->p, txt->l)));
#else
	return (*ret = GW_pause(nDOC, _copyBuff(nDOC, txt, l)));
#endif
}

int GWpause(char *txt)
{
	return GW_pause(nDOC, txt);
}

int GW_pause(int nDoc, char *txt)
{
	_setBuff(nDoc, txt);
	return _command2(nDoc, GW_CMD, CMD_MESSAGEBOX, 1);
}
