// How To Determine Whether an Application is Console or GUI
// Last reviewed: December 16, 1996
// Article ID: Q90493  
// The information in this article applies to: 
// Microsoft Win32 Application Programming Interface (API) included with: 
//     - Microsoft Windows NT versions 3.1, 3.5, 3.51, 4.0
//     - Microsoft Windows 95 version 4.0
// 
// SUMMARY
// In order to determine whether an application is console or GUI, you 
// must parse the EXEheader. The header contains a field called 
// 'Subsystem'. This field determines both the subsystem the application 
// is to run under and the type of interface it requires.

#ifdef __DMC__
typedef unsigned short wchar_t;
#define _inline
#include <stdio.h>
#include <windef.h>
#include <winbase.h>
#else
#include <windows.h>
#endif

#include "Messages.h"
#include "Globals.h"
#include "GrWinAll.h"

//#define DEBUG

#if !defined(__MINGW32__) && !defined(_UWIN)	// for egcs-1.1.2 or cygb20+gcc-2.95

#ifndef IMAGE_NUMBEROF_DIRECTORY_ENTRIES
#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES    16
#endif

#ifndef IMAGE_SIZEOF_NT_OPTIONAL_HEADER
#define IMAGE_SIZEOF_NT_OPTIONAL_HEADER      224
#endif

//
// Directory format.
//
#if !defined(__LCC__)

#ifndef IMAGE_SIZEOF_FILE_HEADER		// for Cygb20

typedef struct _IMAGE_DATA_DIRECTORY {
    DWORD   VirtualAddress;
    DWORD   Size;
} IMAGE_DATA_DIRECTORY, *PIMAGE_DATA_DIRECTORY;

//
// Optional header format.
//

typedef struct _IMAGE_OPTIONAL_HEADER {
    //
    // Standard fields.
    //

    WORD    Magic;
    BYTE    MajorLinkerVersion;
    BYTE    MinorLinkerVersion;
    DWORD   SizeOfCode;
    DWORD   SizeOfInitializedData;
    DWORD   SizeOfUninitializedData;
    DWORD   AddressOfEntryPoint;
    DWORD   BaseOfCode;
    DWORD   BaseOfData;

    //
    // NT additional fields.
    //

    DWORD   ImageBase;
    DWORD   SectionAlignment;
    DWORD   FileAlignment;
    WORD    MajorOperatingSystemVersion;
    WORD    MinorOperatingSystemVersion;
    WORD    MajorImageVersion;
    WORD    MinorImageVersion;
    WORD    MajorSubsystemVersion;
    WORD    MinorSubsystemVersion;
    DWORD   Win32VersionValue;
    DWORD   SizeOfImage;
    DWORD   SizeOfHeaders;
    DWORD   CheckSum;
    WORD    Subsystem;
    WORD    DllCharacteristics;
    DWORD   SizeOfStackReserve;
    DWORD   SizeOfStackCommit;
    DWORD   SizeOfHeapReserve;
    DWORD   SizeOfHeapCommit;
    DWORD   LoaderFlags;
    DWORD   NumberOfRvaAndSizes;
    IMAGE_DATA_DIRECTORY DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
} IMAGE_OPTIONAL_HEADER, *PIMAGE_OPTIONAL_HEADER;

//
// File header format.
//

typedef struct _IMAGE_FILE_HEADER {
    WORD    Machine;
    WORD    NumberOfSections;
    DWORD   TimeDateStamp;
    DWORD   PointerToSymbolTable;
    DWORD   NumberOfSymbols;
    WORD    SizeOfOptionalHeader;
    WORD    Characteristics;
} IMAGE_FILE_HEADER, *PIMAGE_FILE_HEADER;
#endif
#endif

#define IMAGE_SIZEOF_FILE_HEADER             20

// Subsystem Values

#define IMAGE_SUBSYSTEM_UNKNOWN              0   // Unknown subsystem.
#define IMAGE_SUBSYSTEM_NATIVE               1   // Image doesn't require a subsystem.
#define IMAGE_SUBSYSTEM_WINDOWS_GUI          2   // Image runs in the Windows GUI subsystem.
#define IMAGE_SUBSYSTEM_WINDOWS_CUI          3   // Image runs in the Windows character subsystem.
#define IMAGE_SUBSYSTEM_OS2_CUI              5   // image runs in the OS/2 character subsystem.
#define IMAGE_SUBSYSTEM_POSIX_CUI            7   // image runs in the Posix character subsystem.
#define IMAGE_SUBSYSTEM_NATIVE_WINDOWS       8   // image is a native Win9x driver.
#define IMAGE_SUBSYSTEM_WINDOWS_CE_GUI       9   // Image runs in the Windows CE subsystem.

#endif		// for egcs-1.1.2 or cygb20+gcc-2.95

extern UINT CodePage;

static VOID  ReadBytes(HANDLE, LPVOID, DWORD);

BOOL IsWinGUI(char *fname)
{
    HANDLE hImage;

    DWORD  MoreDosHeader[16];

    ULONG  ntSignature;

    IMAGE_DOS_HEADER      image_dos_header;
    IMAGE_FILE_HEADER     image_file_header;
    IMAGE_OPTIONAL_HEADER image_optional_header;

	/*
	 *  Open the reference file.
	 */
    hImage = CreateFile(fname,GENERIC_READ,FILE_SHARE_READ,NULL,
                        OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);

    if (INVALID_HANDLE_VALUE == hImage) {
		if(CodePage == JPNCP) ErrorMessage(1, 
			IDS_JP_ERROPEN2, fname, GetLastError());
		else ErrorMessage(1, 
			IDS_EN_ERROPEN2, fname, GetLastError());
        exit(1);
    }

    /*
	 *  Read the MS-DOS image header.
	 */
    ReadBytes(hImage,&image_dos_header,sizeof(IMAGE_DOS_HEADER));

    if (IMAGE_DOS_SIGNATURE != image_dos_header.e_magic) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERRFILE, fname);
		else ErrorMessage(1, IDS_EN_ERRFILE, fname);
        exit(1);
    }

    /*
	 *  Read more MS-DOS header.       */
    ReadBytes(hImage,MoreDosHeader,sizeof(MoreDosHeader));

    if (SetFilePointer(hImage, image_dos_header.e_lfanew, NULL, FILE_BEGIN) 
    	== 0xFFFFFFFF) {
        ErrorMessage(1, "SetFilePointer failed, error %lu.", GetLastError());
        exit(1);
    }
    ReadBytes (hImage, &ntSignature, sizeof(ULONG));
    if (IMAGE_NT_SIGNATURE != ntSignature) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_MISSINGNT);
		else ErrorMessage(1, IDS_EN_MISSINGNT);
		exit(1);
    }

    ReadBytes(hImage,&image_file_header,IMAGE_SIZEOF_FILE_HEADER);

    /*
	 *  Read optional header.
	 */
    ReadBytes(hImage,&image_optional_header,IMAGE_SIZEOF_NT_OPTIONAL_HEADER);

#ifdef DEBUG
    switch (image_optional_header.Subsystem) {
    case IMAGE_SUBSYSTEM_UNKNOWN:
        ErrorMessage(1, "Type is unknown.");
        break;
    case IMAGE_SUBSYSTEM_NATIVE:
        ErrorMessage(1, "Type is native.");
        break;
    case IMAGE_SUBSYSTEM_WINDOWS_GUI:
        ErrorMessage(1, "Type is Windows GUI.");
        break;
    case IMAGE_SUBSYSTEM_WINDOWS_CUI:
        ErrorMessage(1, "Type is Windows CUI.");
        break;
    case IMAGE_SUBSYSTEM_OS2_CUI:
        ErrorMessage(1, "Type is OS/2 CUI.");
        break;
    case IMAGE_SUBSYSTEM_POSIX_CUI:
        ErrorMessage(1, "Type is POSIX CUI.");
        break;
    case IMAGE_SUBSYSTEM_NATIVE_WINDOWS:
        ErrorMessage(1, "Type is a native Win9x driver.");
        break;
    case IMAGE_SUBSYSTEM_WINDOWS_CE_GUI:
        ErrorMessage(1, "Type is Windows CE.");
        break;
    default:
        ErrorMessage(1, "Unknown type %u.", image_optional_header.Subsystem);
        break;
    }
#endif

    return image_optional_header.Subsystem == IMAGE_SUBSYSTEM_WINDOWS_GUI;
}

static VOID ReadBytes(HANDLE hFile, LPVOID buffer, DWORD  size)
{
    DWORD bytes;

    if (!ReadFile(hFile, buffer, size, &bytes, NULL)) {
		if(CodePage == JPNCP) ErrorMessage(1, IDS_JP_ERRREAD, GetLastError());
		else ErrorMessage(1, IDS_EN_ERRREAD, GetLastError());
        exit(1);
    } else if (size != bytes) {
        ErrorMessage(1, 
        	"Read the wrong number of bytes, expected %lu, got %lu.",
               size, bytes);
        exit(1);
    }
}
