/* Capture.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"


/*0
}EXɂ_W̎擾
*******************************************************************************
[F] SUBROUTINE GWCAPPNT(IRTN, X, Y, TEXT)
    INTEGER IRTN
    REAL X, Y
    CHARACTER TEXT*(*)

[C] int GWcappnt(float *X, float *Y, char *TEXT);
-------------------------------------------------------------------------------
()
   }EX̍{^܂ő҂C̓_̍WƘ_Fԍ ( GWCOLOR Q) 
   ԂB
-------------------------------------------------------------------------------
(͕ϐ)
   TEXT = Xe[^Xo[ɕ\镶
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = _Fԍ (-1: s̏ꍇ)
    X = }EX̍{^ꂽ_ X W([hWn)
    Y = }EX̍{^ꂽ_ Y W([hWn)
_______________________________________________________________________________
*/
/*E
Capture Point
*******************************************************************************
[F] SUBROUTINE GWCAPPNT(IRTN, X, Y, TEXT)
    INTEGER IRTN
    REAL X, Y
    CHARACTER TEXT*(*)

[C] int GWcappnt(float *X, float *Y, char *TEXT);
-------------------------------------------------------------------------------
Description
   Wait for the left mouse button turned down, and retrieve the world x, y 
   coordinates and the logical color (see GWCOLOR) value of the point.

Input
   TEXT = a string to be notified at the status bar.

Output
 IRTN = the logical color value ( -1 if failed )
    X = the world x-coordinate of the point
    Y = the world y-coordinate of the point
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCAPPNT "^";
int GWCAPPNT(int *ret, float *x, float *y, CHARACTER *text)
#else
int GWCAPPNT(int *ret, float *x, float *y, char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCAPPNT(int *ret, float *x, float *y, char *text, int l)
#else
int gwcappnt_(int *ret, float *x, float *y, char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWcappnt(x, y, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GWcappnt(x, y, _copyBuff(nDOC, text, l)));
#endif
}

int GWcappnt(float *x, float *y, char *txt)
{
	int u, v, ret;
	ret = GW_cappoint(nDOC, &u, &v, txt);
	GW_asgn(x, LPtoWCx(u));
	GW_asgn(y, LPtoWCy(v));
	return ret;
}

int GW_cappoint(int nDoc, int *u, int *v, char *txt)
{
	int ret;
	_setBuff(nDoc, txt);
	ret = _command1(nDoc, GW_CAPTURE, CAPPOINT);
	if(ret > 0) {
		GW_asgn(u, GW_Params(nDoc)->c.i.p1);
		GW_asgn(v, GW_Params(nDoc)->c.i.p2);
		return GW_Params(nDoc)->c.i.p3;
	}
	return ret;
}


/*0
}EXɂxNg̎擾
*******************************************************************************
[F] SUBROUTINE GWCAPVEC(IRTN, X1, Y1, X2, Y2, TEXT)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcapvec(float X1, float Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
()
   xNg̎n_^āC}EX̃{^܂ő҂C̓_̍W
   BI_m肷܂ŁCn_ƌ݂̃}EX|C^Ԑ\B
-------------------------------------------------------------------------------
(͕ϐ)
   TEXT = Xe[^Xo[ɕ\镶
   X1 = n_ X W([hWn)
   Y1 = n_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN  = 1: }EX̍{^ꂽꍇ
       = 2: }EX̉E{^ꂽꍇ
      <= 0: ̑
    X2 = I_ X W([hWn)
    Y2 = I_ Y W([hWn)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Capture Vector
*******************************************************************************
[F] SUBROUTINE GWCAPVEC(IRTN, X1, Y1, X2, Y2, IBTN, TEXT)
    INTEGER IRTN, IBTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcapvec(float X1, float Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
Description
   Giving the coordinates of a beginning point as inputs, wait for the left 
   mouse button turned down, and retrieve the world x, y coordinates.   In 
   capturing, a rubber band connecting the beginning point and the current 
   mouse pointer is displayed.

Input
   TEXT = a string to be notified at the status bar.
   X1 = the world x-coordinate of the beginning point
   Y1 = the world y-coordinate of the beginning point

Output
 IRTN = 1: the left button was pushed to get the end point
      = 2: the right button was pushed to get the end point
     <= 0: otherwise
   X2 = the world x-coordinate of the end point
   Y2 = the world y-coordinate of the end point
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCAPVEC "^";
int GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
	CHARACTER *text)
#else
int GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
	char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
	char *text, int l)
#else
int gwcapvec_(int *ret, float *x1, float *y1, float *x2, float *y2, 
	char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWcapvec(*x1, *y1, x2, y2, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GWcapvec(*x1, *y1, x2, y2, _copyBuff(nDOC, text, l)));
#endif
}

int GWcapvec(float x1, float y1, float *x2, float *y2, char *txt)
{
	int u, v, ret;
	ret = GW_capvec(nDOC, WCtoLPx(x1), WCtoLPy(y1), &u, &v, txt);
	if(ret <= 0) return ret;
	GW_asgn(x2, LPtoWCx(u));
	GW_asgn(y2, LPtoWCy(v));
	return ret;
}

int GW_capvec(int nDoc, int x1, int y1, int *x2, int *y2, char *txt)
{
	int ret;
	_setBuff(nDoc, txt);
	ret = _command(nDoc, GW_CAPTURE, CAPVEC, x1, y1);
	if(ret <= 0) return ret;
	GW_asgn(x2, GW_Params(nDoc)->c.i.p1);
	GW_asgn(y2, GW_Params(nDoc)->c.i.p2);
	return ret;
}


/*0
}EXɂW̎擾
*******************************************************************************
[F] SUBROUTINE GWCAPLIN(IRTN, X1, Y1, X2, Y2, TEXT)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcaplin(float *X1, float *Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
()
   }EXhbO܂ő҂ChbOJn_ƏI_̍WԂBhbO
   ̓hbOJn_ƌ݂̃}EX|C^Ԑ\B܂Chb
   OɉE{^΃hbÔ蒼łB
-------------------------------------------------------------------------------
(͕ϐ)
   TEXT = Xe[^Xo[ɕ\镶
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0: I
     <= 0: LZC
   X1 = hbOJn_ X W([hWn)
   Y1 = hbOJn_ Y W([hWn)
   X2 = hbOI_ X W([hWn)
   Y2 = hbOI_ Y W([hWn)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Capture Line
*******************************************************************************
[F] SUBROUTINE GWCAPLIN(IRTN, X1, Y1, X2, Y2, TEXT)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcaplin(float *X1, float *Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
Description
   Wait for the end of mouse dragging, and return the coordinates of the 
   beginning point, where the left mouse button is turned down, and the end 
   point, where the left mouse button is released.   In dragging, a rubber band 
   connecting between the beginning point and the current mouse pointer is 
   displayed, and the dragging can be canceled by the right mouse button.

Input
   TEXT = a string to be notified at the status bar.

Output
 IRTN > 0: succeeded
     <= 0: canceled
   X1 = the world x-coordinate of the beginning point
   Y1 = the world y-coordinate of the beginning point
   X2 = the world x-coordinate of the end point
   Y2 = the world y-coordinate of the end point
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCAPLIN "^";
int GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		CHARACTER *text)
#else
int GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#else
int gwcaplin_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWcaplin(x1, y1, x2, y2, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GWcaplin(x1, y1, x2, y2, _copyBuff(nDOC, text, l)));
#endif
}

int GWcaplin(float *x1, float *y1, float *x2, float *y2, char *txt)
{
	int u1, v1, u2, v2, ret;
	ret = GW_capline(nDOC, &u1, &v1, &u2, &v2, txt);
	GW_asgn(x1, LPtoWCx(u1));
	GW_asgn(y1, LPtoWCy(v1));
	GW_asgn(x2, LPtoWCx(u2));
	GW_asgn(y2, LPtoWCy(v2));
	return ret;
}

int GW_capline(int nDoc, int *x1, int *y1, int *x2, int *y2, char *txt)
{
	int ret;
	_setBuff(nDoc, txt);
	ret = _command1(nDoc, GW_CAPTURE, CAPLINE);
	if(ret <= 0) return ret;
	GW_asgn(x1, GW_Params(nDoc)->c.i.p0);
	GW_asgn(y1, GW_Params(nDoc)->c.i.p1);
	GW_asgn(x2, GW_Params(nDoc)->c.i.p2);
	GW_asgn(y2, GW_Params(nDoc)->c.i.p3);
	return ret;
}


/*0
}EXɂ`W̎擾
*******************************************************************************
[F] SUBROUTINE GWCAPRECT(IRTN, X1, Y1, X2, Y2, TEXT)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcaprect(float *X1, float *Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
()
   }EXhbOCE{^܂ő҂ChbOJn_ƏI_
   WԂB}EXhbOƋ`̈悪邪CE{^
   ܂ł͊m肵Ȃ̂ŁC`̋hbO邱ƂőÏύXłB
   ܂ChbOɉE{^΃hbÔ蒼łB
-------------------------------------------------------------------------------
(͕ϐ)
   TEXT = Xe[^Xo[ɕ\镶
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN != 0: I
       = 0: LZC
    X1 = hbOJn_ X W([hWn)
    Y1 = hbOJn_ Y W([hWn)
    X2 = hbOI_ X W([hWn)
    Y2 = hbOI_ Y W([hWn)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Capture Rectangle
*******************************************************************************
[F] SUBROUTINE GWCAPRECT(IRTN, X1, Y1, X2, Y2, TEXT)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2
    CHARACTER TEXT*(*)

[C] int GWcaprect(float *X1, float *Y1, float *X2, float *Y2, char *TEXT);
-------------------------------------------------------------------------------
Description
   Wait for the end of mouse dragging followed by the right mouse button turned 
   down.   The coordinates of the beginning point, where the left mouse button 
   is turned down, and the end point, where the left mouse button is released,  
   are returned.   In dragging, a rectangular rubber band whose diagonal is the 
   pair of the beginning point and the current mouse pointer is displayed, and 
   the dragging can be canceled by the right mouse button.   Until the right 
   mouse button is turned down after dragging the rectangle to be captured can 
   be changed by dragging a corner of the rectangular rubber band displayed.

Input
   TEXT = a string to be notified at the status bar.

Output
 IRTN != 0: succeeded
       = 0: canceled
    X1 = the world x-coordinate of the beginning point
    Y1 = the world y-coordinate of the beginning point
    X2 = the world x-coordinate of the end point
    Y2 = the world y-coordinate of the end point
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCAPRECT "^";
int GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		CHARACTER *text)
#else
int GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#else
int gwcaprect_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GWcaprect(x1, y1, x2, y2, _copyBuff(nDOC, text->p, text->l)));
#else
	return (*ret = GWcaprect(x1, y1, x2, y2, _copyBuff(nDOC, text, l)));
#endif
}

int GWcaprect(float *x1, float *y1, float *x2, float *y2, char *txt)
{
	int u1, v1, u2, v2, ret;
	ret = GW_caprect(nDOC, &u1, &v1, &u2, &v2, txt);
	GW_asgn(x1, LPtoWCx(u1));
	GW_asgn(y1, LPtoWCy(v1));
	GW_asgn(x2, LPtoWCx(u2));
	GW_asgn(y2, LPtoWCy(v2));
	return ret;
}

int GW_caprect(int nDoc, int *x1, int *y1, int *x2, int *y2, char *txt)
{
	int ret;
	_setBuff(nDoc, txt);
	ret = _command1(nDoc, GW_CAPTURE, CAPRECT);
	if(ret <= 0) return ret;
	GW_asgn(x1, GW_Params(nDoc)->c.i.p0);
	GW_asgn(y1, GW_Params(nDoc)->c.i.p1);
	GW_asgn(x2, GW_Params(nDoc)->c.i.p2);
	GW_asgn(y2, GW_Params(nDoc)->c.i.p3);
	return ret;
}
