/* Bitmap.c
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*0
rbg}bvt@C̓ǂݍ
*******************************************************************************
[F] SUBROUTINE GWLOADBMP(IRTN, NB, FN)
    INTEGER IRTN, NB
    CHARACTER FN*(*)

[C] int GWloadbmp(int NB, char *FN);
-------------------------------------------------------------------------------
()
    rbg}bvt@C(*.bmp)ǂݍ݁Crbg}bvԍ NB ɓo^BU
    o^ꂽrbg}bv̓rbg}bvԍɂ艽xłp邱ƂłB
    rbg}bv̓o^ɏ݂͐ĂȂȂ,̓[CVXeE
    [\[X̗ʂɈˑBVXeE[\[Xg؂Ƃ̓ɂ
    Ă͂قƂǃ`FbNsĂȂ̂ŗvӁB
-------------------------------------------------------------------------------
(͕ϐ)
    NB = rbg}bvԍ(1`): ǂݍ񂾃rbg}bvۑz̗vfԍB
         NB = 0 ƂƖgp̔zvfgB
    FN = rbg}bvt@C(rbg}bvt@C͎st@CƓfB
         NgɒuCtpXŎw肵Ȃ΂ȂȂ)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ۂɃrbg}bvۑzvfԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Load Bitmap
*******************************************************************************
[F] SUBROUTINE GWLOADBMP(IRTN, NB, FN)
    INTEGER IRTN, NB
    CHARACTER FN*(*)

[C] int GWloadbmp(int NB, char *FN);
-------------------------------------------------------------------------------
Description
    Load a bitmap from a bitmap file (*.bmp) with bitmap number NB.  When NB = 0 
    unused array element is used.   Maximun number of stored bitmaps depends 
    on amount of available system resources though is not restricted.  It 
    should be noted that no test has been done for the case where available 
    system resources are exhausted.

Input
    NB = bitmap number (>0) or 0 to use unused array element.
    FN = bitmap file name (the bitmap file must be in the same directory as the 
         exe file for the application unless specified as full path).

Output
  IRTN = bitmap number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLOADBMP "^";
int GWLOADBMP(int *ret, int *nb, CHARACTER *fname)
#else
int GWLOADBMP(int *ret, int *nb, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLOADBMP(int *ret, int *nb, char *fname, int l)
#else
int gwloadbmp_(int *ret, int *nb, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_loadbitmap(nDOC, *nb, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_loadbitmap(nDOC, *nb, _copyBuff(nDOC, fname, l)));
#endif
}

int GWloadbmp(int nb, char *fname)
{
	return GW_loadbitmap(nDOC, nb, fname);
}

int GW_loadbitmap(int nDoc, int nb, char *fname)
{
	int ret;
	FILE *fp;
	if(_setBuff(nDoc, fname) == 0) _setBuff(nDoc, "*.bmp");
	if((fp = fopen(GW_Buffer(nDoc), "r"))) {
		fclose(fp);
	} else {
		if(_command1(nDoc, GW_CMD, CMD_FILE_DIALOG) != IDOK)
			return 0;
	}
	if(_command2(nDoc, GW_BITMAP, DIB_LOADFILE, nb) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
rbg}bvt@C̕ۑ
*******************************************************************************
[F] SUBROUTINE GWSAVEBMP(IRTN, NB, FN)
    INTEGER IRTN, NB
    CHARACTER FN*(*)

[C] int GWsavebmp(int NB, char *FN);
-------------------------------------------------------------------------------
()
    ԍ NB ̃rbg}bvt@CɕۑB
-------------------------------------------------------------------------------
(͕ϐ)
    NB = rbg}bvԍ
    FN = rbg}bvt@C
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Save Bitmap
*******************************************************************************
[F] SUBROUTINE GWSAVEBMP(IRTN, NB, FN)
    INTEGER IRTN, NB
    CHARACTER FN*(*)

[C] int GWsavebmp(int NB, char *FN);
-------------------------------------------------------------------------------
Description
    Save the bitmap specified by NB to a bitmap file.

Input
    NB = bitmap number
    FN = bitmap file name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVEBMP "^";
int GWSAVEBMP(int *ret, int *nb, CHARACTER *fname)
#else
int GWSAVEBMP(int *ret, int *nb, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVEBMP(int *ret, int *nb, char *fname, int l)
#else
int gwsavebmp_(int *ret, int *nb, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_savebitmap(nDOC, *nb, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_savebitmap(nDOC, *nb, _copyBuff(nDOC, fname, l)));
#endif
}

int GWsavebmp(int nb, char *fname)
{
	return GW_savebitmap(nDOC, nb, fname);
}

int GW_savebitmap(int nDoc, int nb, char *fname)
{
	_setBuff(nDoc, fname);
	if(_command2(nDoc, GW_BITMAP, DIB_SAVEFILE, nb))
		return nDoc;
	return 0;
}


/*0
rbg}bv̍쐬
*******************************************************************************
[F] SUBROUTINE GWMAKEBMP(IRTN, NB, IW, IH, IBC, IBITS)
    INTEGER IRTN, NB, IW, IH, IBITS(*)

[C] int GWmakebmp(int NB, int IW, int IH, int IBC, int *IBITS);
-------------------------------------------------------------------------------
()
    z IBITS Ɋi[Ărbg}bvEf[^ɂrbg}bv쐬C
    rbg}bvԍNB ɓo^BIBC ɕsȒlݒ肵ꍇɂ̓ftHgl
    gpD
-------------------------------------------------------------------------------
(͕ϐ)
    NB = rbg}bvԍ(1`): 쐬rbg}bvۑz̗vfԍB
         NB = 0 ƂƖgp̔zvfgB
    IW = rbg}bv̕(sNZ)
    IH = rbg}bv̍(sNZ)
   IBC = sNZ̍ő̐F(rbg)
       = 1: mN(1rbg)
       = 4: 16F(4rbg)
       = 8: 256F(8rbgFftHg)
       = 16: 2^16F(16rbg)
       = 24: 2^24F(24rbg)
       = 32: 2^32F(32rbg)
 IBITS = rbg}bvEf[^
         rbg}bv̍_[0,0]ƂāCʒu[i,j]̃sNZ̘_Fԍ
             IBITS(i+IW*j+1)    : [F}
             IBITS[i+IW*j]      : [C]
         ɐݒ肷ii = 0 ` IW-1Cj = 0 ` IH-1j.
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ۂɃrbg}bvۑzvfԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Make Bitmap
*******************************************************************************
[F] SUBROUTINE GWMAKEBMP(IRTN, NB, IW, IH, IBC, IBITS)
    INTEGER IRTN, NB, IW, IH, IBITS(*)

[C] int GWmakebmp(int NB, int IW, int IH, int IBC, int *IBITS);
-------------------------------------------------------------------------------
Description
    Make a bitmap using bitmap data stored in the array IBITS with the bitmap 
    number NB.   When NB = 0 unused array element is used.   If an invalid 
    value is set to IBC the default value is used.

Input
    NB = bitmap number (>0)
    IW = width of the bitmap(pixel)
    IH = height of the bitmap(pixel)
   IBC = color depth per pixel(bits per pixel)
       = 1: monochrome(1 bit)
       = 4: 16 colors (4 bits)
       = 8: 256 colors (8 bits: default)
       = 16: 2^16 colors (16 bits)
       = 24: 2^24 colors (24 bits)
       = 32: 2^32 colors (32 bits)
 IBITS = the bitmap data
         the logical color value of the pixels [i,j] are stored to
             IBITS(i+IW*j+1)    : [F}
         or
             IBITS[i+IW*j]      : [C]
         where the origin [0,0] is assumed at the top-left corner of the 
         bitmap, and i = 0..IW-1 and j = 0..IH-1.

Output
  IRTN = bitmap number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWMAKEBMP "^";
#endif
int GWMAKEBMP(int *ret, int *nb, int *w, int *h, int *bc, int *bits)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWMAKEBMP(int *ret, int *nb, int *w, int *h, int *bc, int *bits)
#else
int gwmakebmp_(int *ret, int *nb, int *w, int *h, int *bc, int *bits)
#endif
#endif
{
	return (*ret = GW_makebitmap(nDOC, *nb, *w, *h, *bc, bits));
}

int GWmakebmp(int nb, int w, int h, int bc, int *bits)
{
	return GW_makebitmap(nDOC, nb, w, h, bc, bits);
}

int GW_makebitmap(int nDoc, int nb, int w, int h, int bc, int *bits)
{
	int ret, size;
	switch(bc) {
	case 1:
	case 4:
	case 8:
	case 16:
	case 24:
	case 32:
		break;
	default:
		bc = 8;
	}
	GW_Params(nDoc)->c.i.p0 = w;
	GW_Params(nDoc)->c.i.p1 = h;
	size = w*h;
	if(size < 0) size *= -1;
	if(size 
	&& _command2(nDoc, GW_CMD, CMD_ALLOC, size*sizeof(INT)) 
	&& _senddata(nDoc, (LPCVOID)bits, size*sizeof(INT)) 
	&& _command(nDoc, GW_BITMAP, DIB_MAKE, nb, bc) 
	&& sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
tHgrbg}bvւ̕ϊ
*******************************************************************************
[F] SUBROUTINE GWFNT2BMP(IRTN, NB, IW, IH, IU, IV, TEXT)
    INTEGER IRTN, NB, IW, IH, IC, IU, IV
    CHARACTER TEXT*(*)

[C] int GWfnt2bmp(int NB, int IW, int IH, int IU, int IV, char *TEXT);
-------------------------------------------------------------------------------
()
   ݂̃tHggĕ񂩂烂mNErbg}bv쐬B쐬ꂽ
   rbg}bv̓rbg}bvԍNB ɓo^B
-------------------------------------------------------------------------------
(͕ϐ)
    NB = rbg}bvԍ(1`): 쐬rbg}bvۑz̗vfԍB
         NB = 0 ƂƖgp̔zvfgB
    IW = rbg}bv̕(sNZ)
    IH = rbg}bv̍(sNZ)
    IU = _̃ItZbguW(sNZ)
    IV = _̃ItZbgvW(sNZ)
  TEXT = 
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ۂɃrbg}bvۑzvfԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Make Bitmap
*******************************************************************************
[F] SUBROUTINE GWFNT2BMP(IRTN, NB, IW, IH, IU, IV, TEXT)
    INTEGER IRTN, NB, IW, IH, IC, IU, IV
    CHARACTER TEXT*(*)

[C] int GWfnt2bmp(int NB, int IW, int IH, int IU, int IV, char *TEXT);
-------------------------------------------------------------------------------
Description
    Make a bitmap with the bitmap number NB from a text string using the 
    current text font.  When NB = 0 unused array element is used. 

Input
   NB = bitmap number (>0)
   IW = width of the bitmap(pixel)
   IH = height of the bitmap(pixel)
   IU = offset of the reference point to the right(pixel)
   IV = offset of the reference point to the bottom(pixel)
 TEXT = the string

Output
  IRTN = bitmap number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFNT2BMP "^";
int GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			   CHARACTER *text)
#else
int GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			   char *text, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			   char *text, int l)
#else
int gwfnt2bmp_(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			   char *text, int l)
#endif
#endif
{
	return 
#ifdef __WATCOMC__
		(*ret = GW_font2bitmap(nDOC, *nb, *w, *h, *u, *v, _copyBuff(nDOC, text->p, text->l)));
#else
		(*ret = GW_font2bitmap(nDOC, *nb, *w, *h, *u, *v, _copyBuff(nDOC, text, l)));
#endif
}

int GWfnt2bmp(int nb, int w, int h, int u, int v, char *text)
{
	return GW_font2bitmap(nDOC, nb, w, h, u, v, text);
}

int GW_font2bitmap(int nDoc, int nb, int w, int h, int u, int v, char *text)
{
	int ret;
	GW_Params(nDoc)->c.i.p0 = w;
	GW_Params(nDoc)->c.i.p1 = h;
	GW_Params(nDoc)->c.i.p2 = u;
	GW_Params(nDoc)->c.i.p3 = v;
	_setBuff(nDoc, text);
	if(_command2(nDoc, GW_BITMAP, DIB_FONT, nb)
		&& sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
rbg}bv̑ݒ
*******************************************************************************
[F] SUBROUTINE GWSETBMP(IRTN, NB, W, H, MX, ITR, IOF)
    INTEGER IRTN, NB, MX, ITR, IOF
    REAL W, H

[C] int GWsetbmp(int NB, float W, float H, int MX, int ITR, int IOF);
-------------------------------------------------------------------------------
()
    NB Ŏw肳ꂽo^ς݃rbg}bv̕`掞̑ݒ肷Bj[o[
     [Edit] -> [Import Clipboard] Ŏ荞񂾃rbg}bv 0 Ԃɓo^
    ĂBW = H = 0 ̏ꍇ͓o^̃TCY_foCXWnŉ肳B
    rbg}bv[h MX ݂͌̃uVA]̃rbg}bvA]
    rbg}bvgݍ킹ďo͑̐F𐶐@`BMX > 15 
    ꍇ MX - 16 ̒l "ternary raster-operation code" ƂĎgpB
    ITR > 0 ̏ꍇɂ ITR Ŏw肳ꂽFɂȂBIOF ł͊_ǂ
    uw肷Bp^̒l̏ꍇ́CΉ鑮͕ύXȂB
-------------------------------------------------------------------------------
(͕ϐ)
    NB = gprbg}bvԍB
     W = ʏ̃rbg}bv̕([hWn)B
     H = ʏ̃rbg}bv̍([hWn)B
    MX = 0 ... 15 : rbg}bv[h(ȉQ)B
       > 15 :  (MX - 16) = "ternary raster-operation code[W]"
   ITR = [htO
       = 0: s[h(rbg}bv͋`ŕ\)
       = 1: 𓧖FƂ(ftHg)
       > 1: F̘_Fԍl + 2 (. 2 => )
   IOF = _̈ʒuw肷
       = 0:  (ftHg)
       = 1: 
       = 2: E
       = 3: E
       = 4: 
       = 5: 
       = 6: 
       = 7: E
       = 8: 

    (rbg}bv[h)
        0: INVERTNOT = source XOR (NOT dest)
            ]rbg}bv𔽓]ǍʂƓ]rbg}bv_ XOR 
            ZqŌ܂B
        1: SRCCOPY = source
            
        2: SRCPAINT = source OR dest
            ]rbg}bṽsNZƓ]rbg}bv_ OR Zq
            ܂B
        3: SRCAND = source AND dest
            ]̃rbg}bvƓ]rbg}bṽsNZ_ AND Zq
            Ō܂B
        4: SRCINVERT= source XOR dest
            ]rbg}bṽsNZƓ]rbg}bv_ XOR Zq
            ܂B
        5: SRCERASE = source AND (NOT dest )
            ]rbg}bv𔽓]ǍʂƓ]rbg}bv_ AND 
            ZqŌ܂B
        6: NOTSRCCOPY = (NOT source)
            ]]rbg}bv]rbg}bvɃRs[܂B
        7: NOTSRCERASE = (NOT src) AND (NOT dest)
            ]rbg}bvƓ]rbg}bv_ OR ZqŌ
            ʂ𔽓]܂B
        8: MERGECOPY = (source AND pattern)
            p^[ rbg}bvƓ]rbg}bv_ AND ZqŌ
            ܂B
        9: MERGEPAINT = (NOT source) OR dest
            ]]rbg}bvƓ]rbg}bv_ OR ZqŌ
            ܂B
       10: PATCOPY = pattern
           p^[ rbg}bv]rbg}bvɃRs[܂B
       11: PATPAINT = DPSnoo
           ]]rbg}bvƃp^[ rbg}bv_ OR Zq
           ܂BɁȂœ̂Ɠ]rbg}bv_ OR 
           ZqŌ܂B
       12: PATINVERT = pattern XOR dest
           p^[ rbg}bvƓ]rbg}bv_ XOR ZqŌ
           B
       13: DSTINVERT = (NOT dest)
           ]̃rbg}bv𔽓]܂B
       14: BLACKNESS = BLACK
           ׂĂ̏o͂ɂ܂B
       15: WHITENESS = WHITE
           ׂĂ̏o͂𔒂ɂ܂B
-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Bitmap Attributes
*******************************************************************************
[F] SUBROUTINE GWSETBMP(IRTN, NB, W, H, MX, ITR, IOF)
    INTEGER IRTN, NB, MX, ITR, IOF
    REAL W, H

[C] int GWsetbmp(int NB, float W, float H, int MX, int ITR, int IOF);
-------------------------------------------------------------------------------
Description
    Set drawing attributes for a stored bitmap NB.  The bitmap number NB = 0
    is reserved for a bitmap imported from the clipboard [W].  When W = H = 0, 
    the original bitmap size in pixels are assumed in the LDCS.   
    Bitmap-mix modes MX define how colors are combined in output operations 
    that involve a current brush, a possible source bitmap, and a destination 
    bitmap. When MX > 15, the value is used as the "ternary raster-operation 
    code[W]".   When ITR > 0 the value specifies the transparent color, which 
    becomes transparent.  The parameter IOF specifies the reference point of 
    the bit map.   When a parameter has a negative value the corresponding 
    attribute is not changed.

Input
    NB = bitmap number to be drawn
     W = width of the bitmap in the world coordinate system
     H = height of the bitmap in the world coordinate system
    MX = 0 ... 15 : bitmap-mix mode (see below)
       > 15 :  (MX - 16) = "ternary raster-operation code[W]"
   ITR = transparent mode flag
       = 0: non transparent mode (the bitmap is drawn as a rectangle)
       = 1: transparent mode (white pixels in the bitmap becomes transparent)
       > 1: (a positive logical color value) + 2 for the transparent color
            ex. 2 => black
   IOF = set the reference point at
       = 0: center (default)
       = 1: bottom-left
       = 2: bottom-right
       = 3: top-right
       = 4: top-left
       = 5: left
       = 6: bottom
       = 7: right
       = 8: top

    bitmap-mix mode (see "ternary raster-operation code[W]")
        0: INVERTNOT = source XOR (NOT dest)
            Inverts the destination bitmap and combines the result with the 
            source bitmap using the Boolean XOR operator.
        1: SRCCOPY = source
            Copies the source bitmap to the destination bitmap.
        2: SRCPAINT = source OR dest
            Combines pixels of the destination and source bitmaps using the 
            Boolean OR operator.
        3: SRCAND = source AND dest
            Combines pixels of the destination and source bitmaps using the 
            Boolean AND operator.
        4: SRCINVERT= source XOR dest
            Combines pixels of the destination and source bitmaps using the 
            Boolean XOR operator.
        5: SRCERASE = source AND (NOT dest )
            Inverts the destination bitmap and combines the result with the source 
            bitmap using the Boolean AND operator.
        6: NOTSRCCOPY = (NOT source)
            Copies the inverted source bitmap to the destination.
        7: NOTSRCERASE = (NOT src) AND (NOT dest)
            Inverts the result of combining the destination and source bitmaps 
            using the Boolean OR operator.
        8: MERGECOPY = (source AND pattern)
            Combines the pattern and the source bitmap using the Boolean AND 
            operator.
        9: MERGEPAINT = (NOT source) OR dest
            Combines the inverted source bitmap with the destination bitmap using 
            the Boolean OR operator.
       10: PATCOPY = pattern
            Copies the pattern to the destination bitmap.
       11: PATPAINT = DPSnoo
            Combines the inverted source bitmap with the pattern using the 
            Boolean OR operator. Combines the result of this operation with 
            the destination bitmap using the Boolean OR operator.
       12: PATINVERT = pattern XOR dest
           Combines the destination bitmap with the pattern using the Boolean XOR 
           operator.
       13: DSTINVERT = (NOT dest)
           Inverts the destination bitmap.
       14: BLACKNESS = BLACK
           Turns all outset black.
       15: WHITENESS = WHITE
           Turns all outset white.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETBMP "^";
#endif
int GWSETBMP(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETBMP(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o)
#else
int gwsetbmp_(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o)
#endif
#endif
{
	return (*ret = GWsetbmp(*nb, *w, *h, *m, *t, *o));
}

int GWsetbmp(int nb, float w, float h, int m, int t, int o)
{
	int iw, ih;

	if(w >= 0.0)
		iw = WCtoLPw(w);
	else
		iw = -1;
	if(h >= 0.0)
		ih = WCtoLPh(h);
	else
		ih = -1;

	return GW_setbitmap(nDOC, nb, iw, ih, m, t, o);
}

int GW_setbitmap(int nDoc, int nb, int w, int h, int m, int t, int o)
{
	if(nb > 0) (GW_Params(nDoc)->p.GW_In) = nb;
	else return 0;
	if(m >= 0) (GW_Params(nDoc)->p.GW_Im) = m;
	if(t >= 0) (GW_Params(nDoc)->p.GW_It) = t;
	if(o >= 0) (GW_Params(nDoc)->p.GW_Io) = o;
	GW_Params(nDoc)->c.i.p0 = w;
	GW_Params(nDoc)->c.i.p1 = h;
	return _command2(nDoc, GW_BITMAP, DIB_SET, nb);
}


/*0
rbg}bv̑擾
*******************************************************************************
[F] SUBROUTINE GWGETBMP(IRTN, NB, W, H, IW, IH, IB, MAXNB, FN)
    INTEGER IRTN, NB, IW, IH, NC, MAXNB
    CHARACTER FN*(*)
    REAL W, H

[C] int GWgetbmp(int NB, float *W, float *H, int *IW, int *IH, 
		int *NC, int *MAXNB, char *FN, int l);
-------------------------------------------------------------------------------
()
    o^ς݃rbg}bv̑擾B
-------------------------------------------------------------------------------
(͕ϐ)
    NB = 擾rbg}bvԍB0 ̓Nbv{[hC|[g
         ([Edit] => [Import Clipboard])Ƀrbg}bvۑԍB
     l = char ϐ FN ̒ ([C])
-------------------------------------------------------------------------------
(o͕ϐ)
     W = rbg}bv̕[hWɊŹB
     H = rbg}bv̍[hWɊŹB
    IW = rbg}bv̕(rbg)B
    IH = rbg}bv̍(rbg)B
    IB = rbg}bv̊esNZ`rbgBsꍇ 0B
 MAXNB = o^ς݃rbg}bvԍ̍őlB
    FN = rbg}bvt@CB FN == NULL ([C]) ܂ FN ̒\łȂ
         ꍇ͖B
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Bitmap Attributes
*******************************************************************************
[F] SUBROUTINE GWGETBMP(IRTN, NB, W, H, IW, IH, IB, MAXNB, FN)
    INTEGER IRTN, NB, IW, IH, NC, MAXNB
    CHARACTER FN*(*)
    REAL W, H

[C] int GWgetbmp(int NB, float *W, float *H, int *IW, int *IH, 
		int *NC, int *MAXNB, char *FN, int l);
-------------------------------------------------------------------------------
Description
    Get bitmap attributes.

Input
    NB = bitmap number (>0), or 0 for imported clipboard obtained by [Edit] -> 
         [Import Clipboard] on the menu bar.
     l = length of the char variable FN ([C])

Output
     W = width of the bitmap in the world coordinate
     H = height of the bitmap in the world coordinate
    IW = width of the bitmap in pixels
    IH = height of the bitmap in pixels
    IB = the number of bits per pixel
 MAXNB = maximum bitmap number of stored bitmaps
    FN = bitmap file name.  It is neglected when FN == NULL ([C]) or the length 
         of the FN is insufficient to retrieve the file name.
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETBMP "^";
int GWGETBMP(int *ret, int *nb, float *width, float *height, int *w, int *h, 
		int *bc, int *maxnb, CHARACTER *fnm)
#else
int GWGETBMP(int *ret, int *nb, float *width, float *height, int *w, int *h, 
		int *bc, int *maxnb, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETBMP(int *ret, int *nb, float *width, float *height, int *w, int *h, 
		int *bc, int *maxnb, char *fname, int l)
#else
int gwgetbmp_(int *ret, int *nb, float *width, float *height, int *w, int *h, 
		int *bc, int *maxnb, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	int i, l;
	char *fname = NULL;
	l = sizeof(char)*fnm->l + 1;
	if(l > 2) 	// '' forbidden on WATCOM Fortran
		fname = (char*)malloc(l);
	else
		l = 0;
	*ret = GWgetbmp(*nb, width, height, w, h, bc, maxnb, fname, l);
	if(fname) {
		strncpy(fnm->p, fname, l-1);
		free(fname);
		i = strlen(fnm->p);
		while(i < l)
			fnm->p[i++] = ' ';
	}
	return *ret;
#else
	int i;
	if(l == 0) fname = NULL;
	*ret = GWgetbmp(*nb, width, height, w, h, bc, maxnb, fname, l);
	if(fname) {
		i = strlen(fname);
		while(i < l)
			fname[i++] = ' ';
	}
	return *ret;
#endif
}

int GWgetbmp(int nb, float *width, float *height, 
	int *bw, int *bh, int *bc, int *maxnb, char *fname, int l)
{
	int ret, w = 0, h = 0, *wp = NULL, *hp = NULL;
	if(width) wp = &w;
	if(height) hp = &h;
	ret = GW_getbitmap(nDOC, nb, wp, hp, bw, bh, bc, maxnb, fname, l);
	if(width && (GW_asgn(width, LPtoWCw(w)) < 0))
		(*width)*=-1;
	if(height && (GW_asgn(height, LPtoWCh(h)) < 0))
		(*height)*=-1;
	return ret;
}

int GW_getbitmap(int nDoc, int nb, int *width, int *height, 
	int *bw, int *bh, int *bc, int *maxnb, char *fname, int l)
{
	int ret;
	if((ret = _command2(nDoc, GW_BITMAP, DIB_ATTR, nb))) {
		GW_asgn(width, GW_Params(nDoc)->x);
		GW_asgn(height, GW_Params(nDoc)->y);
		GW_asgn(bw, GW_Params(nDoc)->c.i.p0);
		GW_asgn(bh, GW_Params(nDoc)->c.i.p1);
		GW_asgn(bc, GW_Params(nDoc)->c.i.p2);
		GW_asgn(maxnb, GW_Params(nDoc)->c.i.p3);
		if(fname) {
			if(l > (int)strlen(GW_Buffer(nDoc))) 
				strcpy(fname, GW_Buffer(nDoc));
			else
				ret = 0;
		}
	}
	return ret;
}


/*1
rbg}bv̕`
*******************************************************************************
[F] SUBROUTINE GWPUTBMP(IRTN, NB, X, Y, IBK)
    INTEGER IRTN, NB, IBK
    REAL X, Y

[C] int GWputbmp(int NB, float X, float Y, int IBK);
-------------------------------------------------------------------------------
()
    w肳ꂽo^ς݃rbg}bv NB ʒu (X, Y) ɕ`悷Brbg}bv
     GWSETBMP Őݒ肷BIBK ͔wiǂ̂悤Ɉw肷B
    `̑OɔwiۑC̕`̑OɕۑĂwi𕜌C܂C
    `悳Ărbg}bvΊȒPȃAj[V邱Ƃ
    łBIBK ̃ftHgl 1 ŁC`݂̂sB
-------------------------------------------------------------------------------
(͕ϐ)
    NB = gprbg}bvԍB
     X = rbg}bv_ X W([hWn)B
     Y = rbg}bv_ Y W([hWn)B
   IBK = R*4 + S*2 + D*1
         R = 1(0): `̑Oɔwi̕sisȂj
         S = 1(0): `̑Oɔwi̕ۑsisȂj
         D = 1(0): `sisȂj

   ) IBK = 7: () > ۑ > `s
       IBK = 4: ()݂̂s

-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Bitmap
*******************************************************************************
[F] SUBROUTINE GWPUTBMP(IRTN, NB, X, Y, IBK)
    INTEGER IRTN, NB, IBK
    REAL X, Y

[C] int GWputbmp(int NB, float X, float Y, int IBK);
-------------------------------------------------------------------------------
Description
    Draw a stored bitmap NB at the point (X, Y) with attributes set by GWSETBMP.
    The parameter IBK is the switches (1 = on | 0 = off) for Restoring(R) 
    and Saving(S) the background of the bitmap and for Drawing(D) the bitmap. 
    Saving the background before drawing a bitmap and restoring it, that is 
    clearing the bitmap, before the next drawing, a simple animation can be 
    made.

Input
    NB = bitmap number to be drawn
     X = the world x-coordinate of the reference point of the bitmap
     Y = the world y-coordinate of the reference point of the bitmap
   IBK = R*4 + S*2 + D*1
         R = switch for restoring the background before the drawing
         S = switch for saving the background before the drawing
         D = switch for drawing the bitmap

   ex) IBK = 7: restoring (clearing) > saving > drawing
       IBK = 4: restoring (clearing) only

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPUTBMP "^";
#endif
int GWPUTBMP(int *ret, int *nb, float *x, float *y, int *bk)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPUTBMP(int *ret, int *nb, float *x, float *y, int *bk)
#else
int gwputbmp_(int *ret, int *nb, float *x, float *y, int *bk)
#endif
#endif
{
	return (*ret = GWputbmp(*nb, *x, *y, *bk));
}

int GWputbmp(int nb, float x, float y, int bk)
{
	return GW_putbitmap(nDOC, nb, WCtoLPx(x), WCtoLPy(y), bk);
}

int GW_putbitmap(int nDoc, int nb, int x, int y, int bk)
{
	if(nb >= 0) (GW_Params(nDoc)->p.GW_In) = nb;
	if(bk >= 0) (GW_Params(nDoc)->p.GW_Ib) = bk;
	return (_command(nDoc, GW_GENDOTOOL, TOOL_DIB, x, y));
}


/*0
ۑrbg}bṽRs[o^
*******************************************************************************
[F] SUBROUTINE GWCOPYBMP(IRTN, NB1, NB2)
    INTEGER IRTN, NB1, NB2

[C] int GWcopybmp(int NB1, int NB2);
-------------------------------------------------------------------------------
()
    rbg}bvԍ NB1 (0 ` MAXNB)ɓo^Ărbg}bvrbg}bv
    ԍ NB2 ɍēo^B
-------------------------------------------------------------------------------
(͕ϐ)
  NB1 = o^̃rbg}bvԍ
  NB2 = o^̃rbg}bvԍBNB = 0 ƂƖgp̔zvfgB
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɓo^ꂽrbg}bvԍB
_______________________________________________________________________________
*/
/*E
Copy Stored Bitmap
*******************************************************************************
[F] SUBROUTINE GWCOPYBMP(IRTN, NB1, NB2)
    INTEGER IRTN, NB1, NB2

[C] int GWcopybmp(int NB1, int NB2);
-------------------------------------------------------------------------------
Description
    Copy stored bitmap of the bitmap number NB1 to a bitmap with bitmap number 
    NB2.

Input
  NB1 = bitmap number of the bitmap to be copied
  NB2 = destination bitmap number (>0), or NB = 0 for using unused array element.
Output
  IRTN = bitmap number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCOPYBMP "^";
#endif
int GWCOPYBMP(int *ret, int *nb1, int *nb2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCOPYBMP(int *ret, int *nb1, int *nb2)
#else
int gwcopybmp_(int *ret, int *nb1, int *nb2)
#endif
#endif
{
	return (*ret = GW_copybitmap(nDOC, *nb1, *nb2));
}

int GWcopybmp(int nb1, int nb2)
{
	return GW_copybitmap(nDOC, nb1, nb2);
}

int GW_copybitmap(int nDoc, int nb1, int nb2)
{
	int ret;
	if(_command(nDoc, GW_BITMAP, DIB_COPY, nb1, nb2) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret) == 1)
		return ret;
	return 0;
}


/*0
rbg}bv̓o^폜
*******************************************************************************
[F] SUBROUTINE GWDELBMP(IRTN, NM)
    INTEGER IRTN, NM

[C] int GWdelbmp(int NM);
-------------------------------------------------------------------------------
()
    rbg}bvԍ NM (1 ` MAXNM) ̃rbg}bv̓o^폜Bw肳ꂽ
    rbg}bvԍgp̏ꍇ͉ȂB
-------------------------------------------------------------------------------
(͕ϐ)
  NM = 폜rbg}bv̔ԍ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɍ폜ꂽrbg}bv̔ԍ (>0)B폜Ȃꍇ 0B
_______________________________________________________________________________
*/
/*E
Delete Bitmap
*******************************************************************************
[F] SUBROUTINE GWDELBMP(IRTN, NM)
    INTEGER IRTN, NM

[C] int GWdelbmp(int NM);
-------------------------------------------------------------------------------
Description
    Deletes stored bitmap of the bitmap number NM.   If the spesified bitmap 
    number is not used, nothing is done.

Input
  NM = bitmap number of the bitmap to be deleted

Output
  IRTN = bitmap number deleted (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDELBMP "^";
#endif
int GWDELBMP(int *ret, int *nb)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDELBMP(int *ret, int *nb)
#else
int gwdelbmp_(int *ret, int *nb)
#endif
#endif
{
	return (*ret = GW_delbmp(nDOC, *nb));
}

int GWdelbmp(int nb)
{
	return GW_delbmp(nDOC, nb);
}

int GW_delbmp(int nDoc, int nb)
{
	int ret;
	if(_command2(nDoc, GW_BITMAP, DIB_DEL, nb) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret) == 1)
		return ret;
	return 0;
}


/*0
`̈̎荞
*******************************************************************************
[F] SUBROUTINE GWCAPIMG(IRTN, NB, X1, Y1, X2, Y2)
    INTEGER IRTN, NB
    REAL X1, Y1, X2, Y2

[C] int GWcapimg(int NB, float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
    (X1,Y1)-(X2,Y2) Ŏw肳ꂽ`̈rbg}bvƂāCrbg}bvԍ
    NB ɓo^Bw肳ꂽ`̖̈ʐς 0 ̏ꍇɂ́C݂̃EBhES
    ̂肳B
-------------------------------------------------------------------------------
(͕ϐ)
    NB = rbg}bvԍ(1`): ǂݍ񂾃rbg}bvۑz̗vfԍB
         NB = 0 ƂƖgp̔zvfgB
   X1 = `̊p̓_ X W([hWn)
   Y1 = `̊p̓_ Y W([hWn)
   X2 = _(X1, Y1)ƑΊpƂȂ_ X W([hWn)
   Y2 = _(X1, Y1)ƑΊpƂȂ_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ۂɃrbg}bvۑzvfԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Capture Image
*******************************************************************************
[F] SUBROUTINE GWCAPIMG(IRTN, NB, X1, Y1, X2, Y2)
    INTEGER IRTN, NB
    REAL X1, Y1, X2, Y2

[C] int GWcapimg(int NB, float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
    Capture image of a rectangular area specified by a pair of two diagonal 
    points (X1,Y1) and (X2,Y2) into an element of the internal bitmap array.  
    The array element can be specified with the bitmap number NB.   When 
    NB = 0 is specified, an unused element will be used.   If the specified 
    rectangle has no area the bounding rectangle for the current window is 
    assumed.

Input
   NB = bitmap number (>=0)
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.

Output
 IRTN = bitmap number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCAPIMG "^";
#endif
int GWCAPIMG(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCAPIMG(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2)
#else
int gwcapimg_(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GWcapimg(*nb, *x1, *y1, *x2, *y2));
}

int GWcapimg(int nb, float x1, float y1, float x2, float y2)
{
	return GW_capimage(nDOC, nb, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2));
}

int GW_capimage(int nDoc, int nb, int x1, int y1, int x2, int y2)
{
	int ret;
	GW_Params(nDoc)->c.i.p0 = x1;
	GW_Params(nDoc)->c.i.p1 = y1;
	GW_Params(nDoc)->c.i.p2 = x2;
	GW_Params(nDoc)->c.i.p3 = y2;
	if(_command2(nDoc, GW_CMD, CMD_CAPIMAGE, nb) &&
		sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
`̈̃Nbv{[hւ̃Rs[
*******************************************************************************
[F] SUBROUTINE GWCLIPIMG(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWclipimg(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
    (X1,Y1)-(X2,Y2) Ŏw肳ꂽ`̈Nbv{[hփRs[BNbv
    {[hփRs[ꂽ}`̓rbg}bvԍ 0 ɂۑBw肳ꂽ`
    ̖̈ʐς 0 ̏ꍇɂ́C݂̃EBhEŜ肳B
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = `̊p̓_ X W([hWn)
   Y1 = `̊p̓_ Y W([hWn)
   X2 = _(X1, Y1)ƑΊpƂȂ_ X W([hWn)
   Y2 = _(X1, Y1)ƑΊpƂȂ_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Copy To Clipboard
*******************************************************************************
[F] SUBROUTINE GWCLIPIMG(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWclipimg(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
    Copy rectangular area specified by a pair of diagonal points (X1,Y1) and 
    (X2,Y2) into the Windows clipboard and also into an array element with the 
    bitmap number NB = 0.  If the specified rectangle has no area the bounding 
    rectangle for the current window is assumed.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCLIPIMG "^";
#endif
int GWCLIPIMG(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCLIPIMG(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwclipimg_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GWclipimg(*x1, *y1, *x2, *y2));
}

int GWclipimg(float x1, float y1, float x2, float y2)
{
	return GW_clipimage(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2));
}

int GW_clipimage(int nDoc, int x1, int y1, int x2, int y2)
{
	GW_Params(nDoc)->c.i.p0 = x1;
	GW_Params(nDoc)->c.i.p1 = y1;
	GW_Params(nDoc)->c.i.p2 = x2;
	GW_Params(nDoc)->c.i.p3 = y2;
	return _command1(nDoc, GW_CMD, CMD_CLIPIMAGE);
}
