/*
 * PGPLOT driver Version 1.5.0 - Jul 14 2003 
 *     for Win32 / GrWin Library Ver.0.99.9a and later
 *     by  "Tsuguhiro Tamaribuchi" <tamari@spdg1.sci.shizuoka.ac.jp>
 *
 *     FTP: ftp://spdg1.sci.shizuoka.ac.jp/pub/GrWinlib/english/contrib/pgplot/
 *     WWW: http://spdg1.sci.shizuoka.ac.jp/grwinlib/english/
 * 
 * Contributors:
 *   "Olof Svensson" <svensson@esrf.fr>
 *   "Roberto Abraham" <abraham@astro.utoronto.ca>
 *   "Karl Glazebrook" <kgb@pha.jhu.edu>
 */

#define USE_LEAVE 0
#define USE_JOIN 1
#define USE_CDUMP 1
//#define _DEBUG 1
//#define RESETFR	// reset the frame's show state after each call to 'Begin picture'

#define TOPMOST 11	// the frame's show state: 11 = topmost, (-1 = default)

#if USE_CDUMP		//  turn to 0 if you never use 'C-dump' with /gwd or /cgwd
#define _CDUMP "pggwdump.c"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "GrWin.h"

char *gw_ident[] = {       /* Name to prefix messages to user */
	"PGPLOT /gw"
	,"PGPLOT /cgw"
#ifdef _CDUMP
	,"PGPLOT /gwd"
	,"PGPLOT /cgwd"
#endif
};

#define MRKTBLSIZE	256

#define Qinch		(0.25f*(pGW->DPIY)/(pGW->HEIGHT))
#define NWMAX		8
#define ROP2		4
#define COLORBITS	8
#define MAXCOLOR	256
#define MAXCOLOR1	(MAXCOLOR-1)
#define MAXPNTS		128
#define FLUSH(p,n)	((n>0)?(Flush(p,&(n))):0)

struct GRWIN {
	int ID;
	int NWIN, WIDTH, HEIGHT, DPIX, DPIY;
	int lcolor[MAXCOLOR], curC, lclrFg, lclrBk;
	int marker[32], mkIdx[MRKTBLSIZE], mkCur;
	int Mode;
	float WWIDTH, WHEIGHT;
} GW[NWMAX], *pGW = NULL;

float Sgmnts[MAXPNTS][2];

int GWID = 0, nBegin = 0;
int npnt, nVertices = 0, nSgmnts = 0;
float *pnt, *points = NULL;
char chr7;

int HERSH[32] = {
	 841, 899, 845, 847, 840, 846, 841, 842,
	2284,2281, 735, 843, 844, 852, 866, 868,
	 851, 850, 856, 254, 900, 901, 902, 903,
	 904, 905, 906, 907,2263,2261,2262,2264};

#ifdef _CDUMP
char *op[] = {
	"IFUNC=0, ???",
	"IFUNC=1, Return device name",
	"IFUNC=2, Return max. dim. of view surface, and range of color index",
	"IFUNC=3, Return device scale",
	"IFUNC=4, Return device capabilities",
	"IFUNC=5, Return default device/file name",
	"IFUNC=6, Return default size of view surface",
	"IFUNC=7, Return miscellaneous defaults",
	"IFUNC=8, Select device",
	"IFUNC=9, Open workstation",
	"IFUNC=10, Close workstation",
	"IFUNC=11, Begin picture",
	"IFUNC=12, Draw line",
	"IFUNC=13, Draw dot",
	"IFUNC=14, End picture",
	"IFUNC=15, Set color index",
	"IFUNC=16, Flush buffer",
	"IFUNC=17, Read cursor",
	"IFUNC=18, Erase alpha screen",
	"IFUNC=19, Set line style",
	"IFUNC=20, Polygon fill",
	"IFUNC=21, Set color representation",
	"IFUNC=22, Set line width",
	"IFUNC=23, Escape function",
	"IFUNC=24, Rectangle fill",
	"IFUNC=25, Set fill pattern",
	"IFUNC=26, Line of pixels",
	"IFUNC=27, Scaling information",
	"IFUNC=28, Draw marker",
	"IFUNC=29, Query color representation",
	"IFUNC=30, Scroll rectangle"
};

FILE *fp = NULL;
#endif

#ifdef __cplusplus
extern "C" {
#endif
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
typedef struct CHARACTER {
	char		*p;
	unsigned	l;
} CHARACTER;
#pragma aux GRSYXD "^";
#endif
void GRSYXD(int*, int*, int*);
#else
#if defined(_MSC_VER) && !defined(__F2C__) /* Microsoft VC++ */
void __stdcall GRSYXD(int*, int*, int*);
#else
void grsyxd_(int*, int*, int*);
#endif
#endif
#ifdef __cplusplus
}
#endif

static int Flush(float *pnts, int *n)
{
	if(*n == 1) {
		GWline(pnts[0], pnts[1], pnts[0], pnts[1]);
#ifdef _CDUMP
		if(fp) 
			fprintf(fp, "\tGWline(%f, %f, %f, %f);\n", 
				pnts[0], pnts[1], pnts[0], pnts[1]);
#endif
	} else if(*n == 2) {
		GWline(pnts[0], pnts[1], pnts[2], pnts[3]);
#ifdef _CDUMP
		if(fp) 
			fprintf(fp, "\tGWline(%f, %f, %f, %f);\n", 
				pnts[0], pnts[1], pnts[2], pnts[3]);
#endif
	} else {
		GWpolylin(pnts, *n);
#ifdef _CDUMP
		if(fp) {
			int i;
			fprintf(fp, "\t{\n");
			fprintf(fp, "\t\tfloat points[] = {");
			for(i = 0; i < 2*(*n); i += 2) {
				if(i%4 == 0) 
					fprintf(fp, "\n\t\t");
				fprintf(fp, "%f, %f, ", 
					pnts[i], pnts[i + 1]);
			}
			fprintf(fp, "0.0};\n");
			fprintf(fp, "\t\tGWpolylin(points, %d);\n", *n);
			fprintf(fp, "\t}\n");
		}
#endif
	}
	*n = 0;
	return *n;
}

int GetPGSymbol(int m)
{
	int xygrid[300], unused, *p = xygrid;
	int lx, ly, n = 0, ret;
	float segment[147][2];
	float minimumX, maximumX, minimumY, baselineY, maximumY;

#if !defined(__F2C__) && (defined(_MSC_VER) ||  defined(__INTEL_COMPILER) || defined(__WATCOMC__))
	GRSYXD(&m, p, &unused);
#else /* assumes a length argument at end */
	grsyxd_(&m, p, &unused);
#endif
//C*GRSYXD -- obtain the polyline representation of a given symbol
//C+
//C     SUBROUTINE GRSYXD (SYMBOL, XYGRID, UNUSED)
//C     INTEGER SYMBOL
//C     INTEGER XYGRID(300)
//C     LOGICAL UNUSED
//C
//C Return the digitization coordinates of a character. Each character is
//C defined on a grid with X and Y coordinates in the range (-49,49), 
//C with the origin (0,0) at the center of the character.  The coordinate
//C system is right-handed, with X positive to the right, and Y positive
//C upward.  
//C
//C Arguments:
//C  SYMBOL (input)  : symbol number in range (1..3000).
//C  XYGRID (output) : height range, width range, and pairs of (x,y)
//C                    coordinates returned.  Height range = (XYGRID(1),
//C                    XYGRID(3)).  Width range = (XYGRID(4),XYGRID(5)).
//C                    (X,Y) = (XYGRID(K),XYGRID(K+1)) (K=6,8,...).
//C  UNUSED (output) : receives .TRUE. if SYMBOL is an unused symbol
//C                    number. A character of normal height and zero width
//C                    is returned. Receives .FALSE. if SYMBOL is a 
//C                    valid symbol number.
//C 
//C The height range consists of 3 values: (minimum Y, baseline Y,
//C maximum Y).  The first is reached by descenders on lower-case g, p,
//C q, and y.  The second is the bottom of upper-case letters.  The third
//C is the top of upper-case letters.  A coordinate pair (-64,0) requests
//C a pen raise, and a pair (-64,-64) terminates the coordinate list. It
//C is assumed that movement to the first coordinate position will be
//C done with the pen raised - no raise command is explicitly included to
//C do this. 
//C--
//C  7-Mar-1983.
//C 15-Dec-1988 - standardize.
//C-----------------------------------------------------------------------

	minimumY  = (float)*p++;	// XYGRID(1)
	baselineY = (float)*p++;	// XYGRID(2)
	maximumY  = (float)*p++;	// XYGRID(3)
	minimumX  = (float)*p++;	// XYGRID(4)
	maximumX  = (float)*p++;	// XYGRID(5)

#ifdef _CDUMP
	if(fp) {
		fprintf(fp, 
			"// Symbol #%d = %s: \n", m, unused?"unused":"used");
		fprintf(fp, "//   X range = %f, %f, Y range = %f, %f, %f\n", 
			minimumX, maximumX, minimumY, baselineY, maximumY);
	}
#endif

	if(unused) return 0;

	if(GWbegincmb(0, 100.0f, 100.0f) > 0) {
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWbegincmb(0, 100.0f, 100.0f);\n");
#endif
		while(p) {
			lx = *p++;
			ly = *p++;
			if(lx == -64) {
				if(ly == -64) p = NULL;
				FLUSH(*segment, n);
			} else {
				segment[n][0] = (float)(lx + 50);
				segment[n++][1] = (float)(ly + 50);
			}
		}
		ret = GWendcmb();
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWendcmb();\n");
#endif
	}
	return ret;
}

static void Initial(void)
{
	int i;
	for(i = 0; i < MAXCOLOR; ++i) pGW->lcolor[i] = i%36;
	pGW->lcolor[0]  = GWC_BKCOLOR;            // current background color
	pGW->lcolor[1]  = GWC_FGCOLOR;            // current foreground color
	pGW->lcolor[2]  = GWkrgb(255,   0,   0);  // Red  
	pGW->lcolor[3]  = GWkrgb(  0, 255,   0);  // Green
	pGW->lcolor[4]  = GWkrgb(  0,   0, 255);  // Blue 
	pGW->lcolor[5]  = GWkrgb(  0, 255, 255);  // Cyan (Green + Blue)
	pGW->lcolor[6]  = GWkrgb(255,   0, 255);  // Magenta (Red + Blue)
	pGW->lcolor[7]  = GWkrgb(255, 255,   0);  // Yellow (Red + Green)
	pGW->lcolor[8]  = GWkrgb(255, 127,   0);  // Orange (Red + Yellow)
	pGW->lcolor[9]  = GWkrgb(127, 255,   0);  // Green + Yellow
	pGW->lcolor[10] = GWkrgb(  0, 255, 127);  // Green + Cyan
	pGW->lcolor[11] = GWkrgb(  0, 127, 255);  // Blue + Cyan
	pGW->lcolor[12] = GWkrgb(127,   0, 255);  // Blue + Magenta
	pGW->lcolor[13] = GWkrgb(255,   0, 127);  // Red + Magenta
	pGW->lcolor[14] = GWkrgb( 85,  85,  85);  // Dark Gray
	pGW->lcolor[15] = GWkrgb(170, 170, 170);  // Light Gray
	GWcolor(pGW->lclrFg,1);
	GWcolor(pGW->lclrBk,2);
	GWsize(1, &(pGW->WIDTH), &(pGW->HEIGHT));  // get paper size in LDC
	GWsize(10, &(pGW->DPIX), &(pGW->DPIY));    // get default dpi
//	GWindow(0.0, 0.0, (float)(pGW->WIDTH), (float)(pGW->HEIGHT));
#if 1
	GWsetmrk(6, (float)(pGW->DPIY)/40.0f, -1, -1, ROP2);
#else
	GWsetmrk(1, (float)(pGW->DPIY)/40.0f, -1, -1, ROP2);
#endif
	GWsetpen(GWC_FGCOLOR, -1, -1, ROP2);    // default pen color == fg color
	GWsetbrs(GWC_FGCOLOR, 1, -1);           // SOLIDBRUSH
#ifdef _CDUMP
	if(fp) {
		fprintf(fp, "\tGWcolor(%d,1);\n", pGW->lclrFg);
		fprintf(fp, "\tGWcolor(%d,2);\n", pGW->lclrBk);
		fprintf(fp, "\tGWsetmrk(1, %f, -1, -1, %d);\n", 
			(float)(pGW->DPIY)/40.0f, ROP2);
		fprintf(fp, "\tGWsetpen(%d, -1, -1, %d);\n", GWC_FGCOLOR, ROP2);
		fprintf(fp, "\tGWsetbrs(%d, 1, -1);\n", GWC_FGCOLOR);
	}
#endif
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDRIV "^";
void GWDRIV(int *opcode, float rbuf[], int *nbuf, CHARACTER *chr, int *lchr, 
		   int *Mode)
#else
void GWDRIV(int *opcode, float rbuf[], int *nbuf, char *chr, int *lchr, 
			 int *Mode, int len)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__) /* Microsoft VC++ */
void __stdcall GWDRIV(int *opcode, float rbuf[], int *nbuf, char *chr, int len, 
					  int *lchr, int *Mode)
#else /* assumes a length argument at end */
void gwdriv_(int *opcode, float rbuf[], int *nbuf, char *chr, int *lchr, 
			 int *Mode, int len)
#endif
#endif
{
	int i;
	*nbuf = *lchr = 0;
	if(GWID < 0) {	// GWID < 0 when closed
		switch(*opcode) {
		case 1:		// IFUNC=1, Return device name
		case 4:		// IFUNC=4, Return device capabilities
		case 9:		// IFUNC=9, Open workstation
			break;
		default:
			return;
		}
	}
	if(GWID > 0) pGW = GW+(GWID-1);
#ifdef _CDUMP
	if(fp)
		fprintf(fp, "// %s\n", op[*opcode]);
#ifdef _DEBUG
	else
		printf("// %s\n", op[*opcode]);
#endif
#endif
/*
 * Branch on the specified PGPLOT opcode.
 */
	if(*opcode != 12) 
		FLUSH(*Sgmnts, nSgmnts);
	switch(*opcode) {

/*--- IFUNC=1, Return device name -------------------------------------------*/
	case 1:
#ifdef __WATCOMC__
		if(*Mode == 1)
			sprintf(chr->p, "GW (GrWin Library with grwnd.exe on Win32)");
		else if(*Mode == 2)
			sprintf(chr->p, "CGW (GW + colors compatible with /CPS)");
#ifdef _CDUMP
		else if(*Mode == 3)
			sprintf(chr->p, "GWD (GW + output of native source code)");
		else if(*Mode == 4)
			sprintf(chr->p, "CGWD (CGW + output of native source code)");
#endif
		else
			chr->p[0] = '\0';
		*lchr = strlen(chr->p);
		for(i = *lchr; i < chr->l; i++)
			chr->p[i] = ' ';
#else
		if(*Mode == 1)
			sprintf(chr, "GW (GrWin Library with grwnd.exe on Win32)");
		else if(*Mode == 2)
			sprintf(chr, "CGW (GW + colors compatible with /CPS)");
#ifdef _CDUMP
		else if(*Mode == 3)
			sprintf(chr, "GWD (GW + output of native source code)");
		else if(*Mode == 4)
			sprintf(chr, "CGWD (CGW + output of native source code)");
#endif
		else
			chr[0] = '\0';
		*lchr = strlen(chr);
		for(i = *lchr; i < len; i++)
			chr[i] = ' ';
#endif
		break;
/*--- IFUNC=2, Return max. dim. of view surface, and range of color index ---*/
	case 2:
		rbuf[0] = 0.0;
		rbuf[1] = -1.0;  /* Report no effective max plot width */
		rbuf[2] = 0.0;
		rbuf[3] = -1.0;  /* Report no effective max plot height */
		rbuf[4] = 0.0;
		rbuf[5] = MAXCOLOR1;
		*nbuf = 6;
		break;
/*--- IFUNC=3, Return device scale ------------------------------------------*/
	case 3:
		rbuf[0] = (float)(pGW->DPIX);	/* assuming landscape paper setting */
		rbuf[1] = (float)(pGW->DPIY);
		rbuf[2] = 1.0;		/* Device coordinates per pixel */
		*nbuf = 3;
		break;
/*--- IFUNC=4, Return device capabilities -----------------------------------*/
	case 4:
#ifdef __WATCOMC__
		chr->p[0] = 'I'; /* Interactive device */
		chr->p[1] = 'C'; /* Cursor available */
		chr->p[2] = 'N'; /* Dashed lines available */
		chr->p[3] = 'A'; /* Area fill available */
		chr->p[4] = 'T'; /* Thick lines */
		chr->p[5] = 'R'; /* Rectangle fill available */
		chr->p[6] = 'Q'; /* Line of pixels available */
		chr->p[7] = 'V'; /* PGPLOT window is deleted when closed */
		chr->p[8] = 'Y'; /* Can return color representation */
		chr->p[9] = 'M'; /* Graph markers available */
		chr->p[10]= 'N'; /* Area-scroll NOT available */
		*lchr = 11;
		chr7 = chr->p[6];
#else
		chr[0] = 'I'; /* Interactive device */
		chr[1] = 'C'; /* Cursor available */
		chr[2] = 'N'; /* Dashed lines available */
		chr[3] = 'A'; /* Area fill available */
		chr[4] = 'T'; /* Thick lines */
		chr[5] = 'R'; /* Rectangle fill available */
		chr[6] = 'Q'; /* Line of pixels available */
		chr[7] = 'V'; /* PGPLOT window is deleted when closed */
		chr[8] = 'Y'; /* Can return color representation */
		chr[9] = 'M'; /* Graph markers available */
		chr[10]= 'N'; /* Area-scroll NOT available */
		*lchr = 11;
		chr7 = chr[6];
#endif
		break;
/*--- IFUNC=5, Return default device/file name ------------------------------*/
	case 5:
#ifdef __WATCOMC__
		chr->p[0] = ' ';  /* Default name is "" */
#else
		chr[0] = ' ';  /* Default name is "" */
#endif
		*lchr = 0;
		break;
/*--- IFUNC=6, Return default size of view surface --------------------------*/
	case 6:
		rbuf[0] = 0.0;
		rbuf[1] = (float)(pGW->WIDTH);
		rbuf[2] = 0.0;
		rbuf[3] = (float)(pGW->HEIGHT);
		*nbuf = 4;
		break;
/*--- IFUNC=7, Return miscellaneous defaults --------------------------------*/
	case 7:
		rbuf[0] = 1.0;
		*nbuf = 1;
		break;
/*--- IFUNC=8, Select device ------------------------------------------------*/
	case 8:
		GWID = GWselect((int)(rbuf[1]+0.5));
//		GWarrange(5);
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWselect(%d);\n", (int)(rbuf[1]+0.5));
#endif
		break;
/*--- IFUNC=9, Open workstation ---------------------------------------------*/
	case 9:
/*
 * Assign the returned device unit number and success indicator.
 * Assume failure to open until the workstation is open.
 */
		rbuf[0] = rbuf[1] = 0.0;
		*nbuf = 2;
/*
 * Prepare the display name.
 */
#ifdef _CDUMP
		if((*Mode < 1) && (*Mode > 4)) {
#else
		if((*Mode < 1) && (*Mode > 2)) {
#endif
			fprintf(stderr, "ERROR: Invalid device number (%d)\n", *Mode);
			return;
		}
#ifdef __WATCOMC__
		if(*lchr >= chr->l) {
#else
		if(*lchr >= len) {
#endif
			fprintf(stderr, "%s: Display name too long.\n", gw_ident[(*Mode) - 1]);
			return;
		} else {
#ifdef __WATCOMC__
			chr->p[*lchr] = '\0';
#else
			chr[*lchr] = '\0';
#endif
		}
/*
 * Connect to the server and create the window.
 */
		if(GWID <= 0) {	// not open or closed
			int IRB = -1;	// default mode
//			int IRB = 0x7ffc0002;	// storing(1)= OFF, buffering(2)=ON
//			int IRB = 0x7fdf0020;	// StayOpen(32)=ON
#ifdef _CDUMP
			if((*Mode > 2) && (fp == NULL)) {
				char *p, fname[MAX_PATH];
				sprintf(fname, "Output file name [%s] = ", _CDUMP);
				fprintf(stderr, "%s", fname);
				fgets(fname, MAX_PATH, stdin);
				if((p = strrchr(fname, '\n')))
					*p = '\0';
				if(strlen(fname) > 0)
					fp = fopen(fname, "w");
				else
					fp = fopen(_CDUMP, "w");
			}
#endif
#if USE_JOIN
			GWjoin(0,0,1,NULL);
#endif
			GWinitx(IRB,-1,-1,-1,-1,-1,TOPMOST,-1,-1);
#ifdef _CDUMP
			if(fp) {
				fprintf(fp, "#include \"GrWin.h\"\n\n");
				fprintf(fp, "int main()\n{\n");
#if USE_JOIN
				fprintf(fp, "\tGWjoin(0,0,1,NULL);\n");
#endif
				fprintf(fp, "\tGWinitx(%d,-1,-1,-1,-1,-1,%d,-1,-1);\n",
					IRB, TOPMOST);
			}
#endif
		}
		if((*Mode == 1)
#ifdef _CDUMP
		|| (*Mode == 3)
#endif
		) {			// GW or GWD
			GWID = GWopenx(0,0,0,GWC_BLACK,GWC_WHITE,-1,NULL);
#ifdef _CDUMP
			if(fp) fprintf(fp, "\tGWopenx(%d,0,0,%d,%d,-1,NULL);\n", 
				GWID>0?-GWID:0,GWC_BLACK,GWC_WHITE);
#endif
		} else if((*Mode == 2)
#ifdef _CDUMP
		|| (*Mode == 4)
#endif
		) {	// CGW or CGWD
			GWID = GWopenx(0,0,0,GWC_WHITE,GWC_BLACK,-1,NULL);
#ifdef _CDUMP
			if(fp) fprintf(fp, "\tGWopenx(%d,0,0,%d,%d,-1,NULL);\n", 
				GWID>0?-GWID:0,GWC_WHITE, GWC_BLACK);
#endif
		} else {
			fprintf(stderr, "ERROR: Invalid device number (%d)\n", *Mode);
#ifdef _CDUMP
			if(fp) {
//				fprintf(fp, "\tGWquit();");
				fprintf(fp, "\t// Invalid device number (%d)\n", *Mode);
				fprintf(fp, "\treturn 0;\n");
				fprintf(fp, "}\n");
				fclose(fp);
				fp = NULL;
			}
#endif
//			GWquit();
			return;
		}
		if(GWID > 0) 
			pGW = GW+(GWID-1);
		else {
			fprintf(stderr, "ERROR: failed to open a window (%d)\n", GWID);
#ifdef _CDUMP
			if(fp) {
//				fprintf(fp, "\tGWquit();");
				fprintf(fp, "\t// failed to open a window (%d)\n", GWID);
				fprintf(fp, "\treturn 0;\n");
				fprintf(fp, "}\n");
				fclose(fp);
				fp = NULL;
			}
#endif
//			GWquit();
			return;
		}
		pGW->ID = GWID;
		if((*Mode == 1)
#ifdef _CDUMP
		|| (*Mode == 3)
#endif
		) {
			pGW->lclrFg = GWC_BLACK;
			pGW->lclrBk = GWC_WHITE;
		} else if((*Mode == 2)
#ifdef _CDUMP
		|| (*Mode == 4)
#endif
		) {
			pGW->lclrFg = GWC_WHITE;
			pGW->lclrBk = GWC_BLACK;
		}
		pGW->mkCur = 0;
		ZeroMemory(pGW->marker, 32*sizeof(int));
		ZeroMemory(pGW->mkIdx, MRKTBLSIZE*sizeof(int));
/*
 * Insert the device in the list of open devices.
 */
		rbuf[0] = (float)GWID; /* Number used to select this device */
		rbuf[1] = 1.0;
		*nbuf = 2;
		Initial();
		if(GWID > 1) {
			GWarrange(3);
#ifdef _CDUMP
			if(fp) fprintf(fp, "\tGWarrange(3);\n");
#endif
		}
		break;
/*--- IFUNC=10, Close workstation -------------------------------------------*/
	case 10:
		FLUSH(*Sgmnts, nSgmnts);
		if(points) {
			free(points);
			points = NULL;
		}
#ifdef _CDUMP
		if(fp) {
#if !USE_LEAVE
			fprintf(fp, "\tGWquit();\n");
#endif
			fprintf(fp, "\treturn 0;\n");
			fprintf(fp, "}\n");
			fclose(fp);
			fp = NULL;
		}
#endif
#if USE_LEAVE
		GWleave();
#else
		GWquit();
#endif
		GWID = -1;
		break;
/*--- IFUNC=11, Begin picture -----------------------------------------------*/
	case 11:
	{
		float x1, y1, x2, y2, d;
		FLUSH(*Sgmnts, nSgmnts);
/*
 * Convert the passed max X and Y coordinates into the total width of the
 * new window. Add 1/4" margins to the requested area.
 */
		if(nBegin++) {
#ifdef _CDUMP
			if(fp) 
				fprintf(fp, "\tGWclear(-1);\n");
#endif
			GWclear(-1);
		}
		Initial();
		if(rbuf[0]*(pGW->HEIGHT) > rbuf[1]*(pGW->WIDTH)) {
			x1 = Qinch;
			x2 = (float)(pGW->WIDTH)/(pGW->HEIGHT) - Qinch;
			d = (x2-x1)/rbuf[0]*rbuf[1];
			y1 = (1.0f-d)/2;
			y2 = y1+d;
		} else {
			y1 = Qinch;
			y2 = 1.0f - Qinch;
			d = (y2-y1)/rbuf[1]*rbuf[0];
			x1 = ((float)(pGW->WIDTH)/(pGW->HEIGHT)-d)/2;
			x2 = x1+d;
		}
		GWvport(x1, y1, x2, y2);
		GWindow(0.0, 0.0, rbuf[0], rbuf[1]);
		pGW->WWIDTH = rbuf[0];
		pGW->WHEIGHT = rbuf[1];
#ifdef _CDUMP
		if(fp) {
			fprintf(fp, "\tGWvport(%f, %f, %f, %f);\n", x1, y1, x2, y2);
			fprintf(fp, "\tGWindow(0.0, 0.0, %f, %f);\n", rbuf[0], rbuf[1]);
		}
#endif
#ifdef RESETFR
		GWshowfr(TOPMOST);
#ifdef _CDUMP
		if(fp) 
			fprintf(fp, "\tGWshowfr(%d);\n", TOPMOST);
#endif
#endif
//		GWclear(-3);
		break;
	}
/*--- IFUNC=12, Draw line ---------------------------------------------------*/
	case 12:
		if((nSgmnts > 0) && (nSgmnts < MAXPNTS)
		&& (rbuf[0] == Sgmnts[nSgmnts-1][0]) 
		&& (rbuf[1] == Sgmnts[nSgmnts-1][1])) {
			Sgmnts[nSgmnts][0] = rbuf[2];
			Sgmnts[nSgmnts++][1] = rbuf[3];
		} else {
			FLUSH(*Sgmnts, nSgmnts);
			Sgmnts[nSgmnts][0] = rbuf[0];
			Sgmnts[nSgmnts++][1] = rbuf[1];
			Sgmnts[nSgmnts][0] = rbuf[2];
			Sgmnts[nSgmnts++][1] = rbuf[3];
		}
		break;
/*--- IFUNC=13, Draw dot ----------------------------------------------------*/
	case 13:
		GWputmrk(rbuf[0], rbuf[1]);
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWputmrk(%f, %f);\n", rbuf[0], rbuf[1]);
#endif
		break;
/*--- IFUNC=14, End picture -------------------------------------------------*/
	case 14:
		FLUSH(*Sgmnts, nSgmnts);
#ifdef _CDUMP
		if(fp) 
			fprintf(fp, "\tGWpause(\"Pause\");\n");
#endif
	    *nbuf = -1;
		break;
/*--- IFUNC=15, Set color index ---------------------------------------------*/
	case 15:
		FLUSH(*Sgmnts, nSgmnts);
		if( ((int)(rbuf[0] + 0.5) < 0)
		 || ((int)(rbuf[0] + 0.5) >= MAXCOLOR) ) break;
		pGW->curC = (int) (rbuf[0] + 0.5);
		if((pGW->curC >= 0) && (pGW->curC < MAXCOLOR)) {
			GWsetpen(pGW->lcolor[pGW->curC], -1, -1, -1);
			GWsetbrs(pGW->lcolor[pGW->curC], -1, -1);
			GWsetmrk(-1, -1, pGW->lcolor[pGW->curC], -1, -1);
#ifdef _CDUMP
			if(fp) {
				fprintf(fp, "\tGWsetpen(%d, -1, -1, -1);\n", 
					pGW->lcolor[pGW->curC]);
				fprintf(fp, "\tGWsetbrs(%d, -1, -1);\n", 
					pGW->lcolor[pGW->curC]);
				fprintf(fp, "\tGWsetmrk(-1, -1, %d, -1, -1);\n", 
					pGW->lcolor[pGW->curC]);
			}
#endif
			ZeroMemory(pGW->marker, 32*sizeof(int));
		}
		break;
/*--- IFUNC=16, Flush buffer ------------------------------------------------*/
	case 16:
		FLUSH(*Sgmnts, nSgmnts);
	    *nbuf = -1;
		break;
/*--- IFUNC=17, Read cursor -------------------------------------------------*/
	case 17:
	{
		int ILB,		// left button
			IRB = 0,	// right button
			ICH = 0;	// last nonsystem key code

		while(ICH == 0) {
			GWidle(&ICH, &(rbuf[0]), &(rbuf[1]), 1000);
			if(ICH == -1) {
#ifdef __WATCOMC__
				*(chr->p) = 'A';
#else
				*chr = 'A';
#endif
				ILB = 1;
				while(ILB) {
					ILB = GWmouse(&IRB, NULL, NULL);
#ifdef __WATCOMC__
					if(IRB) *(chr->p) = 'X';
#else
					if(IRB) *chr = 'X';
#endif
				}
			} else if(ICH == -2) {
#ifdef __WATCOMC__
				*(chr->p) = 'D';
#else
				*chr = 'D';
#endif
				IRB = 1;
				while(IRB) {
					ILB = GWmouse(&IRB, NULL, NULL);
#ifdef __WATCOMC__
					if(ILB) *(chr->p) = 'X';
#else
					if(ILB) *chr = 'X';
#endif
				}
			} else {
#ifdef __WATCOMC__
				*(chr->p) = ICH;
#else
				*chr = ICH;
#endif
				GWkybrd(NULL, NULL, NULL, -1);
			}
		}
		*lchr = 1;
		*nbuf = 2;
		break;
	}
/*--- IFUNC=18, Erase alpha screen ------------------------------------------*/
	case 18:
	    *nbuf = -1;
		break;
/*--- IFUNC=19, Set line style ----------------------------------------------*/
	case 19:
		FLUSH(*Sgmnts, nSgmnts);
		GWsetpen(-1, (int) (rbuf[0] + 0.5), -1, -1);
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWsetpen(-1, %d, -1, -1);\n", (int) (rbuf[0] + 0.5));
#endif
		break;
/*--- IFUNC=20, Polygon fill ------------------------------------------------*/
	case 20:
		FLUSH(*Sgmnts, nSgmnts);
		if(nVertices == 0) {
			npnt = nVertices = (int) (rbuf[0] + 0.5);
			pnt = points = (float*)malloc(sizeof(float)*2*nVertices);
			if(points == NULL) {
				fprintf(stderr, "Polygon fill failed [%d]\n", nVertices);
				nVertices = 0;
#ifdef _CDUMP
				if(fp) {
#if !USE_LEAVE
					fprintf(fp, "\tGWquit();\n");
#endif
					fprintf(fp, "\t// Polygon fill failed [%d]\n", nVertices);
					fprintf(fp, "\treturn 0;\n");
					fprintf(fp, "}\n");
					fclose(fp);
					fp = NULL;
				}
#endif
#if USE_LEAVE
				GWleave();
#else
				GWquit();
#endif
				GWID = -1;
			}
			return;
		} else if(nVertices > 0) {
			*pnt++ = rbuf[0];
			*pnt++ = rbuf[1];
			if((--nVertices) == 0) {
				GWpolygon(points, npnt, 0);
#ifdef _CDUMP
				if(fp) {
					int i;
					fprintf(fp, "{\n");
					fprintf(fp, "float points[] = {");
					for(i = 0; i < 2*npnt; i += 2) {
						if(i%4 == 0) fprintf(fp, "\n\t");
						fprintf(fp, "%f, %f, ", points[i], points[i+1]);
					}
					fprintf(fp, "0.0};\n");
					fprintf(fp, "\tGWpolygon(points, %d, 0);\n", npnt);
					fprintf(fp, "}\n");
				}
#endif
				free(points);
				points = NULL;
			}
			return;
		}
	    *nbuf = -1;
		break;
/*--- IFUNC=21, Set color representation ------------------------------------*/
	case 21:
		FLUSH(*Sgmnts, nSgmnts);
		if( ((int)(rbuf[0] + 0.5) < 0)
		 || ((int)(rbuf[0] + 0.5) >= MAXCOLOR) ) break;
		pGW->lcolor[	(int)(rbuf[0] + 0.5)] = 
			GWkrgb(	(int)(rbuf[1]*MAXCOLOR1 + 0.5),
					(int)(rbuf[2]*MAXCOLOR1 + 0.5),
					(int)(rbuf[3]*MAXCOLOR1 + 0.5));
		if((int)(rbuf[0] + 0.5) == 0) {
			GWcolor(pGW->lcolor[(int)(rbuf[0] + 0.5)], 2);
#ifdef _CDUMP
			if(fp) fprintf(fp, "\tGWcolor(%d, 2);\n", 
				pGW->lcolor[(int)(rbuf[0] + 0.5)]);
#endif
		}
		break;
/*--- IFUNC=22, Set line width ----------------------------------------------*/
/*    rbuf[0]: requested line width, in units of 0.005 inch.                 */
	case 22:
		FLUSH(*Sgmnts, nSgmnts);
		GWsetpen(-1, -1, (int)(rbuf[0]*pGW->DPIY/200), -1);
		GWsetmrk(-1, rbuf[0]*pGW->DPIY/200*pGW->WHEIGHT/pGW->HEIGHT, -1, -1, -1);
#ifdef _CDUMP
		if(fp) {
			fprintf(fp, "\tGWsetpen(-1, -1, %d, -1);\n", 
				(int)(rbuf[0]*pGW->DPIX/200));
			fprintf(fp, "\tGWsetmrk(-1, %f, -1, -1, -1);\n", 
				rbuf[0]*pGW->DPIY/200*pGW->WHEIGHT/pGW->HEIGHT);
		}
#endif
		break;
/*--- IFUNC=23, Escape function ---------------------------------------------*/
	case 23:
	    *nbuf = -1;
		break;
/*--- IFUNC=24, Rectangle fill ----------------------------------------------*/
	case 24:
		FLUSH(*Sgmnts, nSgmnts);
		GWsrect(rbuf[0], rbuf[1], rbuf[2], rbuf[3], pGW->lcolor[pGW->curC]);
#ifdef _CDUMP
		if(fp) fprintf(fp, "\tGWsrect(%f, %f, %f, %f, %d);\n", 
			rbuf[0], rbuf[1], rbuf[2], rbuf[3], pGW->lcolor[pGW->curC]);
#endif
		break;
/*--- IFUNC=25, Set fill pattern --------------------------------------------*/
	case 25:
	    *nbuf = -1;
		break;
/*--- IFUNC=26, Line of pixels ----------------------------------------------*/
	case 26:
		FLUSH(*Sgmnts, nSgmnts);
		if(chr7 == 'Q') {
			static int n, *ibits;
			static float w, h, x0 = 0, y0 = 0, x1, y1, x2, y2;
			static float xfrm[6];
			static float xscl, yscl;

			if(rbuf[0] > 0) {
				for(i = 0; i < (int)(rbuf[0]+0.5); ++i) 
					ibits[n++] = pGW->lcolor[(int)(rbuf[1+i]+0.5)];
			} else if(rbuf[0] < 0) {
				int ibmp = GWmakebmp(0, (int)(w + 0.5), -(int)(h + 0.5), 
							COLORBITS, ibits);
				GWsetbmp(ibmp, w*xscl, h*yscl, 1, 0, 1);	// SRCCOPY
				GWsetrgn(x1, y1, x2, y2, 1);
				GWsetxfrm(xfrm);
				GWputbmp(ibmp, x0, y0, 1);
				GWsetxfrm(NULL);
				GWsetrgn(0.0, 0.0, 0.0, 0.0, -1);
#ifdef _CDUMP
				if(fp) {
					int i;
					fprintf(fp, "{\n");
					fprintf(fp, "float xfrm[] = {\n\t");
					for(i = 0; i < 6; ++i) 
						fprintf(fp, "%f%s", xfrm[i], 
							(i==2)?",\n\t":((i==5)?"};\n":", "));
					fprintf(fp, "int ibits[] = {");
					for(i = 0; i < n; ++i) {
						if(i%4 == 0) fprintf(fp, "\n\t");
						fprintf(fp, "%d, ", ibits[i]);
					}
					fprintf(fp, "0};\n");
					fprintf(fp, "\tint ibmp = GWmakebmp(0, %d, %d, %d, ibits);\n", 
						(int)(w + 0.5), -(int)(h + 0.5), COLORBITS);
					fprintf(fp, "\tGWsetbmp(ibmp, %f, %f, 1, 0, 1);\n", 
						w*xscl, h*yscl);
					fprintf(fp, "\tGWsetrgn(%f, %f, %f, %f, 1);\n", x1, y1, x2, y2);
					fprintf(fp, "\tGWsetxfrm(xfrm);\n");
					fprintf(fp, "\tGWputbmp(ibmp, %f, %f, 1);\n", x0, y0);
					fprintf(fp, "\tGWsetxfrm(NULL);\n");
					fprintf(fp, "\tGWsetrgn(0.0, 0.0, 0.0, 0.0, -1);\n");
					fprintf(fp, "}\n");
				}
#endif
				if(ibits) free(ibits);
				ibits = NULL;
			} else {
				int dx, dy;
				w = rbuf[1];
				h = rbuf[2];
				n = 0;
				ibits = (int*)malloc(sizeof(int)*(int)(w*h+0.5));
				x1 = rbuf[3];
				x2 = rbuf[4];
				y1 = rbuf[5];
				y2 = rbuf[6];
				GWldcsiz((float)fabs(x2-x1), (float)fabs(y2-y1), &dx, &dy);
				if(dx && dy) {
					float den, FAC = 1/(rbuf[7]*rbuf[10] - rbuf[8]*rbuf[9]);
					xfrm[0] = FAC*(rbuf[9]*rbuf[12] - rbuf[10]*rbuf[11]);
					xfrm[1] = FAC*rbuf[10];
					xfrm[2] = FAC*rbuf[ 9];
					xfrm[3] = FAC*(rbuf[8]*rbuf[11] - rbuf[ 7]*rbuf[12]);
					xfrm[4] = FAC*rbuf[ 8];
					xfrm[5] = FAC*rbuf[ 7];
					den = xfrm[1]*xfrm[5]-xfrm[2]*xfrm[4];
					yscl = (float)sqrt(xfrm[2]*xfrm[2]+xfrm[5]*xfrm[5]);
					xscl = den/yscl;
					xfrm[1] /= xscl;
					xfrm[2] /= yscl;
					xfrm[4] /= xscl;
					xfrm[5] /= yscl;
				} else {
					xfrm[0] = 0;
					xfrm[1] = 1;
					xfrm[2] = 0;
					xfrm[3] = 0;
					xfrm[4] = 0;
					xfrm[5] = 1;
				}
			}
		}
		*nbuf = -1;
		break;
/*--- IFUNC=27, Scaling information -----------------------------------------*/
	case 27:
		rbuf[0] = 0.0;
		rbuf[1] = 1.0;
		rbuf[2] = 0.0;
		rbuf[3] = 1.0;
	    *nbuf = 4;
		break;
/*--- IFUNC=28, Draw marker -------------------------------------------------*/
// rbuf[3]: scale factor (number of device units per unit of ``marker 
//          coordinate space''). The shapes of the marker symbols are defined 
//          in a coordinate system in which the radius of typical symbols is 
//          10 units or less; for more information, see the Hershey definitions 
//          of the markers (Appendix B). 
	case 28:
	{
		int m = (int)(rbuf[0] + 0.5);
		FLUSH(*Sgmnts, nSgmnts);
		if(!pGW->marker[m]) {
			if(pGW->mkIdx[pGW->mkCur]) {
				GWdelcmb(pGW->mkIdx[pGW->mkCur]);
#ifdef _CDUMP
				if(fp) 
					fprintf(fp, "\tGWdelcmb(%d);\n", pGW->mkIdx[pGW->mkCur]);
#endif
			}
			pGW->mkIdx[pGW->mkCur] = pGW->marker[m] = GetPGSymbol(HERSH[m]);
			if(pGW->mkIdx[pGW->mkCur] && (++(pGW->mkCur) >= MRKTBLSIZE)) 
				pGW->mkCur -= MRKTBLSIZE;
		}
		if(pGW->marker[m] > 0) {
			GWputcmb(pGW->marker[m], rbuf[1], rbuf[2], 
				100*rbuf[3], 100*rbuf[3], 0);
#ifdef _CDUMP
			if(fp) fprintf(fp, "\tGWputcmb(%d, %f, %f, %f, %f, 0);\n", 
					pGW->marker[m], rbuf[1], rbuf[2], 100*rbuf[3], 100*rbuf[3]);
#endif
		}
		*nbuf = -1;
		break;
	}
/*--- IFUNC=29, Query color representation ----------------------------------*/
	case 29:
		if( ((int)(rbuf[0] + 0.5) < 0)
		 || ((int)(rbuf[0] + 0.5) >= MAXCOLOR) ) break;
		{
			int r, g, b;
			GWgetrgb(pGW->lcolor[(int)(rbuf[0] + 0.5)], &r, &g, &b);
			rbuf[1] = r/(float)MAXCOLOR1;
			rbuf[2] = g/(float)MAXCOLOR1;
			rbuf[3] = b/(float)MAXCOLOR1;
			*nbuf = 4;
		}
		break;
/*--- IFUNC=30, Scroll rectangle --------------------------------------------*/
	case 30:
	    *nbuf = -1;
		break;
 	default:
		fprintf(stderr, "/GW: Unexpected opcode=%d in stub driver.\n", *opcode);
		*nbuf = -1;
		break;
	}
	return;
}
