$ofile = shift;		# man_body.htm
$TOCfile = shift;	# man_toc.htm
$IDXfile = shift;	# man_index.htm
$ALL = shift;		# All.h
$DIST = shift;		# GrWin.h
$FORT = shift;		# GrWin.f
$DOUBLEH = shift;	# Double.h

@LLFuncs = ();

require '../script/version.pl';

open(All, ">$ALL");
open(DIST,">$DIST");
open(FORT,">$FORT");
open(MAN, ">$ofile");
open(EMAN, ">E$ofile");

print DIST "// GrWin Library $VERSION (build \#  $MAGIC)\n";
print DIST "// $COPYRIGHT\n";
print DIST "// Created: $CREATIONTIME\n\n";

print DIST "\#include <windows.h>\n\n";
print DIST "\#ifdef __cplusplus\n";
print DIST "extern \"C\" {\n";
print DIST "\#endif\n";

print DIST "\n// Logical colors\n";
print DIST "\#define GWC_BLACK       0\n";
print DIST "\#define GWC_DARKRED     1\n";
print DIST "\#define GWC_DARKGREEN   2\n";
print DIST "\#define GWC_DARKYELLOW  3\n";
print DIST "\#define GWC_DARKBLUE    4\n";
print DIST "\#define GWC_DARKMAGENTA 5\n";
print DIST "\#define GWC_DARKCYAN    6\n";
print DIST "\#define GWC_LIGHTGRAY   7\n";
print DIST "\#define GWC_MONEYGREEN  8\n";
print DIST "\#define GWC_SKYBLUE     9\n";
print DIST "\#define GWC_CREAM      10\n";
print DIST "\#define GWC_MEDIUMGRAY 11\n";
print DIST "\#define GWC_DARKGRAY   12\n";
print DIST "\#define GWC_RED        13\n";
print DIST "\#define GWC_GREEN      14\n";
print DIST "\#define GWC_YELLOW     15\n";
print DIST "\#define GWC_BLUE       16\n";
print DIST "\#define GWC_MAGENTA    17\n";
print DIST "\#define GWC_CYAN       18\n";
print DIST "\#define GWC_WHITE      19\n";
print DIST "\#define GWC_FGCOLOR    -2\n";
print DIST "\#define GWC_BKCOLOR    -3\n\n";

print DIST "\n// Pen styles\n";
print DIST "\#define GWL_NULL       0\n";
print DIST "\#define GWL_SOLID      1\n";
print DIST "\#define GWL_DASH       2\n";
print DIST "\#define GWL_DOT        3\n";
print DIST "\#define GWL_DASHDOT    4\n";
print DIST "\#define GWL_DASHDOTDOT 5\n";

print DIST "\n// Brush styles\n";
print DIST "\#define GWB_NULL       0\n";
print DIST "\#define GWB_SOLID      1\n";
print DIST "\#define GWB_HATCHED    2\n";

print DIST "\n// Hatch styles\n";
print DIST "\#define GWB_HORIZONTAL 1\n";
print DIST "\#define GWB_VERTICAL   2\n";
print DIST "\#define GWB_FDIAGONAL  3\n";
print DIST "\#define GWB_BDIAGONAL  4\n";
print DIST "\#define GWB_CROSS      5\n";
print DIST "\#define GWB_DIAGCROSS  6\n";

print DIST "\n// MIX (ROP2) modes\n";
print DIST "\#define GWX_NOP          0\n";
print DIST "\#define GWX_BLACK        1\n";
print DIST "\#define GWX_WHITE        2\n";
print DIST "\#define GWX_NOT          3\n";
print DIST "\#define GWX_COPYPEN      4\n";
print DIST "\#define GWX_MASKPEN      5\n";
print DIST "\#define GWX_MERGEPEN     6\n";
print DIST "\#define GWX_XORPEN       7\n";
print DIST "\#define GWX_NOTCOPYPEN   8\n";
print DIST "\#define GWX_NOTMASKPEN   9\n";
print DIST "\#define GWX_NOTMERGEPEN 10\n";
print DIST "\#define GWX_NOTXORPEN   11\n";
print DIST "\#define GWX_MASKNOTPEN  12\n";
print DIST "\#define GWX_MASKPENNOT  13\n";
print DIST "\#define GWX_MERGENOTPEN 14\n";
print DIST "\#define GWX_MERGEPENNOT 15\n";

print DIST "\n// View mode\n";
print DIST "\#define GWV_BITMAP      1\n";
print DIST "\#define GWV_ISOTROPIC   2\n";
print DIST "\#define GWV_FIT         3\n";
print DIST "\#define GWV_TOTAL       4\n";
print DIST "\#define GWV_ZOOM        5\n";

print DIST "\n// File format\n";
print DIST "\#define GWF_GWD         1\n";
print DIST "\#define GWF_EMF         2\n";
print DIST "\#define GWF_BMP         3\n";
#print DIST "\#define GWF_JPG         4\n";
#print DIST "\#define GWF_PNG         5\n";
#print DIST "\#define GWF_EPS         6\n";

#print DIST "\n\#ifdef __CYGWIN__\n";
#print DIST "int getch(void);\n";
#print DIST "int getche(void);\n";
#print DIST "\#endif\n";

print DIST "\n\#if !defined(__LCC__) && !defined(_MSC_VER) && !defined(__BORLANDC__)\n";
print DIST "int kbhit();\n";
print DIST "\#endif\n";
print DIST "\n\#ifdef __CYGWIN32__\n";
print DIST "int getch (void);\n";
print DIST "int getche (void);\n";
print DIST "\#endif\n\n";

print DIST "\#ifdef __F2C__\n";
print DIST "float rand_(void);\n";
print DIST "\#endif\n\n";

$SEPARATOR = '-'x50;
print FORT "*$SEPARATOR\n";
print FORT "* GrWin Library $VERSION ($PRODUCTVERSION)\n";
print FORT "* $COPYRIGHT\n";
print FORT "* Created: $CREATIONTIME\n\n";
print FORT "*$SEPARATOR\n";

$n = 0;
$F = "Fortran";
$C = "C";
$ttl = "";
$Ettl = "Function";
while($f = shift) {
	print $f,"\n";
	print All "// ",$f,"\n";
	open(buff, $f);
	$yn = 0;
	$Chf = 0;
	$isC = 0;
	$isF = 0;
	$hrf = 0;
	$Eng = 0;
	$Tool = "";
	$AF = "";
	$AC = "";
	$F = "";
	$C = "";
	$cnt = 0;
	while(<buff>) {
		if(/^\s*\#if\s+0/) {
			while(<buff>) {
				last if /^\s*\#endif/;
			}
			next;
		}
		next if /^\!/;
		if($Eng && /[^\x00-\x7f]/) {
			print stderr "2-byte code included: $_";
			exit(1);
		}
		if(/^\*+$/) {			#*********************************
#			if($hrf) {
				push(temp, "\<hr\>");
				$hrf = 0;
#			}
		} elsif(/^\-+$/) {	#---------------------------------
			if($hrf) {
				push(temp, "\<hr\>");
				$hrf = 0;
			}
		} elsif(/^\_+$/) {	#_________________________________
			if($hrf) {
				push(temp, "\<hr\>");
				$hrf = 0;
			}
		} elsif($Chf != 0) {
			push(temp, "\<CODE\>$_\</CODE\>");
			print DIST unless $Eng;
			if(/\;/) {
				$Chf = 0;
				$isC = 0;
			}
		} elsif(/^\/\*\S/) {	# begin header part
			if(m|/*E|i) {
				$Eng = 1;
			} else {
				$Tool = substr($_,2);
				$Tool =~ s/\s+//g;
				$Eng = 0;
			}
			@temp = ();
			$AF = "";
			$AC = "";
			$F = "";
			$C = "";
			$yn = 1;
			$n += 1 unless $Eng;		# routine number
			$AN = "\<a name=\"routine$n\"\>\</a\>";
			$_ = "\n\<BR\>\<b\>$n. ";
			push(temp, $_);
			$_ = <buff>;
			print stderr "2-byte included: $_" if($Eng && /[^\x00-\x7f]/);
			push(temp, $_);
			push(temp, "\</b\>\<PRE\>");
			chop;
			$ttl = $_;
			$hrf = 1;
		} elsif(substr($_,0,2) eq "*/") {	# end of header part
			$yn = 2;
			$_ = "\n";
#			@header = ();
			if($Eng) {
				print EMAN "$AN$AF$AC";
			} else {
				print MAN "$AN$AF$AC";
			}
			foreach $_ (@temp) {
				if($Eng) {
					print EMAN;
				} else {
					print MAN;
				}
			}
			if($Eng) {
				print EMAN "\n\</PRE\>";
				print EMAN "\<DIV ALIGN=RIGHT\>\<A HREF=\"\#TOC\"\>[TOC]\</A\> \<A HREF=\"\#INDEX\"\>[INDEX]\</A\>\</DIV\>\n";
			} else {
				print MAN "\n\</PRE\>";
				print MAN "\<DIV ALIGN=RIGHT\>\<A HREF=\"\#TOC\"\>[TOC]\</A\> \<A HREF=\"\#INDEX\"\>[INDEX]\</A\>\</DIV\>\n";
			}
		} elsif(substr($_,0,1) eq "{") {
			$yn = 3;
#			print All @header;
		} elsif(substr($_,0,1) eq "}") {
			$yn = 2;
		} elsif($yn == 1) {		# Header part
			$l = $_;
			if(substr($_,0,3) eq '[F]') {
				$isF = 1;
				++$hrf;
				substr($_,0,4) = '';
				print FORT "      $_" unless $Eng;
				chop;
				if(s/([^ ]*) *FUNCTION//i > 0) {
					s/ //;
					s/^([^\(]*).*/$1/;
					$F = "\L$_".'*';
					$AF .= "\<a name=\"\L$_\"\>\</a\>";
				} elsif(s/SUBROUTINE//i > 0) {
					s/ //;
					s/^([^\(]*).*/$1/;
					$F = "\L$_";
					$AF .= "\<a name=\"$F\"\>\</a\>";
				} else {
					$F = $_;
					$AF .= "\<a name=\"$F\"\>\</a\>";
				}
				push(temp, "\<CODE\>$l\</CODE\>");
			} elsif((substr($_,0,3) eq '[C]')) {
				$isF = 0;
				$isC = 1;
				++$hrf;
				if(/Ȃ/) {
					$C = 'Ȃ';
				} elsif(/None/i) {
					$C = 'None';
				} else {
					substr($_,0,4) = '';
#					print DIST unless $Eng;
					print DIST if !$Eng && !/ kbhit\(/;
					if(!(/\;/)) {
						$Chf = 1;
					}
					chop;
					s/int//;
					s/float//;
					s/ //;
					s/^([^\(]*).*/$1/;
					s/\;//;
					$C = $_;
					$AC .= "\<a name=\"$C\"\>\</a\>";
				}
				push(temp, "\<CODE\>$l\</CODE\>");
				if($Eng) {
					$line = join(';',$ttl,$F,$C,$n,$Tool);
					push(EToc, $line);
				} else {
					$line = join(';',$F,$C,$n,$ttl,$Tool);
					push(Toc, $line);
				}
			} else {
				if($isF) {
					if(/^\s*\n/) {
						print FORT "      END\n" unless $Eng;
						print FORT unless $Eng;
						$isF = 0;
					} else {
						print FORT "  $_" unless $Eng;
					}
				}
				if(($Chf != 0) && (substr($_,0,1) eq ' ')) {
					print DIST unless $Eng;
				} else {
					$Chf = 0;
				}
				$l =~ s/\&/\&amp\;/g;
				$l =~ s/\</\&lt\;/g;
				$l =~ s/\>/\&gt\;/g;
				$l =~ s/\"/\&quot\;/g;
				if($l =~ /^\(([^\)]*)\)(.*)/) {
					push(temp, "\($1\)\n$2");
				} elsif($l =~ /^\[([^\]]*)\](.*)/) {
					push(temp, "\[$1\]\n$2");
				} else {
					push(temp, "\<CODE\>") if($hrf);
					push(temp, $l);
					push(temp, "\</CODE\>") if($hrf);
				}
			}
		} elsif($yn == 2) {
			if(!(m#\s*//#) && (length > 1)) {
#				push @header, $_;
				s/\)\s*\n/);\n/;
				if(!/=/ && !/^\s*static/ && !/^\s*\#/ && !/\];/) {
					print All;
					push(@LLFuncs, $_) if($cnt || /^\S+\s+GW_/);
#					print DIST if /^\S+\s+GW_/;
					if(/^\S+\s+GW_/ && !/\;\s*$/) {$cnt = 1;}
					else {$cnt = 0;}
				}
			}
		}
	}
}

print DIST "\n// Low Level Functions\n";
#sort(@LLFuncs, byfnames);
foreach $_ (@LLFuncs) {
	print DIST;
}

print DIST "\n// Functions with double prec args\n";
if(open(DOUBLEH, "<$DOUBLEH") == 1)
{
	while(<DOUBLEH>) {
		print DIST;
	}
}

print DIST "\n\#ifdef __cplusplus\n";
print DIST "}\n";
print DIST "\#endif\n";

open(CALCOMP, ">calcomp.pl");
printf(CALCOMP "\$CAL2 = $n;\n");
$cal1 = $n - 7;
printf(CALCOMP "\$CAL1 = $cal1;\n");
close(CALCOMP);

@Idx = sort @Toc;
open(TOC, ">$TOCfile");
printf(TOC "\<table border=1\>\n");
printf(TOC 
	"\<tr\>\<th align=\"left\"\>#\</th\> \<th align=\"left\"\>Fortran\</th\> \<th align=\"left\"\>C\</th\> \<th align=\"left\"\>@ \\</th\> \<th align=\"left\"\>n\</th\> \</tr\>\n");
while(@Toc) {
	($F,$C,$n,$ttl,$Tool) = split(/;/,shift @Toc);
#	@item = split(/;/,shift @Toc);
#	$F = shift @item;
	$FA = $F;
	$FA =~ s/\*//;
#	$C = shift @item;
#	$n = shift @item;
	printf(TOC 
		"\<tr\>\<td\>\<a href=\"\#routine%d\"\>%2d\</a\>.\</td\> ", $n, $n);
	printf(TOC "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $FA, $F);
	printf(TOC "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $C, $C);
#	printf(TOC "\<td\>%s\</td\>\n", @item);
	printf(TOC "\<td\>%s\</td\>\n", $ttl);
	printf(TOC "\<td\>%s\</td\> ", $Tool);
}
printf(TOC "\</table\>\n");
close(TOC);

@EIdx = sort @EToc;
open(TOC, ">E$TOCfile");
printf(TOC "\<table border=1\>\n");
printf(TOC 
	"\<tr\>\<th align=\"left\"\>#\</th\> \<th align=\"left\"\>Fortran\</th\> \<th align=\"left\"\>C\</th\> \<th align=\"left\"\>Function\</th\> \<th align=\"left\"\>n\</th\> \</tr\>\n");
while(@EToc) {
#	@item = split(/;/,shift @EToc);
	($ttl,$F,$C,$n,$Tool) = split(/;/,shift @EToc);
#	$ttl = shift @item;
#	$F = shift @item;
	$FA = $F;
	$FA =~ s/\*//;
#	$C = shift @item;
#	$n = shift @item;
	printf(TOC 
		"\<tr\>\<td\>\<a href=\"\#routine%d\"\>%2d\</a\>.\</td\> ", $n, $n);
	printf(TOC "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $FA, $F);
	printf(TOC "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $C, $C);
	printf(TOC "\<td\>%s\</td\>\n", $ttl);
	printf(TOC "\<td\>%s\</td\> ", $Tool);
}
printf(TOC "\</table\>\n");
close(TOC);

open(IDX, ">$IDXfile");
printf(IDX "\<table border=1\>\n");
printf(IDX 
	"\<tr\>\<th align=\"left\"\>Fortran\</th\> \<th align=\"left\"\>C\</th\> \<th align=\"left\"\>@ \\</th\> \<th align=\"left\"\>#\</th\>\</tr\>\n");
while(@Idx) {
	@item = split(/;/,shift @Idx);
	$F = shift @item;
	$FA = $F;
	$FA =~ s/\*//;
	$C = shift @item;
	$n = shift @item;
	printf(IDX "\<tr\>");
	printf(IDX "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $FA, $F);
	printf(IDX "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $C, $C);
	printf(IDX "\<td\>%s\</td\>", @item);
	printf(IDX "\<td\>\<a href=\"\#routine%d\"\>%2d\</a\>.\</td\> ", $n, $n);
	printf(IDX "\n");
}
printf(IDX "\</table\>\n");
close(IDX);

open(IDX, ">E$IDXfile");
printf(IDX "\<table border=1\>\n");
printf(IDX 
	"\<tr\>\<th align=\"left\"\>Function\</th\> \<th align=\"left\"\>Fortran\</th\> \<th align=\"left\"\>C\</th\> \<th align=\"left\"\>#\</th\>\</tr\>\n");
while(@EIdx) {
	@item = split(/;/,shift @EIdx);
	$ttl = shift @item;
	$F = shift @item;
	$FA = $F;
	$FA =~ s/\*//;
	$C = shift @item;
	$n = shift @item;
	printf(IDX "\<tr\>");
	printf(IDX "\<td\>%s\</td\>", $ttl);
	printf(IDX "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $FA, $F);
	printf(IDX "\<td\>\<a href=\"\#%s\"\>%s\</a\>\</td\> ", $C, $C);
	printf(IDX "\<td\>\<a href=\"\#routine%d\"\>%2d\</a\>.\</td\> ", $n, $n);
	printf(IDX "\n");
}
printf(IDX "\</table\>\n");
close(IDX);

sub fnames {
	local ($fn1, $fn2) = ($a, $b);
	$fn1 = $' if $fn1 =~ /^\S+\s+GW_/;
	$fn2 = $' if $fn2 =~ /^\S+\s+GW_/;
	$fn1 gt $fn2;
}