[Setup]
;MessagesFile=compiler:english.isl
AppName=GrWin Graphics Library
AppVerName=GrWin Version  0.99.9b for VC++/f2c
DefaultDirName={sd}\GrWin
DisableProgramGroupPage=yes
OutputDir=..
OutputBaseFilename=lGrWn0999be-f2vcpp
UninstallDisplayIcon={app}\grwnd.ico

[Messages]
; *** "Welcome" wizard page
WelcomeLabel2=This will install [name/ver] on your computer.%n%nIf an earlier version of [name] exists installed it must be uninstalled to prevent problems due to mixed uses of earlier files with those just will be installed, unless you know what you are doing.  It is also strongly recommended that you close all other applications you have running before continuing. This will help prevent any conflicts during the installation process.  

[Dirs]
Name: "{app}\demo"; Components: demo
Name: "{app}\pgplot"; Tasks: pgplot
;Name: "{app}\GrWinTk"; Tasks: GrWinTk

[Types]
Name: "vcpp"; Description: "for Microsoft Visual C++ / f2c"

[Components]
Name: "main"; Description: "Main Files"; Types: vcpp; Flags: fixed
Name: "demo"; Description: "Examples"; Types: vcpp;
Name: "vcpp"; Description: "Files for Microsoft Visual C++ / f2c"; Types: vcpp

[Tasks]
Name: "NOcalcomp"; Description: "Installs GrWin0 library ( no Calcomp )"
Name: "calcomp"; Description: "Installs separate Calcomp library"
Name: "pgplot"; Description: "Installs Pgplot library"
;Name: "GKS"; Description: "Installs GKS library"
;Name: "GrWinTk"; Description: "Installs GrWin Tool Kit"

[Files]
Source: "..\..\GrWnd\RES\grwnd.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "bin\grwnd.exe"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "bin\grwnd.ini"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999b.html"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999b.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "README.html"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "README.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "lGrWn0999be-f2vcpp.iss"; DestDir: "{app}"; Components: main; Flags: ignoreversion

Source: "f77chk\f77chk.pl"; DestDir: "{code:exe}"; Components: main; Flags: ignoreversion
Source: "f77chk\f77chk.txt"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "..\GrWinTk\build\library.def"; DestDir: "{code:exe}"; Components: main; Tasks: pgplot; Flags: ignoreversion

Source: "..\..\skel\pgdemo\rgb.txt"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgplot.doc"; DestDir: "{app}\pgplot"; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgdemo17.ini"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\cpg\cpgdemo.c"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo1.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo2.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo3.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo4.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo5.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo6.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo7.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo8.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo9.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo10.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo11.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo12.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo13.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo14.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo15.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo16.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\pgplot\examples\pgdemo17.f"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion
Source: "..\..\skel\pgdemo\pgdemo17.ini"; DestDir: "{app}\pgplot"; Components: demo; Tasks: pgplot; Flags: ignoreversion

Source: "demo\ball.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bitmap.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bitmap.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bounce.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\bounce.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dp.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dspexf.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\dspexf.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\gwdemo17.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\gwdemo17.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\jonathan1.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\jonathan2.bmp"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mixmodes.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mixmodes.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mlwndws.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\mlwndws.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose_d.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\penrose_d.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\polygon_f.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample1.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample1.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample2.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\sample2.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\shot.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\shot.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\soliton.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\soliton.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tblfonts.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tblfonts.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\trigfn.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\trigfn.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstmlvp.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstmlvp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstttsmrk.f"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstttsmrk.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstwinapp.c"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion
Source: "demo\tstwinapp.html"; DestDir: "{app}\demo"; Components: demo; Flags: ignoreversion




Source: "vcpp\GrWin.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\GrWin0.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: NOcalcomp; Flags: ignoreversion
Source: "vcpp\Calcomp.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: calcomp; Flags: ignoreversion
Source: "vcpp\f2c.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\f2c.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\f2c.exe"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "vcpp\gwf2cl.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwf2cl.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion

Source: "include\GrWin.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Flags: ignoreversion
Source: "vcppML\gwcl.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "vcppML\gwclw.bat"; DestDir: "{code:exe}"; Components: vcpp; Flags: ignoreversion
Source: "..\pgplot-vcpp\cpgplot.h"; DestDir: "{code:vcpp}\Include"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pgplot.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\cpgplot.lib"; DestDir: "{code:vcpp}\Lib"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwcl.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion
Source: "..\pgplot-vcpp\pggwclw.bat"; DestDir: "{code:exe}"; Components: vcpp; Tasks: pgplot; Flags: ignoreversion

[Code]
var
	vcpp_base: String;
	system_drive: String;
	program_files: String;

function InitializeSetup(): Boolean;
begin
	vcpp_base := '';
	system_drive := ExpandConstant('{sd}');
	program_files := ExpandConstant('{pf}');

	{ Let Setup run }
	Result := True;
end;

function GetBaseDir(Default, Description, Check: String): String;
var
	Ok: Boolean;
	YesNo: Integer;
begin
	Result := Default;
	ScriptDlgPageOpen();
	{ Set some captions }
	ScriptDlgPageSetCaption(Description);
	ScriptDlgPageSetSubCaption1('Where has ' + Check + ' been installed?');
	ScriptDlgPageSetSubCaption2('Select the folder, then click Next.');
	{ Ask for a dir until the user has entered one or click Back or Cancel }
	Ok := InputDir('', Result);
	if Ok then begin
		while Ok and not FileExists(Result + '\' + Check) do begin
			YesNo := MsgBox('Not found ' + Check + ' in ' + Result + '. '#13#13'Continue?', mbError, MB_YESNOCANCEL or MB_DEFBUTTON2);
			if YesNo = idYes then begin
			Ok := False;
			end else if YesNo = idNo then begin
				Ok := InputDir('', Result);
				if not Ok then Result := '';
			end else begin
				Ok := False;
				Result := '';
			end;
		end;
		ScriptDlgPageClose(True);
	end else
		Result := '';
end;

function vcpp(Default: String): String;
begin
  if vcpp_base = '' then
    vcpp_base := GetBaseDir(program_files + '\Microsoft Visual Studio\VC98', 'Microsoft Visual C++ / f2c', '\include\stdio.h');
  Result := vcpp_base;
end;

function exe(Default: String): String;
var
	SetupType: String;
begin
	Result := ExpandConstant('{code:vcpp}\Bin');
{  MsgBox(Result, mbError, MB_OK);}
end;

function DirCheck(DirName: String): Boolean;
begin
	Result := DirExists(DirName);
end;
