# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>


import string
from qt import QListView, QListViewItem, QWhatsThis, SIGNAL

from Config import ConfigVarTypeDispStrings, ConfigVarTypeStrings, ConfigVarEditable


class VariablesViewer(QListView):
    """VariablesViewer(self,parent=None,scope=1)
    
    A class to display a list of variables.
    
    """
    def __init__(self,parent=None,scope=1,dbs=None):
        QListView.__init__(self,parent)
        
        self.dbs = dbs
        
        self.setRootIsDecorated(1)
        self.setAllColumnsShowFocus(1)
        self.scope = scope
        if scope:
            self.setCaption(self.trUtf8("Global Variables"))
            self.addColumn(self.trUtf8("Globals"))
            QWhatsThis.add(self,self.trUtf8(
"""<b>The Global Variables Viewer Window</b>"""
"""<p>This window displays the global variables"""
""" of the debugged program.</p>"""
                        ))
        else:
            self.setCaption(self.trUtf8("Local Variables"))
            self.addColumn(self.trUtf8("Locals"))
            QWhatsThis.add(self,self.trUtf8(
"""<b>The Local Variables Viewer Window</b>"""
"""<p>This window displays the local variables"""
""" of the debugged program.</p>"""
                        ))
        
        self.addColumn(self.trUtf8("Type"))
        self.addColumn(self.trUtf8("Value"))
        self.setSorting(0)
        
        self.connect(self,
            SIGNAL('itemRenamed(QListViewItem*,int,const QString&)'),
            self.handleItemRenamed)
        
    def showVariables(self, vlist):
        """
        Public method to show the variables in a listview
        """
        self.clear()
        
        if len(vlist):
            itm = None
            for (var, vtype, value) in vlist:
                slist = string.split(var,'.',1)
                # format the type nicely
                editable = 0
                try:
                    i = ConfigVarTypeStrings.index(vtype)
                    vtype = self.trUtf8(ConfigVarTypeDispStrings[i])
                    editable = i in ConfigVarEditable
                except ValueError:
                    pass
                item = self.findItem(slist[0], 0)
                if item:
                    itm = QListViewItem(item, slist[1], vtype, value)
                    if not item.isOpen():
                        item.setOpen(1)
                else:
                    itm = QListViewItem(self, var, vtype, value)
                itm.setRenameEnabled(2, editable)

    def handleItemRenamed(self, itm, col, text):
        """
        Private slot to handle the changing of a variables value.
        """
        var = str(itm.text(0))
        par = itm.parent()
        while par is not None:
            var = '%s.%s' % (str(par.text(0)), var)
            par = par.parent()
        arg = '%s=%s' % (var, str(text))
        self.dbs.remoteExec(arg)
