# Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>
# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>


from qt import Qt, QT_TRANSLATE_NOOP

# Config stuff for the scanner window
ConfigScannerFont = 'courier'
ConfigScannerFontSize = 12
ConfigScannerTabStop = 8
ConfigScannerColorKeyword = Qt.darkGreen
ConfigScannerColorName = Qt.darkRed
ConfigScannerColorComment = Qt.darkMagenta
ConfigScannerColorString = Qt.darkBlue
ConfigScannerColorDefault = Qt.black
ConfigScannerColorCurrentLine = Qt.yellow
ConfigScannerColorErrorLine = Qt.red

# Variables type definition
ConfigVarTypeDispStrings = [
        QT_TRANSLATE_NOOP('Variable Types', 'Hidden Attributes'), \
        QT_TRANSLATE_NOOP('Variable Types', 'None'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Type'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Integer'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Long Integer'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Float'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Complex'), \
        QT_TRANSLATE_NOOP('Variable Types', 'String'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Unicode String'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Tuple'), \
        QT_TRANSLATE_NOOP('Variable Types', 'List'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Dictionary'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Dictionary Proxy'), \
        QT_TRANSLATE_NOOP('Variable Types', 'File'), \
        QT_TRANSLATE_NOOP('Variable Types', 'X Range'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Slice'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Buffer'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Class'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Class Instance'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Class Method'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Class Property'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Generator'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Function'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Builtin Function'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Code'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Module'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Ellipsis'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Traceback'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Frame'), \
        QT_TRANSLATE_NOOP('Variable Types', 'Other')]
ConfigVarTypeStrings = ['__', 'NoneType', 'type',\
        'int', 'long', 'float', 'complex',\
        'str', 'unicode', 'tuple', 'list',\
        'dict', 'dict-proxy', 'file', 'xrange',\
        'slice', 'buffer', 'class', 'instance',\
        'instance method', 'property', 'generator',\
        'function', 'builtin_function_or_method', 'code', 'module',\
        'ellipsis', 'traceback', 'frame', 'other']
ConfigVarDefaultFilter = [0,1,2,17,19,20,21,22,23,24,25,26,27,28,29]
ConfigVarEditable = [3,4,5,6,7,8,9,10,11]

# Config stuff for the remote debugger
RemoteDebuggerEnabled = 0
RemoteDebuggerHost = '<hostname of remote client>'
RemoteExecution = '<path to the remote login executable>'

# Config stuff for the language of the UI
#ConfigUILanguage = 'de'
ConfigUILanguage = None    # use this in order to dynamically detect locale settings