# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>


from qt import *

from Info import *
from BreakpointForm import BreakpointForm


class BreakpointDialog(BreakpointForm):
    def __init__(self,parent = None,name = None,modal = 0,fl = 0,fn = None):
        BreakpointForm.__init__(self,parent,name,modal,fl)

        if fn:
            self.setCaption(self.trUtf8('%1 - Breakpoints of %2')
                .arg(Program)
                .arg(fn))
        else:
            self.setCaption(self.trUtf8('%1 - All Breakpoints')
                .arg(Program))

        if not fn:
            self.bpListview.addColumn(self.trUtf8("Filename"))
        self.bpListview.addColumn(self.trUtf8(" # "))
        self.bpListview.addColumn(self.trUtf8("Condition"))
        self.bpListview.setSelectionMode(QListView.Extended)
        self.bpListview.setSorting(0)
        
        self.filename = fn
        
        # populate the listbox
        if fn:
            bpList = self.parent().dbs.getFileBreakpoints(fn)
            for (lineno, cond) in bpList:
                QListViewItem(self.bpListview, str(lineno), cond)
        else:
            bpList = self.parent().dbs.getAllBreakpoints()
            for (fname, lineno, cond) in bpList:
                QListViewItem(self.bpListview, fname, str(lineno), cond)
                
        self.currItem = None
        self.condHistory = QStringList()
        
        # create the popup menu
        self.menu = QPopupMenu(self)
        self.menu.insertItem(self.trUtf8('Change condition...'), self.handleChangeCondition)
        self.menu.insertItem(self.trUtf8('Delete breakpoint'), self.handleDeleteSingle)

    def handleDeleteAll(self):
        """
        Private slot to delete all breakpoints listed of the listview.
        """
        item = self.bpListview.firstChild()
        
        while item:
            if self.filename:
                fn = self.filename
                line = int(str(item.text(0)))
            else:
                fn = item.text(0)
                line = int(str(item.text(1)))
            scn = self.parent().getScanner(fn)
            # we simulate a button press in the breakpoint column 
            # of the source window
            scn.handleBreakpoint(line, Qt.LeftButton)
            self.bpListview.takeItem(item)
            del item
            item = self.bpListview.firstChild()

    def handleDeleteSelected(self):
        """
        Private slot to delete the selected breakpoints of the listview.
        """
        item = self.bpListview.firstChild()
        
        while item:
            if item.isSelected():
                if self.filename:
                    fn = self.filename
                    line = int(str(item.text(0)))
                else:
                    fn = item.text(0)
                    line = int(str(item.text(1)))
                scn = self.parent().getScanner(fn)
                # we simulate a button press in the breakpoint column 
                # of the source window
                scn.handleBreakpoint(line, Qt.LeftButton)
                olditem = item
                item = olditem.itemBelow()
                self.bpListview.takeItem(olditem)
                del olditem
            else:
                item = item.itemBelow()

    def handleDeleteSingle(self):
        """
        Private slot to delete a single breakpoint.
        """
        if self.currItem:
            if self.filename:
                fn = self.filename
                line = int(str(self.currItem.text(0)))
            else:
                fn = self.currItem.text(0)
                line = int(str(self.currItem.text(1)))
            scn = self.parent().getScanner(fn)
            # we simulate a button press in the breakpoint column 
            # of the source window
            scn.handleBreakpoint(line, Qt.LeftButton)
            self.bpListview.takeItem(self.currItem)
            del self.currItem
            self.currItem = None
        
    def handleChangeCondition(self):
        """
        Private slot to change the condition of the selected breakpoint.
        """
        if self.currItem:
            if self.filename:
                fn = self.filename
                line = int(str(self.currItem.text(0)))
                cond = self.currItem.text(1)
            else:
                fn = self.currItem.text(0)
                line = int(str(self.currItem.text(1)))
                cond = self.currItem.text(2)
                
            if cond == None:
                cond = ''
            curr = self.condHistory.findIndex(cond)
            if curr == -1:
                self.condHistory.prepend(cond)
                curr = 0
                    
            cond, ok = QInputDialog.getItem(
                            self.trUtf8('Breakpoint'),
                            self.trUtf8('Enter condition for breakpoint'),
                            self.condHistory, curr, 1)
                                
            if not ok:
                self.currItem = None
                return
                
            scn = self.parent().getScanner(fn)
            # we simulate a button press in the breakpoint column 
            # of the source window
            scn.handleBreakpoint(line, Qt.RightButton, cond)
            
            if self.filename:
                self.currItem.setText(1, cond)
            else:
                self.currItem.setText(2, cond)
            self.currItem = None
        
    def handleListContextmenu(self, item, pos, col):
        """
        Private slot to show the context menu of the listview.
        """
        if item:
            self.currItem = item
            self.menu.popup(pos)
