"""
    DrawableContour.py
    Contour and shade plot of 2D arrays 
        
"""

from PyDVT import __version__,__date__,__author__


import Tkinter
import pyqt_pl 
import mytkplplot
import Numeric
from Binding import Pen,Brush


class  Drawable_Contour(Tkinter.Frame):
    def __init__( self,parent=None,**kw):
       self.parent=parent
       Tkinter.Frame.__init__(self,parent,**kw)
       self.parent.Show()
       self.grid(row=0,col=0,sticky="nsew")
       self.qpl=  mytkplplot.MyTkplplot(self,back_color=( 0xFF, 0xFF, 0xFF ))

          
       self.GraphicObjects=[]        
              
       self.init=1
       self.style="Contour"
       self.Gridlines=0
       self.ContourLevels=8
       self.ShadeLevels=8
       self.ShadeColormap="Grayscale"
       self.ContourLabels=0
       self.opt=1
       self.log=0
       self.functions={}
       self.SetDrawPos(0.12, 0.88, 0.12, 0.88)      
       self.SetEnv(0,1000,0,1000,0,1000)
    
       self.TitleLabel=self.XLabel=self.YLabel=""


        
    def Show(self):
        self.qpl.pack(expand=Tkinter.YES, fill=Tkinter.BOTH)


    def RemoveFunction(self,name=None):
        if name==None:
            self.functions={}
        else:
            if name in self.functions.keys():  del self.functions[name]
            
    def SetFunction(self,name,function_pars):
        self.functions[name]=function_pars
              
    def SetFunctionItem(self,name,item,val):
        if name in self.functions.keys():
            self.functions[name][item]=val

    def SetLabels(self,title_label="",x_label="",y_label=""):
        self.TitleLabel,self.XLabel,self.YLabel=title_label,x_label,y_label

    def SetEnv(self,xmin,xmax,ymin,ymax,zmin=None,zmax=None):   
       (self.xmin,self.xmax,self.ymin,self.ymax,self.zmin,self.zmax)=(xmin,xmax,ymin,ymax,zmin,zmax)
  
    def SetStyle(self,style):
      if style != self.style:
         self.style=style
         self._Refresh()

    def SetContourLevels(self,levels):
        if self.ContourLevels!=levels:
            self.ContourLevels=levels
            self._Refresh()

    def SetContourLabels(self,labels):
        if self.ContourLabels!=labels:
            self.ContourLabels=labels
            self._Refresh()
        

    def SetShadeLevels(self,levels):
        if self.ShadeLevels!=levels:
            self.ShadeLevels=levels
            self._Refresh()


    def SetShadeColormap(self,colormap):
        if self.ShadeColormap!=colormap:
            self.ShadeColormap=colormap
            self._Refresh()

    def SetDrawPos(self,xmin,xmax,ymin,ymax):
       self.xposmin,self.xposmax,self.yposmin,self.yposmax=xmin,xmax,ymin,ymax


    def ToggleGridlines(self):
        if self.Gridlines: self.Gridlines=0
        else: self.Gridlines=1
        self._Refresh()
                  
    def Linear( self ):
      if self.log:
         self.log=0
         self._Refresh()

    def Log( self ):
      if self.log==0:
         self.log=1
         self._Refresh()




    def Redraw(self):
        #self.GraphicObjects=[]        
        self._Refresh()

    def _DrawFunctions(self,modpl):
         modpl.pladv(0)                  
         
         modpl.plvpor(self.xposmin,self.xposmax,self.yposmin,self.yposmax)
         
         for function in  self.functions.values():
            func=function["data"].flat            
            if len(func):
                minval=min(func)
                maxval=max(func)
                if self.log:
                   func=(function["data"])            
                   if minval<=0:
                       minval=0.000001
                       func=Numeric.maximum(func,minval)
                   if maxval<=minval: maxval=minval+0.00001
                   minval,maxval=Numeric.log10(minval),Numeric.log10(maxval)
                   func=Numeric.log10(func)
                else:
                   if self.zmin!=None: minval=self.zmin
                   if self.zmax!=None: maxval=self.zmax
                   if minval==maxval:
                       maxval=maxval+0.000001
                   func=function["data"]
                
                pen=function["pen"]
                modpl.plwind(self.xmin,self.xmax,self.ymin,self.ymax)
                
                xg0=function["xdata"]
                yg0=function["ydata"]
            
                if self.style=="Shade" or self.style=="Both":
                    sh_cmap = 1;min_color = 1; min_width = 0; max_color = 0; max_width = 0

                    if self.ShadeColormap =="Color": self.qpl.set_cmap1_color(modpl)
                    elif self.ShadeColormap =="Temperature": self.qpl.set_cmap1_temp(modpl)
                    elif self.ShadeColormap =="Red": self.qpl.set_cmap1_rgb(modpl,(255,0,0))
                    elif self.ShadeColormap =="Green": self.qpl.set_cmap1_rgb(modpl,(0,255,0))
                    elif self.ShadeColormap =="Blue": self.qpl.set_cmap1_rgb(modpl,(0,0,255))
                    elif self.ShadeColormap =="RevGrey": self.qpl.set_cmap1_rgb(modpl,(255,255,255),reverse=1)
                    else:self.qpl.set_cmap1_rgb(modpl,(255,255,255))

                    for i in range(self.ShadeLevels):
                        shade_min = minval + float(maxval - minval) * i / self.ShadeLevels
                        shade_max = minval + float(maxval - minval) * (i+1) / self.ShadeLevels
                        sh_color = i/(self.ShadeLevels-1.)
                        sh_width = 2
                        modpl.plpsty(0)

                        modpl.plshade( Numeric.transpose(func), self.xmin,self.xmax,self.ymin,self.ymax,
                               shade_min, shade_max, sh_cmap, sh_color, sh_width,
                               min_color, min_width, max_color, max_width, 1 ,'pltr1', xg0, yg0  )

                if (self.style=="Contour" or self.style=="Both") and pen.style!="hidden":
                    clevelcontour = minval + (maxval - minval) * (Numeric.arrayrange(self.ContourLevels).astype('f'))/self.ContourLevels
                    if self.ContourLabels:
                        modpl.pl_setcontlabelparam(0.006, 0.5, 0.2, 1) #offset, size, spacing, &active
                    else:
                        modpl.pl_setcontlabelparam(0.006, 0.5, 0.2, 0) #offset, size, spacing, &active
                    modpl.pllsty(self.GetStyle(pen.style))
                    modpl.plwid(pen.width)
                    modpl.plrgb1(pen.color[0],pen.color[1],pen.color[2])
                
                    modpl.plcont( Numeric.transpose(func), clevelcontour, "pltr1", xg0, yg0, 0 )

                    modpl.plwind(self.xmin,self.xmax,self.ymin,self.ymax)
                    modpl.pllsty(1)
                    modpl.plwid(0)                
        
    def _DrawEnv(self,modpl):
        modpl.plrgb1(0,0,0)
        modpl.plwind(self.xmin,self.xmax,self.ymin,self.ymax)
        if self.Gridlines:
            modpl.plbox( "bcgnst", 0., 0, "bcgnstv", 0., 0 )
        else:
            modpl.plbox( "bcnst", 0., 0, "bcnstv", 0., 0 )
        #modpl.pllab( self.XLabel,self.YLabel, self.TitleLabel)
        if self.TitleLabel!="": modpl.plmtex("t", 3.0, 0.5, 0.5, self.TitleLabel)
        if self.XLabel!="":     modpl.plmtex("b", 3.5, 0.5, 0.5, self.XLabel)
        if self.YLabel!="":    modpl.plmtex("l", 5.0, 0.5, 0.5, self.YLabel)


    def _Refresh(self):
         self.qpl.InitDrawing()
         self._DrawFunctions(pyqt_pl)
         self._DrawEnv(pyqt_pl)
         self.qpl.EndDrawing()

    def GetStyle(self,style):
            if   style=="solid":    return 1
            elif style=="dashed":   return 3
            elif style=="dotted":   return 2
            else:                   return 1         

    def Destroy(self):
        self.parent=None
        self.qpl=  None
        self.functions={}
        self.GraphicObjects=[]        


    def Save(self,filename,format="BMP"):        
        import pl
        pl.plsdev("psc")
        pl.plsfnam(filename)
        pl.plscolbg(self.qpl.back_color[0],self.qpl.back_color[1],self.qpl.back_color[2])        
        pl.plinit()
        self._DrawFunctions(pl)
        self._DrawEnv(pl)
        pl.plend()
        if format=="PS": return
        if format=="JPG": format="JPEG"
        else:
            try:
                import Image
                pilim=Image.open(filename).transpose(Image.ROTATE_270)
                pilim.save(filename,format)
            except:
                import os
                try: os.remove(tmpfile)
                except: pass
                return 0
                     
    def _RightButtonPress(self,event):
        if self.parent is not None: self.parent._RightButtonPress(event)

    def _LeftButtonPress(self, e):
        pass

    def _LeftButtonRelease(self, e):
        pass
            
    def _Motion(self, e):
        pass

    def _PressMotion(self,e):
        pass

    def _DoubleClick(self, e):
        pass
		
    def _KeyPress(self,e):
        pass
