!********1*********2*********3*********4*********5*********6*********7*********8
                                                                                
!  ****************************
!  *                          *
!  * hst_calculate_limits.f90 *
!  *                          *
!  ****************************
                               
!+ CALCULATE LIMITS of the region worth reconstructing
     Subroutine HST_CALCULATE_LIMITS (num_bins, start_x, start_y, &
       num_x, num_y, axis_position, y_start, y_end, X_STARTS, X_ENDS, status)
!  Description:
!    Set limits of smaller circle or rectangle which is to be reconstructed
!  Method:
!  Deficiencies:
!  Bugs:
!    None
!  Authors:
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    08-Jul-1999: V0.1 Original (HAMMERSLEY)
!    16-Feb-2000: V0.2 Correct problem, that an inner rectangle was being
!      further reduced by 2 pixels along each borrder (HAMMERSLEY)
!  Modules:
!     Use IO_LIB
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc' ! Status system constants
!  Import:
     Integer, Intent(IN) :: num_bins ! Number of bins in each sinogram
     Integer, Intent(IN) :: start_x ! First X-pixel in region required by user
     Integer, Intent(IN) :: start_y ! First Y-pixel in region required by user
     Integer, Intent(IN) :: num_x ! Number of X-pixels in reconstruction region
     Integer, Intent(IN) :: num_y ! Number of Y-pixels in reconstruction region
     Real, Intent(IN) :: axis_position ! Position of rotation axis
!  Export:
     Integer, Intent(OUT) :: y_start ! First Y-row in region to reconstruct
     Integer, Intent(OUT) :: y_end ! Last Y-row in region to reconstruct
     Integer, Intent(OUT), Dimension(num_bins) :: X_STARTS ! First pixel to
!      reconstruct of each row
     Integer, Intent(OUT), Dimension(num_bins) :: X_ENDS ! Last pixel to
!      reconstruct of each row
!  Status:
     Integer, Intent(INOUT) :: status ! Status return variable
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      program
!  Local Variables:
     Integer :: y ! Loop variable for Y-direction
     Real :: radius ! The radius of region to reconstruct
     Real :: radius_squared ! The square of 'radius'
     Real :: x_diff ! X-difference for points on circle
!  Local Arrays:
!--------1---------2---------3---------4---------5---------6---------7---------8
!     Write (*, '(''Entered HST_CALCULATE_LIMITS'')')
                                                     
!  Check status
!     If (status .Ne. St_goodvalue) Then
!        Call ST_SAVE ('Subroutine HST_CALCULATE_LIMITS ' // Version)
!        Return
!     End If
           
!  Calculate radius of maximum region to reconstruct, and square it
     radius = Min(axis_position - 0.501, Real(num_bins) - axis_position - 0.501)
     radius_squared = radius**2
                               
!  Calculate start and end pixels of projection
     y_start = Max(1, Int(axis_position - radius) + 2 - start_y + 1)
     y_end = Min(num_y, Int(axis_position + radius) - 2 - start_y + 1)
                                                                      
     Do y = y_start, y_end
        x_diff = Sqrt(radius_squared - &
          (Real(y) + start_y - 1.5 - axis_position)**2)
        X_STARTS(y) = Max(1, Int(axis_position - x_diff) + 2 - start_x + 1)
        X_ENDS(y) = Min(num_x, &
          Int(axis_position + x_diff) - 2 - start_x + 1)
     End Do
           
     End Subroutine HST_CALCULATE_LIMITS
!********1*********2*********3*********4*********5*********6*********7*********8
                                                                                
                                                                                
                                                                                
                                                                                
                                                                                
                                                                                
                                                                                
                                                                                
