/* Vhst_calculate_limits.f -- translated by f2c (version 20000121).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ********1*********2*********3*********4*********5*********6*********7*********8 */
/*  **************************** */
/*  *                          * */
/*  * hst_calculate_limits.f90 * */
/*  *                          * */
/*  **************************** */
/* + CALCULATE LIMITS of the region worth reconstructing */
/* Subroutine */ int hst_calculate_limits__(num_bins__, start_x__, start_y__, 
	num_x__, num_y__, axis_position__, y_start__, y_end__, x_starts__, 
	x_ends__, status)
integer *num_bins__, *start_x__, *start_y__, *num_x__, *num_y__;
real *axis_position__;
integer *y_start__, *y_end__, *x_starts__, *x_ends__, *status;
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer y;
    static real x_diff__, radius, radius_squared__;

/*  Description: */
/*    Set limits of smaller circle or rectangle which is to be reconstructed */
/*  Method: */
/*  Deficiencies: */
/*  Bugs: */
/*    None */
/*  Authors: */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    08-Jul-1999: V0.1 Original (HAMMERSLEY) */
/*    16-Feb-2000: V0.2 Correct problem, that an inner rectangle was being */
/*      further reduced by 2 pixels along each borrder (HAMMERSLEY) */
/*  Modules: */
/*     Use IO_LIB */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' ! Status system constants */
/*  Import: */
/* Number of bins in each sinogram */
/* First X-pixel in region required by user */
/* First Y-pixel in region required by user */
/* Number of X-pixels in reconstruction region */
/* Number of Y-pixels in reconstruction region */
/*  Export: */
/* Position of rotation axis */
/* First Y-row in region to reconstruct */
/* Last Y-row in region to reconstruct */
/*      reconstruct of each row */
/* First pixel to */
/*      reconstruct of each row */
/*  Status: */
/* Last pixel to */
/*  Local Constants: */
/* Status return variable */
/* Version number for */
/*      program */
/*  Local Variables: */
/* Loop variable for Y-direction */
/* The radius of region to reconstruct */
/* The square of 'radius' */
/*  Local Arrays: */
/* --------1---------2---------3---------4---------5---------6---------7---------8 */
/*     Write (*, '(''Entered HST_CALCULATE_LIMITS'')') */
/*  Check status */
/*     If (status .Ne. St_goodvalue) Then */
/*        Call ST_SAVE ('Subroutine HST_CALCULATE_LIMITS ' // Version) */
/*        Return */
/*     End If */
/*  Calculate radius of maximum region to reconstruct, and square it */
/* X-difference for points on circle */
    /* Parameter adjustments */
    --x_ends__;
    --x_starts__;

    /* Function Body */
/* Computing MIN */
    r__1 = *axis_position__ - (float).501, r__2 = (real) (*num_bins__) - *
	    axis_position__ - (float).501;
    radius = dmin(r__1,r__2);
/* Computing 2nd power */
    r__1 = radius;
    radius_squared__ = r__1 * r__1;
/*  Calculate start and end pixels of projection */
/* Computing MAX */
    i__1 = 1, i__2 = (integer) (*axis_position__ - radius) + 2 - *start_y__ + 
	    1;
    *y_start__ = max(i__1,i__2);
/* Computing MIN */
    i__1 = *num_y__, i__2 = (integer) (*axis_position__ + radius) - 2 - *
	    start_y__ + 1;
    *y_end__ = min(i__1,i__2);
    i__1 = *y_end__;
    for (y = *y_start__; y <= i__1; ++y) {
/* Computing 2nd power */
	r__1 = (real) y + *start_y__ - (float)1.5 - *axis_position__;
	x_diff__ = sqrt(radius_squared__ - r__1 * r__1);
/* Computing MAX */
	i__2 = 1, i__3 = (integer) (*axis_position__ - x_diff__) + 2 - *
		start_x__ + 1;
	x_starts__[y] = max(i__2,i__3);
/* Computing MIN */
	i__2 = *num_x__, i__3 = (integer) (*axis_position__ + x_diff__) - 2 - 
		*start_x__ + 1;
	x_ends__[y] = min(i__2,i__3);
    }
} /* hst_calculate_limits__ */

