import mpi
import os
import sys
import string
import my_EdfFile
import Numeric
import math
from  copy import copy
import INSTALLATION

EdfFile=my_EdfFile
DEG2RAD=math.pi/180.0


reader_proc_1 = 0
reader_proc_2 = 1
semaphore_proc = 2
drain_proc = 3
firstslave_proc = 4





DEBUGGA=0

sys.path=[ '%s/scisoft/ESRF_sw/linux_i386/PACKAGES/PyHST/SOURCES/' %  INSTALLATION.homedir ] + sys.path
def add_quotes(s):
    pos=string.find(s,"=")
    if(pos==-1): return s
    pos=pos+1
    new_s=s[:pos+1]
    toggle=0
    while(pos<len(s) and s[pos]==" "):
        pos=pos+1
    if(pos==len(s)):
        return s
    new_s=new_s+"\""
    while(pos<len(s) and s[pos]!=" "):
        new_s=new_s+s[pos]
        pos=pos+1
    new_s=new_s+"\""
    return new_s
    
    
def treat_par_file(s):
    """
      pythonify the old format (fortran)
      input file given as a string s
    """
    print "PYTHONIFYING INPUT FILE"
    s=string.replace(s,"!","#")
    lines=string.split(s,"\n")
    new_lines=""
    for line in lines:
        if( string.find(line,"FILE ")>=0 or string.find(line,"FILE=")>=0):
            line=add_quotes(line)
        elif( string.find(line,"PREFIX")>=0):
             line=add_quotes(line)
        elif( string.find(line,"POSTFIX")>=0):
             line=add_quotes(line)
        new_lines=new_lines+"\n"+line
    # try to execute the input file
    print "CHECKING INPUTFILE FOR EXECUTION"
    try:
       NO =0
       YES=1       
       new_lines= string.replace(new_lines, "\"N.A.\"", "\"N_A_\"")
       new_lines= string.replace(new_lines, "N.A.", "\"N_A_\"")
       exec(new_lines)
    except:
       print new_lines
       raise " something went wrong interpreting input file " 
    print "INPUT FILE IS GOOD FOR ME"
    return new_lines




def initialise_Loop_Data(Parameters):
  ########################################################################################################  #    
  # determine how many slice to read at once
  # --------------------------------------------
  Parameters.nsinos = (Parameters.NUM_LAST_IMAGE - Parameters.NUM_FIRST_IMAGE+1)

  if(Parameters.ROTATION_VERTICAL):
      Parameters.nslices_atonce = Parameters.SINOGRAM_MEGABYTES*1.0e6/(
                             Parameters.NUM_IMAGE_1 *Parameters.nsinos  *4  )
  else:
      Parameters.nslices_atonce = Parameters.SINOGRAM_MEGABYTES*1.0e6/(
                             Parameters.NUM_IMAGE_2 *Parameters.nsinos) 

  Parameters.nslices_atonce = int(Parameters.nslices_atonce)

  # =======================================================================================================

  ###############################################################################
  # How many slices we want in total
  # ----------------------------------------------------------------------------

  Parameters.tot_slices = Parameters.END_VOXEL_3 - Parameters.START_VOXEL_3 + 1

  # ///////////////////////////////////////////////////////////////////////////////////////////////////////////////


  #########################################################################################
  # read and store the BACKGROUND in variable background fully dimensioned
  # -------------------------------------------------------------------------------------
  if(Parameters.SUBTRACT_BACKGROUND):
     print " reading edf file for background ", Parameters.BACKGROUND_FILE
     dark=EdfFile.EdfFile(Parameters.BACKGROUND_FILE)
     background=dark.GetData(0,DataType="FloatValue")
  else:
    background=Numeric.zeros([ Parameters.NUM_IMAGE_2, Parameters.NUM_IMAGE_1 ],"f")

  if(Parameters.ROTATION_VERTICAL==0):
      background=Numeric.transpose(background)

  # ////////////////////////////////////////////////////////////////////////////////////////////



  ###############################################################################################
  # create the big array to contain sinograms
  # --------------------------------------------------------------------------------------------
  #
  if(Parameters.ROTATION_VERTICAL==0):
    dim_1 = Parameters.NUM_IMAGE_2
    dim_2 = Parameters.nsinos
    dim_3 = Parameters.nslices_atonce
  
  if(Parameters.ROTATION_VERTICAL==1):
    dim_1 = Parameters.NUM_IMAGE_1
    dim_2 = Parameters.nsinos
    dim_3 = Parameters.nslices_atonce
  #
  # >>>>>>>>>>>>>>>> the BIG thing <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
  BIG_SINOS = Numeric.zeros( [dim_3,dim_2,dim_1],"f" )  
  #
  #
  #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  # another reference to access the BIG thing with a different scheme
  # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
  BIG_SINOS_natural_ordering  = Numeric.swapaxes(BIG_SINOS ,0,1)
  # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
  # **********************************************************************

  # ///////////////////////////////////////////////////////////////////////////////////

  ########################################################################################
  # How many angular steps we must integrate
  # -----------------------------------------------------------------------------------------
  num_projections=  Parameters.NUM_LAST_IMAGE+1-Parameters.NUM_FIRST_IMAGE
  # ///////////////////////////////////////////////////////////////////////////////////////


  #################################################################################################
  # constant to normalise the result
  # -----------------------------------------------------------------------------------------------
  if (Parameters.ROTATION_VERTICAL):
          normalise = Numeric.array([(math.pi / 2.0) * (1.0 / num_projections) *   (1.0e6*0.01 / Parameters.IMAGE_PIXEL_SIZE_1)],"f")
  else:
          normalise = Numeric.array([(math.pi / 2.0) * (1.0 / num_projections) *   (1.0e6*0.01 / Parameters.IMAGE_PIXEL_SIZE_2)],"f")
  # //////////////////////////////////////////////////////////////////////////////////////////////////////////

  return (normalise, num_projections,
	 BIG_SINOS_natural_ordering , BIG_SINOS ,
	 dim_1, dim_2, dim_3, background, dark)



def CALL_SLAVES(first_slice,  last_slice , dim_1 , num_projections, BIG_SINOS):

    # wait for the green light from the semaphore process

    go, status = mpi.recv( semaphore_proc, mpi.ANY_TAG  )

    # calculate slices from first_slice up to last_slice

    for i in range(first_slice,  last_slice+1):

       # semaphore process tells which is the recipient 

       who_is_libre , status = mpi.recv( semaphore_proc , mpi.ANY_TAG)

       if(DEBUGGA): print who_is_libre, " e libero "

       mpi.send( i                        ,  who_is_libre )
       mpi.send( dim_1                    ,  who_is_libre )
       mpi.send( num_projections          ,  who_is_libre )
       if(DEBUGGA): print " mando la fetta a un libero "
       mpi.sendString( (BIG_SINOS[i-first_slice]).tostring() ,  who_is_libre )
       if(DEBUGGA): print " ho mandato la fetta al libero"



def READ_CHUNCK( Parameters, i_pass,  BIG_SINOS_natural_ordering  ):
    
    first_slice = i_pass * Parameters.nslices_atonce + Parameters.START_VOXEL_3 -1
    last_slice  = min(first_slice + Parameters.nslices_atonce-1, Parameters.END_VOXEL_3-1) 

    print " processing slice ", first_slice+1," up to (included) " , last_slice+1

    ######################################################################
    # pos_edf and size_edf are passed to the Gobbo's EdfFile routine
    # to extract the interesting part of the edf images
    # -------------------------------------------------------------------

    if(Parameters.ROTATION_VERTICAL==1):
      pos_edf=   [first_slice,0]
      size_edf = [last_slice-first_slice+1, Parameters.NUM_IMAGE_1 ]

    if(Parameters.ROTATION_VERTICAL==0):
      pos_edf=   [0,first_slice]
      size_edf = [  Parameters.NUM_IMAGE_2, last_slice-first_slice+1      ]

    # ///////////////////////////////////////////////////////////////////////

    ################################################################################
    # the background that is going to be used for the interesting part
    # ------------------------------------------------------------------------------
    #
    new_background = background[first_slice:last_slice+1]
  
    # /////////////////////////////////////////////////////////////////////////////  


    #################################################################################
    # ipro is an index running over the  projection edf-images
    # It can be used directly to access the files by postpending it to the file prefix
    # -------------------------------------------------------------------------------
    for i_pro in range(Parameters.NUM_FIRST_IMAGE, Parameters.NUM_LAST_IMAGE+1,1):

      if(( i_pro- Parameters.NUM_FIRST_IMAGE)%100 ==0 ):
        print " READING projection # ", i_pro- Parameters.NUM_FIRST_IMAGE, " of ",  Parameters.NUM_LAST_IMAGE+1-Parameters.NUM_FIRST_IMAGE

      if(Parameters.CORRECT_FLATFIELD):
        if( Parameters.FLATFIELD_CHANGING):
          i_FF=( (i_pro - Parameters.NUM_FIRST_IMAGE  )   %Parameters.FF_FILE_INTERVAL)
          if( i_FF==0 ):

            ########################################################
            # convert ipro to the index for the FF
            # ------------------------------------------------------------
            nFF=i_pro - Parameters.NUM_FIRST_IMAGE + Parameters.FF_NUM_FIRST_IMAGE
            nFF = min(nFF,  Parameters.FF_NUM_LAST_IMAGE)
            # ////////////////////////////////////////////////////////////////
            ############################################################
            #   read the fisrt  FF of the interpolation range
            # -----------------------------------------------------------
            FF_a = extract_edf_N(Parameters.FF_PREFIX, nFF,
                               Parameters.FF_NUMBER_LENGTH_VARIES,
                               Parameters.FF_LENGTH_OF_NUMERICAL_PART,
                               Parameters.FF_POSTFIX,
                               Parameters.ROTATION_VERTICAL, 
                               pos_edf, size_edf)
            # ////////////////////////////////////////////////////////////
            FF_b = FF_a
          if( i_FF==1 ):
            ########################################################
            # convert ipro to the index for the FF
            # ------------------------------------------------------------
            nFF = i_pro-1 - Parameters.NUM_FIRST_IMAGE + Parameters.FF_NUM_FIRST_IMAGE+ Parameters.FF_FILE_INTERVAL  
            nFF = min(nFF,  Parameters.FF_NUM_LAST_IMAGE)
            # ////////////////////////////////////////////////////////////////
            ############################################################
            # read the second  FF of the interpolation range
            # -----------------------------------------------------------
            FF_b = extract_edf_N(Parameters.FF_PREFIX,
                           nFF ,
                               Parameters.FF_NUMBER_LENGTH_VARIES,
                               Parameters.FF_LENGTH_OF_NUMERICAL_PART,
                               Parameters.FF_POSTFIX,
                               Parameters.ROTATION_VERTICAL, 
                               pos_edf, size_edf)
             # ////////////////////////////////////////////////////////////
                           
          ##########################################################################
          # linear interpolation
          # ------------------------------------------------------------------------
          FF = ( FF_a*Numeric.array([Parameters.FF_FILE_INTERVAL-i_FF]).astype("f") +
                 FF_b *Numeric.array([i_FF]).astype("f")  )/Numeric.array([Parameters.FF_FILE_INTERVAL]    ).astype("f")
          # /////////////////////////////////////////////////////////////////////////////////////////////////////////////
        else:
            if(ipro==Parameters.NUM_FIRST_IMAGE):
               ###################################################
               # read at the beginning of the scan the only
               # FF available
               # -------------------------------------------------
               FF = extract_edf(Parameters.FLATFIELD_FILE,
                                 Parameters.ROTATION_VERTICAL, 
                                 pos_edf, size_edf)
               # /////////////////////////////////////////////////

        if( Parameters.SUBTRACT_BACKGROUND):
          newFF = FF - new_background
        else:
          newFF = FF

        # clipping newFF 
        newFF=Numeric.maximum(newFF,Numeric.array([0.1],"f") )
      
      newitem =  extract_edf_N(Parameters.FILE_PREFIX,
                           i_pro,
                           Parameters.NUMBER_LENGTH_VARIES,
                           Parameters.LENGTH_OF_NUMERICAL_PART,
                           Parameters.FILE_POSTFIX,
                           Parameters.ROTATION_VERTICAL , 
                           pos_edf, size_edf )

      if( Parameters.SUBTRACT_BACKGROUND):
          newitem = newitem - new_background

        
      # clipping  newitem 
      newitem=Numeric.maximum(newitem,Numeric.array([1.0e-9],"f") )

      if( Parameters.CORRECT_FLATFIELD):
        newitem =  newitem/newFF 

      if( Parameters.TAKE_LOGARITHM):
        newitem = -Numeric.log( newitem) 

      newitem=newitem*normalise

      # throwing new data into the BIG thing

      throw_start=first_slice -Parameters.START_VOXEL_3 +1
      throw_end  =last_slice  -Parameters.START_VOXEL_3 +1

      BIG_SINOS_natural_ordering[i_pro-Parameters.NUM_FIRST_IMAGE , 0:throw_end+1-throw_start] = newitem
      


def master_LOOP( Parameters, normalise, num_projections,
                 BIG_SINOS_natural_ordering, BIG_SINOS , 
                 dim_1, dim_2, dim_3, background, dark):

  #######################################################################################
  # SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
  #
  # start the loop over memory bunches
  #
  # --------------------------------------------------------------------------------------

  ###########################################################################################
  #
  # HOW many passes, reading a maximum of nslices_atonce slices each time, we have to perform
  # 
  tot_passes = int(Parameters.tot_slices*1.0/ Parameters.nslices_atonce +0.9999999999999 ) 
  # --------------------------------------------------------------------------------------

  #####################################3
  # read the first chunck
  #
  i_pass=0
  
  for i_pass in range( mpi.rank, tot_passes , 2 ): 

    print " pass ", i_pass, " of ", tot_passes

    first_slice = i_pass * Parameters.nslices_atonce + Parameters.START_VOXEL_3 -1
    last_slice  = min(first_slice + Parameters.nslices_atonce-1, Parameters.END_VOXEL_3-1) 

    if( first_slice > last_slice ) :
      raise " first_slice > last_slice  in master_LOOP "


    READ_CHUNCK( Parameters, i_pass,  BIG_SINOS_natural_ordering )
    CALL_SLAVES(first_slice,  last_slice , dim_1 , num_projections, BIG_SINOS )

    if(DEBUGGA): print " i_pass ", i_pass


def  drain_LOOP(Parameters):

  finished = 0
  file = open(Parameters.OUTPUT_FILE,"w")
  arrived={}
  firsttodo=Parameters.START_VOXEL_3 - 1

  while( finished != (mpi.size - firstslave_proc ) ):

     sender , status = mpi.recv(mpi.ANY_SOURCE,mpi.ANY_TAG)
     done   , status = mpi.recv( sender  ,mpi.ANY_TAG)
     if(DEBUGGA): print " ", sender , " has finished " , done
     
     if( done >=0):
       if(DEBUGGA): print " inizio a ricevere il risultato " 
       SLICE, status = mpi.recvString( sender  ,mpi.ANY_TAG)
       if(DEBUGGA): print " ho ricevuto il risultato "
       arrived[done]=SLICE
       
       while( firsttodo in arrived.keys() ):
          file.write( arrived[ firsttodo ]  ) 
          del arrived[ firsttodo ]
          firsttodo = firsttodo + 1

     else:
       finished = finished + 1
     if(DEBUGGA): print finished , " contro ", (mpi.size - firstslave_proc )
  file.close()


def semaphore_LOOP( Parameters ):

    old_emitting = -1
    for i in range( Parameters.tot_slices):

       emitting_process = int(  i / Parameters.nslices_atonce  ) % 2

       if(emitting_process <> old_emitting ):

           # send the green light to the emitter

           go=1
           mpi.send( go  , emitting_process )
           old_emitting=emitting_process 


       if(DEBUGGA): print " waiting for someone free "

       who_is_libre , status = mpi.recv(mpi.ANY_SOURCE,mpi.ANY_TAG)


       # tell the emitting process the recipient of the slice

       mpi.send( who_is_libre   ,  emitting_process )

    #################################
    ##  FINISH
    ##
    for i in range(firstslave_proc ,mpi.size):
       who_is_libre , status = mpi.recv(mpi.ANY_SOURCE,mpi.ANY_TAG)
       mpi.send(-1 ,  who_is_libre )






def extract_edf_N(prefix , n ,  lvaries, nlength, postfix, vertical , pos_edf, size_edf ):
    name=prefix
    if(lvaries):
        name=name+("%d"%n)+postfix
    else:
        number = "%d"%n
        number = ("0" *  (nlength-len(number)))+ number
        name=name+number+postfix
    return extract_edf(name , vertical    , pos_edf, size_edf    )
                  
def extract_edf(name , vertical  , pos_edf, size_edf      ):      
   ima=EdfFile.EdfFile(name)
   P=copy(pos_edf)
   S=copy(size_edf)
   P.reverse()
   S.reverse()
   image=ima.GetData(0,Pos=P, Size=S, DataType="FloatValue")
           
   if(vertical==0):
        image=Numeric.transpose(image)
   return image

import PyHST_c_F
PyHST_c=PyHST_c_F

# HOW MANY SLICES ??? 
filein = open(sys.argv[1],"r")
s=filein.read()
s=treat_par_file(s)


NO=0
YES=1
class Parameters:
    RECONSTRUCT_FROM_SINOGRAMS=0
    NO_SINOGRAM_FILTERING=0
    exec(s)

nslices =  Parameters.END_VOXEL_3 - Parameters.START_VOXEL_3 + 1



if(mpi.rank in [reader_proc_1  ,reader_proc_2  ]):

   if(DEBUGGA):  print " inizializzo LOOP "

   (normalise, num_projections,
	 BIG_SINOS_natural_ordering, BIG_SINOS,
	 dim_1, dim_2, dim_3, background, dark) = initialise_Loop_Data(Parameters)    

   if(DEBUGGA): print " ENTRO NEL MASTER LOOP "

   master_LOOP(  Parameters, normalise, num_projections,
		 BIG_SINOS_natural_ordering, BIG_SINOS,
	 	 dim_1, dim_2, dim_3, background, dark)

elif(mpi.rank in [semaphore_proc  ]):

   initialise_Loop_Data(Parameters) 
   semaphore_LOOP(  Parameters )

elif(mpi.rank in [ drain_proc  ]):
   drain_LOOP(Parameters)
else:

   todo=1
   if(DEBUGGA): print " SONO LO SCHIAVO ", mpi.rank

   SLICE = Numeric.zeros([ Parameters.END_VOXEL_1-Parameters.START_VOXEL_1+1,
	Parameters.END_VOXEL_2-Parameters.START_VOXEL_2+1  ]  , "f"   )

   while(todo>=0):
     mpi.send(mpi.rank, semaphore_proc )
     i , status  = mpi.recv(mpi.ANY_SOURCE ,mpi.ANY_TAG)
     todo = i
     if(todo<0):
         print " SLAVE PROCESS # ", mpi.rank , " HAS FINISHED HIS JOB " 
         mpi.send( mpi.rank                       ,  drain_proc )
         mpi.send(   todo                         ,  drain_proc )
         break

     dim_1 , status  = mpi.recv(mpi.ANY_SOURCE ,mpi.ANY_TAG)
     num_projections  , status  = mpi.recv( mpi.ANY_SOURCE ,mpi.ANY_TAG)
     SINOS_mpi_string , status  = mpi.recvString( mpi.ANY_SOURCE ,mpi.ANY_TAG)

     SINOS_mpi = Numeric.fromstring(SINOS_mpi_string ,  'f')

     OUTPUT_FILE = ""
     pyhst=PyHST_c.PyHST( OUTPUT_FILE  ,
                  Parameters.OVERSAMPLING_FACTOR,
                  Parameters.START_VOXEL_1-1 +1,
                  Parameters.START_VOXEL_2-1 +1,
                  Parameters.END_VOXEL_1-Parameters.START_VOXEL_1+1,
                  Parameters.END_VOXEL_2-Parameters.START_VOXEL_2+1,
                  Parameters.ROTATION_AXIS_POSITION,
                  Parameters.ANGLE_OFFSET*DEG2RAD,
                  Parameters.ANGLE_BETWEEN_PROJECTIONS*DEG2RAD,
				  Parameters.NO_SINOGRAM_FILTERING,
                  dim_1,
                  num_projections,
                  SINOS_mpi  )
     
     if(DEBUGGA): print " faccio la slice ", i
     
     pyhst.calcSlicesMemory(1,1, SLICE)

     mpi.send( mpi.rank                       ,  drain_proc )
     mpi.send(   todo                         ,  drain_proc )
     if(DEBUGGA): print " mando il risultato al drain"
     mpi.sendString( SLICE.tostring()                          ,  drain_proc )
     if(DEBUGGA): print " mandato risultato " 
     


print " process " , mpi.rank , " is exiting "








